package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.List;

/**
 * 分组内逻辑仓排序
 */
public class WhAutoAllotGroupWhSortVO implements Comparable<WhAutoAllotGroupWhSortVO>{

  private String warehouseCode;

  private Short priorityInGroup;

  private int planAllotQuantity;

  private int canUseQuantity;

  private int allotOnTheWayQunatity = 0;

  //一个分货逻辑仓对应多个 计算逻辑仓
  private List<WhAutoAllotCalculateWhVO> calculateWhList;

  public String getWarehouseCode() {
    return warehouseCode;
  }

  public void setWarehouseCode(String warehouseCode) {
    this.warehouseCode = warehouseCode;
  }

  public Short getPriorityInGroup() {
    return priorityInGroup;
  }

  public void setPriorityInGroup(Short priorityInGroup) {
    this.priorityInGroup = priorityInGroup;
  }

  public Integer getPlanAllotQuantity() {
    if (EmptyUtil.isEmpty(calculateWhList)) {
      return 0;
    }
    planAllotQuantity = 0;
    for (WhAutoAllotCalculateWhVO allotCalculateWhVO : calculateWhList) {
      planAllotQuantity += allotCalculateWhVO.getPlanAllotQuantity();
    }

    planAllotQuantity = planAllotQuantity - allotOnTheWayQunatity;
    return planAllotQuantity > 0 ? planAllotQuantity : 0;
  }

  public void setPlanAllotQuantity(Integer planAllotQuantity) {
    this.planAllotQuantity = planAllotQuantity;
  }

  public List<WhAutoAllotCalculateWhVO> getCalculateWhList() {
    return calculateWhList;
  }

  public void setCalculateWhList(List<WhAutoAllotCalculateWhVO> calculateWhList) {
    this.calculateWhList = calculateWhList;
  }

  public Integer getCanUseQuantity() {
    return canUseQuantity;
  }

  public void setCanUseQuantity(Integer canUseQuantity) {
    this.canUseQuantity = canUseQuantity;
  }

  @Override
  public int compareTo(WhAutoAllotGroupWhSortVO o) {
    return this.priorityInGroup - o.getPriorityInGroup();
  }

  public int getAllotOnTheWayQunatity() {
    return allotOnTheWayQunatity;
  }

  public void setAllotOnTheWayQunatity(int allotOnTheWayQunatity) {
    this.allotOnTheWayQunatity = allotOnTheWayQunatity;
  }
}
