package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.util.List;

public class WhAutoAllotGroupVO {

  private int planAllotQuantity;
  private String ownGroup;
  private int canUseQuantity;

  //一个分组内有多个分货逻辑仓
  private List<WhAutoAllotGroupWhSortVO> groupWhList;

  public Integer getPlanAllotQuantity() {
    if (EmptyUtil.isEmpty(groupWhList)) {
      return 0;
    }
    planAllotQuantity = 0;
    for (WhAutoAllotGroupWhSortVO allotGroup : groupWhList) {
      planAllotQuantity += allotGroup.getPlanAllotQuantity();
    }
    return planAllotQuantity;
  }

  public void setPlanAllotQuantity(Integer planAllotQuantity) {
    this.planAllotQuantity = planAllotQuantity;
  }

  public String getOwnGroup() {
    return ownGroup;
  }

  public void setOwnGroup(String ownGroup) {
    this.ownGroup = ownGroup;
  }

  public List<WhAutoAllotGroupWhSortVO> getGroupWhList() {
    return groupWhList;
  }

  public void setGroupWhList(List<WhAutoAllotGroupWhSortVO> groupWhList) {
    this.groupWhList = groupWhList;
  }

  public Integer getCanUseQuantity() {
    return canUseQuantity;
  }

  public void setCanUseQuantity(Integer canUseQuantity) {
    this.canUseQuantity = canUseQuantity;
  }

}
