package com.thebeastshop.pegasus.service.warehouse.vo;

import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Gary
 * @createtime 2018-08-13 10:38
 */
public class WhAllotStoreApplicationVO implements Serializable  {

  private static final long serialVersionUID = 5194625683148007325L;

  private Integer id;

  @NotNull(message = "门店不能为空！")
  private String channelCode;

  private Date applicationDate;

  private Long applicant;

  private Date updateTime;

  @Valid
  @NotEmpty(message = "SKU列表不能为空！")
  private List<WhAllotStoreApplicationSkuVO> skuList;

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getChannelCode() {
    return channelCode;
  }

  public void setChannelCode(String channelCode) {
    this.channelCode = channelCode;
  }

  public Date getApplicationDate() {
    return applicationDate;
  }

  public void setApplicationDate(Date applicationDate) {
    this.applicationDate = applicationDate;
  }

  public Long getApplicant() {
    return applicant;
  }

  public void setApplicant(Long applicant) {
    this.applicant = applicant;
  }

  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  public List<WhAllotStoreApplicationSkuVO> getSkuList() {
    return skuList;
  }

  public void setSkuList(List<WhAllotStoreApplicationSkuVO> skuList) {
    this.skuList = skuList;
  }
}
