package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotStoreApplicationRejectTypeEnum;
import com.thebeastshop.pegasus.service.warehouse.enums.WhAllotStoreApplicationStatusEnum;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

public class WhAllotStoreApplicationSkuVO implements Serializable {
    private static final long serialVersionUID = 440305150420257404L;

    private Integer id;

    @NotNull(message = "SKU不能为空！")
    private String skuCode;

    @NotNull(message = "申请数量不能为空！")
    @Min(0)
    private Integer quantity;

    private Integer applicationId;

    private Short applicationStatus;

    private String applicationStatusDesc;

    private Date updateTime;

    private Date cancelTime;

    private Long cancelPerson;

    private Long approver;

    private String approverName;

    private Date approvalTime;

    private Short rejectReason;

    private String rejectReasonDesc;

    private String approvalNote;

    private String allotCode;

    private String channelName;

    private String channelCode;

    private Long applicant;

    private String applicantName;

    private String cancelPersonName;

    private Date applicationDate;

    private Long categoryId;

    private String catetoryFullName;

    private String skuName;

    private String skuImg;
    //渠道总数
    private int channelCnt;
    //sku总申请数
    private int totalQuantity;
    //良品仓数量=[WH020600010096]颛兴路 - 良品待分配仓 可用库存 - 所有该SKU预售未分配数量
    private int goodWarehouseQuantity;

    private int officialWebsiteQuantity;

    private Boolean isNotify;

    private String warehouseForChannel;

    private Date planReceiveDate;    //预计到货日期

    // 供应商条码
    private String supplierCode;

    public Integer getId() {
        return id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.id
     *
     * @param id the value for t_wh_allot_store_application_sku.id
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.sku_code
     *
     * @return the value of t_wh_allot_store_application_sku.sku_code
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public String getSkuCode() {
        return skuCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.sku_code
     *
     * @param skuCode the value for t_wh_allot_store_application_sku.sku_code
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode == null ? null : skuCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.quantity
     *
     * @return the value of t_wh_allot_store_application_sku.quantity
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Integer getQuantity() {
        return quantity;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.quantity
     *
     * @param quantity the value for t_wh_allot_store_application_sku.quantity
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.application_id
     *
     * @return the value of t_wh_allot_store_application_sku.application_id
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Integer getApplicationId() {
        return applicationId;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.application_id
     *
     * @param applicationId the value for t_wh_allot_store_application_sku.application_id
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setApplicationId(Integer applicationId) {
        this.applicationId = applicationId;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.application_status
     *
     * @return the value of t_wh_allot_store_application_sku.application_status
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Short getApplicationStatus() {
        return applicationStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.application_status
     *
     * @param applicationStatus the value for t_wh_allot_store_application_sku.application_status
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setApplicationStatus(Short applicationStatus) {
        this.applicationStatus = applicationStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.update_time
     *
     * @return the value of t_wh_allot_store_application_sku.update_time
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.update_time
     *
     * @param updateTime the value for t_wh_allot_store_application_sku.update_time
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.cancel_time
     *
     * @return the value of t_wh_allot_store_application_sku.cancel_time
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Date getCancelTime() {
        return cancelTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.cancel_time
     *
     * @param cancelTime the value for t_wh_allot_store_application_sku.cancel_time
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.cancel_person
     *
     * @return the value of t_wh_allot_store_application_sku.cancel_person
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Long getCancelPerson() {
        return cancelPerson;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.cancel_person
     *
     * @param cancelPerson the value for t_wh_allot_store_application_sku.cancel_person
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setCancelPerson(Long cancelPerson) {
        this.cancelPerson = cancelPerson;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.approver
     *
     * @return the value of t_wh_allot_store_application_sku.approver
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Long getApprover() {
        return approver;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.approver
     *
     * @param approver the value for t_wh_allot_store_application_sku.approver
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setApprover(Long approver) {
        this.approver = approver;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.approval_time
     *
     * @return the value of t_wh_allot_store_application_sku.approval_time
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Date getApprovalTime() {
        return approvalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.approval_time
     *
     * @param approvalTime the value for t_wh_allot_store_application_sku.approval_time
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setApprovalTime(Date approvalTime) {
        this.approvalTime = approvalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.reject_reason
     *
     * @return the value of t_wh_allot_store_application_sku.reject_reason
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public Short getRejectReason() {
        return rejectReason;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.reject_reason
     *
     * @param rejectReason the value for t_wh_allot_store_application_sku.reject_reason
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setRejectReason(Short rejectReason) {
        this.rejectReason = rejectReason;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.approval_note
     *
     * @return the value of t_wh_allot_store_application_sku.approval_note
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public String getApprovalNote() {
        return approvalNote;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.approval_note
     *
     * @param approvalNote the value for t_wh_allot_store_application_sku.approval_note
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setApprovalNote(String approvalNote) {
        this.approvalNote = approvalNote == null ? null : approvalNote.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_wh_allot_store_application_sku.allot_code
     *
     * @return the value of t_wh_allot_store_application_sku.allot_code
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public String getAllotCode() {
        return allotCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_wh_allot_store_application_sku.allot_code
     *
     * @param allotCode the value for t_wh_allot_store_application_sku.allot_code
     *
     * @mbggenerated Mon Aug 13 10:25:18 CST 2018
     */
    public void setAllotCode(String allotCode) {
        this.allotCode = allotCode == null ? null : allotCode.trim();
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getCancelPersonName() {
        return cancelPersonName;
    }

    public void setCancelPersonName(String cancelPersonName) {
        this.cancelPersonName = cancelPersonName;
    }

    public String getApplicationStatusDesc() {
        return  applicationStatus == null ? "" : WhAllotStoreApplicationStatusEnum.getStatusDesc(applicationStatus);
    }

    public Date getApplicationDate() {
        return applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public Long getApplicant() {
        return applicant;
    }

    public void setApplicant(Long applicant) {
        this.applicant = applicant;
    }

    public String getCatetoryFullName() {
        return catetoryFullName;
    }

    public void setCatetoryFullName(String catetoryFullName) {
        this.catetoryFullName = catetoryFullName;
    }

    public String getApproverName() {
        return approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public String getSkuImg() {
        return skuImg;
    }

    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

  public int getChannelCnt() {
    return channelCnt;
  }

  public void setChannelCnt(int channelCnt) {
    this.channelCnt = channelCnt;
  }

  public int getTotalQuantity() {
    return totalQuantity;
  }

  public void setTotalQuantity(int totalQuantity) {
    this.totalQuantity = totalQuantity;
  }

    public int getGoodWarehouseQuantity() {
        return goodWarehouseQuantity;
    }

    public void setGoodWarehouseQuantity(int goodWarehouseQuantity) {
        this.goodWarehouseQuantity = goodWarehouseQuantity;
    }

    public int getOfficialWebsiteQuantity() {
        return officialWebsiteQuantity;
    }

    public void setOfficialWebsiteQuantity(int officialWebsiteQuantity) {
        this.officialWebsiteQuantity = officialWebsiteQuantity;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Boolean getNotify() {
        return isNotify;
    }

    public void setNotify(Boolean notify) {
        isNotify = notify;
    }

    public String getWarehouseForChannel() {
        return warehouseForChannel;
    }

    public void setWarehouseForChannel(String warehouseForChannel) {
        this.warehouseForChannel = warehouseForChannel;
    }

    public Date getPlanReceiveDate() {
        return planReceiveDate;
    }

    public void setPlanReceiveDate(Date planReceiveDate) {
        this.planReceiveDate = planReceiveDate;
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getRejectReasonDesc() {
        if (rejectReason == null) {
            return "";
        }
        return WhAllotStoreApplicationRejectTypeEnum.getRejectTypeDesc(rejectReason);
    }
}