package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.WhAllotDiffDetail;

import java.io.Serializable;
import java.util.List;

/**
 * com.thebeastshop.pegasus.service.warehouse.vo
 *
 * @author admin
 * @create 2017-11-21
 */
public class WhAllotDiffDetailVO extends WhAllotDiffDetail implements Serializable {

    private static final long serialVersionUID = -295978750552150812L;
    private List<String> skuCodes;
    private List<Long> refIds;

    private String operatorName;
    private String skuName;

    private String processTypeStr;
    private String warehouseName;

    /**
     * 处理类型
     */
    // 回调1
    public static final Integer PROCESS_TYPE_CALLBACK = 1;
    // 盘点2
    public static final Integer PROCESS_TYPE_INVENTORY = 2;

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public List<Long> getRefIds() {
        return refIds;
    }

    public void setRefIds(List<Long> refIds) {
        this.refIds = refIds;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getProcessTypeStr() {
        return PROCESS_TYPE_CALLBACK.equals(this.getProcessType())?"回调":
                PROCESS_TYPE_INVENTORY.equals(this.getProcessType())?"盘点":"";
    }

    public void setProcessTypeStr(String processTypeStr) {
        this.processTypeStr = processTypeStr;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }
}
