package com.thebeastshop.pegasus.service.warehouse.vo;

import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;

/**
 * @version V1.0
 * @Description:${todo}(用一句话描述该文件做什么)
 * @author: ljj
 * @date: 2018/8/15 14:35
 */
public class TmallStockLogVO extends TmallStockLog {

    private String channelName;

    private String skuNameCn;

    private Integer skuType;

    private String createOperatorName;

    private String syncTypeName;

    private String skuTypeName;

    private String syncStatusName;

    private String dealStatusName;

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public Integer getSkuType() {
        return skuType;
    }

    public void setSkuType(Integer skuType) {
        this.skuType = skuType;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getSyncTypeName() {
        return resolveSynTypeName(getSyncType());
    }

    public void setSyncTypeName(String syncTypeName) {
        this.syncTypeName = syncTypeName;
    }

    public String getSkuTypeName() {
        return resolveSkuTypeName(getSkuType());
    }

    public void setSkuTypeName(String skuTypeName) {
        this.skuTypeName = skuTypeName;
    }

    public String getSyncStatusName() {
        return resolveSyncStatusName(getSyncStatus());
    }

    public void setSyncStatusName(String syncStatusName) {
        this.syncStatusName = syncStatusName;
    }

    public String getDealStatusName() {
        return resolveDealStatusName(getDealStatus());
    }

    public void setDealStatusName(String dealStatusName) {
        this.dealStatusName = dealStatusName;
    }

    //    1:调拨，2：盘点，3：ECP，4：天猫未发货订单取消，5：换货单，8：品级调整
    public static final Integer ALLOT = 1;      //调拨
    public static final Integer CHECK = 2;
    public static final Integer ECP = 3;
    public static final Integer TMALL_UNDELIVERIED_CANCEL = 4;
    public static final Integer CHANGE_PACKAGE = 5;
    public static final Integer PRODUCT_ADJUSTMENT = 8;



    private String resolveSynTypeName(Integer synType) {
        return synType == null ? "" :
                synType.equals(TmallStockLogVO.ALLOT) ? "调拨" :
                        synType.equals(TmallStockLogVO.CHECK) ? "盘点" :
                                synType.equals(TmallStockLogVO.ECP) ? "ECP" :
                                        synType.equals(TmallStockLogVO.TMALL_UNDELIVERIED_CANCEL) ? "天猫未发货订单取消" :
                                                synType.equals(TmallStockLogVO.CHANGE_PACKAGE) ? "换货单" :
                                                        synType.equals(TmallStockLogVO.PRODUCT_ADJUSTMENT) ? "品级调整" : "";
    }

    private String resolveSkuTypeName(Integer skuType) {
        return skuType == null ? "" :
                skuType.equals(1) ? "原材料" :
                        skuType.equals(2) ? "半成品" :
                                skuType.equals(3) ? "成品" :"";
    }

    private String resolveSyncStatusName(Short syncStatus) {
        return syncStatus == null ? "" :
                syncStatus == 0 ? "同步失败" :
                        syncStatus == 1 ? "同步成功" :"";
    }

    private String resolveDealStatusName(Short dealStatus) {
        return dealStatus == null ? "" :
                dealStatus == 0 ? "未处理" :
                        dealStatus == 1 ? "已处理" :"";
    }


}
