package com.thebeastshop.pegasus.service.warehouse.util;

import com.thebeastshop.common.kafka.KafkaConsumerListener;
import com.thebeastshop.pegasus.integration.email.vo.EmailAttachmentVO;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.common.SCMWmsMessage;
import com.thebeastshop.pegasus.service.warehouse.common.ScmSkuListVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStock;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WmsScmCheckRecord;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * 消息队列的接受者
 * create by com.thebeastshop.util.rabbitutil uploadpics :author lijing
 * User:lijing
 * DATE : 2016/5/26
 * TIME : 11:03
 * uploadpics.
 */
public class RabbitReceiver extends KafkaConsumerListener<SCMWmsMessage> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitReceiver.class);
    @Autowired
    private WhInvService whInvService;
    @Autowired
    private WhTakeStockService whTakeStockService;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhWmsScmCheckRecordService whWmsScmCheckRecordService;
    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;

    private static final String[] EXCEL_HEAD = new String[]{"SKU_CODE","SKU名称","对应仓库","差异数","SKU类型","可用剩余数量"};
    /**
     * 邮件收件人
     */
    private final  static  String[] EMAIL_ADDRESSS_XHJ = new String[]{"planning@thebeastshop.com","david.yan@thebeastshop.com","sizhen.ma@thebeastshop.com"};//  allen.wu@thebeastshop.com","jing.li@thebeastshop.com","changjiong.gu@thebeastshop.com","liang.chen@thebeastshop.com
    /**元电路 - 官网渠道销售仓 的逻辑Code*/
    private static final String officialChannelCode = "WH020600010102";

    /**
     * 接收消息，如果有异常，则消息重排
     */
    @Override
    public void processMessage(String s, SCMWmsMessage scmWmsMessage) {
        //这个是用于Excel的字符串的内容
        List<List<String>> excelLines = new ArrayList<List<String>>();
        excelLines.add(getExcelHead());

        if(null != scmWmsMessage){
            try {
                handlePandianDate(scmWmsMessage,excelLines);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else{
            logger.info("scmWmsMessage对象为空");
        }
    }

    /**
     * 得到execl的头
     * @return
     */
    public List<String> getExcelHead(){
        List<String> head = new ArrayList<String>();
        for(String ar : EXCEL_HEAD){
            head.add(ar);
        }
        return head;
    }


    public void handlePandianDate(SCMWmsMessage scmWmsMessage, List<List<String>> excelLines) throws Exception{
        logger.info("进入 盘点对象处理信息  参数  scmWmsMessage={}",scmWmsMessage);
        /**这是良品的统计*/
        Map<String,Map<String,Integer>> goodProduct = new HashMap<String,Map<String,Integer>>();
        /**这是残品仓的统计*/
        Map<String,Map<String,Integer>> defectiveProduct = new HashMap<String,Map<String,Integer>>();
        /**这是样品的统计*/
        Map<String,Map<String,Integer>> sampleProduct = new HashMap<String,Map<String,Integer>>();

        List<ScmSkuListVO> scmSkuListVOList = scmWmsMessage.getSkuList();
        //这里是给样品 残次品   样品 排序
        if(CollectionUtils.isNotEmpty(scmSkuListVOList)){
            for (ScmSkuListVO scmSkuListVO : scmSkuListVOList){
                if(null != scmSkuListVO){
                    if (scmSkuListVO.getSkuCodeStatus() != null){
                        if(scmSkuListVO.getSkuCodeStatus() == 1){
                            //良品
                          Map<String,Integer> goodsProd = goodProduct.get(scmSkuListVO.getPhysicWarehouseCode());
                            if(goodsProd != null){
                               Integer quantityCount = goodsProd.get(scmSkuListVO.getSkuCode());
                                if(quantityCount != null){
                                    quantityCount = quantityCount.intValue() + scmSkuListVO.getQuantity().intValue();
                                    goodsProd.put(scmSkuListVO.getSkuCode(),quantityCount);
                                }else{
                                    goodsProd.put(scmSkuListVO.getSkuCode(),scmSkuListVO.getQuantity());
                                }
                                goodProduct.put(scmSkuListVO.getPhysicWarehouseCode(),goodsProd);
                            }else{
                                Map<String,Integer> goodP = new HashMap<String,Integer>();
                                goodP.put(scmSkuListVO.getSkuCode(),scmSkuListVO.getQuantity());
                                goodProduct.put(scmSkuListVO.getPhysicWarehouseCode(),goodP);
                            }
                        }else if (scmSkuListVO.getSkuCodeStatus() == 0){
                            //残品
                            Map<String,Integer> goodsProd = defectiveProduct.get(scmSkuListVO.getPhysicWarehouseCode());
                            if(goodsProd != null){
                                Integer quantityCount = goodsProd.get(scmSkuListVO.getSkuCode());
                                if(quantityCount != null){
                                    quantityCount = quantityCount.intValue() + scmSkuListVO.getQuantity().intValue();
                                    goodsProd.put(scmSkuListVO.getSkuCode(),quantityCount);
                                }else{
                                    goodsProd.put(scmSkuListVO.getSkuCode(),scmSkuListVO.getQuantity());
                                }
                                defectiveProduct.put(scmSkuListVO.getPhysicWarehouseCode(),goodsProd);
                            }else{
                                Map<String,Integer> goodP = new HashMap<String,Integer>();
                                goodP.put(scmSkuListVO.getSkuCode(),scmSkuListVO.getQuantity());
                                defectiveProduct.put(scmSkuListVO.getPhysicWarehouseCode(),goodP);
                            }
                        }else {
                            //样品
                            Map<String,Integer> goodsProd = sampleProduct.get(scmSkuListVO.getPhysicWarehouseCode());
                            if(goodsProd != null){
                                Integer quantityCount = goodsProd.get(scmSkuListVO.getSkuCode());
                                if(quantityCount != null){
                                    quantityCount = quantityCount.intValue() + scmSkuListVO.getQuantity().intValue();
                                    goodsProd.put(scmSkuListVO.getSkuCode(),quantityCount);
                                }else{
                                    goodsProd.put(scmSkuListVO.getSkuCode(),scmSkuListVO.getQuantity());
                                }
                                sampleProduct.put(scmSkuListVO.getPhysicWarehouseCode(),goodsProd);
                            }else{
                                Map<String,Integer> goodP = new HashMap<String,Integer>();
                                goodP.put(scmSkuListVO.getSkuCode(),scmSkuListVO.getQuantity());
                                sampleProduct.put(scmSkuListVO.getPhysicWarehouseCode(),goodP);
                            }
                        }
                    }
                }
            }
        }
        //统计完成
        logger.info("goodProduct ={}",goodProduct);
        logger.info("defectiveProduct ={}",defectiveProduct);
        logger.info("sampleProduct ={}", sampleProduct);
        //走不同的处理
        hanldGoodProduct(goodProduct, scmWmsMessage.getUserId(), scmWmsMessage.getWmsId(), excelLines);
        hanlddefectiveProduct(defectiveProduct, scmWmsMessage.getUserId(), scmWmsMessage.getWmsId(), excelLines);
        hanldsampleProduct(sampleProduct, scmWmsMessage.getUserId(), scmWmsMessage.getWmsId(), excelLines);
        logger.info("处理完成！");
        //BI有发邮件，现注释
        //发送邮件
//      byte[]  bytes = ExcelUtil.write("scm盘点", excelLines, false);
//        if(null != bytes){
//            EmailVO emailVO = setEmail(bytes);
//            boolean resultEmail = EmailUtil.getInstance().send(emailVO);
//            if(resultEmail){
//                logger.warn("发送邮件成功");
//            } else {
//                logger.warn("发送邮件失败");
//            }
//
//        }else{
//            logger.warn("excel 没有值没有 发邮件");
//        }

    }

    /**
     * 设置邮件方法
     * @Author lijing
     * @time 2016-04-29
     * @param number
     * @return
     */
    public EmailVO setEmail(byte[] number){


        EmailVO emailVO = new EmailVO();
        List<EmailAttachmentVO>  emailAttachmentVOs = new ArrayList<>();
        EmailAttachmentVO emailAttachmentVO = new EmailAttachmentVO(DateTool.date2String(new Date(),DateTool.FORMAT_DATE)+new Random().nextInt(100)+"盘点"+".xlsx",number);
        emailAttachmentVOs.add(emailAttachmentVO);
        emailVO.setAttachmentList(emailAttachmentVOs);
        emailVO.setContent("这是盘点的差异表格，请查收");
        emailVO.setSubject("这是盘点的差异表格，请查收");
        List<String> emailAddress = new ArrayList<String>();
        for(String str : EMAIL_ADDRESSS_XHJ){
            emailAddress.add(str);
        }
        emailVO.setToAddressList(emailAddress);
        return emailVO;
    }

    /**
     * 良品处理
     * @param goodProduct
     * @param userId
     * @param wmsId
     * @throws Exception 
     */
     public void hanldGoodProduct( Map<String,Map<String,Integer>> goodProduct,Long userId,Long wmsId, List<List<String>> excelLines) throws Exception{
         if(!goodProduct.isEmpty()){
             for (Map.Entry<String,Map<String,Integer>> entry : goodProduct.entrySet()) {
                 String physicWarehouseCode = entry.getKey();
                 Map<String,Integer> skus = entry.getValue();
                 for(Map.Entry<String,Integer> skusEn : skus.entrySet() ){
                     String skuCode = skusEn.getKey();
                     Integer quantity = skusEn.getValue();
                     List<WhWarehouse> whWarehouses = whInfoService.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, 1);
                     if (quantity.intValue() > 0){
                        //直接创建盘点
                         /**
                          * scm盘点流程   1.通过物理仓  和类型查询逻辑仓 是良品仓的结果
                          * 2. 创建 盘点
                          *
                          *
                          */

                         if(CollectionUtils.isNotEmpty(whWarehouses)){
                             //调用创建判断接口
                             /**这是良品仓的sku 数量*/
                             WhInvVO goodProductWhInvVO = whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode, whWarehouses.get(0).getCode());

                             Long id = saveCreateTakeStock(skuCode,quantity,userId,whWarehouses.get(0).getCode());
                             logger.info("调用scm盘点返回 id ={}",id);
                             //保存记录 另外的方法
                             if(id > 0){

                                 int c=  saveWmsScmCheckRecord(wmsId,id,userId);

                                 //保存记录到 execl中
                                 //1 查询 skuName 和数量 然后保存
                                 WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                 whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                 List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                 //查询总量


                                 List<String> ececlSet = new ArrayList<>();
                                 ececlSet.add(skuCode);//skuCode
                                 ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                 ececlSet.add(whWarehouses.get(0).getName());
                                 ececlSet.add(quantity.intValue()+"");
                                 ececlSet.add("良品");
                                 ececlSet.add(((goodProductWhInvVO == null ? 0 : goodProductWhInvVO.getCanUseInv()) + quantity.intValue() )+"");
                                 excelLines.add(ececlSet);
                                 //end
                                 logger.info("保存记录 返回 c={}", c);
                             }else{
                                 logger.info("调用scm盘点返回 id 错误 ");
                             }
                         }else{
                             logger.info("通过物理仓没有查询到 良品仓");
                         }

                     }

                     if(quantity.intValue() < 0){
                        //查询数量判断 2个仓  1是良品仓库  2是 官网仓(code 写死)
                         /**
                          * 亏的处理流程
                          * 1. 用亏的总数量和 先和 良品仓的库存相加 然后在和
                          */
                         if(CollectionUtils.isNotEmpty(whWarehouses)){
                             logger.info("====盘亏scm开始计算处理 === ");
                             lossCalc(skuCode, quantity, whWarehouses.get(0).getCode(),whWarehouses.get(0).getName(), wmsId, userId,excelLines);
                             logger.info("====盘亏scm结束计算处理 === ");
                         }else{
                             logger.info("良品仓 查询为空 就没有走亏的情况   对应的sku为={} 数量为={}",skuCode,quantity);
                         }
                     }
                 }
             }
         }
     }


     /**
     * 对亏的盘点进行平摊
     * @param skuCode  shkCode
     * @param quantity  数量 本来的
     * @param warehouseCode  良品仓 code
     * @return
     * @param wmsId  wms盘点id
     * @param userId  用户id
     * @throws Exception 
     */
    public void lossCalc(String skuCode,Integer quantity,String warehouseCode,String warehouseName,Long wmsId,Long userId,List<List<String>> execlList) throws Exception{
        logger.info("盘亏的记录  参数 ==skuCode={},quantity={},warehouseCode={}",skuCode,quantity,warehouseCode);
        if(StringUtils.isNotBlank(skuCode)){
            Map<String,Integer> quanT = new HashMap<String,Integer>();
            /**这是良品仓的sku 数量*/
            WhInvVO goodProductWhInvVO = whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode,warehouseCode);
            /**这是官网的sku 数量*/
            WhInvVO officialProductWhInvVO = whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skuCode,officialChannelCode);
            if(null != goodProductWhInvVO){
                Integer goodSproCount = goodProductWhInvVO.getCanUseInv();
                if((goodSproCount.intValue() + quantity.intValue() ) >=0){
                    //这里证明  良品仓就可以满足
                    logger.info("良品仓满足了要求 skuCode={}",skuCode);
                    Long scmId = saveCreateTakeStock(skuCode,quantity,userId,warehouseCode);
                    if(scmId > 0){
                        //插入 execl 信息
                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                        List<String> ececlSet = new ArrayList<>();
                        ececlSet.add(skuCode);//skuCode
                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                        ececlSet.add(warehouseName);
                        ececlSet.add(quantity.intValue()+"");
                        ececlSet.add("良品");
                        ececlSet.add((goodSproCount.intValue() + quantity.intValue())+"");
                        execlList.add(ececlSet);
                        //end

                        saveWmsScmCheckRecord(wmsId,scmId,userId);
                    }else{
                        logger.info("创建盘点失败，scm盘点返回 小于0");
                    }
                    return;
                }else{
                    if(goodSproCount.intValue() >= 0) {
                        quanT.put("goodsP", 0 - goodSproCount.intValue());//良品的数量

                        quantity = (quantity.intValue() + goodSproCount.intValue());//quantity一定小于0 的
                        if(officialProductWhInvVO != null){
                            logger.info("官网渠道 有skuCode的数量信息");
                            Integer guanwangQu = officialProductWhInvVO.getCanUseInv();
                            if((guanwangQu.intValue() + quantity.intValue()) >= 0){
                                //可以扣减完成


                                Long scmId = saveCreateTakeStock(skuCode,quanT.get("goodsP"),userId,warehouseCode);//当然先要吧良品的减完计算
                                Long scmGuanId = saveCreateTakeStock(skuCode,quantity,userId,officialChannelCode);//官网够减少了  然后 就减少官网的
                                if(scmId > 0){
                                    saveWmsScmCheckRecord(wmsId,scmId,userId);
                                    //插入 execl 信息
                                    WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                    whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                    List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                    List<String> ececlSet = new ArrayList<>();
                                    ececlSet.add(skuCode);//skuCode
                                    ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                    ececlSet.add(warehouseName);
                                    ececlSet.add(quanT.get("goodsP")+"");
                                    ececlSet.add("良品");
                                    ececlSet.add((goodSproCount.intValue() + quanT.get("goodsP"))+"");
                                    execlList.add(ececlSet);
                                    //end

                                }else{
                                    logger.info("创建盘点失败，scm盘点返回 小于0");
                                }
                                if(scmGuanId > 0){
                                    saveWmsScmCheckRecord(wmsId,scmGuanId,userId);
                                    //插入 execl 信息
                                    WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                    whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                    List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                    List<String> ececlSet = new ArrayList<>();
                                    ececlSet.add(skuCode);//skuCode
                                    ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                    ececlSet.add("官网仓");
                                    ececlSet.add(quantity+"");
                                    ececlSet.add("良品");
                                    ececlSet.add((guanwangQu.intValue() + quantity)+"");
                                    execlList.add(ececlSet);
                                    //end
                                }else{
                                    logger.info("创建盘点官网的渠道失败，scm盘点返回 小于0");
                                }
                                return ;
                            }else{
                                logger.info("官网渠道的 数量也不够减少的 skuCode={}  逛网渠道数量为={}   ,现在需要扣减的数量为={}   现在全部扣减到良品", skuCode, guanwangQu, quantity);
                                quanT.put("guanwang", guanwangQu);
                                quantity = quantity.intValue() + guanwangQu.intValue();
                                Integer goodG = quanT.get("goodsP");

                                Long scmId = saveCreateTakeStock(skuCode,goodG.intValue() + quantity.intValue(),userId,warehouseCode);
                                logger.info("良品仓 盘点id scmId={}",scmId);
                                Long scmGuanId = saveCreateTakeStock(skuCode,0-guanwangQu.intValue(),userId,officialChannelCode);
                                if(scmId > 0){
                                    saveWmsScmCheckRecord(wmsId,scmId,userId);
                                    //插入 execl 信息
                                    WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                    whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                    List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                    List<String> ececlSet = new ArrayList<>();
                                    ececlSet.add(skuCode);//skuCode
                                    ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                    ececlSet.add(warehouseName);
                                    ececlSet.add(goodG.intValue() + quantity.intValue()+"");
                                    ececlSet.add("良品");
                                    ececlSet.add((goodSproCount.intValue() + (goodG.intValue() + quantity.intValue()))+"");
                                    execlList.add(ececlSet);
                                    //end

                                }else{
                                    logger.info("创建盘点失败，scm盘点返回 小于0");
                                }
                                if(scmGuanId > 0){
                                    saveWmsScmCheckRecord(wmsId,scmGuanId,userId);
                                    //插入 execl 信息
                                    WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                    whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                    List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                    List<String> ececlSet = new ArrayList<>();
                                    ececlSet.add(skuCode);//skuCode
                                    ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                    ececlSet.add("官网仓");
                                    ececlSet.add((0-guanwangQu.intValue())+"");
                                    ececlSet.add("良品");
                                    ececlSet.add((guanwangQu.intValue() + (0-guanwangQu.intValue()))+"");
                                    execlList.add(ececlSet);
                                }else{
                                    logger.info("创建盘点官网的渠道失败，scm盘点返回 小于0");
                                }
                                return ;
                            }
                        }else{
                            logger.info("官网渠道  sku  查询数量为空 skuCode={}  把所有的库存扣减到了  良品中",skuCode);
                            Integer cTt = quanT.get("goodsP");
                            cTt = cTt.intValue() + quantity.intValue();
                            Long scmId = saveCreateTakeStock(skuCode,cTt,userId,warehouseCode);
                            if(scmId > 0){
                                saveWmsScmCheckRecord(wmsId,scmId,userId);
                                //插入 execl 信息
                                WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                List<String> ececlSet = new ArrayList<>();
                                ececlSet.add(skuCode);//skuCode
                                ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                ececlSet.add(warehouseName);
                                ececlSet.add(cTt+"");
                                ececlSet.add("良品");
                                ececlSet.add((goodSproCount.intValue() + cTt.intValue())+"");
                                execlList.add(ececlSet);
                                //end
                            }else{
                                logger.info("创建盘点失败，scm盘点返回 小于0");
                            }
                        }
                    }else{
                        //良品为负数
                        if(officialProductWhInvVO != null){
                            Integer guanwangQu = officialProductWhInvVO.getCanUseInv();
                            if((guanwangQu.intValue() + quantity.intValue()) >= 0){
                                Long scmGuanId = saveCreateTakeStock(skuCode,quantity.intValue(),userId,officialChannelCode);
                                if(scmGuanId > 0){
                                    saveWmsScmCheckRecord(wmsId,scmGuanId,userId);
                                    //插入 execl 信息
                                    WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                    whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                    List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                    List<String> ececlSet = new ArrayList<>();
                                    ececlSet.add(skuCode);//skuCode
                                    ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                    ececlSet.add("官网仓");
                                    ececlSet.add(quantity.intValue()+"");
                                    ececlSet.add("良品");
                                    ececlSet.add((guanwangQu.intValue() + quantity.intValue())+"");
                                    execlList.add(ececlSet);
                                }else{
                                    logger.info("创建盘点官网的渠道失败，scm盘点返回 小于0");
                                }
                                return ;
                            }else{
                                if(guanwangQu.intValue() >=0){
                                    quantity = quantity.intValue() + guanwangQu.intValue();
                                    Long scmId = saveCreateTakeStock(skuCode,quantity,userId,warehouseCode);
                                    logger.info("良品仓 盘点id scmId={}",scmId);
                                    Long scmGuanId = saveCreateTakeStock(skuCode,0-guanwangQu.intValue(),userId,officialChannelCode);
                                    if(scmId > 0){
                                        //插入 execl 信息
                                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                        List<String> ececlSet = new ArrayList<>();
                                        ececlSet.add(skuCode);//skuCode
                                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                        ececlSet.add(warehouseName);
                                        ececlSet.add(quantity+"");
                                        ececlSet.add("良品");
                                        ececlSet.add((goodSproCount.intValue() + quantity.intValue())+"");
                                        execlList.add(ececlSet);
                                        //end
                                        saveWmsScmCheckRecord(wmsId,scmId,userId);
                                    }else{
                                        logger.info("创建盘点失败，scm盘点返回 小于0");
                                    }
                                    if(scmGuanId > 0){
                                        //插入 execl 信息
                                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                        List<String> ececlSet = new ArrayList<>();
                                        ececlSet.add(skuCode);//skuCode
                                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                        ececlSet.add("官网仓");
                                        ececlSet.add((0-guanwangQu.intValue())+"");
                                        ececlSet.add("良品");
                                        ececlSet.add((guanwangQu.intValue() +(0-guanwangQu.intValue()))+"");
                                        execlList.add(ececlSet);
                                        saveWmsScmCheckRecord(wmsId,scmGuanId,userId);
                                    }else{
                                        logger.info("创建盘点官网的渠道失败，scm盘点返回 小于0");
                                    }
                                    return ;
                                }else{
                                    Long scmId = saveCreateTakeStock(skuCode, quantity.intValue(),userId,warehouseCode);
                                    if(scmId > 0){
                                        //插入 execl 信息
                                        WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                        whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                        List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                        List<String> ececlSet = new ArrayList<>();
                                        ececlSet.add(skuCode);//skuCode
                                        ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                        ececlSet.add(warehouseName);
                                        ececlSet.add(quantity.intValue()+"");
                                        ececlSet.add("良品");
                                        ececlSet.add((goodSproCount.intValue() + quantity.intValue())+"");
                                        execlList.add(ececlSet);
                                        //end
                                        saveWmsScmCheckRecord(wmsId,scmId,userId);
                                    }else{
                                        logger.info("创建盘点失败，scm盘点返回 小于0");
                                    }
                                    return;
                                }

                            }
                        }else{
                            logger.info("fushu 官网渠道  sku  查询数量为空 skuCode={}  把所有的库存扣减到了  良品中",skuCode);

                            Long scmId = saveCreateTakeStock(skuCode,quantity.intValue(),userId,warehouseCode);
                            if(scmId > 0){
                                //插入 execl 信息
                                WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
                                whWmsShelvesSkuInfoCond.setSkuCode(skuCode);
                                List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
                                List<String> ececlSet = new ArrayList<>();
                                ececlSet.add(skuCode);//skuCode
                                ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
                                ececlSet.add(warehouseName);
                                ececlSet.add(quantity.intValue()+"");
                                ececlSet.add("良品");
                                ececlSet.add((goodSproCount.intValue() + quantity.intValue())+"");
                                execlList.add(ececlSet);
                                //end
                                saveWmsScmCheckRecord(wmsId,scmId,userId);

                            }else{
                                logger.info("创建盘点失败，scm盘点返回 小于0");
                            }
                        }
                    }
                }
            }else{
                logger.error("盘点的良品仓查询为空 对应的wms的盘点为 wmsId={}, skuCode={},quantity={}",wmsId,skuCode,quantity);
            }
        }else{
            logger.error("盘亏的sku 为空");
        }
        return ;
    }
    /**
     * 保存scm盘点接口
     * @param skuCode sku
     * @param quantity 数量
     * @param userId  用户id
     * @param whwarCode 逻辑仓
     * @return
     * @throws Exception 
     */
    public Long saveCreateTakeStock(String skuCode,Integer quantity,Long userId,String whwarCode) throws Exception{
        logger.info("调用scm 参数  skuCode={},quantity={},userId={},whwarCode={}", skuCode, quantity, userId, whwarCode);
        WhTakeStock whTakeStock = new WhTakeStock();
        whTakeStock.setCreateUserId(userId);
        whTakeStock.setWarehouseCode(whwarCode);
        List<WhTakeStockRcd> whTakeStockRcds = new ArrayList<WhTakeStockRcd>();
        WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
        whTakeStockRcd.setQuantity(quantity);
        whTakeStockRcd.setSkuCode(skuCode);
        whTakeStockRcds.add(whTakeStockRcd);
        whTakeStock.setWhTakeStockRcdList(whTakeStockRcds);
        Long id =whTakeStockService.createTakeStock(whTakeStock);
        logger.info("保存的结果为id={}",id);
        return id;
    }


    /**
     * 批量保存scm盘点接口
     * @param userId  用户id
     * @param whwarCode 逻辑仓
     * @param type  0 残次   2是样品
     * @return
     * @throws Exception 
     */
    public Long saveCreateTakeStockPist( Map<String,Integer> skuCodeQuantity,Long userId,String whwarCode,String whwarName,List<List<String>> excelLines,int type) throws Exception{
        logger.info("调用scm 参数 skuCodeQuantity={},userId={},whwarCode={}", skuCodeQuantity, userId, whwarCode);
        WhTakeStock whTakeStock = new WhTakeStock();
        whTakeStock.setCreateUserId(userId);
        whTakeStock.setWarehouseCode(whwarCode);
        List<WhTakeStockRcd> whTakeStockRcds = new ArrayList<WhTakeStockRcd>();
        for(Map.Entry<String,Integer> skusEn : skuCodeQuantity.entrySet() ){
            //先去查询 skuCOde的名称 然后先设置 ececl
            WhWmsShelvesSkuInfoCond whWmsShelvesSkuInfoCond = new WhWmsShelvesSkuInfoCond();
            whWmsShelvesSkuInfoCond.setSkuCode(skusEn.getKey());
            List<WhWmsShelvesSkuInfoVO> whWmsShelvesSkuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(whWmsShelvesSkuInfoCond);
            //查询总量
            /**这是良品仓的sku 数量*/
            WhInvVO goodProductWhInvVO = whInvService.findCanUseQttBySkuCodeAndWarehouseCode(skusEn.getKey(), whwarCode);

            List<String> ececlSet = new ArrayList<>();
            ececlSet.add(skusEn.getKey());//skuCode
            ececlSet.add(CollectionUtils.isNotEmpty(whWmsShelvesSkuInfos) ? whWmsShelvesSkuInfos.get(0).getSkuNameCN() : "" );
            ececlSet.add(whwarName);
            ececlSet.add(skusEn.getValue()+"");
            ececlSet.add(type == 0 ? "残次品" : "样品");
            ececlSet.add(((goodProductWhInvVO == null ? 0 : goodProductWhInvVO.getCanUseInv()) + skusEn.getValue() )+"");
            excelLines.add(ececlSet);

            // ==下面是正常逻辑  上面是封装 execl
            WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
            whTakeStockRcd.setQuantity(skusEn.getValue());
            whTakeStockRcd.setSkuCode(skusEn.getKey());
            whTakeStockRcds.add(whTakeStockRcd);
        }
        whTakeStock.setWhTakeStockRcdList(whTakeStockRcds);
        Long id =whTakeStockService.createTakeStock(whTakeStock);
        logger.info("保存的结果为id={}",id);
        return id;
    }
    /**
     * 残品处理
     * @param defectiveProduct
     * @param userId
     * @param wmsId
     * @throws Exception 
     */
    public void hanlddefectiveProduct( Map<String,Map<String,Integer>> defectiveProduct,Long userId,Long wmsId, List<List<String>> excelLines) throws Exception{

        if(!defectiveProduct.isEmpty()){
            for (Map.Entry<String,Map<String,Integer>> entry : defectiveProduct.entrySet()) {
                String physicWarehouseCode = entry.getKey();
                Map<String,Integer> skus = entry.getValue();
                //批量保存
                List<WhWarehouse> whWarehouses = whInfoService.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode, 2);
                if(CollectionUtils.isNotEmpty(whWarehouses)){
                    //调用创建判断接口
                    Long id =  saveCreateTakeStockPist(skus, userId, whWarehouses.get(0).getCode(),whWarehouses.get(0).getName(),excelLines,0);
                    logger.info("调用scm盘点返回 id ={}",id);
                    //保存记录 另外的方法
                    if(id > 0){
                        int c=  saveWmsScmCheckRecord(wmsId,id,userId);
                        logger.info("保存记录 返回 c={}",c);
                    }else{
                        logger.info("调用scm盘点返回 id 错误 ");
                    }
                }else{
                    logger.info("通过物理仓没有查询到 残品仓");
                }

            }
        }
    }

    /**
     * 样品处理
     * @param sampleProduct
     * @param userId
     * @param wmsId
     * @throws Exception 
     */
    public void hanldsampleProduct( Map<String,Map<String,Integer>> sampleProduct,Long userId,Long wmsId, List<List<String>> excelLines) throws Exception{
        if(!sampleProduct.isEmpty()){
            for (Map.Entry<String,Map<String,Integer>> entry : sampleProduct.entrySet()) {
                String physicWarehouseCode = entry.getKey();
                Map<String,Integer> skus = entry.getValue();
                List<WhWarehouse> whWarehouses = whInfoService.findWarehouseByPhysicalCodeAndStatus(physicWarehouseCode,5);
                if(CollectionUtils.isNotEmpty(whWarehouses)){
                    //调用创建判断接口
                    Long id =  saveCreateTakeStockPist(skus,userId,whWarehouses.get(0).getCode(),whWarehouses.get(0).getName(),excelLines,2);
                    //保存记录 另外的方法
                    logger.info("调用scm盘点返回 id ={}",id);
                    //保存记录 另外的方法
                    if(id > 0){
                      int c=  saveWmsScmCheckRecord(wmsId,id,userId);
                        logger.info("保存记录 返回 c={}",c);
                    }else{
                        logger.info("调用scm盘点返回 id 错误 ");
                    }
                }else{
                    logger.info("通过物理仓没有查询到 残品仓");
                }

            }
        }
    }

    /**
     * 保存wms盘点调用的scm记录
     * @param wmsId
     * @param scmId
     * @param userId
     * @return
     */
    public int saveWmsScmCheckRecord(Long wmsId,Long scmId,Long userId) {
        logger.info("保存记录参数  wmsId={},scmId={},userId={}", wmsId, scmId, userId);
        WmsScmCheckRecord wmsScmCheckRecord = new WmsScmCheckRecord();
        wmsScmCheckRecord.setScmId(scmId);
        wmsScmCheckRecord.setWmsId(wmsId);
        wmsScmCheckRecord.setUserId(userId);
        return  whWmsScmCheckRecordService.insertWmsScmCheckRecord(wmsScmCheckRecord);
    }


}
