package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWarehouseAreaMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseAreaExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.util.CollectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by devin.li on 2016/3/21.
 */
@Service("whWmsWarehouseAreaService")
public class WhWmsWarehouseAreaServiceImpl implements WhWmsWarehouseAreaService {

    @Autowired
    private WhWmsWarehouseAreaMapper whWmsWarehouseAreaMapper;

    public WhWmsWarehouseArea getAreaByType(String houseType,String code){
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        WhWmsWarehouseAreaExample.Criteria criteria = example.createCriteria();
        criteria.andHouseTypeEqualTo(houseType);
        criteria.andCodeEqualTo(code);
       List<WhWmsWarehouseArea> list = whWmsWarehouseAreaMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) return null;
        return list.get(0);
    }

    public List<WhWmsWarehouseArea> getAllArea(){
//        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
//        example.createCriteria();
       List<WhWmsWarehouseArea> list = whWmsWarehouseAreaMapper.getAll();
        if (CollectionUtils.isEmpty(list)) return null;
        return list;
    }

    @Override
    public WhWmsWarehouseArea getAreaByCode(String houseCode) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andCodeEqualTo(houseCode);
        List<WhWmsWarehouseArea> list =whWmsWarehouseAreaMapper.selectByExample(example);
       if(CollectionUtils.isEmpty(list)) return null;
        return list.get(0);
    }

    @Override
    public WhWmsWarehouseArea getAreaByName(String name) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andHouseTypeNameEqualTo(name);
        List<WhWmsWarehouseArea> list =whWmsWarehouseAreaMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(list)) return null;
        return list.get(0);
    }

    @Override
    public WhWmsWarehouseArea getAreaByHouseType(String houseType) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andHouseTypeEqualTo(houseType);
        List<WhWmsWarehouseArea> list =whWmsWarehouseAreaMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(list)) return null;
        return list.get(0);
    }

    @Override
    public List<String> getHouseTypesByType(String type) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        WhWmsWarehouseAreaExample.Criteria criteria = example.createCriteria();
        criteria.andTypeEqualTo(type);
        List<WhWmsWarehouseArea> list = whWmsWarehouseAreaMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(list)){
            return Collections.emptyList();
        }else{
            List<String> newList = new ArrayList<>();
            for (WhWmsWarehouseArea whWmsWarehouseArea : list) {
                newList.add(whWmsWarehouseArea.getHouseType());
            }
            return newList;
        }
    }

    @Override
    public List<WhWmsWarehouseArea> getAreaHouseByType(String type) {
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        if(EmptyUtil.isNotEmpty(type)){
            WhWmsWarehouseAreaExample.Criteria criteria = example.createCriteria();
            criteria.andTypeEqualTo(type);
        }
        List<WhWmsWarehouseArea> list = whWmsWarehouseAreaMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(list)){
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public Map<String, WhWmsWarehouseArea> getAreaHouseMapByType(String type) {
        Map<String, WhWmsWarehouseArea> map = new HashMap<>();
        List<WhWmsWarehouseArea> list = getAreaHouseByType(type);
        if(EmptyUtil.isNotEmpty(list)){
            for(WhWmsWarehouseArea area : list){
                map.put(area.getHouseType(),area);
            }
        }
        return map;
    }
}
