package com.thebeastshop.pegasus.service.warehouse.service.impl;


import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWaitPutawayTaskService;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.web.response.JsonResult;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by Administrator on 2016/4/13.
 */
@Service("whWmsWaitPutawayTaskService")
public class WhWmsWaitPutawayTaskServiceImpl implements WhWmsWaitPutawayTaskService{

    private static Logger log = LoggerFactory.getLogger(WhWmsWaitPutawayTaskServiceImpl.class);

    @Autowired
    private WhWmsWaitPutawayTaskMapper mapper;
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsOccupyMapper whWmsOccupyMapper;
    @Autowired
    private WhWarehouseMapper whWarehouseMapper;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Override
    public WhWmsWaitPutawayTaskVO create(WhWmsWaitPutawayTaskVO vo) {
        WhWmsWaitPutawayTask task = BeanUtil.buildFrom(vo, WhWmsWaitPutawayTask.class);
        mapper.insert(task);
        vo.setId(task.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsWaitPutawayTaskVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo,WhWmsWaitPutawayTask.class))!=0;
    }

    @Override
    public WhWmsWaitPutawayTaskVO findById(Long id) {
        WhWmsWaitPutawayTask task = mapper.selectByPrimaryKey(id);
        if(task!=null){
            return BeanUtil.buildFrom(task,WhWmsWaitPutawayTaskVO.class);
        }
        return null;
    }

    @Override
    public Pagination<WhWmsWaitPutawayTaskVO> findPutawayTaskList(WhWmsWaitPutawayTaskVO vo) {
        WhWmsWaitPutawayTaskExample example = new WhWmsWaitPutawayTaskExample();
        WhWmsWaitPutawayTaskExample.Criteria criteria = example.createCriteria();
        List<String> skuList = new ArrayList<>();
        if(vo.getPopCode() != null && !vo.getPopCode().equals("")){
            WhCommand whCommand = whCommandService.findCommandByReferenceCode(vo.getPopCode());
            if(whCommand != null && whCommand.getWhCommandSkuList() != null && whCommand.getWhCommandSkuList().size() > 0){
                for(WhCommandSku whCommandSku:whCommand.getWhCommandSkuList()){
                    skuList.add(whCommandSku.getSkuCode());
                }
                criteria.andSkuCodeIn(skuList);
            }
        }
        if(vo.getPhysicalWarehouseCode() != null && !vo.getPhysicalWarehouseCode().equals("") ){
            criteria.andPhysicalWarehouseCodeEqualTo(vo.getPhysicalWarehouseCode());
        }
        if(vo.getStatus() != null && vo.getStatus() > 0){
            criteria.andStatusEqualTo(vo.getStatus());
        }
        if(vo.getBatchNo() != null && !vo.getBatchNo().equals("")){
            criteria.andBatchNoEqualTo(vo.getBatchNo());
        }
        if(vo.getCode() != null && !vo.getCode().equals("")){
            criteria.andCodeEqualTo(vo.getCode());
        }
        if(vo.getSkuCode() != null && !vo.getSkuCode().equals("")){
            criteria.andSkuCodeEqualTo(vo.getSkuCode());
        }
        if(vo.getSkuStatus() != null && vo.getSkuStatus() >= 0){
            criteria.andSkuStatusEqualTo(vo.getSkuStatus());
        }
        if(vo.getHouseType() != null && !vo.getHouseType().equals("")){
            criteria.andHouseTypeEqualTo(vo.getHouseType());
        }
        if(vo.getInOutType()!=null){
            criteria.andInOutTypeEqualTo(vo.getInOutType());
        }
        if(vo.getBarCode()!=null && !vo.getBarCode().equals("")){
            criteria.andBarCodeEqualTo(vo.getBarCode());
        }

        int count = mapper.countByExample(example);
        Pagination<WhWmsWaitPutawayTaskVO> pagination = new Pagination<WhWmsWaitPutawayTaskVO>();
        pagination.setCurrpage(vo.getCurrpage());
        pagination.setPagenum(vo.getPagenum());
        pagination.setRecord(count);
        List<WhWmsWaitPutawayTaskVO> list = mapper.findWhWmsWaitPutawayTaskVOList(vo);
        pagination.setResultList(list);
        return pagination;
    }

    @Override
    public List<WhWmsWaitPutawayTaskVO> findWhWmsWaitPutawayTaskVOList(WhWmsWaitPutawayTaskVO vo) {
        return mapper.findWhWmsWaitPutawayTaskVOList(vo);
    }

    @Override
    public List<WhCountVO> countPutawayTask(String physicalWarehouseCode) {
        return mapper.countPutawayTask(physicalWarehouseCode);
    }


    public boolean targetShelvesCodeCheck(String shelvesCode,String barCode,boolean focus){
        WhWmsHouseShelvesVO shelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCode);
        if(NullUtil.isNull(shelvesVO)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]库位不存在！",shelvesCode));
        }
        //库位类型常规判断
        if(WhWmsHouseShelvesVO.SHELVES_TYPE_NORMAL.equals(shelvesVO.getShelvesType())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]库位类型为常规！",shelvesCode));
        }
        if(focus){
            return true;
        }
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setShelvesCode(shelvesVO.getCode());
        stockCond.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        stockCond.setHouseType(shelvesVO.getHouseType());
        List<WhWmsSkuStock> stockList = whWmsSkuStockService.getStockByCond(stockCond);
        Map<String,Set<String>> skuBarCodeMap = getShelveSkuBarCodeMap(stockList);
        //相同商品不同批次

        String skuCode = barCode.split("_")[0];
        Set<String> barCodes = skuBarCodeMap.get(skuCode);
        StringBuilder buffer = new StringBuilder();
        if(EmptyUtil.isNotEmpty(barCodes)){
            if(!barCodes.contains(barCode) || barCodes.size()>1){
                //throw new WarehouseException(WarehouseExceptionErrorCode.CONDITION_NEED_CHECK,String.format("[%s]存在相同商品不同批次！",shelvesCode));
                buffer.append("2").append(";");
            }
        }
        //库位类型拣货判断
        if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(shelvesVO.getShelvesType())){
            if(EmptyUtil.isNotEmpty(shelvesVO.getSkuCode())
                    && !shelvesVO.getSkuCode().equals(skuCode)){
                //throw new WarehouseException(WarehouseExceptionErrorCode.CONDITION_NEED_CHECK,String.format("[%s]库位已关联其他SKU！",shelvesCode));
                buffer.append("3").append(";");
            }
        }
        //混载条件
        if(WhWmsHouseShelvesVO.MIXED_TYPE_SINGLE.equals(shelvesVO.getMixedType())){
            //单品单批
            if(EmptyUtil.isNotEmpty(skuBarCodeMap)){
                if(skuBarCodeMap.size() > 1 || !skuBarCodeMap.containsKey(skuCode)){
                    buffer.append("4").append(";");
                }else{
                    Set<String> tmpBarCodes = skuBarCodeMap.get(skuCode);
                    if(EmptyUtil.isNotEmpty(tmpBarCodes)){
                        if(!tmpBarCodes.contains(barCode) || tmpBarCodes.size()>1){
                            //throw new WarehouseException(WarehouseExceptionErrorCode.CONDITION_NEED_CHECK,String.format("[%s]不符合混载条件！",shelvesCode));
                            buffer.append("4").append(";");
                        }
                    }
                }
            }
        }else if(WhWmsHouseShelvesVO.MIXED_TYPE_SINGLE.equals(shelvesVO.getMixedType())){
            //多品单批
            Set<String> tmpBarCodes = skuBarCodeMap.get(skuCode);
            if(EmptyUtil.isNotEmpty(tmpBarCodes) && !tmpBarCodes.contains(barCode)){
                buffer.append("4").append(";");
            }
        }
        String errorMsg = buffer.toString();
        if(EmptyUtil.isNotEmpty(errorMsg)){
            throw new WarehouseException(WarehouseExceptionErrorCode.CONDITION_NEED_CHECK,errorMsg);
        }
        return true;
    }

    private Map<String,Set<String>> getShelveSkuBarCodeMap(List<WhWmsSkuStock> stockList){
        Map<String,Set<String>> skuBarCodeMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(stockList)){
            for(WhWmsSkuStock stock : stockList){
                if(NullUtil.isNull(stock.getAmount()) || stock.getAmount() <= 0){
                    continue;
                }
                Set<String> barCodes = skuBarCodeMap.get(stock.getSkuCode());
                if(NullUtil.isNull(barCodes)){
                    barCodes = new HashSet<>();
                    skuBarCodeMap.put(stock.getSkuCode(),barCodes);
                }
                barCodes.add(stock.getBarCode());
            }
        }
        return skuBarCodeMap;
    }

    public List<WhWmsWaitPutawayTask> listWhWmsWaitPutawayTaskByIds(List<Long> taskIds){
        WhWmsWaitPutawayTaskExample taskExample = new WhWmsWaitPutawayTaskExample();
        WhWmsWaitPutawayTaskExample.Criteria criteria = taskExample.createCriteria();
        criteria.andIdIn(taskIds);
        return mapper.selectByExample(taskExample);
    }

    @Override
    public boolean putawayTaskExcu(WhWmsPutawayExcuVO vo,Long operationId) throws Exception {
        //获取分布式锁
        List<String> lockKeyList = new ArrayList<>();
        try{
            if(EmptyUtil.isNotEmpty(vo.getTaskId())){
                for(Long taskId : vo.getTaskId()){
                    lockKeyList.add("lock:wms:putawayTask:"+taskId);
                }
                Boolean getLock = redisDistributLock.tryLock(lockKeyList,3L, TimeUnit.MINUTES);
                if (!getLock){
                    log.info("获取锁失败 putawayTaskExcu");
                    throw new WarehouseException(
                            WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                            "请稍后重试!");
                }
            }
            if(EmptyUtil.isNotEmpty(vo) && CollectionUtils.isNotEmpty(vo.getTaskId())){
                List<Long> taskIds = new ArrayList<>();
                for(int i = 0 ;i < vo.getTaskId().size();i++){
                    taskIds.add(vo.getTaskId().get(i));
                }
                List<WhWmsWaitPutawayTask> waitPutawayTasks = listWhWmsWaitPutawayTaskByIds(taskIds);
                Map<Long, WhWmsWaitPutawayTask> waitPutawayTaskMap = new HashMap<>();
                Set<String> skuCodeSet = new HashSet<>();
                for (WhWmsWaitPutawayTask waitPutawayTask : waitPutawayTasks){
                    waitPutawayTaskMap.put(waitPutawayTask.getId(), waitPutawayTask);
                    skuCodeSet.add(waitPutawayTask.getSkuCode());
                }
                List<PcsSkuVO> pcsSkuVOs = mapper.listPcsSkuInfoBySkuCodes(Arrays.asList(skuCodeSet.toArray(new String[skuCodeSet.size()])));
                Map<String, Integer> shelfLifeMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(pcsSkuVOs)){
                    for (PcsSkuVO pcsSkuVO : pcsSkuVOs){
                        shelfLifeMap.put(pcsSkuVO.getCode(), pcsSkuVO.getShelfLife());
                    }
                }

                checkSampleShelvesByShelfLife(vo, taskIds, waitPutawayTaskMap, shelfLifeMap);

                for(int i = 0 ;i < vo.getTaskId().size();i++){
                    Long taskId = vo.getTaskId().get(i);
                    Integer putawayAmount = vo.getPutawayAmount().get(i);
                    Integer shortAmount = vo.getShortAmount().get(i);

                    String shelvesCode = vo.getShelvesCode().get(i);
                    WhWmsWaitPutawayTask task = waitPutawayTaskMap.get(taskId);
                    if(shelvesCode == null || shelvesCode.equals("")){
                        throw new RuntimeException("请选择库位");
                    }
//                    if(task.getSkuStatus() == 2){
//                        continue;
//                    }
                    WhWmsHouseShelvesCond tarcond = new WhWmsHouseShelvesCond();
                    tarcond.setCode(shelvesCode);
                    List<WhWmsHouseShelvesVO> tarShelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(tarcond);
                    WhWmsHouseShelvesVO tarVo = null;
                    if(tarShelvesList != null && tarShelvesList.size() > 0){
                        tarVo = tarShelvesList.get(0);

                        // 采购入库 待定状态商品，上架库位只能是待定区的库位
                        if (WhCommand.TYPE_PURCHASE_IN.equals(task.getInOutType())
                                && WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(task.getSkuStatus())){
                            if (!WhWmsWarehouseAreaVO.HOUSE_TYPE_HOLD_PENDING.equals(tarVo.getHouseType())){
                                throw new RuntimeException(shelvesCode+",采购入库[待定状态商品]，上架库位只能是待定区的库位");
                            }
                        }
                    }else{
                        throw new RuntimeException(shelvesCode+"设置的目标库位不存在");
                    }

                    //库位跟推荐库位不一致
                    if(!task.getShelvesCode().equals(shelvesCode)){
                        //上架数+缺货数跟待上架数不一致，则需要新增记录
                        if(!task.getAmount().equals((putawayAmount + shortAmount))){
                            task.setAmount(task.getAmount() - putawayAmount -shortAmount);
                            WhWmsWaitPutawayTask newTask = new WhWmsWaitPutawayTask();
                            newTask.setAmount(putawayAmount + shortAmount);
                            newTask.setPutawayUserId(Integer.parseInt(operationId.toString()));
                            newTask.setPutawayTime(Calendar.getInstance().getTime());
                            newTask.setStatus(2);
                            newTask.setBarCode(task.getBarCode());
                            newTask.setBatchNo(task.getBatchNo());
                            newTask.setHouseType(tarVo.getHouseType());
                            newTask.setPhysicalWarehouseCode(tarVo.getPhysicalWarehouseCode());
                            newTask.setSkuStatus(task.getSkuStatus());
                            newTask.setSkuCode(task.getSkuCode());
                            newTask.setPutawayAmount(putawayAmount);
                            newTask.setShelvesCode(tarVo.getCode());
                            newTask.setShortAmount(shortAmount);
                            Integer id = mapper.insert(newTask);
                            WhWmsWaitPutawayTask whWmsWaitPutawayTask = mapper.selectByPrimaryKey(Long.parseLong(id.toString()));
                            whWmsWaitPutawayTask.setCode("SJ"+id);
                            mapper.updateByPrimaryKey(whWmsWaitPutawayTask);
                            if(task.getAmount().equals(task.getShortAmount()+task.getPutawayAmount())){
                                task.setStatus(2);
                            }
                            mapper.updateByPrimaryKey(task);
                        }else{
                            task.setShelvesCode(shelvesCode);
                            task.setHouseType(tarVo.getHouseType());
                            task.setPutawayAmount(putawayAmount);
                            task.setShortAmount(shortAmount);
                            task.setStatus(2);
                            task.setPutawayTime(Calendar.getInstance().getTime());
                            task.setPutawayUserId(Integer.parseInt(operationId.toString()));
                            mapper.updateByPrimaryKey(task);
                        }
                    }else{
                        task.setPutawayAmount((task.getPutawayAmount() == null?0:task.getPutawayAmount()) + putawayAmount);
                        task.setShortAmount((task.getShortAmount() == null?0:task.getShortAmount()) + shortAmount);
                        if(task.getAmount().equals(task.getShortAmount() + task.getPutawayAmount())){
                            task.setStatus(2);
                        }
                        task.setPutawayTime(Calendar.getInstance().getTime());
                        task.setPutawayUserId(Integer.parseInt(operationId.toString()));
                        mapper.updateByPrimaryKey(task);
                    }
                    WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
                    cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
                    cond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
                    List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
                    WhWmsHouseShelvesVO shelves = null;
                    if(shelvesList != null && shelvesList.size() > 0){
                        shelves = shelvesList.get(0);
                    }else{
                        throw new RuntimeException("请先设置收货暂存区库位");
                    }
                    //扣减收货区库存
                    whWmsSkuStockService.updateStockByCond(-(putawayAmount+shortAmount),shelves.getPhysicalWarehouseCode(),shelves.getHouseType(),task.getBarCode(),shelves.getCode(),task.getSkuCode(),task.getSkuStatus(), WhCommand.TYPE_MOVE_OUT,task.getCode(),operationId,null,2);
                    //增加上架库存
                    if(putawayAmount > 0){
                        whWmsSkuStockService.updateStockByCond(putawayAmount,tarVo.getPhysicalWarehouseCode(),tarVo.getHouseType(),task.getBarCode(),tarVo.getCode(),task.getSkuCode(),task.getSkuStatus(), WhCommand.TYPE_MOVE_IN,task.getCode(),operationId,null,2);
                    }
                    if(shortAmount > 0){
                        //记录差异库存
                        WhWmsHouseShelvesCond diffCond = new WhWmsHouseShelvesCond();
                        diffCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_DIFF);
                        diffCond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
                        List<WhWmsHouseShelvesVO> diffShelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(diffCond);
                        WhWmsHouseShelvesVO diffShelves = null;
                        if(diffShelvesList != null && diffShelvesList.size() > 0){
                            diffShelves = diffShelvesList.get(0);
                        }else{
                            throw new RuntimeException("请先设置差异区库位");
                        }
                        whWmsSkuStockService.updateStockByCond(shortAmount,diffShelves.getPhysicalWarehouseCode(),diffShelves.getHouseType(),task.getBarCode(),diffShelves.getCode(),task.getSkuCode(),task.getSkuStatus(), WhCommand.TYPE_MOVE_IN,task.getCode(),operationId);
                    }
                    //释放占用
//                WhWmsOccupyExample example = new WhWmsOccupyExample();
//                example.createCriteria().andReceiptsNoEqualTo(task.getCode());
//                List<WhWmsOccupy> occupyList = whWmsOccupyMapper.selectByExample(example);
//                if(occupyList != null && occupyList.size() > 0){
//                    for(WhWmsOccupy whWmsOccupy:occupyList){
//                        if(Math.abs(whWmsOccupy.getAmount())==Math.abs(putawayAmount + shortAmount)){
//                            whWmsOccupy.setStatus(0);
//                            whWmsOccupy.setFinishDate(Calendar.getInstance().getTime());
//                        }else{
//                            if(whWmsOccupy.getAmount() < 0){
//                                whWmsOccupy.setAmount(whWmsOccupy.getAmount() + putawayAmount + shortAmount);
//                            }else{
//                                whWmsOccupy.setAmount(whWmsOccupy.getAmount() - putawayAmount - shortAmount);
//                            }
//
//                        }
//                        whWmsOccupyMapper.updateByPrimaryKey(whWmsOccupy);
//                    }
//                }
                    WhWmsWaitPutawayTask lastTask = mapper.selectByPrimaryKey(taskId);
                    int targetAmount = lastTask.getAmount() == null?0:lastTask.getAmount();
                    int realAmount = lastTask.getPutawayAmount() == null?0:lastTask.getPutawayAmount();
                    int shortRealAmount = lastTask.getShortAmount() == null?0:lastTask.getShortAmount();
                    if(realAmount + shortRealAmount > targetAmount){
                        throw new RuntimeException("上架数量大于待上架数量，请刷新后重新录入");
                    }
                }
            }
            return true;
        }finally {
            if(EmptyUtil.isNotEmpty(lockKeyList)){
                redisDistributLock.unLock(lockKeyList);
            }
        }
    }

    /**
     * 效期商品
     * 相同sku，不同批次不能使用同一个库位
     * @param vo
     * @param taskIds
     * @param waitPutawayTaskMap
     * @param shelfLifeMap
     */
    private void checkSampleShelvesByShelfLife(WhWmsPutawayExcuVO vo, List<Long> taskIds, Map<Long, WhWmsWaitPutawayTask> waitPutawayTaskMap, Map<String, Integer> shelfLifeMap) {
        Map<String, Set<String>> barCodeShelvesCodeMap = new HashMap<>();
        String shelvesCode = "";
        StringBuilder sbMsg = new StringBuilder();
        for(int i = 0 ;i < vo.getTaskId().size();i++){
            taskIds.add(vo.getTaskId().get(i));
            shelvesCode = vo.getShelvesCode().get(i);
            WhWmsWaitPutawayTask taskTmp = waitPutawayTaskMap.get(vo.getTaskId().get(i));
            Integer shelfLife = shelfLifeMap.get(taskTmp.getSkuCode());
            String key = "["+taskTmp.getSkuCode()+"]["+shelvesCode+"]";
            if (shelfLife != null && shelfLife > 0){
                Set<String> barCodes = barCodeShelvesCodeMap.get(key);
                if (CollectionUtils.isEmpty(barCodes)){
                    barCodes = new HashSet<>();
                    barCodeShelvesCodeMap.put(key, barCodes);
                }
                barCodes.add(taskTmp.getBarCode());
            }
        }
        barCodeShelvesCodeMap.entrySet().forEach(entry -> {
            if (entry.getValue().size() > 1){
                for (String barCode : entry.getValue()){
                    sbMsg.append("效期商品，不同批次的商品不能放在同一库位!"+entry.getKey()+",批次["+barCode+"]</br>");
                }
            }
        });
        /*for (Map.Entry<String, Set<String>>entry : barCodeShelvesCodeMap.entrySet()){
            if (entry.getValue().size() > 1){
                for (String barCode : entry.getValue()){
                    sbMsg.append("效期商品，不同批次的商品不能放在同一库位!"+entry.getKey()+",批次["+barCode+"]</br>");
                }
            }
        }*/

        if (sbMsg.length() > 0){
            throw new WarehouseException(
                    WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    sbMsg.toString());
        }
    }

}
