package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuPickShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2016/3/23.
 */
@Service("whWmsWaitPutawayService")
public class WhWmsWaitPutawayServiceImpl implements WhWmsWaitPutawayService {

    private final Logger log = LoggerFactory.getLogger(WhWmsWaitPutawayServiceImpl.class);

    @Autowired
    private WhWmsWaitPutawayMapper mapper;

    @Autowired
    private WhWmsOccupyService whWmsOccupyService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;

    @Autowired
    private WhWmsWaitPutawayTaskService whWmsWaitPutawayTaskService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsWarehouseAreaMapper whWmsWarehouseAreaMapper;
    @Autowired
    private WhCommandMapper whCommandMapper;
    @Autowired
    private WhCommandSkuMapper whCommandSkuMapper;
    @Autowired
    private WhWmsSkuBarcodeMapper whWmsSkuBarcodeMapper;

    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;

    @Override
    public WhWmsWaitPutawayVO create(WhWmsWaitPutawayVO waitPutawayVO) {
        WhWmsWaitPutaway waitPutaway = BeanUtil.buildFrom(waitPutawayVO, WhWmsWaitPutaway.class);
        mapper.insert(waitPutaway);
        waitPutawayVO.setId(waitPutaway.getId());
        return waitPutawayVO;
    }

    @Override
    public Boolean update(WhWmsWaitPutawayVO waitPutawayVO) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(waitPutawayVO,WhWmsWaitPutaway.class))!=0;
    }

    @Override
    public WhWmsWaitPutawayVO findById(Long id) {
        WhWmsWaitPutaway waitPutaway = mapper.selectByPrimaryKey(id);
        if(waitPutaway!=null){
            return BeanUtil.buildFrom(waitPutaway,WhWmsWaitPutawayVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsWaitPutawayVO> findWmsWaitPutawayByReceiptsNo(String receiptsNo) {
        return mapper.findWmsWaitPutawayByReceiptsNo(receiptsNo);
    }

    @Override
    public Pagination<WhWmsWaitPutawayVO> findPutawayList(WhWmsWaitPutawayVO vo) {
        Pagination<WhWmsWaitPutawayVO> pagination = new Pagination<>(vo.getCurrpage(),vo.getPagenum());
        pagination.setRecord(mapper.findWaitPutawayCountByCond(vo));
        pagination.setResultList(mapper.findWaitPutawayListByCond(vo));
        return pagination;
    }

    @Override
    public Pagination<WhWmsWaitPutawayVO> getPutawayListBySkuCode(WhWmsWaitPutawayVO vo) {
        Pagination<WhWmsWaitPutawayVO> pagination = new Pagination<>(vo.getCurrpage(),vo.getPagenum());
        pagination.setRecord(mapper.findSKUWaitPutawayCountByCond(vo));
        pagination.setResultList(mapper.findSKUWaitPutawayListByCond(vo));
        return pagination;
    }

    @Override
    public List<WhWmsWaitPutawayVO> listPutawayListBySkuCode(WhWmsWaitPutawayVO waitPutawayVO) {
        return mapper.findSKUWaitPutawayListByCond(waitPutawayVO);
    }

    @Override
    public Pagination<WhWmsWaitPutawayVO> findPutawayTaskList(WhWmsWaitPutawayVO vo) {
        Pagination<WhWmsWaitPutawayVO> pagination = new Pagination<>(vo.getCurrpage(),vo.getPagenum());
        pagination.setRecord(mapper.findPutawayTaskCountByCond(vo));
        pagination.setResultList(mapper.findPutawayTaskListByCond(vo));
        return pagination;
    }


    @Override
    public boolean isReceiveOver(String cmdCode) {
        List<String> list = mapper.isReceiveOver(cmdCode);
        if(list != null && list.size() > 0) return false;
        return true;
    }

    /**
     * 查询要打印的上架清单
     * @param vo
     * @return
     */
    @Override
    public List<WhWmsWaitPutawayVO> findPrintPutawayOrder(WhWmsPutawaySearchVO vo) {
        return mapper.findPrintPutawayOrderList(vo);
    }


    /**
     * 上架开始
     * @param waitPutawayVO
     * @return
     */
    @Override
    public String startPutaway(WhWmsWaitPutawayVO waitPutawayVO) {
        List<WhWmsStartPutawayVO> pvoList= waitPutawayVO.getStartPutList();
        String batchNo =DateUtil.format(new Date(),"yyyyMMddHHmmss")+StringUtil.getRandomString(3,StringUtil.randomInts);//上架批次生成
        Map<String,Integer> amountMap=new HashMap();
        Map<String,WhWmsStartPutawayVO> taskVoMap=new HashMap();
        String warnMessage = null;
        List<WhWmsStartPutawayVO> newList = new ArrayList<>();
        for(WhWmsStartPutawayVO vo:pvoList){
            WhWmsWaitPutaway whWmsWaitPutaway = mapper.selectByPrimaryKey(vo.getId());
            if(whWmsWaitPutaway.getBatchNo() == null){
                vo.setInOutType(whWmsWaitPutaway.getInOutType());
                newList.add(vo);
            }
        }
        pvoList = newList;
        //获取sku是否定制
        prepareStartPutawayVO(pvoList);
        //STEP1:以barcode+skuStatus+inOutType汇总VO对象
        for(WhWmsStartPutawayVO pvo:pvoList) {
            pvo.setPhysicalWarehouseCode(waitPutawayVO.getPhysicalWarehouseCode());
            String key = pvo.getBarCode() + pvo.getSkuStatus()+pvo.getInOutType();
            if (amountMap.containsKey(key)) {
                Integer countVal = parseInteger(amountMap.get(key) + pvo.getReceiveAmount());
                amountMap.put(key, countVal);
            } else {
                amountMap.put(key, pvo.getReceiveAmount());
            }
        }
        for(WhWmsStartPutawayVO pvo:pvoList) {
            String key = pvo.getBarCode() + pvo.getSkuStatus()+pvo.getInOutType();
            if(amountMap.containsKey(key)) {
                pvo.setReceiveAmount(amountMap.get(key));
                taskVoMap.put(key, pvo);
            }
        }
        Set<Map.Entry<String, WhWmsStartPutawayVO>> entrySet = taskVoMap.entrySet();
        Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map = new HashMap<>();
        for (Map.Entry<String, WhWmsStartPutawayVO> entry : entrySet) {
            WhWmsStartPutawayVO  pvo=entry.getValue();
            //STEP2:根据汇总后的VO推荐库位
            List<WhWmsHouseShelves> shelvesList = recommendWmsHouseShelves(pvo,map);
            if(shelvesList != null && shelvesList.size() > 0){
                WhWmsHouseShelves whWmsHouseShelves = shelvesList.get(shelvesList.size()-1);
                if(whWmsHouseShelves.getWarnMessage() != null && !whWmsHouseShelves.getWarnMessage().equals("")){
                    warnMessage = whWmsHouseShelves.getWarnMessage();
                    shelvesList.remove(shelvesList.size()-1);
                }
            }
            map.put(pvo,shelvesList);
            //STEP3:记录上架任务
            savePutawayTask(pvo,shelvesList,batchNo);
        }
        //STEP5:更新待上架表状态
        List<Long> idList = new ArrayList<>();
        for(WhWmsStartPutawayVO pvo:pvoList) {
            //putawayInfoUpdate(pvo,batchNo);
            idList.add(pvo.getId());
        }
        putawayInfoStatusInPutaway(idList,batchNo);
        if(warnMessage != null && !warnMessage.equals("")){
            batchNo = batchNo + "," + warnMessage;
        }
        return batchNo;
    }

    private void putawayInfoStatusInPutaway(List<Long> ids,String batchNo){
        if(EmptyUtil.isEmpty(ids)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"上架参数异常");
        }
        int size = ids.size();
        int count = mapper.putawayInfoUpdate(batchNo,WhWmsWaitPutaway.STATUS_IN_PUTAWAY,WhWmsWaitPutaway.STATUS_WAIT_PUTAWAY,ids);
        if(count != size){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"上架状态异常");
        }
    }


    private List<WhWmsHouseShelves> recommendCustomizationSkuHouseShelves(WhWmsStartPutawayVO pvo,Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map){
        List<WhWmsHouseShelves> retList = new ArrayList<>();
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(pvo.getSkuStatus())){
            //良品
            WhWmsHouseShelvesCond shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            shelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_CUSTOMIZATION);
            List<WhWmsHouseShelves> hsList = whWmsHouseShelvesService.getHouseShelvesByCondNoPage(shelvesCond);
            if(EmptyUtil.isEmpty(hsList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无定制库位");
            }
            WhWmsHouseShelves shelves = hsList.get(0);
            distributShelves(999999999,shelves.getPhysicalWarehouseCode(),shelves.getHouseType(),shelves.getCode(),pvo.getReceiveAmount(),retList,map);
        }
        return retList;
    }

    /*
    *推荐库位
    */
    private List<WhWmsHouseShelves> recommendWmsHouseShelves(WhWmsStartPutawayVO pvo,Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map) {
        StringBuffer warnMessage = new StringBuffer();
        //需要上架数量
        Integer putAmount = pvo.getReceiveAmount();
        List<WhWmsHouseShelves> retList = new ArrayList<>();
        WhWmsShelvesSkuInfo whWmsShelvesSkuInfo = whWmsShelvesSkuInfoService.getSkuInfoByCode(pvo.getSkuCode());

        List<WhWmsSkuPickShelves> skuPickShelves = null;
        if (EmptyUtil.isNotEmpty(whWmsShelvesSkuInfo)){
            // sku库位信息
            WhWmsSkuPickShelvesCond skuPickCond = new WhWmsSkuPickShelvesCond();
            skuPickCond.setSkuCode(whWmsShelvesSkuInfo.getSkuCode());
            skuPickCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            skuPickShelves = whWmsShelvesSkuInfoService.listSkuPickShelvesByCond(skuPickCond);
        }
        final Map<String,WhWmsWarehouseArea> areaMap = whWmsWarehouseAreaService.getAreaHouseMapByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
        /*if(whWmsShelvesSkuInfo != null){
            skuMaxAmount = whWmsShelvesSkuInfo.getMaxAmount();
        }else{
            skuMaxAmount = 99999999;
        }*/
        //sku最大保管量
        Integer skuMaxAmount = null;
        if(CollectionUtils.isNotEmpty(skuPickShelves)){
            skuMaxAmount = skuPickShelves.get(0).getMaxAmount();
        }
        if (EmptyUtil.isEmpty(skuMaxAmount)){
            skuMaxAmount = 99999999;
        }
        //良品
        if (WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(pvo.getSkuStatus())) {
            if(pvo.isCustomization()){
                //定制良品推荐
                return recommendCustomizationSkuHouseShelves(pvo,map);
            }
            List<WhWmsHouseShelves> hsList = checkIsRelatedToSku(pvo.getPhysicalWarehouseCode(),pvo.getSkuCode(), WhWmsWarehouseAreaVO.TYPE_NORMAL,warnMessage,pvo.getStorageType());
            houseShelvesSort(hsList,areaMap,pvo.getSkuCode(),pvo.getSkuStatus());//排序
            //推荐拣货区
            if(hsList != null){
                for (WhWmsHouseShelves hs : hsList) {
                    putAmount = distributShelves(skuMaxAmount,hs.getPhysicalWarehouseCode(),hs.getHouseType(),hs.getCode(),putAmount,retList,map);
                    if(putAmount <= 0){
                        break;
                    }
                }
            }
            //推荐拣货区已存在库存的库位
            if(putAmount > 0){
                WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
                example.createCriteria().andTypeEqualTo(WhWmsWarehouseAreaVO.TYPE_NORMAL);
                List<WhWmsWarehouseArea> whWmsWarehouseAreaList = whWmsWarehouseAreaMapper.selectByExample(example);
                List<String> houseTypeList = new ArrayList<>();
                for(WhWmsWarehouseArea whWmsWarehouseArea:whWmsWarehouseAreaList){
                    houseTypeList.add(whWmsWarehouseArea.getHouseType());
                }
                //首先分配拣货区相同barcode所在库位
                List<WhWmsSkuStock> smHs = findSameBatch(pvo,houseTypeList);
                if (smHs != null && smHs.size() > 0) {
                    for(WhWmsSkuStock putawayVO :smHs){
                        WhWmsHouseShelvesVO whWmsHouseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(putawayVO.getShelvesCode());
                        if(whWmsHouseShelvesVO.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING) && whWmsHouseShelvesVO.getStorageType().equals(pvo.getStorageType()) && whWmsHouseShelvesVO.getSkuStatus().equals(pvo.getSkuStatus())){
                            putAmount = distributShelves(skuMaxAmount,putawayVO.getPhysicalWarehouseCode(),putawayVO.getHouseType(),putawayVO.getShelvesCode(),putAmount,retList,map);
                            if(putAmount <= 0){
                                break;
                            }
                        }
                    }
                }
            }
            //推荐保管区
            if (putAmount > 0) {
                distributeByRule(pvo,skuMaxAmount,putAmount,retList,WhWmsWarehouseAreaVO.TYPE_NORMAL,WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING,pvo.getStorageType(),pvo.getSkuStatus(),map);
            }
        } else if (WhWarehouseVO.isDamagedCommodity(pvo.getSkuStatus())
                || WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(pvo.getSkuStatus())
                || WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(pvo.getSkuStatus())) {//残次或样品或废品
//            String houseType = null;
//            if (pvo.getSkuStatus() == WMSConstants.WMS_SKU_STATUS_DEFECTIVE) {
//                houseType = WhWmsWarehouseAreaVO.HOUSE_TYPE_DEFECTIVE;
//            } else if (pvo.getSkuStatus() == WMSConstants.WMS_SKU_STATUS_SAMPLE) {
//                houseType = WhWmsWarehouseAreaVO.HOUSE_TYPE_SAMPLE;
//            }
            //推荐残次区或者样品区
            distributeByRule(pvo,skuMaxAmount,putAmount,retList,WhWmsWarehouseAreaVO.TYPE_NORMAL,WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING,pvo.getStorageType(),pvo.getSkuStatus(),map);
        }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(pvo.getSkuStatus())
                    || WhWarehouseVO.COMMODITY_STATUS_FOR_PROP.equals(pvo.getSkuStatus())){
            //陈列品区
            WhWmsHouseShelvesCond shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            shelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_EXHIBITS);
            List<WhWmsHouseShelves> hsList = whWmsHouseShelvesService.getHouseShelvesByCondNoPage(shelvesCond);
            if(EmptyUtil.isEmpty(hsList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无陈列库位");
            }
            WhWmsHouseShelves shelves = hsList.get(0);
            distributShelves(Integer.MAX_VALUE,shelves.getPhysicalWarehouseCode(),shelves.getHouseType(),shelves.getCode(),pvo.getReceiveAmount(),retList,map);
        }else if(WhWmsCommandInfoVO.TYPE_PURCHASE_IN.equals(pvo.getInOutType())
                && WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING.equals(pvo.getSkuStatus())){
            // 采购入库 且 商品状态=待定  默认上架库位推荐待定区的库位
            // 待定商品区
            WhWmsHouseShelvesCond shelvesCond = new WhWmsHouseShelvesCond();
            shelvesCond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            shelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HOLD_PENDING);
            List<WhWmsHouseShelves> hsList = whWmsHouseShelvesService.getHouseShelvesByCondNoPage(shelvesCond);
            if(EmptyUtil.isEmpty(hsList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无待定商品区库位");
            }
            WhWmsHouseShelves shelves = hsList.get(0);
            distributShelves(Integer.MAX_VALUE,shelves.getPhysicalWarehouseCode(),shelves.getHouseType(),shelves.getCode(),pvo.getReceiveAmount(),retList,map);
        }
        if(warnMessage.length() > 0){
            WhWmsHouseShelves myShelves = new WhWmsHouseShelves();
            myShelves.setWarnMessage(warnMessage.toString());
            retList.add(myShelves);
        }
        return retList;
    }

    //库位排序-库区拣货顺序升序+库位库存降序
    private void houseShelvesSort(List<WhWmsHouseShelves> hsList,final Map<String,WhWmsWarehouseArea> areaMap,String skuCode,Integer skuStatus){
        if(EmptyUtil.isNotEmpty(hsList)){
            WhWmsHouseShelves oneShelves = hsList.get(0);
            List<String> shelvesCodes = new ArrayList<>();
            for(WhWmsHouseShelves houseShelves : hsList){
                shelvesCodes.add(houseShelves.getCode());
            }
            final Map<String,Integer> shelvesStockMap = shelvesStockGroupBySku(oneShelves.getPhysicalWarehouseCode(),skuCode,skuStatus,shelvesCodes);
            Collections.sort(hsList, new Comparator<WhWmsHouseShelves>() {
                @Override
                public int compare(WhWmsHouseShelves o1, WhWmsHouseShelves o2) {
                    WhWmsWarehouseArea a1 = areaMap.get(o1.getHouseType());
                    WhWmsWarehouseArea a2 = areaMap.get(o2.getHouseType());
                    Integer sortOrder1 = a1.getSortOrder();
                    Integer sortOrder2 = a2.getSortOrder();
                    if(NullUtil.isNull(sortOrder1)){
                        sortOrder1 = Integer.MAX_VALUE;
                    }
                    if(NullUtil.isNull(sortOrder2)){
                        sortOrder2 = Integer.MAX_VALUE;
                    }
                    int result = sortOrder1.compareTo(sortOrder2);
                    if(result == 0){
                        Integer stock1 = shelvesStockMap.get(o1.getCode());
                        Integer stock2 = shelvesStockMap.get(o2.getCode());
                        if(NullUtil.isNull(stock1)){
                            stock1 = 0;
                        }
                        if(NullUtil.isNull(stock2)){
                            stock2 = 0;
                        }
                        result = -(stock1.compareTo(stock2));
                    }
                    return result;
                }
            });
        }
    }

    private Map<String,Integer> shelvesStockGroupBySku(String physicalWarehouseCode,String skuCode,Integer skuStatus,List<String> shelvesCodes){
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        cond.setSkuCode(skuCode);
        cond.setShelvesCodeList(shelvesCodes);
        List<WhWmsSkuStockVO> stockList = whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
        Map<String,Integer> shelvesStockMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(stockList)){
            for(WhWmsSkuStockVO skuStock : stockList){
                Integer total = shelvesStockMap.get(skuStock.getShelvesCode());
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                shelvesStockMap.put(skuStock.getShelvesCode(),total+skuStock.getTotalAmount());
            }
        }
        return shelvesStockMap;
    }

    /**
     * 推荐库位
     * */
    @Override
    public List<WhWmsMoveSkuVO> recommendWmsHouseShelves(List<WhWmsStartPutawayVO> pvoList){
        Map<String,Integer> amountMap=new HashMap<>();
        Map<String,WhWmsStartPutawayVO> taskVoMap=new HashMap<>();
        List<String> skuCodes = new ArrayList<>();
        //STEP1:以barcode+skuStatus+shelvescode汇总VO对象
        for(WhWmsStartPutawayVO pvo : pvoList){
            String key = pvo.getBarCode() + pvo.getSkuStatus()+pvo.getSourceShelvesVO().getCode();
            skuCodes.add(pvo.getSkuCode());
            if (amountMap.containsKey(key)) {
                Integer tmp = amountMap.get(key) + pvo.getReceiveAmount();
                Integer countVal = 0;
                if(tmp != null){
                    countVal = tmp;
                }
                amountMap.put(key, countVal);
            } else {
                amountMap.put(key, pvo.getReceiveAmount());
            }
        }
        //获取sku是否定制
        prepareStartPutawayVO(pvoList);
        for(WhWmsStartPutawayVO pvo:pvoList) {
            String key = pvo.getBarCode() + pvo.getSkuStatus()+pvo.getSourceShelvesVO().getCode();
            if(amountMap.containsKey(key)) {
                pvo.setReceiveAmount(amountMap.get(key));
                taskVoMap.put(key, pvo);
            }
        }
        String warnMessage = null;
        Set<Map.Entry<String, WhWmsStartPutawayVO>> entrySet = taskVoMap.entrySet();
        Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map = new HashMap<>();
        for (Map.Entry<String, WhWmsStartPutawayVO> entry : entrySet) {
            WhWmsStartPutawayVO  pvo=entry.getValue();
            //STEP2:根据汇总后的VO推荐库位
            List<WhWmsHouseShelves> shelvesList = recommendWmsHouseShelves(pvo,map);
            if(shelvesList != null && shelvesList.size() > 0){
                WhWmsHouseShelves whWmsHouseShelves = shelvesList.get(shelvesList.size()-1);
                if(whWmsHouseShelves.getWarnMessage() != null && !whWmsHouseShelves.getWarnMessage().equals("")){
                    warnMessage = whWmsHouseShelves.getWarnMessage();
                    shelvesList.remove(shelvesList.size()-1);
                }
            }
            map.put(pvo,shelvesList);
        }
        //生成移库行
        List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
        if(EmptyUtil.isEmpty(map)){
            return moveStockSkuList;
        }
        for(WhWmsStartPutawayVO pvo : map.keySet()){
            List<WhWmsHouseShelves> shelvesList = map.get(pvo);
            WhWmsHouseShelvesVO sourceShelvesVO = pvo.getSourceShelvesVO();
            for(WhWmsHouseShelves hs : shelvesList){
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(pvo.getSkuCode());
                moveSkuVO.setSkuStatus(pvo.getSkuStatus());
                moveSkuVO.setBarCode(pvo.getBarCode());
                moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                moveSkuVO.setTargetHouseType(hs.getHouseType());
                moveSkuVO.setTargetShelvesCode(hs.getCode());
                moveSkuVO.setAmount(hs.getMaxAmount());
                moveStockSkuList.add(moveSkuVO);
            }
        }

        return moveStockSkuList;
    }

    //填充数据
    private void prepareStartPutawayVO(List<WhWmsStartPutawayVO> pvoList){
        if(EmptyUtil.isEmpty(pvoList)){
            return;
        }
        List<String> skuCodes = new ArrayList<>();
        for(WhWmsStartPutawayVO putawayVO : pvoList){
            skuCodes.add(putawayVO.getSkuCode());
        }
        //获取sku是否定制
        Map<String,WhWmsSkuInfoVO> skuInfoMap = new HashMap<>();
        List<WhWmsSkuInfoVO> skuList = mapper.findWmsSkuInfoBySkuCodes(skuCodes);
        if(EmptyUtil.isNotEmpty(skuList)){
            for(WhWmsSkuInfoVO skuInfo : skuList ){
                skuInfoMap.put(skuInfo.getCode(),skuInfo);
            }
        }
        for(WhWmsStartPutawayVO pvo:pvoList) {
            boolean customization = false;
            WhWmsSkuInfoVO skuInfo = skuInfoMap.get(pvo.getSkuCode());
            if(NullUtil.isNotNull(skuInfo)
                    && NullUtil.isNotNull(skuInfo.getCanCustomize())
                    && skuInfo.getCanCustomize()==1){
                customization = true;
            }
            pvo.setCustomization(customization);
        }
    }

    /**
     * 按规则分配库位， 先分配相同barcode库位，在分配空库位，最后分配混载库位
     * @param pvo
     * @param skuMaxAmount
     * @param putAmount
     * @param retList
     */
    private void distributeByRule(WhWmsStartPutawayVO pvo,int skuMaxAmount,int putAmount,List<WhWmsHouseShelves> retList,String type,Integer shelvesType,Integer storageType,Integer skuStatus,Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map){
        WhWmsWarehouseAreaExample example = new WhWmsWarehouseAreaExample();
        example.createCriteria().andTypeEqualTo(type);
        List<WhWmsWarehouseArea> whWmsWarehouseAreaList = whWmsWarehouseAreaMapper.selectByExample(example);
        List<String> houseTypeList = new ArrayList<>();
        for(WhWmsWarehouseArea whWmsWarehouseArea:whWmsWarehouseAreaList){
            houseTypeList.add(whWmsWarehouseArea.getHouseType());
        }
        //首先分配保管区相同barcode所在库位
        List<WhWmsSkuStock> smHs = findSameBatch(pvo,houseTypeList);

        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        if (smHs != null && smHs.size() > 0) {
            cond.setShelvesType(shelvesType);
            cond.setStorageType(storageType);
            cond.setSkuStatus(skuStatus);
            for(WhWmsSkuStock putawayVO :smHs){
                cond.setCode(putawayVO.getShelvesCode());
                List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
                if (CollectionUtils.isNotEmpty(whWmsHouseShelvesVOs)){
                    boolean isDistribute = isDistribut(map,putawayVO.getShelvesCode());
                    if(!isDistribute){
                        putAmount = distributShelves(skuMaxAmount,putawayVO.getPhysicalWarehouseCode(),putawayVO.getHouseType(),putawayVO.getShelvesCode(),putAmount,retList,map);
                        if(putAmount <= 0){
                            break;
                        }
                    }
                }
                /*WhWmsHouseShelvesVO whWmsHouseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(putawayVO.getShelvesCode());
                if(whWmsHouseShelvesVO.getShelvesType().equals(shelvesType) && whWmsHouseShelvesVO.getStorageType().equals(storageType) && whWmsHouseShelvesVO.getSkuStatus().equals(skuStatus)){
                    boolean isDistribute = isDistribut(map,putawayVO.getShelvesCode());
                    if(!isDistribute){
                        putAmount = distributShelves(skuMaxAmount,putawayVO.getPhysicalWarehouseCode(),putawayVO.getHouseType(),putawayVO.getShelvesCode(),putAmount,retList,map);
                        if(putAmount <= 0){
                            break;
                        }
                    }
                }*/
            }
        }
        final Map<String,WhWmsWarehouseArea> areaMap = whWmsWarehouseAreaService.getAreaHouseMapByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
        //第二步，在空库位进行分配
        if(putAmount > 0){
            cond=new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            cond.setType(type);
            cond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);//库位 可用状态
            cond.setShelvesStatus(WhWmsHouseShelvesVO.SHELVES_STATUS_UNOCCUPY); // 空库位

            cond.setShelvesType(shelvesType);
            cond.setStorageType(storageType);
            cond.setSkuStatus(skuStatus);

            // List<WhWmsHouseShelves> hsList2 = this.findHouseShelves(pvo.getPhysicalWarehouseCode(), type, 0,0,null);
            List<WhWmsHouseShelves> hsList2 = this.findHouseShelvesByCondNoPage(cond);
            houseShelvesSort(hsList2,areaMap,pvo.getSkuCode(),skuStatus);//排序
            for (WhWmsHouseShelves hs : hsList2) {
                boolean isDistribute = isDistribut(map,hs.getCode());
                if(!isDistribute){
                    putAmount = distributShelves(skuMaxAmount,hs.getPhysicalWarehouseCode(),hs.getHouseType(),hs.getCode(),putAmount,retList,map);
                    if(putAmount <= 0){
                        break;
                    }
                }
                // WhWmsHouseShelvesVO whWmsHouseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(hs.getCode());
                /*if(whWmsHouseShelvesVO.getShelvesType().equals(shelvesType) && whWmsHouseShelvesVO.getStorageType().equals(storageType) && whWmsHouseShelvesVO.getSkuStatus().equals(skuStatus)){
                    boolean isDistribute = isDistribut(map,hs.getCode());
                    if(!isDistribute){
                        putAmount = distributShelves(skuMaxAmount,hs.getPhysicalWarehouseCode(),hs.getHouseType(),hs.getCode(),putAmount,retList,map);
                        if(putAmount <= 0){
                            break;
                        }
                    }
                }*/
            }
        }
        //第三步分配可混载库位
        if(putAmount > 0){
            cond=new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(pvo.getPhysicalWarehouseCode());
            cond.setType(type);
            cond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);// 库位可用状态: 可用[0]
            cond.setShelvesStatus(WhWmsHouseShelvesVO.SHELVES_STATUS_OCCUPY); // 库位状态:库存库位[1]
            cond.setMixedType(WhWmsHouseShelvesVO.MIXED_TYPE_MULTI); // 混载类型:单品多批[2]
            // List<WhWmsHouseShelves> hsList2 = this.findHouseShelves(pvo.getPhysicalWarehouseCode(), type, 0,1,2);
            List<WhWmsHouseShelves> hsList2 = this.findHouseShelvesByCondNoPage(cond);
            houseShelvesSort(hsList2,areaMap,pvo.getSkuCode(),skuStatus);//排序
            for (WhWmsHouseShelves hs : hsList2) {
                WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO();
                whWmsSkuStockVO.setSkuCode(pvo.getSkuCode());
                whWmsSkuStockVO.setShelvesCode(hs.getCode());
                whWmsSkuStockVO.setPhysicalWarehouseCode(hs.getPhysicalWarehouseCode());
                whWmsSkuStockVO.setHouseType(hs.getHouseType());
                List<WhWmsSkuStockVO> list = whWmsSkuStockService.getWmsSkuStockByCond(whWmsSkuStockVO);
                boolean isHasSameBarcode = false;
                if(list != null && list.size() > 0){
                    for(WhWmsSkuStockVO whWmsSkuStockVO1 :list){
                        if(whWmsSkuStockVO1.getAmount() > 0 && !whWmsSkuStockVO1.getBarCode().equals(pvo.getBarCode())){
                            isHasSameBarcode = true;
                        }
                    }
                }
                if(!isHasSameBarcode){
                    WhWmsHouseShelvesVO whWmsHouseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(hs.getCode());
                    if(whWmsHouseShelvesVO.getShelvesType().equals(shelvesType) && whWmsHouseShelvesVO.getStorageType().equals(storageType) && whWmsHouseShelvesVO.getSkuStatus().equals(skuStatus)){
                        boolean isDistribute = isDistribut(map,hs.getCode());
                        if(!isDistribute){
                            putAmount = distributShelves(skuMaxAmount,hs.getPhysicalWarehouseCode(),hs.getHouseType(),hs.getCode(),putAmount,retList,map);
                            if(putAmount <= 0){
                                break;
                            }
                        }
                    }
                }
            }
        }
        //推荐本次分配的保管库位
        if(putAmount >0 ){
            for(List<WhWmsHouseShelves> shelvesList:map.values()){
                for(WhWmsHouseShelves whWmsHouseShelves:shelvesList){
                    WhWmsHouseShelvesVO whWmsHouseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(whWmsHouseShelves.getCode());
                    if(whWmsHouseShelvesVO != null && whWmsHouseShelvesVO.getMixedType().equals(WhWmsHouseShelvesVO.MIXED_TYPE_MULTI) && whWmsHouseShelvesVO.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                        if(whWmsHouseShelvesVO.getStorageType().equals(storageType) && whWmsHouseShelvesVO.getSkuStatus().equals(skuStatus)){
                            putAmount = distributShelves(skuMaxAmount,whWmsHouseShelvesVO.getPhysicalWarehouseCode(),whWmsHouseShelvesVO.getHouseType(),whWmsHouseShelvesVO.getCode(),putAmount,retList,map);
                            if(putAmount <= 0){
                                break;
                            }
                        }
                    }
                }
            }
        }
        if(putAmount >0 ){
            throw new RuntimeException("条形码["+pvo.getBarCode()+"],物理仓["+pvo.getPhysicalWarehouseCode()+"],shelvesType["+WhWmsHouseShelvesVO.getShelvesTypeNameStr(shelvesType)+"],storageType["+WhWmsHouseShelvesVO.getStorageTypeStr(storageType)+"],skuStatus["+skuStatus+"]找不到可使用的库位");
        }
    }
    private boolean isDistribut(Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map,String shelvesCode){
        for(List<WhWmsHouseShelves> shelvesList:map.values()) {
            for (WhWmsHouseShelves whWmsHouseShelves : shelvesList) {
                if (whWmsHouseShelves.getCode().equals(shelvesCode)) {
                    return true;
                }
            }
        }
        return false;
    }
    private int distributShelves(int skuMaxAmount,String physicalWarehouseCode,String houseType,String shelvesCode,int putAmount,List<WhWmsHouseShelves> retList,Map<WhWmsStartPutawayVO,List<WhWmsHouseShelves>> map){
        int max = skuMaxAmount;
        Integer shelvesMax = this.getMaxAmountByShelvesCode(physicalWarehouseCode,houseType,shelvesCode);
        if(shelvesMax != null){
            max = shelvesMax;
        }
        WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO();
        whWmsSkuStockVO.setPhysicalWarehouseCode(physicalWarehouseCode);
        whWmsSkuStockVO.setShelvesCode(shelvesCode);
        whWmsSkuStockVO.setHouseType(houseType);
        List<WhWmsSkuStockVO> stockVOList = whWmsSkuStockService.findWmsSkuAvailableAccount(whWmsSkuStockVO);
        if(stockVOList != null && stockVOList.size() > 0) {
            for (WhWmsSkuStockVO whWmsSkuStockVO1 : stockVOList) {
                max = max - whWmsSkuStockVO1.getAvailableAccount();
            }
        }
        for(List<WhWmsHouseShelves> shelvesList:map.values()){
            for(WhWmsHouseShelves whWmsHouseShelves:shelvesList){
                if(whWmsHouseShelves.getCode().equals(shelvesCode)){
                    max -= whWmsHouseShelves.getMaxAmount();
                }
            }
        }
        if(max > 0 && putAmount > 0){
            int changeAmount = 0;
            if(max > putAmount){
                changeAmount = putAmount;
            }else{
                changeAmount = max;
            }
            putAmount = putAmount - changeAmount;
            WhWmsHouseShelves whWmsHouseShelves = new WhWmsHouseShelves();
            whWmsHouseShelves.setHouseType(houseType);
            whWmsHouseShelves.setPhysicalWarehouseCode(physicalWarehouseCode);
            whWmsHouseShelves.setCode(shelvesCode);
            whWmsHouseShelves.setMaxAmount(changeAmount);
            retList.add(whWmsHouseShelves);
            return putAmount;
        }
        return putAmount;
    }
    private Integer getMaxAmountByShelvesCode(String physicalWarehouseCode,String houseType,String shelvesCode){
        WhWmsHouseShelvesCond cond=new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setHouseType(houseType);
        cond.setCode(shelvesCode);
        List<WhWmsHouseShelves> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
        if(shelvesList != null && shelvesList.size() > 0){
            if(shelvesList.get(0).getMaxAmount() != null){
                return shelvesList.get(0).getMaxAmount();
            };
        }
        return null;
    }
    /*
     *以barcode+skuStatus汇总记录上架任务信息
     */
    private void savePutawayTask(WhWmsStartPutawayVO pvo,List<WhWmsHouseShelves> shelvesList,String batchNo) {
        if(shelvesList != null && shelvesList.size() > 0){
            for(WhWmsHouseShelves whWmsHouseShelves:shelvesList){
                WhWmsWaitPutawayTaskVO vo=new WhWmsWaitPutawayTaskVO();
                vo.setPhysicalWarehouseCode(whWmsHouseShelves.getPhysicalWarehouseCode());
                vo.setBarCode(pvo.getBarCode());
                vo.setSkuStatus(pvo.getSkuStatus());
                vo.setAmount(whWmsHouseShelves.getMaxAmount());//需上架数量
                vo.setShelvesCode(whWmsHouseShelves.getCode());
                vo.setBatchNo(batchNo);
                vo.setStatus(WhWmsWaitPutawayTask.STATUS_IN_PUTAWAY);
                vo.setSkuCode(pvo.getSkuCode());
                vo.setHouseType(whWmsHouseShelves.getHouseType());
                vo.setPutawayAmount(0);
                vo.setShortAmount(0);
                vo.setInOutType(pvo.getInOutType());//入库类型
                vo=whWmsWaitPutawayTaskService.create(vo);
                WhWmsWaitPutawayTaskVO vo2=new WhWmsWaitPutawayTaskVO();
                vo2.setId(vo.getId());
                String code="SJ0000"+vo.getId();
                vo2.setCode(code);//上架任务号
                vo.setCode(code);
                whWmsWaitPutawayTaskService.update(vo2);
//                putawayOccupy(vo);
            }
        }
    }

    /*
     *更新待上架表信息
     */
    private void  putawayInfoUpdate(WhWmsStartPutawayVO vo, String batchNo) {
        WhWmsWaitPutaway waitPutaway = mapper.selectByPrimaryKey(vo.getId());
        //waitPutaway.setCode();废弃字段
        waitPutaway.setBatchNo(batchNo);
        waitPutaway.setPutawayStatus(WhWmsWaitPutaway.STATUS_IN_PUTAWAY);
        int count = mapper.updateByPrimaryKeySelective(waitPutaway);
        if(count!=1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]状态异常",vo.getId()));
        }
    }

    /*
     *库存占用
     */
    private void  putawayOccupy(WhWmsWaitPutawayTaskVO whWmsWaitPutawayTaskVO) {
        WhWmsOccupyVO ocpy=new WhWmsOccupyVO();
        ocpy.setSkuCode(whWmsWaitPutawayTaskVO.getSkuCode());
        ocpy.setBarCode(whWmsWaitPutawayTaskVO.getBarCode());
        ocpy.setSkuStatus(whWmsWaitPutawayTaskVO.getSkuStatus());
        ocpy.setAmount(whWmsWaitPutawayTaskVO.getAmount());
        ocpy.setHouseType(whWmsWaitPutawayTaskVO.getHouseType());
        ocpy.setPhysicalWarehouseCode(whWmsWaitPutawayTaskVO.getPhysicalWarehouseCode());
        ocpy.setOriShelvesCode(whWmsWaitPutawayTaskVO.getShelvesCode());
        //ocpy.setType();废弃字段
        ocpy.setReceiptsNo(whWmsWaitPutawayTaskVO.getCode());//用task的code字段
        ocpy.setStatus(WhWmsOccupyVO.OCCUPIED);
        //ocpy.setFinishDate(new Date());
        whWmsOccupyService.wmsOccupy(ocpy);

        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
        cond.setPhysicalWarehouseCode(whWmsWaitPutawayTaskVO.getPhysicalWarehouseCode());
        List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        String receiveShelves = "";
        if(shelvesList != null && shelvesList.size() > 0){
            receiveShelves = shelvesList.get(0).getCode();
        }else{
            throw new RuntimeException("请设置收货区库位");
        }
        WhWmsOccupyVO ocpyRe=new WhWmsOccupyVO();
        ocpyRe.setSkuCode(whWmsWaitPutawayTaskVO.getSkuCode());
        ocpyRe.setBarCode(whWmsWaitPutawayTaskVO.getBarCode());
        ocpyRe.setSkuStatus(whWmsWaitPutawayTaskVO.getSkuStatus());
        ocpyRe.setAmount(-whWmsWaitPutawayTaskVO.getAmount());
        ocpyRe.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
        ocpyRe.setPhysicalWarehouseCode(whWmsWaitPutawayTaskVO.getPhysicalWarehouseCode());
        ocpyRe.setOriShelvesCode(receiveShelves);
        //ocpy.setType();废弃字段
        ocpyRe.setReceiptsNo(whWmsWaitPutawayTaskVO.getCode());//用task的code字段
        ocpyRe.setStatus(WhWmsOccupyVO.OCCUPIED);
        //ocpy.setFinishDate(new Date());
        whWmsOccupyService.wmsOccupy(ocpyRe);
    }

    /*
     *拣货区是否关联SKU
     */
    private List<WhWmsHouseShelves> checkIsRelatedToSku(String physicalWarehouseCode,String skuCode,String type,StringBuffer warnMessage,Integer storageType) {
        WhWmsHouseShelvesCond cond=new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setType(type);
        cond.setSkuCode(skuCode);
        cond.setStorageType(storageType);
        cond.setShelvesType(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
        cond.setSkuStatus(1);
        List<WhWmsHouseShelves> hsList = whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
        if(hsList!=null&&hsList.size()>0) {
            return hsList;
        }else{
            warnMessage.append("["+skuCode+"]未关联拣货库位 \n");
        }
        return null;
    }
    /*
    *查询SKU最大保管量属性
    */
    private int findSkuMaxAmount(String code){
        WhWmsShelvesSkuInfo skuInfo=whWmsShelvesSkuInfoService.getSkuInfoByCode(code);
        return skuInfo!=null?skuInfo.getMaxAmount():0;
    }

    /*
    *查询同一批次的库位相关信息-按拣货顺序+库存降序排序
    */
    private  List<WhWmsSkuStock>  findSameBatch(WhWmsStartPutawayVO vo,List<String> houseTypeList) {
        WhWmsSkuStockExample example = new WhWmsSkuStockExample();
        WhWmsSkuStockExample.Criteria criteria = example.createCriteria();
        criteria.andPhysicalWarehouseCodeEqualTo(vo.getPhysicalWarehouseCode());
        criteria.andHouseTypeIn(houseTypeList);
        criteria.andBarCodeEqualTo(vo.getBarCode());
        criteria.andSkuStatusEqualTo(vo.getSkuStatus());
        criteria.andAmountGreaterThan(0);
        List<WhWmsSkuStock> stockList = whWmsSkuStockService.selectByExample(example);
        if(EmptyUtil.isNotEmpty(stockList)){
            final Map<String,WhWmsWarehouseArea> areaMap = whWmsWarehouseAreaService.getAreaHouseMapByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
            final List<String> shelvesCodes = new ArrayList<>();
            for(WhWmsSkuStock stock : stockList){
                shelvesCodes.add(stock.getShelvesCode());
            }
            List<WhWmsHouseShelves> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCodes);
            if(EmptyUtil.isNotEmpty(shelvesList)){
                houseShelvesSort(shelvesList,areaMap,vo.getSkuCode(),vo.getSkuStatus());
                final Map<String,Integer> shelvesSortedMap = new HashMap<>();
                int i=0;
                for(WhWmsHouseShelves shelves : shelvesList){
                    shelvesSortedMap.put(shelves.getCode(),i++);
                }
                Collections.sort(stockList, new Comparator<WhWmsSkuStock>() {
                    @Override
                    public int compare(WhWmsSkuStock o1, WhWmsSkuStock o2) {
                        Integer s1 = shelvesSortedMap.get(o1.getShelvesCode());
                        Integer s2 = shelvesSortedMap.get(o2.getShelvesCode());
                        return s1.compareTo(s2);
                    }
                });
            }
        }
        return stockList;
    }

    /*
     *查询仓库库位
     */
    private  List<WhWmsHouseShelves>  findHouseShelves(String physicalWarehouseCode,String type,Integer usableStatus,Integer shelvesStatus,Integer mixedType) {
        WhWmsHouseShelvesCond cond=new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setType(type);
        cond.setShelvesUsableStatus(usableStatus);//库位可用状态
        cond.setShelvesStatus(shelvesStatus);
        cond.setMixedType(mixedType);
        return whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
    }

    /*
     *查询仓库库位
     */
    private  List<WhWmsHouseShelves>  findHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond) {
        return whWmsHouseShelvesService.getHouseShelvesByCondNoPage(cond);
    }

    private Integer parseInteger(Integer i) {
        return i == null? 0: i;
    }

    @Override
    public boolean checkQuInfo(WhReceiveShelvesVO vo) {
        WhCommand whCommand = whCommandMapper.selectByPrimaryKey(Long.parseLong(vo.getWhCommandId().toString()));
        if(whCommand != null){
            if(whCommand.getCommandStatus().equals(WhCommand.STATUS_QUALITY_PROCESSING) || whCommand.getCommandStatus().equals(WhCommand.STATUS_WAITING_QUALITY_CONTROL)){
                WhCommandSkuExample example = new WhCommandSkuExample();
                example.createCriteria().andCommandIdEqualTo(whCommand.getId());
                List<WhCommandSku> whCommandSkuList = whCommandSkuMapper.selectByExample(example);
                Map<String,Integer> map = new HashMap<>();
                for(WhCommandSku whCommandSku:whCommandSkuList){
                    Integer amount = map.get(whCommandSku.getSkuCode());
                    if(amount == null){
                        map.put(whCommandSku.getSkuCode(),whCommandSku.getPlanedQuantity());
                    }else{
                        map.put(whCommandSku.getSkuCode(),amount + whCommandSku.getPlanedQuantity());
                    }
                }
                WhWmsWaitPutawayExample whWmsWaitPutawayExample = new WhWmsWaitPutawayExample();
                whWmsWaitPutawayExample.createCriteria().andCommandCodeEqualTo(whCommand.getCode());
                List<WhWmsWaitPutaway> whWmsWaitPutawayList = mapper.selectByExample(whWmsWaitPutawayExample);
                for(WhWmsWaitPutaway whWmsWaitPutaway:whWmsWaitPutawayList){
                    WhWmsSkuBarcodeExample whWmsSkuBarcodeExample = new WhWmsSkuBarcodeExample();
                    whWmsSkuBarcodeExample.createCriteria().andBarCodeEqualTo(whWmsWaitPutaway.getBarCode());
                    List<WhWmsSkuBarcode> barcodeList = whWmsSkuBarcodeMapper.selectByExample(whWmsSkuBarcodeExample);
                    if(barcodeList != null && barcodeList.size() > 0){
                        Integer waitAmount = map.get(barcodeList.get(0).getSkuCode());
                        if(waitAmount != null){
                            map.put(barcodeList.get(0).getSkuCode(),waitAmount-whWmsWaitPutaway.getReceiveAmount());
                        }
                    }
                }

                // 采购入库 此处不再校验收货数量
                if (!WhCommand.TYPE_PURCHASE_IN.equals(vo.getWhInType())){
                    for(WhQualityControlVO whQualityControlVO:vo.getQcList()){
                        Integer remainAmount =  map.get(whQualityControlVO.getQcSku());
                        if(remainAmount != null){
                            remainAmount -= whQualityControlVO.getDefectiveQuantity()==null?0:whQualityControlVO.getDefectiveQuantity();
                            remainAmount -= whQualityControlVO.getNondefectiveQuantity()==null?0:whQualityControlVO.getNondefectiveQuantity();
                            remainAmount -= whQualityControlVO.getSampleQuantity()==null?0:whQualityControlVO.getSampleQuantity();
                            remainAmount -= whQualityControlVO.getWasteQuantity()==null?0:whQualityControlVO.getWasteQuantity();
                            remainAmount -= whQualityControlVO.getDisplayQuantity()==null?0:whQualityControlVO.getDisplayQuantity();
                            remainAmount -= whQualityControlVO.getPropQuantity()==null?0:whQualityControlVO.getPropQuantity();
                            if(remainAmount < 0){
                                throw new RuntimeException(whQualityControlVO.getQcSku()+"的收货数量大于计划收货数量");
                            }else{
                                map.put(whQualityControlVO.getQcSku(),remainAmount);
                            }
                        }
                    }
                }
            }else{
                throw new RuntimeException("单号"+vo.getReferenceCode()+"的状态必须是待质检或质检中才可以质检");
            }
        }else{
            throw new RuntimeException("单号"+vo.getReferenceCode()+"不存在");
        }
        return true;
    }
    @Override
	public List<WhWmsWaitPutaway> getAllRemearkByReceiptsNo(String receiptsNo){
		return mapper.getAllRemearkByReceiptsNo(receiptsNo);
	}

    @Override
    public List<WhWmsWaitPutawayVO> countQcQuantityByCond(List<String> receiptsNos, Integer inOutType) {
        return mapper.countQcQuantityByCond(receiptsNos,inOutType);
    }

    @Override
	public List<WhWmsWaitPutaway> getAllRemearkByCond(WhWmsWaitPutawayVO cond){
		return mapper.getAllRemearkByCond(cond);
	}

    @Override
	public List<WhWmsWaitPutawayVO> findWaitPutawayWasteByCond(WhWmsWaitPutawayVO vo){
		return mapper.findWaitPutawayWasteByCond(vo);
	}

    @Override
    public List<WhWmsWaitPutaway> listWaitPutawayByCond(WhWmsWaitPutawayVO vo){
        WhWmsWaitPutawayExample example = new WhWmsWaitPutawayExample();
        WhWmsWaitPutawayExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(vo.getReceiptsNos())){
            criteria.andReceiptsNoIn(vo.getReceiptsNos());
        }
        if (EmptyUtil.isNotEmpty(vo.getReceiptsNo())){
            criteria.andReceiptsNoEqualTo(vo.getReceiptsNo());
        }
        if (CollectionUtils.isNotEmpty(vo.getIds())){
            criteria.andIdIn(vo.getIds());
        }
        if (EmptyUtil.isNotEmpty(vo.getSkuStatus())){
            criteria.andSkuStatusEqualTo(vo.getSkuStatus());
        }
        if (EmptyUtil.isNotEmpty(vo.getOrderByClause())){
            example.setOrderByClause(vo.getOrderByClause());
        }
        return mapper.selectByExample(example);
    }
}
