package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsTaskAssignCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsTaskAssignMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2016/10/13.
 */
@Service("whWmsTaskAssignService")
public class WhWmsTaskAssignServiceImpl implements WhWmsTaskAssignService {

    @Autowired
    private WhWmsTaskAssignMapper whWmsTaskAssignMapper;

//    @Autowired
//    private WhWmsInventoryManageService whWmsInventoryManagerService;

    @Autowired
    private WhWmsInventoryService whWmsInventoryService;

    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Override
    public List<WhWmsTaskAssignVO> findWhWmsTaskAssignByCond(WhWmsTaskAssignCond cond) {
        return this.whWmsTaskAssignMapper.findWhWmsTaskAssignByCond(cond);
    }

    @Override
    public WhWmsTaskAssignVO findNotFinishedTaskAssign(String referenceCode, Integer type) {
        WhWmsTaskAssignCond cond = new WhWmsTaskAssignCond();
        cond.setReferenceCode(referenceCode);
        cond.setStatus(WhWmsTaskAssignVO.TASK_STATUS_PENDING);
        cond.setType(type);
        List<WhWmsTaskAssignVO> list = findWhWmsTaskAssignByCond(cond);
        if(EmptyUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public WhWmsTaskAssignVO taskAssignAuto(WhWmsTaskAssignReqVO reqVO) {
        if(NullUtil.isNull(reqVO) || NullUtil.isNull(reqVO.getTaskType())
                || EmptyUtil.isEmpty(reqVO.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"参数异常");
        }
        WhWmsTaskAssignCond cond = new WhWmsTaskAssignCond();
        cond.setReferenceCode(reqVO.getReferenceCode());
        cond.setOperatorId(reqVO.getOperatorId());
        cond.setStatus(WhWmsTaskAssignVO.TASK_STATUS_PENDING);
        cond.setType(reqVO.getTaskType());
        cond.setInOutType(reqVO.getInOutType());
        cond.setConnectType(reqVO.getConnectType());
        cond.setConnectTypeList(reqVO.getConnectTypeList());
        cond.setMoveType(reqVO.getMoveType());
        cond.setHouseType(reqVO.getHouseType());
        cond.setInventoryStatus(reqVO.getInventoryStatus());
        cond.setShelvesColumn(reqVO.getShelvesColumn());
        List<WhWmsTaskAssignVO> taskList = whWmsTaskAssignMapper.findWhWmsTaskAssignUnFinishByCond(cond);
        if(EmptyUtil.isNotEmpty(taskList)){
            //有未完成的任务，取最早领取的
            return taskList.get(0);
        }
        WhWmsTaskAssignVO vo = null;
        if(WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU.equals(reqVO.getTaskType())){
            vo = taskAssignConnPickSku(reqVO);
        }else if(WhWmsTaskAssignVO.TASK_TYPE_MOVESHELVES.equals(reqVO.getTaskType())){
            vo = taskAssignMoveShelves(reqVO);
        }else if(WhWmsTaskAssignVO.TASK_TYPE_INVENTORY.equals(reqVO.getTaskType())){
            vo = taskAssignInventory(reqVO);
        }
        afterTaskAssign(vo);
        if(NullUtil.isNotNull(vo)){
            vo.setFirstGetTask(true);
        }
        return vo;
    }

    @Override
    @Transactional
    public WhWmsTaskAssignVO taskAssignAsked(WhWmsTaskAssignReqVO reqVO) {
        if(NullUtil.isNull(reqVO) || NullUtil.isNull(reqVO.getTaskType())
                || EmptyUtil.isEmpty(reqVO.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"参数异常");
        }
        //检查
        checkTaskAsked(reqVO);
        WhWmsTaskAssignCond cond = new WhWmsTaskAssignCond();
        cond.setReferenceCode(reqVO.getReferenceCode());
        cond.setType(reqVO.getTaskType());
        List<WhWmsTaskAssignVO> assignedList = findWhWmsTaskAssignByCond(cond);
        if(EmptyUtil.isNotEmpty(assignedList)){
            WhWmsTaskAssignVO taskAssignVO = assignedList.get(0);
            if(taskAssignVO.getOperatorId().equals(reqVO.getOperatorId())){
                return taskAssignVO;
            }
            if(!reqVO.isForce()){
                //非强制领取
                throw new WarehouseException(WarehouseExceptionErrorCode.TASK_ASSIGNED,"任务已被领取");
            }
        }
        //取消其他人的任务
        if(EmptyUtil.isNotEmpty(assignedList)){
            WhWmsTaskAssignVO vo = assignedList.get(0);
            //领取任务
            vo.setOperatorId(reqVO.getOperatorId());
            vo.setCreateTime(DateUtil.getNow());
            whWmsTaskAssignMapper.updateByPrimaryKeySelective(vo);
            return vo;
        }
        //领取任务
        WhWmsTaskAssignVO vo = buildAndInsertTaskAssignVo(reqVO);
        afterTaskAssign(vo);
        return vo;

    }

    private void checkInventoryStatus(Long planId,Integer inventoryStatus){

    }

    @Override
    @Transactional
    public void finishTaskAssigned(Long id,Long operatorId) {
        WhWmsTaskAssignVO update = new WhWmsTaskAssignVO();
        update.setOperatorId(operatorId);
        update.setId(id);
        update.setStatus(WhWmsTaskAssignVO.TASK_STATUS_FINISHED);
        update.setFinishTime(DateUtil.getNow());
        whWmsTaskAssignMapper.updateByPrimaryKeySelective(update);
    }

    @Override
    @Transactional
    public void finishTaskAssigned(String referenceCode, Integer type, Long operatorId) {
        if(NullUtil.isNull(operatorId)){
            operatorId = 1L;
        }
        WhWmsTaskAssignVO taskAssign = findNotFinishedTaskAssign(referenceCode,type);
        if(NullUtil.isNotNull(taskAssign)){
            finishTaskAssigned(taskAssign.getId(),operatorId);
        }
    }

    @Override
    public Integer checkIfAnyMoveStockAssignEd(List<String> codeList) {
        return whWmsTaskAssignMapper.checkIfAnyMoveStockAssignEd(codeList);
    }

    /**
     * 拣货分配
     * */
    private WhWmsTaskAssignVO taskAssignConnPickSku(WhWmsTaskAssignReqVO reqVO){
        if(NullUtil.isNull(reqVO.getInOutType())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"参数异常,inOutType必填");
        }
        while (true){
            try {
                Long connectId = whWmsTaskAssignMapper.tryFindAssignConnectPickSku(reqVO);
                if(NullUtil.isNull(connectId)) {
                    return null;
                }
                reqVO.setReferenceCode(connectId.toString());
                WhWmsTaskAssignVO vo = buildAndInsertTaskAssignVo(reqVO);
                return vo;
            }catch (DuplicateKeyException e){
            }
        }

    }

    /**
     * 移库分配
     * */
    private WhWmsTaskAssignVO taskAssignMoveShelves(WhWmsTaskAssignReqVO reqVO){
//        if(NullUtil.isNull(reqVO.getMoveType())){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"参数异常,moveType必填");
//        }
        while (true){
            try {
                String moveCode = whWmsTaskAssignMapper.tryFindAssignMoveShelves(reqVO);
                if(NullUtil.isNull(moveCode)) {
                    return null;
                }
                reqVO.setReferenceCode(moveCode);
                WhWmsTaskAssignVO vo = buildAndInsertTaskAssignVo(reqVO);
                return vo;
            }catch (DuplicateKeyException e){}
        }
    }

    /**
     * 盘点分配
     * */
    private WhWmsTaskAssignVO taskAssignInventory(WhWmsTaskAssignReqVO reqVO){
        while (true){
            try {
                Long planId = whWmsTaskAssignMapper.tryFindAssignInventory(reqVO);
                if(NullUtil.isNull(planId)) {
                    return null;
                }
                reqVO.setReferenceCode(planId.toString());
                WhWmsTaskAssignVO vo = buildAndInsertTaskAssignVo(reqVO);
                return vo;
            }catch (DuplicateKeyException e){}
        }
    }

    /**
     * 取消任务指派
     * */
    private void cancelTaskAssigned(String referenceCode,Integer type){
        whWmsTaskAssignMapper.cancelTaskAssigned(referenceCode,type);
    }

    private  void checkTaskAsked(WhWmsTaskAssignReqVO reqVO){
        if(WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU.equals(reqVO.getTaskType())) {
            checkConnectPickSku(reqVO);
        }else if(WhWmsTaskAssignVO.TASK_TYPE_MOVESHELVES.equals(reqVO.getTaskType())){
            checkMoveShelves(reqVO);
        }else if(WhWmsTaskAssignVO.TASK_TYPE_INVENTORY.equals(reqVO.getTaskType())){
            checkInventory(reqVO);
        }
    }
    //拣货检查
    private void checkConnectPickSku(WhWmsTaskAssignReqVO reqVO){
        if(EmptyUtil.isEmpty(reqVO.getReferenceCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"任务号不可为空");
        }
        WhWmsConnectInfoVO connectInfo = whWmsConnectInfoService.findById(Long.valueOf(reqVO.getReferenceCode()));
        if(NullUtil.isNull(connectInfo)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不存在["+reqVO.getReferenceCode()+"]");
        }
        if(!WMSConstants.ConnectStatus.WAITING_PROCESS.equals(connectInfo.getConnectStatus())
                && !WMSConstants.ConnectStatus.PROCESSING.equals(connectInfo.getConnectStatus())) {
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "波次状态["+WhWmsConnectInfoVO.getConnectStatusStr(connectInfo.getConnectStatus())+"]");
        }
        if( (WhCommand.TYPE_SALES_OUT.equals(connectInfo.getInOutType())
                || WhCommand.TYPE_CHANGE_OUT.equals(connectInfo.getInOutType()))
                && NullUtil.isNotNull(connectInfo.getDistributeStatus())
                && !(PegasusConstants.YES == connectInfo.getDistributeStatus()) ){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "波次状态["+connectInfo.getDistributeStatusName()+"]");
        }
        if(NullUtil.isNull(reqVO.getInOutType()) || NullUtil.isNull(connectInfo.getInOutType())
                || (!reqVO.getInOutType().equals(connectInfo.getInOutType()))
                || WhCommand.TYPE_SALES_OUT.equals(reqVO.getInOutType())
                    && EmptyUtil.isEmpty(reqVO.getConnectType()) && WMSConstants.ConnectType.RECEIVE_WASTE.equals(connectInfo.getConnectType())
                || WhCommand.TYPE_SALES_OUT.equals(reqVO.getInOutType())
                    && EmptyUtil.isNotEmpty(reqVO.getConnectType()) && !WMSConstants.ConnectType.RECEIVE_WASTE.equals(connectInfo.getConnectType())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库类型不正确["+reqVO.getReferenceCode()+"]");
        }
    }
    //移库检查
    private void checkMoveShelves(WhWmsTaskAssignReqVO reqVO){
        if(EmptyUtil.isEmpty(reqVO.getReferenceCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"任务号不可为空");
        }
        WhWmsMoveStockVO moveStock = whWmsMoveStockService.getMoveStockByCode(reqVO.getReferenceCode());
        if(NullUtil.isNull(moveStock)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"移库不存在["+reqVO.getReferenceCode()+"]");
        }
        if(!WhWmsMoveStockVO.STATUS_WAITTINT_OUT.equals(moveStock.getStatus())
                && !WhWmsMoveStockVO.STATUS_PROCESSING.equals(moveStock.getStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "移库状态["+WhWmsMoveStockVO.getStatusName(moveStock.getStatus())+"]");
        }
        if(NullUtil.isNotNull(reqVO.getMoveType()) &&
                !reqVO.getMoveType().equals(moveStock.getMoveType()) ){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"移库类型不正确["+reqVO.getReferenceCode()+"]");
        }
    }
    //盘点检查
    private void checkInventory(WhWmsTaskAssignReqVO reqVO){
        if(EmptyUtil.isNotEmpty(reqVO.getShelvesCode())
                && EmptyUtil.isEmpty(reqVO.getReferenceCode())
                && NullUtil.isNotNull(reqVO.getInventoryStatus())){
            List<Integer> statusList = new ArrayList<>();
            if(WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(reqVO.getInventoryStatus())){
                statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PENDING);
                statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING);
            }else if(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(reqVO.getInventoryStatus())){
                statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING);
            }
            WhWmsInventoryPlanShelvesCond planShelvesCond = new WhWmsInventoryPlanShelvesCond();
            planShelvesCond.setShelvesCode(reqVO.getShelvesCode());
            planShelvesCond.setStatusList(statusList);
            List<WhWmsInventoryPlanShelvesVO> planVOList = whWmsInventoryService.findInventoryPlanShelvesByCond(planShelvesCond);
            if(EmptyUtil.isEmpty(planVOList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"库位无["+WhWmsTakeStockPlanVO.getStatusStr(reqVO.getInventoryStatus())+"]任务["+reqVO.getShelvesCode()+"]");
            }
            reqVO.setReferenceCode(planVOList.get(0).getId().toString());
        }else if(EmptyUtil.isNotEmpty(reqVO.getReferenceCode()) && NullUtil.isNotNull(reqVO.getInventoryStatus())){
            try{
                Long planShelvesId = Long.parseLong(reqVO.getReferenceCode());
                WhWmsInventoryPlanShelvesVO planShelves = whWmsInventoryService.findInventoryPlanShelves(planShelvesId,false);
                if(!WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus())
                        && !WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus())
                        && !WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(reqVO.getInventoryStatus())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                            "盘点计划状态["+WhWmsInventoryPlanShelvesVO.getStatusName(planShelves.getStatus())+"]");
                }
            }catch (Exception e){
                throw  new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"盘点任务不存在["+reqVO.getReferenceCode()+"]");
            }
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"参数异常");
        }

    }

    private WhWmsTaskAssignVO buildAndInsertTaskAssignVo(WhWmsTaskAssignReqVO reqVO){
        WhWmsTaskAssignVO vo = new WhWmsTaskAssignVO();
        vo.setReferenceCode(reqVO.getReferenceCode());
        vo.setType(reqVO.getTaskType());
        vo.setStatus(WhWmsTaskAssignVO.TASK_STATUS_PENDING);
        vo.setOperatorId(reqVO.getOperatorId());
        vo.setCreateTime(DateUtil.getNow());
        whWmsTaskAssignMapper.insert(vo);
        vo.setCode(WhWmsTaskAssignVO.CODE_PREFIX+vo.getId());
        whWmsTaskAssignMapper.updateByPrimaryKeySelective(vo);
        return vo;
    }

    //拣货任务领取后的操作
    private void afterTaskAssign(WhWmsTaskAssignVO vo){
        if(NullUtil.isNull(vo)){
            return;
        }
        if(WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU.equals(vo.getType())){
            //更新波次状态 待拣货到拣货中
            Long connectId = Long.parseLong(vo.getReferenceCode());
            whWmsConnectInfoService.connectStatusTransform(connectId,WMSConstants.ConnectStatus.WAITING_PROCESS,WMSConstants.ConnectStatus.PROCESSING);
        }else if(WhWmsTaskAssignVO.TASK_TYPE_INVENTORY.equals(vo.getType())){
            Long planShelvesId = Long.parseLong(vo.getReferenceCode());
            WhWmsInventoryPlanShelvesVO planShelves = whWmsInventoryService.findInventoryPlanShelves(planShelvesId,false);
            if(WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus())){
                //更新任务行:待盘点->盘点中
                planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING);
                whWmsInventoryService.updateInventoryPlanShelves(planShelves);
            }

        }
    }



}
