//package com.thebeastshop.pegasus.service.warehouse.service.impl;
//
//import java.util.*;
//import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsTakeStockPlanCond;
//import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsTakeStockPlanMapper;
//import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
//import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
//import com.thebeastshop.pegasus.service.warehouse.model.WhWmsTakeStockPlan;
//import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
//import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTakeStockPlanService;
//import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
//import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTakeStockPlanVO;
//import com.thebeastshop.pegasus.util.comm.BeanUtil;
//import com.thebeastshop.pegasus.util.comm.EmptyUtil;
//import com.thebeastshop.pegasus.util.comm.NumberUtil;
//import org.apache.commons.collections.CollectionUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//
//
///**
// * create by com.thebeastshop.pegasus.service.warehouse.service.impl parent :author lijing
// * User:lijing
// * DATE : 2016/5/31
// * TIME : 19:38
// * parent.
// */
//@Service("whWmsTakeStockPlanService")
//public class WhWmsTakeStockPlanServiceImpl implements WhWmsTakeStockPlanService {
//
//    @Autowired
//    private WhWmsTakeStockPlanMapper       whWmsTakeStockPlanMapper;
//
//    @Autowired
//    private WhWmsHouseShelvesService       whWmsHouseShelvesService;
//
//
//
//    @Override
//    public Boolean createTakeStockPlan(WhWmsTakeStockPlanVO plan) {
//        if(EmptyUtil.isEmpty(plan.getPhysicalWarehouseCode())
//                || EmptyUtil.isEmpty(plan.getHouseType())
//                || EmptyUtil.isEmpty(plan.getShelvesCode())
//                || EmptyUtil.isEmpty(plan.getStatus())
//                || EmptyUtil.isEmpty(plan.getTakeStockId())
//                || EmptyUtil.isEmpty(plan.getSubmitUserId())){
//        }
//        WhWmsTakeStockPlanCond cond = new WhWmsTakeStockPlanCond();
//        cond.setShelvesCode(plan.getShelvesCode());
//        cond.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//        if(CollectionUtils.isNotEmpty(getTakeStockPlanByCond(cond)))
//            throw new WarehouseException("","["+plan.getShelvesCode()+"]尚未盘点");
//        plan.setSubmitTime(new Date());
//        if(whWmsTakeStockPlanMapper.insert(plan)<=0){
//            throw new WarehouseException("","插入数据失败");
//        }
//        return true;
//    }
//
//    @Override
//    public WhWmsTakeStockPlanVO getTakeStockPlanById(Long id) {
//        if(NumberUtil.isNullOrZero(id)) throw new WarehouseException("","主键为空");
//        WhWmsTakeStockPlan plan = whWmsTakeStockPlanMapper.selectByPrimaryKey(id);
//        if(EmptyUtil.isNotEmpty(plan)){
//            return BeanUtil.buildFrom(plan,WhWmsTakeStockPlanVO.class);
//        }
//        return null;
//    }
//
//    @Override
//    @Transactional
//    public Boolean completePlanById(Long id,Long takeStockId,Long createUserId) {
//        WhWmsTakeStockPlan plan =  getTakeStockPlanById(id);
//        if(EmptyUtil.isEmpty(plan)) throw new WarehouseException("","盘点计划不存在");
//        if(!plan.getStatus().equals(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY))
//            throw new WarehouseException("","盘点计划状态异常,无法创建盘点");
//        plan.setStatus(WhWmsTakeStockPlanVO.INVENTORIED);
//        plan.setTakeStockId(takeStockId);
//        plan.setSubmitTime(new Date());
//        if(whWmsTakeStockPlanMapper.updateByPrimaryKey(plan)<=0) throw  new WarehouseException("","更新数据库失败");
//        return true;
//    }
//
//
//    @Override
//    public List<WhWmsTakeStockPlanVO> getTakeStockPlanByCond(WhWmsTakeStockPlanCond cond) {
//        return whWmsTakeStockPlanMapper.getTakeStockPlanByCond(cond);
//    }
//
//    @Override
//    public Boolean createTakeStockPlans(List<WhWmsTakeStockPlanVO> planList) {
//        for(WhWmsTakeStockPlanVO plan :planList){
//            createTakeStockPlan(plan);
//        }
//        return true;
//    }
//
//    @Transactional
//    public Boolean updatePlan(WhWmsTakeStockPlanVO plan){
//        if(EmptyUtil.isEmpty(plan))  throw new WarehouseException("","空参数");
//        int update = whWmsTakeStockPlanMapper.updateByPrimaryKeySelective(plan);
//        if(update<=0) throw new WarehouseException("","更新数据失败");
//        return true;
//    }
//
//    public Boolean updatePlans(List<WhWmsTakeStockPlanVO> plans){
//        if(CollectionUtils.isEmpty(plans))  throw new WarehouseException("","空参数");
//        for(WhWmsTakeStockPlanVO plan : plans ){
//            updatePlan(plan);
//        }
//        return true;
//    }
//
//
//    @Override
//    public Boolean createTakeStockPlansGroupByShelves(List<WhWmsSkuStock> skuStocksList,Long userId) {
//        if(CollectionUtils.isEmpty(skuStocksList))  throw  new WarehouseException("","空参数");
//        Map<String,List<WhWmsSkuStock>> rcdMap = new HashMap<>();
//        for (WhWmsSkuStock  rcd : skuStocksList) {
//            String shelvesCode = rcd.getShelvesCode();
//            List<WhWmsSkuStock> rcds = rcdMap.get(shelvesCode);
//            if(EmptyUtil.isEmpty(rcds)){
//                rcds = new ArrayList<>();
//                rcdMap.put(shelvesCode,rcds);
//            }
//            rcds.add(rcd);
//        }
//        for(Map.Entry<String,List<WhWmsSkuStock>> entry: rcdMap.entrySet()){
//            WhWmsTakeStockPlanVO plan = new WhWmsTakeStockPlanVO();
//            WhWmsHouseShelvesVO houselves = whWmsHouseShelvesService.getHouseShelvesByCode(entry.getKey());
//            if(EmptyUtil.isEmpty(houselves)) throw  new WarehouseException("","["+entry.getKey()+"]库位不存在");
//            plan.setShelvesCode(entry.getKey());
//            plan.setPhysicalWarehouseCode(houselves.getPhysicalWarehouseCode());
//            plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//            plan.setSubmitUserId(userId);
//            plan.setSubmitTime(new Date());
//            plan.setHouseType(houselves.getHouseType());
//            WhWmsTakeStockPlanCond cond = new WhWmsTakeStockPlanCond();
//            cond.setShelvesCode(entry.getKey());
//            cond.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//            List<WhWmsTakeStockPlanVO> planList_0 = getTakeStockPlanByCond(cond);
//            if(CollectionUtils.isNotEmpty(planList_0)){
//                for(WhWmsTakeStockPlanVO plan_0:planList_0){
//                    plan_0.setSubmitTime(new Date());
//                    plan_0.setSubmitUserId(userId);
//                    updatePlan(plan_0);
//                }
//            }
//            cond = new WhWmsTakeStockPlanCond();
//            cond.setShelvesCode(entry.getKey());
//            cond.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//            if(CollectionUtils.isNotEmpty(getTakeStockPlanByCond(cond))) continue;
//            createTakeStockPlan(plan);
//        }
//        return true;
//    }
//
//
//}
