package com.thebeastshop.pegasus.service.warehouse.service.impl;

import java.util.*;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuTranslateItemVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuTranslateVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsStartPutawayVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTakeStockPlanVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsTakeStockRcdVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Service("whWmsSkuTranslateService")
public class WhWmsSkuTranslateServiceImpl implements WhWmsSkuTranslateService{

	@Autowired
	private WhWmsHouseShelvesService whWmsHouseShelvesService;

	@Autowired
	private WhWmsSkuStockService whWmsSkuStockService;

//	@Autowired
//	private WhWmsTakeStockPlanService whWmsTakeStockPlanService;
//
//	@Autowired
//	private WhWmsTakeStockService whWmsTakeStockService;
//
//	@Autowired
//	private WhWmsTakeStockRcdService whWmsTakeStockRcdService;

//    @Autowired
//    private WhWmsInventoryManageService whWmsInventoryManageService;

	@Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;

	@Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

	@Override
	@Transactional
	public boolean skuTranslate(WhWmsSkuTranslateVO vo) {
//		if(EmptyUtil.isEmpty(vo) ||
//				EmptyUtil.isEmpty(vo.getMemo()) ||
//				EmptyUtil.isEmpty(vo.getItems()) ){
//			throw new WarehouseException("","参数格式不对");
//		}
//		//检查库存
//		checkStock(vo);
//		//盘点计划批量生成盘点任务
//		List<WhWmsTakeStockPlanVO> planList = buildTakeStockPlan(vo);
//		whWmsInventoryManageService.insertInventoryPlan(planList);
//		List<Long> planIds = new ArrayList<>();
//		for(WhWmsTakeStockPlanVO plan : planList){
//			planIds.add(plan.getId());
//			plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK);
//		}
//		//完成盘点任务
//		whWmsInventoryManageService.complateInventoryPlan(planList);//直接走二盘
//		//自动审核通过
//		whWmsInventoryManageService.auditInventoryPlanForSkuTranslate(planIds,vo.getOperatorId());
//		//生产移库
//		String moveStockCode = moveStock(vo);
//		vo.setResultMoveStockCode(moveStockCode);
//		//更新smc库存
//		whWmsInventoryManageService.inventoryScmStockForSkuTranslate(planIds,vo.getOperatorId());
		return false;
	}

	//检查可以及库存是否足够盘点
	private boolean checkStock(WhWmsSkuTranslateVO vo){
		WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
		for(WhWmsSkuTranslateItemVO item : vo.getItems()){
			cond.setSkuCode(item.getSkuCode());
			cond.setSkuStatus(item.getSkuStatus());
			cond.setBarCode(item.getBarCode());
			cond.setShelvesCode(item.getShelvesCode());
			List<WhWmsSkuStockVO> shelvesStockList = whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
			if(EmptyUtil.isEmpty(shelvesStockList) || shelvesStockList.size()>1){
				String msg = String.format("[%s][%s][%s]库存不足", item.getShelvesCode(),item.getBarCode(),WhCommand.getSkuStatusName(item.getSkuStatus()));
        		throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,msg);
			}
			WhWmsSkuStockVO stock = shelvesStockList.get(0);
			if(item.getChangeAmount()>stock.getTotalAmount()){
				String msg = String.format("[%s][%s][%s][%d]<[%d]库存不足", item.getShelvesCode(),item.getBarCode(),WhCommand.getSkuStatusName(item.getSkuStatus()),stock.getTotalAmount(),item.getChangeAmount());
        		throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,msg);
			}
			if(item.getChangeAmount()>stock.getAvailableAmount()){
				String msg = String.format("[%s][%s][%s][%d]<[%d]可用库存不足", item.getShelvesCode(),item.getBarCode(),WhCommand.getSkuStatusName(item.getSkuStatus()),stock.getAvailableAmount(),item.getChangeAmount());
        		throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,msg);
			}

		}
		return true;
	}


	//构建盘点计划
	private List<WhWmsTakeStockPlanVO> buildTakeStockPlan(WhWmsSkuTranslateVO vo){
		if(EmptyUtil.isEmpty(vo.getItems())){
			return null;
		}
		List<String> shelvesCodes = new ArrayList<>();
		for(WhWmsSkuTranslateItemVO item :  vo.getItems()){
			shelvesCodes.add(item.getShelvesCode());
		}
		WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
		cond.setShelvesCodeList(shelvesCodes);
		List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
		Map<String,WhWmsHouseShelvesVO> shelvesMap = new HashMap<>();
		if(EmptyUtil.isNotEmpty(shelvesList)){
			for(WhWmsHouseShelvesVO shelvesVO : shelvesList){
				shelvesMap.put(shelvesVO.getCode(),shelvesVO);
			}
		}
		Map<String,List<WhWmsSkuTranslateItemVO>> shelvesItemMap = new HashMap<>();
		for(WhWmsSkuTranslateItemVO item :  vo.getItems()){
			String key = item.getShelvesCode();
			List<WhWmsSkuTranslateItemVO> itemList = shelvesItemMap.get(key);
			if(NullUtil.isNull(itemList)){
				itemList = new ArrayList<>();
				shelvesItemMap.put(key,itemList);
			}
			WhWmsHouseShelvesVO shelvesVO = shelvesMap.get(key.toUpperCase());
			item.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
			item.setHouseType(shelvesVO.getHouseType());
			itemList.add(item);
			if(EmptyUtil.isEmpty(vo.getPhysicalWarehouseCode())){
				vo.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
			}
		}
		List<WhWmsTakeStockPlanVO> planList = new ArrayList<>();
		Date submitTime = DateUtil.getNow();
		for(String shelvesCode : shelvesItemMap.keySet()){
			WhWmsHouseShelvesVO shelvesVO = shelvesMap.get(shelvesCode);
			if(NullUtil.isNull(shelvesVO)){
				throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]库位不存在",shelvesCode));
			}
			WhWmsTakeStockPlanVO plan = new WhWmsTakeStockPlanVO();
			plan.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
			plan.setHouseType(shelvesVO.getHouseType());
			plan.setShelvesCode(shelvesVO.getCode());
			plan.setSubmitUserId(vo.getOperatorId());
			plan.setSubmitTime(submitTime);
			plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
			plan.setDiff(PegasusConstants.YES);
			plan.setTakeStockRcdList(buildTakeStockRcds(shelvesItemMap.get(shelvesCode),vo));
			planList.add(plan);
		}
		return planList;
	}

	//生产移库
	private String moveStock(WhWmsSkuTranslateVO vo){
		List<WhWmsMoveSkuVO> moveskuList = null;
		List<WhWmsStartPutawayVO> pvoList = buildPutawayVOs(vo);
		if(EmptyUtil.isNotEmpty(pvoList)){
			moveskuList = whWmsWaitPutawayService.recommendWmsHouseShelves(pvoList);
		}
		if(EmptyUtil.isNotEmpty(moveskuList)){
			//移库行不为空,创建移库单
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(vo.getOperatorId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SKU_TRANSLATE);
            //调用移库接口
            moveStockVO.setMoveSkuList(moveskuList);
            whWmsMoveStockService.newMoveStock(moveStockVO);
            return moveStockVO.getCode();
		}
		return null;
	}

	//
	//组织上架数据
    private List<WhWmsStartPutawayVO> buildPutawayVOs(WhWmsSkuTranslateVO vo){
    	List<WhWmsStartPutawayVO> pvoList = new ArrayList<>();
    	if(EmptyUtil.isNotEmpty(vo) && EmptyUtil.isNotEmpty(vo.getItems())){
    		for(WhWmsSkuTranslateItemVO item : vo.getItems()){
        		WhWmsStartPutawayVO pt = new WhWmsStartPutawayVO();
        		WhWmsHouseShelvesVO shelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(item.getShelvesCode());
        		pt.setSourceShelvesVO(shelvesVO);
        		pt.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        		pt.setPutawayAmount(item.getChangeAmount());
        		pt.setSkuCode(item.getSkuCode());
        		pt.setBarCode(item.getBarCode());
        		pt.setSkuStatus(vo.getTargetSkuStatus());
        		pt.setReceiveAmount(item.getChangeAmount());
        		pt.setStorageType(item.getSkuStorageType());
        		pvoList.add(pt);
        	}
    	}
    	return pvoList;
    }

	//组织盘点记录数据
	private List<WhWmsTakeStockRcdVO> buildTakeStockRcds(List<WhWmsSkuTranslateItemVO> itemList,WhWmsSkuTranslateVO vo){
		if(EmptyUtil.isEmpty(itemList)){
			throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("无可用数据"));
		}
		List<WhWmsTakeStockRcdVO> whTakeStockRcdList = new ArrayList<>();
		for(WhWmsSkuTranslateItemVO item : itemList ){
			//盘盈
			WhWmsTakeStockRcdVO whWmsTakeStockRcd = new WhWmsTakeStockRcdVO();
            whWmsTakeStockRcd.setPhysicalWarehouseCode(item.getPhysicalWarehouseCode());
            whWmsTakeStockRcd.setHouseType(item.getHouseType());
            whWmsTakeStockRcd.setSkuStatus(item.getSkuStatus());
            whWmsTakeStockRcd.setSkuCode(item.getSkuCode());
            whWmsTakeStockRcd.setBarCode(item.getBarCode());
            whWmsTakeStockRcd.setShelvesCode(item.getShelvesCode());
            whWmsTakeStockRcd.setOriAmount(item.getAmount());
            whWmsTakeStockRcd.setRealAmount(item.getAmount()-item.getChangeAmount());
            whWmsTakeStockRcd.setDiffAmount(-item.getChangeAmount());
            whWmsTakeStockRcd.setCreateUserId(vo.getOperatorId());
            whWmsTakeStockRcd.setTakeStockeStatus(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
            whWmsTakeStockRcd.setMemo(vo.getMemo());
            whWmsTakeStockRcd.setAuditUserId(vo.getOperatorId());
            whTakeStockRcdList.add(whWmsTakeStockRcd);
            //盘亏
            whWmsTakeStockRcd = new WhWmsTakeStockRcdVO();
            whWmsTakeStockRcd.setPhysicalWarehouseCode(item.getPhysicalWarehouseCode());
            whWmsTakeStockRcd.setHouseType(item.getHouseType());
            whWmsTakeStockRcd.setSkuStatus(vo.getTargetSkuStatus());
            whWmsTakeStockRcd.setSkuCode(item.getSkuCode());
            whWmsTakeStockRcd.setBarCode(item.getBarCode());
            whWmsTakeStockRcd.setShelvesCode(item.getShelvesCode());
            whWmsTakeStockRcd.setOriAmount(0);
            whWmsTakeStockRcd.setRealAmount(item.getChangeAmount());
            whWmsTakeStockRcd.setDiffAmount(item.getChangeAmount());
            whWmsTakeStockRcd.setCreateUserId(vo.getOperatorId());
            whWmsTakeStockRcd.setTakeStockeStatus(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
            whWmsTakeStockRcd.setMemo(vo.getMemo());
            whWmsTakeStockRcd.setAuditUserId(vo.getOperatorId());
            whTakeStockRcdList.add(whWmsTakeStockRcd);
		}
		return whTakeStockRcdList;
	}

}
