package com.thebeastshop.pegasus.service.warehouse.service.impl;


import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsHouseShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveStorehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.http.client.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import javax.xml.crypto.dsig.keyinfo.PGPData;
import java.util.*;

/**
 * Created by Administrator on 2016/3/23.
 */
@Service("whWmsSkuStockService")
public class WhWmsSkuStockServiceImpl implements WhWmsSkuStockService {

    @Autowired
    private WhWmsSkuStockMapper mapper;

    @Autowired
    private WhWmsSkuStockRecordMapper whWmsSkuStockRecordMapper;
    @Autowired
    private WhWmsHouseShelvesMapper whWmsHouseShelvesMapper;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Override
    public WhWmsSkuStockVO create(WhWmsSkuStockVO skuStockVO) {
        WhWmsSkuStock skuStock = BeanUtil.buildFrom(skuStockVO, WhWmsSkuStock.class);
        skuStock.setLastUpdateTime(new Date());
        mapper.insert(skuStock);
        skuStockVO.setId(skuStock.getId());
        return skuStockVO;
    }

    /**
     * (不推荐使用)更新库存相关信息，不能更新库存
     * @param skuStockVO
     * @return
     */
    @Override
    public Boolean update(WhWmsSkuStockVO skuStockVO) {
        skuStockVO.setLastUpdateTime(new Date());
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(skuStockVO, WhWmsSkuStock.class))!=0;
    }

    @Override
    public WhWmsSkuStockVO findById(Long id) {
        WhWmsSkuStock skuStock = mapper.selectByPrimaryKey(id);
        if(skuStock!=null){
            return BeanUtil.buildFrom(skuStock,WhWmsSkuStockVO.class);
        }
        return null;
    }

    /**
     * 根据ID更新WMS的SKU库存
     * @param id
     * @return
     */
    public boolean updateStockById(Integer id,Integer amount) {
        if(null!=id) {
            WhWmsSkuStock skuStock = mapper.selectByPrimaryKey(id.longValue());
            skuStock.setLastUpdateTime(new Date());
            return mapper.updateStockById(id,amount,skuStock.getVersion()) != 0;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus, Integer inoutType, String receiptNo, Long userId, String memo, Integer isUpdateScm) {
        return updateStockByCond(amount, physicalWarehouseCode, houseType, barcode, shelvesCode, skuCode, skuStatus, inoutType, receiptNo, userId, memo, isUpdateScm,true);
    }

    @Transactional
    @Override
    public boolean outSkuStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus) {
        if(amount==null
                ||physicalWarehouseCode==null
                ||houseType==null
                ||barcode==null
                ||shelvesCode==null
                ||skuCode==null
                ||skuStatus==null
                ){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"NullPointerException");
        }
        WhWmsSkuStockVO cond=new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setHouseType(houseType);
        cond.setBarCode(barcode);
        cond.setShelvesCode(shelvesCode);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> list = mapper.getByCond(cond);
        WhWmsSkuStock sk = null;
        if(null!=list && list.size()==1){
            sk=list.get(0);
            if(sk.getAmount() + amount < 0){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicalWarehouseCode+"]"+"["+shelvesCode+"]["+barcode+"]["+WhCommand.getSkuStatusName(skuStatus)+"]["+(sk.getAmount())+"<"+(-amount)+"]库存不足，不可以出库");
            }else{
                int i = 0;
                boolean isTurn = true;
                do{
                    int updateCount = mapper.updateStockByPrimaryKey(amount,sk.getVersion(),sk.getId());
                    if(i >=3 || updateCount >0){
                        isTurn = false;
                    }else{
                        List<WhWmsSkuStock> newList = mapper.getByCond(cond);
                        if(newList != null && newList.size() > 0){
                            sk = newList.get(0);
                        }
                    }
                    i+= 1;
                }while(isTurn);
                if(i > 3){
                    //throw new RuntimeException("库存修改失败");
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicalWarehouseCode+"]"+"["+shelvesCode+"]["+barcode+"]["+WhCommand.getSkuStatusName(skuStatus)+"]["+amount+"]库存修改失败");
                }
            }
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicalWarehouseCode+"]"+"["+shelvesCode+"]["+barcode+"]["+WhCommand.getSkuStatusName(skuStatus)+"]["+(-amount)+"]还没有库存记录不可以出库");
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updatePhyWhSkuStock(String physicalWarehouseCode, String skuCode, Integer skuStatus, Integer quantity, Integer inOutType, String referenceCode, Long operatorId, String memo) {
        //门店物理仓库存出入记录，仓库慎用
        if(quantity==null
                ||physicalWarehouseCode==null
                ||skuCode==null
                ||skuStatus==null
                || inOutType == null
                || referenceCode == null){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"参数异常");
        }
        if(quantity < 0 ){
            updatePhyWhSkuStockOut(physicalWarehouseCode
                    ,skuCode,skuStatus,quantity
                    ,inOutType,referenceCode,operatorId,memo);
        }else if(quantity > 0){
            updatePhyWhSkuStockIn(physicalWarehouseCode
                    ,skuCode,skuStatus,quantity
                    ,inOutType,referenceCode,operatorId,memo);
        }
        return true;
    }

    private boolean updatePhyWhSkuStockIn(String physicalWarehouseCode
            ,String skuCode,Integer skuStatus,Integer quantity
            ,Integer inOutType,String referenceCode,Long operatorId,String memo){
        WhWmsHouseShelvesVO houseShelves = findPhyWhShelves(physicalWarehouseCode,skuStatus);
        updateStockByCond(quantity//入库
                ,physicalWarehouseCode
                ,houseShelves.getHouseType()
                ,skuCode+"_0000",houseShelves.getCode(),skuCode,skuStatus
                ,inOutType,referenceCode,operatorId,memo,2);
        return true;
    }

    private WhWmsHouseShelvesVO findPhyWhShelves(String physicalWarehouseCode,Integer skuStatus){
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesVOs = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesVOs)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",库位不存在!");
        }
        if (whWmsHouseShelvesVOs.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",查询有多个库位!");
        }
        return whWmsHouseShelvesVOs.get(0);
    }

    private boolean updatePhyWhSkuStockOut(String physicalWarehouseCode
            ,String skuCode,Integer skuStatus,Integer quantity
            ,Integer inOutType,String referenceCode,Long operatorId,String memo){
        if(NullUtil.isNull(operatorId)){
            operatorId = 1L;
        }
        int needQuantity = -quantity;//出库是负值
        int errorCount =0;
        while(errorCount<3 && needQuantity!=0){//尝试3次
            List<WhWmsSkuStock> skuStockList = findPhyWhSkuStock(physicalWarehouseCode,skuCode,skuStatus);
            if(EmptyUtil.isEmpty(skuStockList)){
                break;
            }
            sortPhyWhSkuStock(skuStockList);//排序
            for(WhWmsSkuStock skuStock : skuStockList){
                int canUse = Math.min(needQuantity,skuStock.getAmount());
                try{
                    updateStockByCond(-canUse//出库
                            ,skuStock.getPhysicalWarehouseCode()
                            ,skuStock.getHouseType()
                            ,skuStock.getBarCode(),skuStock.getShelvesCode(),skuStock.getSkuCode(),skuStock.getSkuStatus()
                            ,inOutType,referenceCode,operatorId,memo,2);
                    needQuantity -= canUse;
                    skuStock.setAmount(skuStock.getAmount()-needQuantity);
                    if(needQuantity == 0){
                        break;
                    }
                }catch (WarehouseException whEx){
                    errorCount++;
                    break;
                }
            }
        }
        if(needQuantity!=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("物理仓[%s][%s][%s]库存不足[%s]"
                    ,physicalWarehouseCode,skuCode,WhCommand.getSkuStatusName(skuStatus),-quantity));
        }
        return true;
    }

    private List<WhWmsSkuStock> findPhyWhSkuStock(String physicalWarehouseCode,String skuCode,Integer skuStatus){
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        stockCond.setSkuCode(skuCode);
        stockCond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> skuStockList = getStockByCond(stockCond);
        if(EmptyUtil.isNotEmpty(skuStockList)){//过滤数量不足0
            Iterator<WhWmsSkuStock> iterator = skuStockList.iterator();
            while (iterator.hasNext()){
                WhWmsSkuStock skuStock = iterator.next();
                if(skuStock.getAmount() <= 0){
                    iterator.remove();
                }
            }
        }
        return skuStockList;
    }

    private void sortPhyWhSkuStock(List<WhWmsSkuStock> skuStockList){
        if(EmptyUtil.isEmpty(skuStockList)){
            return;
        }
        List<String> barcodes = new ArrayList<>();
        for(WhWmsSkuStock skuStock : skuStockList){
            barcodes.add(skuStock.getBarCode());
        }
        final Map<String,WhWmsSkuBarcodeVO> barcodeMap = whWmsSkuBarcodeService.getBarcodeMap(barcodes);
        Collections.sort(skuStockList, new Comparator<WhWmsSkuStock>() {
            @Override
            public int compare(WhWmsSkuStock o1, WhWmsSkuStock o2) {
                if(o1.getBarCode().endsWith("_0000") && o2.getBarCode().endsWith("_0000")){
                    return 0;
                }else if(o1.getBarCode().endsWith("_0000")){
                    return -1;
                }else if(o2.getBarCode().endsWith("_0000")){
                    return 1;
                }else{
                    if(o1.getBarCode().endsWith("_0001") && o2.getBarCode().endsWith("_0001")){
                        return 0;
                    }else if(o1.getBarCode().endsWith("_0001")){
                        return -1;
                    }else if(o2.getBarCode().endsWith("_0001")){
                        return 1;
                    }else{
                        WhWmsSkuBarcodeVO bc1 = barcodeMap.get(o1.getBarCode());
                        WhWmsSkuBarcodeVO bc2 = barcodeMap.get(o2.getBarCode());
                        return whWmsSkuBarcodeService.compareBarCode(bc1,bc2);
                    }
                }
            }
        });

    }

    /**
     * 根据物理仓库编码、仓库区域、条形码、库位编码、SKU_CODE、SKU状态更新WMS的库存
     * @return
     */
    public boolean  updateStockByCond(Integer amount,String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus,Integer inoutType,String receiptNo,Long userId) {
        int isUpdateScm = 2;
        return updateStockByCond(amount,physicalWarehouseCode,houseType,barcode,shelvesCode,skuCode,skuStatus,inoutType,receiptNo,userId,null,isUpdateScm);
    }

    @Override
    @Transactional
    public void batchUpdateWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList) {
        if(EmptyUtil.isEmpty(skuStockRecordList)){
            return;
        }
        for(WhWmsSkuStockRecord skuStockRecord : skuStockRecordList){
            if(NullUtil.isNull(skuStockRecord.getCreateUserId())){
                skuStockRecord.setCreateUserId(1L);
            }
            updateStockByCond(skuStockRecord.getQuantity()
                    ,skuStockRecord.getPhysicalWarehouseCode()
                    ,skuStockRecord.getHouseType()
                    ,skuStockRecord.getBarCode(),skuStockRecord.getShelvesCode(),skuStockRecord.getSkuCode(),skuStockRecord.getSkuStatus()
                    ,skuStockRecord.getInOutType(),skuStockRecord.getReceiptNo(),skuStockRecord.getCreateUserId(),skuStockRecord.getMemo(),skuStockRecord.getIsUpdateScm(),false);
        }
        for(List<WhWmsSkuStockRecord> partList : ListUtils.partition(skuStockRecordList,1000)){
            whWmsSkuStockRecordMapper.batchInsert(partList);
        }
    }

    private boolean updateStockByCond(Integer amount, String physicalWarehouseCode, String houseType, String barcode, String shelvesCode, String skuCode, Integer skuStatus, Integer inoutType, String receiptNo, Long userId, String memo, Integer isUpdateScm,boolean recordLog){
        if(amount==null
                ||physicalWarehouseCode==null
                ||houseType==null
                ||barcode==null
                ||shelvesCode==null
                ||skuCode==null
                ||skuStatus==null
                ||inoutType==null
                ||receiptNo==null
                ||userId==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"NullPointerException");
        }
        WhWmsSkuStockVO cond=new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setHouseType(houseType);
        cond.setBarCode(barcode);
        cond.setShelvesCode(shelvesCode);
        cond.setSkuCode(skuCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsSkuStock> list = mapper.getByCond(cond);
        WhWmsSkuStock sk = null;
        if(null!=list && list.size()==1){
            sk=list.get(0);
            if(sk.getAmount() + amount < 0){
                //throw new RuntimeException("库存不足，不可以出库");
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicalWarehouseCode+"]"+"["+shelvesCode+"]["+barcode+"]["+WhCommand.getSkuStatusName(skuStatus)+"]["+(sk.getAmount())+"<"+(-amount)+"]库存不足，不可以出库");
            }else{
                int i = 0;
                boolean isTurn = true;
                do{
                    int updateCount = mapper.updateStockByPrimaryKey(amount,sk.getVersion(),sk.getId());
                    if(i >=3 || updateCount >0){
                        isTurn = false;
                    }else{
                        List<WhWmsSkuStock> newList = mapper.getByCond(cond);
                        if(newList != null && newList.size() > 0){
                            sk = newList.get(0);
                        }
                    }
                    i+= 1;
                }while(isTurn);
                if(i > 3){
                    //throw new RuntimeException("库存修改失败");
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicalWarehouseCode+"]"+"["+shelvesCode+"]["+barcode+"]["+WhCommand.getSkuStatusName(skuStatus)+"]["+amount+"]库存修改失败");
                }
            }
        }else{
            if(amount < 0){
                //throw new RuntimeException("还没有库存记录不可以出库");
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"物理仓["+physicalWarehouseCode+"]"+"["+shelvesCode+"]["+barcode+"]["+WhCommand.getSkuStatusName(skuStatus)+"]["+(-amount)+"]还没有库存记录不可以出库");
            }else{
                WhWmsSkuStockVO stockVO = new WhWmsSkuStockVO();
                stockVO.setBarCode(barcode);
                stockVO.setSkuCode(skuCode);
                stockVO.setVersion(1);
                stockVO.setAmount(amount);
                stockVO.setSkuStatus(skuStatus);
                stockVO.setPhysicalWarehouseCode(physicalWarehouseCode);
                stockVO.setHouseType(houseType);
                stockVO.setShelvesCode(shelvesCode.toUpperCase());
                mapper.insert(stockVO);
            }
        }
        if(recordLog){
            WhWmsSkuStockRecord whWmsSkuStockRecord = new WhWmsSkuStockRecord();
            whWmsSkuStockRecord.setPhysicalWarehouseCode(physicalWarehouseCode);
            whWmsSkuStockRecord.setHouseType(houseType);
            whWmsSkuStockRecord.setSkuCode(skuCode);
            whWmsSkuStockRecord.setBarCode(barcode);
            whWmsSkuStockRecord.setCreateTime(Calendar.getInstance().getTime());
            whWmsSkuStockRecord.setCreateUserId(userId);
            whWmsSkuStockRecord.setInOutType(inoutType);
            whWmsSkuStockRecord.setQuantity(amount);
            whWmsSkuStockRecord.setReceiptNo(receiptNo);
            whWmsSkuStockRecord.setSkuStatus(skuStatus);
            whWmsSkuStockRecord.setShelvesCode(shelvesCode);
            whWmsSkuStockRecord.setMemo(memo);
            whWmsSkuStockRecord.setIsUpdateScm(isUpdateScm);
            if(sk != null){
                whWmsSkuStockRecord.setOldQuantity(sk.getAmount());
            }else {
                whWmsSkuStockRecord.setOldQuantity(0);
            }
            whWmsSkuStockRecordMapper.insert(whWmsSkuStockRecord);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean convertBarcodeUpdateSkuStock(WhWmsSkuStockVO vo) {
        // 扣源批次
        boolean result = updateStockByCond(-vo.getAmount(),vo.getPhysicalWarehouseCode(),vo.getHouseType(),vo.getBarCode(),vo.getShelvesCode(),vo.getSkuCode(),vo.getSkuStatus(),WhInvRcd.TYPE_BARCODE_CONVERT_OUT,vo.getBarCode()+"_"+vo.getAmount()+"_"+DateUtil.format(DateUtil.getNow(), DateUtil.DEFAULT_STR_FORMAT),vo.getCreateOperatorId(),"",2);
        if (result){
            // 加目标批次
            result = updateStockByCond(vo.getAmount(),vo.getPhysicalWarehouseCode(),vo.getHouseType(),vo.getTargetBarcode(),vo.getShelvesCode(),vo.getSkuCode(),vo.getSkuStatus(),WhInvRcd.TYPE_BARCODE_CONVERT_IN,vo.getTargetBarcode()+"_"+vo.getAmount()+"_"+DateUtil.format(DateUtil.getNow(), DateUtil.DEFAULT_STR_FORMAT),vo.getCreateOperatorId(),"",2);
        }
        return result;
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStockByCond(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStock> list = mapper.getByCond(cond);
        List<WhWmsSkuStockVO> voList = BeanUtil.buildListFrom(list,WhWmsSkuStockVO.class);
        return voList;
    }

    @Override
    public List<WhWmsSkuStockVO> getWmsSkuStockByVO(WhWmsSkuStockVO cond) {
        List<WhWmsSkuStock> list = mapper.getByVO(cond);
        List<WhWmsSkuStockVO> voList = BeanUtil.buildListFrom(list,WhWmsSkuStockVO.class);
        return voList;
    }

    /**
     * 根据物理仓code 和 sku状态良品、残次、样品 查找sku
     * @param physicalWarehouseCode
     * @param skuStatus
     * @param skuCode
     * @return
     */
    @Override
    public List<WhWmsSkuStockVO> findWmsSkuStockByPhysicalWarehouseCodeAndStatus(String physicalWarehouseCode,Integer skuStatus,String skuCode) {
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        cond.setSkuCode(skuCode);
        return getWmsSkuStockByCond(cond);
    }

    /**
     * 根据vos 算出sku总数
     * @param vos
     * @return
     */
    @Override
    public int sumSkuQuantity(List<WhWmsSkuStockVO> vos) {
        int result = 0;
        for (WhWmsSkuStockVO vo : vos) {
            result+=vo.getAmount();
        }
        return result;
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vo) {
      return findWmsSkuAvailableAccount(vo,false);
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccount(WhWmsSkuStockVO vo,boolean gtZero){
        return mapper.findWmsSkuAvailableAccount(vo,gtZero);
    }

    @Override
    public List<WhWmsSkuStockVO> findWmsSkuAvailableAccountWithPreOccupy(WhWmsSkuStockVO vos, boolean gtZero) {
        return mapper.findWmsSkuAvailableAccountWithPreOccupy(vos,gtZero);
    }

    @Override
    public List<WhWmsSkuStock> selectByExample(WhWmsSkuStockExample example) {
        return mapper.selectByExample(example);
    }

    @Override
    public List<WhWmsSkuStock>  getGroupByShelvesByCond(WhWmsSkuStockVO vo) {
        return mapper.getGroupByShelvesByCond(vo);
    }

    @Override
    public List<WhWmsSkuStock> getStockByCond(WhWmsSkuStockVO vo) {
        return mapper.getStockByCond(vo);
    }

    @Override
	public List<WhWmsSkuStockVO> getWmsSkuStocksByCond(WhWmsSkuStockVO cond) {
		List<WhWmsSkuStockVO> voList = mapper.getSkuStocksByCond(cond);
        return voList;
	}
	
	@Override
	public List<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCond(WhWmsSkuStockVO cond) {
		List<WhWmsSkuStockVO> voList = mapper.getSkuStocksByShelvesCond(cond);
        return voList;
	}

	@Override
	public List<WhWmsSkuStockVO> getWmsSkuStocksByCondForReport(
			WhWmsSkuStockVO cond) {
		List<WhWmsSkuStockVO> voList = mapper.getSkuStocksByCondForReport(cond);
        return voList;
	}

	@Override
	public Pagination<WhWmsSkuStockVO> getWmsSkuStocksByShelvesCondForReport(
			WhWmsSkuStockVO cond) {
        Pagination<WhWmsSkuStockVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());

        List<WhWmsSkuStockVO> voList = listSkuStocksByCond(cond);
        Integer counts = mapper.countSkuStocksByShelvesCondForReport(cond);

        page.setRecord(counts);
        page.setResultList(voList);
        return page;
	}

    @Override
    public List<WhWmsSkuStockVO> getSkuStocksByShelvesCondForReport(WhWmsSkuStockVO cond) {
        return mapper.getSkuStocksByShelvesCondForReport(cond);
    }

    @Override
    public List<WhWmsSkuStockVO> listSkuStocksByCond(WhWmsSkuStockVO cond) {
        return mapper.getSkuStocksByShelvesCondForReport(cond);
    }

    @Override
	public WhWmsSkuStockVO countSkuAmountBySkuStatus(
			WhWmsSkuStockVO cond) {
        return mapper.countSkuAmountBySkuStatus(cond);
	}

    @Override
    public List<WhWmsSkuStockRecordVO> findWhWmsStockRecord(WhWmsSkuStockRecordCond cond) {
        return   whWmsSkuStockRecordMapper.findWhWmsStockRecordByCond(cond);

    }

    @Override
    public Pagination<PhyWhSkuStockRcdVO> findPhyWhSkuStockRcdByCond(PhyWhSkuStockRcdCond cond) {
        Pagination<PhyWhSkuStockRcdVO> pagination = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int total = whWmsSkuStockRecordMapper.countPhyWhSkuStockRcdByCond(cond);
        pagination.setRecord(total);
        if(!NumberUtil.isNullOrZero(total)){
            List<PhyWhSkuStockRcdVO> rcdList = whWmsSkuStockRecordMapper.findPhyWhSkuStockRcdByCond(cond);
            if(EmptyUtil.isNotEmpty(rcdList)){
                List<String> commandCodes = new ArrayList<>();
                for(PhyWhSkuStockRcdVO rcd : rcdList){
                    if(isCommandCode(rcd.getReceiptNo())){
                        commandCodes.add(rcd.getReceiptNo());
                    }
                }
                Map<String, String> referenceCodeMap = whCommandService.findReferenceCodesByCommdCodes(commandCodes);
                for(PhyWhSkuStockRcdVO rcd : rcdList){
                    if(isCommandCode(rcd.getReceiptNo())){
                        rcd.setReferenceCode(referenceCodeMap.get(rcd.getReceiptNo()));
                    }else{
                        rcd.setReferenceCode(rcd.getReceiptNo());
                    }
                }
            }
            pagination.setResultList(rcdList);
        }
        return pagination;
    }

    private boolean isCommandCode(String commandLike){
        return EmptyUtil.isNotEmpty(commandLike) && commandLike.startsWith("CMD");
    }

    @Override
    public int findWhWmsStockRecordCount(WhWmsSkuStockRecordCond whWmsSkuStockRecordCond) {
        return   whWmsSkuStockRecordMapper.countWhWmsStockRecord(whWmsSkuStockRecordCond);
    }

    @Override
    public WhPhysicalWarehouse computeDispatchPhysicalWarehouse(String dispatchWhCode, Map<String, Integer> skuQuantityMap, Long targetDistrict) {
        WhWarehouse warehouse = whInfoService.findWarehouseByCode(dispatchWhCode);
        if(NullUtil.isNull(warehouse)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]逻辑仓不存在",dispatchWhCode));
        }
        if(NullUtil.isNull(warehouse.getCommodityStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]逻辑仓商品状态未设置",dispatchWhCode));
        }
        List<WhPhysicalWarehouseVO> phyWhList = whInfoService.findPhysicalWarehouseByWarehouseCode(dispatchWhCode);
        if(EmptyUtil.isNotEmpty(phyWhList)){
            //根据包裹物理仓和包裹区县ID查询优先发货的物理仓
            List<String> phyWhCodeList = new ArrayList<>();
            Map<String,WhPhysicalWarehouseVO> phyWhMap = new HashMap<>();
            for(WhPhysicalWarehouseVO phyWh : phyWhList){
                phyWhCodeList.add(phyWh.getCode());
                phyWhMap.put(phyWh.getCode(),phyWh);
            }
            List<WhDistrictPhysicalWarehouseVO> sortPhyWhList = whInfoService.findDistrictPyWarehouseByCodeAndDistrictId(phyWhCodeList,targetDistrict);
            List<String> skuCodes = Arrays.asList(skuQuantityMap.keySet().toArray(new String[skuQuantityMap.size()]));
            PhyWhStockCond cond = new PhyWhStockCond();
            cond.setSkuCodes(skuCodes);
            cond.setSkuStatus(warehouse.getCommodityStatus());
            for(WhDistrictPhysicalWarehouseVO phyWh : sortPhyWhList){
                cond.setPhysicalWarehouseCode(phyWh.getPhysicalWarehouseCode());
                List<PhyWhStockVO> stockList = findPhyWhStockByCond(cond);
                if(isStockEnough(stockList,skuQuantityMap)){
                    return phyWhMap.get(phyWh.getPhysicalWarehouseCode());
                }
            }
        }
        return null;
    }

    private boolean isStockEnough(List<PhyWhStockVO> stockList,Map<String, Integer> skuQuantityMap){
        Map<String,Integer> phyWhSkuStockMap =singlePhyWhSingleSkuStatusStockToMap(stockList);
        boolean enough = true;
        for(Map.Entry<String,Integer> needEntry : skuQuantityMap.entrySet()){
            Integer phyWhCanUseQuantity = phyWhSkuStockMap.get(needEntry.getKey());
            if(NullUtil.isNull(phyWhCanUseQuantity)){
                phyWhCanUseQuantity = 0;
            }
            if(phyWhCanUseQuantity<needEntry.getValue()){
                enough = false;
                break;
            }
        }
        return enough;
    }

    private Map<String,Integer> singlePhyWhSingleSkuStatusStockToMap(List<PhyWhStockVO> stockList){
        Map<String,Integer> phyWhSkuStockMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(stockList)){
            for(PhyWhStockVO stock : stockList){
                phyWhSkuStockMap.put(stock.getSkuCode(),stock.getCanUseQuantity());
            }
        }
        return phyWhSkuStockMap;
    }

    @Override
	public List<WhWmsSkuStockVO> listExpiryDateSku(WhWmsSkuStockVO cond) {
        return mapper.listExpiryDateSku(cond);
	}

    @Override
    public List<WhWmsSkuStockVO> listExpiryDateSkuForCheckRule(WhWmsSkuStockVO cond) {
        return mapper.listExpiryDateSkuForCheckRule(cond);
    }

    @Override
    public List<WhWmsSkuStockDiffVO> findWhWmsSkuStockDiffList() {
        return mapper.findWhWmsSkuStockDiffList();
    }

    @Override
    public List<PhyWhStockVO> findPhyWhStockByCond(PhyWhStockCond cond) {
        return mapper.findPhyWhStockByCond(cond);
    }

    @Override
    public List<PhyWhStockVO> findPhyWhSkuTotalQuantityByCond(PhyWhStockCond cond) {
        return mapper.findPhyWhSkuTotalQuantityByCond(cond);
    }

    @Override
    public List<WhGjStockVO> findWhGjStock() {
        return mapper.findWhGjStock();
    }

    @Override
    public List<WhGjStockVO> findWhGjStockByLimit(int pageSize,int pageNum) {
        return mapper.findWhGjStockByLimit(pageSize,pageNum);
    }
}
