package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStockRecord;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockRecordService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockRecordVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2016/3/23.
 */
@Service("whWmsSkuStockRecordService")
public class WhWmsSkuStockRecordServiceImpl implements WhWmsSkuStockRecordService {
    @Autowired
    private WhWmsSkuStockRecordMapper mapper;

    @Override
    public WhWmsSkuStockRecordVO create(WhWmsSkuStockRecordVO vo) {
        WhWmsSkuStockRecord recordStock = BeanUtil.buildFrom(vo, WhWmsSkuStockRecord.class);
        mapper.insert(recordStock);
        vo.setId(recordStock.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsSkuStockRecordVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo, WhWmsSkuStockRecord.class))!=0;
    }

    @Override
    public WhWmsSkuStockRecordVO findById(Long id) {
        WhWmsSkuStockRecord recordStock = mapper.selectByPrimaryKey(id);
        if(recordStock!=null){
            return BeanUtil.buildFrom(recordStock,WhWmsSkuStockRecordVO.class);
        }
        return null;
    }
}
