package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.utils.*;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuBarcodeCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuBarcodeMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcodeExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuBarcodeService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2016/3/25.
 */
@Service("whWmsSkuBarcodeService")
public class WhWmsSkuBarcodeServiceImpl implements WhWmsSkuBarcodeService {

    @Autowired
    private WhWmsSkuBarcodeMapper mapper;

    @Override
    public WhWmsSkuBarcodeVO create(WhWmsSkuBarcodeVO vo) {
        WhWmsSkuBarcode barcode = BeanUtil.buildFrom(vo, WhWmsSkuBarcode.class);
        mapper.insert(barcode);
        vo.setId(barcode.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsSkuBarcodeVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo, WhWmsSkuBarcode.class))!=0;
    }

    @Override
    public WhWmsSkuBarcodeVO findById(Long id) {
        WhWmsSkuBarcode barcode = mapper.selectByPrimaryKey(id);
        if(barcode!=null){
            return BeanUtil.buildFrom(barcode,WhWmsSkuBarcodeVO.class);
        }
        return null;
    }

    @Override
    public WhWmsSkuBarcode findMaxBatchNo(String skuCode, String date,String prodDate) {
        return  mapper.findMaxBatchNo(skuCode,date,prodDate);
    }

    @Override
    public WhWmsSkuBarcode findMaxBatchNoByCond(WhWmsSkuBarcodeCond cond) {
        return  mapper.findMaxBatchNoByCond(cond);
    }

    @Override
    public WhWmsSkuBarcodeVO findSkuInfoBySkuCode(String skuCode) {
        WhWmsSkuBarcodeCond cond = new WhWmsSkuBarcodeCond();
        cond.setSkuCode(skuCode);
        List<WhWmsSkuBarcodeVO> wmsSkuBarcodeVOs = mapper.findSkuInfoBySkuCode(cond);
        if (CollectionUtils.isNotEmpty(wmsSkuBarcodeVOs)){
            return wmsSkuBarcodeVOs.get(0);
        }
        return null;
    }

    @Override
    public Integer countBatchBySkuCode(String skuCode) {
    	WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
    	example.createCriteria().andSkuCodeEqualTo(skuCode);
        return  mapper.countByExample(example);
    }
    
    @Override
    public Integer countBatchByReferenceCode(String whCmdCode,String skuCode,String referenceCode) {
        return  mapper.countBatchByReferenceCode(whCmdCode,skuCode,referenceCode);
    }

    @Override
    public List<WhWmsSkuBarcodeVO> getWmsSkuBarcodeByCond(WhWmsSkuBarcodeVO vo) {
        List<WhWmsSkuBarcode> list= mapper.getByCond(vo);
        List<WhWmsSkuBarcodeVO> voList = BeanUtil.buildListFrom(list, WhWmsSkuBarcodeVO.class);
        return voList;
    }

    @Override
    public Map<String, WhWmsSkuBarcodeVO> getBarcodeMap(List<String> barcodes) {
        Map<String,WhWmsSkuBarcodeVO> barcodeMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(barcodes)){
            WhWmsSkuBarcodeVO barcodeCond = new WhWmsSkuBarcodeVO();
            barcodeCond.setBarCodeList(barcodes);
            List<WhWmsSkuBarcodeVO> barcodeList = getWmsSkuBarcodeByCond(barcodeCond);
            if(EmptyUtil.isNotEmpty(barcodeList)){
                for(WhWmsSkuBarcodeVO barcodeVO : barcodeList){
                    barcodeMap.put(barcodeVO.getBarCode(),barcodeVO);
                }
            }
        }
        return barcodeMap;
    }

    @Override
    public List<String> findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(String skuCode) {
        List<String> r = new ArrayList<>();
        for (WhWmsSkuBarcode whWmsSkuBarcode : findBarCodesEntityConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode)) {
            r.add(whWmsSkuBarcode.getBarCode());
        }
        return CollectionUtils.isEmpty(r)?Collections.<String>emptyList():r;
    }

    @Override
    public List<String> findBarCodesConditionBySkuCodeAndSortByExpiredAsc(String skuCode) {
        List<String> r = new ArrayList<>();
        for (WhWmsSkuBarcode whWmsSkuBarcode : findBarCodesEntityConditionBySkuCodeAndSortByExpiredAsc(skuCode)) {
            r.add(whWmsSkuBarcode.getBarCode());
        }
        return CollectionUtils.isEmpty(r)?Collections.<String>emptyList():r;
    }

    @Override
    public List<String> findBarCodesConditionBySkuCodeAndNullExpired(String skuCode) {
        List<String> r = new ArrayList<>();
        for (WhWmsSkuBarcode whWmsSkuBarcode : findBarCodesEntityConditionBySkuCodeAndNullExpired(skuCode)) {
            r.add(whWmsSkuBarcode.getBarCode());
        }
        return CollectionUtils.isEmpty(r)?Collections.<String>emptyList():r;
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesForPickSkuStock(String skuCode) {
        return findBarCodesForPickSkuStock(Collections.singletonList(skuCode));
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesForPickSkuStock(List<String> skuCodes) {
        return mapper.findBarCodesForPickSkuStock(skuCodes);
    }

    @Override
    public List<WhWmsSkuBarcode> findBarcodesForAltOrPcsRtnConnect(List<String> skuCodes,boolean allowExpire) {
        return mapper.findBarcodesForAltOrPcsRtnConnect(skuCodes,allowExpire);
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndUnexpiredSortByExpiredAsc(String skuCode) {
        List<String> r = new ArrayList<>();
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andExpirationDateGreaterThanOrEqualTo(DateUtil.getNow());
        example.setOrderByClause(" EXPIRATION_DATE ASC,PROD_DATE ASC");
        List<WhWmsSkuBarcode> list = mapper.selectByExample(example);
        return CollectionUtils.isEmpty(list)?Collections.<WhWmsSkuBarcode>emptyList():list;
    }

    @Override
    public WhWmsSkuBarcode findMinProdOrExpiryDateByBarCodes(List<String> barCodes) {
        return mapper.findMinProdOrExpiryDateByBarCodes(barCodes);
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndSortByExpiredAsc(String skuCode) {
        List<String> r = new ArrayList<>();
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        example.setOrderByClause(" EXPIRATION_DATE ASC,PROD_DATE ASC");
        List<WhWmsSkuBarcode> list = mapper.selectByExample(example);
        return CollectionUtils.isEmpty(list)?Collections.<WhWmsSkuBarcode>emptyList():list;
    }

    @Override
    public List<WhWmsSkuBarcode> findBarCodesEntityConditionBySkuCodeAndNullExpired(String skuCode) {
        List<String> r = new ArrayList<>();
        WhWmsSkuBarcodeExample example = new WhWmsSkuBarcodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andExpirationDateIsNull();
        List<WhWmsSkuBarcode> list = mapper.selectByExample(example);
        return CollectionUtils.isEmpty(list)?Collections.<WhWmsSkuBarcode>emptyList():list;
    }

    @Override
    public Integer findSkuShelfLifeBySkuCode(String skuCode) {
        return mapper.findSkuShelfLifeBySkuCode(skuCode);
    }

    @Override
    public List<WhWmsSkuBarcodeVO> findExpiryDateSkuInfo(WhWmsSkuBarcodeCond cond) {
        return mapper.findExpiryDateSkuInfo(cond);
    }

    @Override
    public Pagination<WhWmsSkuBarcodeVO> findExpiryDateSkuInfoByCondPage(WhWmsSkuBarcodeCond cond) {
        Pagination<WhWmsSkuBarcodeVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = findExpiryDateSkuInfoCount(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return page;
        List<WhWmsSkuBarcodeVO> expiryDateSkuInfos = mapper.findExpiryDateSkuInfo(cond);
        page.setResultList(expiryDateSkuInfos);
        return page;
    }

    @Override
    //先进先出:优先出库最早过期的,其次生产日期最早的,再次入库时间最早的
    public int compareBarCode(WhWmsSkuBarcode barcode1,WhWmsSkuBarcode barcode2){
        //过期日期比较
        int result = compareBarcodeDate(barcode1.getExpirationDate(),barcode2.getExpirationDate());
        if(result==0){
            //生产日期比较
            result = compareBarcodeDate(barcode1.getProdDate(),barcode2.getProdDate());
            if(result==0){
                //入库时间比较
                result = compareBarcodeDate(barcode1.getFirstInDate(),barcode2.getFirstInDate());
            }
        }
        return result;
    }

    //日期比较
    private int compareBarcodeDate(Date o1, Date o2){
        Date today = DateUtil.dayStart(DateUtil.getNow());
        if(NullUtil.isNull(o1)){
            o1 = today;
        }
        if(NullUtil.isNull(o2)){
            o2 = today;
        }
        return o1.compareTo(o2);
    }

    public int findExpiryDateSkuInfoCount(final WhWmsSkuBarcodeCond cond) {
        return mapper.findExpiryDateSkuInfoCount(cond);
    }

    @Override
    public boolean modifyExpiryDate(WhWmsSkuBarcode cond) {
        return mapper.updateExpiryDateByPrimaryKey(cond)>0;
    }
}
