package com.thebeastshop.pegasus.service.warehouse.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsWarehouseAreaMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsReportService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;

@Service("whWmsReportService")
public class WhWmsReportServiceImpl implements WhWmsReportService{

	@Autowired
    private WhWmsSkuStockMapper skuStockMapper;
	@Autowired
	private WhWmsWarehouseAreaMapper whWmsWarehouseAreaMapper;
	@Override
	public List<WhWmsSkuStockVO> getStockByWarehouseCode(String warehouseCode) {
		List<WhWmsSkuStockVO> whWmsSkuStockVOList =  skuStockMapper.getStockByWarehouseCode(warehouseCode);
		List<WhWmsWarehouseArea> whWmsWarehouseAreaList = whWmsWarehouseAreaMapper.getAll();
		Map<String,String> map = new HashMap<>();
		if(whWmsWarehouseAreaList != null && whWmsWarehouseAreaList.size() > 0){
			for(WhWmsWarehouseArea whWmsWarehouseArea:whWmsWarehouseAreaList){
				map.put(whWmsWarehouseArea.getHouseType(),whWmsWarehouseArea.getHouseTypeName());
			}
		}
		if(whWmsSkuStockVOList != null && whWmsSkuStockVOList.size() > 0){
			for(WhWmsSkuStockVO vo:whWmsSkuStockVOList){
				vo.setHouseTypeName(map.get(vo.getHouseType()));
			}
		}
		return  whWmsSkuStockVOList;
	}

	@Override
	public Map<String, Object> getStockCountByWarehouseCode(
			String warehouseCode) {
		return skuStockMapper.getStockCountByWarehouseCode(warehouseCode);
	}

	@Override
	public List<WhWmsSkuStockVO> getShelvesStockByWarehouseCode(
			String warehouseCode) {
		List<WhWmsSkuStockVO> whWmsSkuStockVOList =  skuStockMapper.getShelvesStockByWarehouseCode(warehouseCode);
		List<WhWmsWarehouseArea> whWmsWarehouseAreaList = whWmsWarehouseAreaMapper.getAll();
		Map<String,String> map = new HashMap<>();
		if(whWmsWarehouseAreaList != null && whWmsWarehouseAreaList.size() > 0){
			for(WhWmsWarehouseArea whWmsWarehouseArea:whWmsWarehouseAreaList){
				map.put(whWmsWarehouseArea.getHouseType(),whWmsWarehouseArea.getHouseTypeName());
			}
		}
		if(whWmsSkuStockVOList != null && whWmsSkuStockVOList.size() > 0){
			for(WhWmsSkuStockVO vo:whWmsSkuStockVOList){
				vo.setHouseTypeName(map.get(vo.getHouseType()));
			}
		}
		return whWmsSkuStockVOList;
	}

}
