/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * wms 补货service
 * @author Eric.Lou
 * @version $Id: WhWmsReplenishServiceImpl.java, v 0.1 2016-05-30 下午5:30
 */
@Service("whWmsReplenishService")
public class WhWmsReplenishServiceImpl implements WhWmsReplenishService {

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;//wms 库存 service

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;//wms barcode service

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;//wms 库位 service

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;//wms 移库 service

    private static class ReplenishCond{
        private String type;
        private Integer shelvesType;
        public ReplenishCond(String type,Integer shelvesType){
            this.type = type;
            this.shelvesType = shelvesType;
        }
        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getShelvesType() {
            return shelvesType;
        }

        public void setShelvesType(Integer shelvesType) {
            this.shelvesType = shelvesType;
        }

        public WhWmsHouseShelvesCond toShelvesCond(){
            if(this.getType()==null ||  !this.getType().equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"暂时只支持普通区这个类型的区域");
            }
            if(this.getShelvesType()==null || !this.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"暂时只支持拣货库位这个类型的库位");
            }
            WhWmsHouseShelvesCond c = new WhWmsHouseShelvesCond();
            c.setType(this.getType());//区域类型
            c.setShelvesType(this.getShelvesType());//库位属性
            c.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);//这里写死是良品属性
            c.setStorageType(WhWmsHouseShelvesVO.STORAGE_TYPE_NORMAL_TEMPERATURE);//这里写死是普通常温
            c.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);//这里写死是库位有效状态,非冻结非禁用
            c.setCurrpage(null);
            c.setPagenum(null);
            return c;
        }
    }

    private static class StockCond{
        private WhWmsHouseShelvesVO vo;
        StockCond(WhWmsHouseShelvesVO vo){
            this.vo = vo;
        }
        public WhWmsSkuStockVO toExternalStockCond(){
            if(vo==null){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"库位属性为空");
            }
            WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
            cond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            cond.setHouseType(vo.getHouseType());
            cond.setSkuCode(vo.getSkuCode());
            cond.setSkuStatus(vo.getSkuStatus());
            return cond;
        }
    }

    @Override
    public List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(String type, Integer shelvesType) {
        return findNeedToReplenishShelves(new ReplenishCond(type,shelvesType));
    }

    @Override
    public void processReplenish(final WhWmsHouseShelvesVO shelvesVO) {
        if (shelvesVO.getShelvesType() == null || !shelvesVO.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)) {
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM, "暂时只支持拣货库位这个类型的库位");
        }
        if(!(shelvesVO.getSafeAmount()!=null&&shelvesVO.getSafeAmount()>0&&shelvesVO.getMaxAmount()!=null&&shelvesVO.getMaxAmount()>0&&shelvesVO.getMaxAmount()>shelvesVO.getSafeAmount())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM, "拣货库位最大库存必须大于安全库存");
        }
        int need = sumAvailableAccountIncludeShelf(shelvesVO) - shelvesVO.getSafeAmount();//当前库位的可用库存 - 当前库位的安全库存
        if(need >= 0){//当前库位可用库存大于当前库位的安全库存
            return ;
        }
        List<WhWmsSkuStockVO> stocks = whWmsSkuStockService.findWmsSkuAvailableAccount(new StockCond(shelvesVO).toExternalStockCond());
        if (sumAvailableAccountExclusiveShelfAndIncludeType(stocks, shelvesVO) > 0) {//保管库位可用库存大于0
            List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(shelvesVO.getSkuCode()));
            List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(shelvesVO.getSkuCode()));
            barCodesBySku.addAll(_barCodesBySku);
            for (String barcode : barCodesBySku) {
                if (sumAvailableAccountIncludeShelf(shelvesVO) - shelvesVO.getMaxAmount()<0) {//当前库位可用库存小于库位最大库存,补货
                    WhWmsSkuStockVO cond = new StockCond(shelvesVO).toExternalStockCond();
                    cond.setBarCode(barcode);
                    stocks = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    //排除当前库位的库存
                    final List<WhWmsSkuStockVO> stocksWithOutSelf = new ArrayList<>();
                    for (WhWmsSkuStockVO stock : stocks) {
                        if (!stock.getShelvesCode().equals(shelvesVO.getCode())) {
                            stocksWithOutSelf.add(stock);
                        }
                    }
                    //排除不是保管库位的库存
                    final List<WhWmsSkuStockVO> stocksTypeisHolding = new ArrayList<>();
                    for (final WhWmsSkuStockVO stock : stocksWithOutSelf) {
                        WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        if (hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)) {//判断库位属性必须是保管区
                            if(stock.getAvailableAccount()>0){//可用数大于0
                                stocksTypeisHolding.add(stock);
                            }
                        }
                    }
                    boolean breakFlag = false;
                    //新建移库任务并自动完成
                    for (final WhWmsSkuStockVO stockHolding : stocksTypeisHolding) {
                        //每次执行前再判断当前库位可用库存是否小于最大库存
                        int needToMoveNum = sumAvailableAccountIncludeShelf(shelvesVO) - shelvesVO.getMaxAmount();
                        if (needToMoveNum < 0) {//当前库位可用库存小于库位最大库存,补货
                            needToMoveNum = 0 - needToMoveNum;
                            int quantity = needToMoveNum <= stockHolding.getAvailableAccount()
                                    ? needToMoveNum : stockHolding.getAvailableAccount();
                            //调用移库接口
                            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                            moveStockVO.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
                            moveStockVO.setCreateUserId(1l);//system user
                            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                            List<WhWmsMoveSkuVO> moveStockList = new ArrayList<>();
                            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                            moveSkuVO.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
                            moveSkuVO.setSkuCode(shelvesVO.getSkuCode());
                            moveSkuVO.setSkuStatus(shelvesVO.getSkuStatus());
                            moveSkuVO.setBarCode(stockHolding.getBarCode());
                            moveSkuVO.setOriginalHouseType(stockHolding.getHouseType());
                            moveSkuVO.setOriginalShelvesCode(stockHolding.getShelvesCode());
                            moveSkuVO.setTargetHouseType(shelvesVO.getHouseType());
                            moveSkuVO.setTargetShelvesCode(shelvesVO.getCode());
                            moveSkuVO.setAmount(quantity);
                            moveStockList.add(moveSkuVO);
                            moveStockVO.setMoveSkuList(moveStockList);
                            whWmsMoveStockService.newMoveStock(moveStockVO);
                        } else {
                            breakFlag = true;
                            break;
                        }
                    }
                    if (breakFlag) {
                        break;
                    }

                } else {
                    break;
                }
            }
        }
    }


    //================private methods
    private List<WhWmsHouseShelvesVO> findNeedToReplenishShelves(ReplenishCond cond){
        List<WhWmsHouseShelvesVO> shelves = new ArrayList<>();
        List<WhWmsHouseShelvesVO> allMatches = whWmsHouseShelvesService.getHouseShelvesByCond(cond.toShelvesCond());
        for (WhWmsHouseShelvesVO curr : allMatches) {
            if(curr.getSafeAmount()!=null&&curr.getSafeAmount()>0&&curr.getMaxAmount()!=null&&curr.getMaxAmount()>0&&curr.getMaxAmount()>curr.getSafeAmount()){
                //安全库存字段不为空且大于0,最大库存字段不为空且大于0,最大库存>安全库存
                shelves.add(curr);
            }
        }
        return shelves;
    }

    /**
     * 不包含当前库位的且库位属性必须是保管库位
     * @param rcds
     * @param currShelf
     * @return
     */
    private int sumAvailableAccountExclusiveShelfAndIncludeType(List<WhWmsSkuStockVO> rcds,WhWmsHouseShelvesVO currShelf){
        int sum = 0;
        if(CollectionUtils.isNotEmpty(rcds)){
            for (WhWmsSkuStockVO rcd : rcds) {
                WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(rcd.getShelvesCode());
                if(!hs.getCode().equals(currShelf.getCode())){//不是当前库位的库存数据
                    if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){//判断库位属性 保管库位
                        sum+=rcd.getAvailableAccount();
                    }
                }
            }
        }
        return sum;
    }

    /**
     * 包含当前库位的可用数
     * @param shelvesVO
     * @return
     */
    private int sumAvailableAccountIncludeShelf(WhWmsHouseShelvesVO shelvesVO){
        int sum = 0;
        WhWmsSkuStockVO cond = new StockCond(shelvesVO).toExternalStockCond();
        cond.setShelvesCode(shelvesVO.getCode());
        List<WhWmsSkuStockVO> rcds = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
        if(CollectionUtils.isNotEmpty(rcds)) {
            for (WhWmsSkuStockVO rcd : rcds) {
                sum+=rcd.getAvailableAccount();
            }
        }
        return sum;
    }


}
