package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishRuleCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuPickShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishRuleBlacklistMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishRuleHousetypeMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsReplenishRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsReplenishRuleCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import page.Pagination;

import java.util.*;

/**
 * @author xw
 * @create 2018-08-14 16:25
 */
@Service("whWmsReplenishRuleService")
public class WhWmsReplenishRuleServiceImpl implements WhWmsReplenishRuleService {

    @Autowired
    private WhWmsReplenishRuleMapper whWmsReplenishRuleMapper;

    @Autowired
    private WhWmsReplenishRuleHousetypeMapper whWmsReplenishRuleHousetypeMapper;

    @Autowired
    private WhWmsReplenishRuleBlacklistMapper whWmsReplenishRuleBlacklistMapper;

    @Autowired
    private WhWmsReplenishRuleCustomMapper whWmsReplenishRuleCustomMapper;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsReplenishInfoService whWmsReplenishInfoService;

    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Override
    public Pagination<WhWmsReplenishRuleVO> pageWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond) {
        Pagination<WhWmsReplenishRuleVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        int count = countWhWmsReplenishRule(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count))
            return page;
        List<WhWmsReplenishRuleVO> replenishRuleVOs = whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleVOByCond(cond);
        page.setResultList(replenishRuleVOs);
        return page;
    }

    @Override
    public List<WhWmsReplenishRuleVO> listWhWmsReplenishRuleVOByCond(WhWmsReplenishRuleCond cond) {
        cond.setCurrpage(null);
        return whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishRule> listWhWmsReplenishRuleByCond(WhWmsReplenishRuleCond cond) {
        WhWmsReplenishRuleExample example = buildWhWmsReplenishRuleExampleByCond(cond);
        return whWmsReplenishRuleMapper.selectByExample(example);
    }

    @Override
    public WhWmsReplenishRule findWhWmsReplenishRuleById(Long id) {
        return whWmsReplenishRuleMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsReplenishRule findWhWmsReplenishRuleByPhyCode(String phyCode) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setPhysicalWarehouseCode(phyCode);
        List<WhWmsReplenishRule> replenishRules = listWhWmsReplenishRuleByCond(cond);
        if (CollectionUtils.isNotEmpty(replenishRules)){
            return replenishRules.get(0);
        }
        return null;
    }

    private void aggregationWmsSkuStock(List<WhWmsSkuStockVO> wmsSkuStockVOs,Map<String,WhWmsSkuStockVO> skuStockVOMap){
        String key = "";
        for (WhWmsSkuStockVO skuStockVO : wmsSkuStockVOs){
            key = skuStockVO.getSkuCode()+skuStockVO.getShelvesCode();
            WhWmsSkuStockVO skuStockVO1 = skuStockVOMap.get(key);
            if (EmptyUtil.isEmpty(skuStockVO1)){
                skuStockVOMap.put(key,skuStockVO);
            }else{
                skuStockVO1.setTotalAmount(getStockRemoveNull(skuStockVO.getTotalAmount())+getStockRemoveNull(skuStockVO1.getTotalAmount()));
                skuStockVO1.setAvailableAmount(getStockRemoveNull(skuStockVO.getAvailableAmount())+getStockRemoveNull(skuStockVO1.getAvailableAmount()));
            }
        }
    }

    private int getStockRemoveNull(Integer quantity){
        return EmptyUtil.isEmpty(quantity)?0:quantity;
    }

    private Set<String> fetchBlackListSkus(WhWmsReplenishRuleVO replenishRuleVO){
        // 黑名单sku+二级类目
        List<String> blacklistSkus = new ArrayList<>();
        List<Long> blacklistCategorys = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleBlacklistVOs())){
            for (WhWmsReplenishRuleBlacklistVO blacklistVO : replenishRuleVO.getRuleBlacklistVOs()){
                if (EmptyUtil.isNotEmpty(blacklistVO.getSkuCode())){
                    blacklistSkus.add(blacklistVO.getSkuCode());
                }
                if (EmptyUtil.isNotEmpty(blacklistVO.getSecondCategoryId())){
                    blacklistCategorys.add(blacklistVO.getSecondCategoryId());
                }
            }
        }
        Set<String> skuCodeSet = new HashSet<>();
        if (blacklistCategorys.size()>0){
            WhWmsReplenishRuleCond replenishRuleCond = new WhWmsReplenishRuleCond();
            replenishRuleCond.setSecondCategoryIds(blacklistCategorys);
            List<WhWmsReplenishRuleVO> replenishRuleVOs = listPcsSkuVOsByCond(replenishRuleCond);
            for (WhWmsReplenishRuleVO ruleVO : replenishRuleVOs){
                skuCodeSet.add(ruleVO.getSkuCode());
            }
        }

        // 黑名单中的二级类目下的sku 与 黑名单中的sku 并集
        if (blacklistSkus.size() > 0){
            skuCodeSet.addAll(blacklistSkus);
        }
        return skuCodeSet;
    }

    private WhWmsReplenishRuleVO checkBeformReplenish(WhWmsReplenishInfoCond cond){
        Validation.paramNotNull(cond.getPhysicalWarehouseCode(), "物理仓为空");
        WhWmsReplenishRule replenishRule = findWhWmsReplenishRuleByPhyCode(cond.getPhysicalWarehouseCode());
        if (EmptyUtil.isEmpty(replenishRule)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED, "仓库["+cond.getPhysicalWarehouseCode()+"]，没有设置此仓库的补货规则!");
        }else if(PegasusConstants.YES != replenishRule.getRuleState()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"仓库["+cond.getPhysicalWarehouseCode()+"]，补货规则未开启!");
        }

        WhWmsReplenishRuleVO replenishRuleVO = findWhWmsReplenishRuleVOById(replenishRule.getId(),true,true);
        if (CollectionUtils.isEmpty(replenishRuleVO.getRuleHousetypeVOs())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"仓库["+cond.getPhysicalWarehouseCode()+"]，适用库区规则未设置!");
        }
        return replenishRuleVO;
    }

    @Override
    public String replenishInfoGenerateByCond(WhWmsReplenishInfoCond cond) throws WarehouseException {
        WhWmsReplenishRuleVO replenishRuleVO = checkBeformReplenish(cond);
        List<String> houseTypes = new ArrayList<>();
        for (WhWmsReplenishRuleHousetypeVO housetypeVO : replenishRuleVO.getRuleHousetypeVOs()){
            houseTypes.add(housetypeVO.getHouseType());
        }

        Set<String> skuCodeSet = fetchBlackListSkus(replenishRuleVO);
        WhWmsShelvesSkuInfoCond skuInfoCond = new WhWmsShelvesSkuInfoCond();
        skuInfoCond.setHouseTypes(houseTypes);
        // 黑名单sku
        if (skuCodeSet.size() > 0){
            if (CollectionUtils.isNotEmpty(cond.getSkuCodes())){
                Set<String> needSkuCodeSet = new HashSet<>();
                for (String skuCode : cond.getSkuCodes()){
                    if (!skuCodeSet.contains(skuCode)){
                        needSkuCodeSet.add(skuCode);
                    }
                }
                if (CollectionUtils.isNotEmpty(needSkuCodeSet)){
                    skuInfoCond.setSkuCodes(Arrays.asList(needSkuCodeSet.toArray(new String[needSkuCodeSet.size()])));
                }else{
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"给定的sku都不允许补货!");
                }
            }else{
                skuInfoCond.setNoSkuCodes(Arrays.asList(skuCodeSet.toArray(new String[skuCodeSet.size()])));
            }
        }else if(CollectionUtils.isNotEmpty(cond.getSkuCodes())){
            skuInfoCond.setSkuCodes(cond.getSkuCodes());
        }
        // a) 查询出所有默认库区在补货规则适用库区范围内的 sku
        // b) 剔除在黑名单范围内的 sku
        // 获取sku及默认拣货位列表
        skuInfoCond.setFetchSkuPickShelvesFlag(true);
        List<WhWmsShelvesSkuInfoVO> skuInfos = whWmsShelvesSkuInfoService.getSkuInfoByCond(skuInfoCond);
        StringBuilder warnMsg = new StringBuilder();
        Set<String> shelvesCodes = new HashSet<>();
        if (CollectionUtils.isNotEmpty(skuInfos)) {
            List<String> skuInfoCodes = new ArrayList<>();
            Map<String,Map<String,WhWmsSkuPickShelves>> skuPickShelvesMap = new HashMap<>();
            for (WhWmsShelvesSkuInfoVO skuInfoVO : skuInfos){
                if (CollectionUtils.isNotEmpty(skuInfoVO.getWhWmsSkuPickShelves())){
                    skuInfoCodes.add(skuInfoVO.getSkuCode());
                    for (WhWmsSkuPickShelves skuPickShelves : skuInfoVO.getWhWmsSkuPickShelves()){
                        Map<String,WhWmsSkuPickShelves> shelvesCodePickShelvesMap = skuPickShelvesMap.get(skuInfoVO.getSkuCode());
                        if (EmptyUtil.isEmpty(shelvesCodePickShelvesMap)){
                            shelvesCodePickShelvesMap = new HashMap<>();
                            skuPickShelvesMap.put(skuPickShelves.getSkuCode(),shelvesCodePickShelvesMap);
                        }
                        shelvesCodes.add(skuPickShelves.getShelvesCode());
                        shelvesCodePickShelvesMap.put(skuPickShelves.getShelvesCode(),skuPickShelves);
                    }
                }
            }

            List<WhWmsSkuStockVO> newWmsSkuStockVOs = new ArrayList<>();
            WhWmsSkuStockVO skuStockCond = new WhWmsSkuStockVO();
            if (skuInfoCodes.size()>0){
                skuStockCond.setSkuCodeList(skuInfoCodes);
                buildNewWmsSkuStockVOs(newWmsSkuStockVOs,skuStockCond,shelvesCodes,skuPickShelvesMap,cond);

                // 生成补货数据
                if (newWmsSkuStockVOs.size()>0){
                    buildAndCreateReplenishInfo(newWmsSkuStockVOs,skuStockCond,cond,warnMsg);
                }else{
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"当前仓库["+cond.getPhysicalWarehouseCode()+"]"+"没有需要生成补货的数据!");
                }
            }
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"当前仓库["+cond.getPhysicalWarehouseCode()+"]"+"没有符合条件的SKU信息!");
        }
        return warnMsg.toString();
    }

    private void buildAndCreateReplenishInfo(List<WhWmsSkuStockVO> newWmsSkuStockVOs,WhWmsSkuStockVO skuStockCond,
                                               WhWmsReplenishInfoCond cond,StringBuilder warnMsg){
        List<WhWmsReplenishInfoVO> wmsReplenishInfoVOs = new ArrayList<>();
        List<String> primaryKey = new ArrayList<>();
        String keyStr = "";
        for (WhWmsSkuStockVO skuStockVO1 : newWmsSkuStockVOs){
            WhWmsReplenishInfoVO replenishInfoVO = new WhWmsReplenishInfoVO();
            replenishInfoVO.setPhysicalWarehouseCode(skuStockCond.getPhysicalWarehouseCode());
            replenishInfoVO.setSkuCode(skuStockVO1.getSkuCode());
            replenishInfoVO.setShelvesCode(skuStockVO1.getShelvesCode());
            replenishInfoVO.setHouseType(skuStockVO1.getHouseType());
            replenishInfoVO.setReplenishStates(WhWmsReplenishInfoVO.STATES_WAIT_REPLENISH);
            replenishInfoVO.setLessSafeMinStock(skuStockVO1.isLessSafeMinStock());

            keyStr = skuStockCond.getPhysicalWarehouseCode()+skuStockVO1.getSkuCode()+skuStockVO1.getShelvesCode();
            // 逻辑过滤 底层再实际数据过滤 【同一sku，同一拣货位，只能存在一条“待补货”或“补货中”的数据】
            if (primaryKey.contains(keyStr+replenishInfoVO.getReplenishStates())){
                continue;
            }else {
                primaryKey.add(keyStr+replenishInfoVO.getReplenishStates());
            }

            WhWmsReplenishInfoCond replenishInfoCond = new WhWmsReplenishInfoCond();
            replenishInfoCond.setPhysicalWarehouseCode(skuStockCond.getPhysicalWarehouseCode());
            replenishInfoCond.setSkuCode(skuStockVO1.getSkuCode());
            replenishInfoCond.setShelvesCode(skuStockVO1.getShelvesCode());
            replenishInfoCond.setReplenishStates(WhWmsReplenishInfoVO.STATES_WAIT_REPLENISH);
            // 待补货 和 补货中 改为 分别判断
            // replenishInfoCond.setReplenishStatesList(Arrays.asList(WhWmsReplenishInfoVO.STATES_WAIT_REPLENISH,WhWmsReplenishInfoVO.STATES_REPLENISHING));
            List<WhWmsReplenishInfo> replenishInfos = whWmsReplenishInfoService.listWhWmsReplenishInfoByCond(replenishInfoCond);
            if (CollectionUtils.isNotEmpty(replenishInfos)){
                warnMsg.append("同一:"+replenishInfoCond.toCustomString()+" 只能存在一条！<br/>");
                continue;
            }
            replenishInfoVO.setCreateUserId(cond.getCreateUserId());
            if(EmptyUtil.isEmpty(replenishInfoVO.getShelvesCode())){
                continue;
            }
            wmsReplenishInfoVOs.add(replenishInfoVO);
        }
        /*if (EmptyUtil.isNotEmpty(warnMsg)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,warnMsg);
        }*/

        // 保存补货数据
        if (wmsReplenishInfoVOs.size()>0){
            WhWmsBatchReplenishInfoVO batchReplenishInfo = new WhWmsBatchReplenishInfoVO();
            batchReplenishInfo.setReplenishInfoList(wmsReplenishInfoVOs);
            batchReplenishInfo.setAutoReplenish(cond.isAutoReplenish());
            batchReplenishInfo.setSourceConnectStart(cond.isSourceConnectStart());
            warnMsg.append(whWmsReplenishInfoService.batchSaveWhWmsReplenishInfoVO(batchReplenishInfo));
        }
    }

    private void buildNewWmsSkuStockVOs(List<WhWmsSkuStockVO> newWmsSkuStockVOs,WhWmsSkuStockVO skuStockCond,
                                        Set<String> shelvesCodes,Map<String,Map<String,WhWmsSkuPickShelves>> skuPickShelvesMap,WhWmsReplenishInfoCond cond){
        // 查询当前物理仓下的，商品状态为：良品 的sku 的库存
        skuStockCond.setPhysicalWarehouseCode(cond.getPhysicalWarehouseCode());
        skuStockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        List<Integer> shelvesTypeList = new ArrayList<>();
        shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);//拣货库位
        // shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);//保管库位
        skuStockCond.setShelvesTypeList(shelvesTypeList);

        List<WhWmsSkuStockVO> wmsSkuStockVOs = null;
        if (cond.isSourceConnectStart()){
            // 波次启动的 查询 良品可用-预占用的库存
            wmsSkuStockVOs = whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(skuStockCond, true);
        }else{
            wmsSkuStockVOs = whWmsSkuStockService.getSkuStocksByShelvesCondForReport(skuStockCond);
        }

        // 库区查询
        List<String> shelvesCodeList = Arrays.asList(shelvesCodes.toArray(new String[shelvesCodes.size()]));
        List<WhWmsHouseShelves> houseShelves = whWmsHouseShelvesService.getHouseShelvesByCode(shelvesCodeList);
        Map<String,String> houseShelveMap = new HashMap<>();
        for (WhWmsHouseShelves houseShelves1 : houseShelves){
            houseShelveMap.put(houseShelves1.getCode(),houseShelves1.getHouseType());
        }

        Map<String,WhWmsSkuStockVO> skuStockVOMap = new HashMap<>();
        // 按照 sku+库位 聚合库存可用数量
        aggregationWmsSkuStock(wmsSkuStockVOs,skuStockVOMap);

        /*WhWmsSkuPickShelvesCond skuPickShelvesCond = new WhWmsSkuPickShelvesCond();
        skuPickShelvesCond.setSkuCodes(skuStockCond.getSkuCodeList());
        skuPickShelvesCond.setPhysicalWarehouseCode(skuStockCond.getPhysicalWarehouseCode());
        // 通过库位查询需要的sku
        List<WhWmsSkuPickShelves> skuPickShelves = whWmsShelvesSkuInfoService.listSkuPickShelvesByCond(skuPickShelvesCond);
        if (CollectionUtils.isNotEmpty(skuPickShelves)){
            Map<String,String> shelvesSkuMap = new HashMap<>();
            for (WhWmsSkuPickShelves skuPickShelves1 : skuPickShelves){
                shelvesSkuMap.put(skuPickShelves1.getSkuCode(),skuPickShelves1.getShelvesCode());
            }

        }*/
        String shelvesCodeTmp = "";
        List<String> checkRepetition = new ArrayList<>();
        for (String skuCode : skuStockCond.getSkuCodeList()){
            Map<String,WhWmsSkuPickShelves> shelvesCodePickShelvesMap = skuPickShelvesMap.get(skuCode);
            if (EmptyUtil.isNotEmpty(shelvesCodePickShelvesMap)){
                // 默认拣货库位
                WhWmsSkuPickShelves skuPickShelvesTmp = shelvesCodePickShelvesMap.values().iterator().next();
                shelvesCodeTmp = skuPickShelvesTmp.getShelvesCode();
                if (EmptyUtil.isEmpty(shelvesCodeTmp)){
                    continue;
                }
                String primaryKey = skuPickShelvesTmp.getShelvesCode()+skuPickShelvesTmp.getSkuCode();
                if (checkRepetition.contains(primaryKey)){
                    continue;
                }
                // 库存
                WhWmsSkuStockVO wmsSkuStockVO = skuStockVOMap.get(skuCode+shelvesCodeTmp);
                if (EmptyUtil.isNotEmpty(wmsSkuStockVO)){
                    int stockAmount = wmsSkuStockVO.getAvailableAmount();
                    // 库存拣货库位
                    // WhWmsSkuPickShelves wmsStockPickShelvesTmp = shelvesCodePickShelvesMap.get(wmsSkuStockVO.getShelvesCode());
                    if (EmptyUtil.isNotEmpty(skuPickShelvesTmp)){
                        if (!(stockAmount<skuPickShelvesTmp.getSafeMaxStock()
                                || stockAmount<skuPickShelvesTmp.getSafeMinStock())){
                            continue;
                        }
                        // 生成补货数据时，如果当前拣货位可用库存＜安全库存下限，则直接生成补货移库单
                        if (stockAmount<skuPickShelvesTmp.getSafeMinStock()){
                            wmsSkuStockVO.setLessSafeMinStock(true);
                        }
                        newWmsSkuStockVOs.add(wmsSkuStockVO);
                        checkRepetition.add(primaryKey);
                    }
                }else{
                    checkRepetition.add(primaryKey);
                    // 如果没有库存，则组装数据
                    makeNeedReplenishSkuStock(skuStockCond.getPhysicalWarehouseCode(),skuPickShelvesTmp,houseShelveMap,newWmsSkuStockVOs);
                }
            }
        }
    }

    private void makeNeedReplenishSkuStock(String phyCode, WhWmsSkuPickShelves skuPickShelvesTmp,
                                           Map<String,String> houseShelveMap, List<WhWmsSkuStockVO> newWmsSkuStockVOs){
        WhWmsSkuStockVO wmsSkuStockVO = new WhWmsSkuStockVO();
        wmsSkuStockVO.setPhysicalWarehouseCode(phyCode);
        wmsSkuStockVO.setShelvesCode(skuPickShelvesTmp.getShelvesCode());
        wmsSkuStockVO.setHouseType(houseShelveMap.get(skuPickShelvesTmp.getShelvesCode()));
        wmsSkuStockVO.setSkuCode(skuPickShelvesTmp.getSkuCode());
        wmsSkuStockVO.setAvailableAmount(0);
        wmsSkuStockVO.setLessSafeMinStock(true);
        newWmsSkuStockVOs.add(wmsSkuStockVO);
    }

    @Override
    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOById(Long id,boolean fetchHouse,boolean fetchBlack) {
        WhWmsReplenishRuleVO replenishRuleVO = whWmsReplenishRuleCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty(replenishRuleVO)){
            if (fetchHouse){
                replenishRuleVO.setRuleHousetypeVOs(listWhWmsReplenishRuleHousetypeVOByRuleId(id));
            }
            if (fetchBlack){
                replenishRuleVO.setRuleBlacklistVOs(listWhWmsReplenishRuleBlacklistVOByRuleId(id));
            }
        }
        return replenishRuleVO;
    }

    @Override
    public WhWmsReplenishRuleVO findWhWmsReplenishRuleVOByPhyCode(String phyCode, boolean fetchHouse, boolean fetchBlack) {
        WhWmsReplenishRule replenishRule = findWhWmsReplenishRuleByPhyCode(phyCode);
        if (EmptyUtil.isNotEmpty(replenishRule)){
            return findWhWmsReplenishRuleVOById(replenishRule.getId(),fetchHouse,fetchBlack);
        }
        return null;
    }

    @Override
    public List<WhWmsReplenishRuleVO> listPcsSkuVOsByCond(WhWmsReplenishRuleCond cond){
        return whWmsReplenishRuleCustomMapper.listPcsSkuVOsByCond(cond);
    }

    @Override
    public WhWmsReplenishRuleVO saveOrUpdateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        if (EmptyUtil.isNotEmpty(replenishRuleVO.getId())){
            updateWhWmsReplenishRuleVO(replenishRuleVO);
        }else{
            saveWhWmsReplenishRuleVO(replenishRuleVO);
        }
        return replenishRuleVO;
    }

    @Override
    public boolean saveWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        WhWmsReplenishRule replenishRule = BeanUtil.buildFrom(replenishRuleVO,WhWmsReplenishRule.class);
        replenishRule.setCreateTime(DateUtil.getNow());
        boolean result = whWmsReplenishRuleMapper.insert(replenishRule)>0;
        if (result){
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleHousetypeVOs())){
                batchInsertHousetypeByHousetypeVOs(replenishRuleVO.getRuleHousetypeVOs(),replenishRule.getId());
            }
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleBlacklistVOs())){
                batchInsertBlacklistByBlacklistVOs(replenishRuleVO.getRuleBlacklistVOs(),replenishRule.getId());
            }
            replenishRuleVO.setId(replenishRule.getId());
        }
        return result;
    }

    private void batchInsertHousetypeByHousetypeVOs(List<WhWmsReplenishRuleHousetypeVO> ruleHousetypeVOs,Long ruleId){
        List<WhWmsReplenishRuleHousetype> ruleHousetypes = BeanUtil.buildListFrom(ruleHousetypeVOs,WhWmsReplenishRuleHousetype.class);
        for (WhWmsReplenishRuleHousetype ruleHousetype : ruleHousetypes){
            ruleHousetype.setReplenishRuleId(ruleId);
        }
        whWmsReplenishRuleCustomMapper.batchInsertWhWmsReplenishRuleHousetype(ruleHousetypes);
    }

    private void batchInsertBlacklistByBlacklistVOs(List<WhWmsReplenishRuleBlacklistVO> ruleBlacklistVOs,Long ruleId){
        List<WhWmsReplenishRuleBlacklist> ruleBlacklists = BeanUtil.buildListFrom(ruleBlacklistVOs,WhWmsReplenishRuleBlacklist.class);
        for (WhWmsReplenishRuleBlacklist ruleBlacklist : ruleBlacklists){
            ruleBlacklist.setReplenishRuleId(ruleId);
        }
        whWmsReplenishRuleCustomMapper.batchInsertWhWmsReplenishRuleBlacklist(ruleBlacklists);
    }

    @Override
    public boolean updateWhWmsReplenishRuleVO(WhWmsReplenishRuleVO replenishRuleVO) {
        WhWmsReplenishRule replenishRule = BeanUtil.buildFrom(replenishRuleVO,WhWmsReplenishRule.class);
        replenishRule.setUpdateTime(DateUtil.getNow());
        boolean result = whWmsReplenishRuleMapper.updateByPrimaryKeySelective(replenishRule)>0;
        if (result){
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleHousetypeVOs())){
                deleteWhWmsReplenishRuleHousetypeByRuleId(replenishRuleVO.getId());
                batchInsertHousetypeByHousetypeVOs(replenishRuleVO.getRuleHousetypeVOs(),replenishRuleVO.getId());
            }
            if (CollectionUtils.isNotEmpty(replenishRuleVO.getRuleBlacklistVOs())){
                deleteWhWmsReplenishRuleBlacklistByRuleId(replenishRuleVO.getId());
                batchInsertBlacklistByBlacklistVOs(replenishRuleVO.getRuleBlacklistVOs(),replenishRuleVO.getId());
            }
        }
        return result;
    }

    @Override
    public List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByCond(WhWmsReplenishRuleCond cond) {
        return whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleHousetypeVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishRuleHousetypeVO> listWhWmsReplenishRuleHousetypeVOByRuleId(Long ruleId) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setId(ruleId);
        return listWhWmsReplenishRuleHousetypeVOByCond(cond);
    }

    @Override
    public boolean deleteWhWmsReplenishRuleHousetypeByRuleId(Long ruleId) {
        WhWmsReplenishRuleHousetypeExample example = new WhWmsReplenishRuleHousetypeExample();
        example.createCriteria().andReplenishRuleIdEqualTo(ruleId);
        return whWmsReplenishRuleHousetypeMapper.deleteByExample(example)>=0;
    }

    @Override
    public List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByCond(WhWmsReplenishRuleCond cond) {
        return whWmsReplenishRuleCustomMapper.listWhWmsReplenishRuleBlacklistVOByCond(cond);
    }

    @Override
    public List<WhWmsReplenishRuleBlacklistVO> listWhWmsReplenishRuleBlacklistVOByRuleId(Long ruleId) {
        WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
        cond.setId(ruleId);
        return listWhWmsReplenishRuleBlacklistVOByCond(cond);
    }

    @Override
    public boolean deleteWhWmsReplenishRuleBlacklistByRuleId(Long ruleId) {
        WhWmsReplenishRuleBlacklistExample example = new WhWmsReplenishRuleBlacklistExample();
        example.createCriteria().andReplenishRuleIdEqualTo(ruleId);
        return whWmsReplenishRuleBlacklistMapper.deleteByExample(example)>=0;
    }

    private int countWhWmsReplenishRule(WhWmsReplenishRuleCond cond){
        return whWmsReplenishRuleCustomMapper.countWhWmsReplenishRuleByCond(cond);
    }

    private WhWmsReplenishRuleExample buildWhWmsReplenishRuleExampleByCond(WhWmsReplenishRuleCond cond){
        WhWmsReplenishRuleExample example = new WhWmsReplenishRuleExample();
        WhWmsReplenishRuleExample.Criteria criteria = example.createCriteria();

        if (EmptyUtil.isNotEmpty(cond.getId())){
            criteria.andIdEqualTo(cond.getId());
        }else if(CollectionUtils.isNotEmpty(cond.getIds())){
            criteria.andIdIn(cond.getIds());
        }

        if (EmptyUtil.isNotEmpty(cond.getRuleState())){
            criteria.andRuleStateEqualTo(cond.getRuleState());
        }

        if (EmptyUtil.isNotEmpty(cond.getRunInterval())){
            criteria.andRunIntervalEqualTo(cond.getRunInterval());
        }

        if (EmptyUtil.isNotEmpty(cond.getPhysicalWarehouseCode())){
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }

        if (EmptyUtil.isNotEmpty(cond.getCreateTimeStart())){
            criteria.andCreateTimeGreaterThanOrEqualTo(cond.getCreateTimeStart());
        }
        if (EmptyUtil.isNotEmpty(cond.getCreateTimeEnd())){
            criteria.andCreateTimeLessThanOrEqualTo(cond.getCreateTimeEnd());
        }

        if (EmptyUtil.isNotEmpty(cond.getOrderBy())){
            example.setOrderByClause(cond.getOrderBy());
        }
        return example;
    }
}
