package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhGradeOfQualityCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsGradeOfQualityCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsReceiveShelvesDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author xw
 * @create 2018-04-23 15:26
 */
@Service("whWmsReceiveShelvesDetailService")
public class WhWmsReceiveShelvesDetailServiceImpl implements WhWmsReceiveShelvesDetailService {

    private final static Logger log = LoggerFactory.getLogger(WhWmsReceiveShelvesDetailServiceImpl.class);

    @Autowired
    private WhWmsReceiveShelvesDetailMapper whWmsReceiveShelvesDetailMapper;

    @Autowired
    private WhWmsReceiveShelvesDetailCustomMapper whWmsReceiveShelvesDetailCustomMapper;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhGradeOfQualityService whGradeOfQualityService;

    @Autowired
    private WhGradeOfQualityCustomMapper whGradeOfQualityCustomMapper;

    @Autowired
    private WhWmsQcProcessDetailMapper whWmsQcProcessDetailMapper;

    @Override
    public WhWmsReceiveShelvesDetail findWhWmsReceiveShelvesDetailById(Long id){
        return whWmsReceiveShelvesDetailMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsReceiveShelvesDetailVO findWhWmsReceiveShelvesDetailVOById(Long id, boolean fetchSkuImg) {
        WhWmsReceiveShelvesDetailVO vo = whWmsReceiveShelvesDetailCustomMapper.findVOById(id);
        if (EmptyUtil.isNotEmpty(vo)){
            fetchSkuImg(vo,fetchSkuImg);
        }
        return vo;
    }

    private void fetchSkuImg(WhWmsReceiveShelvesDetailVO vo,boolean fetchSkuImg){
        if (fetchSkuImg && EmptyUtil.isNotEmpty(vo.getSkuImage())){
            String[] skuImageIds = vo.getSkuImage().split(",");
            Long[] skuImageArr = (Long[]) ConvertUtils.convert(skuImageIds,Long.class);
            List<CommFileRef> commFileRefs = PegasusUtilFacade.getInstance().findCommFileRefByIds(Arrays.asList(skuImageArr));
            vo.setCommFileRefs(commFileRefs);
        }
    }

    @Override
    public WhWmsReceiveShelvesDetailVO findWhWmsReceiveShelvesDetailVOByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = buildWhWmsReceiveShelvesDetailExampleByCond(cond);
        List<WhWmsReceiveShelvesDetail> shelvesDetails = whWmsReceiveShelvesDetailMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(shelvesDetails)){
            WhWmsReceiveShelvesDetailVO vo = BeanUtil.buildFrom(shelvesDetails.get(0),WhWmsReceiveShelvesDetailVO.class);
            fetchSkuImg(vo,cond.isFetchSkuImg());
            return vo;
        }
        return null;
    }

    private WhWmsReceiveShelvesDetailExample buildWhWmsReceiveShelvesDetailExampleByCond(WhWmsReceiveShelvesDetailCond cond){
        WhWmsReceiveShelvesDetailExample example = new WhWmsReceiveShelvesDetailExample();
        WhWmsReceiveShelvesDetailExample.Criteria criteria = example.createCriteria();

        if (EmptyUtil.isNotEmpty(cond.getId())){
            criteria.andIdEqualTo(cond.getId());
        }else if(CollectionUtils.isNotEmpty(cond.getIds())){
            criteria.andIdIn(cond.getIds());
        }

        if (EmptyUtil.isNotEmpty(cond.getRefCode())){
            criteria.andRefCodeEqualTo(cond.getRefCode());
        }else if(CollectionUtils.isNotEmpty(cond.getRefCodes())){
            criteria.andRefCodeIn(cond.getRefCodes());
        }

        if (EmptyUtil.isNotEmpty(cond.getRefType())){
            criteria.andRefTypeEqualTo(cond.getRefType());
        }else if(CollectionUtils.isNotEmpty(cond.getRefTypes())){
            criteria.andRefTypeIn(cond.getRefTypes());
        }

        if (EmptyUtil.isNotEmpty(cond.getQcId())){
            criteria.andQcIdEqualTo(cond.getQcId());
        }else if(CollectionUtils.isNotEmpty(cond.getQcIds())){
            criteria.andQcIdIn(cond.getQcIds());
        }

        if (EmptyUtil.isNotEmpty(cond.getSkuStatus())){
            criteria.andSkuStatusEqualTo(cond.getSkuStatus());
        }

        if (EmptyUtil.isNotEmpty(cond.getSkuCode())){
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }else if(CollectionUtils.isNotEmpty(cond.getSkuCodes())){
            criteria.andSkuCodeIn(cond.getSkuCodes());
        }

        if (EmptyUtil.isNotEmpty(cond.getOriginType())){
            criteria.andOriginTypeEqualTo(cond.getOriginType());
        }

        if (EmptyUtil.isNotEmpty(cond.getCreateTimeStart())){
            criteria.andCreateTimeGreaterThanOrEqualTo(DateUtil.parse(cond.getCreateTimeStart(),DateUtil.DEFAULT_DATE_FORMAT));
        }

        if (EmptyUtil.isNotEmpty(cond.getCreateTimeEnd())){
            criteria.andCreateTimeLessThanOrEqualTo(DateUtil.parse(cond.getCreateTimeEnd(),DateUtil.DEFAULT_DATE_FORMAT));
        }

        if (EmptyUtil.isNotEmpty(cond.getCreateUserId())){
            criteria.andCreateUserIdEqualTo(cond.getCreateUserId());
        }
        return example;
    }

    @Override
    public List<WhWmsReceiveShelvesDetail> findWhWmsReceiveShelvesDetailByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = buildWhWmsReceiveShelvesDetailExampleByCond(cond);
        return whWmsReceiveShelvesDetailMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsReceiveShelvesDetailVO> listWhWmsReceiveShelvesDetailVOByCond(WhWmsReceiveShelvesDetailCond cond) {
        List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs = whWmsReceiveShelvesDetailCustomMapper.listWhWmsReceiveShelvesDetailVOByCond(cond);
        if (cond.isFetchSkuImg() && CollectionUtils.isNotEmpty(receiveShelvesDetailVOs)){
            for (WhWmsReceiveShelvesDetailVO shelvesDetailVO : receiveShelvesDetailVOs){
                fetchSkuImg(shelvesDetailVO,true);
            }
        }
        return receiveShelvesDetailVOs;
    }

    @Override
    public WhWmsQcProcessDetailVO findWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        List<WhWmsQcProcessDetailVO> whWmsQcProcessDetailVOs = listWhWmsQcProcessDetailVOByCond(cond);
        if (CollectionUtils.isNotEmpty(whWmsQcProcessDetailVOs)){
            return whWmsQcProcessDetailVOs.get(0);
        }
        return null;
    }

    @Override
    public List<WhWmsQcProcessDetailVO> listWhWmsQcProcessDetailVOByCond(WhWmsQcProcessDetailCond cond) {
        return whWmsReceiveShelvesDetailCustomMapper.listWhWmsQcProcessDetailVOByCond(cond);
    }

    @Override
    public WhWmsQcProcessDetail findWhWmsQcProcessDetailByCond(WhWmsQcProcessDetailCond cond) {
        List<WhWmsQcProcessDetail> whWmsQcProcessDetails = listWhWmsQcProcessDetailsByCond(cond);
        if (CollectionUtils.isNotEmpty(whWmsQcProcessDetails)){
            return whWmsQcProcessDetails.get(0);
        }
        return null;
    }

    @Override
    public List<WhWmsQcProcessDetail> listWhWmsQcProcessDetailsByCond(WhWmsQcProcessDetailCond cond) {
        WhWmsQcProcessDetailExample example = buildWhWmsQcProcessDetailExampleByCond(cond);
        return whWmsQcProcessDetailMapper.selectByExample(example);

    }

    private WhWmsQcProcessDetailExample buildWhWmsQcProcessDetailExampleByCond(WhWmsQcProcessDetailCond cond){
        WhWmsQcProcessDetailExample example = new WhWmsQcProcessDetailExample();
        WhWmsQcProcessDetailExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getQcId())){
            criteria.andQcIdEqualTo(cond.getQcId());
        }
        if (EmptyUtil.isNotEmpty(cond.getRefCode())){
            criteria.andRefCodeEqualTo(cond.getRefCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getSkuCode())){
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getInOutType())){
            criteria.andInOutTypeEqualTo(cond.getInOutType());
        }
        if (EmptyUtil.isNotEmpty(cond.getProcessStatus())){
            criteria.andProcessStatusEqualTo(cond.getProcessStatus());
        }
        return example;
    }

    @Override
    @Transactional
    public void purchaseDefectiveProcess(List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs,Long processUserId) throws Exception {
        // WhWmsReceiveShelvesDetailVO shelvesDetail = receiveShelvesDetailVOs.get(0);
        Set<Long> qcIds = new HashSet<>();
        Set<String> refCodes = new HashSet<>();
        Set<String> skuCodes = new HashSet<>();
        for (WhWmsReceiveShelvesDetailVO shelvesDetailVO : receiveShelvesDetailVOs){
            qcIds.add(shelvesDetailVO.getQcId());
            refCodes.add(shelvesDetailVO.getRefCode());
            skuCodes.add(shelvesDetailVO.getSkuCode());
            shelvesDetailVO.setCreateUserId(processUserId);
            shelvesDetailVO.setProcessUserId(processUserId);
            shelvesDetailVO.setCreateTime(new Date());
        }
        WhWmsReceiveShelvesDetailCond shelvesDetailCond = new WhWmsReceiveShelvesDetailCond();

        //shelvesDetailCond.setRefCode(shelvesDetail.getRefCode());
        shelvesDetailCond.setRefCodes(Arrays.asList(refCodes.toArray(new String[refCodes.size()])));

        //shelvesDetailCond.setQcId(shelvesDetail.getQcId());
        shelvesDetailCond.setQcIds(Arrays.asList(qcIds.toArray(new Long[qcIds.size()])));

        //shelvesDetailCond.setSkuCode(shelvesDetail.getSkuCode());
        shelvesDetailCond.setSkuCodes(Arrays.asList(skuCodes.toArray(new String[skuCodes.size()])));

        shelvesDetailCond.setRefType(WhCommand.TYPE_PURCHASE_IN);
        shelvesDetailCond.setOriginType(WhWmsReceiveShelvesDetailVO.ORIGIN_TYPE_SCM_QC);
        // 先清空源数据
        deleteByCond(shelvesDetailCond);

        // 重新新增
        batchCreate(BeanUtil.buildListFrom(receiveShelvesDetailVOs,WhWmsReceiveShelvesDetail.class));

        List<String> keyList = new ArrayList<>();
        String key = "";
        for (WhWmsReceiveShelvesDetailVO shelvesDetailVO : receiveShelvesDetailVOs){
            key = shelvesDetailVO.getQcId()+shelvesDetailVO.getRefCode()+shelvesDetailVO.getSkuCode();
            if (!keyList.contains(key)){
                WhWmsQcProcessDetail whWmsQcProcessDetail = buildWhWmsQcProcessDetailByReceiveShelvesDetail(shelvesDetailVO);
                // 保存处理状态
                createWhWmsQcProcessDetail(whWmsQcProcessDetail);
                keyList.add(key);
            }
        }
    }

    @Override
    public boolean createWhWmsQcProcessDetail(WhWmsQcProcessDetail whWmsQcProcessDetail){
        return whWmsQcProcessDetailMapper.insert(whWmsQcProcessDetail) > 0;
    }

    public WhWmsQcProcessDetail buildWhWmsQcProcessDetailByReceiveShelvesDetail(WhWmsReceiveShelvesDetailVO shelvesDetailVO){
        WhWmsQcProcessDetail whWmsQcProcessDetail = new WhWmsQcProcessDetail();
        whWmsQcProcessDetail.setQcId(shelvesDetailVO.getQcId());
        whWmsQcProcessDetail.setRefCode(shelvesDetailVO.getRefCode());
        whWmsQcProcessDetail.setSkuCode(shelvesDetailVO.getSkuCode());
        whWmsQcProcessDetail.setInOutType(shelvesDetailVO.getRefType());
        whWmsQcProcessDetail.setProcessStatus(WhWmsQcProcessDetailVO.DEFECTIVE_PROCESS_STATUS_PROCESSED);
        whWmsQcProcessDetail.setProcessUserId(shelvesDetailVO.getProcessUserId());
        whWmsQcProcessDetail.setProcessTime(DateUtil.getNow());
        return whWmsQcProcessDetail;
    }

    @Override
    @Transactional
    public boolean create(WhWmsReceiveShelvesDetailVO vo) throws Exception{
        WhWmsReceiveShelvesDetail receiveShelvesDetail = BeanUtil.buildFrom(vo,WhWmsReceiveShelvesDetail.class);
        receiveShelvesDetail.setCreateTime(DateUtil.getNow());
        int result = whWmsReceiveShelvesDetailMapper.insert(receiveShelvesDetail);
        vo.setId(receiveShelvesDetail.getId());
        return result > 0;
    }

    @Override
    @Transactional
    public boolean batchCreate(List<WhWmsReceiveShelvesDetail> receiveShelvesDetails){
        return whWmsReceiveShelvesDetailCustomMapper.batchCreateReceiveShelvesDetail(receiveShelvesDetails)>0;
    }

    @Override
    @Transactional
    public boolean deleteByCond(WhWmsReceiveShelvesDetailCond cond) {
        WhWmsReceiveShelvesDetailExample example = buildWhWmsReceiveShelvesDetailExampleByCond(cond);
        whWmsReceiveShelvesDetailMapper.deleteByExample(example);
        return true;
    }

    @Override
    @Transactional
    public boolean createOrUpdate(WhWmsReceiveShelvesDetailVO vo) throws Exception{
        boolean result = false;
        if (EmptyUtil.isNotEmpty(vo.getId()) && EmptyUtil.isNotEmpty(whWmsReceiveShelvesDetailMapper.selectByPrimaryKey(vo.getId()))){
            result = update(vo);
        }else{
            result = create(vo);
        }
        return result;
    }

    @Override
    @Transactional
    public boolean update(WhWmsReceiveShelvesDetailVO vo) throws Exception{
        WhWmsReceiveShelvesDetail receiveShelvesDetail = BeanUtil.buildFrom(vo,WhWmsReceiveShelvesDetail.class);
        int result = whWmsReceiveShelvesDetailMapper.updateByPrimaryKeySelective(receiveShelvesDetail);
        return result > 0;
    }

    private void sendGradeAdjustApplyMail(WhWmsGradeOfQualityVO vo){
        WhGradeOfQualityCond whGradeCond = new WhGradeOfQualityCond();
        whGradeCond.setRefId(vo.getId());
        List<WhGradeOfQualityVO> gradeOfQualityVOs = whGradeOfQualityCustomMapper.listWhGradeOfQualityVOByCond(whGradeCond);
        whGradeOfQualityService.gradeAdjustApplySendMail(gradeOfQualityVOs);
    }

    private Map<String,WhWmsHouseShelves> getHouseTypeMapByBarcodes(List<WhWmsGradeOfQualityBarcode> gradeBarcodes){
        Set<String> shelvesCodes = new HashSet<>();
        for (WhWmsGradeOfQualityBarcode barcode : gradeBarcodes){
            shelvesCodes.add(barcode.getShelvesCode());
        }
        List<WhWmsHouseShelves> whWmsHouseShelves = whWmsHouseShelvesService.getHouseShelvesByCode(new ArrayList<>(shelvesCodes));
        Map<String,WhWmsHouseShelves> shelvesMap = new HashMap<>();
        for (WhWmsHouseShelves houseShelves : whWmsHouseShelves){
            shelvesMap.put(houseShelves.getCode(),houseShelves);
        }
        return shelvesMap;
    }
}
