package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcMaterialDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsPrdcMaterialDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhWmsPrdcMaterialDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcMaterialDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcMaterialDetailExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcMaterialDetailService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcMaterialDetailVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xw
 * @create 2018-03-28 14:16
 */
@Service("whWmsPrdcMaterialDetailService")
public class WhWmsPrdcMaterialDetailServiceImpl implements WhWmsPrdcMaterialDetailService {

    @Autowired
    private WhWmsPrdcMaterialDetailMapper whWmsPrdcMaterialDetailMapper;

    @Autowired
    private WhWmsPrdcMaterialDetailCustomMapper whWmsPrdcMaterialDetailCustomMapper;

    @Override
    public boolean create(WhWmsPrdcMaterialDetail record) {
        return whWmsPrdcMaterialDetailMapper.insert(record)>0;
    }

    @Override
    public boolean batchCreate(List<WhWmsPrdcMaterialDetail> records) {
        return whWmsPrdcMaterialDetailCustomMapper.batchInsert(records)>0;
    }

    @Override
    public Boolean updateById(WhWmsPrdcMaterialDetail record) {
        return whWmsPrdcMaterialDetailMapper.updateByPrimaryKeySelective(record)>0;
    }

    @Override
    public Boolean updateByCond(WhWmsPrdcMaterialDetail record,WhWmsPrdcMaterialDetailCond cond) {
        WhWmsPrdcMaterialDetailExample example = buildWhWmsPrdcMaterialDetailExampleByCond(cond);
        return whWmsPrdcMaterialDetailMapper.updateByExampleSelective(record,example)>0;
    }

    @Override
    public WhWmsPrdcMaterialDetail findWhWmsPrdcMaterialDetailById(Long id) {
        return whWmsPrdcMaterialDetailMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<WhWmsPrdcMaterialDetail> listWhWmsPrdcMaterialDetailByCond(WhWmsPrdcMaterialDetailCond cond) {
        WhWmsPrdcMaterialDetailExample example = buildWhWmsPrdcMaterialDetailExampleByCond(cond);
        return whWmsPrdcMaterialDetailMapper.selectByExample(example);
    }

    @Override
    public List<WhWmsPrdcMaterialDetailVO> listWhWmsPrdcMaterialDetailVOByCond(WhWmsPrdcMaterialDetailCond cond) {
        return whWmsPrdcMaterialDetailCustomMapper.listWhWmsPrdcMaterialDetailVOByCond(cond);
    }

    private WhWmsPrdcMaterialDetailExample buildWhWmsPrdcMaterialDetailExampleByCond(WhWmsPrdcMaterialDetailCond cond){
        WhWmsPrdcMaterialDetailExample example = new WhWmsPrdcMaterialDetailExample();
        WhWmsPrdcMaterialDetailExample.Criteria criteria = example.createCriteria();

        // ID
        if (EmptyUtil.isNotEmpty(cond.getId())){
            criteria.andIdEqualTo(cond.getId());
        }else if(CollectionUtils.isNotEmpty(cond.getIds())){
            criteria.andIdIn(cond.getIds());
        }

        // MaterialSku
        if (EmptyUtil.isNotEmpty(cond.getMaterialSku())){
            criteria.andMaterialSkuEqualTo(cond.getMaterialSku());
        }

        // ProdSku
        if (EmptyUtil.isNotEmpty(cond.getProdSku())){
            criteria.andProdSkuEqualTo(cond.getProdSku());
        }

        // MaterialBarcode
        if (EmptyUtil.isNotEmpty(cond.getMaterialBarcode())){
            criteria.andMaterialBarcodeEqualTo(cond.getMaterialBarcode());
        }

        // ProdBarcode
        if (EmptyUtil.isNotEmpty(cond.getProdBarcode())){
            criteria.andProdBarcodeEqualTo(cond.getProdBarcode());
        }

        // SkuStatus
        if (EmptyUtil.isNotEmpty(cond.getSkuStatus())){
            criteria.andSkuStatusEqualTo(cond.getSkuStatus());
        }

        // PrdcTaskCode
        if (EmptyUtil.isNotEmpty(cond.getPrdcTaskCode())){
            criteria.andPrdcTaskCodeEqualTo(cond.getPrdcTaskCode());
        }

        if (EmptyUtil.isNotEmpty(cond.getOrderByClause())){
            example.setOrderByClause(cond.getOrderByClause());
        }
        return example;
    }
}
