package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcJobTaskCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsPrdcMaterialDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsPrdcJobTaskMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;

import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by devin.li on 16/4/14.
 */
@Controller("whWmsPrdcJobTaskService")
public class WhWmsPrdcJobTaskServiceImpl implements WhWmsPrdcJobTaskService {

    private static Logger log = LoggerFactory.getLogger(WhWmsPrdcJobTaskServiceImpl.class);

    @Autowired
    private WhWmsPrdcJobTaskMapper        whWmsPrdcJobTaskMapper;

    @Autowired
    private WhWmsOccupyService whWmsOccupyService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsPrdcJobTaskDetailService whWmsPrdcJobTaskDetailService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Autowired
    private WhWmsHouseShelvesService      whWmsHouseShelves;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;

    @Autowired
    private WhWarehouseMapper whWarehouseMapper;

    @Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhInvService whInvService;

    @Autowired
    private WhWmsHouseShelvesService whHouseShelvesService;

    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;
    
    @Autowired
    private WhWmsWaitPutawayService whWmsWaitPutawayService;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhWmsPrdcMaterialDetailService whWmsPrdcMaterialDetailService;

    @Override
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByCond(WhWmsPrdcJobTaskCond cond) {
        List<WhWmsPrdcJobTask> jobTaskList = whWmsPrdcJobTaskMapper.getPrdcJobTaskByCond(cond);
        if(CollectionUtils.isEmpty(jobTaskList)) return Collections.EMPTY_LIST;
        List<WhWmsPrdcJobTaskVO> prdcJobTaskVOs = BeanUtil.buildListFrom(jobTaskList,WhWmsPrdcJobTaskVO.class);
        if (cond.isFetchTaskDetail()){
            for (WhWmsPrdcJobTaskVO taskVO : prdcJobTaskVOs){
                taskVO.setJobTaskDetailList(whWmsPrdcJobTaskDetailService.getTaskDetailByTaskCode(taskVO.getCode()));
            }
        }
        return prdcJobTaskVOs;
    }

    @Override
    public WhWmsPrdcJobTaskVO getPrdcJobTaskById(Long id) {
        WhWmsPrdcJobTask jobTask = whWmsPrdcJobTaskMapper.selectByPrimaryKey(id);
        if (EmptyUtil.isEmpty(jobTask)) return null;
        WhWmsPrdcJobTaskVO jobTaskVO =  BeanUtil.buildFrom(jobTask, WhWmsPrdcJobTaskVO.class);
        List<WhWmsPrdcJobTaskDetailVO> taskDetailVOs = whWmsPrdcJobTaskDetailService.getTaskDetailByTaskCode(jobTask.getCode());
        jobTaskVO.setJobTaskDetailList(taskDetailVOs);
        return jobTaskVO;
    }

    @Override
    public WhWmsPrdcJobTaskVO getPrdcJobTaskByTaskCode(String taskCode) {
        WhWmsPrdcJobTaskExample example = new WhWmsPrdcJobTaskExample();
        example.createCriteria().andCodeEqualTo(taskCode);
        List<WhWmsPrdcJobTask> jobTasks = whWmsPrdcJobTaskMapper.selectByExample(example);
        if (EmptyUtil.isEmpty(jobTasks)) return null;
        List<WhWmsPrdcJobTaskVO> jobTaskVOs =BeanUtil.buildListFrom(jobTasks,WhWmsPrdcJobTaskVO.class);
        return jobTaskVOs.get(0);
    }

    @Override
    public List<WhWmsPrdcJobTaskVO> getPrdcJobTaskByJobCode(String jobCode) {
        WhWmsPrdcJobTaskExample example = new WhWmsPrdcJobTaskExample();
        example.createCriteria().andPrdcJobCodeEqualTo(jobCode);
        List<WhWmsPrdcJobTask> jobTasks = whWmsPrdcJobTaskMapper.selectByExample(example);
        List<WhWmsPrdcJobTaskVO> jobTaskVOs =BeanUtil.buildListFrom(jobTasks,WhWmsPrdcJobTaskVO.class);
        return jobTaskVOs;
    }

//    @Override
//    @Transactional
//    public Boolean createJobTaskAndOccupyStock(WhWmsPrdcJobTaskVO vo) {
//        if (EmptyUtil.isEmpty(vo.getPrdcJobCode())) throw new WarehouseException("","the jobCode isnot can be null");
//        if (vo.getJobPlanStatus()== WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED)
//            throw new WarehouseException("","["+vo.getPrdcJobCode()+"]the status of the job has been finished!");
//        if(EmptyUtil.isEmpty(vo.getAmount())) throw new WarehouseException("","the production of quantity cannot be null!");
//        if(vo.getAmount()<=0) throw new WarehouseException("","the production of quantity must be >0");
//        vo.setCreateTime(DateUtil.getNow());
//        vo.setFinishedDefectiveAmount(0);
//        vo.setFinishedGoodsAmount(0);
//        vo.setStatus(WhWmsPrdcJobTaskVO.STATUS_PROCESSING);
//        //vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
//        vo.setCode(createNewCode("TK"));
//        List<WhWmsOccupyVO> occupyList = new ArrayList<>();
//        //检查库存,库存不足生成移库任务
//        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
//        moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
//        moveStockVO.setCreateUserId(vo.getCreateUserId());
//        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
//        moveStockVO.setReferenceCode(vo.getPrdcJobCode());
//        boolean canStart = true;
//        boolean ifMoveStock = false ;
//        Map<String,Integer> taskDetailDifferenceMap = new HashedMap();
//        List<WhWmsMoveSkuVO> moveSkus = new ArrayList<>();
//        //组装
//        if(vo.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE){
//            for (WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()) {
//                taskDetailVO.setTaskCode(vo.getCode());
//                taskDetailVO.setCode(createNewCode("TKD"));
//                //检查耗材库存
//                List<WhWmsSkuStockVO> skuStockList = checkStockBeforeOccupy(vo, taskDetailVO,taskDetailDifferenceMap,moveSkus);
//                if(taskDetailDifferenceMap.size()==0){
//                    if(CollectionUtils.isNotEmpty(skuStockList) && moveSkus.size()==0){
//                        for(WhWmsSkuStockVO skuStock :skuStockList){
//                            if(NumberUtil.isNullOrZero(skuStock.getOccupiedAccount())) continue;
//                            WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
//                            occupyVO.setSkuCode(skuStock.getSkuCode());
//                            occupyVO.setBarCode(skuStock.getBarCode());
//                            //occupyVO.setSkuStatus(vo.getSkuStatus());
//                            occupyVO.setSkuStatus(skuStock.getSkuStatus());
//                            occupyVO.setAmount(-(int)Math.ceil(skuStock.getOccupiedAccount()));
//                            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
//                            occupyVO.setReceiptsNo(vo.getCode());
//                            occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
//                            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
//                            occupyVO.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
//                            occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
//                            occupyList.add(occupyVO);
//                            canStart = canStart && true;
//                            ifMoveStock = ifMoveStock || false;
//                        }
//                    } else if(CollectionUtils.isNotEmpty(skuStockList) && CollectionUtils.isNotEmpty(moveSkus)){
//                        ifMoveStock = ifMoveStock || true;
//                        canStart = canStart && false;
//                    }
//
//                } else if(taskDetailDifferenceMap.size()!=0){
//                    ifMoveStock = false;
//                    canStart =  false;
//                }
//                else{
//                    canStart = false;
//                    ifMoveStock = false;
//                }
//
//            }
//            //拆分
//        }else if(vo.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT){
//            for (WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()) {
//                taskDetailVO.setTaskCode(vo.getCode());
//                taskDetailVO.setCode(createNewCode("TKD"));
//            }
//            //检查耗材库存
//            List<WhWmsSkuStockVO> skuStockList = checkStockBeforeOccupy(vo,null, taskDetailDifferenceMap,moveSkus);
//            //构造占用,可以启动
//            if (CollectionUtils.isNotEmpty(skuStockList) && moveSkus.size()==0 && taskDetailDifferenceMap.size()==0) {
//                for (WhWmsSkuStockVO skuStock : skuStockList) {
//                    WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
//                    occupyVO.setSkuCode(vo.getSkuCode());
//                    occupyVO.setBarCode(skuStock.getBarCode());
//                    //occupyVO.setSkuStatus(vo.getSkuStatus());
//                    occupyVO.setSkuStatus(skuStock.getSkuStatus());
//                    occupyVO.setAmount(-(int) Math.ceil(skuStock.getOccupiedAccount()));
//                    occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
//                    occupyVO.setReceiptsNo(vo.getCode());
//                    occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
//                    occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
//                    occupyVO.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
//                    occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
//                    occupyList.add(occupyVO);
//                    canStart = true;
//                    ifMoveStock = false;
//                }
//            }
//            //有移库任务,无法启动
//            else if(CollectionUtils.isNotEmpty(skuStockList) && CollectionUtils.isNotEmpty(moveSkus)){
//                ifMoveStock =  true;
//                canStart =  false;
//            }
//            //库存不足,无移库任务,无法启动
//            else{
//                ifMoveStock = false;
//                canStart = false;
//            }
//        }
//        if(canStart && !ifMoveStock){
//            //创建占用
//            whWmsOccupyService.wmsBatchOccupy(occupyList);
//            //新增子任务
//            int insertTask = whWmsPrdcJobTaskMapper.insert(vo);
//            if (insertTask <= 0) throw new WarehouseException("","insert data failed!");
//            //子任务sku信息
//            whWmsPrdcJobTaskDetailService.newTaskDetail(vo.getJobTaskDetailList());
//            return true;
//        }
//        else if(canStart && ifMoveStock && EmptyUtil.isNotEmpty(moveSkus)){
//            moveStockVO.setMoveSkuList(moveSkus);
//            whWmsMoveStockService.newMoveStock(moveStockVO);
//            vo.setMoveStockCode(moveStockVO.getCode());
//            return(createJobTaskAndOccupyStock(vo));
//        }else if(!canStart && ifMoveStock && EmptyUtil.isNotEmpty(moveSkus)){
//            moveStockVO.setMoveSkuList(moveSkus);
//            whWmsMoveStockService.newMoveStock(moveStockVO);
//            vo.setMoveStockCode(moveStockVO.getCode());
//        } else if(!canStart && !ifMoveStock){
//            sendOutOfStockEmil(vo.getAmount(),vo.getPhysicalWarehouseCode(),vo.getPrdcJobCode(),taskDetailDifferenceMap);
//        }
//        return false;
//    }

    @Transactional
    public Boolean createJobTaskAndOccupyStock(WhWmsPrdcJobTaskVO vo){
        if (WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED.equals(vo.getJobPlanStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"["+vo.getPrdcJobCode()+"]加工单已完成！");
        }
        Map<String,Integer> skuQuantiyMap = computeTaskMaterial(vo);
        List<WhWmsSkuStockVO> pickStockList = new ArrayList<>();
        Map<String,Integer> shortageSkuMap = findTaskPickStock(vo.getPhysicalWarehouseCode(),vo.getSkuStatus(),skuQuantiyMap,pickStockList);
        if(!shortageSkuMap.isEmpty()){
            //总可用库存不足，邮件提醒
            sendOutOfStockEmil(vo.getAmount(),vo.getPhysicalWarehouseCode(),vo.getPrdcJobCode(),shortageSkuMap);
//            StringBuilder buff = new StringBuilder();
//            for(Map.Entry<String,Integer> entry : shortageSkuMap.entrySet()){
//                buff.append("SKU:"+entry.getKey()+",差额:"+entry.getValue());
//                buff.append("</br>");
//            }
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,buff.toString());
            return false;
        }
        //加工区库位
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        List<WhWmsHouseShelvesVO> targetShelves = whWmsHouseShelves.getHouseShelvesByCond(cond);
        if(CollectionUtils.isEmpty(targetShelves)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"加工区无库位！");
        }
        WhWmsHouseShelvesVO processingShelves = targetShelves.get(0);
        List<WhWmsMoveSkuVO> moveSkuList = filterMoveStock(pickStockList,processingShelves);
        if(EmptyUtil.isNotEmpty(moveSkuList)){
            //加工区库存不足，生成移库单
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(vo.getCreateUserId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
            moveStockVO.setReferenceCode(vo.getPrdcJobCode());
            moveStockVO.setMoveSkuList(moveSkuList);
            whWmsMoveStockService.newMoveStock(moveStockVO);
            vo.setMoveStockCode(moveStockVO.getCode());
            return false;
        }
        vo.setCreateTime(DateUtil.getNow());
        vo.setFinishedDefectiveAmount(0);
        vo.setFinishedGoodsAmount(0);
        vo.setStatus(WhWmsPrdcJobTaskVO.STATUS_PROCESSING);
        vo.setCode(createNewCode("TK"));
        for (WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()) {
            taskDetailVO.setTaskCode(vo.getCode());
            taskDetailVO.setCode(createNewCode("TKD"));
        }
        //构造占用,可以启动
        List<WhWmsOccupyVO> occupyList = buildJobTaskOccupy(pickStockList,vo);
        //创建占用
        whWmsOccupyService.wmsBatchOccupy(occupyList);
        //新增子任务
        whWmsPrdcJobTaskMapper.insert(vo);
        //子任务sku信息
        whWmsPrdcJobTaskDetailService.newTaskDetail(vo.getJobTaskDetailList());
        return true;
    }

    private List<WhWmsOccupyVO> buildJobTaskOccupy(List<WhWmsSkuStockVO> pickStockList,WhWmsPrdcJobTaskVO JobTask){
        List<WhWmsOccupyVO> occupyList = new ArrayList<>();
        for(WhWmsSkuStockVO pickStock : pickStockList){
            WhWmsOccupyVO occupyVO = BeanUtil.buildFrom(pickStock,WhWmsOccupyVO.class);
            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
            occupyVO.setReceiptsNo(JobTask.getCode());
            occupyVO.setHouseType(pickStock.getHouseType());
            occupyVO.setOriShelvesCode(pickStock.getShelvesCode());
            occupyVO.setAmount(-pickStock.getAvailableAccount());
            occupyList.add(occupyVO);
        }
        return occupyList;
    }

    private List<WhWmsMoveSkuVO> filterMoveStock(List<WhWmsSkuStockVO> pickStockList,WhWmsHouseShelvesVO processingShelves){
        List<WhWmsMoveSkuVO> moveSkus = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(pickStockList)){
            for(WhWmsSkuStockVO pickStock : pickStockList){
                //非加工区库存
                if(!WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING.equals(pickStock.getHouseType())){
                    WhWmsMoveSkuVO moveSkuVO = BeanUtil.buildFrom(pickStock,WhWmsMoveSkuVO.class);
                    moveSkuVO.setCreateTime(DateUtil.getNow());
                    moveSkuVO.setOriginalHouseType(pickStock.getHouseType());
                    moveSkuVO.setTargetHouseType(processingShelves.getHouseType());
                    moveSkuVO.setAmount(pickStock.getAvailableAccount());
                    moveSkuVO.setOriginalShelvesCode(pickStock.getShelvesCode());
                    moveSkuVO.setTargetShelvesCode(processingShelves.getCode());
                    moveSkus.add(moveSkuVO);
                }
            }
        }
        return moveSkus;
    }


    //优先加工区库存，加工区库存不足从（保管|拣货）移库到加工区
    private Map<String,Integer> findTaskPickStock(String physicalWarehouseCode,Integer skuStatus,Map<String,Integer> skuQuantityMap,List<WhWmsSkuStockVO> pickStockList){
        //查找可用批次号
        List<String> skuCodes = Arrays.asList(skuQuantityMap.keySet().toArray(new String[skuQuantityMap.size()]));
        List<WhWmsSkuBarcode> skuBarcodeList = null;
        if(EmptyUtil.isNotEmpty(skuCodes)){
            skuBarcodeList  = whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        }
        if(NullUtil.isNull(skuBarcodeList)){
            skuBarcodeList = new ArrayList<>();
        }
        Map<String,WhWmsSkuBarcode> barcodeMap = new HashMap<>();
        List<String> barCodes = new ArrayList<>();
        for(WhWmsSkuBarcode barcode : skuBarcodeList){
            barCodes.add(barcode.getBarCode());
            barcodeMap.put(barcode.getBarCode(),barcode);
        }
        Map<String,Integer> diffMap = skuQuantityMap;
        List<WhWmsSkuStockVO> canUseShelvesStockList = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(barCodes)){
            //查询加工区+普通区保管库位+普通区拣货库位总可用库存
            WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
            stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
            stockCond.setSkuStatus(skuStatus);
            stockCond.setBarCodeList(barCodes);
            stockCond.setHouseTypes(Collections.singletonList(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING));
            List<WhWmsSkuStockVO> shelvesStockList =  whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond,true);
            if(EmptyUtil.isNotEmpty(shelvesStockList)){
                canUseShelvesStockList.addAll(shelvesStockList);
                Map<String,Integer> stockSkuQuantityMap = groupStockBySku(shelvesStockList);
                diffMap = coumputeDiffMap(skuQuantityMap,stockSkuQuantityMap);
            }
            if(!diffMap.isEmpty()){//加工区库存不足
                //普通区保管库位+普通区拣货库位总可用库存
                Map<String,WhWmsWarehouseArea> areaMap = whWmsWarehouseAreaService.getAreaHouseMapByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
                List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
                stockCond.setHouseTypes(houseTypes);
                List<Integer> shelvesTypeList = new ArrayList<>();
                shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);//拣货库位
                shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);//保管库位
                stockCond.setShelvesTypeList(shelvesTypeList);
                shelvesStockList =  whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond,true);
                if(EmptyUtil.isNotEmpty(shelvesStockList)){
                    canUseShelvesStockList.addAll(shelvesStockList);
                    Map<String,Integer> stockSkuQuantityMap = groupStockBySku(shelvesStockList);
                    diffMap = coumputeDiffMap(diffMap,stockSkuQuantityMap);
                }
            }
        }
        if(!diffMap.isEmpty()){
            //总库存不足
            return diffMap;
        }
        //库存充足，库存排序：加工区优先-效期先进先出-保管-拣货-数量升序
        sortStockForJobTaskPickStock(canUseShelvesStockList,barcodeMap);
        //拣货
        List<WhWmsSkuStockVO> pickedStockList = computeTaskStock(canUseShelvesStockList,skuQuantityMap);
        pickStockList.addAll(pickedStockList);
        return diffMap;
    }

    private List<WhWmsSkuStockVO> computeTaskStock(List<WhWmsSkuStockVO> canUseShelvesStockListSorted,Map<String,Integer> skuQuantityMap){
        Map<String,Integer> needMap = new HashMap<>(skuQuantityMap);
        List<WhWmsSkuStockVO> stockList = new ArrayList<>();
        for(WhWmsSkuStockVO stock : canUseShelvesStockListSorted){
            if(needMap.isEmpty()){
                break;
            }
            Integer needQuantity = needMap.get(stock.getSkuCode());
            if(NullUtil.isNull(needQuantity) || stock.getAvailableAccount()<= 0){
                continue;
            }
            int canuseQuantity = Math.min(stock.getAvailableAccount(),needQuantity);
            WhWmsSkuStockVO pickStock = BeanUtil.buildFrom(stock,WhWmsSkuStockVO.class);
            pickStock.setAvailableAccount(canuseQuantity);
            needQuantity -= canuseQuantity;
            needMap.put(stock.getSkuCode(),needQuantity);
            if(needQuantity == 0){
                //已满足，移除
                needMap.remove(stock.getSkuCode());
            }
            stockList.add(pickStock);
        }
        return stockList;
    }

    //库存充足，库存排序：加工区优先-效期先进先出-(保管|拣货)-数量升序
    private void sortStockForJobTaskPickStock(List<WhWmsSkuStockVO> canUseShelvesStockList,final Map<String,WhWmsSkuBarcode> barcodeMap){
        if(EmptyUtil.isEmpty(canUseShelvesStockList)){
            return;
        }
        List<String> shelvesCodes = new ArrayList<>();
        for(WhWmsSkuStockVO skuStock : canUseShelvesStockList){
            shelvesCodes.add(skuStock.getShelvesCode());
        }
        final Map<String,WhWmsHouseShelves> shelvesMap = whHouseShelvesService.getHouseShelvesMapByCode(shelvesCodes);
        Collections.sort(canUseShelvesStockList, new Comparator<WhWmsSkuStockVO>() {
            @Override
            public int compare(WhWmsSkuStockVO o1, WhWmsSkuStockVO o2) {
                WhWmsHouseShelves s1 = shelvesMap.get(o1.getShelvesCode());
                WhWmsHouseShelves s2 = shelvesMap.get(o2.getShelvesCode());
                Integer houseTypeSort1 = Integer.MAX_VALUE,houseTypeSort2 = Integer.MAX_VALUE;
                if(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING.equals(s1.getHouseType())){
                    houseTypeSort1 = Integer.MIN_VALUE;
                }
                if(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING.equals(s2.getHouseType())){
                    houseTypeSort2 = Integer.MIN_VALUE;
                }
                int result = houseTypeSort1.compareTo(houseTypeSort2);
                if(result == 0){
                    //效期比较
                    result = whWmsSkuBarcodeService.compareBarCode(barcodeMap.get(o1.getBarCode()),barcodeMap.get(o2.getBarCode()));
                    if(result == 0){
                        //库位类型-保管优先
                        result = -(s1.getShelvesType().compareTo(s2.getShelvesType()));
                        if(result == 0){
                            //库存比较
                            Integer stock1 = o1.getAvailableAccount();
                            Integer stock2 = o2.getAvailableAccount();
                            result = stock1.compareTo(stock2);
                        }
                    }
                }
                return result;
            }
        });
    }

    private Map<String,Integer> groupStockBySku(List<WhWmsSkuStockVO> stockList){
        Map<String,Integer> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(stockList)){
            for(WhWmsSkuStockVO stock : stockList){
                Integer total = map.get(stock.getSkuCode());
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                map.put(stock.getSkuCode(),total+stock.getAvailableAccount());
            }
        }
        return map;
    }

    private Map<String,Integer> coumputeDiffMap(Map<String,Integer> needMap,Map<String,Integer> stockMap){
        Map<String,Integer> diffMap = new HashMap<>();
        for(Map.Entry<String,Integer> needEntry : needMap.entrySet()){
            String skuCode = needEntry.getKey();
            Integer needQuantity = needEntry.getValue();
            Integer stockQuantity = stockMap.get(skuCode);
            if(NullUtil.isNull(stockQuantity)){
                stockQuantity = 0;
            }
            if(needQuantity > stockQuantity){
                diffMap.put(skuCode,needQuantity-stockQuantity);
            }
        }
        return diffMap;
    }

    //计算所需耗材数量
    private Map<String,Integer> computeTaskMaterial(WhWmsPrdcJobTaskVO vo){
        Map<String,Integer> skuQuantiyMap = new HashMap<>();
        if(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())){
            //组装
            for(WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()){
                skuQuantiyMap.put(taskDetailVO.getSkuCode(),taskDetailVO.getAmount().intValue());
            }
        }else if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())){
            skuQuantiyMap.put(vo.getSkuCode(),vo.getAmount());
        }
        return skuQuantiyMap;
    }

    //计算所需耗材数量
    private Map<String,Float> buildTaskConsumeRecipeMaterial(WhWmsPrdcJobTaskVO vo){
        Map<String,Float> skuQuantiyMap = new HashMap<>();
        if(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())){
            //组装
            for(WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()){
                skuQuantiyMap.put(taskDetailVO.getSkuCode(),taskDetailVO.getRecipeAmount());
            }
        }else if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())){
            skuQuantiyMap.put(vo.getSkuCode(),1F);
        }
        return skuQuantiyMap;
    }
    
    //@Transactional
    //加工启动旧代码
    @Deprecated
    public Boolean createJobTaskAndOccupyStock_old(WhWmsPrdcJobTaskVO vo) {
    	List<WhWmsOccupyVO> kOccupyList = vo.getHistorykOccupyList();
        if (EmptyUtil.isEmpty(vo.getPrdcJobCode())) throw new WarehouseException("","the jobCode isnot can be null");
        if (vo.getJobPlanStatus()== WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED)
            throw new WarehouseException("","["+vo.getPrdcJobCode()+"]the status of the job has been finished!");
        if(EmptyUtil.isEmpty(vo.getAmount())) throw new WarehouseException("","the production of quantity cannot be null!");
        if(vo.getAmount()<=0) throw new WarehouseException("","the production of quantity must be >0");
        vo.setCreateTime(DateUtil.getNow());
        vo.setFinishedDefectiveAmount(0);
        vo.setFinishedGoodsAmount(0);
        vo.setStatus(WhWmsPrdcJobTaskVO.STATUS_PROCESSING);
        //vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        vo.setCode(createNewCode("TK"));
        List<WhWmsOccupyVO> occupyList = new ArrayList<>();
        List<WhWmsSkuStockVO> stockList = new ArrayList<>();
        //检查库存,库存不足生成移库任务
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(vo.getCreateUserId());
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
        moveStockVO.setReferenceCode(vo.getPrdcJobCode());
        boolean canStart = true;
        boolean ifMoveStock = false ;
        Map<String,Integer> taskDetailDifferenceMap = new HashedMap();
        List<WhWmsMoveSkuVO> moveSkus = new ArrayList<>();
        //组装
        if(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())){
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()) {
                taskDetailVO.setTaskCode(vo.getCode());
                taskDetailVO.setCode(createNewCode("TKD"));
                //检查耗材库存
                List<WhWmsSkuStockVO> skuStockList = checkStockBeforeOccupy(vo, taskDetailVO,taskDetailDifferenceMap,moveSkus,kOccupyList);
                if(EmptyUtil.isNotEmpty(skuStockList)){
                	stockList.addAll(skuStockList);
                }
                if(taskDetailDifferenceMap.size()==0){
                    if(CollectionUtils.isNotEmpty(skuStockList) && moveSkus.size()==0){
                        for(WhWmsSkuStockVO skuStock :skuStockList){
                            if(NumberUtil.isNullOrZero(skuStock.getOccupiedAccount())) continue;
                            WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                            occupyVO.setSkuCode(skuStock.getSkuCode());
                            occupyVO.setBarCode(skuStock.getBarCode());
                            //occupyVO.setSkuStatus(vo.getSkuStatus());
                            occupyVO.setSkuStatus(skuStock.getSkuStatus());
                            occupyVO.setAmount(-(int)Math.ceil(skuStock.getOccupiedAccount()));
                            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
                            occupyVO.setReceiptsNo(vo.getCode());
                            occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
                            occupyVO.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
                            occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
                            occupyList.add(occupyVO);
                            canStart = canStart && true;
                            ifMoveStock = ifMoveStock || false;
                        }
                    } else if(CollectionUtils.isNotEmpty(skuStockList) && CollectionUtils.isNotEmpty(moveSkus)){
                        ifMoveStock = ifMoveStock || true;
                        canStart = canStart && false;
                    }
                } else if(taskDetailDifferenceMap.size()!=0){
                    ifMoveStock = false;
                    canStart =  false;
                } else{
                    canStart = false;
                    ifMoveStock = false;
                }
            }
            //拆分
        } else if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())){
            for (WhWmsPrdcJobTaskDetailVO taskDetailVO :vo.getJobTaskDetailList()) {
                taskDetailVO.setTaskCode(vo.getCode());
                taskDetailVO.setCode(createNewCode("TKD"));
            }
            //检查耗材库存
            List<WhWmsSkuStockVO> skuStockList = checkStockBeforeOccupy(vo,null, taskDetailDifferenceMap,moveSkus,kOccupyList);
            if(EmptyUtil.isNotEmpty(skuStockList)){
            	stockList.addAll(skuStockList);
            }
            //构造占用,可以启动
            if (CollectionUtils.isNotEmpty(skuStockList) && moveSkus.size()==0 && taskDetailDifferenceMap.size()==0) {
                for (WhWmsSkuStockVO skuStock : skuStockList) {
                    WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
                    occupyVO.setSkuCode(vo.getSkuCode());
                    occupyVO.setBarCode(skuStock.getBarCode());
                    //occupyVO.setSkuStatus(vo.getSkuStatus());
                    occupyVO.setSkuStatus(skuStock.getSkuStatus());
                    occupyVO.setAmount(-(int) Math.ceil(skuStock.getOccupiedAccount()));
                    occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
                    occupyVO.setReceiptsNo(vo.getCode());
                    occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                    occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
                    occupyVO.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
                    occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
                    occupyList.add(occupyVO);
                    canStart = true;
                    ifMoveStock = false;
                }
            }
            //有移库任务,无法启动
            else if(CollectionUtils.isNotEmpty(skuStockList) && CollectionUtils.isNotEmpty(moveSkus)){
                ifMoveStock =  true;
                canStart =  false;
            }
            //库存不足,无移库任务,无法启动
            else{
                ifMoveStock = false;
                canStart = false;
            }
        }
        if(canStart && !ifMoveStock){
            //创建占用
            whWmsOccupyService.wmsBatchOccupy(occupyList);
            //新增子任务
            int insertTask = whWmsPrdcJobTaskMapper.insert(vo);
            if (insertTask <= 0) throw new WarehouseException("","insert data failed!");
            //子任务sku信息
            whWmsPrdcJobTaskDetailService.newTaskDetail(vo.getJobTaskDetailList());
            return true;
        }
        else if(canStart && ifMoveStock && EmptyUtil.isNotEmpty(moveSkus)){
            moveStockVO.setMoveSkuList(moveSkus);
            whWmsMoveStockService.newMoveStock(moveStockVO);
            vo.setMoveStockCode(moveStockVO.getCode());
            return(createJobTaskAndOccupyStock(vo));
        }else if(!canStart && ifMoveStock && EmptyUtil.isNotEmpty(moveSkus)){
        	occupyList = computeOccupyList(stockList,vo);
        	reComputeOccupyList(occupyList,kOccupyList);
        	vo.setHistorykOccupyList(kOccupyList);
            moveStockVO.setMoveSkuList(moveSkus);
            whWmsMoveStockService.newMoveStock(moveStockVO);
            vo.setMoveStockCode(moveStockVO.getCode());
        } else if(!canStart && !ifMoveStock){
            sendOutOfStockEmil(vo.getAmount(),vo.getPhysicalWarehouseCode(),vo.getPrdcJobCode(),taskDetailDifferenceMap);
        }
        return false;
    }
    
    /**
     * 占用前检查可用库存
     * @param taskDetail
     * @return
     * 按照,加工区=>保管区=>拣货区优先级
     */
    public List<WhWmsSkuStockVO> checkStockBeforeOccupy(WhWmsPrdcJobTaskVO task, WhWmsPrdcJobTaskDetailVO taskDetail,Map<String,Integer> taskDetailDifferenceMap,List<WhWmsMoveSkuVO> moveSkus,List<WhWmsOccupyVO> kOccupyList){
        int taskDetailNeedAmount = 0;
        List<WhWmsSkuStockVO> skuStockList = new ArrayList<>();
        WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
        skuStockVOCond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
        skuStockVOCond.setSkuStatus(task.getSkuStatus());
        if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE){
            taskDetailNeedAmount = taskDetail.getAmount().intValue();
            skuStockVOCond.setSkuCode(taskDetail.getSkuCode());
            skuStockVOCond.setSkuCodeLike(taskDetail.getSkuCode());
        }else if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT){
            taskDetailNeedAmount = task.getAmount().intValue();
            skuStockVOCond.setSkuCode(task.getSkuCode());
            skuStockVOCond.setSkuCodeLike(task.getSkuCode());
        }
        int difference = taskDetailNeedAmount; //总差额数量

        //查询加工区+普通区保管库位+普通区拣货库位总可用库存
        List<String> houseTypeList = new ArrayList<>();
        houseTypeList.add(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        houseTypeList.addAll(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));
        skuStockVOCond.setHouseTypes(houseTypeList);
        List<WhWmsSkuStockVO> totalAreaStocks = whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
        //总库存不足,则子任务启动失败
        if(CollectionUtils.isEmpty(totalAreaStocks)){
            if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) taskDetailDifferenceMap.put(taskDetail.getSkuCode(),difference);
            if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) taskDetailDifferenceMap.put(task.getSkuCode(),difference);
            return Collections.EMPTY_LIST;
        }
        else{
            Integer totalAvailStock = 0;
            for(WhWmsSkuStockVO skuStock : totalAreaStocks){
                totalAvailStock += skuStock.getAvailableAmount();
                if(totalAvailStock.compareTo(taskDetailNeedAmount) >= 0)
                    break;
            }
            if (totalAvailStock.compareTo(taskDetailNeedAmount) < 0) {
                difference = taskDetailNeedAmount - totalAvailStock;
                if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) taskDetailDifferenceMap.put(taskDetail.getSkuCode(),difference);
                if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) taskDetailDifferenceMap.put(task.getSkuCode(),difference);
                return Collections.EMPTY_LIST;
            }
        }
        //依次查询库存
        skuStockVOCond.setHouseTypes(null);
        for(final String houseType : houseTypeList){
            int pagenum =100;
            int currpage = 1;
            skuStockVOCond.setPagenum(pagenum);
            skuStockVOCond.setCurrpage(currpage);
            if (difference == 0) break;
            /*skuStockVOCond.setHouseTypes(new ArrayList<String>(){{
                add(houseType);
            }});*/
            skuStockVOCond.setHouseType(houseType);
            List<WhWmsSkuStockVO> areaStocks = whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);

            if (CollectionUtils.isEmpty(areaStocks)) continue;
            if (areaStocks.size()!=1)  throw new WarehouseException("","error,the result isnot unique!");
            WhWmsSkuStockVO areaStock = areaStocks.get(0);
            
            if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && areaStock.getAvailableAmount()<=0) continue;
            //分页遍历
            do{
                skuStockVOCond.setCurrpage(currpage);
                areaStocks =  whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                reComputeSkuStockList(areaStocks,kOccupyList);///临时使用
                if(CollectionUtils.isEmpty(areaStocks)) break;
                if(areaStock.getAvailableAmount()<=0) continue;
                if(areaStock.getAvailableAmount().compareTo(difference) < 0 && difference >0 && areaStock.getAvailableAmount()>0){
                    //areaStocks =  whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                    //reComputeSkuStockList(areaStocks,kOccupyList);///临时使用
                    if(CollectionUtils.isEmpty(areaStocks)) break;
                    for(WhWmsSkuStockVO skuStock :areaStocks){
                        WhWmsHouseShelvesVO houseShelves = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        skuStock.setHouseType(houseShelves.getHouseType());
                        if(!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) &&
                             !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) &&
                                 !houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)) continue;
                        Integer areaAvailableAmount = skuStock.getAvailableAmount();
                        if (areaAvailableAmount<=0) continue;
                        skuStock.setOccupiedAccount(areaAvailableAmount);
                        skuStockList.add(skuStock);
                        difference -= areaAvailableAmount;
                        if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && skuStock.getOccupiedAccount()!=0){
                            WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                            if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                            if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                ||WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                                moveSkus.add(buildMoveSku(houseType,task,skuStock));
                            }
                        }
                    }
                        // difference -= areaStock.getAvailableAmount();
                } else if(areaStock.getAvailableAmount().compareTo(difference) >= 0 && difference >0){
                    //按照可用数量排序
                    Collections.sort(areaStocks,new Comparator<WhWmsSkuStockVO>(){
                        @Override
                        public int compare(WhWmsSkuStockVO vo1, WhWmsSkuStockVO vo2) {
                            return vo1.getAvailableAmount().compareTo(vo2.getAvailableAmount());
                        }
                    });
                    for(WhWmsSkuStockVO skuStock :areaStocks){
                        WhWmsHouseShelvesVO houseShelves = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        skuStock.setHouseType(houseShelves.getHouseType());
                        if(!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) &&
                                !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) &&
                                !houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)) continue;
                        Integer areaAvailableAmount = skuStock.getAvailableAmount();
                        if(areaAvailableAmount.compareTo(difference) >= 0){
                            skuStock.setOccupiedAccount(difference);
                            skuStockList.add(skuStock);
                            difference = 0;
                            if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && skuStock.getOccupiedAccount()!=0){
                                WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                                if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                                if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                    || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                                    moveSkus.add(buildMoveSku(houseType,task,skuStock));
                                }
                            }
                            return skuStockList;
                        }else{
                            if(areaAvailableAmount<=0) continue;
                            skuStock.setOccupiedAccount(areaAvailableAmount);
                            skuStockList.add(skuStock);
                            difference -= areaAvailableAmount;
                            if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && skuStock.getOccupiedAccount()!=0){
                                WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                                if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                                if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                        || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                                    moveSkus.add(buildMoveSku(houseType,task,skuStock));
                                }
                            }
                        }
                    }
                }
                else{
                    throw new WarehouseException("","error,the difference is abnormal");
                }
                currpage += 1;
            }while(areaStocks.size() == pagenum);
        }
        if(difference>0) taskDetailDifferenceMap.put(taskDetail.getSkuCode(),difference);
        return Collections.EMPTY_LIST;
    }
    
    private List<WhWmsOccupyVO> computeOccupyList(List<WhWmsSkuStockVO> skuStockList,WhWmsPrdcJobTaskVO vo){
    	List<WhWmsOccupyVO> occupyList = new ArrayList<>();
    	if(EmptyUtil.isEmpty(skuStockList)){
    		return occupyList;
    	}
    	for (WhWmsSkuStockVO skuStock : skuStockList) {
    		if(!skuStock.getHouseType().equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)){
    			continue;
    		}
            WhWmsOccupyVO occupyVO = new WhWmsOccupyVO();
            occupyVO.setSkuCode(skuStock.getSkuCode());
            occupyVO.setBarCode(skuStock.getBarCode());
            occupyVO.setSkuStatus(skuStock.getSkuStatus());
            occupyVO.setAmount(-(int) Math.ceil(skuStock.getOccupiedAccount()));
            occupyVO.setStatus(WhWmsOccupyVO.OCCUPIED);
            occupyVO.setReceiptsNo(null);
            occupyVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            occupyVO.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
            occupyVO.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
            occupyVO.setOriShelvesCode(skuStock.getShelvesCode());
            occupyList.add(occupyVO);
        }
    	return occupyList;
    }
    
    private void reComputeOccupyList(List<WhWmsOccupyVO> nowkOccupyList,List<WhWmsOccupyVO> oldkOccupyList){
    	if(EmptyUtil.isEmpty(nowkOccupyList)){
    		return;
    	}
    	if(NullUtil.isNull(oldkOccupyList)){
    		oldkOccupyList = new ArrayList<>();
    	}
    	for(WhWmsOccupyVO n : nowkOccupyList){
    		boolean exist = false;
    		for(WhWmsOccupyVO o : oldkOccupyList){
    			if(o.getSkuCode().equals(n.getSkuCode()) &&
    					o.getBarCode().equals(n.getBarCode()) &&
    						o.getSkuStatus().equals(n.getSkuStatus()) &&
    							o.getOriShelvesCode().equals(n.getOriShelvesCode()) &&
    								o.getPhysicalWarehouseCode().equals(n.getPhysicalWarehouseCode())){
    				exist = true;
    				o.setAmount(o.getAmount()+n.getAmount());
    				break;
    			}
    		}
    		if(!exist){
    			oldkOccupyList.add(n);
    		}
    	}
    	
    }
    
    private void reComputeSkuStockList(List<WhWmsSkuStockVO> areaStockList,List<WhWmsOccupyVO> kOccupyList){
    	if(EmptyUtil.isEmpty(areaStockList) || EmptyUtil.isEmpty(kOccupyList)){
    		return;
    	}
    	for(WhWmsSkuStockVO areaStock : areaStockList){
    		reComputeSkuStock(areaStock,kOccupyList);
    	}
    }
    
    /**
     * 重新计算本次可用库存
     * */
    private void reComputeSkuStock(WhWmsSkuStockVO areaStock,List<WhWmsOccupyVO> kOccupyList){
    	if(EmptyUtil.isEmpty(kOccupyList) || NullUtil.isNull(areaStock)){
    		return;
    	}
    	for(WhWmsOccupyVO occupy : kOccupyList){
    		if(occupy.getSkuCode().equals(areaStock.getSkuCode()) &&
    				occupy.getBarCode().equals(areaStock.getBarCode()) &&
    					occupy.getSkuStatus().equals(areaStock.getSkuStatus()) &&
    						occupy.getOriShelvesCode().equals(areaStock.getShelvesCode()) ){
    			areaStock.setAvailableAmount(areaStock.getAvailableAmount()+occupy.getAmount());
    			break;
    		}
    	}
    }

    @Override
    @Transactional
    public Boolean updateJobTask(WhWmsPrdcJobTaskVO vo){
        int update = whWmsPrdcJobTaskMapper.updateByPrimaryKey(vo);
        if (update<0) throw new WarehouseException("","update data failed");
        return null;
    }

    @Override
    public Pagination<WhWmsPrdcJobTaskVO> getPrdcTaskByCondPage(WhWmsPrdcJobTaskCond cond) {
        Pagination<WhWmsPrdcJobTaskVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = whWmsPrdcJobTaskMapper.getCountByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        page.setResultList(BeanUtil.buildListFrom(whWmsPrdcJobTaskMapper.getPrdcJobTaskByCondPage(cond),WhWmsPrdcJobTaskVO.class));
        return page;
    }



    @Override
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo){
        Map<String,Float> skuQuantityConsumeMap = buildTaskConsumeRecipeMaterial(vo);
        List<String> skuCodes = Arrays.asList(skuQuantityConsumeMap.keySet().toArray(new String[skuQuantityConsumeMap.size()]));
        List<WhWmsSkuBarcode> skuBarcodeList = null;
        if(EmptyUtil.isNotEmpty(skuCodes)){
            skuBarcodeList  = whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        }
        if(NullUtil.isNull(skuBarcodeList)){
            skuBarcodeList = new ArrayList<>();
        }
        Map<String,WhWmsSkuBarcode> barcodeMap = new HashMap<>();
        List<String> barCodes = new ArrayList<>();
        for(WhWmsSkuBarcode barcode : skuBarcodeList){
            barCodes.add(barcode.getBarCode());
            barcodeMap.put(barcode.getBarCode(),barcode);
        }
        List<WhWmsSkuStockVO> canUseShelvesStockList = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(barCodes)){
            //查询加工区+普通区保管库位+普通区拣货库位总可用库存
            WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
            stockCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            stockCond.setSkuStatus(vo.getSkuStatus());
            stockCond.setBarCodeList(barCodes);
            stockCond.setHouseTypes(Collections.singletonList(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING));
            List<WhWmsSkuStockVO> shelvesStockList =  whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond,true);
            if(EmptyUtil.isNotEmpty(shelvesStockList)){
                canUseShelvesStockList.addAll(shelvesStockList);
            }
            //普通区保管库位+普通区拣货库位总可用库存
            Map<String,WhWmsWarehouseArea> areaMap = whWmsWarehouseAreaService.getAreaHouseMapByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
            List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
            stockCond.setHouseTypes(houseTypes);
            List<Integer> shelvesTypeList = new ArrayList<>();
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);//拣货库位
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);//保管库位
            stockCond.setShelvesTypeList(shelvesTypeList);
            shelvesStockList =  whWmsSkuStockService.findWmsSkuAvailableAccount(stockCond,true);
            if(EmptyUtil.isNotEmpty(shelvesStockList)){
                canUseShelvesStockList.addAll(shelvesStockList);
            }
        }
        Map<String,Integer> stockSkuQuantityMap = groupStockBySku(canUseShelvesStockList);
        Integer min = Integer.MAX_VALUE;
        for(Map.Entry<String,Float> entry : skuQuantityConsumeMap.entrySet()){
            String skuCode = entry.getKey();
            Float materialAmount = entry.getValue();
            Integer totalStockAmount = stockSkuQuantityMap.get(skuCode);
            log.error("------skuCode:" + skuCode + ";totalStockAmount:" + totalStockAmount + ";materialAmount:" + materialAmount + ";Math.ceil(totalStockAmount/materialAmount):" + Math.ceil(totalStockAmount/materialAmount));
            if(NullUtil.isNull(totalStockAmount) || totalStockAmount < 0){
                totalStockAmount = 0;
            }
            min = Math.min(min,(int)Math.ceil(totalStockAmount/materialAmount));
        }
        return min;
    }

    @Deprecated
    public int getPrdcJobMaxTask_old(WhWmsPrdcJobTaskVO vo) {
        List<Integer> maxInts = new ArrayList<>();
        List<WhWmsPrdcJobTaskDetailVO> taskDetails =  vo.getJobTaskDetailList();
        if(vo.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE){
            for(WhWmsPrdcJobTaskDetailVO taskDetail : taskDetails ){
                WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
                skuStockVOCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                skuStockVOCond.setSkuCode(taskDetail.getSkuCode());
                skuStockVOCond.setSkuCodeLike(taskDetail.getSkuCode());
                //skuStockVOCond.setSkuStatus(WhWmsOccupyVO.OCCUPY_STATUS_GOOD);
                skuStockVOCond.setSkuStatus(vo.getSkuStatus());
                //查询加工区+普通区保管库位+普通区拣货库位总可用库存
                List<String> houseTypeList = new ArrayList<>();
                houseTypeList.add(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
                houseTypeList.addAll(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));
                skuStockVOCond.setHouseTypes(houseTypeList);
                List<WhWmsSkuStockVO> totalStocks = whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
                //总库存不足,则子任务启动失败
                if(CollectionUtils.isEmpty(totalStocks)) return NumberUtils.INTEGER_ZERO;
                List<WhWmsSkuStockVO> totalAreaStocks = whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                //总库存不足,则子任务启动失败
                if(CollectionUtils.isEmpty(totalAreaStocks)){
                    return NumberUtils.INTEGER_ZERO;
                }
                else{
                    int totalAvailableAmount = 0;
                    for(WhWmsSkuStockVO skustock :totalAreaStocks) {
                        WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skustock.getShelvesCode());
                        if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                        if(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING.equals(houseShelvesVO.getHouseType())
                                || WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                            if(skustock.getAvailableAmount()==0) continue;
                        totalAvailableAmount += skustock.getAvailableAmount();
                      }
                    }
                    int max = (int)Math.floor(totalAvailableAmount/taskDetail.getRecipeAmount());
                    maxInts.add(max);
                }
            }
            int min = maxInts.get(0);
            int max = maxInts.get(0);
            for(int j=0;j<maxInts.size();j++)
            {
                if(maxInts.get(j)> max)
                    max = maxInts.get(j);
                if(maxInts.get(j)< min)
                    min = maxInts.get(j);
            }
            if(min<0) return NumberUtils.INTEGER_ZERO;
            else  return min;
        }
        else if(vo.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT){
            WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
            skuStockVOCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            skuStockVOCond.setSkuCode(vo.getSkuCode());
            skuStockVOCond.setSkuCodeLike(vo.getSkuCode());
            //skuStockVOCond.setSkuStatus(WhWmsOccupyVO.OCCUPY_STATUS_GOOD);
            skuStockVOCond.setSkuStatus(vo.getSkuStatus());
            //查询加工区+普通区保管库位+普通区拣货库位总可用库存
            List<String> houseTypeList = new ArrayList<>();
            houseTypeList.add(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
            houseTypeList.addAll(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));
            skuStockVOCond.setHouseTypes(houseTypeList);
            List<WhWmsSkuStockVO> totalStocks = whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
            //总库存不足,则子任务启动失败
            if(CollectionUtils.isEmpty(totalStocks)) return NumberUtils.INTEGER_ZERO;
            List<WhWmsSkuStockVO> totalAreaStocks = whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
            if(CollectionUtils.isNotEmpty(totalAreaStocks)){
                int totalAvailableAmount = 0;
                for(WhWmsSkuStockVO skustock :totalAreaStocks){
                    WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skustock.getShelvesCode());
                    if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                    if(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING.equals(houseShelvesVO.getHouseType())
                            || WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                            || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {
                        if(skustock.getAvailableAmount()==0) continue;
                        totalAvailableAmount += skustock.getAvailableAmount();
                    }
                }
                if(totalAvailableAmount<0){
                    return NumberUtils.INTEGER_ZERO;
                }else{
                    return totalAvailableAmount;
                }

            }
        }
        return NumberUtils.INTEGER_ZERO;
    }

    @Transactional
    public Boolean finishTaskAndUpdateStock(WhWmsPrdcJobTaskVO vo,Long userId) throws Exception{
        if (EmptyUtil.isEmpty(vo.getPrdcJobCode())){
            throw new WarehouseException("","the jobCode isnot can be null");
        }
        if (vo.getJobPlanStatus()== WhWmsPrdcJobTaskVO.WMS_PLAN_STATUS_FINISHED){
            throw new WarehouseException("","["+vo.getPrdcJobCode()+"]the status of the job has been finished!");
        }

        WhWmsOccupyVO occupyCond = new WhWmsOccupyVO();
        occupyCond.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
        occupyCond.setReceiptsNo(vo.getCode());
        occupyCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        occupyCond.setStatus(WhWmsOccupyVO.OCCUPIED);
        occupyCond.setSkuStatus(vo.getSkuStatus());
        occupyCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        //获取占用
        List<WhWmsOccupyVO> occupyList = whWmsOccupyService.getWmsOccupyByCond(occupyCond);
        releaseWmsOccupy(occupyCond);
        List<WhWmsSkuStockRecordVO> updateStocks = buildUpdateStockDatas(vo,userId,occupyList);
        List<WhWmsSkuStockRecordVO> typeInSkuStocks = filterSkuStocks(updateStocks, WhCommand.TYPE_PRODUCE_IN);
        List<WhWmsSkuStockRecordVO> typeOutSkuStocks = filterSkuStocks(updateStocks,WhCommand.TYPE_PRODUCE_OUT);
        String lockKey = "lock:wms:finishTaskAndUpdateStock"+vo.getCode();
        try{
            //获取分布式锁
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                log.info("获取锁失败  "+lockKey);
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            //更新wms 出库库存
            updateWmsStocks(typeOutSkuStocks);
            //更新任务状态
            updateWmsPrdcJobTask(vo,userId);
            //更新scm 需出库库存
            // 记录出入库操作人
            vo.setCreateUserId(userId);
            //更新 scm 出库库存
            updateScmStock(vo);
            //记录上架记录
            String commandCode = createCommandThenRecordWaitPutAway(vo,userId,typeInSkuStocks);
            vo.setCommandCode(commandCode);
            //创建移库单
            String moveCode = moveSkuForTaskFinish(vo,userId,typeInSkuStocks);
            vo.setMoveStockCode(moveCode);
            if(EmptyUtil.isNotEmpty(moveCode)){
                //自动移库
                whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveCode,userId);
                //自动启动上架
                String batchNo = startPutAway(commandCode,vo.getPhysicalWarehouseCode());
                vo.setBatchNo(batchNo);
            }
            // 加工组装入库,如果产生新批次,则需要记录所有主耗材批次号
            if (vo.isMakeNewBarcode()){
                recordPrdcMaterialDetail(vo,typeInSkuStocks,typeOutSkuStocks);
            }

            // 点击【加工完成】后将加工单号赋值到此批次
            if (EmptyUtil.isNotEmpty(vo.getBcId())){
                WhWmsSkuBarcodeVO skuBarcodeVO = whWmsSkuBarcodeService.findById(vo.getBcId());
                if (EmptyUtil.isNotEmpty(skuBarcodeVO) && EmptyUtil.isEmpty(skuBarcodeVO.getRefCode())){
                    skuBarcodeVO.setRefCode(vo.getPrdcJobCode());
                    if (EmptyUtil.isEmpty(skuBarcodeVO.getFirstInDate())){
                        skuBarcodeVO.setFirstInDate(DateUtil.getNow());
                    }
                    whWmsSkuBarcodeService.update(skuBarcodeVO);
                }
            }
            // vo.setPrdcMaterialDetails(updateStocks);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
        return true;
    }

    // 记录生产加工耗材信息
    private void recordPrdcMaterialDetail(WhWmsPrdcJobTaskVO taskVO,List<WhWmsSkuStockRecordVO> typeInSkuStocks,List<WhWmsSkuStockRecordVO> typeOutSkuStocks) {
        List<WhWmsPrdcMaterialDetail> prdcMaterialDetails = new ArrayList<>();
        // 成品信息
        WhWmsSkuStockRecordVO prodSkuInfo =  typeInSkuStocks.get(0);
        // 耗材信息
        for (WhWmsSkuStockRecordVO materialVO : typeOutSkuStocks){
            WhWmsPrdcMaterialDetail prdcMaterialDetail = new WhWmsPrdcMaterialDetail();
            prdcMaterialDetail.setMaterialSku(materialVO.getSkuCode());
            prdcMaterialDetail.setProdSku(prodSkuInfo.getSkuCode());
            prdcMaterialDetail.setMaterialBarcode(materialVO.getBarCode());
            prdcMaterialDetail.setProdBarcode(prodSkuInfo.getBarCode());
            prdcMaterialDetail.setSkuStatus(materialVO.getSkuStatus());
            prdcMaterialDetail.setRealAmount(Math.abs(materialVO.getQuantity()));
            prdcMaterialDetail.setPrdcTaskCode(taskVO.getCode());
            prdcMaterialDetails.add(prdcMaterialDetail);
        }
        whWmsPrdcMaterialDetailService.batchCreate(prdcMaterialDetails);
    }



    
    //开始上架
    private String startPutAway(String commandCode,String physicalWarehouseCode){
    	List<WhWmsWaitPutawayVO> waitPutawayVOs = whWmsWaitPutawayService.findWmsWaitPutawayByReceiptsNo(commandCode);
    	if(EmptyUtil.isEmpty(waitPutawayVOs)){
    		return null;
    	}
    	WhWmsWaitPutawayVO waitPutawayVO = new WhWmsWaitPutawayVO();
    	waitPutawayVO.setPhysicalWarehouseCode(physicalWarehouseCode);
    	List<WhWmsStartPutawayVO> startPutList = new ArrayList<>();
    	for(WhWmsWaitPutawayVO vo : waitPutawayVOs){
    		WhWmsStartPutawayVO tmp = new WhWmsStartPutawayVO();
    		tmp.setId(vo.getId());
    		tmp.setReceiptsNo(vo.getReceiptsNo());
    		tmp.setBarCode(vo.getBarCode());
    		tmp.setSkuCode(vo.getSkuCode());
    		tmp.setSkuStatus(vo.getSkuStatus());
    		tmp.setReceiveAmount(vo.getReceiveAmount());
    		Map<String,Object> skuInfo = whWmsPrdcJobTaskMapper.getPcsSkuInfoBySkuCode(vo.getSkuCode());
    		if(skuInfo == null){
    			throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,vo.getSkuCode()+"不存在");
    		}
    		Integer storageType = EmptyUtil.isEmpty(skuInfo.get("storageType"))?1:Integer.parseInt(skuInfo.get("storageType").toString());
    		tmp.setStorageType(storageType);
    		startPutList.add(tmp);
    	}
    	waitPutawayVO.setStartPutList(startPutList);
    	return whWmsWaitPutawayService.startPutaway(waitPutawayVO);
    }

    private String createCommandThenRecordWaitPutAway(WhWmsPrdcJobTaskVO vo,Long userId,List<WhWmsSkuStockRecordVO> inUpdateStocks) throws Exception{
        String commandCode = null;
        Map<String,String> skuAndBarcodeMap = new HashMap<>();
        List<WhCommandSku> commandSkus = buildSkuCommandList(inUpdateStocks,skuAndBarcodeMap);
        // 成品的sku及批次
        skuAndBarcodeMap.put(vo.getSkuCode(),vo.getBarcode());

        // 逻辑仓为：物理仓对应的默认入库良品仓
        WhWarehouse whWarehouse = whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(vo.getPhysicalWarehouseCode());
        if(EmptyUtil.isNotEmpty(whWarehouse)){
            if(commandSkus!=null && !commandSkus.isEmpty()){
                WhCommand whCommand = new WhCommand();
                whCommand.setReferenceCode(vo.getCode());
                whCommand.setWarehouseCode(whWarehouse.getCode());
                whCommand.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                whCommand.setInOutType(WhCommand.TYPE_PRODUCE_IN);
                whCommand.setWhCommandSkuList(commandSkus);
                whCommandService.createCommand(whCommand);
                commandCode = whCommand.getCode();
                WhReceiveShelvesVO receiveShelvesVO = new WhReceiveShelvesVO();
                receiveShelvesVO.setWhCommandId(whCommand.getId().intValue());
                receiveShelvesVO.setWhCmdCode(whCommand.getCode());
                receiveShelvesVO.setOperatorId(userId.intValue());
                receiveShelvesVO.setReferenceCode(vo.getCode());
                receiveShelvesVO.setWhInType(WhCommand.TYPE_PRODUCE_IN);//上架类型
                List<WhQualityControlVO> qcVoList = buildQualityControlDatas(vo,skuAndBarcodeMap);
                receiveShelvesVO.setQcList(qcVoList);

                // 此处不再调用 getBarCode，因为已经在前面(buildupdateStockDatas 处)获取了相应的barcode
                receiveShelvesVO.setExistsBarcode(true);
                whCommandService.qualityControl(receiveShelvesVO,WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
            }
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"上架失败，找不到["+vo.getPhysicalWarehouseCode()+"]对应的默认入库良品仓");
        }
        return commandCode;
    }
    
    /**
     * 组织待质检数据
     * */
    private List<WhQualityControlVO> buildQualityControlDatas(WhWmsPrdcJobTaskVO vo,Map<String,String> skuAndBarcodeMap){
    	List<WhQualityControlVO> qcVoList = new ArrayList<WhQualityControlVO>();
    	if(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE == vo.getJobType()){//组装
    		 WhQualityControlVO qc = new WhQualityControlVO();
             qc.setQcSku(vo.getSkuCode());
             qc.setQcProdDate(vo.getProductDate());
             qc.setQcExpirationDate(vo.getExpirationDate());
             qc.setNondefectiveQuantity(0);
             qc.setDefectiveQuantity(0);
             qc.setSampleQuantity(0);
             if(vo.getFinishedGoodsAmount()!=null && vo.getFinishedGoodsAmount()>0){
            	 qc.setNondefectiveQuantity(vo.getFinishedGoodsAmount());
             }
             if(vo.getFinishedDefectiveAmount()!=null && vo.getFinishedDefectiveAmount()>0 ){
            	 qc.setDefectiveQuantity(vo.getFinishedDefectiveAmount());
             }
             qc.setBarCode(skuAndBarcodeMap.get(vo.getSkuCode()));
             qcVoList.add(qc);
    	}else if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT == vo.getJobType()){//拆分
    		Integer amount = vo.getFinishedGoodsAmount();
    		List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
    		if(EmptyUtil.isNotEmpty(jobTaskDetailList) && amount>0 ){//拆出来的主耗材库存变化
    			for(WhWmsPrdcJobTaskDetailVO taskDetailVO :  jobTaskDetailList){
    				if(taskDetailVO.getMaterialType()!=null
                            && WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())){
    					WhQualityControlVO qc = new WhQualityControlVO();
    		            qc.setQcSku(taskDetailVO.getSkuCode());
    		            qc.setQcProdDate(taskDetailVO.getProductDate());
                        qc.setQcExpirationDate(taskDetailVO.getExpirationDate());
    		            qc.setNondefectiveQuantity(0);
    		            qc.setDefectiveQuantity(0);
    		            qc.setSampleQuantity(0);
    					Integer totalAmount = amount*taskDetailVO.getRecipeAmount().intValue();
    					if(taskDetailVO.getRealAmount()>0){
    						qc.setNondefectiveQuantity(taskDetailVO.getRealAmount());
    					}
    					Integer defectiveQuantity = totalAmount-taskDetailVO.getRealAmount();
    					if(defectiveQuantity>0){
    						qc.setDefectiveQuantity(defectiveQuantity);
    					}
                        qc.setBarCode(skuAndBarcodeMap.get(taskDetailVO.getSkuCode()));
    					qcVoList.add(qc);
    				}
    			}
    		}
    	}
    	return qcVoList;
    }

    /**
     *创建移库任务加工区库存移到收货暂存区
     * */
    private String moveSkuForTaskFinish(WhWmsPrdcJobTaskVO vo,Long userId,List<WhWmsSkuStockRecordVO> updateStocks){
        String moveCode = null;
        List<WhWmsSkuStockRecordVO> inStocks = updateStocks;
        if(inStocks.isEmpty()){
            return moveCode;
        }
        List<WhWmsMoveSkuVO> moveSkus = new ArrayList<WhWmsMoveSkuVO>();
        for(WhWmsSkuStockRecordVO stock : inStocks){
            if(stock.getQuantity()==0){
                continue;
            }
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
            moveSkuVO.setCreateTime(new Date());
            moveSkuVO.setOriginalHouseType(stock.getHouseType());
            moveSkuVO.setTargetHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
            moveSkuVO.setSkuStatus(stock.getSkuStatus());
            moveSkuVO.setAmount(stock.getQuantity());
            moveSkuVO.setSkuCode(stock.getSkuCode());
            moveSkuVO.setBarCode(stock.getBarCode());
            moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
            WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
            cond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
            cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
            List<WhWmsHouseShelvesVO> targetShelves = whWmsHouseShelves.getHouseShelvesByCond(cond);
            if(CollectionUtils.isEmpty(targetShelves))
                throw new WarehouseException("",stock.getPhysicalWarehouseCode()+":收货暂存区库位不存在!");
            moveSkuVO.setTargetShelvesCode(targetShelves.get(0).getCode());
            moveSkus.add(moveSkuVO);
        }
        if(moveSkus!=null && !moveSkus.isEmpty()){
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(vo.getCreateUserId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_PRODUCTION);
            moveStockVO.setMoveSkuList(moveSkus);
            whWmsMoveStockService.newMoveStock(moveStockVO);
            moveCode = moveStockVO.getCode();
        }
        return moveCode;
    }

    //更新任务状态
    private void updateWmsPrdcJobTask(WhWmsPrdcJobTaskVO vo,Long userId){
        //更新任务状态
        WhWmsPrdcJobTaskVO updateJobTaskVO = new WhWmsPrdcJobTaskVO();
        updateJobTaskVO.setId(vo.getId());
        updateJobTaskVO.setFinishedGoodsAmount(vo.getFinishedGoodsAmount());
        updateJobTaskVO.setFinishedDefectiveAmount(vo.getFinishedDefectiveAmount());
        updateJobTaskVO.setStatus(WhWmsPrdcJobTaskVO.STATUS_FINISHED);
        updateJobTaskVO.setFinishedUserId(userId);
        updateJobTaskVO.setFinishedTime(DateUtil.getNow());
        if (EmptyUtil.isNotEmpty(vo.getMemo())){
            updateJobTaskVO.setMemo(vo.getMemo());
        }
        whWmsPrdcJobTaskMapper.updateByPrimaryKeySelective(updateJobTaskVO);
        if(vo.getJobTaskDetailList()!=null){
            for(WhWmsPrdcJobTaskDetailVO taskDetailVO : vo.getJobTaskDetailList()){
                whWmsPrdcJobTaskDetailService.updateTaskDetailPrimaryKeySelective(taskDetailVO);
            }
        }
    }
    //更新wms库存
    private void updateWmsStocks(List<WhWmsSkuStockRecordVO> updateStocks){
        if(updateStocks == null || updateStocks.isEmpty()){
            return;
        }
        for(WhWmsSkuStockRecordVO skuStock : updateStocks ){
            whWmsSkuStockService.updateStockByCond(skuStock.getQuantity(),
                    skuStock.getPhysicalWarehouseCode(),
                    skuStock.getHouseType(),
                    skuStock.getBarCode(),
                    skuStock.getShelvesCode(),
                    skuStock.getSkuCode(),
                    skuStock.getSkuStatus(),
                    skuStock.getInOutType(),
                    skuStock.getReceiptNo(),
                    skuStock.getCreateUserId(),null,1);
        }
    }

    private List<WhWmsSkuStockRecordVO> buildUpdateStockDatas(WhWmsPrdcJobTaskVO vo,Long userId,List<WhWmsOccupyVO> occupyList){
        List<WhWmsSkuStockRecordVO> updateSkuStockList = new ArrayList<>();
        List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
        //待入库库位
        WhWmsHouseShelvesVO shelvesVO = getWhWmsHouseShelvesVO(vo);
        if(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())){ //组装
            List<String> materialBarcodes = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(occupyList) && CollectionUtils.isNotEmpty(jobTaskDetailList)){
                Map<String,String> skuBarcodeMap = new HashMap<>();
                for (WhWmsOccupyVO occupyVO : occupyList){
                    skuBarcodeMap.put(occupyVO.getSkuCode(),occupyVO.getBarCode());
                }
                for(WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList){
                    List<WhWmsSkuStockRecordVO> list = getAssembleStockUpdate(taskDetailVO,occupyList,userId);
                    updateSkuStockList.addAll(list);
                    if (WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())){
                        materialBarcodes.add(skuBarcodeMap.get(taskDetailVO.getSkuCode()));
                    }
                }
            }
            String barCode = vo.getBarcode();
            vo.setMaterialBarcodes(materialBarcodes);
            //成品库存变化
            if(vo.getFinishedGoodsAmount()!=null && vo.getFinishedGoodsAmount()>0){
            	/*if(EmptyUtil.isEmpty(barCode)){
            		barCode = whCommandService.getBarCode(vo.getSkuCode(), vo.getProductDate());
            	}*/
                if (EmptyUtil.isEmpty(barCode)){
                    barCode = getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE,vo,null,WhCommand.TYPE_PRODUCE_IN);
                }
                WhWmsSkuStockRecordVO skuStockGoods = buildSkuStock(vo.getFinishedGoodsAmount(),
                        vo.getPhysicalWarehouseCode(),
                        shelvesVO.getHouseType(),
                        vo.getSkuCode(),
                        barCode,
                        shelvesVO.getCode(),
                        WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,
                        WhCommand.TYPE_PRODUCE_IN,
                        vo.getCode(),
                        userId);
                updateSkuStockList.add(skuStockGoods);
            }
            if(vo.getFinishedDefectiveAmount()!=null && vo.getFinishedDefectiveAmount()>0 ){
            	if(EmptyUtil.isEmpty(barCode)){
            		// barCode = whCommandService.getBarCode(vo.getSkuCode(), vo.getProductDate());
                    barCode = getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE,vo,null,WhCommand.TYPE_PRODUCE_IN);
            	}
                WhWmsSkuStockRecordVO skuStockDefective = buildSkuStock(vo.getFinishedDefectiveAmount(),
                        vo.getPhysicalWarehouseCode(),
                        shelvesVO.getHouseType(),
                        vo.getSkuCode(),
                        barCode,
                        shelvesVO.getCode(),
                        WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,
                        WhCommand.TYPE_PRODUCE_IN,
                        vo.getCode(),
                        userId);
                updateSkuStockList.add(skuStockDefective);
            }
            vo.setBarcode(barCode);
        }else if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(vo.getJobType())){ //拆分
            Map<String,WhWmsOccupyVO> skuOccupyMap = new HashMap<>();
            List<WhWmsSkuStockRecordVO> updateStocks = getSplitStockUpdate(vo,occupyList,userId,skuOccupyMap);
            // 成品的批次
            if (EmptyUtil.isEmpty(vo.getBarcode())
                    && EmptyUtil.isNotEmpty(skuOccupyMap.get(vo.getSkuCode()))){
                vo.setBarcode(skuOccupyMap.get(vo.getSkuCode()).getBarCode());
            }
            updateSkuStockList.addAll(updateStocks);
            Integer amount = vo.getFinishedGoodsAmount();
            if(jobTaskDetailList!=null && amount>0 ){//拆出来的主耗材库存变化
                for(WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList){
                    if(taskDetailVO.getMaterialType()!=null
                            && WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())){
                        Integer totalAmount = amount*taskDetailVO.getRecipeAmount().intValue();
                        String materialBarCode = null;
                        if(taskDetailVO.getRealAmount()>0){
                        	/*if(EmptyUtil.isEmpty(materialBarCode)){
                        		// barCode = whCommandService.getBarCode(taskDetailVO.getSkuCode(), taskDetailVO.getProductDate());
                        	}*/
                            materialBarCode = getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT,vo,taskDetailVO,WhCommand.TYPE_PRODUCE_IN);
                            WhWmsSkuStockRecordVO skuStockGood = buildSkuStock(taskDetailVO.getRealAmount(),
                                    vo.getPhysicalWarehouseCode(),
                                    shelvesVO.getHouseType(),
                                    taskDetailVO.getSkuCode(),
                                    materialBarCode,
                                    shelvesVO.getCode(),
                                    WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,
                                    WhCommand.TYPE_PRODUCE_IN,
                                    taskDetailVO.getCode(),//vo.getCode(),
                                    userId);
                            updateSkuStockList.add(skuStockGood);
                        }
                        if(totalAmount-taskDetailVO.getRealAmount()>0){
                        	if(EmptyUtil.isEmpty(materialBarCode)){
                                if (EmptyUtil.isNotEmpty(taskDetailVO.getProductDate())){
                                    materialBarCode = whCommandService.getBarCode(taskDetailVO.getSkuCode(), taskDetailVO.getProductDate());
                                }else{
                                    materialBarCode = getBarCodeByCond(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT,vo,taskDetailVO,WhCommand.TYPE_PRODUCE_IN);
                                }
                        	}
                            WhWmsSkuStockRecordVO skuStockBad = buildSkuStock(totalAmount-taskDetailVO.getRealAmount(),
                                    vo.getPhysicalWarehouseCode(),
                                    shelvesVO.getHouseType(),
                                    taskDetailVO.getSkuCode(),
                                    materialBarCode,//getBarCode(taskDetailVO.getSkuCode(),null),
                                    shelvesVO.getCode(),
                                    WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,
                                    WhCommand.TYPE_PRODUCE_IN,
                                    taskDetailVO.getCode(),//vo.getCode(),
                                    userId);
                            updateSkuStockList.add(skuStockBad);
                        }

                    }
                }
            }
        }
        return updateSkuStockList;
    }

    /**
     * 获取耗材中最小的生产日期 的批次贪睡
     * @param vo
     * @return
     */
    @Override
    public WhWmsSkuBarcode findMinExpiryDateByMaterialOccupy(WhWmsPrdcJobTaskVO vo){
        if (EmptyUtil.isEmpty(vo) || CollectionUtils.isEmpty(vo.getJobTaskDetailList())
                || !WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(vo.getJobType())){
            return null;
        }
        WhWmsOccupyVO occupyCond = new WhWmsOccupyVO();
        occupyCond.setType(WhWmsOccupyVO.TYPE_PRODUCTION);
        occupyCond.setReceiptsNo(vo.getCode());
        occupyCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        // 提前打印时，占用查询 无需此条件
        if (vo.isOccupyFlag()){
            occupyCond.setStatus(WhWmsOccupyVO.OCCUPIED);
        }
        occupyCond.setSkuStatus(vo.getSkuStatus());
        occupyCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        //获取占用
        List<WhWmsOccupyVO> occupyList = whWmsOccupyService.getWmsOccupyByCond(occupyCond);

        List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
        List<String> materialBarcodes = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(occupyList)){
            Map<String,String> skuBarcodeMap = new HashMap<>();
            for (WhWmsOccupyVO occupyVO : occupyList){
                skuBarcodeMap.put(occupyVO.getSkuCode(),occupyVO.getBarCode());
            }
            for(WhWmsPrdcJobTaskDetailVO taskDetailVO : jobTaskDetailList){
                if (WhWmsPrdcJobTaskDetailVO.MATERIALTYPE_MAIN.equals(taskDetailVO.getMaterialType())){
                    materialBarcodes.add(skuBarcodeMap.get(taskDetailVO.getSkuCode()));
                }
            }
        }
        if (materialBarcodes.size() > 0){
            WhWmsSkuBarcode whWmsSkuBarcode = whWmsSkuBarcodeService.findMinProdOrExpiryDateByBarCodes(materialBarcodes);
            return whWmsSkuBarcode;
        }
        return null;
    }

    private String getBarcodeBySkuCanCustomize(String skuCode){
        WhWmsSkuBarcodeVO wmsSkuBarcodeVO = whWmsSkuBarcodeService.findSkuInfoBySkuCode(skuCode);
        if (EmptyUtil.isEmpty(wmsSkuBarcodeVO)){
            throw new RuntimeException("["+skuCode+"],当前SKU不存在!");
        }
        // 是定制，则直接使用_0001批次
        if (EmptyUtil.isNotEmpty(wmsSkuBarcodeVO.getCanCustomize())
                && wmsSkuBarcodeVO.getCanCustomize() == 1){
            return whCommandService.createBarCodeWhenNotExists(skuCode, skuCode+"_0001", 1, null);
        }
        return null;
    }


    private String getBarCodeByCond(Integer jobType,WhWmsPrdcJobTaskVO vo,WhWmsPrdcJobTaskDetailVO taskDetailVO,Integer inOutType){
        String barCode = "";

        if (WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE.equals(jobType)){

            /**
             * [ID1000069]
             * 生产加工完成生成批次时，如果成品是定制商品，直接使用默认批次0001，无需生成新批次
             */
            String barcode = getBarcodeBySkuCanCustomize(vo.getSkuCode());
            if (barcode != null){
                return barcode;
            }

            WhQualityControlVO qcCond = new WhQualityControlVO();
            qcCond.setQcSku(vo.getSkuCode());
            Integer shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(vo.getSkuCode());
            if (EmptyUtil.isNotEmpty(shelfLife) && shelfLife>0 && CollectionUtils.isNotEmpty(vo.getMaterialBarcodes())){
                // 查询主耗材中[最早的生产日期]和[最早的过期日期]
                WhWmsSkuBarcode whWmsSkuBarcode = whWmsSkuBarcodeService.findMinProdOrExpiryDateByBarCodes(vo.getMaterialBarcodes());
                if (EmptyUtil.isNotEmpty(whWmsSkuBarcode)){
                    qcCond.setQcProdDate(whWmsSkuBarcode.getProdDate());
                    qcCond.setQcExpirationDate(whWmsSkuBarcode.getExpirationDate());
                    qcCond.setManualCalculate(true);
                }else if(EmptyUtil.isNotEmpty(vo.getProductDate())){
                    // 如果 主耗材找不到，则采用 界面上输入的生产日期 by #6854
                    qcCond.setQcProdDate(vo.getProductDate());
                }
            }
            // 改成加工单号
            //qcCond.setReferenceCode(vo.getCode());
            qcCond.setReferenceCode(vo.getPrdcJobCode());
            qcCond.setWhInType(inOutType);
            barCode = whCommandService.getBarCode(qcCond);
            vo.setMakeNewBarcode(qcCond.isMakeNewBarcode());
        }else if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT.equals(jobType)){
            Integer shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(taskDetailVO.getSkuCode());
            if (EmptyUtil.isNotEmpty(taskDetailVO.getProductDate())){
                Date expirationDate  = null;
                // 通过生产日期及保质期  计算出 过期日期
                if(shelfLife != null && shelfLife > 0){
                    expirationDate = DateUtil.addDay(taskDetailVO.getProductDate(),shelfLife);
                }
                WhWmsSkuBarcodeVO barcodeCond = new WhWmsSkuBarcodeVO();
                barcodeCond.setSkuCode(taskDetailVO.getSkuCode());
                barcodeCond.setProdDate(taskDetailVO.getProductDate());
                barcodeCond.setExpirationDate(expirationDate);
                List<WhWmsSkuBarcodeVO> barCodeList = whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(barcodeCond);
                if (CollectionUtils.isEmpty(barCodeList)) {
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"SKU["+taskDetailVO.getSkuCode()+"],未找到生产日期对应的批次号");
                }
                /*Collections.sort(barCodeList,new Comparator<WhWmsSkuBarcodeVO>(){
                    @Override
                    public int compare(WhWmsSkuBarcodeVO vo1, WhWmsSkuBarcodeVO vo2) {
                        Date d1 = vo1.getExpirationDate();
                        Date d2 = vo2.getExpirationDate();
                        if(d1==null && d2==null){
                            return 0;
                        }
                        if(d1==null && d2!=null){
                            return 1;
                        }
                        if(d1!=null && d2==null){
                            return -1;
                        }
                        return d1.compareTo(d2);
                    }
                });*/
                barCode = barCodeList.get(0).getBarCode();
            }else{
                WhWmsPrdcMaterialDetailCond cond = new WhWmsPrdcMaterialDetailCond();
                cond.setMaterialSku(taskDetailVO.getSkuCode());
                cond.setProdBarcode(vo.getBarcode());
                List<WhWmsPrdcMaterialDetail> prdcMaterialDetails = whWmsPrdcMaterialDetailService.listWhWmsPrdcMaterialDetailByCond(cond);
                if (CollectionUtils.isNotEmpty(prdcMaterialDetails)){
                    if(prdcMaterialDetails.size() == 1){
                        barCode = prdcMaterialDetails.get(0).getMaterialBarcode();
                    }else if (EmptyUtil.isNotEmpty(shelfLife) && shelfLife>0){
                        // 效期商品,则取过期日期最近的，即最先过期的的批次(过期日期>=今天)
                        List<String> barcodes = whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(taskDetailVO.getSkuCode());
                        if (CollectionUtils.isEmpty(barcodes)){
                            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"拆分时,找不到有效期的耗材批次信息["+taskDetailVO.getSkuCode()+"]");
                        }
                        barCode = barcodes.get(0);
                    }else{
                        // 不是效期商品，则直接取 sku+0001
                        barCode = taskDetailVO.getSkuCode()+"_0001";
                        whCommandService.createBarCodeWhenNotExists(taskDetailVO.getSkuCode(),barCode,1,null);
                    }
                }else{
                    barCode = taskDetailVO.getSkuCode()+"_0001";
                    whCommandService.createBarCodeWhenNotExists(taskDetailVO.getSkuCode(),barCode,1,null);
                   // throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"拆分时,找不到耗材批次信息["+taskDetailVO.getSkuCode()+"],["+vo.getCode()+"]");
                }
            }
        }
        return barCode;
    }

    /**
     *释放生产加工占用
     *
     * */
    private void releaseWmsOccupy(WhWmsOccupyVO occupyCond){
        //占用释放
        whWmsOccupyService.releaseWmsOccupy(occupyCond);

    }

    /**
     * 获取库位
     * */
    private WhWmsHouseShelvesVO getWhWmsHouseShelvesVO(WhWmsPrdcJobTaskVO vo){
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        cond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        WhWmsHouseShelvesVO shelvesVO = null;
        List<WhWmsHouseShelvesVO> shelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if(shelvesList==null || shelvesList.isEmpty()){
            throw new WarehouseException("","["+vo.getPrdcJobCode()+"]，物理仓["+cond.getPhysicalWarehouseCode()+"]，库区["+cond.getHouseType()+"]没有库位存放成品!");
        }
        shelvesVO = shelvesList.get(0);
        return shelvesVO;
    }





    private List<String> getReferenceCodes(List<Map<String,Object>> prdcJobLineInfos){
        List<String> codes = new ArrayList<String>();
        if(prdcJobLineInfos!=null && !prdcJobLineInfos.isEmpty()){
            for(Map<String,Object> prdcJobLineInfo : prdcJobLineInfos){
                Object obj = prdcJobLineInfo.get("code");
                if(obj!=null){
                    codes.add(obj.toString());
                }
            }
        }
        return codes;
    }

    /**
     * 过滤占用
     * */
    private WhInvOccupy getwhInvOccupy(List<WhInvOccupy> whInvOccupyList,String referenceCode){
        if(whInvOccupyList!=null && !whInvOccupyList.isEmpty()){
            for(WhInvOccupy whInvOccupy : whInvOccupyList){
                if(referenceCode.equals(whInvOccupy.getReferenceCode())){
                    return whInvOccupy;
                }
            }
        }
        return null;
    }

    /**
     * 过滤jobLine信息
     * */
    private Map<String,Object> getPrdcJobLineInfoBySkuCode(List<Map<String,Object>> prdcJobLineInfos,String skuCode){
        if(prdcJobLineInfos!=null && !prdcJobLineInfos.isEmpty()){
            for(Map<String,Object> prdcJobLineInfo : prdcJobLineInfos){
                Object obj = prdcJobLineInfo.get("skuCode");
                if(obj!=null && skuCode.equals(obj)){
                    return prdcJobLineInfo;
                }
            }
        }
        return null;
    }



    /**
     * 拆分时获取成品库存变动
     * */
    private List<WhWmsSkuStockRecordVO> getSplitStockUpdate(WhWmsPrdcJobTaskVO vo,List<WhWmsOccupyVO> occupyList,Long userId,Map<String,WhWmsOccupyVO> skuOccupyMap){
        fullExpirationDateThenSort(occupyList);
        List<WhWmsSkuStockRecordVO> updateSkuStockList = new ArrayList<WhWmsSkuStockRecordVO>();
        Integer needAmount = vo.getFinishedDefectiveAmount()+vo.getFinishedGoodsAmount();
        if(needAmount == 0){
            return updateSkuStockList;
        }
        for(WhWmsOccupyVO occupyVO : occupyList){
            if(vo.getSkuCode().equals(occupyVO.getSkuCode())){ //待拆分sku 库存变化
                if(needAmount+occupyVO.getAmount()>0){
                    WhWmsSkuStockRecordVO skuStock = buildSkuStock(occupyVO.getAmount(),
                            occupyVO.getPhysicalWarehouseCode(),
                            occupyVO.getHouseType(),
                            occupyVO.getSkuCode(),
                            occupyVO.getBarCode(),
                            occupyVO.getOriShelvesCode(),
                            occupyVO.getSkuStatus(),
                            WhCommand.TYPE_PRODUCE_OUT,
                            vo.getCode(),
                            userId);
                    updateSkuStockList.add(skuStock);
                    needAmount +=occupyVO.getAmount();
                }else{
                    WhWmsSkuStockRecordVO skuStock = buildSkuStock(-needAmount,
                            occupyVO.getPhysicalWarehouseCode(),
                            occupyVO.getHouseType(),
                            occupyVO.getSkuCode(),
                            occupyVO.getBarCode(),
                            occupyVO.getOriShelvesCode(),
                            occupyVO.getSkuStatus(),
                            WhCommand.TYPE_PRODUCE_OUT,
                            vo.getCode(),
                            userId);
                    updateSkuStockList.add(skuStock);
                    needAmount = 0;
                }
            }
            skuOccupyMap.put(occupyVO.getSkuCode(),occupyVO);
        }
        if(needAmount>0){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"待拆分的sku占用数量不对!");
        }
        return updateSkuStockList;
    }


    /**
     * 组装时获取耗材库存变动
     * */
    private List<WhWmsSkuStockRecordVO> getAssembleStockUpdate(WhWmsPrdcJobTaskDetailVO taskDetailVO,List<WhWmsOccupyVO> occupyList,Long userId){
        fullExpirationDateThenSort(occupyList);
        List<WhWmsSkuStockRecordVO> list = new ArrayList<WhWmsSkuStockRecordVO>();
        int needAmount = taskDetailVO.getRealAmount();
        if(needAmount==0){
            return list;
        }
        for(WhWmsOccupyVO occupyVO : occupyList){
            if(!occupyVO.getSkuCode().equals(taskDetailVO.getSkuCode())){
                continue;
            }
            if(needAmount+occupyVO.getAmount()>0){
                WhWmsSkuStockRecordVO skuStock = buildSkuStock(occupyVO.getAmount(),
                        occupyVO.getPhysicalWarehouseCode(),
                        occupyVO.getHouseType(),
                        occupyVO.getSkuCode(),
                        occupyVO.getBarCode(),
                        occupyVO.getOriShelvesCode(),
                        occupyVO.getSkuStatus(),
                        WhCommand.TYPE_PRODUCE_OUT,
                        taskDetailVO.getCode(),//occupyVO.getReceiptsNo(),
                        userId);
                list.add(skuStock);
                needAmount += occupyVO.getAmount();
            }else{
                WhWmsSkuStockRecordVO skuStock = buildSkuStock(-needAmount,
                        occupyVO.getPhysicalWarehouseCode(),
                        occupyVO.getHouseType(),
                        occupyVO.getSkuCode(),
                        occupyVO.getBarCode(),
                        occupyVO.getOriShelvesCode(),
                        occupyVO.getSkuStatus(),
                        WhCommand.TYPE_PRODUCE_OUT,
                        taskDetailVO.getCode(),//occupyVO.getReceiptsNo(),
                        userId);
                needAmount = 0;
                list.add(skuStock);
                break;
            }
        }
        if(needAmount>0){
            //待处理
        }

        return list;
    }

    /**
     * 更新scm库存
     * @throws Exception 
     * */
    private void updateScmStock(WhWmsPrdcJobTaskVO vo) throws Exception{
        //创建出库指令
        List<WhCommand> commands = new ArrayList<WhCommand>();
        List<WhReleaseOccupationVO> releaseOccupations = new ArrayList<WhReleaseOccupationVO>();
        List<Map<String,Object>> prdcJobLineInfos = whWmsPrdcJobTaskMapper.getPrdcJobLineInfos(vo.getPrdcJobCode());

        List<WhInvOccupy> whInvOccupyList = null;
        List<WhInvOccupy> afterWhInvOccupyList = new ArrayList<WhInvOccupy>();
        boolean jobFinished = false;
        List<String> prdcJobCodes = new ArrayList<String>();
        prdcJobCodes.add(vo.getPrdcJobCode());
        List<Map<String,Object>> wmsPrdcJobTaskInfos = getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
        Map<String,Object> prdcJob = whWmsPrdcJobTaskMapper.getPrdcJobInfo(vo.getPrdcJobCode());
        Map<String,Object> prdcTaskInfo = wmsPrdcJobTaskInfos.get(0);
        Integer estQuantity = Integer.parseInt(prdcJob.get("estQuantity").toString());
        Integer finishAmount = Integer.parseInt(prdcTaskInfo.get("amount").toString());

        if(finishAmount.equals(estQuantity)){
            //任务已完成
            jobFinished = true;
        }

        if (EmptyUtil.isEmpty(prdcJob.get("physicalWarehouseCode"))){
            throw new  WarehouseException("",prdcJob.get("code").toString()+"[没有物理仓]");
        }
        String physicalWarehouseCode = prdcJob.get("physicalWarehouseCode").toString();
        if(WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT == vo.getJobType()
                && vo.getFinishedGoodsAmount()>0){//拆分
            //主耗材库存变化
            //Map<String,Object> prdcJob = whWmsPrdcJobTaskMapper.getPrdcJobInfo(vo.getPrdcJobCode());
            List<String> referenceCodes = new ArrayList<String>();
            referenceCodes.add(prdcJob.get("code").toString());
            whInvOccupyList = whInvService.getWhInvOccupy(referenceCodes);
            String jobCode = prdcJob.get("code").toString();
            WhInvOccupy whInvOccupy = getwhInvOccupy(whInvOccupyList,jobCode);
            if (EmptyUtil.isEmpty(whInvOccupy)){
                throw new  WarehouseException("",jobCode+"[没有scm占用信息]");
            }
            WhCommand whCommandJob = new WhCommand();
            List<WhCommandSku> commandSkus = new ArrayList<>();
            whCommandJob.setWarehouseCode(whInvOccupy.getWarehouseCode());
            whCommandJob.setPhysicalWarehouseCode(physicalWarehouseCode);
            whCommandJob.setReferenceCode(vo.getCode());
            whCommandJob.setPlanedDeliveryDate(DateUtil.getNow());//冗余预计发货日期
            whCommandJob.setInOutType(WhCommand.TYPE_PRODUCE_OUT);
            WhCommandSku jobLineSku = new WhCommandSku();
            jobLineSku.setSkuCode(vo.getSkuCode());
            jobLineSku.setPlanedQuantity(vo.getFinishedGoodsAmount());
            /*if(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(vo.getSkuStatus())){//完成数
                jobLineSku.setQuantity(0);
                jobLineSku.setDamagedQuantity(vo.getFinishedGoodsAmount());
            }else{
                jobLineSku.setQuantity(vo.getFinishedGoodsAmount());
                jobLineSku.setDamagedQuantity(0);
            }*/
            jobLineSku.setQuantity(vo.getFinishedGoodsAmount());
            jobLineSku.setDamagedQuantity(0);

            commandSkus.add(jobLineSku);
            whCommandJob.setWhCommandSkuList(commandSkus);
            whCommandJob.setOperatorId(vo.getCreateUserId());
            commands.add(whCommandJob);
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(WhInvOccupy.TYPE_PRODUCE_OUT);
            whReleaseOccupationVO.setReferenceCode(jobCode);
            releaseOccupations.add(whReleaseOccupationVO);
            //新占用数量改变
            if(!jobFinished){
                Integer amount = vo.getFinishedGoodsAmount()+vo.getFinishedDefectiveAmount();
                if(whInvOccupy.getQuantity()>amount){
                    whInvOccupy.setQuantity(whInvOccupy.getQuantity()-amount);
                    afterWhInvOccupyList.add(whInvOccupy);
                }
            }

        }else if(WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE == vo.getJobType()){
            whInvOccupyList = whInvService.getWhInvOccupy(getReferenceCodes(prdcJobLineInfos));
            List<WhWmsPrdcJobTaskDetailVO> jobTaskDetailList = vo.getJobTaskDetailList();
            if (CollectionUtils.isEmpty(whInvOccupyList)){
            	throw new  WarehouseException("","没有占用库存");
            }
            String warehouseCode = whInvOccupyList.get(0).getWarehouseCode();
            if(jobTaskDetailList!=null && !jobTaskDetailList.isEmpty()){

                //耗材库存变化
                for(WhWmsPrdcJobTaskDetailVO jobTaskDetail : jobTaskDetailList){
                	List<WhCommandSku> commandSkus = new ArrayList<WhCommandSku>();
                    if(jobTaskDetail.getRealAmount()>0){
                    	WhCommandSku jobLineSku = new WhCommandSku();
                        jobLineSku.setSkuCode(jobTaskDetail.getSkuCode());
                        //jobLineSku.setPlanedQuantity(jobTaskDetail.getAmount().intValue());
                        jobLineSku.setPlanedQuantity(jobTaskDetail.getRealAmount());
                        if(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(vo.getSkuStatus())){
                        	jobLineSku.setQuantity(0);
                        	jobLineSku.setDamagedQuantity(jobTaskDetail.getRealAmount());
                        }else{
                        	jobLineSku.setQuantity(jobTaskDetail.getRealAmount());
                        	jobLineSku.setDamagedQuantity(0);
                        }
                        //jobLineSku.setQuantity(jobTaskDetail.getRealAmount());
                        commandSkus.add(jobLineSku);
                    }
                    if(commandSkus!=null && !commandSkus.isEmpty()){
                        WhCommand whCommandJobLine = new WhCommand();
                        whCommandJobLine.setWarehouseCode(warehouseCode);
                        whCommandJobLine.setPhysicalWarehouseCode(physicalWarehouseCode);
                        whCommandJobLine.setReferenceCode(jobTaskDetail.getCode());
                        whCommandJobLine.setInOutType(WhCommand.TYPE_PRODUCE_OUT);
                        whCommandJobLine.setPlanedDeliveryDate(DateUtil.getNow());
                        whCommandJobLine.setWhCommandSkuList(commandSkus);
                        whCommandJobLine.setOperatorId(vo.getCreateUserId());
                        commands.add(whCommandJobLine);
                    }
                    Map<String,Object> prdcJobLineInfo = getPrdcJobLineInfoBySkuCode(prdcJobLineInfos,jobTaskDetail.getSkuCode());
                    String jobLineCode = prdcJobLineInfo.get("code").toString();
                    WhInvOccupy whInvOccupy = getwhInvOccupy(whInvOccupyList,jobLineCode);

                    if(whInvOccupy == null){

                        //throw new WarehouseException(WarehouseExceptionErrorCode.UPDATE_OCCUPY_FAILED,jobTaskDetail.getSkuCode()+"占用库存不足!");
                    }else if(whInvOccupy!=null){
                        //占用未释放完毕
                        WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                        whReleaseOccupationVO.setOccupyType(WhInvOccupy.TYPE_PRODUCE_OUT);
                        whReleaseOccupationVO.setReferenceCode(jobLineCode);
                        releaseOccupations.add(whReleaseOccupationVO);
                    }
                    //新占用数量改变
                    if(!jobFinished && whInvOccupy!=null ){

                        if(whInvOccupy.getQuantity()>jobTaskDetail.getRealAmount()){
                            whInvOccupy.setQuantity(whInvOccupy.getQuantity()-jobTaskDetail.getRealAmount());
                            afterWhInvOccupyList.add(whInvOccupy);
                        }else{
                        	whInvOccupy.setQuantity(0);
                            afterWhInvOccupyList.add(whInvOccupy);
                        }
                    }

                }
                
            }

        }
        if(commands!=null && !commands.isEmpty()){
            //释放占用并更新占用
            whCommandService.createCommandsAfterReleaseThenFinishThenOccupy(commands,releaseOccupations,afterWhInvOccupyList);
        }

    }
    /**
     * 填充占用sku，barcode 的过期日期并排序
     *
     * */
    private void fullExpirationDateThenSort(List<WhWmsOccupyVO> occupyList){
        if(occupyList!=null && !occupyList.isEmpty()){
            for(WhWmsOccupyVO occupy : occupyList){
                WhWmsSkuBarcodeVO cond = new WhWmsSkuBarcodeVO();
                cond.setSkuCode(occupy.getSkuCode());
                cond.setBarCode(occupy.getBarCode());
                cond.setRefCode(occupy.getReceiptsNo());
                List<WhWmsSkuBarcodeVO> list = whWmsSkuBarcodeService.getWmsSkuBarcodeByCond(cond);
                if(list!=null && !list.isEmpty()){
                    occupy.setExpirationDate(list.get(0).getExpirationDate());
                }else{
                    occupy.setExpirationDate(null);
                }
            }
            sortOccupyListByExpirationDate(occupyList);
        }

    }

    /**
     *按过期日期排序占用
     * */
    private void sortOccupyListByExpirationDate(List<WhWmsOccupyVO> occupyList){
        Collections.sort(occupyList, new Comparator<WhWmsOccupyVO>(){
            @Override
            public int compare(WhWmsOccupyVO o1, WhWmsOccupyVO o2) {
                int skuCodeCmp = o1.getSkuCode().compareTo(o2.getSkuCode());
                if(skuCodeCmp==0){
                    int skuStatusCmp = o1.getSkuStatus().compareTo(o2.getSkuStatus());
                    if(skuStatusCmp==0){
                        Date d1 = o1.getExpirationDate();
                        Date d2 = o2.getExpirationDate();
                        if(d1==null && d2==null){
                            return 0;
                        }
                        if(d1==null && d2!=null){
                            return 1;
                        }
                        if(d1!=null && d2==null){
                            return -1;
                        }
                        if(d1!=null && d2!=null){
                            return d1.compareTo(d2);
                        }
                    }
                    return skuStatusCmp;
                }
                return skuCodeCmp;
            }

        });
    }



    /**
     * 根据出入库类型过滤的库存
     * */
    private List<WhWmsSkuStockRecordVO> filterSkuStocks(List<WhWmsSkuStockRecordVO> skuStocks,Integer inOutType){
        List<WhWmsSkuStockRecordVO> rtList = new ArrayList<WhWmsSkuStockRecordVO>();
        if(skuStocks!=null&&inOutType!=null){
            for(WhWmsSkuStockRecordVO vo : skuStocks){
                if(vo.getInOutType().equals(inOutType)
                        &&vo.getQuantity()!=0){
                    rtList.add(vo);
                }
            }
        }
        return rtList;
    }

    private List<WhCommandSku> buildSkuCommandList(List<WhWmsSkuStockRecordVO> stocks,Map<String,String> skuAndBarcodeMap){
        List<WhCommandSku> commandSkus = new ArrayList<>();
        if(stocks!=null){
            for(WhWmsSkuStockRecordVO stock : stocks){
                buildWhCommandSku(commandSkus,stock);
                skuAndBarcodeMap.put(stock.getSkuCode(),stock.getBarCode());
            }
        }
        return commandSkus;
    }
    /**
     * 组织commansSku
     * */
    private void buildWhCommandSku(List<WhCommandSku> commandSkus,WhWmsSkuStockRecordVO stock){
        WhCommandSku cmdSku = null;
        for(WhCommandSku commandSku : commandSkus){
            if(stock.getSkuCode().equals(commandSku.getSkuCode())){
                cmdSku = commandSku;
                break;
            }
        }
        if(cmdSku==null){
            cmdSku = new WhCommandSku();
            cmdSku.setSkuCode(stock.getSkuCode());
            cmdSku.setPlanedQuantity(0);
            cmdSku.setQuantity(0);
            cmdSku.setDamagedQuantity(0);
            cmdSku.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
            cmdSku.setReceiptNo(stock.getReceiptNo());
            commandSkus.add(cmdSku);
        }
        if(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(stock.getSkuStatus())){
            cmdSku.setDamagedQuantity(cmdSku.getDamagedQuantity()+stock.getQuantity());
        }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(stock.getSkuStatus())){
            cmdSku.setQuantity(cmdSku.getQuantity()+stock.getQuantity());
        }
        cmdSku.setPlanedQuantity(cmdSku.getQuantity()+cmdSku.getDamagedQuantity());
    }






    /**
     * 占用前检查可用库存
     * @param taskDetail
     * @return
     * 按照,加工区=>保管区=>拣货区优先级
     */
    public List<WhWmsSkuStockVO> checkStockBeforeOccupy(WhWmsPrdcJobTaskVO task, WhWmsPrdcJobTaskDetailVO taskDetail,Map<String,Integer> taskDetailDifferenceMap,List<WhWmsMoveSkuVO> moveSkus){
        int taskDetailNeedAmount = 0;
        List<WhWmsSkuStockVO> skuStockList = new ArrayList<>();
        WhWmsSkuStockVO skuStockVOCond = new WhWmsSkuStockVO();
        skuStockVOCond.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
        skuStockVOCond.setSkuStatus(task.getSkuStatus());
        if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE){
            taskDetailNeedAmount = taskDetail.getAmount().intValue();
            skuStockVOCond.setSkuCode(taskDetail.getSkuCode());
            skuStockVOCond.setSkuCodeLike(taskDetail.getSkuCode());
        }else if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT){
            taskDetailNeedAmount = task.getAmount().intValue();
            skuStockVOCond.setSkuCode(task.getSkuCode());
            skuStockVOCond.setSkuCodeLike(task.getSkuCode());
        }
        int difference = taskDetailNeedAmount; //总差额数量

        //查询加工区+普通区保管库位+普通区拣货库位总可用库存
        List<String> houseTypeList = new ArrayList<>();
        houseTypeList.add(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        houseTypeList.addAll(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));
        skuStockVOCond.setHouseTypes(houseTypeList);
        List<WhWmsSkuStockVO> totalAreaStocks = whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);
        //总库存不足,则子任务启动失败
        if(CollectionUtils.isEmpty(totalAreaStocks)){
            if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) taskDetailDifferenceMap.put(taskDetail.getSkuCode(),difference);
            if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) taskDetailDifferenceMap.put(task.getSkuCode(),difference);
            return Collections.EMPTY_LIST;
        }
        else{
            Integer totalAvailStock = 0;
            for(WhWmsSkuStockVO skuStock : totalAreaStocks){
                totalAvailStock += skuStock.getAvailableAmount();
                if(totalAvailStock.compareTo(taskDetailNeedAmount) >= 0)
                    break;
            }
            if (totalAvailStock.compareTo(taskDetailNeedAmount) < 0) {
                difference = taskDetailNeedAmount - totalAvailStock;
                if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_ASSEMBLE) taskDetailDifferenceMap.put(taskDetail.getSkuCode(),difference);
                if(task.getJobType() == WhWmsPrdcJobTaskVO.JOB_TYPE_SPLIT) taskDetailDifferenceMap.put(task.getSkuCode(),difference);
                return Collections.EMPTY_LIST;
            }
        }
        //依次查询库存
        for(final String houseType : houseTypeList){
            int pagenum =100;
            int currpage = 1;
            skuStockVOCond.setPagenum(pagenum);
            skuStockVOCond.setCurrpage(currpage);
            if (difference == 0) break;
            skuStockVOCond.setHouseTypes(new ArrayList<String>(){{
                add(houseType);
            }});
            skuStockVOCond.setHouseType(houseType);
            List<WhWmsSkuStockVO> areaStocks = whWmsSkuStockService.getWmsSkuStocksByCond(skuStockVOCond);

            if (CollectionUtils.isEmpty(areaStocks)) continue;
            if (areaStocks.size()!=1)  throw new WarehouseException("","error,the result isnot unique!");
            WhWmsSkuStockVO areaStock = areaStocks.get(0);
            if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && areaStock.getAvailableAmount()<=0) continue;
            //分页遍历
            do{
                skuStockVOCond.setCurrpage(currpage);
                areaStocks =  whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                if(CollectionUtils.isEmpty(areaStocks)) break;
                if(areaStock.getAvailableAmount()<=0) continue;
                if(areaStock.getAvailableAmount().compareTo(difference) < 0 && difference >0 && areaStock.getAvailableAmount()>0){
                    areaStocks =  whWmsSkuStockService.getWmsSkuStocksByShelvesCond(skuStockVOCond);
                    if(CollectionUtils.isEmpty(areaStocks)) break;
                    for(WhWmsSkuStockVO skuStock :areaStocks){
                        WhWmsHouseShelvesVO houseShelves = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        if(!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) &&
                             !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) &&
                                 !houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)) continue;
                        Integer areaAvailableAmount = skuStock.getAvailableAmount();
                        if (areaAvailableAmount<=0) continue;
                        skuStock.setOccupiedAccount(areaAvailableAmount);
                        skuStockList.add(skuStock);
                        difference -= areaAvailableAmount;
                        if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && skuStock.getOccupiedAccount()!=0){
                            WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                            if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                            if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                ||WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {

                                moveSkus.add(buildMoveSku(houseType,task,skuStock));

                            }
                        }
                    }
//                    difference -= areaStock.getAvailableAmount();
                }
                else if(areaStock.getAvailableAmount().compareTo(difference) >= 0 && difference >0){
                    //按照可用数量排序
                    Collections.sort(areaStocks,new Comparator<WhWmsSkuStockVO>(){
                        @Override
                        public int compare(WhWmsSkuStockVO vo1, WhWmsSkuStockVO vo2) {
                            return vo1.getAvailableAmount().compareTo(vo2.getAvailableAmount());
                        }
                    });
                    for(WhWmsSkuStockVO skuStock :areaStocks){
                        WhWmsHouseShelvesVO houseShelves = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                        if(!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelves.getShelvesType()) &&
                                !WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelves.getShelvesType()) &&
                                !houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)) continue;
                        Integer areaAvailableAmount = skuStock.getAvailableAmount();
                        if(areaAvailableAmount.compareTo(difference) >= 0){
                            skuStock.setOccupiedAccount(difference);
                            skuStockList.add(skuStock);
                            difference = 0;
                            if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && skuStock.getOccupiedAccount()!=0){
                                WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                                if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                                if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                    || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {

                                    moveSkus.add(buildMoveSku(houseType,task,skuStock));

                                }
                            }
                            return skuStockList;
                        }else{
                            if(areaAvailableAmount<=0) continue;
                            skuStock.setOccupiedAccount(areaAvailableAmount);
                            skuStockList.add(skuStock);
                            difference -= areaAvailableAmount;
                            if(!houseType.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING) && skuStock.getOccupiedAccount()!=0){
                                WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(skuStock.getShelvesCode());
                                if(EmptyUtil.isEmpty(houseShelvesVO)) continue;
                                if(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(houseShelvesVO.getShelvesType())
                                        || WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING.equals(houseShelvesVO.getShelvesType())) {

                                    moveSkus.add(buildMoveSku(houseType,task,skuStock));

                                }
                            }
                        }
                    }
                }
                else{
                    throw new WarehouseException("","error,the difference is abnormal");
                }
                currpage += 1;

            }while(areaStocks.size() == pagenum);
        }
        if(difference>0) taskDetailDifferenceMap.put(taskDetail.getSkuCode(),difference);
        return Collections.EMPTY_LIST;
    }


    /**
     * 统计区域数据
     * */
    private Integer getAreaAvailableStockAmount(List<WhWmsSkuStockVO> areaStocks,String houseType){
        int total = 0;
        if(areaStocks!=null){
            for(WhWmsSkuStockVO stock : areaStocks){
                if(houseType!=null && houseType.equals(stock.getHouseType())){
                    total += stock.getAvailableAmount();
                }
            }
        }
        return total;
    }



    public  String createNewCode(String head){
        String taskCode = head + System.currentTimeMillis();
        if(EmptyUtil.isNotEmpty(getPrdcJobTaskByTaskCode(taskCode))) createNewCode(head);
        return taskCode;
    }



    public boolean sendOutOfStockEmil(int amount,String physicalWasrehouseCode,String PrdcJobCode,Map<String,Integer> taskDetailDifferenceMap){
        try{
            EmailVO emailVO = new EmailVO();
            emailVO.setToAddressList(Arrays.asList(PegasusUtilFacade.getInstance()
                    .findConfigByKey("wms-prdc-sendOutOfStockEmail_"+physicalWasrehouseCode).getConfigValue().split(",")));
            if (CollectionUtils.isEmpty(emailVO.getToAddressList())){
                return false;
            }
            emailVO.setSubject("[ERROR]WMS-Task of ProductionAndProcessing Starting failed ["+PrdcJobCode+"]");
            StringBuffer contentBuffer = new StringBuffer("生产加工任务启动失败,原因:库存不足");
            contentBuffer.append("</br>");
            contentBuffer.append("生产订单号:"+PrdcJobCode+",仓库:"+physicalWasrehouseCode);
            contentBuffer.append("</br>");
            contentBuffer.append("本次启动任务数:"+amount);
            contentBuffer.append("</br>");
            for(Map.Entry<String,Integer> entry : taskDetailDifferenceMap.entrySet()){
                contentBuffer.append("SKU:"+entry.getKey()+",差额:"+entry.getValue());
                contentBuffer.append("</br>");
            }
            emailVO.setContent(contentBuffer.toString());
            boolean tf = EmailUtil.getInstance().send(emailVO);
            return tf;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }


    //构造移库任务
    public WhWmsMoveSkuVO buildMoveSku(String houseType,WhWmsPrdcJobTaskVO task,WhWmsSkuStockVO skuStock){
        WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
        moveSkuVO.setPhysicalWarehouseCode(task.getPhysicalWarehouseCode());
        moveSkuVO.setCreateTime(new Date());
        moveSkuVO.setOriginalHouseType(houseType);
        moveSkuVO.setTargetHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        moveSkuVO.setSkuStatus(task.getSkuStatus());

        moveSkuVO.setAmount(skuStock.getOccupiedAccount());
        moveSkuVO.setSkuCode(skuStock.getSkuCode());
        moveSkuVO.setBarCode(skuStock.getBarCode());
        moveSkuVO.setOriginalShelvesCode(skuStock.getShelvesCode());

        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(skuStock.getPhysicalWarehouseCode());
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING);
        List<WhWmsHouseShelvesVO> targetShelves = whWmsHouseShelves.getHouseShelvesByCond(cond);
        if(CollectionUtils.isEmpty(targetShelves))  throw new WarehouseException("","Illegal Param!");
        moveSkuVO.setTargetShelvesCode(targetShelves.get(0).getCode());
        return moveSkuVO;
    }

    //构造库存变更
    private WhWmsSkuStockRecordVO buildSkuStock(
            Integer amount,
            String physicalWarehouseCode,
            String houseType,
            String skuCode,
            String barcode,
            String shelvesCode,
            Integer skuStatus,
            Integer inOutType,
            String receiptNo,
            Long userId){
        WhWmsSkuStockRecordVO skuStock = new WhWmsSkuStockRecordVO();
        skuStock.setQuantity(amount);
        skuStock.setPhysicalWarehouseCode(physicalWarehouseCode);
        skuStock.setHouseType(houseType);
        skuStock.setBarCode(barcode);
        skuStock.setShelvesCode(shelvesCode);
        skuStock.setSkuCode(skuCode);
        skuStock.setSkuStatus(skuStatus);
        skuStock.setCreateUserId(userId);
        skuStock.setInOutType(inOutType);
        skuStock.setReceiptNo(receiptNo);
        return skuStock;
    }

//    private String getBarCode(String skuCode,Date prodDate){
//        Date expirationDate = null;
//        int batchNo = 1;
//        if(prodDate != null){
//            Integer shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(skuCode);
//            if(shelfLife != null && shelfLife > 0){
//                expirationDate = DateUtil.addDay(prodDate,shelfLife);
//            }
//        }
//        if(expirationDate != null){
//            WhWmsSkuBarcode skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,DateUtil.format(expirationDate, "yyyy-MM-dd"));
//            if(skuBarcodeVo == null){
//                skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,null);
//                if(skuBarcodeVo != null){
//                    batchNo = skuBarcodeVo.getBatchNo() + 1;
//                }
//            }else{
//                return skuBarcodeVo.getBarCode();
//            }
//        }else{
//            WhWmsSkuBarcode skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,null);
//            if(skuBarcodeVo != null){
//                return skuBarcodeVo.getBarCode();
//            }
//        }
//
//        return createBarCode(skuCode,batchNo,expirationDate);
//    }
//
//    private String createBarCode(String skuCode,int batchNo,Date expirationDate){
//        WhWmsSkuBarcodeVO bcVO = new WhWmsSkuBarcodeVO();
//        bcVO.setSkuCode(skuCode);
//        bcVO.setBatchNo(batchNo);
//        bcVO.setExpirationDate(expirationDate);
//        StringBuilder batch = new StringBuilder();
//        batch.append(batchNo);
//        while(batch.length() < 4){
//            batch.insert(0,"0");
//        }
//        String barcode = skuCode+"_" + batch.toString();
//        bcVO.setBarCode(barcode.toString());
//        whWmsSkuBarcodeService.create(bcVO);
//        return barcode.toString();
//    }

    @Override
    public List<Map<String,Object>> getWmsPrdcJobTaskFinishedInfo(
            List<String> prdcJobCodes) {
        return whWmsPrdcJobTaskMapper.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }

    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskProcessingInfo(
            List<String> prdcJobCodes) {
        return whWmsPrdcJobTaskMapper.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
    }
    
    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedRealAmount(
            List<String> prdcJobCodes) {
        return whWmsPrdcJobTaskMapper.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
    }

}
