package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsPrdcJobTaskDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsPrdcJobTaskDetailExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsPrdcJobTaskDetailService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsPrdcJobTaskDetailVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * Created by devin.li on 16/4/15.
 */
@Service("whWmsPrdcJobTaskDetailService")
public class WhWmsPrdcJobTaskDetailServiceImpl implements WhWmsPrdcJobTaskDetailService {

    @Autowired
    private WhWmsPrdcJobTaskDetailMapper       whWmsPrdcJobTaskDetailMapper;


    @Override
    public WhWmsPrdcJobTaskDetailVO getTaskTetailByCond() {
        return null;
    }

    @Override
    public WhWmsPrdcJobTaskDetail getTaskDetailById(Long id) {
        return whWmsPrdcJobTaskDetailMapper.selectByPrimaryKey(id);
    }

    @Override
    public WhWmsPrdcJobTaskDetail getTaskDetailBycode(String code) {
        WhWmsPrdcJobTaskDetailExample example = new WhWmsPrdcJobTaskDetailExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhWmsPrdcJobTaskDetail> taskDetails = whWmsPrdcJobTaskDetailMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(taskDetails)) return null;
        if(taskDetails.size()>1) throw new WarehouseException("","匹配到多条记录");
        return taskDetails.get(0);
    }

    @Override
    public List<WhWmsPrdcJobTaskDetailVO> getTaskDetailByTaskCode(String taskCode) {
        WhWmsPrdcJobTaskDetailExample example = new WhWmsPrdcJobTaskDetailExample();
        example.createCriteria().andTaskCodeEqualTo(taskCode);
        List<WhWmsPrdcJobTaskDetail> taskDetails = whWmsPrdcJobTaskDetailMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(taskDetails)) return Collections.EMPTY_LIST;
        return BeanUtil.buildListFrom(taskDetails,WhWmsPrdcJobTaskDetailVO.class);
    }

    @Override
    public Boolean newTaskDetail(WhWmsPrdcJobTaskDetailVO taskDetailVO) {
        int insert =  whWmsPrdcJobTaskDetailMapper.insert(taskDetailVO);
        if (insert<=0) throw new WarehouseException("","插入数据失败");
        return true;
    }

    @Override
    public Boolean newTaskDetail(List<WhWmsPrdcJobTaskDetailVO> taskDetailVOs) {
        for (WhWmsPrdcJobTaskDetailVO taskDetail : taskDetailVOs){
            newTaskDetail(taskDetail);
        }
        return true;
    }

    @Override
    public Boolean updateTaskDetail(WhWmsPrdcJobTaskDetailVO taskDetailVO) {
        if(NumberUtil.isNullOrZero(taskDetailVO.getId()))  throw new WarehouseException("","主键");
        int update =  whWmsPrdcJobTaskDetailMapper.updateByPrimaryKey(taskDetailVO);
        if (update<0) throw new WarehouseException("","更新数据失败");
        return true;
    }

	@Override
	public Boolean updateTaskDetailPrimaryKeySelective(
			WhWmsPrdcJobTaskDetailVO taskDetailVO) {
		if(NumberUtil.isNullOrZero(taskDetailVO.getId()))  throw new WarehouseException("","主键");
        int update =  whWmsPrdcJobTaskDetailMapper.updateByPrimaryKeySelective(taskDetailVO);
        if (update<0) throw new WarehouseException("","更新数据失败");
        return true;
	}
}
