package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsBoxNumberMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectTurnoverBoxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsOutStockRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.exception.WmsExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.model.CommEntityOpRcd;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.*;

/**
 * ${DESCRIPTION}
 *
 * @author xwei
 * @create 2017-03-30 20:04
 */
@Service("whWmsOutStockRecordService")
public class WhWmsOutStockRecordServiceImpl implements WhWmsOutStockRecordService{

    private final static Logger log = LoggerFactory.getLogger(WhWmsOutStockRecordServiceImpl.class);

    private PegasusUtilFacade pegasusUtilFacade = null;

    @Autowired
    private WhWmsOutStockRecordMapper whWmsOutStockRecordMapper;

    @Transactional
    public WhWmsOutStockRecord createWhWmsOutStockRecord(WhWmsOutStockRecord whWmsOutStockRecord){
        whWmsOutStockRecordMapper.insertSelective(whWmsOutStockRecord);
        return whWmsOutStockRecord;
    }

    @Override
    public List<WhWmsOutStockRecord> findWhWmsOutStockRecordsByCond(WhWmsOutStockRecordCond cond) {
        WhWmsOutStockRecordExample whWmsOutStockRecordExample = new WhWmsOutStockRecordExample();
        WhWmsOutStockRecordExample.Criteria criteria = whWmsOutStockRecordExample.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getInOutType())){
            criteria.andInOutTypeEqualTo(cond.getInOutType());
        }
        if (EmptyUtil.isNotEmpty(cond.getConnectId())){
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if (EmptyUtil.isNotEmpty(cond.getCommandCode())){
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getOptType())){
            criteria.andOptTypeEqualTo(cond.getOptType());
        }
        if (EmptyUtil.isNotEmpty(cond.getRecordType())){
            criteria.andRecordTypeEqualTo(cond.getRecordType());
        }
        if (EmptyUtil.isNotEmpty(cond.getShelvesCode())){
            criteria.andShelvesCodeEqualTo(cond.getShelvesCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getDisposeType())){
            criteria.andDisposeTypeEqualTo(cond.getDisposeType());
        }
        if (EmptyUtil.isNotEmpty(cond.getSkuCode())){
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getOperatorId())){
            criteria.andOperatorIdEqualTo(cond.getOperatorId());
        }
        whWmsOutStockRecordExample.setOrderByClause("ID DESC");
        return whWmsOutStockRecordMapper.selectByExample(whWmsOutStockRecordExample);
    }

    @Override
    @Transactional
    public boolean updateWhWmsOutStockRecordsByCond(WhWmsOutStockRecord record) {
        int result = whWmsOutStockRecordMapper.updateByPrimaryKeySelective(record);
        if (result<=0) throw new WarehouseException("","update WhWmsOutStockRecord error!");
        return true;
    }

    @Override
    @Transactional
    public boolean updateWhWmsOutStockRecordsByConds(List<WhWmsOutStockRecord> records) {
        for (WhWmsOutStockRecord record : records){
            updateWhWmsOutStockRecordsByCond(record);
        }
        return true;
    }

    @PostConstruct
    public void init() {
        log.debug("[Service] ScmEntityOperationLogServiceImpl is initialing");
        pegasusUtilFacade = PegasusUtilFacade.getInstance();
        log.debug("[Service] ScmEntityOperationLogServiceImpl initialied");
    }
}
