package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsSkuStockCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsOccupyMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSkuStockMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuStock;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsOccupyService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhInvVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsOccupyVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2016/3/23.
 */
@Service("whWmsOccupyService")
public class WhWmsOccupyServiceImpl implements WhWmsOccupyService {
    @Autowired
    private WhWmsOccupyMapper mapper;
    @Autowired
    private WhWmsSkuStockMapper skuStockMapper;
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Override
    public Boolean update(WhWmsOccupyVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo, WhWmsOccupy.class))!=0;
    }

    @Override
    public WhWmsOccupyVO findById(Long id) {
        WhWmsOccupy occupy = mapper.selectByPrimaryKey(id);
        if(occupy!=null){
            return BeanUtil.buildFrom(occupy,WhWmsOccupyVO.class);
        }
        return null;
    }

    /**
     * SKU库存占用
     *
     * @param vo SKU库存占用
     * @return 库存占用ID
     */
    @Override
    public Long wmsOccupy(WhWmsOccupyVO vo) {
        List<WhWmsOccupyVO> whInvOccupyList = new ArrayList<>();
        whInvOccupyList.add(vo);
        return wmsBatchOccupy(whInvOccupyList).get(0);
    }

    /**
     * 批量SKU库存占用
     *
     * @param voList SKU库存占用列表
     * @return 库存占用ID
     */
    @Override
    public List<Long> wmsBatchOccupy(List<WhWmsOccupyVO> voList) {
        List<Long> result = new ArrayList<>();
        for (WhWmsOccupyVO occupyVO : voList) {
            // 判断库存是否够占用
            if(occupyVO.getAmount()!=null&&occupyVO.getAmount()<0) {//amount传负数时，判断库存是否充足
                WhWmsSkuStockVO vo = new WhWmsSkuStockVO();
                vo.setBarCode(occupyVO.getBarCode());
                vo.setPhysicalWarehouseCode(occupyVO.getPhysicalWarehouseCode());
                vo.setHouseType(occupyVO.getHouseType());
                vo.setShelvesCode(occupyVO.getOriShelvesCode());
                vo.setSkuCode(occupyVO.getSkuCode());
                vo.setSkuStatus(occupyVO.getSkuStatus());
                List<WhWmsSkuStockVO> stockVo = whWmsSkuStockService.findWmsSkuAvailableAccount(vo);
                Integer availableAccount = 0;
                for (WhWmsSkuStockVO sv : stockVo) {
                    availableAccount += sv.getAvailableAccount();
                }
                if (availableAccount<-occupyVO.getAmount()){
                    throw new WarehouseException("WMS Occupy", "占用失败，库存不足（" + availableAccount + "<" + -occupyVO.getAmount() + "）。 条形码 : " + occupyVO.getBarCode()+",["+occupyVO.getOriShelvesCode()+"],["+occupyVO.getSkuStatus()+"]");
                }
            }
            occupyVO.setType(NumberUtil.isNullOrZero(occupyVO.getType()) ? WhWmsOccupyVO.TYPE_MOVE : occupyVO.getType());
            occupyVO.setStatus(WMSConstants.WMS_OCCUPY_STATUS_IN_USE);
            WhWmsOccupy occupy = BeanUtil.buildFrom(occupyVO, WhWmsOccupy.class);
            if(mapper.insert(occupy)<=0){
                throw new WarehouseException("WMS Occupy", "insert失败");
            }
            result.add(occupy.getId());
        }
        return result;
    }

    /**
     * 释放WMS的SKU库存占用
     *
     * @param cond
     */
    @Override
    public boolean releaseWmsOccupy(WhWmsOccupyVO cond) {
        List<WhWmsOccupyVO> occupyList = getWmsOccupyByCond(cond);
        if(CollectionUtils.isEmpty(occupyList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "releaseWmsOccupy error,the occupy is not exist[ReceiptsNo:"+cond.getReceiptsNo()+",OccupyType:"+cond.getType()+"]"+",OccupyStatus:"+cond.getStatus()+"]");
        }
        return mapper.releaseOccupy(cond) !=0;
    }

    @Override
    public boolean releaseWmsOccupyById(WhWmsOccupyVO cond) {
        List<WhWmsOccupyVO> occupyList = getWmsOccupyByCond(cond);
        if(CollectionUtils.isEmpty(occupyList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "releaseWmsOccupy error,the occupy is not exist[ReceiptsNo:"+cond.getReceiptsNo()+",OccupyType:"+cond.getType()+"]"+",OccupyStatus:"+cond.getStatus()+"]");
        }
        List<Long> ids = new ArrayList<>();
        for (WhWmsOccupyVO vo : occupyList){
            ids.add(vo.getId());
        }
        cond.setIds(ids);
        return mapper.releaseOccupy(cond) !=0;
    }

    /**
     * 释放波次占用
     * @param connectId
     * @return
     */
    @Override
    public boolean releaseWmsOccupyByConnectId(Long connectId) {
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(connectId.toString());
        cond.setType(WhWmsOccupyVO.TYPE_CONNECT);
        cond.setStatus(WhWmsOccupyVO.OCCUPIED);
//        List<WhWmsOccupyVO> occupyList = getWmsOccupyByCond(cond);
//        if(CollectionUtils.isEmpty(occupyList)){
//            throw new WarehouseException("","releaseWmsOccupyByConnectId error,the occupy is not exist["+cond.toString()+"]");
//        }
        return mapper.releaseOccupy(cond) !=0;
    }

    @Override
    @Transactional
    public boolean releaseWmsOccupyByConnectId(List<Long> connectIds) {
        if(EmptyUtil.isEmpty(connectIds)){
            return false;
        }
        List<String> receiptsNoList = new ArrayList<>();
        for(Long connectId : connectIds){
            receiptsNoList.add(connectId.toString());
        }
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNoList(receiptsNoList);
        cond.setType(WhWmsOccupyVO.TYPE_CONNECT);
        cond.setStatus(WhWmsOccupyVO.OCCUPIED);
        return mapper.releaseOccupy(cond) !=0;
    }

    /**
     * 释放移库占用
     * @param cond
     * @return
     */
    @Override
    public boolean releaseWmsOccupyByMove(WhWmsOccupyVO cond) {
        List<WhWmsOccupyVO> occupyList = getWmsOccupyByCond(cond);
//        if(CollectionUtils.isEmpty(occupyList)){
//            throw new WarehouseException("","releaseWmsOccupyByMove error,the occupy is not exist["+cond.toString()+"]");
//        }
        if(occupyList.size()>1){
            WhWmsOccupyVO newCond = new WhWmsOccupyVO();
            // 释放一个
            //newCond.setId(occupyList.get(0).getId());
            // 释放当前移库单下所有占用
            List<Long> ids = new ArrayList<>();
            for (WhWmsOccupyVO vo : occupyList){
                ids.add(vo.getId());
            }
            newCond.setIds(ids);
            return mapper.releaseOccupy(newCond) !=0;
        }else{
            cond.setId(null);
            return mapper.releaseOccupy(cond) !=0;
        }
    }

    @Override
    @Transactional
    public boolean releaseWmsOccupyByCond(WhWmsOccupyVO cond) {
        return mapper.releaseOccupy(cond) !=0;
    }

    @Override
    public List<WhWmsOccupyVO> getWmsOccupyByCond(WhWmsOccupyVO cond) {
        List<WhWmsOccupy> list = mapper.getByCond(cond);
        List<WhWmsOccupyVO> voList = BeanUtil.buildListFrom(list,WhWmsOccupyVO.class);
        return voList;
    }
}
