package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsMoveSkuCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsMoveSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsMoveSkuExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsMoveSkuService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsSkuStockService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsMoveSkuVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.util.CollectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.List;

/**
 * Created by devin.li on 2016/3/27.
 */
@Service("whWmsMoveSkuService")
public class WhWmsMoveSkuServiceImpl implements WhWmsMoveSkuService {

    @Autowired
    private WhWmsMoveSkuMapper whWmsMoveSkuMapper;

    @Override
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveCode(String moveCode) {
        List<WhWmsMoveSkuVO> list = whWmsMoveSkuMapper.getByMoveCode(moveCode);
        return list;
    }

    @Override
    @Transactional
    public Boolean newMoveSkuVO(WhWmsMoveSkuVO moveSkuVO) {
        if (EmptyUtil.isEmpty(moveSkuVO.getMoveCode())) throw new WarehouseException("","["+moveSkuVO.getOriginalShelvesCode()+"]["+moveSkuVO.getBarCode()+"]创建移库任务行失败");
        int result = whWmsMoveSkuMapper.insert(moveSkuVO);
        if (result<=0) throw new WarehouseException("","["+moveSkuVO.getOriginalShelvesCode()+"]["+moveSkuVO.getBarCode()+"]添加移库任务行失败");
        return true;
    }

    @Override
    @Transactional
    public boolean batchCreateMoveSku(List<WhWmsMoveSkuVO> moveSkuVOList) {
        if(EmptyUtil.isEmpty(moveSkuVOList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"移库行为空！");
        }
        whWmsMoveSkuMapper.batchInsert(moveSkuVOList);
        return true;
    }

    @Override
    public Pagination<WhWmsMoveSkuVO> getMoveSkuByMoveByCondPage(WhWmsMoveSkuCond cond) {
        Pagination<WhWmsMoveSkuVO> pagination = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        pagination.setRecord(whWmsMoveSkuMapper.getMoveSkuCountByCond(cond));
        pagination.setResultList(whWmsMoveSkuMapper.getMoveSkuByCond(cond));
        return pagination;
    }

    @Override
    public WhWmsMoveSkuVO getMoveSkuById(Long id) {
        WhWmsMoveSkuCond cond = new WhWmsMoveSkuCond();
        cond.setId(id);
        List<WhWmsMoveSkuVO> moveSkuVOs = whWmsMoveSkuMapper.getMoveSkuByCond(cond);
        if (CollectionUtils.isEmpty(moveSkuVOs)) return null;
        return moveSkuVOs.get(0);
    }

    @Override
    public List<WhWmsMoveSkuVO> getMoveSkuByMoveByCond(WhWmsMoveSkuCond cond) {
        return whWmsMoveSkuMapper.getMoveSkuByCond(cond);
    }
}
