package com.thebeastshop.pegasus.service.warehouse.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsManualInOutMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsManualInOut;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsSkuBarcode;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsManualInOutVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuBarcodeVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsSkuStockVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Service("whWmsManualInOutService")
public class WhWmsManualInOutServiceImpl implements WhWmsManualInOutService{

    private final Logger log = LoggerFactory.getLogger(WhWmsManualInOutServiceImpl.class);

	@Autowired
	private WhWmsManualInOutMapper whWmsManualInOutMapper;
	
	@Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;
	
	@Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;
	
	@Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
	
	@Autowired
    private WhWarehouseMapper whWarehouseMapper;
	
	@Autowired
    private WhPhysicalWarehouseMapper whPhysicalWarehouseMapper;
	
	@Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Override
	public int insert(WhWmsManualInOut record) {
		return whWmsManualInOutMapper.insertSelective(record);
	}
	
	@Override
	public int update(WhWmsManualInOut record) {
		return whWmsManualInOutMapper.updateByPrimaryKey(record);
	}

	@Override
	public boolean manualInOutStock(WhWmsManualInOutVO vo) throws Exception {
        if(vo.getQuantity()==null
                ||vo.getShelvesCode()==null
                ||vo.getSkuCode()==null
                ||vo.getSkuStatus()==null
                ||vo.getInOutType()==null
                ||vo.getCreateUserId()==null
                ){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"NullPointerException");
        }
        // 获取分布式锁
        String lockKey = "lock:wms:manualInOutStock:"+vo.getShelvesCode();
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.SECONDS);
            if (!getLock){
                log.info("获取锁失败   false");
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            WhWmsHouseShelvesCond tarcond = new WhWmsHouseShelvesCond();
            tarcond.setCode(vo.getShelvesCode());
            tarcond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
            List<WhWmsHouseShelvesVO> tarShelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(tarcond);
            WhWmsHouseShelvesVO tarVo = null;
            if(tarShelvesList != null && tarShelvesList.size() > 0){
                tarVo = tarShelvesList.get(0);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,vo.getShelvesCode()+"设置的目标库位不存在");
            }

            //检查可用库存是否足够
            if(isOut(vo.getInOutType())){
                WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                cond.setSkuCode(vo.getSkuCode());
                cond.setShelvesCode(vo.getShelvesCode());
                cond.setSkuStatus(vo.getSkuStatus());
                cond.setBarCode(vo.getBarCode());
                List<WhWmsSkuStockVO> shelvesStocks = whWmsSkuStockService.getWmsSkuStocksByShelvesCond(cond);
                if(EmptyUtil.isEmpty(shelvesStocks)){
                    StringBuilder prefix = new StringBuilder();
                    prefix.append(vo.getShelvesCode())
                    .append("[").append(vo.getSkuCode()).append("][")
                    .append(vo.getProductTime()!=null?vo.getProductTime():vo.getBarCode())
                    .append("]");
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,prefix.toString()+"库存不足!");
                }
                int avaAmount = 0;
                for(WhWmsSkuStockVO shelvesStock : shelvesStocks){
                    avaAmount += shelvesStock.getAvailableAmount();
                }
                if(avaAmount+vo.getQuantity()<0){
                    StringBuilder prefix = new StringBuilder();
                    prefix.append(vo.getShelvesCode())
                    .append("[").append(vo.getSkuCode()).append("][")
                    .append(vo.getProductTime()!=null?vo.getProductTime():vo.getBarCode())
                    .append("]");
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,prefix.toString()+"库存不足!");
                }
            }

            //插入出入库记录
            vo.setCode(null);
            vo.setPhysicalWarehouseCode(tarVo.getPhysicalWarehouseCode());
            this.insert(vo);
            //获取barcode
            String barCode = null;
            if(!StringUtils.isEmpty(vo.getBarCode())){
                barCode = vo.getBarCode();
            }else{
                //Date productDate = DateUtil.parse(, "yyyy-MM-dd HH:mm:ss");
                barCode= getBarCode(vo.getSkuCode(),vo.getProductTime());
            }
            String code = "M"+vo.getId();
            vo.setCode(code);
            vo.setHouseType(tarVo.getHouseType());
            vo.setBarCode(barCode);
            this.update(vo);

            try{
                //更新库存
                //根据物理仓库编码、仓库区域、条形码、库位编码、SKU_CODE、SKU状态,出入库类型，相关单据号，更新WMS的库存
                whWmsSkuStockService.updateStockByCond(vo.getQuantity(),
                        tarVo.getPhysicalWarehouseCode(),
                        tarVo.getHouseType(),
                        barCode,
                        vo.getShelvesCode(),
                        vo.getSkuCode(),
                        vo.getSkuStatus(),
                        vo.getInOutType(),
                        code,
                        vo.getCreateUserId(),vo.getMemo(),WhWmsManualInOutVO.NEED_UPDATE_SCM_STOCK.equals(vo.getIsUpdateStock())?1:2);
            }catch(Exception e){
                String msg = e.getMessage();
                StringBuilder prefix = new StringBuilder();
                prefix.append("[").append(vo.getShelvesCode())
                .append("][").append(vo.getSkuCode()).append("][")
                .append(vo.getProductTime()!=null?vo.getProductTime():vo.getBarCode())
                .append("]");
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,prefix.toString()+msg);
            }

            //是否需要更改scm 库存
            if(WhWmsManualInOutVO.NEED_UPDATE_SCM_STOCK.equals(vo.getIsUpdateStock())){
                //rcd增加记录
                WhPhysicalWarehouseExample whPhysicalWarehouseExample = new WhPhysicalWarehouseExample();
                whPhysicalWarehouseExample.createCriteria().andCodeEqualTo(vo.getPhysicalWarehouseCode());
                List<WhPhysicalWarehouse> whPhysicalWarehouseList = whPhysicalWarehouseMapper.selectByExample(whPhysicalWarehouseExample);
                /*WhWarehouseExample whWarehouseExample = new WhWarehouseExample();
                WhWarehouseExample.Criteria criteria = whWarehouseExample.createCriteria();
                criteria.andPhysicalWarehouseIdEqualTo(whPhysicalWarehouseList.get(0).getId());
                String warehouseName = "";
                if(vo.getSkuStatus() == 0){
                    warehouseName = "%残次%";
                }else if(vo.getSkuStatus() == 1){
                    warehouseName = "%良品%";
                }else if(vo.getSkuStatus() == 2){
                    warehouseName = "%样品%";
                }
                criteria.andNameLike(warehouseName);*/
                // List<WhWarehouse> whWarehouseList = whWarehouseMapper.selectByExample(whWarehouseExample);
                List<WhWarehouse> whWarehouseList = whInfoService.findWarehouseByPhysicalCodeAndStatus(whPhysicalWarehouseList.get(0).getCode(),vo.getSkuStatus());
                if(whWarehouseList != null && whWarehouseList.size() > 0){
                    WhCommand whCommand = new WhCommand();
                    whCommand.setReferenceCode(vo.getCode());
                    whCommand.setWarehouseCode(whWarehouseList.get(0).getCode());
                    whCommand.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
                    Integer quantity = vo.getQuantity();
                    if(isOut(vo.getInOutType())){
                        quantity = -quantity;
                    }
                    whCommand.setInOutType(vo.getInOutType());
                    List<WhCommandSku> skuList = new ArrayList<>();
                    WhCommandSku commandSku = new WhCommandSku();
                    commandSku.setSkuCode(vo.getSkuCode());
                    commandSku.setPlanedQuantity(quantity);
                    skuList.add(commandSku);
                    whCommand.setWhCommandSkuList(skuList);
                    whCommandService.createCommandThenFinish(whCommand);
                }else{
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"更新库存失败，找不到对应的逻辑仓库");
                }
            }
            return true;
        }catch (Exception e){
            throw e;
        }finally {
            redisDistributLock.unLock(lockKey);
        }
	}
	
	@Override
	public boolean manualInOutStock(List<WhWmsManualInOutVO> records) throws Exception {
		boolean result = false;
		if(records!=null){
			for(WhWmsManualInOutVO vo :records){
				result = manualInOutStock(vo);
				if(!result){
					break;
				}
			}
		}
		return result;
	}
	
	
	private String getBarCode(String skuCode,String prodDateStr){
        Date expirationDate = null;
        Date prodDate = null;
        int batchNo = 1;
        {
           Integer shelfLife = whWmsSkuBarcodeService.findSkuShelfLifeBySkuCode(skuCode);
            if(shelfLife != null && shelfLife > 0){
            	if(StringUtils.isEmpty(prodDateStr)){
            		throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"请输入生产日期");
            	}
                prodDate = DateUtil.parse(prodDateStr, "yyyy-MM-dd");
                expirationDate = DateUtil.addDay(prodDate,shelfLife);
            }
        }
        if(expirationDate != null){
        	// 现在的逻辑【skucode，过期日期，生产日期 确定唯一批次号】
            WhWmsSkuBarcode skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,DateUtil.format(expirationDate, "yyyy-MM-dd"),prodDateStr);
            // 兼容以前的逻辑【skucode，过期日期 确定唯一批次号】
//            if (skuBarcodeVo == null){
//            	skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,DateUtil.format(expirationDate, "yyyy-MM-dd"),null);
//            }
            if(skuBarcodeVo == null){
                skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,null,null);
                if(skuBarcodeVo != null){
                    batchNo = skuBarcodeVo.getBatchNo() + 1;
                }
            }else{
                return skuBarcodeVo.getBarCode();
            }
        }else{
            WhWmsSkuBarcode skuBarcodeVo = whWmsSkuBarcodeService.findMaxBatchNo(skuCode,null,null);
            if(skuBarcodeVo != null){
                return skuBarcodeVo.getBarCode();
            }
        }

        return createBarCode(skuCode,batchNo,expirationDate,prodDate);
    }
	
	private String createBarCode(String skuCode,int batchNo,Date expirationDate,Date prodDate){
        WhWmsSkuBarcodeVO bcVO = new WhWmsSkuBarcodeVO();
        bcVO.setSkuCode(skuCode);
        bcVO.setBatchNo(batchNo);
        bcVO.setProdDate(prodDate);
        bcVO.setExpirationDate(expirationDate);
        StringBuilder batch = new StringBuilder();
        batch.append(batchNo);
        while(batch.length() < 4){
            batch.insert(0,"0");
        }
        String barcode = skuCode+"_" + batch.toString();
        bcVO.setBarCode(barcode.toString());
        whWmsSkuBarcodeService.create(bcVO);
        return barcode.toString();
    }
	
	/**
	 * 是否是手动出库
	 * */
	private boolean isOut(Integer inOutType) {
        return inOutType / 10 == 2;
    }

	
	

}
