package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanDiffDetailCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanShelvesDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhTakeStockRcd;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanShelvesDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsInventoryPlanShelvesExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryPlanDiffService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsInventoryService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsTaskAssignService;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2018/6/1.
 */
@Service("whWmsInventoryService")
public class WhWmsInventoryServiceImpl implements WhWmsInventoryService {

    @Autowired
    private WhWmsInventoryPlanMapper whWmsInventoryPlanMapper;

    @Autowired
    private WhWmsInventoryPlanShelvesMapper whWmsInventoryPlanShelvesMapper;

    @Autowired
    private WhWmsInventoryPlanShelvesDetailMapper whWmsInventoryPlanShelvesDetailMapper;

    @Autowired
    private WhWmsInventoryPlanCheckRcdMapper whWmsInventoryPlanCheckRcdMapper;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;

    @Autowired
    private WhWmsInventoryPlanDiffService whWmsInventoryPlanDiffService;


    @Override
    public List<WhWmsInventoryPlanShelvesVO> findCanInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesDetailCond cond) {
        List<WhWmsInventoryPlanShelvesVO> list = new ArrayList<>();
        if(WhWmsInventoryPlanVO.TYPE_DAYTODAY_INVENTORY.equals(cond.getInventoryType())){
            //日常盘点
            List<WhWmsInventoryPlanShelvesVO> dayToDayList = findInventoryShelvesDetailForDaytoDay(cond);
            if(EmptyUtil.isNotEmpty(dayToDayList)){
                list.addAll(dayToDayList);
            }
        }else if (WhWmsInventoryPlanVO.TYPE_REGULAR_INVENTORY.equals(cond.getInventoryType())){
            //定期盘点
            List<WhWmsInventoryPlanShelvesVO> regularList = whWmsInventoryPlanMapper.findInventoryShelvesForRegular(cond);
            if(EmptyUtil.isNotEmpty(regularList)){
                list.addAll(regularList);
            }
        }
        findNotFinishedInventoryPlanShelvesCode(list,cond.getInventoryPlanId());
        return list;
    }

    private List<WhWmsInventoryPlanShelvesVO> findInventoryShelvesDetailForDaytoDay(WhWmsInventoryPlanShelvesDetailCond cond){
        List<WhWmsInventoryPlanShelvesVO> list = new ArrayList<>();
        List<WhWmsInventoryPlanShelvesDetailVO> planShelvesDetailList = whWmsInventoryPlanMapper
                .findInventoryShelvesDetailForDaytoDay(cond);
        if(EmptyUtil.isNotEmpty(planShelvesDetailList)){
            //按库位聚合
            Map<String,List<WhWmsInventoryPlanShelvesDetailVO>> shelvesMap = new HashMap<>();
            for(WhWmsInventoryPlanShelvesDetailVO detail : planShelvesDetailList){
                List<WhWmsInventoryPlanShelvesDetailVO> tmpList = shelvesMap.get(detail.getShelvesCode());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    shelvesMap.put(detail.getShelvesCode(),tmpList);
                }
                tmpList.add(detail);
            }
            for(Map.Entry<String,List<WhWmsInventoryPlanShelvesDetailVO>> entry : shelvesMap.entrySet()){
                WhWmsInventoryPlanShelvesVO planShelves = new WhWmsInventoryPlanShelvesVO();
                planShelves.setShelvesCode(entry.getKey());
                planShelves.setInventoryShelvesDetailList(entry.getValue());
                list.add(planShelves);
            }
        }
        return list;
    }

    private void findNotFinishedInventoryPlanShelvesCode(List<WhWmsInventoryPlanShelvesVO> list,Long courrentPlanId){
        //移除存在 未完成盘点任务的库位
        if(EmptyUtil.isEmpty(list)){
            return;
        }
        Set<String> shelvesCodes = new HashSet<>();
        for(WhWmsInventoryPlanShelvesVO planShelves : list){
            shelvesCodes.add(planShelves.getShelvesCode());
        }
        Set<String> notFinishedShelvesCodes = findNotFinishedInventoryPlanShelvesCode(null
                ,Arrays.asList(shelvesCodes.toArray(new String[shelvesCodes.size()])),courrentPlanId);
        if(!notFinishedShelvesCodes.isEmpty()){
            Iterator<WhWmsInventoryPlanShelvesVO> it = list.iterator();
            while (it.hasNext()){
                //移除存在 未完成盘点任务的库位
                WhWmsInventoryPlanShelvesVO planShelves = it.next();
                if(notFinishedShelvesCodes.contains(planShelves.getShelvesCode().toUpperCase())){
                    it.remove();
                }
            }
        }
    }

    @Override
    public WhWmsInventoryPlanVO findInventoryPlan(Long id,boolean cascade) {
        WhWmsInventoryPlanVO plan = whWmsInventoryPlanMapper.findInventoryPlanById(id);
        if(NullUtil.isNotNull(plan) && cascade){
            List<WhWmsInventoryPlanShelvesVO> planShelvesList = whWmsInventoryPlanShelvesMapper
                    .findInventoryPlanShelvesByPlanId(plan.getId());
            fullInventoryPlanShelves(planShelvesList);
            plan.setInventroyShelvesList(planShelvesList);
        }
        return plan;
    }

    private void fullInventoryPlanShelves(List<WhWmsInventoryPlanShelvesVO> planShelvesList){
        if(EmptyUtil.isEmpty(planShelvesList)){
            return;
        }
        List<Long> planShelvesIdList = new ArrayList<>();
        for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
            planShelvesIdList.add(planShelves.getId());
        }
        List<WhWmsInventoryPlanShelvesDetailVO> planShelvesDetailList = whWmsInventoryPlanShelvesDetailMapper
                .findInventoryPlanShelvesDetailByPlanShelvesId(planShelvesIdList);
        if(EmptyUtil.isNotEmpty(planShelvesDetailList)){
            Map<Long,List<WhWmsInventoryPlanShelvesDetailVO>> map = new HashMap<>();
            for(WhWmsInventoryPlanShelvesDetailVO shelvesDetail : planShelvesDetailList){
                List<WhWmsInventoryPlanShelvesDetailVO> tmpList = map
                        .get(shelvesDetail.getInventoryPlanShelvesId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(shelvesDetail.getInventoryPlanShelvesId(),tmpList);
                }
                tmpList.add(shelvesDetail);
            }
            for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
                List<WhWmsInventoryPlanShelvesDetailVO> detailList = map.get(planShelves.getId());
                planShelves.setInventoryShelvesDetailList(detailList);
            }
        }
    }

    @Override
    public List<WhWmsInventoryPlanVO> findInventoryPlan(WhWmsInventoryPlanCond cond) {
        return whWmsInventoryPlanMapper.findInventoryPlan(cond);
    }

    @Override
    public Pagination<WhWmsInventoryPlanVO> findInventoryPlanPage(WhWmsInventoryPlanCond cond) {
        Pagination<WhWmsInventoryPlanVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int total = whWmsInventoryPlanMapper.countInventoryPlan(cond);
        page.setRecord(total);
        if(!NumberUtil.isNullOrZero(total)){
            List<WhWmsInventoryPlanVO> planList = findInventoryPlan(cond);
            page.setResultList(planList);
        }
        return page;
    }

    @Override
    @Transactional
    public boolean saveInventoryPlan(WhWmsInventoryPlanVO plan) {
        reBuildInventoryPlan(plan,true);
        if(NullUtil.isNull(plan.getId())){
            return createInventoryPlan(plan);
        }
        return updateInventoryPlan(plan);
    }

    private void reBuildInventoryPlan(WhWmsInventoryPlanVO plan,boolean needFilter){
        List<WhWmsInventoryPlanShelvesVO> inventroyShelvesList = plan.getInventroyShelvesList();
        if(EmptyUtil.isEmpty(inventroyShelvesList)){
            return;
        }
        List<String> shelvesCodes = new ArrayList<>();
        for(WhWmsInventoryPlanShelvesVO planShelves : inventroyShelvesList){
            planShelves.setShelvesCode(planShelves.getShelvesCode().toUpperCase());
            shelvesCodes.add(planShelves.getShelvesCode());
        }
        Set<String> notFinishedShelvesCodes = null;
        if(needFilter){
            notFinishedShelvesCodes = findNotFinishedInventoryPlanShelvesCode(plan.getPhysicalWarehouseCode()
                    ,shelvesCodes,plan.getId());
        }
        Map<String,WhWmsHouseShelves> shelvesMap = whWmsHouseShelvesService
                .getHouseShelvesMapByCode(shelvesCodes);
        Iterator<WhWmsInventoryPlanShelvesVO> it = inventroyShelvesList.iterator();
        while (it.hasNext()) {
            WhWmsInventoryPlanShelvesVO planShelves = it.next();
            if(needFilter
                    && NullUtil.isNotNull(notFinishedShelvesCodes)
                    && notFinishedShelvesCodes.contains(planShelves.getShelvesCode())){
                //移除存在 未完成盘点任务的库位
                it.remove();
                continue;
            }
            WhWmsHouseShelves shelves = shelvesMap.get(planShelves.getShelvesCode());
            if(NullUtil.isNull(shelves)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s]库位不存在!",planShelves.getShelvesCode()));
            }
            planShelves.setShelvesHouseType(shelves.getHouseType());
            planShelves.setPhysicalWarehouseCode(shelves.getPhysicalWarehouseCode());
            List<WhWmsInventoryPlanShelvesDetailVO> inventoryShelvesDetailList = planShelves
                    .getInventoryShelvesDetailList();
            if(EmptyUtil.isNotEmpty(inventoryShelvesDetailList)){
                for(WhWmsInventoryPlanShelvesDetailVO planShelvesDetail : inventoryShelvesDetailList){
                    planShelvesDetail.setShelvesHouseType(shelves.getHouseType());
                    planShelvesDetail.setShelvesCode(shelves.getCode());
                    planShelvesDetail.setSkuCode(planShelvesDetail.getSkuCode().toUpperCase());
                    planShelvesDetail.setBarCode(planShelvesDetail.getBarCode().toUpperCase());
                }
            }
        }

        if(EmptyUtil.isEmpty(inventroyShelvesList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"任务行为空！");
        }

    }

    private Set<String> findNotFinishedInventoryPlanShelvesCode(String physicalWarehouseCode
            ,List<String> shelvesCodes,Long planId){
        Set<String> notFinishedShelvesCodes = findNotFinishedInventoryPlanShelvesCode(physicalWarehouseCode,shelvesCodes);
        //自己库位仍然可以添加
        if(NullUtil.isNotNull(planId)){
            WhWmsInventoryPlanShelvesCond planShelvesCond = new WhWmsInventoryPlanShelvesCond();
            planShelvesCond.setInventoryPlanId(planId);
            List<WhWmsInventoryPlanShelvesVO> planShelvesList = findInventoryPlanShelvesByCond(planShelvesCond);
            if(EmptyUtil.isNotEmpty(planShelvesList)){
                for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
                    notFinishedShelvesCodes.remove(planShelves.getShelvesCode());
                }
            }
        }
        return notFinishedShelvesCodes;
    }

    private Set<String> findNotFinishedInventoryPlanShelvesCode(String physicalWarehouseCode,List<String> shelvesCodes){
        //未完成盘点库位任务
        WhWmsInventoryPlanShelvesCond planShelvesCond = new WhWmsInventoryPlanShelvesCond();
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PENDING);
        statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING);
        statusList.add(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING);
        planShelvesCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        planShelvesCond.setStatusList(statusList);
        planShelvesCond.setShelvesCodes(shelvesCodes);
        List<WhWmsInventoryPlanShelvesVO> shelveList = findInventoryPlanShelvesByCond(planShelvesCond);
        Set<String> notFinishedShelvesCodes = new HashSet<>();
        if(EmptyUtil.isNotEmpty(shelveList)){
            for(WhWmsInventoryPlanShelvesVO planShelves : shelveList){
                notFinishedShelvesCodes.add(planShelves.getShelvesCode());
            }
        }
        //未处理库位差异
        List<Integer> diffStatusList = new ArrayList<>();
        diffStatusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
        diffStatusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
        diffStatusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_REFUSE);
        WhWmsInventoryPlanDiffDetailCond diffDetailCond = new WhWmsInventoryPlanDiffDetailCond();
        diffDetailCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        diffDetailCond.setShelvesCodeList(shelvesCodes);
        diffDetailCond.setStatusList(diffStatusList);
        List<WhWmsInventoryPlanDiffDetailVO> diffList = whWmsInventoryPlanDiffService
                .findInventoryPlanDiffDetail(diffDetailCond);
        if(EmptyUtil.isNotEmpty(diffList)){
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : diffList){
                notFinishedShelvesCodes.add(diffDetail.getShelvesCode());
            }
        }
        return notFinishedShelvesCodes;
    }

    @Override
    @Transactional
    public boolean cancelInventoryPlan(Long id) {
        WhWmsInventoryPlanVO plan = findInventoryPlan(id,true);
        if(NullUtil.isNull(plan)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("[%s]盘点任务不存在！",id));
        }
        if(!WhWmsInventoryPlanVO.STATUS_PENDING.equals(plan.getStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("盘点任务状态[%s]！",plan.getStatusStr()));
        }
        plan.setStatus(WhWmsInventoryPlanVO.STATUS_CANCELED);
        whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = plan.getInventroyShelvesList();
        if(EmptyUtil.isNotEmpty(planShelvesList)){
            for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
                planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_CANCELED);
                whWmsInventoryPlanShelvesMapper.updateByPrimaryKey(planShelves);
            }
        }
        return true;
    }

    private boolean createInventoryPlan(WhWmsInventoryPlanVO plan){
        plan.setCreateTime(DateUtil.getNow());
        plan.setStatus(WhWmsInventoryPlanVO.STATUS_PENDING);
        whWmsInventoryPlanMapper.insert(plan);
        plan.setCode(buildCode(plan.getId()));
        whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        createInventoryPlanShelves(plan);
        return true;
    }

    private boolean createInventoryPlanShelves(WhWmsInventoryPlanVO plan){
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = plan.getInventroyShelvesList();
        if(EmptyUtil.isEmpty(planShelvesList)){
            return true;
        }
        for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
            planShelves.setInventoryPlanId(plan.getId());
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_PENDING);
            whWmsInventoryPlanShelvesMapper.insert(planShelves);
            List<WhWmsInventoryPlanShelvesDetailVO> shelvesDetailList = planShelves
                    .getInventoryShelvesDetailList();
            if(EmptyUtil.isNotEmpty(shelvesDetailList)){
                for(WhWmsInventoryPlanShelvesDetailVO detail : shelvesDetailList){
                    detail.setInventoryPlanShelvesId(planShelves.getId());
                    whWmsInventoryPlanShelvesDetailMapper.insert(detail);
                }
            }
        }
        return true;
    }

    private boolean deleteInventoryPlanShelves(Long planId){
        WhWmsInventoryPlanVO plan = findInventoryPlan(planId,true);
        if(NullUtil.isNull(plan)
                || EmptyUtil.isEmpty(plan.getInventroyShelvesList())){
            return true;
        }
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = plan.getInventroyShelvesList();
        List<Long> planShelvesIdList = new ArrayList<>();
        for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
            planShelvesIdList.add(planShelves.getId());
        }
        //删除明细
        WhWmsInventoryPlanShelvesDetailExample detailExample = new WhWmsInventoryPlanShelvesDetailExample();
        detailExample.createCriteria().andInventoryPlanShelvesIdIn(planShelvesIdList);
        whWmsInventoryPlanShelvesDetailMapper.deleteByExample(detailExample);
        //库位数据
        WhWmsInventoryPlanShelvesExample shelvesExample = new WhWmsInventoryPlanShelvesExample();
        shelvesExample.createCriteria().andIdIn(planShelvesIdList);
        whWmsInventoryPlanShelvesMapper.deleteByExample(shelvesExample);
        return true;
    }

    private boolean updateInventoryPlan(WhWmsInventoryPlanVO plan){
        if(!WhWmsInventoryPlanVO.STATUS_PENDING.equals(plan.getStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("盘点任务状态[%s]！",plan.getStatusStr()));
        }
        whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        //删除旧数据
        deleteInventoryPlanShelves(plan.getId());
        createInventoryPlanShelves(plan);
        return true;
    }

    private String buildCode(Long id){
        String code = id.toString();
        for(int i = code.length();i<=4;i++){
            code = "0"+code;
        }
        return code;
    }

    @Override
    @Transactional
    public boolean updateInventoryPlanStatus(WhWmsInventoryPlanVO plan) {
        whWmsInventoryPlanMapper.updateByPrimaryKey(plan);
        return true;
    }

    @Override
    public WhWmsInventoryPlanShelvesVO findInventoryPlanShelves(Long planShelvesId,boolean cascade) {
        WhWmsInventoryPlanShelvesVO planShelves = whWmsInventoryPlanShelvesMapper
                .findInventoryPlanShelvesById(planShelvesId);
        if(NullUtil.isNotNull(planShelves) && cascade){
            fullInventoryPlanShelves(Collections.singletonList(planShelves));
        }
        return planShelves;
    }

    @Override
    public List<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCond(WhWmsInventoryPlanShelvesCond cond) {
        return whWmsInventoryPlanShelvesMapper.findInventoryPlanShelvesByCond(cond);
    }

    @Override
    public Pagination<WhWmsInventoryPlanShelvesVO> findInventoryPlanShelvesByCondPage(WhWmsInventoryPlanShelvesCond cond) {
        Pagination<WhWmsInventoryPlanShelvesVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        Integer total = whWmsInventoryPlanShelvesMapper.countInventoryPlanShelves(cond);
        page.setRecord(total);
        if(!NumberUtil.isNullOrZero(total)){
            List<WhWmsInventoryPlanShelvesVO> list = findInventoryPlanShelvesByCond(cond);
            page.setResultList(list);
        }
        return page;
    }

    @Override
    @Transactional
    public boolean updateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves) {
        if(WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING.equals(planShelves.getStatus())
                || WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus()) ){
            WhWmsInventoryPlanVO plan = findInventoryPlan(planShelves.getInventoryPlanId(),false);
            if(WhWmsInventoryPlanVO.STATUS_PENDING.equals(plan.getStatus())){
                //更新任务:待盘点->盘点中
                plan.setStatus(WhWmsInventoryPlanVO.STATUS_PROCESSING);
                updateInventoryPlanStatus(plan);
            }
        }
        whWmsInventoryPlanShelvesMapper.updateByPrimaryKey(planShelves);
        if(WhWmsInventoryPlanShelvesVO.STATUS_FINISHED.equals(planShelves.getStatus())){
            //更新领取任务状态
            whWmsTaskAssignService.finishTaskAssigned(
                    planShelves.getId().toString()
                    ,WhWmsTaskAssignVO.TASK_TYPE_INVENTORY
                    ,planShelves.getOperatorId());
            if(isInventoryPlanFinished(planShelves.getInventoryPlanId())){
                //更行盘点任务状态
                WhWmsInventoryPlanVO plan = findInventoryPlan(planShelves.getInventoryPlanId(),false);
                plan.setStatus(WhWmsInventoryPlanVO.STATUS_FINISHED);
                updateInventoryPlanStatus(plan);
            }
        }
        return true;
    }

    private boolean isInventoryPlanFinished(Long inventoryPlanId){
        List<WhWmsInventoryPlanShelvesVO> planShelvesList = whWmsInventoryPlanShelvesMapper
                .findInventoryPlanShelvesByPlanId(inventoryPlanId);
        if(EmptyUtil.isNotEmpty(planShelvesList)){
            for(WhWmsInventoryPlanShelvesVO planShelves : planShelvesList){
                if(!WhWmsInventoryPlanShelvesVO.STATUS_FINISHED.equals(planShelves.getStatus())){
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean complateInventoryPlanShelves(WhWmsInventoryPlanShelvesVO planShelves) {
        if(!WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus())
                && !WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING.equals(planShelves.getStatus())
                && !WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(planShelves.getStatus()) ){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("盘点任务状态[%s]！"
                    ,WhWmsInventoryPlanShelvesVO.getStatusName(planShelves.getStatus())));
        }
        //数据预处理
        buildPlanShelves(planShelves);
        //非快速盘点 或 存在差异 需二盘
        boolean isPlanShelvesExistDiff = !planShelves.isInventoryQuick() && isPlanShelvesExistDiff(planShelves);
        if((WhWmsInventoryPlanShelvesVO.STATUS_PENDING.equals(planShelves.getStatus())
                || WhWmsInventoryPlanShelvesVO.STATUS_PROCESSING.equals(planShelves.getStatus()) )
                && isPlanShelvesExistDiff){
            //存在差异，待二盘
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING);
            //记录一盘数据
            savePlanShelvesCheckRcd(planShelves);
        }else if(!isPlanShelvesExistDiff
                || WhWmsInventoryPlanShelvesVO.STATUS_CHECK_PENDING.equals(planShelves.getStatus())){
            //待二盘 or 一盘无差异 -》完成
            planShelves.setStatus(WhWmsInventoryPlanShelvesVO.STATUS_FINISHED);
            //保存盘点差异数据
            savePlanSelvesDiffDetail(planShelves);
        }
        //更行盘点库位任务状态
        updateInventoryPlanShelves(planShelves);
        return true;
    }

    @Override
    @Transactional
    public boolean inventoryQuick(List<WhWmsInventoryPlanVO> planList) {
        if(EmptyUtil.isNotEmpty(planList)){
            for(WhWmsInventoryPlanVO plan : planList){
                inventoryQuick(plan);
            }
        }
        return true;
    }

    @Override
    public List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode) {
        return whWmsInventoryPlanShelvesMapper.countInventoryPlan(operatorId,physicalWarehouseCode);
    }

    private boolean inventoryQuick(WhWmsInventoryPlanVO plan){
        List<WhWmsInventoryPlanShelvesVO> inventroyShelvesList = plan.getInventroyShelvesList();
        List<String> shelvesCodes = new ArrayList<>();
        for(WhWmsInventoryPlanShelvesVO planShelves : inventroyShelvesList){
            planShelves.setShelvesCode(planShelves.getShelvesCode().toUpperCase());
            shelvesCodes.add(planShelves.getShelvesCode());
        }
        Set<String> notFinishedShelvesCodes = findNotFinishedInventoryPlanShelvesCode(plan.getPhysicalWarehouseCode(),shelvesCodes);
        if(!notFinishedShelvesCodes.isEmpty()){
            StringBuilder buff = new StringBuilder();
            for(String shelvesCode : notFinishedShelvesCodes){
                buff.append(shelvesCode).append("<br/>");
            }
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("以下库位存在未完成盘点任务！<br/>%s",buff.toString()));
        }
        //数据填充，无需再次过滤
        reBuildInventoryPlan(plan,false);
        //创建盘点任务
        createInventoryPlan(plan);
        //完成盘点任务行
        Map<Long,List<WhTakeStockRcd>> diffTakeStockMap = new HashMap<>();
        for(WhWmsInventoryPlanShelvesVO planShelves : plan.getInventroyShelvesList()){
            planShelves.setInventoryQuick(true);//快盘标记
            planShelves.setOperatorId(plan.getCreateUserId());
            complateInventoryPlanShelves(planShelves);
            if(EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())){
                for(WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()){
                    diffTakeStockMap.put(diffDetail.getId(),diffDetail.getTakeStockList());
                }
            }
        }

        // #7182 [盘点差异数据状态为“待审核”，需要审核后才完成库存的加减]
        //差异数据，完成盘盈亏处理
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setInventoryPlanId(plan.getId());
        cond.setNeedDiff(true);
        List<WhWmsInventoryPlanDiffDetailVO> diffList = whWmsInventoryPlanDiffService
                .findInventoryPlanDiffDetail(cond);
        if(EmptyUtil.isNotEmpty(diffList)){
            //存在差异
            List<Long> diffIdList = new ArrayList<>();
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : diffList){
                diffIdList.add(diffDetail.getId());
                List<WhTakeStockRcd> takeStockRcdList = diffTakeStockMap.get(diffDetail.getId());
                if(NullUtil.isNull(takeStockRcdList)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,"SCM同步库存计算错误");
                }
                diffDetail.setTakeStockList(takeStockRcdList);
            }
            //差异处理-默认盘盈亏
            WhWmsInventoryPlanDiffProcessVO processVO = new WhWmsInventoryPlanDiffProcessVO();
            processVO.setOperatorId(plan.getCreateUserId());
            processVO.setIdList(diffIdList);
            processVO.setProcessType(WhWmsInventoryPlanDiffDetailVO.PROCESS_TYPE_PROFIT_OR_LOSS);
            whWmsInventoryPlanDiffService.processInventoryPlanDiff(processVO);
            //审核通过,[此处不再审核，需要审批后才能完成]
            /*WhWmsInventoryPlanDiffAuditeVO auditeVO = new WhWmsInventoryPlanDiffAuditeVO();
            auditeVO.setIdList(diffIdList);
            auditeVO.setProcessDiffList(diffList);
            auditeVO.setOperatorId(plan.getCreateUserId());
            auditeVO.setPass(true);
            whWmsInventoryPlanDiffService.auditeInventoryPlanDiff(auditeVO);*/
        }
        return true;
    }

    private void buildPlanShelves(WhWmsInventoryPlanShelvesVO planShelves){
        WhWmsHouseShelvesVO shelves = whWmsHouseShelvesService
                .getHouseShelvesByCode(planShelves.getShelvesCode());
        if(EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())){
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()){
                if(NullUtil.isNull(diffDetail.getOriAmount())
                        || NullUtil.isNull(diffDetail.getRealAmount())
                        || diffDetail.getOriAmount() < 0
                        || diffDetail.getRealAmount() < 0 ){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s]盘点库存数量异常",diffDetail.getShelvesCode()));
                }
                diffDetail.setPhysicalWarehouseCode(planShelves.getPhysicalWarehouseCode());
                diffDetail.setShelvesCode(diffDetail.getShelvesCode().toUpperCase());
                diffDetail.setBarCode(diffDetail.getBarCode().toUpperCase());
                diffDetail.setSkuCode(diffDetail.getSkuCode().toUpperCase());
                diffDetail.setHouseType(shelves.getHouseType());
                diffDetail.setDiffAmount(diffDetail.getRealAmount()-diffDetail.getOriAmount());
                diffDetail.setCreateTime(DateUtil.getNow());
                diffDetail.setCreateUserId(planShelves.getOperatorId());
                diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
                if(!isPlanShelvesDetailExistDiff(diffDetail)){
                    diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PASS);
                }
                String skuCode = diffDetail.getBarCode().split("_")[0];
                if(!skuCode.equals(diffDetail.getSkuCode())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("[%s][%s]SKU批次数据异常",diffDetail.getSkuCode(),diffDetail.getBarCode()));
                }
            }
        }
    }

    private boolean savePlanSelvesDiffDetail(WhWmsInventoryPlanShelvesVO planShelves){
        if(EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())){
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()){
                diffDetail.setInventoryPlanId(planShelves.getInventoryPlanId());
                diffDetail.setInventoryPlanShelvesId(planShelves.getId());
                if(isPlanShelvesDetailExistDiff(diffDetail)){
                    diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
                }else{
                    diffDetail.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PASS);
                }
                //后期需要使用id
                whWmsInventoryPlanDiffService.insert(diffDetail);
            }
            //whWmsInventoryPlanDiffService.batchInsert(planShelves.getShelvesDiffDetailList());
        }
        return true;
    }

    private boolean savePlanShelvesCheckRcd(WhWmsInventoryPlanShelvesVO planShelves){
        if(EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())){
            List<WhWmsInventoryPlanCheckRcdVO> checkRcdList = new ArrayList<>();
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()){
                WhWmsInventoryPlanCheckRcdVO checkRcd = BeanUtil
                        .buildFrom(diffDetail
                                ,WhWmsInventoryPlanCheckRcdVO.class);
                checkRcd.setCheckTime(DateUtil.getNow());
                checkRcd.setCheckUserId(diffDetail.getCreateUserId());
                checkRcdList.add(checkRcd);
            }
            whWmsInventoryPlanCheckRcdMapper.batchInsert(checkRcdList);
        }
        return true;
    }

    private boolean isPlanShelvesExistDiff(WhWmsInventoryPlanShelvesVO planShelves){
        boolean diff = false;
        if(EmptyUtil.isNotEmpty(planShelves.getShelvesDiffDetailList())){
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : planShelves.getShelvesDiffDetailList()){
                diff = isPlanShelvesDetailExistDiff(diffDetail);
                if(diff){
                    break;
                }
            }
        }
        return diff;
    }

    private boolean isPlanShelvesDetailExistDiff(WhWmsInventoryPlanDiffDetailVO diffDetail){
        return !diffDetail.getOriAmount().equals(diffDetail.getRealAmount());
    }
}
