package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsInventoryPlanDiffDetailCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsInventoryPlanDiffDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2018/6/6.
 */
@Service("whWmsInventoryPlanDiffService")
public class WhWmsInventoryPlanDiffServiceImpl implements WhWmsInventoryPlanDiffService {

    @Autowired
    private WhWmsInventoryPlanDiffDetailMapper whWmsInventoryPlanDiffDetailMapper;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhInvService whInvService;

    @Autowired
    private WhTakeStockService whTakeStockService;

    @Override
    public Pagination<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetailPage(WhWmsInventoryPlanDiffDetailCond cond) {
        Pagination<WhWmsInventoryPlanDiffDetailVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int total = whWmsInventoryPlanDiffDetailMapper.countInventoryPlanDiffDetail(cond);
        page.setRecord(total);
        if(!NumberUtil.isNullOrZero(total)){
            List<WhWmsInventoryPlanDiffDetailVO> list = findInventoryPlanDiffDetail(cond);
            page.setResultList(list);
        }
        return page;
    }

    @Override
    public List<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetail(WhWmsInventoryPlanDiffDetailCond cond) {
        return whWmsInventoryPlanDiffDetailMapper.findInventoryPlanDiffDetail(cond);
    }

    public List<WhWmsInventoryPlanDiffDetailVO> findInventoryPlanDiffDetail(List<Long> idList) {
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setIdList(idList);
        return whWmsInventoryPlanDiffDetailMapper.findInventoryPlanDiffDetail(cond);
    }

    @Override
    @Transactional
    public int batchInsert(List<WhWmsInventoryPlanDiffDetailVO> rcdList) {
        if(EmptyUtil.isEmpty(rcdList)){
            return 0;
        }
        return whWmsInventoryPlanDiffDetailMapper.batchInsert(rcdList);
    }

    @Override
    @Transactional
    public int insert(WhWmsInventoryPlanDiffDetailVO diffDetail) {
        return whWmsInventoryPlanDiffDetailMapper.insert(diffDetail);
    }

    @Override
    @Transactional
    public List<Long> processInventoryPlanDiff(WhWmsInventoryPlanDiffProcessVO processVO) {
        if(EmptyUtil.isEmpty(processVO.getIdList())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"无需要处理的数据");
        }
        List<Long> idList = new ArrayList<>();
        List<Integer> statusList = new ArrayList<>();
        statusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_PENDING);
        statusList.add(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_REFUSE);
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setIdList(processVO.getIdList());
        cond.setStatusList(statusList);
        List<WhWmsInventoryPlanDiffDetailVO> detailList = findInventoryPlanDiffDetail(cond);
        if(EmptyUtil.isEmpty(detailList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"无需要处理的数据!");
        }
        for(WhWmsInventoryPlanDiffDetailVO diffDetail : detailList){
            idList.add(diffDetail.getId());
        }
        processVO.setIdList(idList);
        int rows = whWmsInventoryPlanDiffDetailMapper.batchProcessInventoryPlanDiff(processVO);
        if(rows != idList.size()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"请重试!");
        }
        if(WhWmsInventoryPlanDiffDetailVO.PROCESS_TYPE_NOTHING
                .equals(processVO.getProcessType())){
            //待审核->审核完成，不动库存
            WhWmsInventoryPlanDiffDetailExample example = new WhWmsInventoryPlanDiffDetailExample();
            example.createCriteria()
                    .andIdIn(idList)
                    .andStatusEqualTo(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
            WhWmsInventoryPlanDiffDetail update = new WhWmsInventoryPlanDiffDetail();
            update.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PASS);
            whWmsInventoryPlanDiffDetailMapper.updateByExampleSelective(update,example);
        }
        return idList;
    }


    @Override
    @Transactional
    public List<Long> auditeInventoryPlanDiff(WhWmsInventoryPlanDiffAuditeVO auditeVO) {
        if(auditeVO.isPass()){
            return auditeInventoryPlanDiffPass(auditeVO);
        }
        return auditeInventoryPlanDiffRefuse(auditeVO);
    }

    private List<Long> auditeInventoryPlanDiffRefuse(WhWmsInventoryPlanDiffAuditeVO auditeVO){
        if(EmptyUtil.isEmpty(auditeVO.getIdList())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"无需要处理的数据");
        }
        WhWmsInventoryPlanDiffDetailCond cond = new WhWmsInventoryPlanDiffDetailCond();
        cond.setIdList(auditeVO.getIdList());
        cond.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
        List<WhWmsInventoryPlanDiffDetailVO> diffList = findInventoryPlanDiffDetail(cond);
        List<Long> idList = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(diffList)){
            for(WhWmsInventoryPlanDiffDetailVO diffDetaill : diffList){
                idList.add(diffDetaill.getId());
            }
        }
        WhWmsInventoryPlanDiffDetailExample example = new WhWmsInventoryPlanDiffDetailExample();
        example.createCriteria()
                .andIdIn(idList)
                .andStatusEqualTo(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_PENDING);
        WhWmsInventoryPlanDiffDetail update = new WhWmsInventoryPlanDiffDetail();
        update.setStatus(WhWmsInventoryPlanDiffDetailVO.STATUS_AUDITE_REFUSE);

        int row = whWmsInventoryPlanDiffDetailMapper.updateByExampleSelective(update,example);
        if(row != idList.size()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"请重试");
        }
        return idList;
    }

    private List<Long> auditeInventoryPlanDiffPass(WhWmsInventoryPlanDiffAuditeVO auditeVO){
        if(EmptyUtil.isEmpty(auditeVO.getProcessDiffList())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"无需要处理的数据");
        }
        List<WhWmsInventoryPlanDiffDetailVO> diffList = auditeVO.getProcessDiffList();
        if(EmptyUtil.isEmpty(diffList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"没有需要处理的数据");
        }
        List<Long> idList = new ArrayList<>();
        Map<Long,List<WhTakeStockRcd>> diffTakeStockMap = new HashMap<>();
        for(WhWmsInventoryPlanDiffDetailVO diffDetail : diffList){
            idList.add(diffDetail.getId());
            diffTakeStockMap.put(diffDetail.getId(),diffDetail.getTakeStockList());
        }
        auditeVO.setIdList(idList);
        List<WhWmsInventoryPlanDiffDetailVO> detailList = findInventoryPlanDiffDetail(idList);
        for(WhWmsInventoryPlanDiffDetailVO diffDetail : detailList){
            diffDetail.setTakeStockList(diffTakeStockMap.get(diffDetail.getId()));
        }
        int rows = whWmsInventoryPlanDiffDetailMapper.batchAuditeInventoryPlanDiff(auditeVO);
        if(rows != idList.size()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,"请重试!");
        }
        //更行wms库存
        processWmsStock(diffList,auditeVO);
        //更行scm库存
        processScmStockV2(auditeVO);
        return idList;
    }

    private boolean processWmsStock(List<WhWmsInventoryPlanDiffDetailVO> diffList
            , WhWmsInventoryPlanDiffAuditeVO auditeVO){
        if(EmptyUtil.isEmpty(diffList)){
            return true;
        }
        List<WhWmsSkuStockRecord> skuStockRecordList = new ArrayList<>();
        for(WhWmsInventoryPlanDiffDetailVO diffDetail : diffList){
            if(diffDetail.getDiffAmount() == 0){
                continue;
            }
            WhWmsSkuStockRecord stockRecord = BeanUtil.buildFrom(diffDetail,WhWmsSkuStockRecord.class);
            stockRecord.setInOutType(getInventoryInOutType(diffDetail));
            stockRecord.setQuantity(diffDetail.getDiffAmount());
            stockRecord.setReceiptNo(diffDetail.getId().toString());
            stockRecord.setMemo(diffDetail.getAdjustMemo());
            stockRecord.setIsUpdateScm(2);
            stockRecord.setCreateUserId(auditeVO.getOperatorId());
            skuStockRecordList.add(stockRecord);
        }
        whWmsSkuStockService.batchUpdateWhSkuStock(skuStockRecordList);
        return true;
    }

    private boolean processScmStockV2(WhWmsInventoryPlanDiffAuditeVO auditeVO){
        if(EmptyUtil.isEmpty(auditeVO.getProcessDiffList())){
            return true;
        }
        List<WhTakeStockRcd> takeStockRcdList = new ArrayList<>();
        //重组备注机关联id
        for(WhWmsInventoryPlanDiffDetailVO diffDetail : auditeVO.getProcessDiffList()){
            if(EmptyUtil.isNotEmpty(diffDetail.getTakeStockList())){
                for(WhTakeStockRcd whTakeStockRcd : diffDetail.getTakeStockList()){
                    String memo = "(WMS盘点同步:"+diffDetail.getInventoryPlanId()+")";
                    if(EmptyUtil.isNotEmpty(diffDetail.getAdjustMemo())){
                        memo += diffDetail.getAdjustMemo();
                    }
                    whTakeStockRcd.setMemo(memo);
                    if(NullUtil.isNotNull(diffDetail.getId())){
                        whTakeStockRcd.setWmsTakeStockRcdId(diffDetail.getId().intValue());
                    }
                    takeStockRcdList.add(whTakeStockRcd);
                }
            }
        }
        createWhTakeStock(takeStockRcdList,auditeVO);
        return true;
    }

    private void createWhTakeStock(List<WhTakeStockRcd> whRcdList, WhWmsInventoryPlanDiffAuditeVO auditeVO){
        List<WhTakeStock> takeStockList = new ArrayList<>();
        for(WhTakeStockRcd takeStockRcd : whRcdList){
            WhTakeStock whTakeStock = new WhTakeStock();
            whTakeStock.setType(WhTakeStock.TYPE_WMS);
            whTakeStock.setFromWms(true);
            whTakeStock.setSyncThirdpartStock(true);
            whTakeStock.setUpdatePhyWhStock(false);
            whTakeStock.setCreateUserId(auditeVO.getOperatorId());
            whTakeStock.setWarehouseCode(takeStockRcd.getTakeStockWarehouseCode());
            whTakeStock.setReferenceId(takeStockRcd.getWmsTakeStockRcdId().longValue());
            whTakeStock.setWhTakeStockRcdList(Collections.singletonList(takeStockRcd));
            takeStockList.add(whTakeStock);
        }
        try{
            whTakeStockService.batchCreateTakeStock(takeStockList);
        }catch (Exception e){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"同步SCM库存异常:"+e.getMessage());
        }
    }

    private List<WhTakeStockRcd> buildWhTakeStockRcdList(
            List<WhWmsInventoryPlanDiffDetailVO> diffList
            ,WhWmsInventoryPlanDiffProcessVO processVO
            ,Integer commodityStatus){
        if(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(commodityStatus)){
            //颛兴路良品库存特殊处理
            //return buildWhTakeStockRcdForNondefective(diffList,processVO);
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"非法操作");
        }
        //构建出入库逻辑仓
        buildInOutWh(processVO,commodityStatus);
        return buildWhTackStockRcdList(diffList,processVO);
    }

    //良品仓->官网仓->良品仓
    private List<WhTakeStockRcd> buildWhTakeStockRcdForNondefective(
            List<WhWmsInventoryPlanDiffDetailVO> diffList
            ,WhWmsInventoryPlanDiffProcessVO processVO){
        //良品仓
        String waitForDispatchingWhCode = WhWarehouseVO.WAREHOUSE_WH020600010096;//颛兴路良品仓
        WhWarehouse waitForDispatchingWh = whInfoService.findWarehouseByCode(waitForDispatchingWhCode);

        Map<Integer,List<WhWmsInventoryPlanDiffDetailVO>> inOutMap = groupByInOut(diffList);
        Map<String,Integer> profitMap = groupBySku(inOutMap,WhInvRcd.TYPE_PROFIT_IN);//盘盈sku统计
        Map<String,Integer> lossMap = groupBySku(inOutMap,WhInvRcd.TYPE_LOSS_OUT);//盘亏sku统计
        List<String> lossSkuCodes = Arrays.asList(lossMap.keySet().toArray(new String[lossMap.size()]));//盘亏skuCode

        List<WhTakeStockRcd> takeStockRcdList = new ArrayList<>();//良品仓盘点记录
        //良品仓盘盈记录
        List<WhWmsInventoryPlanDiffDetailVO> profitDiffList = inOutMap.get(WhInvRcd.TYPE_PROFIT_IN);
        if(EmptyUtil.isNotEmpty(profitDiffList)){
            processVO.setInWhWarehouse(waitForDispatchingWh);
            processVO.setOutWhWarehouse(waitForDispatchingWh);
            takeStockRcdList.addAll(buildWhTackStockRcdList(profitDiffList,processVO));
        }
        if(EmptyUtil.isEmpty(lossSkuCodes)){//只有盘盈,则只入良品仓
            return takeStockRcdList;
        }
        //良品仓库存 盘亏的sku
        Map<String,Integer> dispatchingInvMap = findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes,waitForDispatchingWhCode);
        //良品仓库存聚合盘盈数据
        joinProfitMap(lossSkuCodes,dispatchingInvMap,profitMap);
        //官网仓库存
        WhWarehouse officialWh = whInfoService.findWarehouseByCode(WhWarehouseVO.WAREHOUSE_WH020600010102);//官网仓
        Map<String,Integer> officialInvMap = findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes,officialWh.getCode());
        List<WhTakeStockRcd> lossTaksStockRcdList = buildWhWmsTakeStockRcdForLoss(
                inOutMap.get(WhInvRcd.TYPE_LOSS_OUT)
                ,dispatchingInvMap,officialInvMap
                ,waitForDispatchingWh,officialWh);
        takeStockRcdList.addAll(lossTaksStockRcdList);
        return takeStockRcdList;
    }

    private List<WhTakeStockRcd> buildWhWmsTakeStockRcdForLoss(
            List<WhWmsInventoryPlanDiffDetailVO> diffList
            ,Map<String,Integer> dispatchingInvMap,Map<String,Integer> officialInvMap
            ,WhWarehouse waitForDispatchingWh,WhWarehouse officialWh){
        List<WhTakeStockRcd> takeStockRcdList = new ArrayList<>();
        for(WhWmsInventoryPlanDiffDetailVO rcd : diffList){
            Integer diffAmount = rcd.getDiffAmount();
            Integer dispatchingInv = dispatchingInvMap.get(rcd.getSkuCode());
            Integer officialInv = officialInvMap.get(rcd.getSkuCode());
            if(NullUtil.isNull(dispatchingInv)){
                dispatchingInv = 0;
            }
            if(NullUtil.isNull(officialInv)){
                officialInv = 0;
            }
            //dispatchingLossInv负数
            int dispatchingLossInv = computeDispatchingLossInv(diffAmount,dispatchingInv,officialInv);
            if(dispatchingLossInv != 0){
                //良品仓扣库存
                WhTakeStockRcd dispatchingWhTakeStockRcd = buildWhTakeStockRcd(rcd,waitForDispatchingWh);
                dispatchingWhTakeStockRcd.setQuantity(dispatchingLossInv);
                takeStockRcdList.add(dispatchingWhTakeStockRcd);
                dispatchingInvMap.put(rcd.getSkuCode(),dispatchingInv+dispatchingLossInv);
            }
            if(dispatchingLossInv != diffAmount){
                //官网仓扣库存
                int officialLoosInv = diffAmount-dispatchingLossInv;
                WhTakeStockRcd officialWhTakeStockRcd = buildWhTakeStockRcd(rcd,officialWh);
                officialWhTakeStockRcd.setQuantity(officialLoosInv);
                takeStockRcdList.add(officialWhTakeStockRcd);
                officialInvMap.put(rcd.getSkuCode(),officialInv+officialLoosInv);
            }
        }
        return takeStockRcdList;
    }

    //computeOfficialLossInv(-1,4,2)
    private int computeDispatchingLossInv(Integer diffAmount,Integer dispatchingInv,Integer officialInv){
        if(NullUtil.isNull(dispatchingInv) || dispatchingInv <0 ){
            dispatchingInv = 0;
        }
        if(NullUtil.isNull(officialInv) || officialInv<0){
            officialInv = 0;
        }
        int totalInv = dispatchingInv+officialInv;
        if(totalInv <= -diffAmount){
            //总可用库存不足，不足部分从良品仓扣除
            return diffAmount+officialInv;
        }else{
            //库存足够
            if(dispatchingInv >= -diffAmount){
                //良品仓库存足够
                return diffAmount;
            }
            return -dispatchingInv;
        }
    }

    private Map<Integer,List<WhWmsInventoryPlanDiffDetailVO>> groupByInOut(
            List<WhWmsInventoryPlanDiffDetailVO> diffList){
        Map<Integer,List<WhWmsInventoryPlanDiffDetailVO>> map = new HashMap<>();
        for(WhWmsInventoryPlanDiffDetailVO diffDetail : diffList){
            Integer inOutType = getInventoryInOutType(diffDetail);
            List<WhWmsInventoryPlanDiffDetailVO> tmpList = map.get(inOutType);
            if(NullUtil.isNull(tmpList)){
                tmpList = new ArrayList<>();
                map.put(inOutType,tmpList);
            }
            tmpList.add(diffDetail);
        }
        return map;
    }

    private Map<String,Integer> groupBySku(Map<Integer,List<WhWmsInventoryPlanDiffDetailVO>> inOutMap,Integer inOut){
        Map<String,Integer> map = new HashMap<>();
        List<WhWmsInventoryPlanDiffDetailVO> list = inOutMap.get(inOut);
        if(EmptyUtil.isNotEmpty(list)){
            for(WhWmsInventoryPlanDiffDetailVO diffDetail : list){
                Integer total = map.get(diffDetail.getSkuCode());
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                map.put(diffDetail.getSkuCode(),total + diffDetail.getDiffAmount());
            }
        }
        return map;
    }




    private Map<String,Integer> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes,String warehouseCode){
        Map<String,Integer> map = new HashMap<>();
        if (EmptyUtil.isEmpty(warehouseCode)){
            return map;
        }
        Map<String, WhInvVO> waitForDispatchingInvMap = whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes,warehouseCode);
        if(NullUtil.isNotNull(waitForDispatchingInvMap) && !waitForDispatchingInvMap.isEmpty()){
            for(Map.Entry<String,WhInvVO> entry : waitForDispatchingInvMap.entrySet()){
                map.put(entry.getKey(),entry.getValue().getCanUseInv());
            }
        }
        return map;
    }

    private void joinProfitMap(List<String> skuCodes,Map<String,Integer> dispatchingInvMap,Map<String,Integer> profitMap){
        for(String skuCode : skuCodes){
            Integer profitInv = profitMap.get(skuCode);
            if(NullUtil.isNull(profitInv)){
                continue;
            }
            Integer dispatchingInv = dispatchingInvMap.get(skuCode);
            if(NullUtil.isNull(dispatchingInv)){
                dispatchingInv = 0;
            }
            dispatchingInv += profitInv;//聚合盘盈数据
            dispatchingInvMap.put(skuCode,dispatchingInv);
        }
    }

    private void buildInOutWh(WhWmsInventoryPlanDiffProcessVO processVO
            ,Integer commodityStatus){
        if(WhPhysicalWarehouseVO.DEFAULT_PHYSICAL_WAREHOUSE_CODE
                .equals(processVO.getPhysicalWarehouseCode())){
            String inOutWarehouseCode = null;
            if(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(commodityStatus)){
                inOutWarehouseCode = WhWarehouseVO.WAREHOUSE_WH020600010096;//颛兴路良品仓
            }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE.equals(commodityStatus)){
                inOutWarehouseCode = WhWarehouseVO.WAREHOUSE_WH020600010101;//颛兴路 - 样品仓
            }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED.equals(commodityStatus)){
                inOutWarehouseCode = WhWarehouseVO.WAREHOUSE_WH020600010098;//颛兴路 -废品仓
            }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED.equals(commodityStatus)){
                inOutWarehouseCode = WhWarehouseVO.WAREHOUSE_MILD_DAMAGED;//颛兴路 - 轻残
            }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED.equals(commodityStatus)){//中残
                inOutWarehouseCode = getWarehoueByConfig(WhWarehouseVO.WAREHOUSE_MODERATE_DEFECTIVE_CONFIG);
            }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED.equals(commodityStatus)){//重残
                inOutWarehouseCode = getWarehoueByConfig(WhWarehouseVO.WAREHOUSE_SEVERE_DEFECTIVE_CONFIG);
            }else if(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY.equals(commodityStatus)){//陈列品
                inOutWarehouseCode = getWarehoueByConfig(WhWarehouseVO.WAREHOUSE_DISPLAY_CONFIG);
            }
            if(EmptyUtil.isNotEmpty(inOutWarehouseCode)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("无可用逻辑仓库，物理仓[%s]，商品状态[%s]",processVO.getPhysicalWarehouseCode(),commodityStatus));
            }
            WhWarehouse whWarehouse = whInfoService
                    .findWarehouseByCode(inOutWarehouseCode);
            processVO.setOutWhWarehouse(whWarehouse);
            processVO.setInWhWarehouse(whWarehouse);
        }else{
            setWarehouseByPhysicalCodeAndStatus(processVO,commodityStatus);
        }
    }

    private List<WhTakeStockRcd> buildWhTackStockRcdList(List<WhWmsInventoryPlanDiffDetailVO> diffList
            ,WhWmsInventoryPlanDiffProcessVO processVO){
        List<WhTakeStockRcd> whTakeStockRcds = new ArrayList<>();
        for(WhWmsInventoryPlanDiffDetailVO rcd : diffList){
            whTakeStockRcds.add(buildWhTakeStockRcd(rcd,processVO));
        }
        return whTakeStockRcds;
    }

    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsInventoryPlanDiffDetailVO diffDetail
            ,WhWmsInventoryPlanDiffProcessVO processVO){
        WhWarehouse warehouse = null;
        if(diffDetail.getDiffAmount()>=0){
            warehouse = processVO.getInWhWarehouse();
            if(NullUtil.isNull(warehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,processVO.getNotExicstInWhWarehouseMsg());
            }
        }else{
            warehouse = processVO.getOutWhWarehouse();
            if(NullUtil.isNull(warehouse)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,processVO.getNotExicstOutWhWarehouseMsg());
            }
        }
        return buildWhTakeStockRcd(diffDetail,warehouse);
    }

    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsInventoryPlanDiffDetailVO diffDetail
            ,WhWarehouse warehouse){
        WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
        whTakeStockRcd.setQuantity(diffDetail.getDiffAmount());
        whTakeStockRcd.setSkuCode(diffDetail.getSkuCode());
        String memo = "(WMS盘点同步:"+diffDetail.getInventoryPlanId()+")";
        if(EmptyUtil.isNotEmpty(diffDetail.getAdjustMemo())){
            memo += diffDetail.getAdjustMemo();
        }
        whTakeStockRcd.setMemo(memo);
        if(NullUtil.isNotNull(diffDetail.getId())){
            whTakeStockRcd.setWmsTakeStockRcdId(diffDetail.getId().intValue());
        }
        whTakeStockRcd.setTakeStockWarehouseCode(warehouse.getCode());
        diffDetail.setTakeStockList(Collections.singletonList(whTakeStockRcd));
        return whTakeStockRcd;
    }

    private void setWarehouseByPhysicalCodeAndStatus(WhWmsInventoryPlanDiffProcessVO processVO, Integer skuStatus){
        List<WhWarehouse> whWarehouses = whInfoService.findWarehouseByPhysicalCodeAndStatus(processVO.getPhysicalWarehouseCode(),skuStatus);
        for (WhWarehouse whWarehouse : whWarehouses){
            if (WhWarehouseVO.RELATE_OUT.equals(whWarehouse.getRelateType())){
                processVO.setOutWhWarehouse(whWarehouse);
            }else if (WhWarehouseVO.RELATE_IN.equals(whWarehouse.getRelateType())){
                processVO.setInWhWarehouse(whWarehouse);
            }
        }
        if(EmptyUtil.isEmpty(processVO.getOutWhWarehouse())){
            processVO.setNotExicstOutWhWarehouseMsg(String.format("无可用逻辑仓库，物理仓[%s]，商品状态[%s]，[%s]",processVO.getPhysicalWarehouseCode(),skuStatus,"出"));
        }
        if(EmptyUtil.isEmpty(processVO.getInWhWarehouse())){
            processVO.setNotExicstInWhWarehouseMsg(String.format("无可用逻辑仓库，物理仓[%s]，商品状态[%s]，[%s]",processVO.getPhysicalWarehouseCode(),skuStatus,"入"));
        }
    }

    private String getWarehoueByConfig(String configValueParam){
        final CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey(configValueParam);
        if (EmptyUtil.isNotEmpty(config) && EmptyUtil.isNotEmpty(config.getConfigValue())){
            return config.getConfigValue();
        }
        return null;
    }


    private Map<Integer,List<WhWmsInventoryPlanDiffDetailVO>> filterThenGroupBySkuStatus(List<WhWmsInventoryPlanDiffDetailVO> diffList){
        Map<Integer,List<WhWmsInventoryPlanDiffDetailVO>> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(diffList)){
            for(WhWmsInventoryPlanDiffDetailVO rcd : diffList){
                if(rcd.getDiffAmount()!=0){
                    List<WhWmsInventoryPlanDiffDetailVO> tmpList = map.get(rcd.getSkuStatus());
                    if(NullUtil.isNull(tmpList)){
                        tmpList = new ArrayList<>();
                        map.put(rcd.getSkuStatus(),tmpList);
                    }
                    tmpList.add(rcd);
                }
            }
        }
        return map;
    }

    private Integer getInventoryInOutType(WhWmsInventoryPlanDiffDetailVO diffDetail){
        return diffDetail.getDiffAmount()>0 ? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT;
    }


}
