//package com.thebeastshop.pegasus.service.warehouse.service.impl;
//
//import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsTakeStockPlanCond;
//import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsTakeStockCheckRcdMapper;
//import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsTakeStockPlanMapper;
//import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsTakeStockRcdMapper;
//import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
//import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
//import com.thebeastshop.pegasus.service.warehouse.model.*;
//import com.thebeastshop.pegasus.service.warehouse.service.*;
//import com.thebeastshop.pegasus.service.warehouse.vo.*;
//import com.thebeastshop.pegasus.util.PegasusConstants;
//import com.thebeastshop.pegasus.util.PegasusUtilFacade;
//import com.thebeastshop.pegasus.util.comm.DateUtil;
//import com.thebeastshop.pegasus.util.comm.EmptyUtil;
//import com.thebeastshop.pegasus.util.comm.NullUtil;
//import com.thebeastshop.pegasus.util.comm.NumberUtil;
//import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//import page.Pagination;
//
//import java.util.*;
//
///**
// * Created by Administrator on 2016/12/16.
// */
//@Service("whWmsInventoryManagerService")
//public class WhWmsInventoryManagerServiceImpl implements WhWmsInventoryManageService{
//
//    @Autowired
//    private WhWmsTakeStockPlanMapper whWmsTakeStockPlanMapper;
//
//    @Autowired
//    WhWmsTakeStockCheckRcdMapper whWmsTakeStockCheckRcdMapper;
//
//    @Autowired
//    private WhWmsTakeStockRcdMapper whWmsTakeStockRcdMapper;
//
//    @Autowired
//    private WhWmsSkuStockService whWmsSkuStockService;
//
//    @Autowired
//    private WhWmsTaskAssignService whWmsTaskAssignService;
//
//    @Autowired
//    private WhInfoService whInfoService;
//
//    @Autowired
//    private WhInvService whInvService;
//
//    @Autowired
//    private WhTakeStockService whTakeStockService;
//
//    @Override
//    @Transactional
//    public boolean createInventoryPlan(List<WhWmsTakeStockPlanVO> planList) {
//        if(EmptyUtil.isEmpty(planList)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"盘点计划为空");
//        }
//        List<String> shelvesCodeList = new ArrayList<>();
//        for(WhWmsTakeStockPlanVO planVO : planList){
//            shelvesCodeList.add(planVO.getShelvesCode());
//        }
//        List<Integer> statusList = new ArrayList<>();
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK);
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE);
//        WhWmsTakeStockPlanExample example = new WhWmsTakeStockPlanExample();
//        example.createCriteria().andStatusIn(statusList).andShelvesCodeIn(shelvesCodeList);
//        List<WhWmsTakeStockPlan> existPlanList = whWmsTakeStockPlanMapper.selectByExample(example);
//        Map<String,WhWmsTakeStockPlan> existPlanListMap = new HashMap<>();
//        if(EmptyUtil.isNotEmpty(existPlanList)){
//            for(WhWmsTakeStockPlan plan : existPlanList){
//                existPlanListMap.put(plan.getShelvesCode(),plan);
//            }
//        }
//        for(WhWmsTakeStockPlanVO planVO : planList){
//            WhWmsTakeStockPlan existPlan = existPlanListMap.get(planVO.getShelvesCode());
//            if(NullUtil.isNull(existPlan)){
//                whWmsTakeStockPlanMapper.insert(planVO);
//            }
//        }
//        return true;
//    }
//
//    @Override
//    @Transactional
//    public boolean insertInventoryPlan(List<WhWmsTakeStockPlanVO> planList) {
//        if(EmptyUtil.isEmpty(planList)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"盘点计划为空");
//        }
//        List<Integer> statusList = new ArrayList<>();
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE);
//        for(WhWmsTakeStockPlanVO planVO : planList){
//            WhWmsTakeStockPlanExample example = new WhWmsTakeStockPlanExample();
//            example.createCriteria().andShelvesCodeEqualTo(planVO.getShelvesCode()).andStatusIn(statusList);
//            List<WhWmsTakeStockPlan> tmpList = whWmsTakeStockPlanMapper.selectByExample(example);
//            if(EmptyUtil.isEmpty(tmpList)){
//                whWmsTakeStockPlanMapper.insert(planVO);
//            }else{
//                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,String.format("[%s]存在待审核盘点计划",planVO.getShelvesCode()));
//            }
//        }
//        return true;
//    }
//
//    @Override
//    @Transactional
//    public boolean cancelInventoryPlan(List<Long> planIds) {
//        WhWmsTakeStockPlanCond cond = new WhWmsTakeStockPlanCond();
//        cond.setIdList(planIds);
//        Pagination<WhWmsTakeStockPlanVO> page = getInventoryPlanByCond(cond);
//        List<WhWmsTakeStockPlanVO> planList = page.getResultList();
//        if(EmptyUtil.isEmpty(planList)){
//            return false;
//        }
//        StringBuilder sb = new StringBuilder();
//        for(WhWmsTakeStockPlanVO vo : planList){
//            if(!WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY.equals(vo.getStatus())
//                    && !WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK.equals(vo.getStatus())
//                    && !WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(vo.getStatus())){
//                sb.append("盘点ID：" + vo.getId() + "状态"+vo.getStatusName()+"</br>" );
//            }
//        }
//        String msg = sb.toString();
//        if(EmptyUtil.isNotEmpty(msg)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,msg);
//        }
//        for(WhWmsTakeStockPlanVO vo : planList){
//            cancelInventoryPlan(vo);
//        }
//        return true;
//    }
//
//    private boolean cancelInventoryPlan(WhWmsTakeStockPlanVO plan){
//        if(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK.equals(plan.getStatus())){
//            //取消一盘数据
//            if(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK.equals(plan.getStatus())){
//                updateTakeStockCheckRcdByPlandId(plan.getId(),WhWmsTakeStockCheckRcdVO.INVALID);
//            }
//        }else if(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(plan.getStatus())){
//            //取消盘点明细
//            WhWmsTakeStockRcd updateRcd = new WhWmsTakeStockRcd();
//            updateRcd.setPlanId(plan.getId());
//            updateRcd.setAuditTime(DateUtil.getNow());
//            updateRcd.setTakeStockeStatus(WhWmsTakeStockRcdVO.STATUS_CANCEL);
//            WhWmsTakeStockRcdExample example = new WhWmsTakeStockRcdExample();
//            example.createCriteria().andPlanIdEqualTo(plan.getId());
//            whWmsTakeStockRcdMapper.updateByExampleSelective(updateRcd,example);
//        }
//        //取消盘点计划
//        updatePlanStatus(plan.getId(),WhWmsTakeStockPlanVO.CANCEL,null);
//        return true;
//    }
//
//    @Override
//    public WhWmsTakeStockPlanVO getInventoryPlanById(Long planId) {
//        if(NullUtil.isNull(planId)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"参数错误");
//        }
//        WhWmsTakeStockPlanCond cond = new WhWmsTakeStockPlanCond();
//        cond.setId(planId);
//        Pagination<WhWmsTakeStockPlanVO> planList = getInventoryPlanByCond(cond);
//        if(EmptyUtil.isEmpty(planList)){
//            return null;
//        }
//        return planList.getResultList().get(0);
//    }
//
//    @Override
//    public Pagination<WhWmsTakeStockPlanVO> getInventoryPlanByCond(WhWmsTakeStockPlanCond cond) {
//        Pagination<WhWmsTakeStockPlanVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
//        List<WhWmsTakeStockPlanVO> list = whWmsTakeStockPlanMapper.getTakeStockPlanByCond(cond);
//        Integer counts = whWmsTakeStockPlanMapper.countTakeStockPlanByCond(cond);
//        page.setResultList(list);
//        page.setRecord(counts);
//
//        return page;
//    }
//
//    @Override
//    @Transactional
//    public void updateWhWmsTakeStockPlanByKey(WhWmsTakeStockPlan whWmsTakeStockPlan) {
//        whWmsTakeStockPlanMapper.updateByPrimaryKeySelective(whWmsTakeStockPlan);
//    }
//
//    @Override
//    @Transactional
//    public boolean inventoryQuick(List<WhWmsTakeStockPlanVO> planList) {
//        if(EmptyUtil.isEmpty(planList)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"盘点计划为空");
//        }
//        List<String> shelvesCodes = new ArrayList<>();
//        for(WhWmsTakeStockPlanVO plan : planList){
//            shelvesCodes.add(plan.getShelvesCode());
//        }
//        WhWmsTakeStockPlanCond cond = new WhWmsTakeStockPlanCond();
//        List<Integer> statusList = new ArrayList<>();
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK);
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE);
//        cond.setStatusList(statusList);
//        cond.setShelvesCodeList(shelvesCodes);
//        Pagination<WhWmsTakeStockPlanVO> existPlanList = getInventoryPlanByCond(cond);
//        List<WhWmsTakeStockPlanVO> newPlanList = new ArrayList<>();
//        Map<String,WhWmsTakeStockPlanVO> existPlanMap = new HashMap<>();
//        if(EmptyUtil.isNotEmpty(existPlanList)){
//            for(WhWmsTakeStockPlanVO planVO : existPlanList.getResultList()){
//                existPlanMap.put(planVO.getShelvesCode(),planVO);
//            }
//        }
//        StringBuilder sb = new StringBuilder();
//        for(WhWmsTakeStockPlanVO plan : planList){
//            WhWmsTakeStockPlanVO existPlan = existPlanMap.get(plan.getShelvesCode());
//            if(NullUtil.isNotNull(existPlan)){
//                if(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(existPlan.getStatus())){
//                    sb.append(String.format("[%s]为待审核状态，无法完成快速盘点<br>",plan.getShelvesCode()));
//                    continue;
//                }
//                plan.setId(existPlan.getId());
//            }else{
//                newPlanList.add(plan);
//            }
//            plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK);//直接走二盘
//        }
//        String waringMsg = sb.toString();
//        if(EmptyUtil.isNotEmpty(waringMsg)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,waringMsg);
//        }
//        stockAvaliableCheck(planList);
//        boolean stepReslut = true;
//        if(EmptyUtil.isNotEmpty(newPlanList)){
//            //创建新盘点计划
//            stepReslut = createInventoryPlan(newPlanList);
//        }
//        //完成盘点
//        stepReslut = stepReslut && complateInventoryPlan(planList);
//        //自动审核差异
//        List<Long> auditPlanIds = new ArrayList<>();
//        for(WhWmsTakeStockPlanVO plan : planList){
//            boolean isDiff = isDiff(plan);
//            if(isDiff){
//                auditPlanIds.add(plan.getId());
//            }
//        }
//        if(EmptyUtil.isNotEmpty(auditPlanIds)){
//            stepReslut =  stepReslut && auditInventoryPlan(auditPlanIds,true,planList.get(0).getOperatorId());
//        }
//        if(!stepReslut){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"处理出错！");
//        }
//        return true;
//    }
//
//    //可用库存检查
//    private void stockAvaliableCheck(List<WhWmsTakeStockPlanVO> planList){
//        List<String> shelvesCodes = new ArrayList<>();
//        Set<String> barCodes = new HashSet<>();
//        Map<String,Integer> shelvesDiffMap = new HashMap<>();
//        String shelvesKey = null;
//        List<WhWmsTakeStockPlanVO> diffPlanList = new ArrayList<>();
//        for(WhWmsTakeStockPlanVO plan : planList){
//            if(!isDiff(plan)){
//                continue;
//            }
//            diffPlanList.add(plan);
//            shelvesCodes.add(plan.getShelvesCode());
//            List<WhWmsTakeStockRcdVO> list = plan.getTakeStockRcdList();
//            for(WhWmsTakeStockRcdVO rcd : list){
//                barCodes.add(rcd.getBarCode());
//                shelvesKey = plan.getShelvesCode()+":"+rcd.getBarCode()+":"+rcd.getSkuStatus();
//                if(shelvesDiffMap.containsKey(shelvesDiffMap)){
//                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
//                            String.format("[%s][%s][%s]重复记录",plan.getShelvesCode(),rcd.getBarCode(),rcd.getSkuStatus()));
//                }
//                shelvesDiffMap.put(shelvesKey,rcd.getDiffAmount());
//            }
//        }
//        if(EmptyUtil.isEmpty(diffPlanList)){
//            return;
//        }
//        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
//        cond.setShelvesCodeList(shelvesCodes);
//        cond.setBarCodeList(Arrays.asList(barCodes.toArray(new String[barCodes.size()])));
//        List<WhWmsSkuStockVO> stockList = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
//        Map<String,Integer> shelvesAvaliableStockMap = new HashMap<>();
//        if(EmptyUtil.isNotEmpty(stockList)){
//            String key = null;
//            for(WhWmsSkuStockVO stock : stockList){
//                key = stock.getShelvesCode()+":"+stock.getBarCode()+":"+stock.getSkuStatus();
//                shelvesAvaliableStockMap.put(key,stock.getAvailableAccount());
//            }
//        }
//        StringBuilder sb = new StringBuilder();
//        for(Map.Entry<String,Integer> entry : shelvesDiffMap.entrySet()){
//            Integer diffAmount = entry.getValue();
//            if(diffAmount.compareTo(0)>0){
//                continue;
//            }
//            Integer avaliableAmount = shelvesAvaliableStockMap.get(entry.getKey());
//            if(NullUtil.isNull(avaliableAmount) || avaliableAmount < -diffAmount){
//                sb.append(String.format("[%s]库存不足<br/>",entry.getKey()));
//                continue;
//            }
//        }
//        String warningMsg = sb.toString();
//        if(EmptyUtil.isNotEmpty(warningMsg)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,warningMsg);
//        }
//    }
//
//    @Override
//    public Pagination<WhWmsTakeStockPlanVO> getInventoryPlanByCondPagination(WhWmsTakeStockPlanCond cond) {
//        Pagination<WhWmsTakeStockPlanVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
//        int total = whWmsTakeStockPlanMapper.countTakeStockPlanByCond(cond);
//        if (NumberUtil.isNullOrZero(total)) {
//            page.setRecord(0);
//            return page;
//        }
//        List<WhWmsTakeStockPlanVO> list = whWmsTakeStockPlanMapper.getTakeStockPlanByCond(cond);
//        page.setRecord(total);
//        page.setResultList(list);
//        return page;
//    }
//
//    @Override
//    @Transactional
//    public boolean complateInventoryPlan(List<WhWmsTakeStockPlanVO> planList) {
//        if(EmptyUtil.isEmpty(planList)){
//            return false;
//        }
//        for(WhWmsTakeStockPlanVO plan : planList){
//            complateInventory(plan);
//        }
//        return true;
//    }
//
//    @Override
//    @Transactional
//    public boolean complateInventoryPlan(WhWmsTakeStockPlanVO plan, Long operatorId, WhWmsTaskAssignVO taskAssignVO) {
//        boolean result = complateInventory(plan);
//        if(result){
//            WhWmsTakeStockPlanVO newPlanVO = getInventoryPlanById(plan.getId());
//            if(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(newPlanVO.getStatus()) ||
//                    WhWmsTakeStockPlanVO.AUDITED.equals(newPlanVO.getStatus())){
//                whWmsTaskAssignService.finishTaskAssigned(taskAssignVO.getId(),operatorId);
//            }
//        }
//        return  result;
//    }
//
//    @Override
//    public List<WhWmsTakeStockRcdVO> getInventoryRcdByPlanId(Long planId) {
//        return whWmsTakeStockRcdMapper.getTakeStockRcdByPlanId(planId);
//    }
//
//    @Override
//    @Transactional
//    public boolean auditInventoryPlan(List<Long> planIds, boolean flag, Long operatorId) {
//        if(EmptyUtil.isEmpty(planIds)){
//            return false;
//        }
//        boolean result = false;
//        for(Long planId : planIds){
//            result = auditInventoryPlan(planId,flag,operatorId);
//            if(!result){
//                return false;
//            }
//        }
//        return result;
//    }
//
//    @Override
//    @Transactional
//    public boolean auditInventoryPlanForSkuTranslate(List<Long> planIds, Long operatorId) {
//        if(EmptyUtil.isEmpty(planIds)){
//            return false;
//        }
//        for(Long planId : planIds){
//            WhWmsTakeStockPlanVO planVO = getInventoryPlanById(planId);
//            if(NullUtil.isNull(planVO)){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]盘点计划不存在",planId));
//            }
//            if(!WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(planVO.getStatus())){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]盘点计划状态不是待审核",planId));
//            }
//            planVO.setOperatorId(operatorId);
//            planVO.setAuditUserId(operatorId);
//            updatePlanStatus(planVO.getId(),WhWmsTakeStockPlanVO.AUDITED,null);
//            checkPlanRcdByPlanId(planVO);
//            List<WhWmsTakeStockRcdVO> rcdList = getInventoryRcdByPlanId(planVO.getId());
//            inventoryWmsStock(rcdList,planVO);
//            //inventoryScmStock(rcdList,planVO);
//        }
//        return true;
//    }
//
//    @Override
//    @Transactional
//    public boolean inventoryScmStockForSkuTranslate(List<Long> planIds,Long operatorId) {
//        if(EmptyUtil.isEmpty(planIds)){
//            return false;
//        }
//        WhWmsTakeStockPlanCond cond = new WhWmsTakeStockPlanCond();
//        cond.setIdList(planIds);
//        Pagination<WhWmsTakeStockPlanVO> planList = getInventoryPlanByCond(cond);
//        if(EmptyUtil.isEmpty(planList)){
//            return false;
//        }
//        boolean result = false;
//        for(WhWmsTakeStockPlanVO planVO: planList.getResultList()){
//            List<WhWmsTakeStockRcdVO> rcdList = getInventoryRcdByPlanId(planVO.getId());
//            planVO.setOperatorId(operatorId);
//            result = inventoryScmStock(rcdList,planVO);
//            if(!result){
//                break;
//            }
//        }
//        return result;
//    }
//
//    @Override
//    @Transactional
//    public boolean auditInventoryPlan(Long planId, boolean flag,Long operatorId) {
//        WhWmsTakeStockPlanVO planVO = getInventoryPlanById(planId);
//        if(NullUtil.isNull(planVO)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]盘点计划不存在",planId));
//        }
//        if(!WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(planVO.getStatus())){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]盘点计划状态不是待审核",planId));
//        }
//        planVO.setOperatorId(operatorId);
//        planVO.setAuditUserId(operatorId);
//        boolean result = false;
//        if(flag){
//            result = auditInventoryPlanPass(planVO);
//        }else {
//            result = auditInventoryPlanRefuse(planVO);
//        }
//        return result;
//    }
//
//    @Override
//    public List<WhCountVO> countInventoryPlan(Long operatorId, String physicalWarehouseCode) {
//        return whWmsTakeStockPlanMapper.countInventoryPlan(operatorId,physicalWarehouseCode);
//    }
//
//    @Override
//    public List<WhWmsTakeStockCheckRcdVO> getLastCheckRcd(List<Long> planIdList) {
//        return whWmsTakeStockCheckRcdMapper.getLastCheckRcd(planIdList);
//    }
//
//    private boolean auditInventoryPlanPass(WhWmsTakeStockPlanVO planVO){
//        updatePlanStatus(planVO.getId(),WhWmsTakeStockPlanVO.AUDITED,null);
//        checkPlanRcdByPlanId(planVO);
//        List<WhWmsTakeStockRcdVO> rcdList = getInventoryRcdByPlanId(planVO.getId());
//        inventoryWmsStock(rcdList,planVO);
//        inventoryScmStock(rcdList,planVO);
//        return true;
//    }
//
//    private boolean inventoryWmsStock(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO){
//        if(EmptyUtil.isEmpty(rcdList)){
//            return true;
//        }
//        //盘库存
//        Integer inOutType = null;
//        for(WhWmsTakeStockRcdVO rcd : rcdList){
//            if(rcd.getDiffAmount()!=0){
//                inOutType = rcd.getDiffAmount()>0? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT;
//                whWmsSkuStockService.updateStockByCond(
//                        rcd.getDiffAmount(),
//                        planVO.getPhysicalWarehouseCode(),
//                        rcd.getHouseType(),
//                        rcd.getBarCode(),
//                        rcd.getShelvesCode(),
//                        rcd.getSkuCode(),
//                        rcd.getSkuStatus(),
//                        inOutType,
//                        rcd.getId().toString(),
//                        rcd.getAuditUserId(),
//                        rcd.getMemo(),
//                        1);
//            }
//        }
//        return true;
//    }
//
//    private boolean inventoryScmStock(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO){
//        if(EmptyUtil.isEmpty(rcdList)){
//            return true;
//        }
//        /*List<ScmSkuListVO> scmSkuListVOList = new ArrayList<>();
//        for(WhWmsTakeStockRcdVO rcd : rcdList){
//            ScmSkuListVO scmSkuListVO = new ScmSkuListVO();
//            scmSkuListVO.setPhysicWarehouseCode(planVO.getPhysicalWarehouseCode());
//            scmSkuListVO.setSkuCode(rcd.getSkuCode());
//            scmSkuListVO.setQuantity(rcd.getDiffAmount());
//            scmSkuListVO.setType(rcd.getDiffAmount()>0?1:2);
//            scmSkuListVO.setSkuCodeStatus(rcd.getSkuStatus());
//            scmSkuListVOList.add(scmSkuListVO);
//        }
//        if(EmptyUtil.isNotEmpty(scmSkuListVOList)){
//            SCMWmsMessage scmWmsMessage = new SCMWmsMessage();
//            scmWmsMessage.setUserId(planVO.getOperatorId());
//            scmWmsMessage.setWmsId(planVO.getId());
//            scmWmsMessage.setSkuList(scmSkuListVOList);
//            rabbitSend.sendMessageObject(scmWmsMessage);
//        }*/
//
//        List<WhTakeStockRcd> takeStockRcdList = new ArrayList<>();
//
//        Map<Integer,List<WhWmsTakeStockRcdVO>> skuStatusMap = filterThenGroupBySkuStatus(rcdList);
//        //良品
//        List<WhWmsTakeStockRcdVO> tmplist = skuStatusMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
//        if(EmptyUtil.isNotEmpty(tmplist)){
//            takeStockRcdList.addAll(inventoryScmStockNondefective(tmplist,planVO));
//        }
//        //轻残次
//        tmplist = skuStatusMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
//        if(EmptyUtil.isNotEmpty(tmplist)){
//            takeStockRcdList.addAll(inventoryScmStockDefective(tmplist,planVO,WhWarehouseVO.WAREHOUSE_MILD_DAMAGED,WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED));
//        }
//        //中残次
//        String moderateDefactive = getWarehoueByConfig(WhWarehouseVO.WAREHOUSE_MODERATE_DEFECTIVE_CONFIG);
//        if (EmptyUtil.isNotEmpty(moderateDefactive)){
//            tmplist = skuStatusMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
//            if(EmptyUtil.isNotEmpty(tmplist)){
//                takeStockRcdList.addAll(inventoryScmStockDefective(tmplist,planVO,moderateDefactive,WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED));
//            }
//        }
//        //重残次
//        String severeDefactive = getWarehoueByConfig(WhWarehouseVO.WAREHOUSE_SEVERE_DEFECTIVE_CONFIG);
//        if (EmptyUtil.isNotEmpty(severeDefactive)){
//            tmplist = skuStatusMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
//            if(EmptyUtil.isNotEmpty(tmplist)){
//                takeStockRcdList.addAll(inventoryScmStockDefective(tmplist,planVO,severeDefactive,WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED));
//            }
//        }
//        //样品
//        tmplist = skuStatusMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
//        if(EmptyUtil.isNotEmpty(tmplist)){
//            takeStockRcdList.addAll(inventoryScmStockSample(tmplist,planVO));
//        }
//
//        //废品
//        tmplist = skuStatusMap.get(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
//        if(EmptyUtil.isNotEmpty(tmplist)){
//            takeStockRcdList.addAll(inventoryScmStockWaste(tmplist,planVO));
//        }
//
//        createWhTakeStock(takeStockRcdList,planVO);
//        return true;
//    }
//
//    private String getWarehoueByConfig(String configValueParam){
//        final CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey(configValueParam);
//        if (EmptyUtil.isNotEmpty(config) && EmptyUtil.isNotEmpty(config.getConfigValue())){
//            return config.getConfigValue();
//        }
//        return null;
//    }
//
//    private void createWhTakeStock(List<WhTakeStockRcd> whRcdList, WhWmsTakeStockPlanVO planVO){
//        Map<String,List<WhTakeStockRcd>> groupByMap = new HashMap<>();
//        for(WhTakeStockRcd takeStockRcd : whRcdList){
//            List<WhTakeStockRcd> list = groupByMap.get(takeStockRcd.getTakeStockWarehouseCode());
//            if(NullUtil.isNull(list)){
//                list = new ArrayList<>();
//                groupByMap.put(takeStockRcd.getTakeStockWarehouseCode(),list);
//            }
//            list.add(takeStockRcd);
//        }
//        List<WhTakeStock> takeStockList = new ArrayList<>();
//        for(Map.Entry<String,List<WhTakeStockRcd>> entry : groupByMap.entrySet()){
//            WhTakeStock whTakeStock = new WhTakeStock();
//            whTakeStock.setFromWms(true);
//            whTakeStock.setCreateUserId(planVO.getAuditUserId());
//            whTakeStock.setWarehouseCode(entry.getKey());
//            whTakeStock.setWhTakeStockRcdList(entry.getValue());
//            takeStockList.add(whTakeStock);
//        }
//        try{
//            whTakeStockService.batchCreateTakeStock(takeStockList);
//        }catch (Exception e){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"同步SCM库存异常:"+e.getMessage());
//        }
//    }
//
//    private List<WhTakeStockRcd> inventoryScmStockDefective(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO,String warehouseCode,Integer commodityStatus){
//        // WhWarehouse  whWarehouse = getOneWarehouseByPhysicalCodeAndStatus(planVO.getPhysicalWarehouseCode(),WhWarehouseVO.TYPE_DAMAGED);
//        // 颛兴路,则默认是颛兴路-残次仓
//        if(WhPhysicalWarehouseVO.DEFAULT_PHYSICAL_WAREHOUSE_CODE.equals(planVO.getPhysicalWarehouseCode())){
//            WhWarehouse  whWarehouse = whInfoService.findWarehouseByCode(warehouseCode);//颛兴路 - 残次品仓
//            planVO.setOutWhWarehouse(whWarehouse);
//            planVO.setInWhWarehouse(whWarehouse);
//        }else{
//            setWarehouseByPhysicalCodeAndStatus(planVO,WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
//        }
//        //inventoryScmStockEasy(rcdList,planVO);
//        return buildWhTackStockRcd(rcdList,planVO);
//    }
//
//    private List<WhTakeStockRcd> inventoryScmStockSample(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO){
//        //WhWarehouse  whWarehouse = getOneWarehouseByPhysicalCodeAndStatus(planVO.getPhysicalWarehouseCode(),WhWarehouseVO.TYPE_SAMPLE);
//        // 颛兴路,则默认是颛兴路-样品仓
//        if(WhPhysicalWarehouseVO.DEFAULT_PHYSICAL_WAREHOUSE_CODE.equals(planVO.getPhysicalWarehouseCode())) {
//            WhWarehouse  whWarehouse = whInfoService.findWarehouseByCode(WhWarehouseVO.WAREHOUSE_WH020600010101);//颛兴路 - 样品仓
//            planVO.setOutWhWarehouse(whWarehouse);
//            planVO.setInWhWarehouse(whWarehouse);
//        }else{
//            setWarehouseByPhysicalCodeAndStatus(planVO,WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
//        }
//        //inventoryScmStockEasy(rcdList,planVO);
//        return buildWhTackStockRcd(rcdList,planVO);
//    }
//
//    private List<WhTakeStockRcd> inventoryScmStockWaste(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO){
//        //WhWarehouse  whWarehouse = getOneWarehouseByPhysicalCodeAndStatus(planVO.getPhysicalWarehouseCode(),WhWarehouseVO.TYPE_SAMPLE);
//        // 颛兴路,则默认是颛兴路-废品仓
//        if(WhPhysicalWarehouseVO.DEFAULT_PHYSICAL_WAREHOUSE_CODE.equals(planVO.getPhysicalWarehouseCode())) {
//            WhWarehouse  whWarehouse = whInfoService.findWarehouseByCode(WhWarehouseVO.WAREHOUSE_WH020600010098);//颛兴路 - 废品仓
//            planVO.setOutWhWarehouse(whWarehouse);
//            planVO.setInWhWarehouse(whWarehouse);
//        }else{
//            setWarehouseByPhysicalCodeAndStatus(planVO,WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
//        }
//        //inventoryScmStockEasy(rcdList,planVO);
//        return buildWhTackStockRcd(rcdList,planVO);
//
//    }
//
//
//    private List<WhTakeStockRcd> buildWhTackStockRcd(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO){
//        List<WhTakeStockRcd> whTakeStockRcds = new ArrayList<>();
//        for(WhWmsTakeStockRcdVO rcd : rcdList){
//            whTakeStockRcds.add(buildWhTakeStockRcd(rcd,planVO));
//        }
//        return whTakeStockRcds;
//    }
//
//    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsTakeStockRcdVO rcd,WhWmsTakeStockPlanVO planVO){
//        WhWarehouse warehouse = null;
//        if(rcd.getDiffAmount()>=0){
//            warehouse = planVO.getInWhWarehouse();
//            if(NullUtil.isNull(warehouse)){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,planVO.getNotExicstInWhWarehouseMsg());
//            }
//        }else{
//            warehouse = planVO.getOutWhWarehouse();
//            if(NullUtil.isNull(warehouse)){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,planVO.getNotExicstOutWhWarehouseMsg());
//            }
//        }
//        return buildWhTakeStockRcd(rcd,warehouse);
//    }
//
//    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsTakeStockRcdVO rcd,WhWarehouse warehouse){
//        WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
//        whTakeStockRcd.setQuantity(rcd.getDiffAmount());
//        whTakeStockRcd.setSkuCode(rcd.getSkuCode());
//        whTakeStockRcd.setMemo("(WMS盘点同步:"+rcd.getPlanId()+")"+rcd.getMemo());
//        whTakeStockRcd.setWmsTakeStockRcdId(rcd.getId().intValue());
//        whTakeStockRcd.setTakeStockWarehouseCode(warehouse.getCode());
//        return whTakeStockRcd;
//    }
//
//    private List<WhTakeStockRcd> buildWhTackStockRcd(List<WhWmsTakeStockRcdVO> rcdList){
//        List<WhTakeStockRcd> whTakeStockRcds = new ArrayList<>();
//        for(WhWmsTakeStockRcdVO rcd : rcdList){
//            whTakeStockRcds.add(buildWhTakeStockRcd(rcd));
//        }
//        return whTakeStockRcds;
//    }
//
//    private void syncScmStock(List<WhTakeStockRcd> whRcdList, WhWmsTakeStockPlanVO planVO){
//        WhTakeStock whTakeStock = new WhTakeStock();
//        whTakeStock.setCreateUserId(planVO.getOperatorId());
//        whTakeStock.setOutWhWarehouse(planVO.getOutWhWarehouse());
//        whTakeStock.setNotExicstOutWhWarehouseMsg(planVO.getNotExicstOutWhWarehouseMsg());
//        whTakeStock.setInWhWarehouse(planVO.getInWhWarehouse());
//        whTakeStock.setNotExicstInWhWarehouseMsg(planVO.getNotExicstInWhWarehouseMsg());
//        whTakeStock.setWhTakeStockRcdList(whRcdList);
//        try {
//            whTakeStockService.recordScmStock(whTakeStock);
//        }catch (Exception e){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"同步SCM库存异常:"+e.getMessage());
//        }
//    }
//
//    //良品仓->官网仓->良品仓
//    private List<WhTakeStockRcd> inventoryScmStockNondefective(List<WhWmsTakeStockRcdVO> rcdList,WhWmsTakeStockPlanVO planVO){
//        //良品仓
//        //WhWarehouse waitForDispatchingWh = getOneWarehouseByPhysicalCodeAndStatus(planVO.getPhysicalWarehouseCode(),WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING);
//        WhWarehouse waitForDispatchingWh = null;
//        if(WhPhysicalWarehouseVO.DEFAULT_PHYSICAL_WAREHOUSE_CODE.equals(planVO.getPhysicalWarehouseCode())){
//            waitForDispatchingWh = whInfoService.findWarehouseByCode(WhWarehouseVO.WAREHOUSE_WH020600010096);//颛兴路良品仓
//            planVO.setInWhWarehouse(waitForDispatchingWh);
//            planVO.setOutWhWarehouse(waitForDispatchingWh);
//        }else{
//            //非颛兴路物理仓仅扣除良品仓
//            setWarehouseByPhysicalCodeAndStatus(planVO,WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
//            return buildWhTackStockRcd(rcdList,planVO);
//        }
//        List<String> lossSkuCodes = new ArrayList<>();//盘亏skuCode
//        Map<String,Integer> profitMap = new HashMap<>();//盘盈sku
//        Map<String,Integer> lossMap = new HashMap<>();//盘亏sku
//        Iterator<WhWmsTakeStockRcdVO> it = rcdList.iterator();
//        List<WhTakeStockRcd> dispatchingWhTakeStockRcds = new ArrayList<>();//良品仓盘点记录
//        while (it.hasNext()){
//            WhWmsTakeStockRcdVO rcd = it.next();
//            if(rcd.getDiffAmount()>0){
//                dispatchingWhTakeStockRcds.add(buildWhTakeStockRcd(rcd,planVO));
//                Integer total = profitMap.get(rcd.getSkuCode());
//                if(NullUtil.isNull(total)){
//                    total = 0;
//                }
//                profitMap.put(rcd.getSkuCode(),total + rcd.getDiffAmount());
//            }else if(rcd.getDiffAmount()<0){
//                lossSkuCodes.add(rcd.getSkuCode());
//                Integer total = lossMap.get(rcd.getSkuCode());
//                if(NullUtil.isNull(total)){
//                    total = 0;
//                }
//                lossMap.put(rcd.getSkuCode(),total + rcd.getDiffAmount());
//            }
//        }
//
//        if(EmptyUtil.isEmpty(lossSkuCodes)){//只有盘盈,则只入良品仓
//            return dispatchingWhTakeStockRcds;
//        }
//        //良品仓库存 盘亏的sku
//        //Map<String,Integer> dispatchingInvMap = findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes,waitForDispatchingWh.getCode());
//        Map<String,Integer> dispatchingInvMap = findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes,planVO.getOutWhWarehouse().getCode());
//        //良品仓库存聚合盘盈数据
//        joinProfitMap(lossSkuCodes,dispatchingInvMap,profitMap);
//        //官网仓库存
//        WhWarehouse officialWh = whInfoService.findWarehouseByCode(WhWarehouseVO.WAREHOUSE_WH020600010102);//官网仓
//        Map<String,Integer> officialInvMap = findCanUseQttBySkuCodesAndWarehouseCode(lossSkuCodes,officialWh.getCode());
//        List<WhTakeStockRcd> lossTaksStockRcdList = buildWhWmsTakeStockRcd(rcdList,dispatchingInvMap,officialInvMap,waitForDispatchingWh,officialWh);
//        dispatchingWhTakeStockRcds.addAll(lossTaksStockRcdList);
//        return dispatchingWhTakeStockRcds;
//    }
//
//    private Map<String,Integer> findCanUseQttBySkuCodesAndWarehouseCode(List<String> skuCodes,String warehouseCode){
//        Map<String,Integer> map = new HashMap<>();
//        if (EmptyUtil.isEmpty(warehouseCode)){
//            return map;
//        }
//        Map<String, WhInvVO> waitForDispatchingInvMap = whInvService.findCanUseQttBySkuCodesAndWarehouseCode(skuCodes,warehouseCode);
//        if(NullUtil.isNotNull(waitForDispatchingInvMap) && !waitForDispatchingInvMap.isEmpty()){
//            for(Map.Entry<String,WhInvVO> entry : waitForDispatchingInvMap.entrySet()){
//                map.put(entry.getKey(),entry.getValue().getCanUseInv());
//            }
//        }
//        return map;
//    }
//
//    private void joinProfitMap(List<String> skuCodes,Map<String,Integer> dispatchingInvMap,Map<String,Integer> profitMap){
//        for(String skuCode : skuCodes){
//            Integer profitInv = profitMap.get(skuCode);
//            if(NullUtil.isNull(profitInv)){
//                continue;
//            }
//            Integer dispatchingInv = dispatchingInvMap.get(skuCode);
//            if(NullUtil.isNull(dispatchingInv)){
//                dispatchingInv = 0;
//            }
//            dispatchingInv += profitInv;//聚合盘盈数据
//            dispatchingInvMap.put(skuCode,dispatchingInv);
//        }
//    }
//
//    private List<WhTakeStockRcd> buildWhWmsTakeStockRcd(List<WhWmsTakeStockRcdVO> rcdList
//            ,Map<String,Integer> dispatchingInvMap,Map<String,Integer> officialInvMap
//            ,WhWarehouse waitForDispatchingWh,WhWarehouse officialWh){
//        Iterator<WhWmsTakeStockRcdVO> it = rcdList.iterator();
//        List<WhTakeStockRcd> takeStockRcdList = new ArrayList<>();
//        while (it.hasNext()){
//            WhWmsTakeStockRcdVO rcd = it.next();
//            if(rcd.getDiffAmount()<0){
//                Integer diffAmount = rcd.getDiffAmount();
//                Integer dispatchingInv = dispatchingInvMap.get(rcd.getSkuCode());
//                Integer officialInv = officialInvMap.get(rcd.getSkuCode());
//                if(NullUtil.isNull(dispatchingInv)){
//                    dispatchingInv = 0;
//                }
//                if(NullUtil.isNull(officialInv)){
//                    officialInv = 0;
//                }
//                //dispatchingLossInv负数
//                int dispatchingLossInv = computeDispatchingLossInv(diffAmount,dispatchingInv,officialInv);
//                if(dispatchingLossInv != 0){
//                    //良品仓扣库存
//                    WhTakeStockRcd dispatchingWhTakeStockRcd = buildWhTakeStockRcd(rcd,waitForDispatchingWh);
//                    dispatchingWhTakeStockRcd.setQuantity(dispatchingLossInv);
//                    takeStockRcdList.add(dispatchingWhTakeStockRcd);
//                    dispatchingInvMap.put(rcd.getSkuCode(),dispatchingInv+dispatchingLossInv);
//                }
//                if(dispatchingLossInv != diffAmount){
//                    //官网仓扣库存
//                    int officialLoosInv = diffAmount-dispatchingLossInv;
//                    WhTakeStockRcd officialWhTakeStockRcd = buildWhTakeStockRcd(rcd,officialWh);
//                    officialWhTakeStockRcd.setQuantity(officialLoosInv);
//                    takeStockRcdList.add(officialWhTakeStockRcd);
//                    officialInvMap.put(rcd.getSkuCode(),officialInv+officialLoosInv);
//                }
//            }
//        }
//        return takeStockRcdList;
//    }
//
//    //computeOfficialLossInv(-1,4,2)
//    private int computeDispatchingLossInv(Integer diffAmount,Integer dispatchingInv,Integer officialInv){
//        if(NullUtil.isNull(dispatchingInv) || dispatchingInv <0 ){
//            dispatchingInv = 0;
//        }
//        if(NullUtil.isNull(officialInv) || officialInv<0){
//            officialInv = 0;
//        }
//        int totalInv = dispatchingInv+officialInv;
//        if(totalInv <= -diffAmount){
//            //总可用库存不足，不足部分从良品仓扣除
//            return diffAmount+officialInv;
//        }else{
//            //库存足够
//            if(dispatchingInv >= -diffAmount){
//                //良品仓库存足够
//                return diffAmount;
//            }
//            return -dispatchingInv;
//        }
//    }
//
//    private void setWarehouseByPhysicalCodeAndStatus(WhWmsTakeStockPlanVO planVO,Integer skuStatus){
//        List<WhWarehouse> whWarehouses = whInfoService.findWarehouseByPhysicalCodeAndStatus(planVO.getPhysicalWarehouseCode(),skuStatus);
//        //WhWarehouse whWarehouse = whInfoService.findDefaultInOrOutWarehouseByPhyWhCode(physicWarehouseCode,relateType,skuStatus);
//        for (WhWarehouse whWarehouse : whWarehouses){
//            if (WhWarehouseVO.RELATE_OUT.equals(whWarehouse.getRelateType())){
//                planVO.setOutWhWarehouse(whWarehouse);
//            }else if (WhWarehouseVO.RELATE_IN.equals(whWarehouse.getRelateType())){
//                planVO.setInWhWarehouse(whWarehouse);
//            }
//        }
//        if (EmptyUtil.isEmpty(planVO.getOutWhWarehouse())){
//            planVO.setNotExicstOutWhWarehouseMsg(String.format("无可用逻辑仓库，物理仓[%s]，商品状态[%s]，[%s]",planVO.getPhysicalWarehouseCode(),skuStatus,"出"));
//        }
//        if (EmptyUtil.isEmpty(planVO.getInWhWarehouse())){
//            planVO.setNotExicstInWhWarehouseMsg(String.format("无可用逻辑仓库，物理仓[%s]，商品状态[%s]，[%s]",planVO.getPhysicalWarehouseCode(),skuStatus,"入"));
//        }
//    }
//
//    private boolean auditInventoryPlanRefuse(WhWmsTakeStockPlanVO planVO){
//        updatePlanStatus(planVO.getId(),WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY,null);
//        delPlanRcdByPlanId(planVO);
//        return true;
//    }
//
//    private Map<Integer,List<WhWmsTakeStockRcdVO>> filterThenGroupBySkuStatus(List<WhWmsTakeStockRcdVO> rcdList){
//        Map<Integer,List<WhWmsTakeStockRcdVO>> map = new HashMap<>();
//        if(EmptyUtil.isNotEmpty(rcdList)){
//            for(WhWmsTakeStockRcdVO rcd : rcdList){
//                if(rcd.getDiffAmount()!=0){
//                    List<WhWmsTakeStockRcdVO> tmpList = map.get(rcd.getSkuStatus());
//                    if(NullUtil.isNull(tmpList)){
//                        tmpList = new ArrayList<>();
//                        map.put(rcd.getSkuStatus(),tmpList);
//                    }
//                    tmpList.add(rcd);
//                }
//            }
//        }
//        return map;
//    }
//
//    private WhTakeStockRcd buildWhTakeStockRcd(WhWmsTakeStockRcdVO rcd){
//        WhTakeStockRcd whTakeStockRcd = new WhTakeStockRcd();
//        whTakeStockRcd.setQuantity(rcd.getDiffAmount());
//        whTakeStockRcd.setSkuCode(rcd.getSkuCode());
//        whTakeStockRcd.setMemo(rcd.getMemo());
//        whTakeStockRcd.setWmsTakeStockRcdId(rcd.getId().intValue());
//        return whTakeStockRcd;
//    }
//
//    //创建盘点
//    private boolean insertInventoryPlan(WhWmsTakeStockPlanVO planVO){
//        List<Integer> statusList = new ArrayList<>();
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY);
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK);
//        statusList.add(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE);
//        WhWmsTakeStockPlanExample example = new WhWmsTakeStockPlanExample();
//        example.createCriteria().andShelvesCodeEqualTo(planVO.getShelvesCode()).andStatusIn(statusList);
//        List<WhWmsTakeStockPlan> planList = whWmsTakeStockPlanMapper.selectByExample(example);
//        if(EmptyUtil.isEmpty(planList)){
//            whWmsTakeStockPlanMapper.insert(planVO);
//        }
//        return true;
//    }
//
//    private boolean complateInventory(WhWmsTakeStockPlanVO plan){
//        boolean result = false,isDiff = isDiff(plan);
//        if(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY.equals(plan.getStatus()) || WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK.equals(plan.getStatus())){
//            if(WhWmsTakeStockPlanVO.WAITTING_FOR_INVENTORY.equals(plan.getStatus())){
//                result = handleInventoryWaitForInventory(plan);
//                if(!isDiff){
//                    plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK);
//                }
//            }else{
//                result = true;
//            }
//            if(result && WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK.equals(plan.getStatus())){
//                result = handleInventoryWaitForSceondCheck(plan,isDiff);
//                if(!isDiff){
//                    plan.setStatus(WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE);
//                }
//            }
//            if(result && WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE.equals(plan.getStatus())){
//                result = auditInventoryPlan(plan.getId(),true,plan.getOperatorId());
//            }
//        }else{
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"盘点状态不合法");
//        }
//        return result;
//    }
//    //待盘点任务处理
//    private boolean handleInventoryWaitForInventory(WhWmsTakeStockPlanVO plan){
//        //状态变更
//        updatePlanStatus(plan.getId(),WhWmsTakeStockPlanVO.WAITTING_FOR_SECOND_CHECK,null);
//        //记录盘点数据待二次盘点
//        List<WhWmsTakeStockCheckRcdVO> checkList = buildTakeStockCheckRcd(plan);
//        insertTakeStockCheckRcd(checkList);
//        return true;
//    }
//
//    //待二次盘点任务处理
//    private boolean handleInventoryWaitForSceondCheck(WhWmsTakeStockPlanVO plan,boolean isDiff){
//        if(isDiff){
//            plan.setDiff(PegasusConstants.YES);
//        }else {
//            plan.setDiff(PegasusConstants.NO);
//        }
//        List<WhWmsTakeStockCheckRcdVO> checkList = buildTakeStockCheckRcd(plan);
//        insertTakeStockCheckRcd(checkList);//记录盘点数据
//        //状态变更
//        updatePlanStatus(plan.getId(),WhWmsTakeStockPlanVO.WAITTING_FOR_AUDITE, plan.getDiff());
//        if(EmptyUtil.isNotEmpty(plan.getTakeStockRcdList())){
//            for(WhWmsTakeStockRcdVO rcd : plan.getTakeStockRcdList()){
//                rcd.setPlanId(plan.getId());
//            }
//        }
//        addInventoryRcd(plan.getTakeStockRcdList());
//        updateTakeStockCheckRcdByPlandId(plan.getId(),WhWmsTakeStockCheckRcdVO.CHECKED);
//        return true;
//    }
//
//    //是否有差异
//    private boolean isDiff(WhWmsTakeStockPlanVO plan){
//        if(EmptyUtil.isEmpty(plan.getTakeStockRcdList())){
//            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"盘点内容为空");
//        }
//        for(WhWmsTakeStockRcdVO rcd : plan.getTakeStockRcdList()){
//            if(!rcd.getDiffAmount().equals(0)){
//                return true;
//            }
//        }
//        return false;
//    }
//
//    private List<WhWmsTakeStockCheckRcdVO> buildTakeStockCheckRcd(WhWmsTakeStockPlanVO plan){
//        if(EmptyUtil.isEmpty(plan.getTakeStockRcdList())){
//            return new ArrayList<>();
//        }
//        List<WhWmsTakeStockCheckRcdVO> checkRcdList = new ArrayList<>();
//        for(WhWmsTakeStockRcdVO rcdVO : plan.getTakeStockRcdList()){
//            WhWmsTakeStockCheckRcdVO checkRcd = new WhWmsTakeStockCheckRcdVO();
//            checkRcd.setPlanId(plan.getId());
//            checkRcd.setPhysicalWarehouseCode(rcdVO.getPhysicalWarehouseCode());
//            checkRcd.setHouseType(rcdVO.getHouseType());
//            checkRcd.setShelvesCode(rcdVO.getShelvesCode());
//            checkRcd.setCheckUserId(rcdVO.getAuditUserId());
//            checkRcd.setCheckTime(rcdVO.getAuditTime());
//            checkRcd.setStatus(WhWmsTakeStockCheckRcdVO.WATIING_CHECK);
//            checkRcd.setSkuCode(rcdVO.getSkuCode());
//            checkRcd.setBarCode(rcdVO.getBarCode());
//            checkRcd.setSkuStatus(rcdVO.getSkuStatus());
//            checkRcd.setRealAmount(rcdVO.getRealAmount());
//            checkRcd.setOriAmount(rcdVO.getOriAmount());
//            checkRcd.setDiffAmount(rcdVO.getDiffAmount());
//            checkRcd.setMemo(rcdVO.getMemo());
//            checkRcdList.add(checkRcd);
//        }
//        return checkRcdList;
//    }
//
//    private boolean insertTakeStockCheckRcd(List<WhWmsTakeStockCheckRcdVO> checkList){
//        for(WhWmsTakeStockCheckRcdVO checkRcdVO : checkList){
//            whWmsTakeStockCheckRcdMapper.insert(checkRcdVO);
//        }
//        return true;
//    }
//
//    private boolean updateTakeStockCheckRcdByPlandId(Long planId,Integer status){
//        WhWmsTakeStockCheckRcd record = new WhWmsTakeStockCheckRcd();
//        record.setStatus(status);
//        WhWmsTakeStockCheckRcdExample example = new WhWmsTakeStockCheckRcdExample();
//        example.createCriteria().andPlanIdEqualTo(planId).andStatusNotEqualTo(WhWmsTakeStockCheckRcdVO.INVALID);
//        whWmsTakeStockCheckRcdMapper.updateByExampleSelective(record,example);
//        return true;
//    }
//
//    //更新盘点计划状态
//    private boolean updatePlanStatus(Long planId,Integer planStatus,Integer diff){
//        WhWmsTakeStockPlan update = new WhWmsTakeStockPlan();
//        update.setId(planId);
//        update.setStatus(planStatus);
//        if(NullUtil.isNotNull(diff)){
//            update.setDiff(diff);
//        }
//        whWmsTakeStockPlanMapper.updateByPrimaryKeySelective(update);
//        return true;
//    }
//
//    //盘点通过
//    private boolean checkPlanRcdByPlanId(WhWmsTakeStockPlanVO planVO){
//        WhWmsTakeStockRcd updateRcd = new WhWmsTakeStockRcd();
//        updateRcd.setPlanId(planVO.getId());
//        updateRcd.setAuditTime(DateUtil.getNow());
//        updateRcd.setTakeStockeStatus(planVO.getStatus());
//        updateRcd.setAuditUserId(planVO.getAuditUserId());
//        WhWmsTakeStockRcdExample example = new WhWmsTakeStockRcdExample();
//        example.createCriteria().andPlanIdEqualTo(planVO.getId());
//        whWmsTakeStockRcdMapper.updateByExampleSelective(updateRcd,example);
//        return true;
//    }
//
//    //删除盘点记录
//    private boolean delPlanRcdByPlanId(WhWmsTakeStockPlanVO planVO){
//        WhWmsTakeStockRcdExample example = new WhWmsTakeStockRcdExample();
//        example.createCriteria().andPlanIdEqualTo(planVO.getId()).andTakeStockeStatusEqualTo(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
//        whWmsTakeStockRcdMapper.deleteByExample(example);
//        return true;
//    }
//
//    //盘点行
//    private boolean addInventoryRcd(List<WhWmsTakeStockRcdVO> rcdList) {
//        if(EmptyUtil.isEmpty(rcdList)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"盘点行为空");
//        }
//        List<WhWmsTakeStockRcdVO> autoAuditList = new ArrayList<>();
//        List<WhWmsTakeStockRcdVO> noAuditList = new ArrayList<>();
//        Map<String,List<WhWmsTakeStockRcdVO>> rcdMap = new HashMap<>();
//        for (WhWmsTakeStockRcdVO  rcd : rcdList) {
//            if (EmptyUtil.isEmpty(rcd.getDiffAmount()) ||
//                    EmptyUtil.isEmpty(rcd.getHouseType()) ||
//                    EmptyUtil.isEmpty(rcd.getOriAmount()) ||
//                    EmptyUtil.isEmpty(rcd.getShelvesCode()) ||
//                    EmptyUtil.isEmpty(rcd.getRealAmount())
//                    ){
//                throw new WarehouseException("", "空参数");
//            }
//            rcd.setTakeStockeStatus(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
//            //按照库位分组
//            String shelvesCode = rcd.getShelvesCode();
//            List<WhWmsTakeStockRcdVO> tmpList = rcdMap.get(shelvesCode);
//            if(EmptyUtil.isEmpty(tmpList)){
//                tmpList = new ArrayList<>();
//                rcdMap.put(shelvesCode,tmpList);
//            }
//            tmpList.add(rcd);
//        }
//        //按库位遍历
//        for(Map.Entry<String,List<WhWmsTakeStockRcdVO>> entry: rcdMap.entrySet()) {
//            if(!checkShelveCanInventory(entry.getKey())){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]有盘点待审核,无法继续",entry.getKey()));
//            }
//            boolean audit = true;
//            for (WhWmsTakeStockRcdVO rcd : entry.getValue()) {
//                if (rcd.getDiffAmount().compareTo(0) != 0) {
//                    audit = false;
//                    break;
//                }
//            }
//            //库位所有批次差异都为0,库位自动审核
//            if (audit) {
//                setShelveRcdStatus(entry.getValue(),WhWmsTakeStockRcdVO.STATUS_AUDITED);
//                autoAuditList.addAll(entry.getValue());
//            } else {
//                setShelveRcdStatus(entry.getValue(),WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
//                noAuditList.addAll(entry.getValue());
//            }
//        }
//        insertRcd(autoAuditList);
//        insertRcd(noAuditList);
//        return true;
//    }
//
//    //检查库位是否可盘点
//    private boolean checkShelveCanInventory(String shelvesCode){
//        WhWmsTakeStockRcdExample example = new WhWmsTakeStockRcdExample();
//        example.createCriteria().andShelvesCodeEqualTo(shelvesCode).andTakeStockeStatusEqualTo(WhWmsTakeStockRcdVO.STATUS_PEDDING_AUDIT);
//        List<WhWmsTakeStockRcd> list = whWmsTakeStockRcdMapper.selectByExample(example);
//        if(EmptyUtil.isEmpty(list)){
//            return true;
//        }
//        return false;
//    }
//
//    //设置盘点状态
//    private void setShelveRcdStatus(List<WhWmsTakeStockRcdVO> shelveRcdList,Integer status){
//        if(EmptyUtil.isEmpty(shelveRcdList)){
//            return;
//        }
//        for(WhWmsTakeStockRcdVO rcd : shelveRcdList){
//            rcd.setTakeStockeStatus(status);
//        }
//    }
//
//    //记录库位盘点记录
//    private boolean insertRcd(List<WhWmsTakeStockRcdVO> rcdList){
//        if(EmptyUtil.isEmpty(rcdList)){
//            return false;
//        }
//        for(WhWmsTakeStockRcdVO rcd : rcdList){
//            if (whWmsTakeStockRcdMapper.insert(rcd) <= 0){
//                throw new WarehouseException("", "数据库插入失败");
//            }
//        }
//        return true;
//    }
//}
