package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWmsServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsHouseShelvesMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelves;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsHouseShelvesExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsWarehouseArea;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsHouseShelvesService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsWarehouseAreaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsShelvesSkuInfoVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWarehouseAreaVO;
import com.thebeastshop.pegasus.util.comm.*;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * Created by devin.li on 2016/3/20.
 */
@Controller("whWmsHouseShelvesService")
public class WhWmsHouseShelvesServiceImpl implements WhWmsHouseShelvesService {
    @Autowired
    private WhWmsHouseShelvesMapper              whHouseShelvesMapper;

    @Autowired
    private WhWmsWarehouseAreaService            whWmsWarehouseAreaService;

    @Autowired
    private WhInfoService                        whInfoService;


    @Override
    public List<WhWmsHouseShelvesVO> getHouseShelvesByCond(WhWmsHouseShelvesCond cond) {
        return whHouseShelvesMapper.getByCondPage(cond);
    }

    @Override
    public WhWmsHouseShelvesVO getHouseShelvesByCode(String code) {
        WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
        example.createCriteria().andCodeEqualTo(code);
        List<WhWmsHouseShelves> houseShelveses = whHouseShelvesMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(houseShelveses)) return null;
        WhWmsHouseShelvesVO vo = BeanUtil.buildFrom(houseShelveses.get(0), WhWmsHouseShelvesVO.class);
        return vo;
    }

    @Override
    public List<WhWmsHouseShelves> getHouseShelvesByCode(List<String> codes) {
        WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
        example.createCriteria().andCodeIn(codes);
        return whHouseShelvesMapper.selectByExample(example);
    }

    @Override
    public Map<String,WhWmsHouseShelves> getHouseShelvesMapByCode(List<String> codes) {
        Map<String,WhWmsHouseShelves> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(codes)){
            List<WhWmsHouseShelves> list = getHouseShelvesByCode(codes);
            if(EmptyUtil.isNotEmpty(list)){
                for(WhWmsHouseShelves shelves : list){
                    map.put(shelves.getCode(),shelves);
                }
            }
        }
        return map;
    }

    @Override
    public WhWmsHouseShelvesVO getHouseShelvesById(Integer id) {
        if (NumberUtil.isNullOrZero(id)) return null;
        WhWmsHouseShelvesExample example = new WhWmsHouseShelvesExample();
        example.createCriteria().andIdEqualTo(new Long(id));
        List<WhWmsHouseShelves> houseShelveses = whHouseShelvesMapper.selectByExample(example);
        if(CollectionUtils.isEmpty(houseShelveses)) return null;
        WhWmsHouseShelvesVO vo = BeanUtil.buildFrom(houseShelveses.get(0), WhWmsHouseShelvesVO.class);
        return vo;
    }

    @Override
    @Transactional
    public Boolean newHouseShelves(WhWmsHouseShelves houseShelves){
        if (EmptyUtil.isEmpty(houseShelves.getCode())) throw new WarehouseException("","null param");
        if (EmptyUtil.isNotEmpty(getHouseShelvesByCode(houseShelves.getCode())))
            throw new WarehouseException("","["+houseShelves.getCode()+"]the code is already exist!");
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setHouseType(houseShelves.getHouseType());
        cond.setPhysicalWarehouseCode(houseShelves.getPhysicalWarehouseCode());
        if(houseShelves.getHouseType().equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE)){
            if (EmptyUtil.isNotEmpty(getHouseShelvesByCondNoPage(cond)))
                throw new WarehouseException("","收货暂存区(A) 只允许有一个库位");
        }else if(houseShelves.getHouseType().equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING)){
            if (EmptyUtil.isNotEmpty(getHouseShelvesByCondNoPage(cond)))
                throw new WarehouseException("","加工区(K) 只允许有一个库位");

        }else if(houseShelves.getHouseType().equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)){
            if (EmptyUtil.isNotEmpty(getHouseShelvesByCondNoPage(cond)))
                throw new WarehouseException("","分拨包装区(M) 只允许有一个库位");
        }
        else if(houseShelves.getHouseType().equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)) {
            if (EmptyUtil.isNotEmpty(getHouseShelvesByCondNoPage(cond)))
                throw new WarehouseException("", "交接区(N) 只允许有一个库位");
        }else if(houseShelves.getHouseType().equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_PROCESSING)) {
            if (EmptyUtil.isNotEmpty(getHouseShelvesByCondNoPage(cond)))
                throw new WarehouseException("", "差异区(O) 只允许有一个库位");
        }
        validate(houseShelves);
        int result = whHouseShelvesMapper.insert(houseShelves);
        if (result<=0) throw new WarehouseException("","insert data error!");
        return true;
    }


    @Override
    @Transactional
    public Boolean updateHouseShelves(WhWmsHouseShelves houseShelves){
        if (EmptyUtil.isEmpty(houseShelves.getCode()) || NumberUtil.isNullOrZero(houseShelves.getId()))
            throw new WarehouseException("","null param");
        validate(houseShelves);
        int result = whHouseShelvesMapper.updateByPrimaryKey(houseShelves);
        if (result<=0) throw new WarehouseException("","update data error!");
        return true;
    }

    public Pagination<WhWmsHouseShelvesVO> getHouseShelvesByCondPage(WhWmsHouseShelvesCond cond){
        List<WhWmsHouseShelvesVO> voList = whHouseShelvesMapper.getByCondPage(cond);
        if (CollectionUtils.isEmpty(voList)) return null;
        Pagination<WhWmsHouseShelvesVO> pagination = new Pagination<WhWmsHouseShelvesVO>(cond.getCurrpage(),cond.getPagenum());
        pagination.setRecord(whHouseShelvesMapper.getCountByCond(cond));
        pagination.setResultList(voList);
        return pagination;
    }

    @Override
    public List<WhWmsHouseShelves> getHouseShelvesByCondNoPage(WhWmsHouseShelvesCond cond) {
        if (EmptyUtil.isNotEmpty(cond.getCodeLike())){
            cond.setCodeLike(SQLUtils.allLike(cond.getCodeLike()));
        }
        return whHouseShelvesMapper.getByCondNoPage(cond);
    }

    @Override
    public List<WhWmsHouseShelves> getHouseShelvesLikeCode(String name) {
        return whHouseShelvesMapper.getHouseShelvesLikeCode(name);
    }

//    @Override
//    public String excuteShelvesCode(String physicalWarehouseCode, String houseType, String shelves) {
//        StringBuffer shelvesCode = new StringBuffer();
//        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(physicalWarehouseCode);
//        WhWmsWarehouseArea warehouseAreaVO = whWmsWarehouseAreaService.getAreaByType(houseType);
//        if(physicalWarehouse!=null && warehouseAreaVO!=null){
//            shelvesCode.append(physicalWarehouse.getHouseNo());
//            shelvesCode.append("-");
//            shelvesCode.append(warehouseAreaVO.getCode());
//            shelvesCode.append("-");
//            shelvesCode.append(shelves);
//            return shelves;
//        }
//        return null;
//    }


    public void validate(WhWmsHouseShelves houseShelves){
        String physicalHouseNo = whInfoService.findPhysicalWarehouseByCode(houseShelves.getPhysicalWarehouseCode()).getHouseNo();
        String []element = houseShelves.getCode().split("-");
        if (element.length != 6){
            throw new WarehouseException("","库位格式错误(例:01-01-01-01)");
        }
        if (EmptyUtil.isNotEmpty(houseShelves.getMaxAmount()) && EmptyUtil.isNotEmpty(houseShelves.getSafeAmount())){
            if(houseShelves.getSafeAmount()>=houseShelves.getMaxAmount()){
                throw new WarehouseException("","安全库存不得大于等于最大保管量");
            }
        }
        if(!element[0].equals(physicalHouseNo)){
            throw new WarehouseException("","["+houseShelves.getCode()+"]error,the code is not matching the physical warehouse!");
        }
        if(whWmsWarehouseAreaService.getAreaByType(houseShelves.getHouseType(),element[1]) == null){
            throw new WarehouseException("","["+houseShelves.getCode()+"]error,区域和区域编码不匹配!");
        }

        if(EmptyUtil.isEmpty(houseShelves.getSkuCode())){
            if (EmptyUtil.isNotEmpty(houseShelves.getSafeAmount())) {
                throw new WarehouseException("","未绑定SKU，安全库存应为空");
            }
            if (EmptyUtil.isNotEmpty(houseShelves.getMaxAmount())) {
                throw new WarehouseException("","未绑定SKU，最大保管量应为空");
            }
        }

    }



}
