package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSimpleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConsumableSkuCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConsumableSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConsumableSku;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConsumableService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConsumableSkuVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("whWmsConsumableService")
public class WhWmsConsumableServiceImpl implements WhWmsConsumableService {

  @Autowired
  private WhWmsConsumableSkuMapper whWmsConsumableSkuMapper;

  @Override
  public PageInfo<WhWmsConsumableSkuVO> findWmsConsumableSkuByCond(WhWmsConsumableSkuCond cond) {

    PageRowBounds pageRowBounds = new PageRowBounds(cond.getRowBounds().getOffset(), cond.getRowBounds().getLimit());
    List<WhWmsConsumableSkuVO> list = whWmsConsumableSkuMapper.findWmsConsumableSkuByCond(cond, pageRowBounds);
    PageInfo<WhWmsConsumableSkuVO> pageInfo = new PageInfo(list);
    pageInfo.setTotal(pageRowBounds.getTotal());
    return pageInfo;
  }

  @Override
  public List<Integer> batchCreate(List<WhWmsConsumableSkuVO> consumableSkuVOList) {
    List<WhWmsConsumableSku> consumableSkuList = buildListVO2PO(consumableSkuVOList);
    if (EmptyUtil.isEmpty(consumableSkuList)) {
      throw  new WarehouseException("批量创建耗材SKU 列表不能为空！");
    }
    whWmsConsumableSkuMapper.batchInsert(consumableSkuList);
    return  new ArrayList<>();
  }

  @Override
  public void batchDeleteConsumableSku(List<String> skuCodes) {
    whWmsConsumableSkuMapper.batchDeleteConsumableSku(skuCodes);

  }

  @Override
  public List<PcsSkuSimpleVO> findConsumableSkuByCodeOrName(String skuCodeOrName) {
    return whWmsConsumableSkuMapper.selectConsumableSkuByCodeOrName(skuCodeOrName);
  }

  @Override
  public List<WhWmsConsumableSku> buildListVO2PO(List<WhWmsConsumableSkuVO> whWmsConsumableSkuVOList) {
    List<WhWmsConsumableSku> consumableSkuList = new ArrayList<>();
    for (WhWmsConsumableSkuVO whWmsConsumableSkuVO : whWmsConsumableSkuVOList) {
      WhWmsConsumableSku whWmsConsumableSku = new  WhWmsConsumableSku();
      BeanUtils.copyProperties(whWmsConsumableSkuVO, whWmsConsumableSku);
      whWmsConsumableSku.setIsDel(whWmsConsumableSkuVO.getBeenDel());
      consumableSkuList.add(whWmsConsumableSku);
    }
    return consumableSkuList;
  }

  @Override
  public List<String> findBySkuCodes(List<String> skuCodes) {
    return whWmsConsumableSkuMapper.selectBySkuCodes(skuCodes);
  }
}
