package com.thebeastshop.pegasus.service.warehouse.service.impl;


import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandPreOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsShelvesSkuInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishInfoCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsReplenishRuleCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsWaitOutStockCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;

import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.pegasus.util.model.CommTypeValue;
import com.thebeastshop.pegasus.util.vo.CommTypeValueVO;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by Administrator on 2017/9/6.
 */
@Service("whWmsConnectStartService")
public class WhWmsConnectStartServiceImpl implements WhWmsConnectStartService {

    private final static String shortKey = "short";
    private final static String shelvesAreaRuleKey = "shelvesAreaRule";
    private final static String noShelvesAreaRuleKey = "noShelvesAreaRuleKey";
    private final static String splitFlag = ":";
    private final static String splitAreaFlag = "|";
    private final static String splitAreaFlagRegx = "\\|";

    private final static String GROUP_SHELVE = "SHELVE";

    private final static String GROUP_HOUSETYPE = "HOUSETYPE";

    private final static String GROUP_NONE = "NONE";

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;

    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhWmsShelvesSkuInfoService whWmsShelvesSkuInfoService;

    @Autowired
    private WhWmsReplenishRuleService whWmsReplenishRuleService;

    @Autowired
    private TaskExecutor taskScheduler;

    @Autowired
    private RedisDistributLock redisDistributLock;


    @Override
    public void commandPreOccupy(String physicalWarehouseCode, Integer skuStatus) {
        // 获取分布式锁
        String lockKey = "lock:preOccupy:"+physicalWarehouseCode+splitFlag+skuStatus;
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            List<WhWmsWaitOutStockVO> waitOutStockList = getWaitOutStockToday(physicalWarehouseCode,skuStatus,true);
            createCommandPreOccupy(physicalWarehouseCode,skuStatus,waitOutStockList);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
    }

    @Override
    public void commandPreOccupy(String physicalWarehouseCode, Integer skuStatus, List<String> commandCodes) {
        // 获取分布式锁
        String lockKey = "lock:preOccupy:"+physicalWarehouseCode+splitFlag+skuStatus;
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            List<WhWmsWaitOutStockVO> waitOutStockList = getWaitOutStock(physicalWarehouseCode,skuStatus,commandCodes,true);
            createCommandPreOccupy(physicalWarehouseCode,skuStatus,waitOutStockList);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
    }

    @Override
    public boolean releasePreOccupy(String physicalWarehouseCode) {
        // 获取分布式锁
        String lockKey = "lock:preOccupy:"+physicalWarehouseCode+splitFlag+ WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE;
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            return whWmsCommandPreOccupyService.releasePreOccupy(physicalWarehouseCode);
        }finally {
            redisDistributLock.unLock(lockKey);
        }
    }

    private void createCommandPreOccupy(String physicalWarehouseCode, Integer skuStatus, List<WhWmsWaitOutStockVO> waitOutStockList){
        List<WhCommandPickStockInfoVO> pickStockInfoList = computePickStock(physicalWarehouseCode,skuStatus,waitOutStockList);
        commandShortRecordThenReplenish(physicalWarehouseCode,pickStockInfoList);//缺货记录
        List<List<WhCommandPickStockInfoVO>> allList = ListUtils.partition(pickStockInfoList,100);
        for(List<WhCommandPickStockInfoVO> partList : allList){
            List<WhWmsCommandPreOccupyVO> preOccupyList = buildPreOccupy(partList);
            whWmsCommandPreOccupyService.createPreOccupy(preOccupyList);
        }
    }


    private void commandShortRecordThenReplenish(String physicalWarehouseCode,List<WhCommandPickStockInfoVO> pickStockInfoList){
        if(EmptyUtil.isEmpty(pickStockInfoList)){
            return;
        }
        List<String> shortCommands = new ArrayList<>();
        List<WhWmsCommandShortRecord> shortRecordList = new ArrayList<>();
        Map<String,Integer> shortSkuMap = null;
        List<String> skuCodes = new ArrayList<>();
        for(WhCommandPickStockInfoVO pickStockInfo : pickStockInfoList){
            if(pickStockInfo.isEnough()){
                continue;
            }
            shortCommands.add(pickStockInfo.getCommandCode());
            shortSkuMap = pickStockInfo.getShortSkuMap();
            for(Map.Entry<String,Integer> entry : shortSkuMap.entrySet()){
                WhWmsCommandShortRecord shortRecord = new WhWmsCommandShortRecord();
                shortRecord.setCommandCode(pickStockInfo.getCommandCode());
                shortRecord.setSkuCode(entry.getKey());
                shortRecord.setShortAmount(entry.getValue());
                shortRecordList.add(shortRecord);
                skuCodes.add(entry.getKey());
            }
        }
        if(EmptyUtil.isNotEmpty(shortCommands)){
            whCommandService.failureStartConnect(shortCommands);//占用失败次数+1
            whCommandService.recordCommandShortSku(shortRecordList);//缺货记录
            //补货规则
            WhWmsPreOccupyBlackListInfoVO blackListInfo = findPreOccupyBlackListInfo(physicalWarehouseCode);
            if(NullUtil.isNotNull(blackListInfo)
                    && blackListInfo.isOn()){
                //补货
                Runnable replenishTask = new ReplenishTask(physicalWarehouseCode,skuCodes);
                taskScheduler.execute(replenishTask);
            }
        }
    }

    private class ReplenishTask implements Runnable{

        private String physicalWarehouseCode;

        private List<String> skuCodes;

        private ReplenishTask(String physicalWarehouseCode,List<String> skuCodes){
            this.physicalWarehouseCode = physicalWarehouseCode;
            this.skuCodes = skuCodes;
        }

        @Override
        public void run() {
            if(EmptyUtil.isEmpty(physicalWarehouseCode)
                    || EmptyUtil.isEmpty(skuCodes)){
                return;
            }
            WhWmsReplenishInfoCond cond = new WhWmsReplenishInfoCond();
            cond.setPhysicalWarehouseCode(physicalWarehouseCode);
            cond.setSkuCodes(skuCodes);
            cond.setCreateUserId(1L);
            cond.setAutoReplenish(true);
            cond.setSourceConnectStart(true);
            try{
                String warnMsg = whWmsReplenishRuleService.replenishInfoGenerateByCond(cond);
                sendMailAfterMakeReplenishFailed(warnMsg);
            }catch (BusinessException e){
                sendMailAfterMakeReplenishFailed(e.getMessage());
            }
        }

        // 补货失败，发送失败原因邮件
        private void sendMailAfterMakeReplenishFailed(String warnMsg){
            if (EmptyUtil.isNotEmpty(warnMsg)){
                CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("mail.sendMailAfterMakeReplenishFailed");
                if (EmptyUtil.isNotEmpty(commGlobalConfig)
                        && EmptyUtil.isNotEmpty(commGlobalConfig.getConfigValue())){
                    String[] msgArr = warnMsg.split("</br>");
                    StringBuilder emailContent = new StringBuilder();
                    for (String msg : msgArr){
                        emailContent.append("<div>"+msg+"</div>");
                    }
                    EmailVO emailVO = new EmailVO();
                    emailVO.setToAddressList(Arrays.asList(commGlobalConfig.getConfigValue().split(",")));
                    emailVO.setSubject("波次启动缺货，生成补货单失败");
                    emailVO.setContent(emailContent.toString());
                    EmailUtil.getInstance().send(emailVO);
                }
            }
        }
    }

    @Override
    public WhWmsConnectStartResultVO connectStart(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if(NullUtil.isNull(countConfig.getNeedAmount()) || countConfig.isIntercept()){
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());
        //step-过滤出sku长宽高过大或sku体积过打的指令
        startLargeSizedPackage(pickStockInfoList,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //step-过滤出sku数量或sku件数过多的指令
        startGeSkuMinCountOrGeSkuQanitlyMinCount(pickStockInfoList,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //step-分离单品单件(根据需要启动的波次数启动,订单留在订单池中)
        //只有留言卡属性为“不需要”的可以启动单品单件否则全部以多品单件和多品多件的形式启动
        startSingleProductSinglePiece(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //多件活动订单根据活动信息的设置,
        // 寻找固定组合的订单，超过下限即可启动，超过上限拆分波次。仅包含活动商品但总件数>1，也可启动
        startMultiPieceActivity(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //step-多品多件根据预分配的拣货区域，按拣货区域从少到多进行组合
        startMultiProductMultiPiece(pickStockInfoList,conditions,countConfig,resultVO,false);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //step-多品单件按拣货库区包含数量依次启动，
        //不足上限部分从包含数量最少的库区依次补充
        startMultiProductSinglePieceV2(pickStockInfoList,conditions,countConfig,resultVO);
        //startMultiProductSinglePiece(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //step-剩余订单根据预分配的拣货区域，按拣货区域从少到多进行组合后启动多品多件，满足下限即可启动，超过上限拆分波次
        startMultiProductMultiPiece(pickStockInfoList,conditions,countConfig,resultVO,true);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //Step-不符合条件的留在订单池中，等待截单时间或人工启动
        startForInterceptOrManual(pickStockInfoList,conditions,countConfig,resultVO);
        return resultVO;
    }

    @Override
    public WhWmsConnectStartResultVO connectStartWithConnectType(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if(EmptyUtil.isEmpty(countConfig.getStartConnectType())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次类型未设置");
        }
        if(WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE.equals(countConfig.getStartConnectType())){
            return connectStartSingleProductSinglePiece(pickStockInfoList,conditions,countConfig);
        }if(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(countConfig.getStartConnectType())){
            return connectStartMultiProductSinglePiece(pickStockInfoList,conditions,countConfig);
        }else if(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE.equals(countConfig.getStartConnectType())){
            return connectStartMultiProductMultiPiece(pickStockInfoList,conditions,countConfig);
        }
        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次类型异常");
    }

    private WhWmsConnectStartResultVO connectStartSingleProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if(NullUtil.isNull(countConfig.getNeedAmount()) || countConfig.isIntercept()){
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());
        if(EmptyUtil.isEmpty(pickStockInfoList)){
            return resultVO;
        }

        //step-过滤出sku长宽高过大或sku体积过打的指令
        startLargeSizedPackage(pickStockInfoList,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }

        //不需要step:过滤出sku数量或sku件数过多的指令
        //分离单品单件、多品多件超出上限部分(根据需要启动的波次数启动,订单留在订单池中)
        //只有留言卡属性为“不需要”的可以启动单品单件，否则全部以多品单件和多品多件的形式启动
        startSingleProductSinglePiece(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //不需要Step:多品单件按拣货库区包含数量依次启动，
        //不足上限部分从包含数量最少的库区依次补充
        //不需要Step:波次不足时，单件和多件组合成多品多件波次
        //不需要Step:不符合条件的留在订单池中，等待截单时间或人工启动

        return resultVO;
    }

    private WhWmsConnectStartResultVO connectStartMultiProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if(NullUtil.isNull(countConfig.getNeedAmount()) || countConfig.isIntercept()){
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());

        if(EmptyUtil.isEmpty(pickStockInfoList)){
            return resultVO;
        }

        //step-过滤出sku长宽高过大或sku体积过打的指令
        startLargeSizedPackage(pickStockInfoList,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //不需要step:-过滤出sku数量或sku件数过多的指令
        //不需要step:分离单品单件、多品多件超出上限部分(根据需要启动的波次数启动,订单留在订单池中)
        //只有留言卡属性为“不需要”的可以启动单品单件，否则全部以多品单件和多品多件的形式启动

        //不需要Step:多品单件按拣货库区包含数量依次启动，
        //不足上限部分从包含数量最少的库区依次补充-优先
        //startMultiProductSinglePiece(pickStockInfoList,conditions,countConfig,resultVO);
        startMultiProductSinglePieceV2(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //多件活动订单根据活动信息的设置,
        // 寻找固定组合的订单，超过下限即可启动，超过上限拆分波次。仅包含活动商品但总件数>1，也可启动
        startMultiPieceActivity(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //不需要Step:波次不足时，单件和多件组合成多品多件波次
        //不需要Step:不符合条件的留在订单池中，等待截单时间或人工启动
        return resultVO;
    }

    public WhWmsConnectStartResultVO connectStartMultiProductMultiPiece(List<WhCommandPickStockInfoVO> pickStockInfoList, WhWmsConnectStartConditionsVO conditions, WhWmsConnectStartCountConfigVO countConfig) {
        if(NullUtil.isNull(countConfig.getNeedAmount()) || countConfig.isIntercept()){
            countConfig.setNeedAmount(9999999);
        }
        WhWmsConnectStartResultVO resultVO = WhWmsConnectStartResultVO.newInstance();
        resultVO.setNeedAmount(countConfig.getNeedAmount());
        resultVO.setPlanedAmount(countConfig.getNeedAmount());
        resultVO.setOperaterId(countConfig.getOperaterId());
        resultVO.setAutoDistribute(conditions.isAutoDistribute());

        //step-过滤出sku长宽高过大或sku体积过打的指令
        startLargeSizedPackage(pickStockInfoList,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }

        //step1-过滤出sku数量或sku件数过多的指令
        startGeSkuMinCountOrGeSkuQanitlyMinCount(pickStockInfoList,countConfig,resultVO);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //分离单品单件、多品多件超出上限部分(根据需要启动的波次数启动,订单留在订单池中)
        //只有留言卡属性为“不需要”的可以启动单品单件，否则全部以多品单件和多品多件的形式启动
        String startConnectType = countConfig.getStartConnectType();
        if(countConfig.isUseAutoFlow()){
            //special-仅启动多品多件数据
            countConfig.setStartConnectType(null);
        }
        startMultiProductMultiPiece(pickStockInfoList,conditions,countConfig,resultVO,false);
        countConfig.setStartConnectType(startConnectType);
        if(resultVO.isEnough()){
            return resultVO;
        }
        //不需要Step3多品单件按拣货库区包含数量依次启动，
        //不足上限部分从包含数量最少的库区依次补充
        //不需要Step4波次不足时，单件和多件组合成多品多件波次
        //不需要Step5不符合条件的留在订单池中，等待截单时间或人工启动
        return resultVO;
    }


    //Step5不符合条件的留在订单池中，等待截单时间或人工启动
    private void startForInterceptOrManual(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                       WhWmsConnectStartCountConfigVO countConfig,
                       WhWmsConnectStartResultVO resultVO){
        if(!countConfig.isIntercept()){
            return;
        }
        //截单全部启动
        Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = computeGroupKey(pickStockInfo,conditions);
            List<WhCommandPickStockInfoVO> multiPieceMultiPieceList = groupMultiProductMultiPieceMap.get(groupKey);
            if(EmptyUtil.isEmpty(multiPieceMultiPieceList)){
                multiPieceMultiPieceList = new ArrayList<>(countConfig.getMultiProductMultiPieceMaxCount());
                groupMultiProductMultiPieceMap.put(groupKey,multiPieceMultiPieceList);
            }
            multiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();//移除
        }
        //全部启动
        for(List<WhCommandPickStockInfoVO> mixList : groupMultiProductMultiPieceMap.values()){
            while(true){
                if(EmptyUtil.isEmpty(mixList)){
                    break;
                }
                int size = Math.min(mixList.size(),countConfig.getMultiProductMultiPieceMaxCount());
                List<WhCommandPickStockInfoVO> needStartList = removeRange(mixList,0,size);//移除启动部分
                buildThenCreateConnectInfo(needStartList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
            }

        }
    }

    //Step4波次不足时，单件和多件组合成多品多件波次
    private void step4(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                       WhWmsConnectStartCountConfigVO countConfig,
                       WhWmsConnectStartResultVO resultVO){
        Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = computeGroupKey(pickStockInfo,conditions);
            List<WhCommandPickStockInfoVO> multiPieceMultiPieceList = groupMultiProductMultiPieceMap.get(groupKey);
            if(EmptyUtil.isEmpty(multiPieceMultiPieceList)){
                multiPieceMultiPieceList = new ArrayList<>(countConfig.getMultiProductMultiPieceMaxCount());
                groupMultiProductMultiPieceMap.put(groupKey,multiPieceMultiPieceList);
            }
            multiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();//移除
            if(multiPieceMultiPieceList.size() == countConfig.getMultiProductMultiPieceMaxCount()){//多品多件-满足上限
                buildThenCreateConnectInfo(multiPieceMultiPieceList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
                if(resultVO.isEnough()){
                    return;
                }
                //清空
                groupMultiProductMultiPieceMap.remove(groupKey);
            }
        }
        //启动满足下限的多品多件
        for(List<WhCommandPickStockInfoVO> mixList : groupMultiProductMultiPieceMap.values()){
            if(mixList.size() >= countConfig.getMultiProductMultiPieceMinCount()){
                buildThenCreateConnectInfo(mixList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
                if(resultVO.isEnough()){
                    return;
                }
            }else{
                if(EmptyUtil.isNotEmpty(mixList)){
                    //不足部分放回订单池
                    pickStockInfoList.addAll(mixList);
                }
            }
        }
    }

    //Step3多品单件按拣货库区包含数量依次启动，
    //优先同一库位
    //不足上限部分从包含数量最少的库区依次补充
    private void startMultiProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                       WhWmsConnectStartCountConfigVO countConfig,
                       WhWmsConnectStartResultVO resultVO){
        //库位聚合剩余数据
        Map<String,Map<String,List<WhCommandPickStockInfoVO>>> groupMultiProductSinglePieceMap = filterAndStartMaxMultiProductSinglePiece(pickStockInfoList,conditions,countConfig,resultVO);
        if(resultVO.isEnough() || groupMultiProductSinglePieceMap.isEmpty()){
           return;
        }
        //库区聚合
        String groupKey = null;
        Map<String,Map<String,List<WhCommandPickStockInfoVO>>> groupMultiProductSinglePieceAreaMap = new HashMap<>();
        for(Map.Entry<String,Map<String,List<WhCommandPickStockInfoVO>>> multiProductSinglePieceAreaShelvesMapEntry : groupMultiProductSinglePieceMap.entrySet()){
            groupKey = multiProductSinglePieceAreaShelvesMapEntry.getKey();
            Map<String,List<WhCommandPickStockInfoVO>> areaMap = groupMultiProductSinglePieceAreaMap.get(groupKey);
            if(NullUtil.isNull(areaMap)){
                areaMap = new HashMap<>();
                groupMultiProductSinglePieceAreaMap.put(groupKey,areaMap);
            }
            Map<String,List<WhCommandPickStockInfoVO>> shelvesMap = multiProductSinglePieceAreaShelvesMapEntry.getValue();
            for(List<WhCommandPickStockInfoVO> shelvesPickList : shelvesMap.values()){
                WhCommandPickStockInfoVO oneShelvesPickInfo = shelvesPickList.get(0);
                String singleHouseType = oneShelvesPickInfo.getSingleHouseType();
                List<WhCommandPickStockInfoVO> areaPickList = getGroupPickList(areaMap,singleHouseType,countConfig.getMultiProductSinglePieceMaxCount());
                areaPickList.addAll(shelvesPickList);
                if(areaPickList.size() >= countConfig.getMultiProductSinglePieceMaxCount()){//超过上限可启动
                    List<WhCommandPickStockInfoVO> needStartList = removeRange(areaPickList,0,countConfig.getMultiProductSinglePieceMaxCount());//移除启动部分
                    buildThenCreateConnectInfo(needStartList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
                    if(resultVO.isEnough()){
                        return;
                    }

                }
            }

        }
        //启动满足下限的单子
        for(Map.Entry<String,Map<String,List<WhCommandPickStockInfoVO>>> multiProductSinglePieceAreaMapEntry : groupMultiProductSinglePieceAreaMap.entrySet()){
            Map<String,List<WhCommandPickStockInfoVO>> multiProductSinglePieceAreaMap = multiProductSinglePieceAreaMapEntry.getValue();
            Iterator<Map.Entry<String,List<WhCommandPickStockInfoVO>>> it = multiProductSinglePieceAreaMap.entrySet().iterator();
            while(it.hasNext()){
                Map.Entry<String,List<WhCommandPickStockInfoVO>> entry = it.next();
                List<WhCommandPickStockInfoVO> areaList = entry.getValue();
                if(areaList.size() >= countConfig.getMultiProductSinglePieceMinCount()){
                    buildThenCreateConnectInfo(areaList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
                    if(resultVO.isEnough()){
                        return;
                    }
                    it.remove();
                }
            }
        }
        //多品单件-库位数量不足部分补齐
        for(Map.Entry<String,Map<String,List<WhCommandPickStockInfoVO>>> multiProductSinglePieceAreaMapEntry : groupMultiProductSinglePieceAreaMap.entrySet()){
            Map<String,List<WhCommandPickStockInfoVO>> multiProductSinglePieceAreaMap = multiProductSinglePieceAreaMapEntry.getValue();
            Collection<List<WhCommandPickStockInfoVO>> areaLists = multiProductSinglePieceAreaMap.values();
            if(Boolean.TRUE.equals(countConfig.getMultiProductSinglePieceMergeShelvesArea())){//需跨区合并
                areaLists = sortThenFull(multiProductSinglePieceAreaMap.values(),countConfig.getMultiProductSinglePieceMaxCount());
            }
            for(List<WhCommandPickStockInfoVO> areaList : areaLists){
                int size = areaList.size();
                //数量足够或者制定启动类型
                if(size == countConfig.getMultiProductSinglePieceMaxCount() || size >= countConfig.getMultiProductSinglePieceMinCount()
                        || (WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(countConfig.getStartConnectType()) && !countConfig.isUseAutoFlow() )){
                    buildThenCreateConnectInfo(areaList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
                    if(resultVO.isEnough()){
                        return;
                    }
                }else{
                    //不足下限部分按多品多件处理
                    pickStockInfoList.addAll(areaList);
                }
            }
        }

    }

    //库位聚合并启动满足上限数据
    private Map<String,Map<String,List<WhCommandPickStockInfoVO>>> filterAndStartMaxMultiProductSinglePiece(
            List<WhCommandPickStockInfoVO> pickStockInfoList,
            WhWmsConnectStartConditionsVO conditions,
            WhWmsConnectStartCountConfigVO countConfig,
            WhWmsConnectStartResultVO resultVO){
        Map<String,Map<String,List<WhCommandPickStockInfoVO>>> groupMultiProductSinglePieceMap = new HashMap<>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        //库位聚合
        while(iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = computeGroupKey(pickStockInfo,conditions);
            if(pickStockInfo.isSingle()){
                //多品单件
                Map<String,List<WhCommandPickStockInfoVO>> multiProductSinglePieceAreaShelvesMap = groupMultiProductSinglePieceMap.get(groupKey);
                if(NullUtil.isNull(multiProductSinglePieceAreaShelvesMap)){
                    multiProductSinglePieceAreaShelvesMap = new HashMap<>();
                    groupMultiProductSinglePieceMap.put(groupKey,multiProductSinglePieceAreaShelvesMap);
                }
                WhWmsCommandPreOccupyVO preOccupy = pickStockInfo.getPreOccupyList().get(0);
                String singlePickShelvesCode = preOccupy.getShelvesCode();
                List<WhCommandPickStockInfoVO> areaShelvesList = getGroupPickList(multiProductSinglePieceAreaShelvesMap,singlePickShelvesCode,countConfig.getMultiProductSinglePieceMaxCount());
                areaShelvesList.add(pickStockInfo);
                iterator.remove();
                if(areaShelvesList.size() == countConfig.getMultiProductSinglePieceMaxCount()){//多品单件满足
                    buildThenCreateConnectInfo(areaShelvesList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
                    multiProductSinglePieceAreaShelvesMap.remove(singlePickShelvesCode);//清空
                    if(resultVO.isEnough()){
                        return groupMultiProductSinglePieceMap;
                    }

                }
//                if(areaShelvesList.size() >= countConfig.getMultiProductSinglePieceMaxCount()){//多品单件满足
//                    Map<String,String> skuBarcodeMap = new HashMap<>();
//                    Map<Integer,WhCommandPickStockInfoVO> restMap = new HashMap<>();
//                    for(int i = 0;i< areaShelvesList.size();i++){
//                        WhCommandPickStockInfoVO vo = areaShelvesList.get(i);
//                        String barCode = skuBarcodeMap.get(vo.getSingleSkuCode());
//                        if(barCode == null){
//                            skuBarcodeMap.put(vo.getSingleSkuCode(),vo.getSingleBarcode());
//                        }else{
//                            if(!barCode.equals(vo.getSingleBarcode())){
//                                restMap.put(i,vo);
//                            }
//                        }
//                    }
//                    if(areaShelvesList.size() - restMap.size() == countConfig.getMultiProductSinglePieceMaxCount()){
//                        for(Integer key:restMap.keySet()){
//                            areaShelvesList.remove(key);
//                        }
//                        buildThenCreateConnectInfo(areaShelvesList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
//                        if(restMap.size() > 0){
//                            areaShelvesList = new ArrayList<>();
//                            areaShelvesList.addAll(restMap.values());
//                            multiProductSinglePieceAreaShelvesMap.put(singlePickShelvesCode,areaShelvesList);
//                        }else{
//                            multiProductSinglePieceAreaShelvesMap.remove(singlePickShelvesCode);//清空
//                        }
//
//                        if(resultVO.isEnough()){
//                            return groupMultiProductSinglePieceMap;
//                        }
//                    }
//
//                }
            }
        }
        return groupMultiProductSinglePieceMap;
    }


    //Step3多品单件按拣货库区包含数量依次启动，
    //优先同一库位
    //不足上限部分从包含数量最少的库区依次补充
    private void startMultiProductSinglePieceV2(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                                              WhWmsConnectStartCountConfigVO countConfig,
                                              WhWmsConnectStartResultVO resultVO){
        //库位聚合剩余数据
        //组->库位->sku->barcode->pickInfoList
        Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> groupMultiProductSinglePieceMap
                = filterAndStartMultiProductSinglePieceShelveSkuBarcode(pickStockInfoList,conditions,countConfig,resultVO,GROUP_SHELVE,false);
        if(resultVO.isEnough() || groupMultiProductSinglePieceMap.isEmpty()){
            return;
        }
        //库区聚合
        List<WhCommandPickStockInfoVO> housePickList = resetPickStockInfo(groupMultiProductSinglePieceMap);
        //组->库区->sku->barcode->pickInfoList
        Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> houseGroupMultiProductSinglePieceMap
                = filterAndStartMultiProductSinglePieceShelveSkuBarcode(housePickList,conditions,countConfig,resultVO,GROUP_HOUSETYPE,false);
        if(resultVO.isEnough() || houseGroupMultiProductSinglePieceMap.isEmpty()){
            return;
        }
        List<WhCommandPickStockInfoVO> nonehousePickList = resetPickStockInfo(houseGroupMultiProductSinglePieceMap);
        if(Boolean.TRUE.equals(countConfig.getMultiProductSinglePieceMergeShelvesArea())){//需跨区合并
            Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> noneGroupMap
                    = filterAndStartMultiProductSinglePieceShelveSkuBarcode(nonehousePickList,conditions,countConfig,resultVO,GROUP_NONE,true);
            if(resultVO.isEnough() || noneGroupMap.isEmpty()){
                return;
            }
            List<WhCommandPickStockInfoVO> restList = resetPickStockInfo(noneGroupMap);
            if(EmptyUtil.isNotEmpty(restList)){
                pickStockInfoList.addAll(restList);
            }
        }else{
            Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> houseTypeGroupMap
                    = filterAndStartMultiProductSinglePieceShelveSkuBarcode(nonehousePickList,conditions,countConfig,resultVO,GROUP_HOUSETYPE,true);
            if(resultVO.isEnough() || houseTypeGroupMap.isEmpty()){
                return;
            }
            List<WhCommandPickStockInfoVO> restList = resetPickStockInfo(houseTypeGroupMap);
            if(EmptyUtil.isNotEmpty(restList)){
                pickStockInfoList.addAll(restList);
            }
        }
    }


    private List<WhCommandPickStockInfoVO> resetPickStockInfo(Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> groupShelveSkuBarcodeMap){
        List<WhCommandPickStockInfoVO> pickStockInfoList = new ArrayList<>();
        for(Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>> shelveSkuBarcodMap : groupShelveSkuBarcodeMap.values()){
            for(Map<String,Map<String,List<WhCommandPickStockInfoVO>>> skuBarcodeMap : shelveSkuBarcodMap.values()){
                for(Map<String,List<WhCommandPickStockInfoVO>> barcodeMap : skuBarcodeMap.values()){
                    for(List<WhCommandPickStockInfoVO> barcodePickStockList : barcodeMap.values()){
                        if(EmptyUtil.isNotEmpty(barcodePickStockList)){
                            pickStockInfoList.addAll(barcodePickStockList);
                        }
                    }
                }
            }
        }
        return pickStockInfoList;
    }


    //库位聚合并启动满足上限数据
    private Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> filterAndStartMultiProductSinglePieceShelveSkuBarcode(
            List<WhCommandPickStockInfoVO> pickStockInfoList,
            WhWmsConnectStartConditionsVO conditions,
            WhWmsConnectStartCountConfigVO countConfig,
            WhWmsConnectStartResultVO resultVO,String groupType,boolean needJoin){
        Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> groupMultiProductSinglePieceMap = new HashMap<>();

        buildAndStartMaxLimitSingleShelveMultSkuSingleBarcode(groupMultiProductSinglePieceMap,pickStockInfoList,conditions,countConfig,resultVO,groupType);
        if(resultVO.isEnough()){
            return groupMultiProductSinglePieceMap;
        }

        for(Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>> groupShelveMap : groupMultiProductSinglePieceMap.values()){
            for(Map.Entry<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>> singleBarcodeMapEntry : groupShelveMap.entrySet()){
                String shelveCode = singleBarcodeMapEntry.getKey();
                Map<String,Map<String,List<WhCommandPickStockInfoVO>>> shelveSkuMap = singleBarcodeMapEntry.getValue();
                List<WhCommandPickStockInfoVO> shelveBarcodePickList = new ArrayList<>();
                boolean nextShelve = false;
                while(!nextShelve){//单一库位，不同sku
                    nextShelve = true;
                    Iterator<Map.Entry<String,Map<String,List<WhCommandPickStockInfoVO>>>> entryIt = shelveSkuMap.entrySet().iterator();
                    while(entryIt.hasNext()){
                        Map.Entry<String,Map<String,List<WhCommandPickStockInfoVO>>> entry = entryIt.next();
                        String skuCode = entry.getKey();
                        Map<String,List<WhCommandPickStockInfoVO>> skuBarcodeMap = entry.getValue();
                        List<WhCommandPickStockInfoVO> barCodePickList = getMaxBarCodePickStockList(skuBarcodeMap);
                        if(EmptyUtil.isEmpty(barCodePickList)){
                            continue;
                        }
                        WhCommandPickStockInfoVO pickInfo = barCodePickList.get(0);
                        String barCode = pickInfo.getSingleBarcode();
                        skuBarcodeMap.remove(barCode);
                        tryFullToLimit(shelveBarcodePickList,barCodePickList,countConfig.getMultiProductSinglePieceMaxCount());
                        if(EmptyUtil.isNotEmpty(barCodePickList)){
                            //多余归还
                            skuBarcodeMap.put(pickInfo.getSingleBarcode(),barCodePickList);
                        }
                        if(skuBarcodeMap.isEmpty()){
                            entryIt.remove();
                        }
                        if(EmptyUtil.isNotEmpty(shelveBarcodePickList)
                                && ( shelveBarcodePickList.size() == countConfig.getMultiProductSinglePieceMaxCount()
                                    || ( GROUP_HOUSETYPE.equals(groupType) || GROUP_NONE.equals(groupType) )
                                        && shelveBarcodePickList.size() >= countConfig.getMultiProductSinglePieceMinCount() && !entryIt.hasNext()
                                    || ( GROUP_HOUSETYPE.equals(groupType) || GROUP_NONE.equals(groupType) ) && needJoin
                                        && WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(countConfig.getStartConnectType()) && !countConfig.isUseAutoFlow() && !entryIt.hasNext() )
                                ){//多品单件满足
                            buildThenCreateConnectInfo(shelveBarcodePickList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
                            shelveBarcodePickList.clear();
                            nextShelve = false;
                            if(resultVO.isEnough()){
                                return groupMultiProductSinglePieceMap;
                            }
                            //当前库位继续遍历
                            break;
                        }
                    }
                    if(EmptyUtil.isNotEmpty(shelveBarcodePickList)){
                        //数据归还
                        buildAndStartMaxLimitSingleShelveMultSkuSingleBarcode(groupMultiProductSinglePieceMap,shelveBarcodePickList,conditions,countConfig,resultVO,groupType);

                    }
                }
            }
        }
        return groupMultiProductSinglePieceMap;
    }


    private void buildAndStartMaxLimitSingleShelveMultSkuSingleBarcode(Map<String,Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>>> groupMultiProductSinglePieceMap,
                                                  List<WhCommandPickStockInfoVO> pickStockInfoList,
                                                  WhWmsConnectStartConditionsVO conditions,
                                                  WhWmsConnectStartCountConfigVO countConfig,
                                                  WhWmsConnectStartResultVO resultVO,String groupType){
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        //组->库位->sku->批次->待启动列表
        while(iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            groupKey = computeGroupKey(pickStockInfo,conditions);
            if(pickStockInfo.isSingle()){
                //多品单件
                Map<String,Map<String,Map<String,List<WhCommandPickStockInfoVO>>>> multiProductSinglePieceAreaShelvesMap = groupMultiProductSinglePieceMap.get(groupKey);
                if(NullUtil.isNull(multiProductSinglePieceAreaShelvesMap)){
                    multiProductSinglePieceAreaShelvesMap = new HashMap<>();
                    groupMultiProductSinglePieceMap.put(groupKey,multiProductSinglePieceAreaShelvesMap);
                }
                WhWmsCommandPreOccupyVO preOccupy = pickStockInfo.getPreOccupyList().get(0);
                String singlePickShelvesCode = null;
                if(GROUP_SHELVE.equals(groupType)){
                    singlePickShelvesCode = preOccupy.getShelvesCode();
                }else if(GROUP_HOUSETYPE.equals(groupType)){
                    singlePickShelvesCode = preOccupy.getHouseType();
                }else if(GROUP_NONE.equals(groupType)){
                    singlePickShelvesCode = GROUP_NONE;
                }
                String skuCode = preOccupy.getSkuCode();
                String barCode = preOccupy.getBarCode();
                Map<String,Map<String,List<WhCommandPickStockInfoVO>>> shelveSkuMap = multiProductSinglePieceAreaShelvesMap.get(singlePickShelvesCode);
                if(NullUtil.isNull(shelveSkuMap)){
                    shelveSkuMap = new HashMap<>();
                    multiProductSinglePieceAreaShelvesMap.put(singlePickShelvesCode,shelveSkuMap);
                }
                Map<String,List<WhCommandPickStockInfoVO>> barCodeMap = shelveSkuMap.get(skuCode);
                if(NullUtil.isNull(barCodeMap)){
                    barCodeMap = new HashMap<>();
                    shelveSkuMap.put(skuCode,barCodeMap);
                }
                List<WhCommandPickStockInfoVO> barCodeShelvesList = getGroupPickList(barCodeMap,barCode,countConfig.getMultiProductSinglePieceMaxCount());
                barCodeShelvesList.add(pickStockInfo);
                iterator.remove();
                if(barCodeShelvesList.size() == countConfig.getMultiProductSinglePieceMaxCount()){//多品单件满足
                    buildThenCreateConnectInfo(barCodeShelvesList,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE,resultVO);
                    barCodeMap.remove(barCode);//清空
                    if(resultVO.isEnough()){
                        return;
                    }
                }
            }
        }
    }

    private void tryFullToLimit(List<WhCommandPickStockInfoVO> shelveBarcodePickList,List<WhCommandPickStockInfoVO> barCodePickList,int limit){
        int pickAmount = shelveBarcodePickList.size(),comeAmount = barCodePickList.size();
        if(pickAmount+comeAmount > limit){
            List<WhCommandPickStockInfoVO> needStartList = removeRange(barCodePickList,0,limit-pickAmount);//移除启动部分
            shelveBarcodePickList.addAll(needStartList);
        }else{
            shelveBarcodePickList.addAll(barCodePickList);
            barCodePickList.clear();
        }
    }

    private List<WhCommandPickStockInfoVO> getMaxBarCodePickStockList(Map<String,List<WhCommandPickStockInfoVO>> skuBarcodeMap){
        List<WhCommandPickStockInfoVO> maxList = Collections.emptyList();
        for(List<WhCommandPickStockInfoVO> skuBarcodePickList :  skuBarcodeMap.values()){
           if(maxList.size() < skuBarcodePickList.size()){
               maxList = skuBarcodePickList;
           }
        }
        return maxList;
    }

    private List<List<WhCommandPickStockInfoVO>> sortThenFull(Collection<List<WhCommandPickStockInfoVO>> collection,int limit){
        List<List<WhCommandPickStockInfoVO>> sortList = sortByHouseTypeDesc(collection);
        if(EmptyUtil.isNotEmpty(sortList)){
            int size = sortList.size();
            int beforeIndex = 0,backIndex = size-1;
            List<WhCommandPickStockInfoVO> beforeList = sortList.get(beforeIndex);
            List<WhCommandPickStockInfoVO> backList = sortList.get(backIndex);
            while(beforeIndex < backIndex){
                int needSize = limit - beforeList.size();
                int avaliableSize = backList.size();
                if(avaliableSize > needSize){
                    List<WhCommandPickStockInfoVO> tmpList = backList.subList(0,needSize);
                    beforeList.addAll(tmpList);
                    backList.removeAll(tmpList);
                    beforeList = sortList.get(++beforeIndex);
                }else{
                    beforeList.addAll(backList);
                    sortList.remove(backIndex);
                    backList = sortList.get(--backIndex);
                }
            }
        }
        return sortList;
    }

    private List<String> findAllGiftCardSkuCode(){
        List<String> skuCodes = new ArrayList<>();
        PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
        List<CommTypeValue> commTypeValues = utilFacade.getCommTypeValuesByType(CommTypeValueVO.TYPE_GIFT_CARD_SKU);
        if(EmptyUtil.isNotEmpty(commTypeValues)){
            for(CommTypeValue value : commTypeValues){
                skuCodes.add(value.getValue());
            }
        }
        return skuCodes;
    }

    private boolean containGiftCardSku(WhCommandPickStockInfoVO pickStockInfo,List<String> giftCardSkuCodes){
        if(EmptyUtil.isEmpty(pickStockInfo.getPreOccupyList())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"预占用未空");
        }
        if(EmptyUtil.isNotEmpty(giftCardSkuCodes)){
            for(WhWmsCommandPreOccupyVO preOccupy : pickStockInfo.getPreOccupyList()){
                if(giftCardSkuCodes.contains(preOccupy.getSkuCode())){
                    return true;
                }
            }
        }
        return false;
    }

    //setp2分离单品单件(根据需要启动的波次数启动,订单留在订单池中)
    //只有留言卡属性为“不需要”的可以启动单品单件
    private void startSingleProductSinglePiece(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                       WhWmsConnectStartCountConfigVO countConfig,
                       WhWmsConnectStartResultVO resultVO){
        Map<String,List<WhCommandPickStockInfoVO>> singleProductSinglePieceMap = new HashMap<>();
        String groupKey = null,skuCodeKey = null,mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        List<String> giftCardSkuCodes = findAllGiftCardSkuCode();
        while(iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            //单品单件或者强制单品单件,且非礼品卡sku
            if(!pickStockInfo.isNeedCard()
                    && pickStockInfo.isSingle()
                    && !containGiftCardSku(pickStockInfo,giftCardSkuCodes)){
                groupKey = computeGroupKey(pickStockInfo,conditions);
                //skuCodeKey = pickStockInfo.getSingleBarcode();
                mixKey = computeMixKey(groupKey,pickStockInfo.getSingleBarcode());
                //单品单件
                List<WhCommandPickStockInfoVO> singleSkuList = getGroupPickList(singleProductSinglePieceMap,mixKey,countConfig.getSingleProductSinglePieceMaxCount());
                singleSkuList.add(pickStockInfo);
                iterator.remove();//移除
                if(singleSkuList.size() == countConfig.getSingleProductSinglePieceMaxCount()){//单品单件-满足上限
                    buildThenCreateConnectInfo(singleSkuList,WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE,resultVO);
                    if(resultVO.isEnough()){
                        return;
                    }
                    //清空
                    singleSkuList.clear();
                }
            }
        }
        //满足下限的也可启动或者制定启动类型
        //不足下限的部分放回订单池
        handleRestPickStockInfo(singleProductSinglePieceMap,resultVO,countConfig,WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE,pickStockInfoList);
    }

    //多品活动订单根据活动信息的设置，寻找固定组合的订单，超过下限即可启动，超过上限拆分波次。仅包含活动商品但总件数>1，也可启动
    //只有留言卡属性为“不需要”的可以启动多品活动,且非礼品卡sku
    private void startMultiPieceActivity(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                                               WhWmsConnectStartCountConfigVO countConfig,
                                               WhWmsConnectStartResultVO resultVO){
        if(EmptyUtil.isEmpty(conditions.getActiveConditions())){
            //无活动
            return;
        }
        Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductActivityMap = new HashMap<>();
        String groupKey = null, activityKey = null,mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        List<String> giftCardSkuCodes = findAllGiftCardSkuCode();
        while(iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            if(!pickStockInfo.isNeedCard()
                    && !containGiftCardSku(pickStockInfo,giftCardSkuCodes) ){
                activityKey = computeActivityKey(pickStockInfo,conditions);
                if(EmptyUtil.isEmpty(activityKey)){
                    continue;
                }
                groupKey = computeGroupKey(pickStockInfo,conditions);
                mixKey = computeMixKey(groupKey,activityKey);
                List<WhCommandPickStockInfoVO> multiProductActivityPickList =
                        getGroupPickList(groupMultiProductActivityMap,mixKey,countConfig.getMultiPieceActivityMaxCount());
                multiProductActivityPickList.add(pickStockInfo);
                iterator.remove();
                if(multiProductActivityPickList.size() == countConfig.getMultiPieceActivityMaxCount()){//多品活动-满足上限
                    buildThenCreateConnectInfo(multiProductActivityPickList,WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY,resultVO);
                    if(resultVO.isEnough()){
                        return;
                    }
                    //清空
                    multiProductActivityPickList.clear();
                }
            }
        }
        //启动满足下限的多品活动或者强制启动多品单件
        String needConnectType = countConfig.getStartConnectType();//暂存启动类型
        if(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(countConfig.getStartConnectType())){
            countConfig.setStartConnectType(WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY);
        }
        handleRestPickStockInfo(groupMultiProductActivityMap,resultVO,countConfig,WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY,pickStockInfoList);
        countConfig.setStartConnectType(needConnectType);
    }

    private List<WhCommandPickStockInfoVO> getGroupPickList(Map<String,List<WhCommandPickStockInfoVO>> groupListMap,String groupKey,Integer defaultSize){
        List<WhCommandPickStockInfoVO> pickList = groupListMap.get(groupKey);
        if(NullUtil.isNull(pickList)){
            if(NullUtil.isNull(defaultSize)){
                pickList = new ArrayList<>();
            }else{
                pickList = new ArrayList<>(defaultSize);
            }
            groupListMap.put(groupKey,pickList);
        }
        return pickList;
    }

    //启动满足下限订单，否则放回订单池
    private void handleRestPickStockInfo(Map<String,List<WhCommandPickStockInfoVO>> groupPickStockInfoMap,
                                         WhWmsConnectStartResultVO resultVO,
                                         WhWmsConnectStartCountConfigVO countConfig,
                                         String startConnectType,
                                         List<WhCommandPickStockInfoVO> pickStockInfoPool){
        Integer minCount = getConnectMinCount(countConfig,startConnectType);
        for(List<WhCommandPickStockInfoVO> groupList : groupPickStockInfoMap.values()){
            if(EmptyUtil.isEmpty(groupList) || NullUtil.isNull(minCount)){
                continue;
            }
            if(groupList.size() >= minCount
                    || (startConnectType.equals(countConfig.getStartConnectType()) && !countConfig.isUseAutoFlow()) ){
                buildThenCreateConnectInfo(groupList,startConnectType,resultVO);
                if(resultVO.isEnough()){
                    return;
                }
            }else{
                if(EmptyUtil.isNotEmpty(groupList)){
                    //不足部分放回订单池
                    pickStockInfoPool.addAll(groupList);
                }
            }
        }
    }


    private Integer getConnectMinCount(WhWmsConnectStartCountConfigVO countConfig,
                                String startConnectType){
        return WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE.equals(startConnectType)?countConfig.getSingleProductSinglePieceMinCount():
                WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(startConnectType)?countConfig.getMultiProductSinglePieceMinCount():
                        WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY.equals(startConnectType)?countConfig.getMultiPieceActivityMinCount():
                                WMSConstants.ConnectType.BULK_ORDER.equals(startConnectType)?countConfig.getMultiProductMultiPieceMinCount():
                                        WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE.equals(startConnectType)?countConfig.getMultiProductMultiPieceMinCount():null;
    }

    //sku必须是单批次
    //A_0001:2:B_0001:3:
    private String computeActivityKey(WhCommandPickStockInfoVO pickStockInfo,WhWmsConnectStartConditionsVO conditions){
        List<WhWmsCommandPreOccupyVO> preOccupyList = pickStockInfo.getPreOccupyList();
        Map<String,Integer> pickSkuQuantityMap = new HashMap<>();//sku数量
        Map<String,Integer> pickBarCodeQuantityMap = new TreeMap<>();//批次数量,必须有序
        Map<String,String> barCodeMap = new HashMap<>();
        for(WhWmsCommandPreOccupyVO preOccupyVO : preOccupyList){
            String barCode = barCodeMap.get(preOccupyVO.getSkuCode());
            if(NullUtil.isNull(barCode)){
                barCodeMap.put(preOccupyVO.getSkuCode(),preOccupyVO.getBarCode());
            }else if(!barCode.equals(preOccupyVO.getBarCode())){
                //sku存在多个barcode
                return null;
            }
            Integer total = pickSkuQuantityMap.get(preOccupyVO.getSkuCode());
            if(NullUtil.isNull(total)){
                total = 0;
            }
            total = total-preOccupyVO.getAmount();
            pickBarCodeQuantityMap.put(preOccupyVO.getBarCode(),total);
            pickSkuQuantityMap.put(preOccupyVO.getSkuCode(),total);//预占用负值
        }
        WhWmsConnectStartActiveConditionVO avaliableActivity = null;
        for(WhWmsConnectStartActiveConditionVO condition : conditions.getActiveConditions()){
            Map<String,Integer> skuQuantityMap = condition.getSkuQuantiyMap();
            int diffSize = pickSkuQuantityMap.size()-skuQuantityMap.size();
            if(diffSize == 0 || diffSize == 1){//sku数量相等或多1
                boolean avaliable = true;
                for(Map.Entry<String,Integer> activeEntry : skuQuantityMap.entrySet()){
                    String skuCode = activeEntry.getKey();
                    Integer activeQuantity = activeEntry.getValue();
                    Integer pickAmount = pickSkuQuantityMap.get(skuCode);
                    if(!activeQuantity.equals(pickAmount)){
                        avaliable = false;
                        break;
                    }
                }
                boolean diffSkuSingle = true;
                if(avaliable && (diffSize == 1)){
                    //检查差异的sku是否是单件
                    for(Map.Entry<String,Integer> pickSkuEntry : pickSkuQuantityMap.entrySet()){
                        if(NullUtil.isNull(skuQuantityMap.get(pickSkuEntry.getKey()))){
                            //差异sku单件
                            if(!pickSkuEntry.getValue().equals(1)){
                                diffSkuSingle = false;
                            }
                            break;
                        }
                    }
                }
                if(avaliable && diffSkuSingle){//发现满足活动
                    avaliableActivity = condition;
                    break;
                }
            }
        }
        if(NullUtil.isNotNull(avaliableActivity)){
            StringBuilder buffer = new StringBuilder();
            for(Map.Entry<String,Integer> pickBarCodeEntry : pickBarCodeQuantityMap.entrySet()){
                buffer.append(pickBarCodeEntry.getKey()).append(splitFlag).append(pickBarCodeEntry.getValue()).append(splitFlag);
            }
            //A_0001:2:B_0001:3:
            return buffer.toString();
        }
        return null;
    }

    //多品多件根据预分配的拣货区域，按拣货区域从少到多进行组合，
    //满足下限即可启动，超过上限拆分波次。
    //例:拣货区域包含A、B、C、AB、AC、BC、ABC时，
    //分组处理顺序如下：
    // ①A
    // ②B
    // ③C
    // ④AB、A、B
    // ⑤AC、A、C
    // ⑥BC、B、C
    // ⑦ABC、AB、AC、BC、A、B、C
    private void startMultiProductMultiPiece(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                       WhWmsConnectStartCountConfigVO countConfig,
                       WhWmsConnectStartResultVO resultVO,boolean ignoreConnectType){
        Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<>();
        Map<Integer,Set<String>> keySizeMap = new TreeMap<>();//区域数量记录，有序(自然排序)
        String groupKey = null, houseTypeKey = null,mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while(iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            //多品多件或者强制多品多件或忽略波次类型
            if(!pickStockInfo.isSingle()
                    || WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE.equals(countConfig.getStartConnectType())
                    || ignoreConnectType){
                groupKey = getGroupKey(pickStockInfo,conditions);
                houseTypeKey = getHouseTypeKey(pickStockInfo);
                mixKey = computeMixKey(groupKey,houseTypeKey);
                Set<String> keySizeSet = keySizeMap.get(pickStockInfo.getPickAreaSize());
                if(NullUtil.isNull(keySizeSet)){
                    keySizeSet = new HashSet<>();
                    keySizeMap.put(pickStockInfo.getPickAreaSize(),keySizeSet);
                }
                keySizeSet.add(mixKey);
                //多品多件
                List<WhCommandPickStockInfoVO> multiPieceMultiPieceList = getGroupPickList(groupMultiProductMultiPieceMap,mixKey,countConfig.getMultiProductMultiPieceMaxCount());
                multiPieceMultiPieceList.add(pickStockInfo);
                if(multiPieceMultiPieceList.size() == countConfig.getMultiProductMultiPieceMaxCount()){
                    //满足上限就启动
                    buildThenCreateConnectInfo(multiPieceMultiPieceList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
                    if(resultVO.isEnough()){
                        return;
                    }
                    multiPieceMultiPieceList.clear();//清除已启动数据
                }
                iterator.remove();//移除
            }
        }
        if(countConfig.isUseAutoFlow()){
            //排列组合取满足条件数据
            combinationThenStartMultiProductMultiPiece(groupMultiProductMultiPieceMap,conditions,countConfig,resultVO,keySizeMap);
            //剩余部分放回订单池
            for(List<WhCommandPickStockInfoVO> list : groupMultiProductMultiPieceMap.values()){
                pickStockInfoList.addAll(list);
            }
        }else{
            mixThenStartMultiProductMultiPiece(groupMultiProductMultiPieceMap,conditions,countConfig,resultVO,pickStockInfoList);
        }

    }

    //无库区组合规则，混合启动
    private void mixThenStartMultiProductMultiPiece(Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap,WhWmsConnectStartConditionsVO conditions,
                                                            WhWmsConnectStartCountConfigVO countConfig,
                                                            WhWmsConnectStartResultVO resultVO,List<WhCommandPickStockInfoVO> poolList){
        String groupKey = null;
        Map<String,List<WhCommandPickStockInfoVO>> groupMap = new HashMap<>();//基础分组Map
        for(List<WhCommandPickStockInfoVO> houseTypePickList : groupMultiProductMultiPieceMap.values()){
            if(EmptyUtil.isEmpty(houseTypePickList)){
                continue;
            }
            WhCommandPickStockInfoVO onePickInfo = houseTypePickList.get(0);
            groupKey = getGroupKey(onePickInfo,conditions);
            List<WhCommandPickStockInfoVO> mixList = getGroupPickList(groupMap,groupKey,countConfig.getMultiProductMultiPieceMaxCount());
            mixList.addAll(houseTypePickList);
            if(mixList.size() >= countConfig.getMultiProductMultiPieceMaxCount()){
                List<WhCommandPickStockInfoVO> needStartList = removeRange(mixList,0,countConfig.getMultiProductMultiPieceMaxCount());//移除启动部分
                buildThenCreateConnectInfo(needStartList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
                if(resultVO.isEnough()){
                    return;
                }
            }
        }
        handleRestPickStockInfo(groupMap,resultVO,countConfig,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,poolList);
    }

    private void combinationThenStartMultiProductMultiPiece(Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap,WhWmsConnectStartConditionsVO conditions,
                                                            WhWmsConnectStartCountConfigVO countConfig,
                                                            WhWmsConnectStartResultVO resultVO,Map<Integer,Set<String>> keySizeMap){
        List<WhCommandPickStockInfoVO> subMultiPieceMultiPieceList = null;
        String subMixKey = null,groupKey = null,houseTypeKey=null;
        for(Map.Entry<Integer,Set<String>> keySizeEntry : keySizeMap.entrySet()){
            Set<String> keySet = keySizeEntry.getValue();
            for(String mixGroupKey : keySet){
                String[] keyParts = mixGroupKey.split(splitAreaFlagRegx);
                groupKey = keyParts[0];
                houseTypeKey = keyParts[1];
                List<String> houseTypeKeyCombination = computeKeyCombination(houseTypeKey.split(splitFlag));
                List<WhCommandPickStockInfoVO> multiPieceMultiPieceList = new ArrayList<>();
                int keyCombinationSize = houseTypeKeyCombination.size();
                String houseTypeKeyItem = null;
                for(int i = 0;i<keyCombinationSize;i++){
                    houseTypeKeyItem = houseTypeKeyCombination.get(i);
                    subMixKey = computeMixKey(groupKey,houseTypeKeyItem);
                    subMultiPieceMultiPieceList = groupMultiProductMultiPieceMap.remove(subMixKey);//获取并清除
                    if(EmptyUtil.isNotEmpty(subMultiPieceMultiPieceList)){
                        multiPieceMultiPieceList.addAll(subMultiPieceMultiPieceList);
                    }
                    if(multiPieceMultiPieceList.size() >= countConfig.getMultiProductMultiPieceMaxCount()
                            || i == keyCombinationSize-1 ){
                        while(true){
                            if(EmptyUtil.isEmpty(multiPieceMultiPieceList)){
                                break;
                            }
                            //数组切割
                            int endIdx = Math.min(multiPieceMultiPieceList.size(),countConfig.getMultiProductMultiPieceMaxCount());
                            //满足上限或无剩余组合且满足下限或无剩余组合且制定波次启动类型
                            if(endIdx >= countConfig.getMultiProductMultiPieceMaxCount()
                                    || (i == keyCombinationSize-1 && endIdx >= countConfig.getMultiProductMultiPieceMinCount())
                                    || (i == keyCombinationSize-1
                                        && WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE.equals(countConfig.getStartConnectType())
                                        && !countConfig.isUseAutoFlow()) ){
                                List<WhCommandPickStockInfoVO> needStartList = removeRange(multiPieceMultiPieceList,0,endIdx);//启动后丢弃
                                buildThenCreateConnectInfo(needStartList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
                                if(resultVO.isEnough()){
                                    return;
                                }
                            }else {
                                break;
                            }
                        }
                    }
                }
                //归还剩余数据
                if(EmptyUtil.isNotEmpty(multiPieceMultiPieceList)){
                    giveUpPickInfo(multiPieceMultiPieceList,conditions,groupMultiProductMultiPieceMap);
                }
            }
        }
    }



    private void giveUpPickInfo(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,final Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap){
        String groupKey = null, houseTypeKey = null,mixKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while(iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            //多品多件或者强制多品多件
            groupKey = getGroupKey(pickStockInfo,conditions);
            houseTypeKey = getHouseTypeKey(pickStockInfo);
            mixKey = computeMixKey(groupKey,houseTypeKey);
            //多品多件
            List<WhCommandPickStockInfoVO> tmpMultiPieceMultiPieceList = groupMultiProductMultiPieceMap.get(mixKey);
            if(EmptyUtil.isEmpty(tmpMultiPieceMultiPieceList)){
                tmpMultiPieceMultiPieceList = new ArrayList<>();
                groupMultiProductMultiPieceMap.put(mixKey,tmpMultiPieceMultiPieceList);
            }
            tmpMultiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();
        }
    }

    private List<WhCommandPickStockInfoVO> removeRange(List<WhCommandPickStockInfoVO> list,int fromIndex,int toIndex){
        List<WhCommandPickStockInfoVO> removedList = new ArrayList<>();
        ListIterator<WhCommandPickStockInfoVO> it = list.listIterator(fromIndex);
        for (int i=0, n=toIndex-fromIndex; i<n; i++) {
            removedList.add(it.next());
            it.remove();
        }
        return removedList;
    }

    private List<String> computeKeyCombination(String[] dataList){
        List<String> keys = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(dataList)){
            List<String[]> collection = combination(dataList);
            for(String[] parts : collection){
                String key = "";
                for(String part : parts){
                    key+=part+splitFlag;
                }
                keys.add(key);
            }
        }
        return keys;
    }

    /**
     * n个组合所有组合
     */
    public static List<String[]> combination(String[] dataList) {
        List<String[]> collection = new ArrayList<>();
        for(int i = dataList.length; i>0; i--){
            collection.addAll(combinationSelect(dataList,i));
        }
        return collection;
    }

    /**
     * 组合选择（从列表中选择n个组合）
     * @param dataList 待选列表
     * @param n 选择个数
     */
    public static List<String[]> combinationSelect(String[] dataList, int n) {
        List<String[]> collection = new ArrayList<>();
        combinationSelect(dataList, 0, new String[n], 0,collection);
        return collection;
    }

    /**
     * 组合选择
     * @param dataList 待选列表
     * @param dataIndex 待选开始索引
     * @param resultList 前面（resultIndex-1）个的组合结果
     * @param resultIndex 选择索引，从0开始
     */
    private static void combinationSelect(String[] dataList, int dataIndex, String[] resultList, int resultIndex,List<String[]> collection){
        int resultLen = resultList.length;
        int resultCount = resultIndex + 1;
        if (resultCount > resultLen) { // 全部选择完时，输出组合结果
            collection.add(Arrays.copyOf(resultList,resultList.length));
            return;
        }
        // 递归选择下一个
        for (int i = dataIndex; i < dataList.length + resultCount - resultLen; i++) {
            resultList[resultIndex] = dataList[i];
            combinationSelect(dataList, i + 1, resultList, resultIndex + 1,collection);
        }
    }

    /**
     * 计算阶乘数，即n! = n * (n-1) * ... * 2 * 1
     * @param n
     * @return
     */
    private static long factorial(int n) {
        return (n > 1) ? n * factorial(n - 1) : 1;
    }

    private String getHouseTypeKey(WhCommandPickStockInfoVO pickStockInfo){
        String houseTypeKey = pickStockInfo.getHouseTypeKey();
        if(EmptyUtil.isEmpty(houseTypeKey)){
            Set<String> pickHouseTypes = pickStockInfo.getPickHouseTypes();
            houseTypeKey = buildPickHouseTypeKey(pickHouseTypes);
            pickStockInfo.setHouseTypeKey(houseTypeKey);
        }
        return houseTypeKey;
    }

    private String buildPickHouseTypeKey(Set<String> pickHouseTypes){
        List<String> sortList = new ArrayList<>();
        sortList.addAll(pickHouseTypes);
        Collections.sort(sortList, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder buffer = new StringBuilder();
        for(String houseType : sortList){
            buffer.append(houseType).append(splitFlag);
        }
        return buffer.toString();
    }


    //组装商品单独分组启动-弃用
    @Deprecated
    private void step0ForAssemble(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartConditionsVO conditions,
                       WhWmsConnectStartCountConfigVO countConfig,
                       WhWmsConnectStartResultVO resultVO){
        Map<String,List<WhCommandPickStockInfoVO>> groupMultiProductMultiPieceMap = new HashMap<>();
        String groupKey = null;
        Iterator<WhCommandPickStockInfoVO> iterator = pickStockInfoList.iterator();
        while (iterator.hasNext()){
            WhCommandPickStockInfoVO pickStockInfo = iterator.next();
            if(!pickStockInfo.isAssemble()){
                continue;
            }
            groupKey = computeGroupKey(pickStockInfo,conditions);
            List<WhCommandPickStockInfoVO> multiPieceMultiPieceList = groupMultiProductMultiPieceMap.get(groupKey);
            if(EmptyUtil.isEmpty(multiPieceMultiPieceList)){
                multiPieceMultiPieceList = new ArrayList<>();
                groupMultiProductMultiPieceMap.put(groupKey,multiPieceMultiPieceList);
            }
            multiPieceMultiPieceList.add(pickStockInfo);
            iterator.remove();//移除
        }
        //全部启动
        for(List<WhCommandPickStockInfoVO> assembleList : groupMultiProductMultiPieceMap.values()){
            List<List<WhCommandPickStockInfoVO>> lists = splitList(assembleList,countConfig.getMultiProductMultiPieceMaxCount());
            for(List<WhCommandPickStockInfoVO> partAssembleList : lists){
                buildThenCreateConnectInfo(partAssembleList,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE,resultVO);
            }

        }
    }


    //Step分离超过商品种类上限和商品数量上限的订单-不包含定制
    //大件包裹
    private void startLargeSizedPackage(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartCountConfigVO countConfig,WhWmsConnectStartResultVO resultVO){
        List<List<WhCommandPickStockInfoVO>> geMinCountList = filterLargeSizedPackage(pickStockInfoList,countConfig);
        for(List<WhCommandPickStockInfoVO> groupList : geMinCountList){
            buildThenCreateConnectInfo(groupList,WMSConstants.ConnectType.LARGE_SIZED_PACKAGE,resultVO);
        }
    }

    //step分离超过商品长宽高和商品体积上限的订单
    private List<List<WhCommandPickStockInfoVO>> filterLargeSizedPackage(List<WhCommandPickStockInfoVO> commandPickStockInfoList,WhWmsConnectStartCountConfigVO countConfigVO){
        Set<String> skuCodes = new HashSet<>();
        for(WhCommandPickStockInfoVO pickStockInfo : commandPickStockInfoList){
            for(WhWmsCommandPreOccupyVO preOccupy : pickStockInfo.getPreOccupyList()){
                skuCodes.add(preOccupy.getSkuCode());
            }
        }
        Map<String,WhWmsShelvesSkuInfoVO> shelvesSkuInfoMap = findWmShelvesSkuInfo(Arrays.asList(skuCodes.toArray(new String[skuCodes.size()])));
        List<List<WhCommandPickStockInfoVO>> groupList =  new ArrayList<>();
        Iterator<WhCommandPickStockInfoVO> iterator = commandPickStockInfoList.iterator();
        WhCommandPickStockInfoVO pickStockInfoVO = null;
        while(iterator.hasNext()){
            pickStockInfoVO = iterator.next();
            if(pickStockInfoVO.isAssemble()){
                continue;
            }
            if(isLargeSizesPackage(pickStockInfoVO,countConfigVO,shelvesSkuInfoMap)){
                //单独启动
                List<WhCommandPickStockInfoVO> singleGroup = new ArrayList<>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                iterator.remove();
            }
        }
        return groupList;
    }

    private boolean isLargeSizesPackage(
            WhCommandPickStockInfoVO pickStockInfo
            ,WhWmsConnectStartCountConfigVO countConfigVO
            ,Map<String,WhWmsShelvesSkuInfoVO> shelvesSkuInfoMap){
        if(NullUtil.isNull(countConfigVO.getSkuMinSingleLength())
                || NullUtil.isNull(countConfigVO.getSkuMinVolume())){
            return false;
        }
        BigDecimal minVolume = new BigDecimal(countConfigVO.getSkuMinVolume());
        minVolume = minVolume.setScale(3, BigDecimal.ROUND_HALF_UP);
        for(WhWmsCommandPreOccupyVO preOccupy : pickStockInfo.getPreOccupyList()){
            WhWmsShelvesSkuInfoVO shelvesSkuInfo = shelvesSkuInfoMap.get(preOccupy.getSkuCode());
            if(NullUtil.isNull(shelvesSkuInfo)){
                continue;
            }

            if(countConfigVO.getSkuMinSingleLength() > 0){
                if(shelvesSkuInfo.getSkuLength() >= countConfigVO.getSkuMinSingleLength()
                        || shelvesSkuInfo.getSkuWidth() >= countConfigVO.getSkuMinSingleLength()
                        || shelvesSkuInfo.getSkuHeight() >= countConfigVO.getSkuMinSingleLength()){
                    return true;
                }
            }
            if(minVolume.compareTo(BigDecimal.ZERO) > 0){
                BigDecimal volumeDecimal = new BigDecimal(shelvesSkuInfo.getSkuLength());
                volumeDecimal = volumeDecimal.multiply(new BigDecimal(shelvesSkuInfo.getSkuWidth()))
                        .multiply(new BigDecimal(shelvesSkuInfo.getSkuHeight()))
                        .divide(new BigDecimal(1000*1000*1000),3,BigDecimal.ROUND_HALF_UP);//转换成立方米
                if(volumeDecimal.compareTo(minVolume) >= 0){
                    return true;
                }
            }

        }
        return false;
    }

    //查询wms sku 信息
    private Map<String,WhWmsShelvesSkuInfoVO> findWmShelvesSkuInfo(List<String> skuCodes){
        Map<String,WhWmsShelvesSkuInfoVO> map = new HashMap<>();
        if(EmptyUtil.isEmpty(skuCodes)){
            return map;
        }
        WhWmsShelvesSkuInfoCond cond = new WhWmsShelvesSkuInfoCond();
        cond.setSkuCodes(skuCodes);
        List<WhWmsShelvesSkuInfoVO> wmsSkuInfoList = whWmsShelvesSkuInfoService.getSkuInfoByCond(cond);
        if(EmptyUtil.isNotEmpty(wmsSkuInfoList)){
            for(WhWmsShelvesSkuInfoVO wmsSkuInfo : wmsSkuInfoList){
                if(NullUtil.isNull(wmsSkuInfo.getSkuWidth())){
                    wmsSkuInfo.setSkuWidth(0f);
                }
                if(NullUtil.isNull(wmsSkuInfo.getSkuHeight())){
                    wmsSkuInfo.setSkuHeight(0f);
                }
                if(NullUtil.isNull(wmsSkuInfo.getSkuLength())){
                    wmsSkuInfo.setSkuLength(0f);
                }
                map.put(wmsSkuInfo.getSkuCode(),wmsSkuInfo);
            }
        }
        return map;
    }

    //Step1分离超过商品种类上限和商品数量上限的订单-不包含定制
    //大宗订单
    private void startGeSkuMinCountOrGeSkuQanitlyMinCount(List<WhCommandPickStockInfoVO> pickStockInfoList,WhWmsConnectStartCountConfigVO countConfig,WhWmsConnectStartResultVO resultVO){
        List<List<WhCommandPickStockInfoVO>> geMinCountList = filterGeMinCount(pickStockInfoList,countConfig);
        for(List<WhCommandPickStockInfoVO> groupList : geMinCountList){
            buildThenCreateConnectInfo(groupList,WMSConstants.ConnectType.BULK_ORDER,resultVO);
        }
    }


    private List<List<WhCommandPickStockInfoVO>> splitList(List<WhCommandPickStockInfoVO> list,int limit){
        List<List<WhCommandPickStockInfoVO>> lists = new ArrayList<>();
        int size = list.size();
        int split = size/limit+1;
        for(int i=0;i<split;i++){
            int begin = i*limit,end = begin+limit;
            if(end>size){
                end = size;
            }
            lists.add(list.subList(begin,end));
        }
        return lists;
    }

    private String computeMixKey(String groupKey ,String houseTypeKey){
        return groupKey+splitAreaFlag+houseTypeKey;
    }

    private String getGroupKey(WhCommandPickStockInfoVO pickStockInfo,WhWmsConnectStartConditionsVO conditions){
        String groupKey = pickStockInfo.getGroupKey();
        if(NullUtil.isNull(groupKey)){
            groupKey = computeGroupKey(pickStockInfo,conditions);
            pickStockInfo.setGroupKey(groupKey);
        }
        return groupKey;
    }


    //skuStatus：渠道：库区：出入库类型:快递类型：组装
    private String computeGroupKey(WhCommandPickStockInfoVO pickStockInfo,WhWmsConnectStartConditionsVO conditions){
        Map<String,String> channelGroupMap = conditions.getChannelGroupMap();
        Map<Long,String> expressGroupMap = conditions.getExpressGroupMap();
        String channelGroupKey = channelGroupMap.get(pickStockInfo.getChannelCode());
        if(NullUtil.isNull(channelGroupKey)){
            channelGroupKey = pickStockInfo.getChannelCode();
        }
        String shelvesAreaKey = NullUtil.isNull(pickStockInfo.getConnectShelveAreaRuleId())?"0":"1";
        String expressGroupKey = expressGroupMap.get(pickStockInfo.getExpressType());
        if(NullUtil.isNull(expressGroupKey)){
            expressGroupKey = pickStockInfo.getExpressType().toString();
        }
        return pickStockInfo.getSkuStatus()+splitFlag
                +channelGroupKey+splitFlag
                +shelvesAreaKey+splitFlag
                +pickStockInfo.getInOutType()+splitFlag
                +expressGroupKey+splitFlag
                +pickStockInfo.isAssemble();
    }

    private String computeShelvesAreaKey(Set<String> pickHouseTypes,List<String> shelvesAreas){
        for(String pickHouseType : pickHouseTypes){
            if(shelvesAreas.contains(pickHouseType)){
                return "1";
            }
        }
        return "0";
    }

    private void buildThenCreateConnectInfo(List<WhCommandPickStockInfoVO> pickStockInfoList,String connectType,WhWmsConnectStartResultVO resultVO){
        WhCommandPickStockInfoVO pickStockInfo = pickStockInfoList.get(0);
        WhWmsConnectInfoVO connectInfo = buildConnectInfo(pickStockInfoList,connectType,pickStockInfo.getSkuStatus(),pickStockInfo.getInOutType(),resultVO.getOperaterId(),resultVO.isAutoDistribute());
        boolean success = createConnectInfo(connectInfo);
        if(!success){
            //启动失败
            resultVO.addFailure(pickStockInfoList);
        }else{
            //减一并记录启动的波次
            resultVO.needAmountAuotDec().startedAmountAuotInc()
                    .addStartConnectInfo(connectInfo);
        }
    }

    private boolean createConnectInfo(WhWmsConnectInfoVO connectInfo){
        try {
            return whWmsConnectInfoService.startConnect(connectInfo);
        }catch (Exception e){
            //启动失败释放预占用
            whWmsCommandPreOccupyService.releasePreOccupy(connectInfo.getWhCommandsCodes());
            return false;
        }
    }

    private WhWmsConnectInfoVO buildConnectInfo(List<WhCommandPickStockInfoVO> pickStockInfoList,String connectType,Integer skuStatus,Integer inOutType,Long operaterId,boolean autoDistribute){
        WhCommandPickStockInfoVO pickStockInfo = pickStockInfoList.get(0);
        WhWmsConnectInfoVO connectInfo = new WhWmsConnectInfoVO();
        connectInfo.setConnectDate(DateUtil.getNow());
        connectInfo.setConnectUserId(NullUtil.isNull(operaterId)?1L:operaterId);
        connectInfo.setConnectType(connectType);
        connectInfo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        connectInfo.setPhysicalWarehouseCode(pickStockInfo.getPhysicalWarehouseCode());
        connectInfo.setSkuStatus(skuStatus);
        connectInfo.setInOutType(inOutType);
        connectInfo.setDistributeStatus(autoDistribute? PegasusConstants.YES:PegasusConstants.NO);
        if(NullUtil.isNull(pickStockInfo.getConnectChannelRuleId())){
            //存在渠道分组是去除渠道号
            connectInfo.setChannelCode(pickStockInfo.getChannelCode());
        }
        connectInfo.setConnectChannelRuleId(pickStockInfo.getConnectChannelRuleId());
        connectInfo.setConnectShelveAreaRuleId(pickStockInfo.getConnectShelveAreaRuleId());
        Set<String> commandCodes = new HashSet<>();
        Map<String,Integer> barCodeShelvesAmountMap = new HashMap<>();
        String key = null;
        Integer total = null;
        for(WhCommandPickStockInfoVO stockInfo : pickStockInfoList){
            commandCodes.add(stockInfo.getCommandCode());
            for(WhWmsCommandPreOccupyVO preOccupy : stockInfo.getPreOccupyList()){
                key = preOccupy.getSkuCode()+splitFlag+preOccupy.getBarCode()+splitFlag+preOccupy.getShelvesCode()+splitFlag+preOccupy.getHouseType();
                total = barCodeShelvesAmountMap.get(key);
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                //占用为负值
                barCodeShelvesAmountMap.put(key,total-preOccupy.getAmount());
            }
        }
        connectInfo.setWhCommandsCodes(Arrays.asList(commandCodes.toArray(new String[commandCodes.size()])));
        //构建拣货数据
        List<WhWmsConnectPickSkuVO> pickSkuList = new ArrayList<>();
        String[] arrs = null;
        for(Map.Entry<String,Integer> entry : barCodeShelvesAmountMap.entrySet()){
            key = entry.getKey();
            arrs = key.split(splitFlag);
            WhWmsConnectPickSkuVO pickSku = new WhWmsConnectPickSkuVO();
            pickSku.setSkuStatus(skuStatus);
            pickSku.setSkuCode(arrs[0]);
            pickSku.setBarCode(arrs[1]);
            pickSku.setShelvesCode(arrs[2]);
            pickSku.setHouseType(arrs[3]);
            pickSku.setNeedAmount(entry.getValue());
            pickSku.setStatus(WhWmsConnectPickSkuVO.STATUS_PENDING);
            pickSkuList.add(pickSku);
        }
        connectInfo.setWhWmsConnectPickSkuVOs(pickSkuList);
        return connectInfo;
    }

    @Override
    public WhWmsCommandPreOccupyCond buildPreOccupyCond(WhWmsConnectStartConditionsVO conditions){
        WhWmsCommandPreOccupyCond preOccupyCond = BeanUtil.buildFrom(conditions.getInOutCondition(),WhWmsCommandPreOccupyCond.class);
        WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition = conditions.getShelvesAreaCondition();
        if(NullUtil.isNotNull(shelvesAreaCondition)){
            if(Boolean.TRUE.equals(shelvesAreaCondition.getInclude())){
                preOccupyCond.setHouseTypes(shelvesAreaCondition.getHouseTypes());
            }else if(Boolean.FALSE.equals(shelvesAreaCondition.getInclude())){
                preOccupyCond.setExcludeHouseTypes(shelvesAreaCondition.getHouseTypes());
            }
        }
        List<WhWmsConnectStartChannelConditionVO> channelConditionList = conditions.getChannelConditions();
        if(EmptyUtil.isNotEmpty(channelConditionList)){
            List<String> channelCodes = new ArrayList<>();
            for(WhWmsConnectStartChannelConditionVO channelCondition : channelConditionList){
                if(EmptyUtil.isNotEmpty(channelCondition.getChannelCodes())){
                    for(String channelCode : channelCondition.getChannelCodes()){
                        channelCodes.add(channelCode);
                    }
                }
            }
            preOccupyCond.setChannelCodes(channelCodes);
        }
        if(EmptyUtil.isNotEmpty(conditions.getSkuStatusList())){
            preOccupyCond.setSkuStatusList(conditions.getSkuStatusList());
        }
        if(NullUtil.isNotNull(conditions.getPlanedDeliveryDate())){
            preOccupyCond.setPlanedDeliveryDateEnd(DateUtil.dayStart(conditions.getPlanedDeliveryDate()));
        }
        return preOccupyCond;
    }

    @Override
    public List<WhCommandPickStockInfoVO> convertPickStockInfoFromPreOccupy(List<WhWmsCommandPreOccupyVO> preOccupyList,
                                                                            WhWmsConnectStartConditionsVO conditions){
        List<WhWmsConnectStartChannelConditionVO> channelConditionList = conditions.getChannelConditions();
        WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition = conditions.getShelvesAreaCondition();
        List<WhCommandPickStockInfoVO> pickStockInfoList = new ArrayList<>();
        if(EmptyUtil.isEmpty(preOccupyList)){
            return pickStockInfoList;
        }
        Map<String,List<WhWmsCommandPreOccupyVO>> commandPreOccupyMap = new HashMap<>();
        //按指令code聚合
        for(WhWmsCommandPreOccupyVO preOccupy : preOccupyList){
            List<WhWmsCommandPreOccupyVO> tmpList = commandPreOccupyMap.get(preOccupy.getCommandCode());
            if(NullUtil.isNull(tmpList)){
                tmpList = new ArrayList<>();
                commandPreOccupyMap.put(preOccupy.getCommandCode(),tmpList);
            }
            tmpList.add(preOccupy);
        }
        String commandCode = null;
        List<WhWmsCommandPreOccupyVO> cmdPreOccupyList = null;
        WhWmsCommandPreOccupyVO preOccupyVO = null;
        Map<String,Integer> skuQuantityMap = new HashMap<>();
        Set<String> houseTypes = null;
        String lastSkuCode = null;
        String lastBarcode = null;
        String lasthouseType = null;
        Map<String,Long> channelRuleMap = new HashMap<>();
        for(WhWmsConnectStartChannelConditionVO condition : channelConditionList){
            if(EmptyUtil.isNotEmpty(condition.getChannelCodes())){
                for(String channelCode : condition.getChannelCodes()){
                    channelRuleMap.put(channelCode,condition.getChannelRuleId());
                }
            }
        }
        for(Map.Entry<String,List<WhWmsCommandPreOccupyVO>> entry : commandPreOccupyMap.entrySet()){
            skuQuantityMap.clear();
            cmdPreOccupyList = entry.getValue();
            preOccupyVO = cmdPreOccupyList.get(0);
            WhCommandPickStockInfoVO pickStockInfoVO = BeanUtil.buildFrom(preOccupyVO,WhCommandPickStockInfoVO.class);
            pickStockInfoVO.setPreOccupyList(cmdPreOccupyList);
            pickStockInfoVO.setEnough(true);
            pickStockInfoVO.setSingle(WhCommand.SINGLE_YES.equals(preOccupyVO.getSingle()));
            pickStockInfoVO.setConnectChannelRuleId(channelRuleMap.get(preOccupyVO.getChannelCode()));
            houseTypes = new HashSet<>();
            for(WhWmsCommandPreOccupyVO preOccupy : cmdPreOccupyList){
                lastSkuCode = preOccupy.getSkuCode();
                lasthouseType = preOccupy.getHouseType();
                lastBarcode = preOccupy.getBarCode();
                Integer total = skuQuantityMap.get(preOccupy.getSkuCode());
                houseTypes.add(preOccupy.getHouseType());
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                //占用为负值
                skuQuantityMap.put(preOccupy.getSkuCode(),total-preOccupy.getAmount());
            }
            if(pickStockInfoVO.isSingle() && !pickStockInfoVO.isNeedCard()){
                pickStockInfoVO.setSingleSkuCode(lastSkuCode);
                pickStockInfoVO.setSingleBarcode(lastBarcode);
            }
            if(pickStockInfoVO.isSingle()){
                pickStockInfoVO.setSingleSkuCode(lastSkuCode);
                pickStockInfoVO.setSingleBarcode(lastBarcode);
                pickStockInfoVO.setSingleHouseType(lasthouseType);
            }
            pickStockInfoVO.setPickHouseTypes(houseTypes);
            pickStockInfoVO.setConnectShelveAreaRuleId(getShelvesAreaRuleId(houseTypes,shelvesAreaCondition));
            pickStockInfoVO.setSkuAmount(skuQuantityMap.size());
            pickStockInfoVO.setSkuMaxQuantity(getMaxValue(skuQuantityMap.values()));
            pickStockInfoList.add(pickStockInfoVO);
        }
        return pickStockInfoList;
    }

    private Long getShelvesAreaRuleId(Set<String> houseTypes,WhWmsConnectStartShelvesAreaConditionVO shelvesAreaCondition){
        if(NullUtil.isNotNull(houseTypes) && !houseTypes.isEmpty()){
            for(String houseType : houseTypes){
                if(EmptyUtil.isNotEmpty(shelvesAreaCondition.getHouseTypes()) && shelvesAreaCondition.getHouseTypes().contains(houseType)){
                    return shelvesAreaCondition.getId();
                }
            }
        }
        return null;
    }

    private List<WhWmsWaitOutStockVO> getWaitOutStock(String physicalWarehouseCode, Integer skuStatus,List<String> commandCodes, boolean fetch){
        List<Integer> inOutTypes = new ArrayList<>();
        inOutTypes.add(WhCommand.TYPE_SALES_OUT);
        inOutTypes.add(WhCommand.TYPE_CHANGE_OUT);
        WhWmsWaitOutStockCond waitOutStockCond = new WhWmsWaitOutStockCond();
        waitOutStockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        waitOutStockCond.setInOutTypeList(inOutTypes);
        waitOutStockCond.setSkuStatus(skuStatus);
        waitOutStockCond.setFetch(fetch);
        waitOutStockCond.setCommandCodes(commandCodes);
        waitOutStockCond.setAutoOccupy(true);
        return whWmsConnectInfoService.findWaitOutStockCommandSaleOutByCond(waitOutStockCond);
    }


    //获取500条待启动指令
    private List<WhWmsWaitOutStockVO> getWaitOutStockToday(String physicalWarehouseCode, Integer skuStatus, boolean fetch){
        Date today = getToday();
        List<Integer> inOutTypes = new ArrayList<>();
        inOutTypes.add(WhCommand.TYPE_SALES_OUT);
        inOutTypes.add(WhCommand.TYPE_CHANGE_OUT);
        WhWmsWaitOutStockCond waitOutStockCond = new WhWmsWaitOutStockCond();
        waitOutStockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        waitOutStockCond.setInOutTypeList(inOutTypes);
        waitOutStockCond.setSkuStatus(skuStatus);
        waitOutStockCond.setFetch(fetch);
        waitOutStockCond.setPlanedDeliveryDateEnd(today);
//        waitOutStockCond.setPlanedDeliveryDateBegin(today);//方便测试
        List<String> excludeSkuCodes = getExcludeSkuCodes();
        if(EmptyUtil.isNotEmpty(excludeSkuCodes)){
            waitOutStockCond.setExcludeSkuCodes(excludeSkuCodes);
        }
        waitOutStockCond.setAutoOccupy(true);
        waitOutStockCond.setCurrpage(1);
        waitOutStockCond.setPagenum(1000);//11.11后改回500
        return whWmsConnectInfoService.findWaitOutStockCommandSaleOutByCond(waitOutStockCond);
    }

    private List<String> getExcludeSkuCodes(){
        List<String> skuCodes = new ArrayList<>();
        PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
        String configValue = utilFacade.findByConfigKey("wms.autoConnect.excludeSku");
        if(EmptyUtil.isNotEmpty(configValue)){
            for(String skuCode : configValue.split(";")){
                skuCodes.add(skuCode);
            }
        }
        return skuCodes;
    }

    private List<WhWmsCommandPreOccupyVO> buildPreOccupy(List<WhCommandPickStockInfoVO> pickStockInfoList){
        List<WhWmsCommandPreOccupyVO> preOccupyList = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(pickStockInfoList)){
            for(WhCommandPickStockInfoVO pickStockInfo : pickStockInfoList){
                buildPreOccupyFromPickStockInfo(pickStockInfo,preOccupyList);
            }
        }
        return preOccupyList;
    }

    private void buildPreOccupyFromPickStockInfo(WhCommandPickStockInfoVO pickStockInfo, List<WhWmsCommandPreOccupyVO> preOccupyList){
        if(!pickStockInfo.isEnough() ||
                EmptyUtil.isEmpty(pickStockInfo.getPickSkuList())){
            return;
        }
        for(WhCommandSkuPickStockInfoVO skuPickStockInfo : pickStockInfo.getPickSkuList()){
            if(EmptyUtil.isNotEmpty(skuPickStockInfo.getStockList())){
                for(WhWmsSkuStockVO skuStock : skuPickStockInfo.getStockList()){
                    WhWmsCommandPreOccupyVO preOccupy = BeanUtil.buildFrom(skuStock,WhWmsCommandPreOccupyVO.class);
                    preOccupy.setCommandCode(pickStockInfo.getCommandCode());
                    preOccupy.setReceiptsNo(skuPickStockInfo.getCode());
                    preOccupy.setCardType(pickStockInfo.getCardType());
                    preOccupy.setPhysicalWarehouseCode(pickStockInfo.getPhysicalWarehouseCode());
                    preOccupy.setAmount(0-preOccupy.getAmount());
                    preOccupy.setStatus(WMSConstants.WMS_OCCUPY_STATUS_IN_USE);
                    preOccupy.setType(WhWmsCommandPreOccupyVO.TYPE_CONNECT);
                    preOccupy.setCardType(pickStockInfo.getCardType());
                    preOccupy.setSingle(pickStockInfo.isSingle()?WhCommand.SINGLE_YES:WhCommand.SINGLE_NO);
                    preOccupyList.add(preOccupy);
                }
            }
        }
    }

    @Override
    public List<WhCommandPickStockInfoVO> computePickStock(String physicalWarehouseCode,Integer skuStatus,List<WhWmsWaitOutStockVO> waitOutCommandList){
        //第一步算出所有sku的计划出库数量
        Map<String,Integer> skuPlanedQuantityMap = computePlanedQuantityMap(waitOutCommandList);
        //第二步查找可用批次号
        List<String> skuCodes = Arrays.asList(skuPlanedQuantityMap.keySet().toArray(new String[skuPlanedQuantityMap.size()]));
        List<WhWmsSkuBarcode> skuBarcodeList = null;
        if(EmptyUtil.isNotEmpty(skuCodes)){
            skuBarcodeList  = whWmsSkuBarcodeService.findBarCodesForPickSkuStock(skuCodes);
        }
        if(NullUtil.isNull(skuBarcodeList)){
            skuBarcodeList = new ArrayList<>();
        }
        Map<String,WhWmsSkuBarcode> barcodeMap = new HashMap<>();
        List<String> barCodes = new ArrayList<>();
        for(WhWmsSkuBarcode barcode : skuBarcodeList){
            barCodes.add(barcode.getBarCode());
            barcodeMap.put(barcode.getBarCode(),barcode);
        }
        //获取普通区
        Map<String,WhWmsWarehouseArea> areaMap = whWmsWarehouseAreaService.getAreaHouseMapByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
        List<String> houseTypes = Arrays.asList(areaMap.keySet().toArray(new String[areaMap.size()]));
        List<WhWmsSkuStockVO> stockList = null;
        if(EmptyUtil.isNotEmpty(barCodes)){
            WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
            stockCond.setPhysicalWarehouseCode(physicalWarehouseCode);
            stockCond.setSkuStatus(skuStatus);
            stockCond.setBarCodeList(barCodes);
            stockCond.setHouseTypes(houseTypes);
            List<Integer> shelvesTypeList = new ArrayList<>();
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);//拣货库位
            shelvesTypeList.add(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING);//保管库位
            stockCond.setShelvesTypeList(shelvesTypeList);
            stockList = whWmsSkuStockService.findWmsSkuAvailableAccountWithPreOccupy(stockCond,true);
        }
        if(NullUtil.isNull(stockList)){
            stockList = new ArrayList<>();
        }
        Set<String> shelvesCodes = new HashSet<>();
        for(WhWmsSkuStockVO skuStock : stockList){
            shelvesCodes.add(skuStock.getShelvesCode());
        }
        Map<String,WhWmsHouseShelves> shelvesMap = whWmsHouseShelvesService
                .getHouseShelvesMapByCode(Arrays.asList(shelvesCodes.toArray(new String[shelvesCodes.size()])));
        //库存过滤
        filterPickStock(stockList,physicalWarehouseCode,shelvesMap);
        //拣货库存排序
        sortStock(stockList,barcodeMap,areaMap,shelvesMap);
        //分配库存
        return distribteStock(physicalWarehouseCode,waitOutCommandList,stockList);
    }


    private void filterPickStock(List<WhWmsSkuStockVO> stockList,String physicalWarehouseCode,Map<String,WhWmsHouseShelves> shelvesMap){
        //如果需要占用的库位库存在补货规则配置的适用库区内&不在补货规则黑名单的类目和sku内，那么只能占用拣货位库存
        if(EmptyUtil.isEmpty(stockList)){
            return;
        }
        WhWmsPreOccupyBlackListInfoVO blackListInfo = findPreOccupyBlackListInfo(physicalWarehouseCode);
        if(NullUtil.isNull(blackListInfo) || !blackListInfo.isOn()){
            //规则不存在或关闭
            return;
        }
        Iterator<WhWmsSkuStockVO> it = stockList.iterator();
        while (it.hasNext()){
            WhWmsSkuStockVO skuShelvesStock = it.next();
            WhWmsHouseShelves shelves = shelvesMap.get(skuShelvesStock.getShelvesCode());
            if(NullUtil.isNull(shelves)){
                it.remove();
            }
            if(!WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING.equals(shelves.getShelvesType())){
                if(blackListInfo.getHouseTypeList().contains(shelves.getHouseType())
                        && !blackListInfo.getSkuCodes().contains(skuShelvesStock.getSkuCode())){
                    it.remove();
                }
            }
        }
    }

    private WhWmsPreOccupyBlackListInfoVO findPreOccupyBlackListInfo(String physicalWarehouseCode){
        WhWmsReplenishRuleVO replenishRule = whWmsReplenishRuleService
                .findWhWmsReplenishRuleVOByPhyCode(physicalWarehouseCode,true,true);
        if(NullUtil.isNull(replenishRule)){
            return null;
        }
        WhWmsPreOccupyBlackListInfoVO blackListInfo = new WhWmsPreOccupyBlackListInfoVO();
        if(NullUtil.isNotNull(replenishRule.getRuleState())
                && PegasusConstants.YES == replenishRule.getRuleState()){
            blackListInfo.setOn(true);
        }
        blackListInfo.setPhysicalWarehouseCode(physicalWarehouseCode);
        //库区
        List<String> houseTypeList = new ArrayList<>();
        blackListInfo.setHouseTypeList(houseTypeList);
        if(EmptyUtil.isNotEmpty(replenishRule.getRuleHousetypeVOs())){
            for(WhWmsReplenishRuleHousetypeVO ruleHousetype : replenishRule.getRuleHousetypeVOs()){
                houseTypeList.add(ruleHousetype.getHouseType());
            }
        }
        //sku
        List<String> skuCodes = new ArrayList<>();
        blackListInfo.setSkuCodes(skuCodes);
        if(EmptyUtil.isNotEmpty(replenishRule.getRuleBlacklistVOs())){
            List<Long> skuSecondCategoryIds = new ArrayList<>();
            for(WhWmsReplenishRuleBlacklistVO blacklist : replenishRule.getRuleBlacklistVOs()){
                if(EmptyUtil.isNotEmpty(blacklist.getSkuCode())){
                    skuCodes.add(blacklist.getSkuCode());
                }
                if(NullUtil.isNull(blacklist.getSecondCategoryId())){
                    skuSecondCategoryIds.add(blacklist.getSecondCategoryId());
                }
            }
            if(EmptyUtil.isNotEmpty(skuSecondCategoryIds)){
                WhWmsReplenishRuleCond cond = new WhWmsReplenishRuleCond();
                cond.setSecondCategoryIds(skuSecondCategoryIds);
                List<WhWmsReplenishRuleVO> skuList = whWmsReplenishRuleService.listPcsSkuVOsByCond(cond);
                if(EmptyUtil.isNotEmpty(skuList)){
                    for(WhWmsReplenishRuleVO sku : skuList){
                        skuCodes.add(sku.getSkuCode());
                    }
                }
            }
        }
        return blackListInfo;
    }

    private List<WhCommandPickStockInfoVO> distribteStock(String physicalWarehouseCode,List<WhWmsWaitOutStockVO> waitOutCommandList,List<WhWmsSkuStockVO> stockList){
        Map<String,List<WhWmsSkuStockVO>> skuStockMap = organizeStock(stockList);
        List<WhCommandPickStockInfoVO> commandPickStockInfoList = new ArrayList<>();
        Map<String,Integer> cmdSkuMap = new HashMap<>();
        for(WhWmsWaitOutStockVO waitOutStockVO : waitOutCommandList){
            boolean allEnough = true;
            cmdSkuMap.clear();
            Map<String,Integer> shortCmdSkuMap = new HashMap<>();//记录缺货数
            WhCommandPickStockInfoVO commandPickStockInfo = new WhCommandPickStockInfoVO();
            commandPickStockInfo.setShortSkuMap(shortCmdSkuMap);
            commandPickStockInfo.setCommandCode(waitOutStockVO.getCode());
            commandPickStockInfo.setPhysicalWarehouseCode(physicalWarehouseCode);
            List<WhCommandSkuPickStockInfoVO> pickStockInfoList = new ArrayList<>();
            commandPickStockInfo.setPickSkuList(pickStockInfoList);
            String lastSkuCode = null;
            String lastHouseType = null;
            for(WhCommandSku commandSku : waitOutStockVO.getWhCommandSkuList()){
                //需计算缺货数
//                if(!allEnough){//存在sku库存不足无需继续
//                    break;
//                }
                lastSkuCode = commandSku.getSkuCode();
                Integer totalQuantity = cmdSkuMap.get(commandSku.getSkuCode());
                if(NullUtil.isNull(totalQuantity)){
                    totalQuantity = 0;
                }
                cmdSkuMap.put(commandSku.getSkuCode(),commandSku.getPlanedQuantity()+totalQuantity);
                WhCommandSkuPickStockInfoVO pickStockInfoVO = new WhCommandSkuPickStockInfoVO();
                pickStockInfoList.add(pickStockInfoVO);
                pickStockInfoVO.setSkuCode(commandSku.getSkuCode());
                pickStockInfoVO.setCode(commandSku.getCode());
                List<WhWmsSkuStockVO> pickStockList = new ArrayList<>();
                pickStockInfoVO.setStockList(pickStockList);
                int needQuantity = commandSku.getPlanedQuantity();
                List<WhWmsSkuStockVO> skuStockList = skuStockMap.get(commandSku.getSkuCode());
                if(EmptyUtil.isNotEmpty(skuStockList)){
                    Iterator<WhWmsSkuStockVO> it = skuStockList.iterator();
                    while(it.hasNext()){
                        if(needQuantity == 0){
                            break;
                        }
                        WhWmsSkuStockVO stockVO = it.next();
                        if(stockVO.getAvailableAccount()<=0){
                            continue;
                        }
                        //拣货区域
                        Set<String> pickHouseTyps = commandPickStockInfo.getPickHouseTypes();
                        if(NullUtil.isNull(pickHouseTyps)){
                            pickHouseTyps = new HashSet<>();
                            commandPickStockInfo.setPickHouseTypes(pickHouseTyps);
                        }
                        lastHouseType = stockVO.getHouseType();
                        pickHouseTyps.add(stockVO.getHouseType());
                        WhWmsSkuStockVO pickStock = BeanUtil.buildFrom(stockVO,WhWmsSkuStockVO.class);
                        pickStock.setReceiptNo(commandSku.getCode());
                        if(stockVO.getAvailableAccount()>needQuantity){
                            pickStock.setAmount(needQuantity);
                            stockVO.setAvailableAccount(stockVO.getAvailableAccount()-needQuantity);
                            needQuantity = 0;
                        }else{
                            pickStock.setAmount(stockVO.getAvailableAccount());
                            needQuantity = needQuantity - stockVO.getAvailableAccount();
                            stockVO.setAvailableAccount(0);
                            it.remove();
                        }
                        pickStockList.add(pickStock);
                    }
                }
                if(needQuantity==0){
                    pickStockInfoVO.setEnough(true);
                }else{//存在Sku库存不足
                    allEnough = false;
                    shortCmdSkuMap.put(commandSku.getSkuCode(),needQuantity);//记录缺货数
                    //库存数据归还
                    giveUpPickStock(skuStockMap,pickStockList);
                }
            }
            commandPickStockInfo.setEnough(allEnough);
            int skuAmount = cmdSkuMap.size();
            commandPickStockInfo.setSkuAmount(skuAmount);
            commandPickStockInfo.setSkuMaxQuantity(getMaxValue(cmdSkuMap.values()));
            commandPickStockInfo.setCardType(waitOutStockVO.getCardType());
            //是否是单件
            if(skuAmount == 1){
                int singleSkuQuantity = cmdSkuMap.get(lastSkuCode);
                if(singleSkuQuantity == 1){
                    commandPickStockInfo.setSingle(true);
                }
                commandPickStockInfo.setSingleSkuCode(lastSkuCode);
                commandPickStockInfo.setSingleHouseType(lastHouseType);
            }
            commandPickStockInfoList.add(commandPickStockInfo);
        }
        return commandPickStockInfoList;
    }

    private void giveUpPickStock(Map<String,List<WhWmsSkuStockVO>> skuStockMap,List<WhWmsSkuStockVO> pickStockList){
        if(EmptyUtil.isNotEmpty(pickStockList)){
            Iterator<WhWmsSkuStockVO> it = pickStockList.iterator();
            WhWmsSkuStockVO pickSkuStock = null;
            while(it.hasNext()){
                pickSkuStock = it.next();
                List<WhWmsSkuStockVO> skuStockList = skuStockMap.get(pickSkuStock.getSkuCode());
                if(EmptyUtil.isEmpty(skuStockList)){
                    skuStockList = new ArrayList<>();
                    skuStockMap.put(pickSkuStock.getSkuCode(),skuStockList);
                    pickSkuStock.setAmount(null);
                    skuStockList.add(pickSkuStock);
                }else {
                    for(WhWmsSkuStockVO skuStock : skuStockList){
                        if(skuStock.getBarCode().equals(pickSkuStock.getBarCode())
                                && skuStock.getShelvesCode().equals(pickSkuStock.getShelvesCode()) ){
                            skuStock.setAvailableAccount(skuStock.getAvailableAccount() + pickSkuStock.getAmount());
                            break;
                        }
                    }
                }
                it.remove();
            }
        }
    }

    private int getMaxValue(Collection<Integer> values){
        int max = 0;
        for(Integer v : values){
            max = Math.max(max,v);
        }
        return max;
    }

    private Map<String,List<WhWmsSkuStockVO>> organizeStock(List<WhWmsSkuStockVO> stockList){
        Map<String,List<WhWmsSkuStockVO>> skuStockMap = new HashMap<>();
        for(WhWmsSkuStockVO skuStockVO : stockList){
            List<WhWmsSkuStockVO> stockInfoList= skuStockMap.get(skuStockVO.getSkuCode());
            if(NullUtil.isNull(stockInfoList)){
                stockInfoList = new ArrayList<>();
                skuStockMap.put(skuStockVO.getSkuCode(),stockInfoList);
            }
            stockInfoList.add(skuStockVO);
        }
        return skuStockMap;
    }


    //效期->活动区->拣货库位->保管库位->数量少的库位v1(弃用)
    //效期->库区顺序->数量少的库位v2
    private void sortStock(List<WhWmsSkuStockVO> stockList
            ,final Map<String,WhWmsSkuBarcode> barcodeMap
            ,final Map<String,WhWmsWarehouseArea> areaMap
            ,final Map<String,WhWmsHouseShelves> shelvesMap){
        Collections.sort(stockList, new Comparator<WhWmsSkuStockVO>() {
            @Override
            public int compare(WhWmsSkuStockVO s1, WhWmsSkuStockVO s2) {
                //比较批次码
                int result = compareBarCode(barcodeMap.get(s1.getBarCode()),barcodeMap.get(s2.getBarCode()));
                if(result == 0){
                    //库区
                    result = compareShelvesArea(areaMap.get(s1.getHouseType()),areaMap.get(s2.getHouseType()));
                    if(result == 0){
                        //库位类型顺序
                        result = compareShelvesType(shelvesMap.get(s1.getShelvesCode()),shelvesMap.get(s2.getShelvesCode()));
                        if(result == 0){
                            //数量
                            result = s1.getAvailableAccount()-s2.getAvailableAccount();
                        }
                    }
                }
                return result;
            }
        });
    }

    private int compareShelvesType(WhWmsHouseShelves s1,WhWmsHouseShelves s2){
        if(NullUtil.isNull(s1.getShelvesType()) && NullUtil.isNull(s2.getShelvesType())){
            return 0;
        }else if(NullUtil.isNull(s1.getShelvesType())){
            return 1;
        }else if(NullUtil.isNull(s2.getShelvesType())){
            return -1;
        }else {
            return s1.getShelvesType().compareTo(s2.getShelvesType());
        }
    }

    private int compareShelvesSortOrder(WhWmsHouseShelves s1,WhWmsHouseShelves s2){
        if(NullUtil.isNull(s1.getSortOrder()) && NullUtil.isNull(s1.getSortOrder())){
            return 0;
        }else if(NullUtil.isNull(s1.getSortOrder())){
            return 1;
        }else if(NullUtil.isNull(s1.getSortOrder())){
            return -1;
        }else {
            return s1.getSortOrder().compareTo(s1.getSortOrder());
        }
    }

    private int compareShelvesArea(WhWmsWarehouseArea a1,WhWmsWarehouseArea a2){
        if(NullUtil.isNull(a1.getSortOrder()) && NullUtil.isNull(a2.getSortOrder())){
            return 0;
        }else if(NullUtil.isNull(a1.getSortOrder())){
            return 1;
        }else if(NullUtil.isNull(a2.getSortOrder())){
            return -1;
        }else {
            return a1.getSortOrder().compareTo(a2.getSortOrder());
        }
    }

    //先进先出:优先出库最早过期的,其次生产日期最早的,再次入库时间最早的
    public int compareBarCode(WhWmsSkuBarcode barcode1,WhWmsSkuBarcode barcode2){
        return whWmsSkuBarcodeService.compareBarCode(barcode1,barcode2);
    }

    private Map<String,Integer> computePlanedQuantityMap(List<WhWmsWaitOutStockVO> waitOutCommandList){
        Map<String,Integer> skuPlanedQuantityMap = new HashMap<>();
        for(WhWmsWaitOutStockVO waitOutStock : waitOutCommandList){
            if(EmptyUtil.isEmpty(waitOutStock.getWhCommandSkuList())){
                continue;
            }
            for(WhCommandSku commandSku : waitOutStock.getWhCommandSkuList()){
                Integer quantity = skuPlanedQuantityMap.get(commandSku.getSkuCode());
                if(NullUtil.isNull(quantity)){
                    quantity = 0;
                }
                if(NullUtil.isNotNull(commandSku.getPlanedQuantity())){
                    skuPlanedQuantityMap.put(commandSku.getSkuCode(),quantity+commandSku.getPlanedQuantity());
                }
            }
        }
        return skuPlanedQuantityMap;
    }

    private List<List<WhCommandPickStockInfoVO>> filterGeMinCount(List<WhCommandPickStockInfoVO> commandPickStockInfoList,WhWmsConnectStartCountConfigVO countConfigVO){
        List<List<WhCommandPickStockInfoVO>> groupList =  new ArrayList<>();
        //step1分离超过商品种类上限和商品数量上限的订单
        Iterator<WhCommandPickStockInfoVO> iterator = commandPickStockInfoList.iterator();
        WhCommandPickStockInfoVO pickStockInfoVO = null;
        while(iterator.hasNext()){
            pickStockInfoVO = iterator.next();
            if(pickStockInfoVO.isAssemble()){
                continue;
            }
            if(!NumberUtil.isNullOrZero(countConfigVO.getSkuMinCount())
                    && countConfigVO.getSkuMinCount() <= pickStockInfoVO.getSkuAmount()){
                //sku数量超过下限，单独启动
                List<WhCommandPickStockInfoVO> singleGroup = new ArrayList<>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                iterator.remove();
                continue;
            }
            if(!NumberUtil.isNullOrZero(countConfigVO.getSkuQanitlyMinCount())
                    && countConfigVO.getSkuQanitlyMinCount()<= pickStockInfoVO.getSkuMaxQuantity()){
                //sku单品数量超过下限，单独启动
                List<WhCommandPickStockInfoVO> singleGroup = new ArrayList<>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                iterator.remove();
            }
        }
        return groupList;
    }

    //
    private void groupPickStockInfoCommands(List<WhCommandPickStockInfoVO> commandPickStockInfoList,WhWmsConnectStartCountConfigVO countConfigVO){
        List<List<WhCommandPickStockInfoVO>> groupList =  new ArrayList<>();
        Map<String,List<WhCommandPickStockInfoVO>> singleProductSinglePieceMap = new HashMap<>();
        List<WhCommandPickStockInfoVO> waitMultiProductMultiPieceList = new ArrayList<>();
        List<WhCommandPickStockInfoVO> multiProductSinglePieceList = new ArrayList<>();
        //step1分离超过商品种类上限和商品数量上限的订单
        //step2分离单品单件、多品多件超出上限部分(根据需要启动的波次数启动,订单留在订单池中)
        //只有留言卡属性为“不需要”的可以启动单品单件，否则全部以多品单件和多品多件的形式启动
        for(WhCommandPickStockInfoVO pickStockInfoVO : commandPickStockInfoList){
            if(!NumberUtil.isNullOrZero(countConfigVO.getSkuMinCount())
                    && countConfigVO.getSkuMinCount() <= pickStockInfoVO.getSkuAmount()){
                //sku数量超过下限，单独启动
                List<WhCommandPickStockInfoVO> singleGroup = new ArrayList<>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                continue;
            }
            if(!NumberUtil.isNullOrZero(countConfigVO.getSkuQanitlyMinCount())
                    && countConfigVO.getSkuQanitlyMinCount()<= pickStockInfoVO.getSkuMaxQuantity()){
                //sku单品数量超过下限，单独启动
                List<WhCommandPickStockInfoVO> singleGroup = new ArrayList<>();
                singleGroup.add(pickStockInfoVO);
                groupList.add(singleGroup);
                continue;
            }
            if(!pickStockInfoVO.isNeedCard()
                    && pickStockInfoVO.getSkuAmount() == 1){
                //单品且不要卡片，聚合到启动上限。例如10个一组
                List<WhCommandPickStockInfoVO> skuGroupList = singleProductSinglePieceMap.get(pickStockInfoVO.getSingleSkuCode());
                if(EmptyUtil.isEmpty(skuGroupList)){
                    skuGroupList = new ArrayList<>();
                    singleProductSinglePieceMap.put(pickStockInfoVO.getSingleSkuCode(),skuGroupList);
                }
                skuGroupList.add(pickStockInfoVO);
                if(skuGroupList.size() == countConfigVO.getSingleProductSinglePieceMaxCount()){
                    //满足单品单件订单数上限，可启动一组
                    groupList.add(skuGroupList);
                    skuGroupList = new ArrayList<>();
                    singleProductSinglePieceMap.put(pickStockInfoVO.getSingleSkuCode(),skuGroupList);
                }
                continue;
            }
            if(pickStockInfoVO.getSkuAmount() == 1){
                //单品且需要卡片，放到多品单批中后续处理
                multiProductSinglePieceList.add(pickStockInfoVO);
                continue;
            }
            if(pickStockInfoVO.getSkuAmount()>1){
                //多品多件,聚合到启动上限。例如10个一组
                waitMultiProductMultiPieceList.add(pickStockInfoVO);
                if(waitMultiProductMultiPieceList.size() == countConfigVO.getMultiProductMultiPieceMaxCount()){
                    //满足多品多件订单数上限，可启动一组
                    groupList.add(waitMultiProductMultiPieceList);
                    waitMultiProductMultiPieceList = new ArrayList<>();
                }
            }
        }
        //单品单件不足部分按多品单批处理
        //step3多品单件按拣货库区包含数量依次启动，不足上限部分从包含数量最少的库区依次补充
        for(List<WhCommandPickStockInfoVO> waitingSingleProductSinglePieceList : singleProductSinglePieceMap.values()){
            multiProductSinglePieceList.addAll(waitingSingleProductSinglePieceList);
        }
        //多品单批按拣货区域数量分组
        Map<String,List<WhCommandPickStockInfoVO>> multiProductSinglePieceMap = new HashMap<>();
        for(WhCommandPickStockInfoVO pickStockInfoVO : multiProductSinglePieceList){
            List<WhCommandPickStockInfoVO> tmpGroupList = multiProductSinglePieceMap.get(pickStockInfoVO.getSingleHouseType());
            if(NullUtil.isNull(tmpGroupList)){
                tmpGroupList = new ArrayList<>();
                multiProductSinglePieceMap.put(pickStockInfoVO.getSingleHouseType(),tmpGroupList);
            }
            tmpGroupList.add(pickStockInfoVO);
            if(tmpGroupList.size() == countConfigVO.getMultiProductSinglePieceMaxCount()){
                //多品单件单个库区，聚合到启动上限。例如10个一组
                groupList.add(tmpGroupList);
                tmpGroupList = new ArrayList<>();
                multiProductSinglePieceMap.put(pickStockInfoVO.getSingleHouseType(),tmpGroupList);
            }
        }
        List<List<WhCommandPickStockInfoVO>> multiProductSinglePieceMultiAreaCanStarList = new ArrayList<>();//多品单件多拣货库区可启动
        List<WhCommandPickStockInfoVO> multiProductSinglePieceMultiAreaWaitingList = new ArrayList<>();//多品单件多拣货库区待启动
        List<List<WhCommandPickStockInfoVO>> multiProductSinglePieceSortList = sortByHouseTypeDesc(multiProductSinglePieceMap.values());
        multiProductSinglePieceGroupByHouseType(multiProductSinglePieceSortList,countConfigVO.getMultiProductSinglePieceMaxCount()
                ,multiProductSinglePieceMultiAreaCanStarList,multiProductSinglePieceMultiAreaWaitingList);
        //Step4波次不足时，单件和多件组合成多品多件波次
        if(EmptyUtil.isNotEmpty(waitMultiProductMultiPieceList)){
            int needSize = countConfigVO.getMultiProductMultiPieceMaxCount()-waitMultiProductMultiPieceList.size();
            int avaliableSize = multiProductSinglePieceMultiAreaWaitingList.size();
            if(needSize>=avaliableSize){
                waitMultiProductMultiPieceList.addAll(multiProductSinglePieceMultiAreaWaitingList);
                multiProductSinglePieceMultiAreaWaitingList.clear();
            }else{
                waitMultiProductMultiPieceList.addAll(multiProductSinglePieceMultiAreaWaitingList.subList(0,needSize));//补齐
                multiProductSinglePieceMultiAreaWaitingList = multiProductSinglePieceMultiAreaWaitingList.subList(needSize,avaliableSize);
            }
        }
        //剩余未分配
        List<WhCommandPickStockInfoVO> waittingList = new ArrayList<>();
        int waitMultiProductMultiPieceCount = waitMultiProductMultiPieceList.size();
        if( waitMultiProductMultiPieceCount > 0 && waitMultiProductMultiPieceCount < countConfigVO.getMultiProductMultiPieceMaxCount()){
            waittingList.addAll(waitMultiProductMultiPieceList);
        }
        int waitMultiProductSinglePieceCount = multiProductSinglePieceMultiAreaWaitingList.size();
        if(waitMultiProductSinglePieceCount > 0 && waitMultiProductSinglePieceCount < countConfigVO.getMultiProductMultiPieceMaxCount()){
            waittingList.addAll(multiProductSinglePieceMultiAreaWaitingList);
        }

    }



    //数量少的库区向数量多点库区补充
    private void multiProductSinglePieceGroupByHouseType(List<List<WhCommandPickStockInfoVO>> sortList,int limit
            ,List<List<WhCommandPickStockInfoVO>> canStartList,List<WhCommandPickStockInfoVO> waitList){
        int size = sortList.size();
        int beforIndex = 0,backIndex = size-1;
        List<WhCommandPickStockInfoVO> beforeList = sortList.get(beforIndex);
        List<WhCommandPickStockInfoVO> backList = sortList.get(backIndex);
        while(beforIndex < backIndex){
            int needSize = limit - beforeList.size();
            int avaliableSize = backList.size();
            if(avaliableSize>=needSize){
                beforeList.addAll(backList.subList(0,needSize));
                canStartList.add(beforeList);//满足上限可启动
                backList = backList.subList(needSize,avaliableSize);
                beforeList = sortList.get(++beforIndex);
            }else{
                beforeList.addAll(backList);
                sortList.remove(backIndex);
                backList = sortList.get(--backIndex);
            }
        }
        if(EmptyUtil.isNotEmpty(beforeList)){//不足部分
            waitList.addAll(beforeList);
        }
    }

    //按照单数数量降序排序
    private List<List<WhCommandPickStockInfoVO>> sortByHouseTypeDesc(Collection<List<WhCommandPickStockInfoVO>> collections){
        List<List<WhCommandPickStockInfoVO>> list = new ArrayList<>();
        for(List<WhCommandPickStockInfoVO> voList : collections){
            if(voList.isEmpty()){
                continue;
            }
            list.add(voList);
        }
        Collections.sort(list, new Comparator<List<WhCommandPickStockInfoVO>>() {
            @Override
            public int compare(List<WhCommandPickStockInfoVO> o1, List<WhCommandPickStockInfoVO> o2) {
                return o1.size()-o2.size();
            }
        });
        return list;
    }

    private Map<String,List<WhCommandPickStockInfoVO>> groupCommandByConnectStartShelvesAreaRule(List<WhCommandPickStockInfoVO> commandPickStockInfoList
            ,WhWmsConnectStartRuleVO shelvesAreaRule){
        Map<String,List<WhCommandPickStockInfoVO>> shelvesAreaGroupMap = new HashMap<>();
        boolean shelvesAreaRuleExist = true;
        if(NullUtil.isNull(shelvesAreaRule)
                || EmptyUtil.isEmpty(shelvesAreaRule.getDetails())){
            //库位规则不存在
            shelvesAreaRuleExist = false;
        }
        Set<String> shelvesAreaSet = new HashSet<>();
        for(WhWmsConnectStartRuleDetailVO shelvesArea : shelvesAreaRule.getDetails()){
            shelvesAreaSet.add(shelvesArea.getValue());
        }
        for(WhCommandPickStockInfoVO pickStockInfoVO : commandPickStockInfoList){
            if(!pickStockInfoVO.isEnough()){//库存不足
                List<WhCommandPickStockInfoVO> shortList = shelvesAreaGroupMap.get(shortKey);
                if(NullUtil.isNull(shortList)){
                    shortList = new ArrayList<>();
                    shelvesAreaGroupMap.put(shortKey,shortList);
                }
                shortList.add(pickStockInfoVO);
                continue;
            }
            if(shelvesAreaRuleExist && shelvesAreaSet.containsAll(pickStockInfoVO.getPickHouseTypes())){
                //在库区规则区域中
                List<WhCommandPickStockInfoVO> tmpList = shelvesAreaGroupMap.get(shelvesAreaRuleKey);
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    shelvesAreaGroupMap.put(shelvesAreaRuleKey,tmpList);
                }
                tmpList.add(pickStockInfoVO);
            }else{
                //不在在库区规则区域中
                List<WhCommandPickStockInfoVO> tmpList = shelvesAreaGroupMap.get(noShelvesAreaRuleKey);
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    shelvesAreaGroupMap.put(noShelvesAreaRuleKey,tmpList);
                }
                tmpList.add(pickStockInfoVO);
            }
        }
        return shelvesAreaGroupMap;
    }

    private Date getToday(){
        Date now = DateUtil.getNow();
        return DateUtil.dayStart(now);
    }
}
