package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartRuleAssignMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartRuleDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartRuleService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleAssignVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartRuleVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created by Administrator on 2017/8/3.
 */
@Service("WhWmsConnectStartRuleService")
public class WhWmsConnectStartRuleServiceImpl implements WhWmsConnectStartRuleService {

    @Autowired
    private WhWmsConnectStartRuleMapper whWmsConnectStartRuleMapper;

    @Autowired
    private WhWmsConnectStartRuleDetailMapper whWmsConnectStartRuleDetailMapper;

    @Autowired
    private WhWmsConnectStartRuleAssignMapper whWmsConnectStartRuleAssignMapper;

    @Override
    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType) {
        return findConnectStartRule(physicalWarehouseCode,ruleType,true);
    }

    @Override
    public List<WhWmsConnectStartRuleVO> findConnectStartRule(String physicalWarehouseCode, Integer ruleType, Boolean enableOrNot) {
        WhWmsConnectStartRuleExample ruleExample = new WhWmsConnectStartRuleExample();
        WhWmsConnectStartRuleExample.Criteria ruleCriteria = ruleExample.createCriteria();
        ruleCriteria.andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode)
                .andTypeEqualTo(ruleType);
        if(Boolean.TRUE.equals(enableOrNot)){
            ruleCriteria.andEnableEqualTo(PegasusConstants.YES);
        }else if(Boolean.FALSE.equals(enableOrNot)){
            ruleCriteria.andEnableEqualTo(PegasusConstants.NO);
        }
        List<WhWmsConnectStartRule> list = whWmsConnectStartRuleMapper.selectByExample(ruleExample);
        List<WhWmsConnectStartRuleVO> ruleList = BeanUtil.buildListFrom(list,WhWmsConnectStartRuleVO.class);
        fullCascadeInfo(ruleList);
        return ruleList;
    }

    @Override
    public WhWmsConnectStartRuleVO findConnectStartRule(Long ruleId, boolean cascade) {
        WhWmsConnectStartRule rule = whWmsConnectStartRuleMapper.selectByPrimaryKey(ruleId);
        if(NullUtil.isNotNull(rule) && cascade){
            WhWmsConnectStartRuleVO ruleVO = BeanUtil.buildFrom(rule,WhWmsConnectStartRuleVO.class);
            fullCascadeInfo(Collections.singletonList(ruleVO));
            return ruleVO;
        }
        return null;
    }

    private void fullCascadeInfo(List<WhWmsConnectStartRuleVO> ruleList){
        if(EmptyUtil.isNotEmpty(ruleList)){
            List<Long> ruleIdList = new ArrayList<>();
            for(WhWmsConnectStartRuleVO ruleVO : ruleList){
                ruleIdList.add(ruleVO.getId());
            }
            Map<Long,List<WhWmsConnectStartRuleDetailVO>> detailsMap = getDetailsMap(ruleIdList);
            Map<Long,List<WhWmsConnectStartRuleAssignVO>> assignedOperatersMap = getAssignedOperatersMap(ruleIdList);
            for(WhWmsConnectStartRuleVO ruleVO : ruleList){
                ruleVO.setDetails(detailsMap.get(ruleVO.getId()));
                ruleVO.setAssignedOperaters(assignedOperatersMap.get(ruleVO.getId()));
            }
        }
    }

    @Override
    @Transactional
    public boolean saveConnectStartRule(WhWmsConnectStartRuleVO startRuleVO) {
        checkRuleName(startRuleVO);

        if(NullUtil.isNotNull(startRuleVO.getId())){
            //编辑
            return updateConnectStartRule(startRuleVO);
        }else {
            //新增
            return addConnectStartRule(startRuleVO);
        }
    }

    @Override
    @Transactional
    public boolean saveConnectStartRuleForChannel(WhWmsConnectStartRuleVO startRuleVO) {
        startRuleVO.setType(WhWmsConnectStartRuleVO.TYPE_CHANNEL);
        startRuleVO.setEnable(PegasusConstants.YES);
        try{
            return saveConnectStartRule(startRuleVO);
        }catch(DuplicateKeyException e){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"存在渠道已编辑");
        }
    }

    @Override
    @Transactional
    public boolean saveConnectStartRuleForShelvesArea(WhWmsConnectStartRuleVO shelvesAreaRuleVO) {
        shelvesAreaRuleVO.setType(WhWmsConnectStartRuleVO.TYPE_WAREHOUSE_AREA);
        shelvesAreaRuleVO.setEnable(PegasusConstants.YES);
        if(NullUtil.isNull(shelvesAreaRuleVO.getId())){
            List<WhWmsConnectStartRuleVO> list = findConnectStartRule(shelvesAreaRuleVO.getPhysicalWarehouseCode(),WhWmsConnectStartRuleVO.TYPE_WAREHOUSE_AREA);
            if(EmptyUtil.isNotEmpty(list)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"库区规则只能有一个");
            }
        }
        try{
            return saveConnectStartRule(shelvesAreaRuleVO);
        }catch(DuplicateKeyException e){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"存在库区已编辑");
        }
    }

    @Override
    @Transactional
    public boolean delConnectStartRule(Long startRuleId) {
        WhWmsConnectStartRule record = new WhWmsConnectStartRule();
        record.setId(startRuleId);
        record.setEnable(PegasusConstants.NO);
        whWmsConnectStartRuleMapper.updateByPrimaryKeySelective(record);
//        boolean success = whWmsConnectStartRuleMapper.deleteByPrimaryKey(startRuleId)==1;
//        if(!success){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"已删除");
//        }
//        delConnectStartRuleDetail(startRuleId);
//        delConnectStartRuleAssignOperater(startRuleId);
        return true;
    }

    private void checkRuleName(WhWmsConnectStartRuleVO ruleVO){
        WhWmsConnectStartRuleExample ruleExample = new WhWmsConnectStartRuleExample();
        WhWmsConnectStartRuleExample.Criteria criteria = ruleExample.createCriteria();
        if(NullUtil.isNotNull(ruleVO.getId())){
            criteria.andIdNotEqualTo(ruleVO.getId());
        }
        criteria.andTypeEqualTo(ruleVO.getType()).andNameEqualTo(ruleVO.getName())
                .andEnableEqualTo(PegasusConstants.YES);//软删除
        int count = whWmsConnectStartRuleMapper.countByExample(ruleExample);
        if(count>0){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"规则名称重复");
        }
        //检查明细是否冲突
        List<WhWmsConnectStartRuleVO> ruleList = findConnectStartRule(ruleVO.getPhysicalWarehouseCode(),ruleVO.getType());
        if(EmptyUtil.isNotEmpty(ruleList)){
            List<String> otherDetails = new ArrayList<>();
            for(WhWmsConnectStartRuleVO rule : ruleList){
                if(!rule.getId().equals(ruleVO.getId())
                        && EmptyUtil.isNotEmpty(rule.getDetails())){
                    for(WhWmsConnectStartRuleDetailVO detail : rule.getDetails()){
                        otherDetails.add(detail.getValue());
                    }
                }
            }
            if(EmptyUtil.isNotEmpty(ruleVO.getDetails())){
                for(WhWmsConnectStartRuleDetailVO detail : ruleVO.getDetails()){
                    if(otherDetails.contains(detail.getValue())){
                        if(WhWmsConnectStartRuleVO.TYPE_CHANNEL.equals(ruleVO.getType())){
                            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]渠道已编辑",detail.getValue()));
                        }else {
                            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]库区已编辑",detail.getValue()));
                        }

                    }
                }
            }
        }
    }

    private boolean addConnectStartRule(WhWmsConnectStartRuleVO startRuleVO){
        whWmsConnectStartRuleMapper.insert(startRuleVO);
        if(EmptyUtil.isNotEmpty(startRuleVO.getDetails())){
            for(WhWmsConnectStartRuleDetailVO detailVO : startRuleVO.getDetails()){
                detailVO.setRuleId(startRuleVO.getId());
                detailVO.setPhysicalWarehouseCode(startRuleVO.getPhysicalWarehouseCode());
                whWmsConnectStartRuleDetailMapper.insert(detailVO);
            }
        }
        if(EmptyUtil.isNotEmpty(startRuleVO.getAssignedOperaters())){
            for(WhWmsConnectStartRuleAssignVO assignVO : startRuleVO.getAssignedOperaters()){
                assignVO.setRuleId(startRuleVO.getId());
                whWmsConnectStartRuleAssignMapper.insert(assignVO);
            }
        }
        return true;
    }

    private boolean updateConnectStartRule(WhWmsConnectStartRuleVO startRuleVO){
        whWmsConnectStartRuleMapper.updateByPrimaryKey(startRuleVO);
        delConnectStartRuleDetail(startRuleVO.getId());
        if(EmptyUtil.isNotEmpty(startRuleVO.getDetails())){
            for(WhWmsConnectStartRuleDetailVO detailVO : startRuleVO.getDetails()){
                detailVO.setRuleId(startRuleVO.getId());
                detailVO.setPhysicalWarehouseCode(startRuleVO.getPhysicalWarehouseCode());
                whWmsConnectStartRuleDetailMapper.insert(detailVO);
            }
        }
        delConnectStartRuleAssignOperater(startRuleVO.getId());
        if(EmptyUtil.isNotEmpty(startRuleVO.getAssignedOperaters())){
            for(WhWmsConnectStartRuleAssignVO assignVO : startRuleVO.getAssignedOperaters()){
                assignVO.setRuleId(startRuleVO.getId());
                whWmsConnectStartRuleAssignMapper.insert(assignVO);
            }
        }
        return true;
    }

    private boolean delConnectStartRuleDetail(Long startRuleId){
        WhWmsConnectStartRuleDetailExample detailExample = new WhWmsConnectStartRuleDetailExample();
        detailExample.createCriteria().andRuleIdEqualTo(startRuleId);
        whWmsConnectStartRuleDetailMapper.deleteByExample(detailExample);
        return true;
    }

    private boolean delConnectStartRuleAssignOperater(Long startRuleId){
        WhWmsConnectStartRuleAssignExample assignExample = new WhWmsConnectStartRuleAssignExample();
        assignExample.createCriteria().andRuleIdEqualTo(startRuleId);
        whWmsConnectStartRuleAssignMapper.deleteByExample(assignExample);
        return true;
    }

    private Map<Long,List<WhWmsConnectStartRuleDetailVO>> getDetailsMap(List<Long> ruleIdList){
        Map<Long,List<WhWmsConnectStartRuleDetailVO>> detailsMap = new HashMap<>();
        WhWmsConnectStartRuleDetailExample detailExample = new WhWmsConnectStartRuleDetailExample();
        detailExample.createCriteria().andRuleIdIn(ruleIdList);
        List<WhWmsConnectStartRuleDetail> detailList = whWmsConnectStartRuleDetailMapper.selectByExample(detailExample);
        if(EmptyUtil.isNotEmpty(detailList)){
            for(WhWmsConnectStartRuleDetail detail : detailList){
                List<WhWmsConnectStartRuleDetailVO> detailVOList = detailsMap.get(detail.getRuleId());
                if(NullUtil.isNull(detailVOList)){
                    detailVOList = new ArrayList<>();
                    detailsMap.put(detail.getRuleId(),detailVOList);
                }
                detailVOList.add(BeanUtil.buildFrom(detail,WhWmsConnectStartRuleDetailVO.class));
            }
        }
        return detailsMap;
    }

    private Map<Long,List<WhWmsConnectStartRuleAssignVO>> getAssignedOperatersMap(List<Long> ruleIdList){
        Map<Long,List<WhWmsConnectStartRuleAssignVO>> map = new HashMap<>();
        WhWmsConnectStartRuleAssignExample example = new WhWmsConnectStartRuleAssignExample();
        example.createCriteria().andRuleIdIn(ruleIdList);
        List<WhWmsConnectStartRuleAssign> list = whWmsConnectStartRuleAssignMapper.selectByExample(example);
        List<WhWmsConnectStartRuleAssignVO> voList = BeanUtil.buildListFrom(list,WhWmsConnectStartRuleAssignVO.class);
        if(EmptyUtil.isNotEmpty(voList)){
            for(WhWmsConnectStartRuleAssignVO vo : voList){
                List<WhWmsConnectStartRuleAssignVO> tmpList = map.get(vo.getRuleId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(vo.getRuleId(),tmpList);
                }
                tmpList.add(vo);
            }
        }
        return map;
     }
}
