package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartForbideRuleDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartForbideRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRule;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRuleDetail;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRuleDetailExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartForbideRuleExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartForbideRuleService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartForbideRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartForbideRuleVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.web.util.ecp.EcpDeliveryReceipt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created by Administrator on 2017/8/3.
 */
@Service("whWmsConnectStartForbideRuleService")
public class WhWmsConnectStartForbideRuleServiceImpl implements WhWmsConnectStartForbideRuleService {

    @Autowired
    private WhWmsConnectStartForbideRuleMapper whWmsConnectStartForbideRuleMapper;

    @Autowired
    private WhWmsConnectStartForbideRuleDetailMapper whWmsConnectStartForbideRuleDetailMapper;

    @Override
    public List<WhWmsConnectStartForbideRuleVO> findConnectStartForbideRule(String physicalWarehouseCode, boolean cascade) {
        WhWmsConnectStartForbideRuleExample example = new WhWmsConnectStartForbideRuleExample();
        example.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode);
        List<WhWmsConnectStartForbideRule> list = whWmsConnectStartForbideRuleMapper.selectByExample(example);
        List<WhWmsConnectStartForbideRuleVO> forbideRuleVOList = BeanUtil.buildListFrom(list,WhWmsConnectStartForbideRuleVO.class);
        if(cascade && EmptyUtil.isNotEmpty(forbideRuleVOList)){
            List<Long> forbideRuleIdList = new ArrayList<>();
            for(WhWmsConnectStartForbideRuleVO forbideRuleVO : forbideRuleVOList){
                forbideRuleIdList.add(forbideRuleVO.getId());
            }
            Map<Long,List<WhWmsConnectStartForbideRuleDetailVO>> detailsMap = getDetailsMap(forbideRuleIdList);
            for(WhWmsConnectStartForbideRuleVO forbideRuleVO : forbideRuleVOList){
                forbideRuleVO.setDetails(detailsMap.get(forbideRuleVO.getId()));
            }
        }
        return forbideRuleVOList;
    }

    @Override
    public WhWmsConnectStartForbideRuleVO findConnectStartForbideRule(Long forbideRuleId, boolean cascade) {
        WhWmsConnectStartForbideRule forbideRule = whWmsConnectStartForbideRuleMapper.selectByPrimaryKey(forbideRuleId);
        WhWmsConnectStartForbideRuleVO forbideRuleVO = BeanUtil.buildFrom(forbideRule,WhWmsConnectStartForbideRuleVO.class);
        if(NullUtil.isNotNull(forbideRuleVO) && cascade){
            Map<Long,List<WhWmsConnectStartForbideRuleDetailVO>> detailsMap
                    = getDetailsMap(Collections.singletonList(forbideRuleVO.getId()));
            forbideRuleVO.setDetails(detailsMap.get(forbideRuleVO.getId()));
        }
        return forbideRuleVO;
    }

    @Override
    @Transactional
    public boolean saveConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO) {
        if(NullUtil.isNull(forbideRuleVO.getId())){
            return addConnectStartForbideRule(forbideRuleVO);
        }else {
            return updateConnectStartForbideRule(forbideRuleVO);
        }
    }

    @Override
    @Transactional
    public boolean enableDisableConnectStartForbideRule(Long forbideRuleId, Integer enableOrDisable) {
        WhWmsConnectStartForbideRule update = new WhWmsConnectStartForbideRule();
        update.setId(forbideRuleId);
        update.setEnable(enableOrDisable);
        whWmsConnectStartForbideRuleMapper.updateByPrimaryKeySelective(update);
        return true;
    }

    @Override
    @Transactional
    public void disableExpireConnectStartForbideRule() {
        whWmsConnectStartForbideRuleMapper.disableExpireConnectStartForbideRule();
    }

    private boolean addConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO){
        whWmsConnectStartForbideRuleMapper.insert(forbideRuleVO);
        if(EmptyUtil.isNotEmpty(forbideRuleVO.getDetails())){
            for(WhWmsConnectStartForbideRuleDetailVO detailVO : forbideRuleVO.getDetails()){
                detailVO.setForbideRuleId(forbideRuleVO.getId());
                whWmsConnectStartForbideRuleDetailMapper.insert(detailVO);
            }
        }
        return true;
    }

    private boolean updateConnectStartForbideRule(WhWmsConnectStartForbideRuleVO forbideRuleVO){
        whWmsConnectStartForbideRuleMapper.updateByPrimaryKey(forbideRuleVO);
        delConnectStartForbideRuleDetail(forbideRuleVO.getId());
        if(EmptyUtil.isNotEmpty(forbideRuleVO.getDetails())){
            for(WhWmsConnectStartForbideRuleDetailVO detailVO : forbideRuleVO.getDetails()){
                detailVO.setForbideRuleId(forbideRuleVO.getId());
                whWmsConnectStartForbideRuleDetailMapper.insert(detailVO);
            }
        }
        return true;
    }

    private boolean delConnectStartForbideRuleDetail(Long forbideRuleId){
        WhWmsConnectStartForbideRuleDetailExample example = new WhWmsConnectStartForbideRuleDetailExample();
        example.createCriteria().andForbideRuleIdEqualTo(forbideRuleId);
        whWmsConnectStartForbideRuleDetailMapper.deleteByExample(example);
        return true;
    }

    private Map<Long,List<WhWmsConnectStartForbideRuleDetailVO>> getDetailsMap(List<Long> forbideRuleIdList){
        Map<Long,List<WhWmsConnectStartForbideRuleDetailVO>> map = new HashMap<>();
        WhWmsConnectStartForbideRuleDetailExample example = new WhWmsConnectStartForbideRuleDetailExample();
        example.createCriteria().andForbideRuleIdIn(forbideRuleIdList);
        List<WhWmsConnectStartForbideRuleDetail> list = whWmsConnectStartForbideRuleDetailMapper.selectByExample(example);
        if(EmptyUtil.isNotEmpty(list)){
            List<WhWmsConnectStartForbideRuleDetailVO> detailVOList = BeanUtil.buildListFrom(list,WhWmsConnectStartForbideRuleDetailVO.class);
            for(WhWmsConnectStartForbideRuleDetailVO detailVO : detailVOList){
                List<WhWmsConnectStartForbideRuleDetailVO> tmpList = map.get(detailVO.getForbideRuleId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(detailVO.getForbideRuleId(),tmpList);
                }
                tmpList.add(detailVO);
            }
        }
        return map;
    }
}
