package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartDurationMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartDuration;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartDurationExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartDurationService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectStartDurationVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2017/8/3.
 */
@Service("whWmsConnectStartDurationService")
public class WhWmsConnectStartDurationServiceImpl implements WhWmsConnectStartDurationService {

    @Autowired
    private WhWmsConnectStartDurationMapper whWmsConnectStartDurationMapper;

    @Override
    public List<WhWmsConnectStartDurationVO> findConnectStartDuration(String physicalWarehouseCode) {
        WhWmsConnectStartDurationExample durationExample = new WhWmsConnectStartDurationExample();
        durationExample.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode);
        durationExample.setOrderByClause(" BEGIN_TIME asc");
        List<WhWmsConnectStartDuration> list = whWmsConnectStartDurationMapper.selectByExample(durationExample);
        return BeanUtil.buildListFrom(list,WhWmsConnectStartDurationVO.class);
    }

    @Override
    public WhWmsConnectStartDurationVO findConnectStartDuration(Long startDurationId) {
        WhWmsConnectStartDuration duration = whWmsConnectStartDurationMapper.selectByPrimaryKey(startDurationId);
        return BeanUtil.buildFrom(duration,WhWmsConnectStartDurationVO.class);
    }

    @Override
    @Transactional
    public boolean saveConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO) {
        checkTime(startDurationVO);
        if(NullUtil.isNull(startDurationVO.getId())){
            startDurationVO.setEnable(PegasusConstants.YES);
            return addConnectStartDuration(startDurationVO);
        }else {
            WhWmsConnectStartDurationVO old = findConnectStartDuration(startDurationVO.getId());
            startDurationVO.setEnable(old.getEnable());
            return updateConnectStartDuration(startDurationVO);
        }
    }

    private boolean addConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO){
        whWmsConnectStartDurationMapper.insert(startDurationVO);
        return true;
    }

    private boolean updateConnectStartDuration(WhWmsConnectStartDurationVO startDurationVO){
        whWmsConnectStartDurationMapper.updateByPrimaryKey(startDurationVO);
        return true;
    }

    @Override
    @Transactional
    public boolean delConnectStartDuration(Long startDurationId) {
        boolean success = whWmsConnectStartDurationMapper.deleteByPrimaryKey(startDurationId) == 1;
        if(!success){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"已删除");
        }
        return success;
    }

    //检查时间是否有重叠
    private void checkTime(WhWmsConnectStartDurationVO startDurationVO){
        List<WhWmsConnectStartDurationVO> list = findConnectStartDuration(startDurationVO.getPhysicalWarehouseCode());
        Date beginDateTime = getDateTime(startDurationVO.getBeginTime());
        Date endDateTime = getDateTime(startDurationVO.getEndTime());
        if(beginDateTime.compareTo(endDateTime)>0){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"截止时间不能小于开始时间");
        }
        if(EmptyUtil.isNotEmpty(list)){
            Date beginTime2 = null,endTime2 = null;
            for(WhWmsConnectStartDurationVO item : list){
                if(item.getId().equals(startDurationVO.getId())){
                    continue;
                }
                beginTime2 = getDateTime(item.getBeginTime());
                endTime2 = getDateTime(item.getEndTime());
                if(beginDateTime.compareTo(endTime2)<=0
                        && endDateTime.compareTo(beginTime2)>=0){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("已存在[%s~%s]的规则中包含重复的时间段"
                            ,DateUtil.format(beginTime2,DateUtil.DEFAULT_TIME_FORMAT)
                            ,DateUtil.format(endTime2,DateUtil.DEFAULT_TIME_FORMAT)));
                }
            }
        }
    }

    private Date getDateTime(Date date){
        return  DateUtil.parse(DateUtil.format(date,DateUtil.DEFAULT_TIME_FORMAT),DateUtil.DEFAULT_TIME_FORMAT);
    }
}
