package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectStartConfigMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartConfig;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectStartConfigExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectStartConfigService;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by Administrator on 2017/8/2.
 */
@Service("whWmsConnectStartConfigService")
public class WhWmsConnectStartConfigServiceImpl implements WhWmsConnectStartConfigService {

    @Autowired
    private WhWmsConnectStartConfigMapper whWmsConnectStartConfigMapper;

    @Override
    public List<WhWmsConnectStartCountConfigVO> findAllConnectStartCountConfig() {
        List<WhWmsConnectStartConfigVO> countConfigList = findConnectStartConfig(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_COUNT);
        if(EmptyUtil.isEmpty(countConfigList)){
            return Collections.emptyList();
        }
        List<WhWmsConnectStartCountConfigVO> voList = new ArrayList<>();
        for(WhWmsConnectStartConfigVO countConfig : countConfigList){
            JSONObject json = JSON.parseObject(countConfig.getValue());
            WhWmsConnectStartCountConfigVO vo = JSONObject.toJavaObject(json,WhWmsConnectStartCountConfigVO.class);
            vo.setId(countConfig.getId());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public WhWmsConnectStartCountConfigVO findConnectStartCountConfig(String physicalWarehouseCode) {
        WhWmsConnectStartConfigVO configVO = findConnectStartConfig(physicalWarehouseCode,WhWmsConnectStartConfigVO.TYPE_CONNECT_START_COUNT);
        if(NullUtil.isNull(configVO)){
            return null;
        }
        if(EmptyUtil.isNotEmpty(configVO.getValue())){
            JSONObject json = JSON.parseObject(configVO.getValue());
            WhWmsConnectStartCountConfigVO countConfigVO = JSONObject.toJavaObject(json,WhWmsConnectStartCountConfigVO.class);
            countConfigVO.setId(configVO.getId());
            return countConfigVO;
        }else{
            WhWmsConnectStartCountConfigVO countConfigVO = new WhWmsConnectStartCountConfigVO();
            countConfigVO.setId(configVO.getId());
            return countConfigVO;
        }
    }

    @Override
    @Transactional
    public boolean saveConnectStartCountConfig(WhWmsConnectStartCountConfigVO countConfigVO) {
        WhWmsConnectStartConfigVO configVO = BeanUtil.buildFrom(countConfigVO,WhWmsConnectStartConfigVO.class);
        configVO.setValue(JSONObject.toJSONString(countConfigVO));
        configVO.setType(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_COUNT);
        return saveConnectStartConfig(configVO);
    }

    @Override
    public WhWmsConnectStartRuleConfigVO findConnectStartRuleConfig(String physicalWarehouseCode) {
        WhWmsConnectStartConfigVO configVO = findConnectStartConfig(physicalWarehouseCode,WhWmsConnectStartConfigVO.TYPE_CONNECT_START_SETTING);
        if(NullUtil.isNull(configVO)){
            return null;
        }
        if(EmptyUtil.isNotEmpty(configVO.getValue())){
            JSONObject json = JSON.parseObject(configVO.getValue());
            WhWmsConnectStartRuleConfigVO ruleConfigVO = JSONObject.toJavaObject(json,WhWmsConnectStartRuleConfigVO.class);
            ruleConfigVO.setId(configVO.getId());
            return ruleConfigVO;
        }else{
            WhWmsConnectStartRuleConfigVO ruleConfigVO = new WhWmsConnectStartRuleConfigVO();
            ruleConfigVO.setId(configVO.getId());
            return ruleConfigVO;
        }
    }

    @Override
    public List<WhWmsConnectStartRuleConfigVO> findAllConnectStartRuleConfig() {
        List<WhWmsConnectStartConfigVO> startRuleConfigList = findConnectStartConfig(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_SETTING);
        if(EmptyUtil.isEmpty(startRuleConfigList)){
            return Collections.emptyList();
        }
        List<WhWmsConnectStartRuleConfigVO> voList = new ArrayList<>();
        for(WhWmsConnectStartConfigVO startRuleConfig : startRuleConfigList){
            JSONObject json = JSON.parseObject(startRuleConfig.getValue());
            WhWmsConnectStartRuleConfigVO vo = JSONObject.toJavaObject(json,WhWmsConnectStartRuleConfigVO.class);
            vo.setId(startRuleConfig.getId());
            voList.add(vo);
        }
        return voList;
    }

    @Override
    @Transactional
    public boolean saveConnectStartRuleConfig(WhWmsConnectStartRuleConfigVO ruleConfigVO) {
        WhWmsConnectStartConfigVO configVO = BeanUtil.buildFrom(ruleConfigVO,WhWmsConnectStartConfigVO.class);
        configVO.setValue(JSONObject.toJSONString(ruleConfigVO));
        configVO.setType(WhWmsConnectStartConfigVO.TYPE_CONNECT_START_SETTING);
        return saveConnectStartConfig(configVO);
    }

    private boolean saveConnectStartConfig(WhWmsConnectStartConfigVO configVO){
        if(NullUtil.isNull(configVO.getId())){
            whWmsConnectStartConfigMapper.insert(configVO);
        }else{
            whWmsConnectStartConfigMapper.updateByPrimaryKey(configVO);
        }
        return true;
    }

    private List<WhWmsConnectStartConfigVO> findConnectStartConfig(Integer configType){
        WhWmsConnectStartConfigExample example = new WhWmsConnectStartConfigExample();
        example.createCriteria().andTypeEqualTo(configType);
        List<WhWmsConnectStartConfig> list = whWmsConnectStartConfigMapper.selectByExample(example);
        if(EmptyUtil.isNotEmpty(list)){
            return BeanUtil.buildListFrom(list,WhWmsConnectStartConfigVO.class);
        }
        return Collections.emptyList();
    }

    private WhWmsConnectStartConfigVO findConnectStartConfig(String physicalWarehouseCode,Integer configType){
        WhWmsConnectStartConfigExample example = new WhWmsConnectStartConfigExample();
        example.createCriteria().andPhysicalWarehouseCodeEqualTo(physicalWarehouseCode)
                .andTypeEqualTo(configType);
        List<WhWmsConnectStartConfig> list = whWmsConnectStartConfigMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            return BeanUtil.buildFrom(list.get(0),WhWmsConnectStartConfigVO.class);
        }
        return null;

    }
}
