/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectPickSkuCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsOutStockRecordCond;
import com.thebeastshop.pegasus.service.warehouse.dao.*;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.exception.WmsExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectPickSkuServiceImpl.java, v 0.1 2016-03-25 下午5:48
 */
@Service("whWmsConnectPickSkuService")
public class WhWmsConnectPickSkuServiceImpl implements WhWmsConnectPickSkuService {
    private static final Logger log = LoggerFactory.getLogger(WhWmsConnectPickSkuServiceImpl.class);
    @Autowired
    private WhWmsConnectPickSkuMapper mapper;

    @Autowired
    private WhWmsConnectTurnoverBoxMapper boxMapper;

    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Autowired
    private WhWmsOccupyService whWmsOccupyService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhWmsHouseShelvesMapper whWmsHouseShelvesMapper;
    @Autowired
    private WhCommandMapper whCommandMapper;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    @Autowired
    private WhWmsCommandCheckMapper whWmsCommandCheckMapper;

    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;

    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;

    @Autowired
    private WhWmsConnectDistributionMapper whWmsConnectDistributionMapper;
    @Autowired
    private WhWmsOutStockRecordService whWmsOutStockRecordService;

    @Override
    public WhWmsConnectPickSkuVO create(WhWmsConnectPickSkuVO vo) {
        validateBeforeCreate(vo);
        WhWmsConnectPickSku whWmsConnectPickSku = BeanUtil.buildFrom(vo, WhWmsConnectPickSku.class);
        whWmsConnectPickSku.setStatus(WhWmsConnectPickSkuVO.STATUS_PENDING);
        mapper.insert(whWmsConnectPickSku);
        vo.setId(whWmsConnectPickSku.getId());
        return vo;
    }

    @Override
    @Transactional
    public boolean batchCreate(List<WhWmsConnectPickSkuVO> voList) {
        if(EmptyUtil.isNotEmpty(voList)){
            for(WhWmsConnectPickSkuVO vo : voList){
                vo.setStatus(WhWmsConnectPickSkuVO.STATUS_PENDING);
            }
            return mapper.batchInsert(voList)==voList.size();
        }
        return false;
    }

    @Override
    public boolean cancelConnectPickSku(List<Long> connectIds) {
        if(EmptyUtil.isEmpty(connectIds)){
            return false;
        }
        List<WhWmsConnectPickSkuVO> pickSkuList = findByConnectIds(connectIds);
        if(EmptyUtil.isEmpty(pickSkuList)){
            return false;
        }
        List<Long> idList = new ArrayList<>();
        for(WhWmsConnectPickSkuVO pickSku : pickSkuList){
            idList.add(pickSku.getId());
        }
        int count = mapper.batchCancel(idList);
        return count == idList.size();
    }

    @Override
    public Boolean update(WhWmsConnectPickSkuVO vo) {
        //WhWmsConnectPickSkuExample example = new WhWmsConnectPickSkuExample();
        //example.createCriteria().andIdEqualTo(vo.getId()).andStatusNotEqualTo(WhWmsConnectPickSkuVO.STATUS_FINISH);
        boolean success = mapper.connectPickskuFinishById(vo)==1;
        if(!success){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"已完成或已取消任务不可操作["+vo.getId()+"]");
        }
        return true;
    }

    @Override
    public void updateWhWmsConnectPickSkuByKey(WhWmsConnectPickSku vo) {
         mapper.updateByPrimaryKeySelective(vo);
    }

    //更新拣货数据
    private void updatePickSkuList(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId,List<WhWmsConnectPickSkuVO> connectPickSkuVOs){
        if(EmptyUtil.isEmpty(connectPickSkuVOs) || EmptyUtil.isEmpty(pickSkuVOList)){
            return;
        }
        Map<Long,WhWmsConnectPickSkuVO> connectPickSkuVOMap = new HashMap<>();
        boolean isStart = true;
        for(WhWmsConnectPickSkuVO whWmsConnectPickSkuVO:connectPickSkuVOs){
            connectPickSkuVOMap.put(whWmsConnectPickSkuVO.getId(),whWmsConnectPickSkuVO);
            if(whWmsConnectPickSkuVO.getStatus() == 1){
                isStart = false;
            }
        }
        if(isStart){
            WhWmsOutStockRecord whWmsOutStockRecord = new WhWmsOutStockRecord();
            whWmsOutStockRecord.setInOutType(connectVO.getInOutType());
            whWmsOutStockRecord.setConnectId(connectVO.getId().intValue());
            whWmsOutStockRecord.setOptType(WhWmsOutStockRecordVO.OPT_TYPE_PICKING_START);
            whWmsOutStockRecord.setOperatorId(operatorId.intValue());
            whWmsOutStockRecord.setOperatorTime(Calendar.getInstance().getTime());
            whWmsOutStockRecord.setDisposeType(WhWmsOutStockRecordVO.DISPOSE_TYPE_ZERO);
            whWmsOutStockRecord.setCreateTime(Calendar.getInstance().getTime());
            whWmsOutStockRecord.setOptDesc(WhWmsOutStockRecordVO.OptTypeDescEnum.PICKING_START.getOptDesc());
            whWmsOutStockRecordService.createWhWmsOutStockRecord(whWmsOutStockRecord);
        }
        for (WhWmsConnectPickSkuVO whWmsConnectPickSkuVO : pickSkuVOList) {
            WhWmsConnectPickSkuVO connectPickSkuVO = connectPickSkuVOMap.get(whWmsConnectPickSkuVO.getId());
            if(connectPickSkuVO != null){
                if(WhWmsConnectPickSkuVO.STATUS_FINISH.equals(connectPickSkuVO.getStatus())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"任务已完成["+connectPickSkuVO.getId()+"]");
                }
                if(WMSConstants.ConnectType.RECEIVE_WASTE.equals(connectVO.getConnectType())){
                    //报废出库-数量必须一致
                    if(!connectPickSkuVO.getNeedAmount().equals(whWmsConnectPickSkuVO.getActualAmount())){
                        throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"报废出库数量必须和需拣货数据一致");
                    }
                }
                connectPickSkuVO.setStatus(WhWmsConnectPickSkuVO.STATUS_FINISH);
                connectPickSkuVO.setActualAmount(whWmsConnectPickSkuVO.getActualAmount());//设置实际拣货数量
//                //操作记录
                WhWmsOutStockRecord whWmsOutStockRecord = new WhWmsOutStockRecord();
                whWmsOutStockRecord.setInOutType(connectVO.getInOutType());
                whWmsOutStockRecord.setConnectId(connectVO.getId().intValue());
                whWmsOutStockRecord.setOptType(WhWmsOutStockRecordVO.OPT_TYPE_PICKING_DETAIL);
                whWmsOutStockRecord.setOptDesc(
                        WhWmsOutStockRecordVO.OptTypeDescEnum.PICKING_DETAIL.getOptDesc());
                whWmsOutStockRecord.setRecordType(WhWmsOutStockRecordVO.RECORD_TYPE_PICKING_DETAIL);
                whWmsOutStockRecord.setOperatorTime(DateUtil.getNow());
                whWmsOutStockRecord.setShelvesCode(connectPickSkuVO.getShelvesCode());
                whWmsOutStockRecord.setSkuCode(connectPickSkuVO.getSkuCode());
                whWmsOutStockRecord.setQuantity(connectPickSkuVO.getActualAmount());
                whWmsOutStockRecord.setOperatorId(operatorId.intValue());
                whWmsOutStockRecord.setCreateTime(Calendar.getInstance().getTime());
                //whWmsOutStockRecord.setRefId(para.getId());
                whWmsOutStockRecord.setRefDesc(WhWmsOutStockRecordVO.REF_DESC_PICKING);
                whWmsOutStockRecordService.createWhWmsOutStockRecord(whWmsOutStockRecord);

                update(connectPickSkuVO);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"找不到拣货数据");
            }
        }
    }

    public boolean isConnectPickSkuFinish(List<WhWmsConnectPickSkuVO> connectPickSkuVOs){
        if(EmptyUtil.isEmpty(connectPickSkuVOs)){
            return true;
        }
        for (WhWmsConnectPickSkuVO pickSkuVO : connectPickSkuVOs){
            if(!WhWmsConnectPickSkuVO.STATUS_FINISH.equals(pickSkuVO.getStatus())){
                return false;
            }
        }
        return true;
    }

    @Override
    public List<WhCountVO> countConnectPickSku(Long operatorId, String physicalWarehouseCode) {
        return mapper.countConnectPickSku(operatorId,physicalWarehouseCode);
    }

    @Override
    public void autoProcessShelvesStatus() {
        List<WhWmsHouseShelves> waitUseList = whWmsHouseShelvesMapper.findShelvesStatusWaitUse();
        if(waitUseList != null && waitUseList.size() > 0){
            for(WhWmsHouseShelves whWmsHouseShelves:waitUseList){
                whWmsHouseShelves.setShelvesStatus(1);
                whWmsHouseShelvesMapper.updateByPrimaryKeySelective(whWmsHouseShelves);
            }
        }

        List<WhWmsHouseShelves> WaitNoUseList = whWmsHouseShelvesMapper.findShelvesStatusWaitNoUse();
        if(WaitNoUseList != null && WaitNoUseList.size() > 0){
            for(WhWmsHouseShelves whWmsHouseShelves:WaitNoUseList){
                whWmsHouseShelves.setShelvesStatus(0);
                whWmsHouseShelvesMapper.updateByPrimaryKeySelective(whWmsHouseShelves);
            }
        }
    }

    @Override
    public WhWmsConnectPickSkuVO findById(Long id) {
        WhWmsConnectPickSku whWmsConnectPickSku = mapper.selectByPrimaryKey(id);
        if(whWmsConnectPickSku!=null){
            return BeanUtil.buildFrom(whWmsConnectPickSku,WhWmsConnectPickSkuVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findByCond(WhWmsConnectPickSkuCond cond) {
        WhWmsConnectPickSkuExample example = new WhWmsConnectPickSkuExample();
        WhWmsConnectPickSkuExample.Criteria criteria = example.createCriteria();
        if(!NumberUtil.isNullOrZero(cond.getConnectId())){
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if(EmptyUtil.isNotEmpty(cond.getConnectIds())){
        	criteria.andConnectIdIn(cond.getConnectIds());
        }
        if(EmptyUtil.isNotEmpty(cond.getBarCode())){
        	criteria.andBarCodeEqualTo(cond.getBarCode());
        }
        example.setOrderByClause(" ID ASC ");

        List<WhWmsConnectPickSku> whWmsConnectPickSkus = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectPickSkus)) {
            return Collections.emptyList();
        }
        List<WhWmsConnectPickSkuVO> vos = new ArrayList<WhWmsConnectPickSkuVO>(whWmsConnectPickSkus.size());
        for (WhWmsConnectPickSku whWmsConnectPickSku : whWmsConnectPickSkus) {
            vos.add(BeanUtil.buildFrom(whWmsConnectPickSku,WhWmsConnectPickSkuVO.class));
        }
        return vos;
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findByConnectId(Long connectId) {
        WhWmsConnectPickSkuCond cond = new WhWmsConnectPickSkuCond();
        cond.setConnectId(connectId);
        return findByCond(cond);
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findConnectPickSkuByCond(WhWmsConnectPickSkuCond cond){
        return findByCond(cond);
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findByConnectIds(List<Long> connectIds) {
        WhWmsConnectPickSkuCond cond = new WhWmsConnectPickSkuCond();
        cond.setConnectIds(connectIds);
        return findByCond(cond);
    }

    @Override
    public List<WhWmsConnectPickSkuVO> findListConnectPickSku(List<Long> connectIds) {
        return mapper.findListConnectPickSku(connectIds);
    }

    @Override
    public boolean preSubmitConnectPickSku(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId,WhCommand cmd,List<WhWmsCommandConnectVO> commandConnects) throws Exception{
        if(EmptyUtil.isNotEmpty(pickSkuVOList)){
            WhWmsConnectTurnoverBox condBox = new WhWmsConnectTurnoverBox();
            condBox.setConnectId(connectVO.getId());
            List<WhWmsConnectTurnoverBox> boxList = findBoxByCond(condBox);
            if(CollectionUtils.isEmpty(boxList)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次没有绑定任何一个拣货周转箱");
            }
        }
        List<WhWmsConnectPickSkuVO> connectPickSkuVOs = findByConnectId(connectVO.getId());
        updatePickSkuList(connectVO,pickSkuVOList,operatorId,connectPickSkuVOs);
        if(!isConnectPickSkuFinish(connectPickSkuVOs)){
            //部分完成.结束
            return true;
        }
        //记录操作日志
        whWmsOperationRcdService.insertRcdByConnectId(connectVO.getId(),operatorId);
        pickSkuVOList.clear();
        for(WhWmsConnectPickSkuVO vo:connectPickSkuVOs){
            pickSkuVOList.add(vo);
        }
        List<WhWmsCommandConnectVO> whWmsCommandConnectVOList = whWmsCommandConnectService.findNotCanceledByConnectId(connectVO.getId());
        for(WhWmsCommandConnectVO vo:whWmsCommandConnectVOList){
            commandConnects.add(vo);
        }
        WhCommand whCommand = whCommandService.findCommandByCode(commandConnects.get(0).getCommandCode(), false);
        BeanUtils.copyProperties(whCommand,cmd);
        return false;
    }
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSku(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId,WhCommand cmd,List<WhWmsCommandConnectVO> commandConnects) throws Exception{
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        returnVo.setConnectVO(connectVO);
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        //多品多件-波次->待分拨，指令->待分拨
        //单品单件、多件活动波次->已完成，指令->待包装
        //多品单件 波次->已完成，指令->待包装
        //大宗订单-波次->已完成，指令->待包装
        Integer newCommandStatus = null;
        if(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE.equals(connectVO.getConnectType())){
            connectVO.setConnectStatus(WMSConstants.ConnectStatus.DISTRIBUTION);
            newCommandStatus = WhCommand.STATUS_DISTRIBUTION;
        }else if(WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE.equals(connectVO.getConnectType())
                || WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY.equals(connectVO.getConnectType())
                || WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(connectVO.getConnectType())
                || WMSConstants.ConnectType.BULK_ORDER.equals(connectVO.getConnectType())
                || WMSConstants.ConnectType.LARGE_SIZED_PACKAGE.equals(connectVO.getConnectType())){
            connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
            newCommandStatus = WhCommand.STATUS_PACKING;
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次类型异常");
        }
        //库存移到分拨包装区
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);//分拨包装区
        List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hs) || hs.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,分拨包装区");
        }
        WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
        List<String> houseShelvesCodeList = new ArrayList<>();
        for (WhWmsConnectPickSkuVO connectPickSkuVO : pickSkuVOList) {
            houseShelvesCodeList.add(connectPickSkuVO.getShelvesCode());
        }
        Map<String,WhWmsHouseShelves> shelvesMap = whWmsHouseShelvesService.getHouseShelvesMapByCode(houseShelvesCodeList);
        //建移库任务 普通区 往 分拨包装区 移库存
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(operatorId);
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        moveStockVO.setReferenceCode(connectVO.getId().toString());
        List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
        moveStockVO.setMoveSkuList(moveStockSkuList);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : pickSkuVOList) {
            WhWmsHouseShelves houseShelvesVO = shelvesMap.get(connectPickSkuVO.getShelvesCode());
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveSkuVO.setSkuCode(connectPickSkuVO.getSkuCode());
            moveSkuVO.setSkuStatus(connectPickSkuVO.getSkuStatus());
            moveSkuVO.setBarCode(connectPickSkuVO.getBarCode());
            moveSkuVO.setOriginalHouseType(houseShelvesVO.getHouseType());
            moveSkuVO.setOriginalShelvesCode(connectPickSkuVO.getShelvesCode());
            moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
            moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
            moveSkuVO.setAmount(connectPickSkuVO.getActualAmount());//todo 是否要改成计划数量 不然出库验货流程会报数量不一致的错误 导致不能出库
            moveStockSkuList.add(moveSkuVO);
        }
        whWmsMoveStockService.rebuildMoveStock(moveStockVO);
        whWmsMoveStockService.moveStockCheck(moveStockVO);
        returnVo.setMoveStockVO(moveStockVO);
        Map<Integer,List<String>> toStatusMap = new HashMap<>();
        for (WhWmsCommandConnectVO commandConnectVO : commandConnects){
            List<String> commandCodes = toStatusMap.get(newCommandStatus);
            if(NullUtil.isNull(commandCodes)){
                commandCodes = new ArrayList<>();
                toStatusMap.put(newCommandStatus,commandCodes);
            }
            commandCodes.add(commandConnectVO.getCommandCode());
        }
        returnVo.setToStatusMap(toStatusMap);
        return returnVo;
    }
    @Override
    @Transactional
    public Boolean submitConnectPickSku(WhWmsConnectPickSkuSubmitDataVO processVo) {

        WhWmsConnectInfoVO connectVO = processVo.getConnectVO();
        if(connectVO != null){
            whWmsConnectInfoService.update(connectVO);
            //释放波次占用的库存
            whWmsOccupyService.releaseWmsOccupyByConnectId(connectVO.getId());
        }
        WhWmsMoveStockVO moveStockVO = processVo.getMoveStockVO();
        if(moveStockVO != null){
            //检查有没有分拨包装区
            whWmsMoveStockService.executeMoveStock(moveStockVO);
        }
        //更新波次关联的所有command的状态,待拣货到待分拨
        Map<Integer, List<String>> toStatusMap = processVo.getToStatusMap();
        if(toStatusMap != null && toStatusMap.size() > 0){
            //更新指令状态
            for(Integer key : toStatusMap.keySet()){
                whCommandService.batchUpdateCommandStatus(toStatusMap.get(key),key,WhCommand.STATUS_PICKING);
            }
        }
        //需验货
//        List<WhWmsCommandCheckVO> commandCheckList = processVo.getCommandCheckList();
//        if(commandCheckList != null && commandCheckList.size() > 0){
//            whWmsCommandCheckMapper.batchInsert(commandCheckList);
//        }
//        if(connectVO.getConnectType().equals("single_product_single_piece")){
//            deleteConnectBox(connectVO.getId());
//        }
        return true;
    }

    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuRecWaste(WhWmsConnectInfoVO connectVO,List<WhWmsCommandConnectVO> commandConnectList,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId) throws Exception{
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        if(EmptyUtil.isEmpty(commandConnectList)){
            throw new WarehouseException("波次状态下指令已全部取消");
        }
        returnVo.setConnectVO(connectVO);
        //查询指令
        List<String> commandCodes = new ArrayList<>();
        for(WhWmsCommandConnectVO cmdConn : commandConnectList){
            commandCodes.add(cmdConn.getCommandCode());
        }
        List<WhCommand> commandList = whCommandService.findCommandByCodes(commandCodes, true);
        for(WhCommand command : commandList){
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
        }
        //有拣货任务,更新拣货任务的实际拣货数量
        List<WhWmsConnectPickSkuVO> actualPickSkuList = updateConnectPickSku(connectVO.getId(),pickSkuVOList);
        //分配拣货数据
        pickCommandSkuPcsRtn(connectVO,commandList,actualPickSkuList);
        returnVo.setCommandList(commandList);
        returnVo.setPickSkuVOList(pickSkuVOList);
        returnVo.setActualPickSkuList(actualPickSkuList);
        return returnVo;
    }


    @Override
    @Transactional
    public boolean submitConnectPickSkuRecWaste(WhWmsConnectPickSkuSubmitDataVO vo,Long operatorId) throws Exception{
        WhWmsConnectInfoVO connectVO = vo.getConnectVO();
        //删除所有波次绑定的拣货箱,调拨拣货走简易流程 周转箱没必要
        Long connectId = connectVO.getId();
        delConnectBox(connectId);
        //更新波次状态到完成
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        whWmsConnectInfoService.update(connectVO);
        List<WhWmsConnectPickSkuVO> pickSkuVOList = vo.getPickSkuVOList();
        List<WhCommand> commandList = vo.getCommandList();
        //如果pickSkuVOList为空 直接将关联的所有cmd完成,整个波次没有拣货任务的情况
        if(CollectionUtils.isEmpty(pickSkuVOList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"拣货数据异常！");
        }
        List<WhWmsConnectPickSkuVO> actualPickSkuList = vo.getActualPickSkuList();
        //处理commandList
        for (WhCommand whCommand : commandList) {
            //完成指令
//            whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
//            whCommandService.finishCommand(whCommand);
            //状态修改为发货完成
            whCommandService.updateCommandStatusById(whCommand.getId().intValue(),WhCommand.STATUS_DELIVERYCOMPLETION);
            //包裹已收货
            whCommandMapper.updatePackageStatusToAlreadyReceive(whCommand.getReferenceCode());
            //记录出库记录，异步处理
            WhCommandOutFinish whCommandOutFinish = new WhCommandOutFinish();
            whCommandOutFinish.setCommandCode(whCommand.getCode());
            whCommandOutFinish.setStatus(PegasusConstants.YES);
            whCommandOutFinish.setWhStatus(PegasusConstants.NO);
            whCommandOutFinish.setFinishDate(DateUtil.getNow());
            whCommandOutFinish.setWeightUserId(operatorId);
            whCommandService.insertWhCommandOutFinish(whCommandOutFinish);
        }

        //处理拣货任务,直接扣wms库存
        //释放波次占用的库存
        whWmsOccupyService.releaseWmsOccupyByConnectId(connectId);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : actualPickSkuList) {
            if(NullUtil.isNull(connectPickSkuVO.getActualAmount()) || connectPickSkuVO.getActualAmount() <= 0){
                continue;
            }
            //扣wms库存
            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(connectPickSkuVO.getShelvesCode());
            whWmsSkuStockService.updateStockByCond(0-connectPickSkuVO.getActualAmount()
                    ,hs.getPhysicalWarehouseCode()             //物理仓编码
                    ,hs.getHouseType()                         //区域类型
                    ,connectPickSkuVO.getBarCode()                            //barcode
                    ,connectPickSkuVO.getShelvesCode()                              //库位号
                    ,connectPickSkuVO.getSkuCode()                            //skucode
                    ,connectPickSkuVO.getSkuStatus()                          //良品、残次、样品
                    ,connectVO.getInOutType()                              //出入库类型
                    ,"JH"+connectPickSkuVO.getId()                                    //相关单据号
                    ,operatorId);                                //操作人
        }
        return true;
    }


    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuPcsRtn(WhWmsConnectInfoVO connectVO,List<WhWmsCommandConnectVO> commandConnectList,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId) throws Exception{
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        if(EmptyUtil.isEmpty(commandConnectList)){
            throw new WarehouseException("波次状态下指令已全部取消");
        }
        returnVo.setConnectVO(connectVO);
        //查询指令
        List<String> commandCodes = new ArrayList<>();
        for(WhWmsCommandConnectVO cmdConn : commandConnectList){
            commandCodes.add(cmdConn.getCommandCode());
        }
        List<WhCommand> commandList = whCommandService.findCommandByCodes(commandCodes, true);
        for(WhCommand command : commandList){
            for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
        }
        //有拣货任务,更新拣货任务的实际拣货数量
        List<WhWmsConnectPickSkuVO> actualPickSkuList = updateConnectPickSku(connectVO.getId(),pickSkuVOList);
        //分配拣货数据
        pickCommandSkuPcsRtn(connectVO,commandList,actualPickSkuList);
        returnVo.setCommandList(commandList);
        returnVo.setPickSkuVOList(pickSkuVOList);
        returnVo.setActualPickSkuList(actualPickSkuList);
        return returnVo;
    }
    @Override
    @Transactional
    public boolean submitConnectPickSkuPcsRtn(WhWmsConnectPickSkuSubmitDataVO vo,Long operatorId) throws Exception{
        WhWmsConnectInfoVO connectVO = vo.getConnectVO();
    	//删除所有波次绑定的拣货箱,调拨拣货走简易流程 周转箱没必要
    	Long connectId = connectVO.getId();
        delConnectBox(connectId);
        //更新波次状态到完成
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        whWmsConnectInfoService.update(connectVO);
        List<WhWmsConnectPickSkuVO> pickSkuVOList = vo.getPickSkuVOList();
        List<WhCommand> commandList = vo.getCommandList();
        //如果pickSkuVOList为空 直接将关联的所有cmd完成,整个波次没有拣货任务的情况
        if(CollectionUtils.isEmpty(pickSkuVOList)){

        	for (WhCommand whCommand : commandList) {
                //完成指令，同时更新采退单数据
                whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
                whCommandService.finishCommand(whCommand);
                //状态修改为发货完成
                whCommandService.updateCommandStatusById(whCommand.getId().intValue(),WhCommand.STATUS_DELIVERYCOMPLETION);
                //采退单取消
                whCommandService.cancelPurchaseRtnByWhCommand(whCommand);
            }
        	return true;
        }
        List<WhWmsConnectPickSkuVO> actualPickSkuList = vo.getActualPickSkuList();
        //处理commandList
        for (WhCommand whCommand : commandList) {
            //完成指令
        	whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            whCommandService.finishCommand(whCommand);
            //状态修改为发货完成
            whCommandService.updateCommandStatusById(whCommand.getId().intValue(),WhCommand.STATUS_DELIVERYCOMPLETION);
            //完成采购单。填充实际采退数据
            if(isZeroPickSkuPcsRtn(pickSkuVOList)){
                //采退单取消。拣货数据为0
                whCommandService.cancelPurchaseRtnByWhCommand(whCommand);
            }else{
                whCommandService.finishPurchaseRtnByWhCommand(whCommand);
            }
        }

        //处理拣货任务,直接扣wms库存
        //释放波次占用的库存
        whWmsOccupyService.releaseWmsOccupyByConnectId(connectId);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : actualPickSkuList) {
        	if(NullUtil.isNull(connectPickSkuVO.getActualAmount()) || connectPickSkuVO.getActualAmount() <= 0){
        		continue;
        	}
        	//扣wms库存
            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(connectPickSkuVO.getShelvesCode());
            whWmsSkuStockService.updateStockByCond(0-connectPickSkuVO.getActualAmount()
                    ,hs.getPhysicalWarehouseCode()             //物理仓编码
                    ,hs.getHouseType()                         //区域类型
                    ,connectPickSkuVO.getBarCode()                            //barcode
                    ,connectPickSkuVO.getShelvesCode()                              //库位号
                    ,connectPickSkuVO.getSkuCode()                            //skucode
                    ,connectPickSkuVO.getSkuStatus()                          //良品、残次、样品
                    ,WhCommand.TYPE_PURCHASE_RETURN_OUT                              //出入库类型
                    ,"JH"+connectPickSkuVO.getId()                                    //相关单据号
                    ,operatorId);                                //操作人
        }

    	return true;
    }



    @Override
    public boolean consumableReceiveOutInPut(String dispatchBillCode,Map<String,Integer> quantityMap,List<WhWmsSkuStock> whWmsSkuStocks,
                                              Long operatorId) throws Exception {
        // 查询指令
        // 出入库类型为：销售出库
        WhCommand whCommand = whCommandService.findCommandByTypeAndReferenceCode(WhCommand.TYPE_SALES_OUT, dispatchBillCode,true);
        /*
        Integer quantityTmp = 0;
        for (WhCommandSku commandSku : whCommand.getWhCommandSkuList()) {
            quantityTmp = quantityMap.get(commandSku.getSkuCode());
            commandSku.setQuantity(quantityTmp==null ? 0:quantityTmp);
            commandSku.setDamagedQuantity(0);
        }
        //完成指令，同时更新采退单数据
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommandService.finishCommand(whCommand);
        //状态修改为发货完成
        whCommandService.updateCommandStatusById(whCommand.getId().intValue(),WhCommand.STATUS_DELIVERYCOMPLETION);*/

        //扣除wms库存  whCommand为空[可能为来单制作的sku,无需创建出入库、及扣减库存]
        if (EmptyUtil.isNotEmpty(whCommand)){
            for (WhWmsSkuStock whWmsSkuStock : whWmsSkuStocks){
                whWmsSkuStockService.updateStockByCond(0-(whWmsSkuStock.getAmount()==null?0:whWmsSkuStock.getAmount())
                        ,whWmsSkuStock.getPhysicalWarehouseCode()             //物理仓编码
                        ,whWmsSkuStock.getHouseType()                         //区域类型
                        ,whWmsSkuStock.getBarCode()                            //barcode
                        ,whWmsSkuStock.getShelvesCode()                              //库位号
                        ,whWmsSkuStock.getSkuCode()                            //skucode
                        ,whWmsSkuStock.getSkuStatus()                          //良品、残次、样品
                        ,WhCommand.TYPE_SALES_OUT                              //出入库类型
                        ,whCommand.getCode()                                    //相关单据号 command_code
                        ,operatorId);
            }
        }

        return true;
    }

    private boolean isZeroPickSkuPcsRtn(List<WhWmsConnectPickSkuVO> pickSkuVOList){
        for(WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList){
            if(pickSkuVO.getActualAmount()>0){
                return false;
            }
        }
        return true;
    }
    @Override
    public WhWmsConnectPickSkuSubmitDataVO checkSubmitConnectPickSkuAlt(WhWmsConnectInfoVO connectVO,List<WhWmsConnectPickSkuVO> pickSkuVOList,Long operatorId) throws Exception{
        WhWmsConnectPickSkuSubmitDataVO returnVo = new WhWmsConnectPickSkuSubmitDataVO();
        returnVo.setConnectVO(connectVO);
        if(!CollectionUtils.isEmpty(pickSkuVOList)){
            WhWmsConnectTurnoverBox cond = new WhWmsConnectTurnoverBox();
            cond.setConnectId(connectVO.getId());
            List<WhWmsConnectTurnoverBox> boxes = findBoxByCond(cond);
            if(CollectionUtils.isEmpty(boxes)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次没有绑定任何一个拣货周转箱");
            }
            //更新拣货任务的实际拣货数量
            List<WhWmsConnectPickSkuVO> connectPickSkuVOs = findByConnectId(connectVO.getId());
            for (WhWmsConnectPickSkuVO connectPickSkuVO : connectPickSkuVOs) {
                boolean found = false;
                for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
                    if(pickSkuVO.getId().equals(connectPickSkuVO.getId())){
                        if(pickSkuVO.getActualAmount()>connectPickSkuVO.getNeedAmount()){
                            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"拣货实际数量大于计划数量");
                        }
                        connectPickSkuVO.setActualAmount(pickSkuVO.getActualAmount());//更新实际拣货数量
                        //update(connectPickSkuVO); 已更新无需再次更新
                        found = true;
                        break;
                    }
                }
                if(!found){
                    throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"找不到拣货任务");
                }
            }

            //检查有没有交接区
            WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
            whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);//交接区
            List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
            if(CollectionUtils.isEmpty(hs) || hs.size()>1){
                throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,交接区");
            }
            WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
            //建移库任务 普通区 往 交接区 移库存
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(operatorId);
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
            moveStockVO.setMoveSkuList(moveStockSkuList);
            for (WhWmsConnectPickSkuVO connectPickSkuVO : connectPickSkuVOs) {
                WhWmsHouseShelvesVO houseShelvesVO = whWmsHouseShelvesService.getHouseShelvesByCode(connectPickSkuVO.getShelvesCode());
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(connectPickSkuVO.getSkuCode());
                moveSkuVO.setSkuStatus(connectPickSkuVO.getSkuStatus());
                moveSkuVO.setBarCode(connectPickSkuVO.getBarCode());
                moveSkuVO.setOriginalHouseType(houseShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(connectPickSkuVO.getShelvesCode());
                moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                moveSkuVO.setAmount(connectPickSkuVO.getActualAmount());//todo 是否要改成计划数量 不然出库验货流程会报数量不一致的错误 导致不能出库
                moveStockSkuList.add(moveSkuVO);
            }
            whWmsMoveStockService.rebuildMoveStock(moveStockVO);
            whWmsMoveStockService.moveStockCheck(moveStockVO);
            returnVo.setMoveStockVO(moveStockVO);
            returnVo.setPickSkuVOList(pickSkuVOList);
        }
        return returnVo;
    }
    /**
     * 包装验货-调拨
     * @throws Exception
     * */
    @Override
    @Transactional
    public boolean submitConnectPickSkuAlt(WhWmsConnectPickSkuSubmitDataVO vo,Long operatorId) throws Exception{
        WhWmsConnectInfoVO connectVO = vo.getConnectVO();
    	//更新波次状态
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PACK);
        whWmsConnectInfoService.update(connectVO);
        List<WhWmsConnectPickSkuVO> pickSkuVOList = vo.getPickSkuVOList();
    	//如果pickSkuVOList为空 ,波次强制结束
        if(CollectionUtils.isEmpty(pickSkuVOList)){
        	WhWmsConnectAllotPackageVO packageVO = new WhWmsConnectAllotPackageVO();
        	packageVO.setConnectId(connectVO.getId());
        	packageVO.setOperatorId(operatorId);
        	packageVO.setFocusFinish(true);
        	return whWmsConnectInfoService.submitConnectAltCheck(packageVO);
        }
        //释放波次占用的库存
        whWmsOccupyService.releaseWmsOccupyByConnectId(connectVO.getId());
        //有拣货任务
        WhWmsMoveStockVO moveStockVO = vo.getMoveStockVO();
        whWmsMoveStockService.executeMoveStock(moveStockVO);
        //更新波次关联的所有command的状态,待拣货到待交接
        for (WhWmsCommandConnectVO commandConnectVO : whWmsCommandConnectService.findNotCanceledByConnectId(connectVO.getId())) {
            whCommandService.commandInPickingToHandover(commandConnectVO.getCommandCode());
        }
        return true;
    }

    /**
     * 校验波次周转箱有效性
     * @param turnoverBoxNo 箱号
     */
    private void checkTurnoverValid(String turnoverBoxNo){
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria()
//                .andConnectIdEqualTo(connectId)
                .andTurnoverBoxNoEqualTo(turnoverBoxNo)
                .andCancelFlagEqualTo(PegasusConstants.NO)
                .andStatusEqualTo(WhWmsConnectTurnoverBox.STATUS_OCCUPY);
        List<WhWmsConnectTurnoverBox> boxes = boxMapper.selectByExample(boxExample);
        if(CollectionUtils.isNotEmpty(boxes)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"已绑定过波次周转箱["+turnoverBoxNo+"]");
        }
    }

    /**
     * 校验分拨周转箱有效性
     * @param distributionCode 箱号
     */
    private void checkDistributionValid(String distributionCode){
        WhWmsConnectDistributionExample boxExample = new WhWmsConnectDistributionExample();
        boxExample.createCriteria()
//                .andConnectIdEqualTo(connectId)
                .andDistributionCodeEqualTo(distributionCode)
                .andCancelFlagEqualTo(PegasusConstants.NO);
        List<WhWmsConnectDistribution> boxes = whWmsConnectDistributionMapper.selectByExample(boxExample);
        if(CollectionUtils.isNotEmpty(boxes)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"已绑定过分拨周转箱["+distributionCode+"]");
        }
    }

    @Override
    public Boolean bindConnectBox(Long connectId, String turnoverBoxNo, Long createUserId) {
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(connectId);
        if(connectVO==null||(!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.WAITING_PROCESS)
                && !connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.PROCESSING) ) ){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不是待拣货状态");
        }

        // 校验波次周转箱有效性
        checkTurnoverValid(turnoverBoxNo);

        boxMapper.updateByPhysicalWarehouseCodeAndBoxNo(turnoverBoxNo);
        WhWmsConnectTurnoverBox box = new WhWmsConnectTurnoverBox();
        box.setConnectId(connectId);
        box.setTurnoverBoxNo(turnoverBoxNo);
        box.setCreateUserId(createUserId);
        box.setCancelFlag(PegasusConstants.NO);
        box.setStatus(WhWmsConnectTurnoverBox.STATUS_OCCUPY);
        box.setCreateTime(DateUtil.getNow());
        boxMapper.insert(box);
        return true;
    }

    @Override
    public List<WhWmsConnectTurnoverBox> findConnectBoxByConnectId(Long connectId) {
        WhWmsConnectTurnoverBoxExample example = new WhWmsConnectTurnoverBoxExample();
        example.createCriteria().andConnectIdEqualTo(connectId).andCancelFlagEqualTo(PegasusConstants.NO);
        return boxMapper.selectByExample(example);
    }

    @Override
    public Boolean deleteConnectBox(Long connectId) {
        //条件
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria()
                .andConnectIdEqualTo(connectId);
        //软删除
        WhWmsConnectTurnoverBox whWmsConnectTurnoverBox = new WhWmsConnectTurnoverBox();
        whWmsConnectTurnoverBox.setCancelFlag(PegasusConstants.YES);
        boxMapper.updateByExampleSelective(whWmsConnectTurnoverBox,boxExample);
        return true;
    }


    @Override
    public Boolean delConnectBox(Long connectId, String turnoverBoxNo) {
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria()
                .andConnectIdEqualTo(connectId)
                .andTurnoverBoxNoEqualTo(turnoverBoxNo);
        //物理删除
        return boxMapper.deleteByExample(boxExample)!=0;
    }

    private Boolean delConnectBox(Long connectId){
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria()
                .andConnectIdEqualTo(connectId);
        //物理删除
        return boxMapper.deleteByExample(boxExample)!=0;
    }

    @Override
    public List<WhWmsConnectTurnoverBox> findBoxByCond(WhWmsConnectTurnoverBox cond) {
        WhWmsConnectTurnoverBoxExample example = new WhWmsConnectTurnoverBoxExample();
        WhWmsConnectTurnoverBoxExample.Criteria criteria = example.createCriteria();

        if(!NumberUtil.isNullOrZero(cond.getConnectId())){
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if(cond.getCancelFlag()!=null && (cond.getCancelFlag().equals(PegasusConstants.YES) || cond.getCancelFlag().equals(PegasusConstants.NO))){
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }
        if(cond.getStatus()!=null && (cond.getStatus().equals(WhWmsConnectTurnoverBox.STATUS_OCCUPY) || cond.getStatus().equals(WhWmsConnectTurnoverBox.STATUS_RELEASED))){
            criteria.andStatusEqualTo(cond.getCancelFlag());
        }
        if(EmptyUtil.isNotEmpty(cond.getTurnoverBoxNo())){
            criteria.andTurnoverBoxNoEqualTo(cond.getTurnoverBoxNo());
        }

        if(EmptyUtil.isNotEmpty(cond.getConnectIds())){
            criteria.andConnectIdIn(cond.getConnectIds());
        }
        example.setOrderByClause(" ID ASC ");

        List<WhWmsConnectTurnoverBox> WhWmsConnectTurnoverBoxes = boxMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(WhWmsConnectTurnoverBoxes)) {
            return Collections.emptyList();
        }
        return WhWmsConnectTurnoverBoxes;
    }

    @Override
    public int findPickCommandCount(Long connectId) {
        return boxMapper.findPickCommandCount(connectId);
    }

    /**
     * 创建前验证
     * @param vo
     */
    private void validateBeforeCreate(WhWmsConnectPickSkuVO vo){

    }

    /**
     * 填充拣货数据
     * */
    private void pickCommandSkuPcsRtn(WhWmsConnectInfoVO connect,
    		List<WhCommand> commandList,
    		List<WhWmsConnectPickSkuVO> pickSkuVOList){

    	for(WhCommand command : commandList){
    		for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
    	}
    	//根据创建时间升序commandList
        Collections.sort(commandList, new Comparator<WhCommand>() {
            @Override
            public int compare(WhCommand o1, WhCommand o2) {
            	if(NullUtil.isNull(o1) || NullUtil.isNull(o2)){
            		return -1;
            	}
                return -(o1.getCreateTime().compareTo(o2.getCreateTime()));
            }
        });

        Map<String,Integer> pickedSkuQMap = new HashMap<>();
        for(WhWmsConnectPickSkuVO detail : pickSkuVOList){
        	String key = detail.getSkuCode();
        	Integer quantity = pickedSkuQMap.get(key);
        	if(NullUtil.isNull(quantity)){
        		pickedSkuQMap.put(key, detail.getActualAmount());
        	}else{
        		pickedSkuQMap.put(key, detail.getActualAmount()+quantity);
        	}
        }
        //分拣
        Integer skuStatus = connect.getSkuStatus();
        for(WhCommand command : commandList){
    		for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
    			String skuCode = commandSku.getSkuCode();
                Integer pickedQuantity = pickedSkuQMap.get(skuCode);
                if(NullUtil.isNull(pickedQuantity)){
                	continue;
                }
                Integer usedQuantity = 0;
                if(pickedQuantity>0 && pickedQuantity > commandSku.getPlanedQuantity()){
                	usedQuantity = commandSku.getPlanedQuantity();
                	pickedSkuQMap.put(skuCode, pickedQuantity-usedQuantity);
                }else{
                	usedQuantity = pickedQuantity;
                	pickedSkuQMap.put(skuCode, 0);
                }
                commandSku.setQuantity(usedQuantity);
//                if(usedQuantity > 0 && !WMSConstants.WMS_SKU_STATUS_DEFECTIVE.equals(skuStatus)){
//                	commandSku.setQuantity(usedQuantity);
//                }else if(usedQuantity > 0 && WMSConstants.WMS_SKU_STATUS_DEFECTIVE.equals(skuStatus)){
//                	commandSku.setDamagedQuantity(usedQuantity);
//                }
            }
    	}
    }

    //更新拣货任务的实际拣货数量
    private List<WhWmsConnectPickSkuVO> updateConnectPickSku(Long connectId,List<WhWmsConnectPickSkuVO> pickSkuVOList){
    	if(EmptyUtil.isEmpty(pickSkuVOList)){
    		throw new WarehouseException("无实际拣货");
    	}
    	//有拣货任务
        //更新拣货任务的实际拣货数量
        List<WhWmsConnectPickSkuVO> connectPickSkuVOs = findByConnectId(connectId);
        for (WhWmsConnectPickSkuVO connectPickSkuVO : connectPickSkuVOs) {
            boolean found = false;
            for (WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList) {
                if(pickSkuVO.getId().equals(connectPickSkuVO.getId())){
                    if(pickSkuVO.getActualAmount()>connectPickSkuVO.getNeedAmount()){
                        throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"拣货实际数量大于计划数量");
                    }
                    connectPickSkuVO.setActualAmount(pickSkuVO.getActualAmount());//更新实际拣货数量
                    //update(connectPickSkuVO); 已更新无需再次更新
                    found = true;
                    break;
                }
            }
            if(!found){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"找不到拣货任务");
            }
        }
        return connectPickSkuVOs;
    }

}
