/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectParaCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectParaMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectPara;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectParaExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectParaService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectParaVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectParaServiceImpl.java, v 0.1 2016-03-16 下午4:53
 */
@Service("whWmsConnectParaService")
public class WhWmsConnectParaServiceImpl implements WhWmsConnectParaService {

    @Autowired
    private WhWmsConnectParaMapper mapper;

    @Override
    public WhWmsConnectParaVO create(WhWmsConnectParaVO vo) {
        validateBeforeSave(vo);
        WhWmsConnectPara whWmsConnectPara = BeanUtil.buildFrom(vo, WhWmsConnectPara.class);
        mapper.insert(whWmsConnectPara);
        vo.setId(whWmsConnectPara.getId());
        return vo;
    }

    @Override
    public Boolean update(WhWmsConnectParaVO vo) {
        validateBeforeSave(vo);
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo,WhWmsConnectPara.class))!=0;
    }

    @Override
    public WhWmsConnectParaVO findById(Long id) {
        WhWmsConnectPara whWmsConnectPara = mapper.selectByPrimaryKey(id);
        if(whWmsConnectPara!=null){
            return BeanUtil.buildFrom(whWmsConnectPara,WhWmsConnectParaVO.class);
        }
        return null;
    }

    @Override
    public Integer findValueById(Long id) {
        WhWmsConnectParaVO opConnectParaVO = findById(id);
        if(opConnectParaVO != null && opConnectParaVO.getParaValue()!=null){
            return opConnectParaVO.getParaValue();
        }
        return null;
    }

    @Override
    public List<WhWmsConnectParaVO> findByCond(WhWmsConnectParaCond cond) {
        WhWmsConnectParaExample example = new WhWmsConnectParaExample();
        WhWmsConnectParaExample.Criteria criteria = example.createCriteria();

        if (StringUtils.isNotBlank(cond.getParaName())) {
            criteria.andParaNameLike(SQLUtils.allLike(cond.getParaName()));
        }

        example.setOrderByClause(" ID " + cond.getCriteriaStr());

        List<WhWmsConnectPara> whWmsConnectParas = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsConnectParas)) {
            return Collections.emptyList();
        }
        List<WhWmsConnectParaVO> vos = new ArrayList<WhWmsConnectParaVO>(whWmsConnectParas.size());
        for (WhWmsConnectPara whWmsConnectPara : whWmsConnectParas) {
            vos.add(BeanUtil.buildFrom(whWmsConnectPara,WhWmsConnectParaVO.class));
        }
        return vos;
    }

    @Override
    public WhWmsConnectParaVO findByName(String name) {
        WhWmsConnectParaExample example = new WhWmsConnectParaExample();
        example.createCriteria().andParaNameEqualTo(name);
        List<WhWmsConnectPara> whWmsConnectParas = mapper.selectByExample(example);
        if(CollectionUtils.isEmpty(whWmsConnectParas)){
            return null;
        }else{
            if(whWmsConnectParas.size()==1){
                return BeanUtil.buildFrom(whWmsConnectParas.get(0),WhWmsConnectParaVO.class);
            }else{
                return null;
            }
        }
    }

    @Override
    public Integer findValueByName(String name) {
        WhWmsConnectParaVO opConnectParaVO = findByName(name);
        if(opConnectParaVO != null && opConnectParaVO.getParaValue()!=null){
            return opConnectParaVO.getParaValue();
        }
        return null;
    }

    /**
     * 创建或者更新前验证
     * @param vo
     */
    private void validateBeforeSave(WhWmsConnectParaVO vo){
        if(vo.getParaName()==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"名字为空");
        }
        if(existByName(vo)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"名字重复");
        }
        if(NumberUtil.isNullOrZero(vo.getParaValue()) || vo.getParaValue().intValue()<0){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"参数小于等于0");
        }
    }

    /**
     * 是否存在同名的
     * @param vo
     * @return
     */
    private Boolean existByName(WhWmsConnectParaVO vo){
        Boolean result = false;

        if(vo.getParaName()!=null){
            WhWmsConnectParaVO exist = findByName(vo.getParaName());
            if(exist!=null && exist.getId().equals(vo.getId())){
                result = true;
            }
        }

        return result;
    }
}
