/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;


import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsBoxNumberMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectInfoMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectTurnoverBoxMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.exception.WmsExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsConnectInfoServiceImpl.java, v 0.1 2016-03-16 下午4:52
 */
@Service("whWmsConnectInfoService")
public class WhWmsConnectInfoServiceImpl implements WhWmsConnectInfoService {

    private final Logger log = LoggerFactory.getLogger(WhWmsConnectInfoServiceImpl.class);

    @Autowired
    private WhWmsConnectInfoMapper mapper;
    
    @Autowired
    private WhWmsConnectTurnoverBoxMapper boxMapper;

    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;

    @Autowired
    private WhWmsOccupyService whWmsOccupyService;

    @Autowired
    private WhAllotService whAllotService;
    
    @Autowired
    private WhWmsConnectAllotPackageService whWmsConnectAllotPackageService;
    
    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;
    
    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsBoxNumberMapper whWmsBoxNumberMapper;

    @Autowired
    private WhWmsCommandPreOccupyService whWmsCommandPreOccupyService;

    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;

    @Autowired
    private WhWmsTaskAssignService whWmsTaskAssignService;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Override
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfo(WhWmsConnectInfoVO vo, int count) throws Exception {
        //没有验证所有commandcodes 逻辑仓的类型是否一致 ,直接拿第一个command做条件 //todo
        WhCommand headCommand = whCommandService.findCommandByCode(vo.getWhCommandsCodes().get(0), false);
        WhWarehouse headWh = whInfoService.findWarehouseByCode(headCommand.getWarehouseCode());
        /*vo.setSkuStatus(headWh.getWarehouseType().equals(WhWarehouseVO.TYPE_DAMAGED)?WMSConstants.WMS_SKU_STATUS_DEFECTIVE:
                headWh.getWarehouseType().equals(WhWarehouseVO.TYPE_SAMPLE)?WMSConstants.WMS_SKU_STATUS_SAMPLE:
                        WMSConstants.WMS_SKU_STATUS_NONDEFECTIVE);*/
        vo.setSkuStatus(WhWarehouseVO.convertSkuStatusByCommodityStatus(headWh.getCommodityStatus()));

        if(count<=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"count<1");
        }

        validateCommandConnect(vo);

        List<WhWmsConnectInfoVO> result = new ArrayList<>();

        Map<String,Boolean> cmdCombineMap = vo.getCmdCombinedMap();
        if(headCommand.getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
            //调拨出库单独处理
            //同一个波次下的出库单关联的调拨单的目标物理仓一致
            Map<String,WhWmsConnectInfoVO> groupByPhysicalWhCode = new HashMap<>();//key 物理仓code,value 波次VO
            for (WhCommand cmd : vo.getWhCommands()) {
                WhAllotRcd allotRcd = whAllotService.findAllotRcdByCode(cmd.getReferenceCode(), false);
                if(allotRcd==null){
                    throw new WarehouseException("","根据相关单据号找不到调拨单");
                }
                WhPhysicalWarehouse physicalWh = whInfoService.findPhysicalWarehouseByCode(allotRcd.getTargetPhysicalWarehouseCode());
                if(!groupByPhysicalWhCode.containsKey(physicalWh.getCode())){
                    WhWmsConnectInfoVO another = new WhWmsConnectInfoVO();
                    BeanUtils.copyProperties(vo,another);
                    List<String> whCommandCodes = new ArrayList<>();
                    List<WhCommand> whCommands = new ArrayList<>();
                    List<String> failureShortageCommandCodes = new ArrayList<>();
                    another.setWhCommandsCodes(whCommandCodes);
                    another.setWhCommands(whCommands);
                    another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                    another.setInOutType(WhCommand.TYPE_ALLOT_OUT);
                    groupByPhysicalWhCode.put(physicalWh.getCode(),another);
                }
                WhWmsConnectInfoVO another = groupByPhysicalWhCode.get(physicalWh.getCode());
                another.getWhCommandsCodes().add(cmd.getCode());
                another.getWhCommands().add(cmd);
            }
            //得到按创建时间升序 并且同一个波次都是同一个目标物理仓的待处理数据
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : groupByPhysicalWhCode.values()) {
                List<WhWmsConnectInfoVO> others = divideConnectInfo(whWmsConnectInfoVO,count);
                if(EmptyUtil.isNotEmpty(others)){
                    result.addAll(others);
                }
                //result.add(whWmsConnectInfoVO);
            }
        }else if(!WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE.equals(vo.getConnectType())
                && (headCommand.getInOutType().equals(WhCommand.TYPE_SALES_OUT) || headCommand.getInOutType().equals(WhCommand.TYPE_CHANGE_OUT))){
            WhPhysicalWarehouse physicalWh = whInfoService.findPhysicalWarehouseByCode(headCommand.getPhysicalWarehouseCode());
            WhWmsWaitOutStockCond cond = new WhWmsWaitOutStockCond();
            cond.setCommandCodes(vo.getWhCommandsCodes());
            cond.setPhysicalWarehouseCode(physicalWh.getCode());
            List<Integer> inOutTypeList = new ArrayList<>();
            inOutTypeList.add(headCommand.getInOutType());
            cond.setInOutTypeList(inOutTypeList);
            List<WhWmsWaitOutStockVO> commandList = findWaitOutStockCommandByCond(cond);
            Map<String,WhWmsConnectInfoVO> groupByChannelCode = new HashMap<>();//key channelCode,value 波次VO
            for(WhWmsWaitOutStockVO command:commandList){
                String channelCode = command.getChannelCode();
                if(!groupByChannelCode.containsKey(channelCode)){
                    WhWmsConnectInfoVO another = new WhWmsConnectInfoVO();
                    BeanUtils.copyProperties(vo,another);
                    List<String> whCommandCodes = new ArrayList<>();
                    List<WhCommand> whCommands = new ArrayList<>();
                    List<String> failureShortageCommandCodes = new ArrayList<>();
                    another.setWhCommandsCodes(whCommandCodes);
                    another.setWhCommands(whCommands);
                    another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                    another.setInOutType(command.getInOutType());
                    another.setChannelCode(channelCode);
                    groupByChannelCode.put(channelCode, another);
                }
                WhWmsConnectInfoVO another = groupByChannelCode.get(channelCode);
                another.getWhCommandsCodes().add(command.getCode());
                // 标识是否为组合
                if (EmptyUtil.isNotEmpty(cmdCombineMap)){
                    command.setNeedConfirm(cmdCombineMap.get(command.getCode())==null?false:cmdCombineMap.get(command.getCode()));
                }
                another.getWhCommands().add(command);
            }
            //得到按渠道分组的待处理数据
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : groupByChannelCode.values()) {
                List<WhWmsConnectInfoVO> others = divideConnectInfo(whWmsConnectInfoVO,count);
                if(EmptyUtil.isNotEmpty(others)){
                    result.addAll(others);
                }
            }

        }else if(WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE.equals(vo.getConnectType()) ){//单品单件特殊处理
            WhPhysicalWarehouse physicalWh = whInfoService.findPhysicalWarehouseByCode(headCommand.getPhysicalWarehouseCode());
            WhWmsWaitOutStockCond cond = new WhWmsWaitOutStockCond();
            cond.setCommandCodes(vo.getWhCommandsCodes());
            cond.setPhysicalWarehouseCode(physicalWh.getCode());
            List<Integer> inOutTypeList = new ArrayList<>();
            inOutTypeList.add(headCommand.getInOutType());
            cond.setInOutTypeList(inOutTypeList);
            List<WhWmsWaitOutStockVO> commandList = findWaitOutStockCommandByCond(cond);
            Map<String,WhWmsConnectInfoVO> group = new HashMap<>();//key card_express_channel,value 波次VO
            for(WhWmsWaitOutStockVO command:commandList){
                String channelCode = command.getChannelCode();
                StringBuilder s = new StringBuilder();
                if(command.needCard()){
                    s.append("1|");
                }else{
                    s.append("2|");
                }
                s.append(command.getExpressType()).append("|");
                s.append(channelCode);
                String key = s.toString();
                if(!group.containsKey(key)){
                    WhWmsConnectInfoVO another = new WhWmsConnectInfoVO();
                    BeanUtils.copyProperties(vo,another);
                    List<String> whCommandCodes = new ArrayList<>();
                    List<WhCommand> whCommands = new ArrayList<>();
                    List<String> failureShortageCommandCodes = new ArrayList<>();
                    another.setWhCommandsCodes(whCommandCodes);
                    another.setWhCommands(whCommands);
                    another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                    another.setInOutType(command.getInOutType());
                    another.setChannelCode(channelCode);
                    group.put(key, another);
                }
                WhWmsConnectInfoVO another = group.get(key);
                another.getWhCommandsCodes().add(command.getCode());

                // 标识是否为组合
                if (EmptyUtil.isNotEmpty(cmdCombineMap)){
                    command.setNeedConfirm(cmdCombineMap.get(command.getCode())==null?false:cmdCombineMap.get(command.getCode()));
                }
                another.getWhCommands().add(command);
            }
            //得到按分组的待处理数据
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : group.values()) {
                List<WhWmsConnectInfoVO> others = divideConnectInfo(whWmsConnectInfoVO,count);
                if(EmptyUtil.isNotEmpty(others)){
                    result.addAll(others);
                }
            }
        }else{
            //非调拨出库
            int loops = new BigDecimal(vo.getWhCommandsCodes().size()).divide(new BigDecimal(count),0,BigDecimal.ROUND_UP).intValue() ;
            int i = 0;
            while (loops>0){
                WhWmsConnectInfoVO another = new WhWmsConnectInfoVO();
                BeanUtils.copyProperties(vo,another);
                List<String> whCommandCodes = new ArrayList<>();
                List<WhCommand> whCommands = new ArrayList<>();
                List<String> failureShortageCommandCodes = new ArrayList<>();
                another.setWhCommandsCodes(whCommandCodes);
                another.setWhCommands(whCommands);
                another.setFailureShortageCommandCodes(failureShortageCommandCodes);

                for(int j = 1;j<=count;j++){
                    if(i<vo.getWhCommandsCodes().size()){
                        int cursor = i++;
                        whCommandCodes.add(vo.getWhCommandsCodes().get(cursor));
                        whCommands.add(vo.getWhCommands().get(cursor));
                    }
                }

                if(CollectionUtils.isEmpty(whCommandCodes)){
                    break;
                }else{
                    result.add(another);
                }

                loops--;
            }
        }

        if(CollectionUtils.isEmpty(result)){
            return Collections.emptyList();
        }

        if (EmptyUtil.isEmpty(vo.getInOutType())){
            vo.setInOutType(headCommand.getInOutType());
        }
        // 波次启动时，订单内包含需要组装的商品时，此类订单单独集中到一个波次中启动。
        List<WhWmsConnectInfoVO> newResult = new ArrayList<>();
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : result) {
            List<String> whCommandCodes = new ArrayList<>();
            List<WhCommand> whCommands = new ArrayList<>();
            // 需要组合商品的启动波次
            WhWmsConnectInfoVO assambleProd = new WhWmsConnectInfoVO();
            BeanUtils.copyProperties(whWmsConnectInfoVO,assambleProd);
            assambleProd.setWhCommandsCodes(whCommandCodes);
            assambleProd.setWhCommands(whCommands);

            // 非组合商品的启动波次
            WhWmsConnectInfoVO noAssambleProd = new WhWmsConnectInfoVO();
            BeanUtils.copyProperties(whWmsConnectInfoVO,noAssambleProd);
            List<String> whCommandCodes2 = new ArrayList<>();
            List<WhCommand> whCommands2 = new ArrayList<>();
            noAssambleProd.setWhCommandsCodes(whCommandCodes2);
            noAssambleProd.setWhCommands(whCommands2);
            for (WhCommand whCommand : whWmsConnectInfoVO.getWhCommands()){
                if (whCommand.isNeedConfirm()){
                    assambleProd.getWhCommands().add(whCommand);
                    assambleProd.getWhCommandsCodes().add(whCommand.getCode());
                }else{
                    noAssambleProd.getWhCommands().add(whCommand);
                    noAssambleProd.getWhCommandsCodes().add(whCommand.getCode());
                }
            }
            if (CollectionUtils.isNotEmpty(assambleProd.getWhCommands())  && assambleProd.getWhCommands().size()>0){
                newResult.add(assambleProd);
            }
            if (CollectionUtils.isNotEmpty(noAssambleProd.getWhCommands())  && noAssambleProd.getWhCommands().size()>0){
                newResult.add(noAssambleProd);
            }
        }

        //create
        //vo = null;
        // 获取分布式锁
        String lockKey = "lock:wmsWh:create:connect_info";
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                log.info("获取锁失败 " + lockKey);
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : newResult) {
                create(whWmsConnectInfoVO);
            }
        }finally {
            redisDistributLock.unLock(lockKey);
        }
        return result;
    }

    @Override
    public List<WhWmsConnectCountVO> connectCount(String physicalWarehouseCode) {
        return mapper.connectCount(physicalWarehouseCode);
    }

    @Override
    @Transactional
    public boolean connectDistribute(WhWmsConnectDistributVO connectDistribut) {
        if(gtZero(connectDistribut.getSingleProductSinglePieceAmount())){
            mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode()
                    ,WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE
                    ,connectDistribut.getSingleProductSinglePieceAmount()
                    ,connectDistribut.getSingleProductSinglePieceIncludeSkuCode());
        }
        if(gtZero(connectDistribut.getMultiPieceActivityAmount())){
            mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode()
                    ,WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY
                    ,connectDistribut.getMultiPieceActivityAmount()
                    ,connectDistribut.getMultiPieceActivityIncludeSkuCode());
        }
        if(gtZero(connectDistribut.getMultiProductSinglePieceAmount())){
            mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode()
                    ,WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE
                    ,connectDistribut.getMultiProductSinglePieceAmount()
                    ,null);
        }
        if(gtZero(connectDistribut.getMultiProductMultiPieceAmount())){
            mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode()
                    ,WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE
                    ,connectDistribut.getMultiProductMultiPieceAmount()
                    ,null);
        }
        if(gtZero(connectDistribut.getBulkOrderAmount())){
            mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode()
                    ,WMSConstants.ConnectType.BULK_ORDER
                    ,connectDistribut.getBulkOrderAmount()
                    ,null);
        }
        if(gtZero(connectDistribut.getLargeSizedPackageAmount())){
            mapper.connectDistribute(connectDistribut.getPhysicalWarehouseCode()
                    ,WMSConstants.ConnectType.LARGE_SIZED_PACKAGE
                    ,connectDistribut.getLargeSizedPackageAmount()
                    ,null);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean connectDistribute(Long connectId) {
        WhWmsConnectInfoVO connectInfo = findById(connectId);
        if(NullUtil.isNull(connectInfo)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]波次不存在！",connectId));
        }
        if(NullUtil.isNotNull(connectInfo.getDistributeStatus())
                && PegasusConstants.YES == connectInfo.getDistributeStatus()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次已分发");
        }
        WhWmsConnectInfo update = new WhWmsConnectInfo();
        update.setId(connectId);
        update.setDistributeStatus(PegasusConstants.YES);
        mapper.updateByPrimaryKeySelective(update);
        return true;
    }

    private boolean gtZero(Integer num){
        return NullUtil.isNotNull(num) && num > 0;
    }

    @Override
    @Transactional
    public boolean startConnect(WhWmsConnectInfoVO connectInfo) throws Exception {
        createConnectInfo(connectInfo);
        //波次占用
        List<WhWmsOccupyVO> occupyList = buildOccupyFormPickStock(connectInfo);
        whWmsOccupyService.wmsBatchOccupy(occupyList);
        //波次拣货数据
        List<WhWmsConnectPickSkuVO> pickSkuList = connectInfo.getWhWmsConnectPickSkuVOs();
        if(EmptyUtil.isNotEmpty(pickSkuList)){
            for(WhWmsConnectPickSkuVO pickSku : pickSkuList){
                pickSku.setConnectId(connectInfo.getId());
            }
        }
        whWmsConnectPickSkuService.batchCreate(pickSkuList);
        //波次指令
        List<WhWmsCommandConnectVO> commandConnectList = new ArrayList<>();
        for(String commandCode : connectInfo.getWhCommandsCodes()){
            WhWmsCommandConnectVO commandConnect = new WhWmsCommandConnectVO();
            commandConnect.setConnectId(connectInfo.getId());
            commandConnect.setCommandCode(commandCode);
            commandConnect.setCancelFlag(PegasusConstants.NO);
            commandConnectList.add(commandConnect);
        }
        whWmsCommandConnectService.create(commandConnectList);
        //更新指令-待拣货
        whCommandService.batchUpdateCommandStatus(connectInfo.getWhCommandsCodes(),WhCommand.STATUS_PICKING,WhCommand.STATUS_IN_PROCESSING);
        //释放指令预占用
        whWmsCommandPreOccupyService.releasePreOccupyForConnectStart(connectInfo.getWhCommandsCodes());
        return true;
    }

    private List<WhWmsOccupyVO> buildOccupyFormPickStock(WhWmsConnectInfoVO connectInfo){
        List<WhWmsOccupyVO> occupyList = new ArrayList<>();
        for(WhWmsConnectPickSkuVO pickSku : connectInfo.getWhWmsConnectPickSkuVOs()){
            WhWmsOccupyVO occupy = BeanUtil.buildFrom(pickSku,WhWmsOccupyVO.class);
            occupy.setPhysicalWarehouseCode(connectInfo.getPhysicalWarehouseCode());
            occupy.setReceiptsNo(connectInfo.getId().toString());
            occupy.setOriShelvesCode(pickSku.getShelvesCode());
            occupy.setAmount(0-pickSku.getNeedAmount());
            occupy.setType(WhWmsOccupyVO.TYPE_CONNECT);
            occupyList.add(occupy);
        }
        return occupyList;
    }

    private boolean createConnectInfo(WhWmsConnectInfoVO vo){
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        mapper.insert(vo);
        return true;
    }

    @Override
    @Transactional
    public  List<WhWmsConnectInfoVO> createWhWmsConnectInfoAlt(WhWmsConnectInfoVO vo, int count) throws Exception {
    	if(count<=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"count<1");
        }
        boolean focusCreate = vo.isFocusCreate();
        validateCommandConnect(vo);
        List<WhWmsConnectInfoVO> result = new ArrayList<>();
        //调拨出库单独处理-调拨单单独启动
        Map<String,WhWmsConnectInfoVO> groupByPhysicalWhCode = new HashMap<>();//key 物理仓code,value 波次VO
        for (WhCommand cmd : vo.getWhCommands()) {
            WhAllotRcd allotRcd = whAllotService.findAllotRcdByCode(cmd.getReferenceCode(), false);
            if(allotRcd==null){
                throw new WarehouseException("","根据相关单据号找不到调拨单");
            }
            WhWmsConnectInfoVO connectInfoVO = new WhWmsConnectInfoVO();
            connectInfoVO = wrapConnectInfo(connectInfoVO,vo);
            connectInfoVO.getWhCommandsCodes().add(cmd.getCode());
            connectInfoVO.getWhCommands().add(cmd);
            groupByPhysicalWhCode.put(allotRcd.getCode(),connectInfoVO);
        }
        result.addAll(groupByPhysicalWhCode.values());

        if(CollectionUtils.isEmpty(result)){
            return Collections.emptyList();
        }

        // 获取分布式锁
        String lockKey = "lock:wmsWh:create:createWhWmsConnectInfoAlt";
        
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                log.info("获取锁失败 " + lockKey);
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : result) {
                createConnectInfoAlt(whWmsConnectInfoVO);
            }
        }finally {
            redisDistributLock.unLock(lockKey);
        }
        checkReceiveAreaStockForAlt(result);
        return result;

    }

    @Override
    @Transactional
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoRecWaste(WhWmsConnectInfoVO vo, int count) throws Exception {
        if(count<=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"count<1");
        }
        validateCommandConnect(vo);
        List<WhWmsConnectInfoVO> startList = new ArrayList<>();
        //报废领用单独处理-单独启动
        Map<String,WhWmsConnectInfoVO> groupBy = new HashMap<>();//key 物理仓code,value 波次VO
        for (WhCommand cmd : vo.getWhCommands()) {
            List<String> whCommandCodes = new ArrayList<>();
            List<WhCommand> whCommands = new ArrayList<>();
            List<String> failureShortageCommandCodes = new ArrayList<>();
            WhWmsConnectInfoVO connectInfoVO = BeanUtil.buildFrom(vo,WhWmsConnectInfoVO.class);
            connectInfoVO.setWhCommandsCodes(whCommandCodes);
            connectInfoVO.setWhCommands(whCommands);
            connectInfoVO.setFailureShortageCommandCodes(failureShortageCommandCodes);
            connectInfoVO.setInOutType(cmd.getInOutType());
            connectInfoVO.getWhCommandsCodes().add(cmd.getCode());
            connectInfoVO.getWhCommands().add(cmd);
            groupBy.put(cmd.getCode(),connectInfoVO);
        }
        startList.addAll(groupBy.values());
        if(EmptyUtil.isEmpty(startList)){
            return Collections.emptyList();
        }
        List<WhWmsConnectInfoVO> retList = new ArrayList<>();
        // 获取分布式锁
        String lockKey = "lock:wmsWh:create:createWhWmsConnectInfoRecWaste";
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                log.info("获取锁失败 " + lockKey);
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : startList) {
                WhWmsConnectInfoVO startedConnect = createConnectInfoRecWaste(whWmsConnectInfoVO);
                if(NullUtil.isNotNull(startedConnect)){
                    retList.add(startedConnect);
                }
            }
        }finally {
            redisDistributLock.unLock(lockKey);
        }
        return retList;
    }

    //检测收货暂存区库存
    private void checkReceiveAreaStockForAlt(List<WhWmsConnectInfoVO> connectInfos){
        if(EmptyUtil.isEmpty(connectInfos)){
            return;
        }
        //组织数据
        Map<String,Integer> cmdSkuQuantityMap = new HashMap<>();
        Map<String,Integer> connectSkuQuantityMap = new HashMap<>();
        for(WhWmsConnectInfoVO connectInfo : connectInfos){
            List<WhCommand> commandList = connectInfo.getWhCommands();
            if(EmptyUtil.isNotEmpty(commandList)){
                for(WhCommand command : commandList){
                    List<WhCommandSku> commandSkuList = command.getWhCommandSkuList();
                    if(EmptyUtil.isNotEmpty(commandSkuList)){
                        String key = null;
                        for(WhCommandSku commandSku : commandSkuList){
                            key = commandSku.getSkuCode();
                            Integer quantity = cmdSkuQuantityMap.get(key);
                            if(NullUtil.isNull(quantity)){
                                cmdSkuQuantityMap.put(key,commandSku.getPlanedQuantity());
                            }else{
                                cmdSkuQuantityMap.put(key,quantity+commandSku.getPlanedQuantity());
                            }
                        }
                    }
                }
            }
            List<WhWmsConnectPickSkuVO> pickSkuVOList = connectInfo.getWhWmsConnectPickSkuVOs();
            if(EmptyUtil.isNotEmpty(pickSkuVOList)){
                for(WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList){
                    Integer pickSkuAmount = connectSkuQuantityMap.get(pickSkuVO.getSkuCode());
                    if(NullUtil.isNull(pickSkuAmount)){
                        connectSkuQuantityMap.put(pickSkuVO.getSkuCode(),pickSkuVO.getNeedAmount());
                    }else{
                        connectSkuQuantityMap.put(pickSkuVO.getSkuCode(),pickSkuAmount+pickSkuVO.getNeedAmount());
                    }
                }
            }
        }

        List<String> cmdSkuList = new ArrayList<>();
        for(String skuCode : cmdSkuQuantityMap.keySet()){
            cmdSkuList.add(skuCode);
        }
        //计算差异
        for(String skuCode : cmdSkuList){
            Integer commandSkuQuantity =  cmdSkuQuantityMap.get(skuCode);
            Integer connectSkuQuantity = connectSkuQuantityMap.get(skuCode);
            if(NullUtil.isNull(connectSkuQuantity)){
                connectSkuQuantity = 0;
            }
            if(connectSkuQuantity<commandSkuQuantity){
                cmdSkuQuantityMap.put(skuCode,commandSkuQuantity-connectSkuQuantity);
            }else{
                cmdSkuQuantityMap.remove(skuCode);
            }
        }
        if(EmptyUtil.isEmpty(cmdSkuQuantityMap)){
            return;
        }
        StringBuilder buffer = new StringBuilder();
        for(Map.Entry<String,Integer> entry : cmdSkuQuantityMap.entrySet()){
            Integer diffQuantity = entry.getValue();
            if(diffQuantity > 0){
                buffer.append(entry.getKey()).append(";").append(entry.getValue()).append(",");
            }
        }
        //收货暂存区
        WhWmsConnectInfoVO connectInfo = connectInfos.get(0);
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setSkuCodeList(Arrays.asList(cmdSkuQuantityMap.keySet().toArray(new String[cmdSkuQuantityMap.keySet().size()])));
        cond.setSkuStatus(connectInfo.getSkuStatus());
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
        cond.setPhysicalWarehouseCode(connectInfo.getPhysicalWarehouseCode());
        List<WhWmsSkuStockVO> skuStockVOList = whWmsSkuStockService.getWmsSkuStockByVO(cond);
        StringBuilder sb = new StringBuilder();
        if(EmptyUtil.isNotEmpty(skuStockVOList)){
            Map<String,Integer> receiveSkuQuantityMap = new HashMap<>();
            String key = null;
            for(WhWmsSkuStockVO skuStockVO : skuStockVOList){
                if(NullUtil.isNull(skuStockVO.getAmount())
                        || skuStockVO.getAmount()<=0){
                    continue;
                }
                key = skuStockVO.getSkuCode();
                Integer quantity = receiveSkuQuantityMap.get(key);
                if(NullUtil.isNull(quantity)){
                    receiveSkuQuantityMap.put(key,skuStockVO.getAmount());
                }else{
                    receiveSkuQuantityMap.put(key,skuStockVO.getAmount()+quantity);
                }
            }
            for(Map.Entry<String,Integer> entry : cmdSkuQuantityMap.entrySet()){
                Integer diffQuantity = entry.getValue();
                if(diffQuantity > 0){
                    sb.append(entry.getKey()).append(";").append(entry.getValue()).append(",");
                }
            }
        }
        String receiveStr = sb.toString();
        if(EmptyUtil.isNotEmpty(receiveStr)){
            buffer.append("--").append(receiveStr);
        }
        throw new WarehouseException(WarehouseExceptionErrorCode.ALT_SKU_RECEIVEING,buffer.toString());
    }


    //检测收货暂存区库存
    private void checkReceiveAreaStock(List<WhWmsConnectInfoVO> connectInfos){
        if(EmptyUtil.isEmpty(connectInfos)){
            return;
        }
        //组织数据
        Map<String,Integer> cmdSkuQuantityMap = new HashMap<>();
        Map<String,Integer> connectSkuQuantityMap = new HashMap<>();
        for(WhWmsConnectInfoVO connectInfo : connectInfos){
            List<WhCommand> commandList = connectInfo.getWhCommands();
            if(EmptyUtil.isNotEmpty(commandList)){
                for(WhCommand command : commandList){
                    List<WhCommandSku> commandSkuList = command.getWhCommandSkuList();
                    if(EmptyUtil.isNotEmpty(commandSkuList)){
                        String key = null;
                        for(WhCommandSku commandSku : commandSkuList){
                            key = commandSku.getSkuCode();
                            Integer quantity = cmdSkuQuantityMap.get(key);
                            if(NullUtil.isNull(quantity)){
                                cmdSkuQuantityMap.put(key,commandSku.getPlanedQuantity());
                            }else{
                                cmdSkuQuantityMap.put(key,quantity+commandSku.getPlanedQuantity());
                            }
                        }
                    }
                }
            }
            List<WhWmsConnectPickSkuVO> pickSkuVOList = connectInfo.getWhWmsConnectPickSkuVOs();
            if(EmptyUtil.isNotEmpty(pickSkuVOList)){
                for(WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList){
                    Integer pickSkuAmount = connectSkuQuantityMap.get(pickSkuVO.getSkuCode());
                    if(NullUtil.isNull(pickSkuAmount)){
                        connectSkuQuantityMap.put(pickSkuVO.getSkuCode(),pickSkuVO.getNeedAmount());
                    }else{
                        connectSkuQuantityMap.put(pickSkuVO.getSkuCode(),pickSkuAmount+pickSkuVO.getNeedAmount());
                    }
                }
            }
        }

        List<String> cmdSkuList = new ArrayList<>();
        for(String skuCode : cmdSkuQuantityMap.keySet()){
            cmdSkuList.add(skuCode);
        }
        //计算差异
        for(String skuCode : cmdSkuList){
            Integer commandSkuQuantity =  cmdSkuQuantityMap.get(skuCode);
            Integer connectSkuQuantity = connectSkuQuantityMap.get(skuCode);
            if(NullUtil.isNull(connectSkuQuantity)){
                connectSkuQuantity = 0;
            }
            if(connectSkuQuantity<commandSkuQuantity){
                cmdSkuQuantityMap.put(skuCode,commandSkuQuantity-connectSkuQuantity);
            }else{
                cmdSkuQuantityMap.remove(skuCode);
            }
        }
        if(EmptyUtil.isEmpty(cmdSkuQuantityMap)){
            return;
        }
        //收货暂存区
        WhWmsConnectInfoVO connectInfo = connectInfos.get(0);
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setSkuCodeList(Arrays.asList(cmdSkuQuantityMap.keySet().toArray(new String[cmdSkuQuantityMap.keySet().size()])));
        cond.setSkuStatus(connectInfo.getSkuStatus());
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
        cond.setPhysicalWarehouseCode(connectInfo.getPhysicalWarehouseCode());
        List<WhWmsSkuStockVO> skuStockVOList = whWmsSkuStockService.getWmsSkuStockByVO(cond);
        if(EmptyUtil.isNotEmpty(skuStockVOList)){
            Map<String,Integer> receiveSkuQuantityMap = new HashMap<>();
            String key = null;
            for(WhWmsSkuStockVO skuStockVO : skuStockVOList){
                if(NullUtil.isNull(skuStockVO.getAmount())
                        || skuStockVO.getAmount()<=0){
                    continue;
                }
                key = skuStockVO.getSkuCode();
                Integer quantity = receiveSkuQuantityMap.get(key);
                if(NullUtil.isNull(quantity)){
                    receiveSkuQuantityMap.put(key,skuStockVO.getAmount());
                }else{
                    receiveSkuQuantityMap.put(key,skuStockVO.getAmount()+quantity);
                }
            }
            StringBuilder sb = new StringBuilder();
            for(String skuCode : receiveSkuQuantityMap.keySet()){
                sb.append(skuCode).append(",");
            }
            String skuCodes = sb.toString();
            if(EmptyUtil.isNotEmpty(skuCodes)){
                throw new WarehouseException(WarehouseExceptionErrorCode.ALT_SKU_RECEIVEING,skuCodes);
            }
        }
    }

    private WhWmsConnectInfoVO wrapConnectInfo(WhWmsConnectInfoVO another,WhWmsConnectInfoVO vo){
        BeanUtils.copyProperties(vo,another);
        List<String> whCommandCodes = new ArrayList<>();
        List<WhCommand> whCommands = new ArrayList<>();
        List<String> failureShortageCommandCodes = new ArrayList<>();
        another.setWhCommandsCodes(whCommandCodes);
        another.setWhCommands(whCommands);
        another.setFailureShortageCommandCodes(failureShortageCommandCodes);
        another.setInOutType(WhCommand.TYPE_ALLOT_OUT);
        return another;
    }
    //检测调拨库存
    private void checkAltStock(List<WhWmsConnectInfoVO> connectInfos){
        if(EmptyUtil.isEmpty(connectInfos)){
            return;
        }
        //组织数据
        Map<String,Integer> cmdSkuQuantityMap = new HashMap<>();
        Map<String,Integer> connectSkuQuantityMap = new HashMap<>();
        for(WhWmsConnectInfoVO connectInfo : connectInfos){
            List<WhCommand> commandList = connectInfo.getWhCommands();
            if(EmptyUtil.isNotEmpty(commandList)){
                for(WhCommand command : commandList){
                    List<WhCommandSku> commandSkuList = command.getWhCommandSkuList();
                    if(EmptyUtil.isNotEmpty(commandSkuList)){
                        String key = null;
                        for(WhCommandSku commandSku : commandSkuList){
                            key = commandSku.getSkuCode();
                            Integer quantity = cmdSkuQuantityMap.get(key);
                            if(NullUtil.isNull(quantity)){
                                cmdSkuQuantityMap.put(key,commandSku.getPlanedQuantity());
                            }else{
                                cmdSkuQuantityMap.put(key,quantity+commandSku.getPlanedQuantity());
                            }
                        }
                    }
                }
            }
            List<WhWmsConnectPickSkuVO> pickSkuVOList = connectInfo.getWhWmsConnectPickSkuVOs();
            if(EmptyUtil.isNotEmpty(pickSkuVOList)){
                for(WhWmsConnectPickSkuVO pickSkuVO : pickSkuVOList){
                    connectSkuQuantityMap.put(pickSkuVO.getSkuCode(),pickSkuVO.getNeedAmount());
                }
            }
        }

        List<String> cmdSkuList = new ArrayList<>();
        for(String skuCode : cmdSkuQuantityMap.keySet()){
            cmdSkuList.add(skuCode);
        }
        //计算差异
        for(String skuCode : cmdSkuList){
            Integer commandSkuQuantity =  cmdSkuQuantityMap.get(skuCode);
            Integer connectSkuQuantity = connectSkuQuantityMap.get(skuCode);
            if(NullUtil.isNull(connectSkuQuantity)){
                connectSkuQuantity = 0;
            }
            if(connectSkuQuantity<commandSkuQuantity){
                cmdSkuQuantityMap.put(skuCode,commandSkuQuantity-connectSkuQuantity);
            }else{
                cmdSkuQuantityMap.remove(skuCode);
            }
        }
        if(EmptyUtil.isEmpty(cmdSkuQuantityMap)){
            return;
        }
        //收货暂存区
        WhWmsConnectInfoVO connectInfo = connectInfos.get(0);
        WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
        cond.setSkuCodeList(Arrays.asList(cmdSkuQuantityMap.keySet().toArray(new String[cmdSkuQuantityMap.keySet().size()])));
        cond.setSkuStatus(connectInfo.getSkuStatus());
        cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_RECEIVE);
        cond.setPhysicalWarehouseCode(connectInfo.getPhysicalWarehouseCode());
        List<WhWmsSkuStockVO> skuStockVOList = whWmsSkuStockService.getWmsSkuStockByVO(cond);
        if(EmptyUtil.isNotEmpty(skuStockVOList)){
            Map<String,Integer> receiveSkuQuantityMap = new HashMap<>();
            String key = null;
            for(WhWmsSkuStockVO skuStockVO : skuStockVOList){
                if(NullUtil.isNull(skuStockVO.getAmount())
                        || skuStockVO.getAmount()<=0){
                    continue;
                }
                key = skuStockVO.getSkuCode();
                Integer quantity = receiveSkuQuantityMap.get(key);
                if(NullUtil.isNull(quantity)){
                    receiveSkuQuantityMap.put(key,skuStockVO.getAmount());
                }else{
                    receiveSkuQuantityMap.put(key,skuStockVO.getAmount()+quantity);
                }
            }
            StringBuilder sb = new StringBuilder();
            for(String skuCode : receiveSkuQuantityMap.keySet()){
                sb.append(skuCode).append(",");
            }
            String skuCodes = sb.toString();
            if(EmptyUtil.isNotEmpty(skuCodes)){
                throw new WarehouseException(WarehouseExceptionErrorCode.ALT_SKU_RECEIVEING,skuCodes);
            }
        }
    }
    
    @Override
    @Transactional
    public List<WhWmsConnectInfoVO> createWhWmsConnectInfoPcsRtn(WhWmsConnectInfoVO vo, int count) throws Exception {
    	if(count<=0){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"count<1");
        }

        validateCommandConnect(vo);
        List<WhWmsConnectInfoVO> result = new ArrayList<>();
        //同一采退单下的指令一个波次
        Map<String,WhWmsConnectInfoVO> groupByPurchaseReturnCode = new HashMap<>();//key groupByPurchaseReturnCode,value 波次VO
        for (WhCommand cmd : vo.getWhCommands()) {
            String purchaseReturnCode = cmd.getReferenceCode();
            if(NullUtil.isNull(purchaseReturnCode)){
                throw new WarehouseException("","采购单号不存在");
            }
            if(!groupByPurchaseReturnCode.containsKey(purchaseReturnCode)){
                WhWmsConnectInfoVO another = new WhWmsConnectInfoVO();
                BeanUtils.copyProperties(vo,another);
                List<String> whCommandCodes = new ArrayList<>();
                List<WhCommand> whCommands = new ArrayList<>();
                List<String> failureShortageCommandCodes = new ArrayList<>();
                another.setWhCommandsCodes(whCommandCodes);
                another.setWhCommands(whCommands);
                another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                another.setInOutType(WhCommand.TYPE_PURCHASE_RETURN_OUT);
                groupByPurchaseReturnCode.put(purchaseReturnCode,another);
            }
            WhWmsConnectInfoVO another = groupByPurchaseReturnCode.get(purchaseReturnCode);
            another.getWhCommandsCodes().add(cmd.getCode());
            another.getWhCommands().add(cmd);
        }
        //得到按创建时间升序 并且同一个波次都是同一个采退单的待处理数据
        for (WhWmsConnectInfoVO whWmsConnectInfoVO : groupByPurchaseReturnCode.values()) {
            List<WhWmsConnectInfoVO> others = divideConnectInfo(whWmsConnectInfoVO,count);
            if(EmptyUtil.isNotEmpty(others)){
                result.addAll(others);
            }
        }

        if(CollectionUtils.isEmpty(result)){
            return Collections.emptyList();
        }

        //获取分布式锁
        String lockKey = "lock:wmsWh:create:createWhWmsConnectInfoPcsRtn";
        try{
            Boolean getLock = redisDistributLock.tryLock(lockKey,3L, TimeUnit.MINUTES);
            if (!getLock){
                log.info("获取锁失败 " + lockKey);
                throw new WarehouseException(
                        WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                        "请稍后重试!");
            }
            for (WhWmsConnectInfoVO whWmsConnectInfoVO : result) {
                createConnectInfoPcsRtn(whWmsConnectInfoVO);
            }
        }finally {
            redisDistributLock.unLock(lockKey);
        }
        boolean focusCreate = vo.isFocusCreate();
        if(!focusCreate){
            checkReceiveAreaStock(result);
        }
        return result;

    }
    
    
    
    
    /**
     * 分割波次
     * */
    private List<WhWmsConnectInfoVO> divideConnectInfo(WhWmsConnectInfoVO connectInfo,int count){
    	List<WhWmsConnectInfoVO> list = new ArrayList<>();
    	List<String> commandCodes = connectInfo.getWhCommandsCodes();
    	List<WhCommand> commands = connectInfo.getWhCommands();
    	if(EmptyUtil.isEmpty(commandCodes)){
    		return list;
    	}
    	int size = commandCodes.size();
    	WhWmsConnectInfoVO another = null;
    	for(int i=0;i<size;i++){
    		if(i%count==0){
    			another = new WhWmsConnectInfoVO();
                BeanUtils.copyProperties(connectInfo,another);
                List<String> whCommandCodes = new ArrayList<>();
                List<WhCommand> whCommands = new ArrayList<>();
                List<String> failureShortageCommandCodes = new ArrayList<>();
                another.setWhCommandsCodes(whCommandCodes);
                another.setWhCommands(whCommands);
                another.setFailureShortageCommandCodes(failureShortageCommandCodes);
                list.add(another);
    		}
    		another.getWhCommandsCodes().add(commandCodes.get(i));
    		another.getWhCommands().add(commands.get(i));
    	}
    	
    	return list;
    }

    /**
     * 创建波次-调拨
     * */
    private WhWmsConnectInfoVO createConnectInfoRecWaste(WhWmsConnectInfoVO vo) throws Exception{
        validateBeforeCreate(vo);
        if(EmptyUtil.isEmpty(vo.getWhCommandsCodes())){
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);//废品
        if(NullUtil.isNull(vo.getDistributeStatus())){
            vo.setDistributeStatus(PegasusConstants.YES);//默认已分发
        }
        WhWmsConnectInfo whWmsConnectInfo = BeanUtil.buildFrom(vo, WhWmsConnectInfo.class);
        mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        //create WhWmsCommandConnect
        List<WhWmsCommandConnectVO> connectInfoList = whWmsCommandConnectService.createConnectInfoRecWaste(vo);
        if(EmptyUtil.isNotEmpty(connectInfoList)){
//            for(WhWmsCommandConnectVO commandConnect : connectInfoList){
//                WhCommand cmd = whCommandService.findCommandByCode(commandConnect.getCommandCode(),false);
//                cmd.setInOutType(WhCommand.TYPE_RECEIVE_WASTE_OUT);//更改指令出库类型
//                whCommandService.updateCommand(cmd);
//            }

            vo.getWhWmsCommandConnectVOs().addAll(connectInfoList);
            //afterCreate
            //根据波次占用生成拣货任务
            WhWmsOccupyVO cond = new WhWmsOccupyVO();
            cond.setReceiptsNo(vo.getId().toString());
            List<WhWmsOccupyVO> occupyVOList = whWmsOccupyService.getWmsOccupyByCond(cond);
            createConnectPickSkuByOccupy(vo,occupyVOList);
        }
        return vo;
    }
    
    /**
     * 创建波次-采退
     * */
    private WhWmsConnectInfoVO createConnectInfoPcsRtn(WhWmsConnectInfoVO vo) throws Exception{
    	validateBeforeCreate(vo);
        if(CollectionUtils.isEmpty(vo.getWhCommandsCodes())){
            return null;
        }

        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        if(NullUtil.isNull(vo.getDistributeStatus())){
            vo.setDistributeStatus(PegasusConstants.YES);//默认已分发
        }
        WhWmsConnectInfo whWmsConnectInfo = BeanUtil.buildFrom(vo, WhWmsConnectInfo.class);
        mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        //create WhWmsCommandConnect
        List<WhWmsCommandConnectVO> connectInfoList = whWmsCommandConnectService.createConnectInfoPcsRtn(vo);
        vo.getWhWmsCommandConnectVOs().addAll(connectInfoList);
        //afterCreate
        afterCreatePcsRtnConnectInfo(vo);
        return vo;

    }
    
    /**
     * 创建波次-调拨
     * */
    private WhWmsConnectInfoVO createConnectInfoAlt(WhWmsConnectInfoVO vo) throws Exception{
    	validateBeforeCreate(vo);
        if(CollectionUtils.isEmpty(vo.getWhCommandsCodes())){
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        if(NullUtil.isNull(vo.getDistributeStatus())){
            vo.setDistributeStatus(PegasusConstants.YES);//默认已分发
        }
        WhWmsConnectInfo whWmsConnectInfo = BeanUtil.buildFrom(vo, WhWmsConnectInfo.class);
        mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        //create WhWmsCommandConnect
        List<WhWmsCommandConnectVO> connectInfoList = whWmsCommandConnectService.createConnectInfoAlt(vo);
        vo.getWhWmsCommandConnectVOs().addAll(connectInfoList);
        //afterCreate
        afterCreateAltConnectInfo(vo);
        return vo;
    }
    
    @Override
    public WhWmsConnectInfoVO create(WhWmsConnectInfoVO vo) throws Exception {
        //create WhWmsConnectInfo
        validateBeforeCreate(vo);
        if(CollectionUtils.isEmpty(vo.getWhCommandsCodes())){
            return null;
        }
        vo.setConnectDate(DateUtil.getNow());
        vo.setConnectStatus(WMSConstants.ConnectStatus.WAITING_PROCESS);
        WhWmsConnectInfo whWmsConnectInfo = BeanUtil.buildFrom(vo, WhWmsConnectInfo.class);
        mapper.insert(whWmsConnectInfo);
        vo.setId(whWmsConnectInfo.getId());
        //create WhWmsCommandConnect
        vo.getWhWmsCommandConnectVOs().addAll(whWmsCommandConnectService.create(vo));
       //afterCreate
        afterCreate(vo);
        return vo;

    }

    @Override
    public Boolean update(WhWmsConnectInfoVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo,WhWmsConnectInfo.class))!=0;
    }

    @Override
    public Boolean connectStatusTransform(Long connectId, Integer beforeStatus, Integer afterStatus) {
        return connectStatusTransform(Collections.singleton(connectId),beforeStatus,afterStatus);
    }

    private boolean connectStatusTransform(Set<Long> connectIds,Integer beforeStatus, Integer afterStatus){
        int count = mapper.connectStatusTransform(connectIds,beforeStatus,afterStatus);
        return count == connectIds.size();
    }

    @Override
    public boolean deleteById(Long id) {
        return mapper.deleteByPrimaryKey(id)!=0;
    }

    @Override
    @Transactional
    public boolean cancelConnect(List<Long> idList) {
        WhWmsConnectInfoCond cond = new WhWmsConnectInfoCond();
        cond.setConnectIds(idList);
        List<WhWmsConnectInfo> connectList = mapper.findByCond(cond);
        if(EmptyUtil.isEmpty(connectList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无波次数据！");
        }
        List<Long> connectIdList = connectCancelCheck(connectList);
        Set<Long> ids = new HashSet<>();
        ids.addAll(connectIdList);
        //波次状态取消
        boolean result = connectStatusTransform(ids,WMSConstants.ConnectStatus.WAITING_PROCESS,WMSConstants.ConnectStatus.CANCELED);
        if(!result){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次状态不是待拣货");
        }
        //取消拣货行信息
        result = whWmsConnectPickSkuService.cancelConnectPickSku(connectIdList);
        if(!result){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"已开始拣货不可取消！");
        }
        //释放波次占用
        whWmsOccupyService.releaseWmsOccupyByConnectId(connectIdList);
        //删除拣货周转箱
        deleteConnectTurnoverBox(connectIdList);
        //波次指令关系打取消标记
        whWmsCommandConnectService.batchCancelByConnectId(connectIdList);
        //波次指令待启动
        WhWmsCommandConnectCond cmdConnectCond = new WhWmsCommandConnectCond();
        cmdConnectCond.setConnectIds(connectIdList);
        List<WhWmsCommandConnectVO> commandConnectList = whWmsCommandConnectService.findByCond(cmdConnectCond);
        if(EmptyUtil.isNotEmpty(commandConnectList)){
            List<String> commandCodes = new ArrayList<>();
            for(WhWmsCommandConnectVO commandConnect : commandConnectList){
                commandCodes.add(commandConnect.getCommandCode());
            }
            whCommandService.batchUpdateCommandStatus(commandCodes,WhCommand.STATUS_IN_PROCESSING,WhCommand.STATUS_PICKING);
            //删除预占记录key,否则无法重新占用
            whWmsCommandPreOccupyIdxMapper.batchDelete(commandCodes);
        }
        return true;
    }

    private boolean deleteConnectTurnoverBox(List<Long> connectIds){
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria().andConnectIdIn(connectIds);
        //软删除
        WhWmsConnectTurnoverBox whWmsConnectTurnoverBox = new WhWmsConnectTurnoverBox();
        whWmsConnectTurnoverBox.setCancelFlag(PegasusConstants.YES);
        boxMapper.updateByExampleSelective(whWmsConnectTurnoverBox,boxExample);
        return true;
    }

    private List<Long> connectCancelCheck(List<WhWmsConnectInfo> connectList){
        List<String> referenceCodes = new ArrayList<>();
        List<Long> connectIdList = new ArrayList<>();
        for(WhWmsConnectInfo connectInfo : connectList){
            connectIdList.add(connectInfo.getId());
            referenceCodes.add(connectInfo.getId().toString());
            if(!WMSConstants.ConnectStatus.WAITING_PROCESS.equals(connectInfo.getConnectStatus())){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("波次[%s]当前状态为%s,不可取消"
                        ,connectInfo.getId(),WhWmsConnectInfoVO.getConnectStatusStr(connectInfo.getConnectStatus())));
            }
        }
        WhWmsTaskAssignCond taskCond = new WhWmsTaskAssignCond();
        taskCond.setType(WhWmsTaskAssignVO.TASK_TYPE_CONNPICKSKU);
        taskCond.setReferenceCodeList(referenceCodes);
        List<WhWmsTaskAssignVO> taskList = whWmsTaskAssignService.findWhWmsTaskAssignByCond(taskCond);
        if(EmptyUtil.isNotEmpty(taskList)){
            StringBuilder buff = new StringBuilder();
            for(WhWmsTaskAssignVO taskAssign : taskList){
                buff.append(String.format("波次[%s]已领取无法取消!<br/>",taskAssign.getReferenceCode()));
            }
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,buff.toString());
        }
        return connectIdList;
    }

    @Override
    public WhWmsConnectInfoVO findById(Long id) {
        WhWmsConnectInfo whWmsConnectInfo = mapper.selectByPrimaryKey(id);
        if(whWmsConnectInfo!=null){
            return BeanUtil.buildFrom(whWmsConnectInfo,WhWmsConnectInfoVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsConnectInfoVO> findNeedHandleConnect() {
        List<WhWmsConnectInfo> list = mapper.findNeedHandleConnect();
        if(EmptyUtil.isEmpty(list)){
            return Collections.emptyList();
        }
        return BeanUtil.buildListFrom(list,WhWmsConnectInfoVO.class);
    }

    @Override
    public List<WhWmsConnectInfo> findConnectInfoByCond(WhWmsConnectInfoCond cond) {
        return mapper.findByCond(cond);
    }

    @Override
    public Pagination<WhWmsConnectInfoVO> findByCond(WhWmsConnectInfoCond cond) {
        Pagination<WhWmsConnectInfoVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        List<WhWmsConnectInfo> whWmsConnectInfos = mapper.findByCond(cond);
        Integer counts = mapper.countFindByCond(cond);
        if (CollectionUtils.isEmpty(whWmsConnectInfos)) {
            return page;
        }
        List<WhWmsConnectInfoVO> vos = new ArrayList<WhWmsConnectInfoVO>(whWmsConnectInfos.size());
        List<Long> connectIds = new ArrayList<>();
        for (WhWmsConnectInfo whWmsConnectInfo : whWmsConnectInfos) {
            connectIds.add(whWmsConnectInfo.getId());
            WhWmsConnectInfoVO whWmsConnectInfoVO = BeanUtil.buildFrom(whWmsConnectInfo, WhWmsConnectInfoVO.class);
            //whWmsConnectInfoVO.setCmdConnectCount(whWmsCommandConnectService.findCountByConnectId(whWmsConnectInfoVO.getId()));
            vos.add(whWmsConnectInfoVO);
        }
        List<WhCountVO> countList = whWmsCommandConnectService.countConnectCommandByConnectId(connectIds);
        if(EmptyUtil.isNotEmpty(countList)){
            Map<String,WhCountVO> countMap = new HashMap<>();
            for(WhCountVO count : countList){
                countMap.put(count.getCode(),count);
            }
            for(WhWmsConnectInfoVO vo : vos){
                WhCountVO count = countMap.get(vo.getId().toString());
                if(NullUtil.isNotNull(count)){
                    vo.setCmdConnectCount(count.getAmount());
                }
            }
        }
        page.setResultList(vos);
        page.setRecord(counts);
        return page;
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandByCond(WhWmsWaitOutStockCond cond) {
        if(EmptyUtil.isEmpty(cond.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"物理仓编码必填");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if(CollectionUtils.isEmpty(cond.getInOutTypeList())){
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }
        List<WhWmsWaitOutStockVO> vos = whCommandService.findWaitOutStockCommandByCond(cond);
        if(CollectionUtils.isEmpty(vos)){
            return Collections.emptyList();
        }else{
            return vos;
        }
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandSaleOutByCond(WhWmsWaitOutStockCond cond) {
        if(EmptyUtil.isEmpty(cond.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"物理仓编码必填");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if(CollectionUtils.isEmpty(cond.getInOutTypeList())){
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }
        return whCommandService.findWaitOutStockCommandSaleOutByCond(cond);
    }

    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandAltByCond(WhWmsWaitOutStockCondAlt cond) {
        if(EmptyUtil.isEmpty(cond.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"物理仓编码必填");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if(CollectionUtils.isEmpty(cond.getInOutTypeList())){
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }

        List<WhWmsWaitOutStockVO> vos = whCommandService.findWaitOutStockCommandAltByCond(cond);
        if(CollectionUtils.isEmpty(vos)){
            return Collections.emptyList();
        }else{
            return vos;
        }
    }
    
    @Override
    public List<WhWmsWaitOutStockVO> findWaitOutStockCommandPcsRtnByCond(WhWmsWaitOutStockCondPcsRtn cond) {
        if(EmptyUtil.isEmpty(cond.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"物理仓编码必填");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if(CollectionUtils.isEmpty(cond.getInOutTypeList())){
            cond.setInOutTypeList(WhCommand.getAllOutType());
        }

        List<WhWmsWaitOutStockVO> vos = whCommandService.findWaitOutStockCommandPcsRtnByCond(cond);
        if(CollectionUtils.isEmpty(vos)){
            return Collections.emptyList();
        }else{
            return vos;
        }
    }

    @Override
    public Pagination<WhWmsWaitOutStockVO> findWaitOutStockCommandRecWasteByCond(WhWmsWaitOutStockCondRecWaste cond){
        if(EmptyUtil.isEmpty(cond.getPhysicalWarehouseCode())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"物理仓编码必填");
        }
        cond.setFetch(true);
        cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        return whCommandService.findWaitOutStockCommandRecWasteByCond(cond);
    }
    
    
    /**
     * 调拨打包
     * */
    @Override
    @Transactional
    public boolean submitConnectAltCheck(WhWmsConnectAllotPackageVO packageVO) throws Exception{
    	Long connectId = packageVO.getConnectId();
    	if(EmptyUtil.isNotEmpty(packageVO.getDetails())){
            checkAltPackageInfo(packageVO);
    		whWmsConnectAllotPackageService.add(packageVO);
    	}
    	List<WhWmsConnectPickSkuVO> pickSkuList = whWmsConnectPickSkuService.findByConnectId(connectId);
    	List<WhWmsConnectAllotPackageDetailVO> packedDetailList = whWmsConnectAllotPackageService.findConnectAltPackageDetailsByConnectId(connectId);
    	if(NullUtil.isNull(packedDetailList)){
    		packedDetailList = new ArrayList<>();
    	}
    	//波次是否完成
    	boolean finished = packageVO.isFocusFinish() || checkConnectAltFinished(pickSkuList,packedDetailList);

    	if(finished){
    		packageVO.setConnectAltDone(true);
    		finishConnectAlt(connectId,pickSkuList,packedDetailList,packageVO.getOperatorId());
    	}
		return true;
    }

    //检查打包数据是否合法，存在并发问题
    private boolean checkAltPackageInfo(WhWmsConnectAllotPackageVO packageVO){
        List<WhWmsConnectPickSkuVO> picSkuList = whWmsConnectPickSkuService.findByConnectId(packageVO.getConnectId());
        if(EmptyUtil.isEmpty(packageVO.getDetails())){
            return true;
        }
        if(EmptyUtil.isEmpty(picSkuList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"无拣货数据");
        }
        Map<String,Integer> skuQuantityMap = new HashMap<>();
        for(WhWmsConnectPickSkuVO pickSku :  picSkuList){
            Integer pickSkuQuantity = skuQuantityMap.get(pickSku.getSkuCode());
            if(NullUtil.isNull(pickSkuQuantity)){
                pickSkuQuantity = pickSku.getActualAmount();
            }else{
                pickSkuQuantity += pickSku.getActualAmount();
            }
            skuQuantityMap.put(pickSku.getSkuCode(),pickSkuQuantity);
        }
        //装箱数
        List<WhWmsConnectAllotPackageVO> allotPackageList = whWmsConnectAllotPackageService.findByConnectId(packageVO.getConnectId());
        if(EmptyUtil.isNotEmpty(allotPackageList)){
            for(WhWmsConnectAllotPackageVO allotPackage : allotPackageList){
                List<WhWmsConnectAllotPackageDetailVO> packageDetailList = allotPackage.getDetails();
                if(EmptyUtil.isNotEmpty(packageDetailList)){
                    for(WhWmsConnectAllotPackageDetailVO detail : packageDetailList){
                        Integer pickSkuQuantity = skuQuantityMap.get(detail.getSkuCode());
                        if(NullUtil.isNull(pickSkuQuantity)){
                            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]无拣货记录",detail.getSkuCode()));
                        }
                        skuQuantityMap.put(detail.getSkuCode(),pickSkuQuantity-detail.getQuantity());
                    }
                }
            }
        }
        //检查本次装箱数
        for(WhWmsConnectAllotPackageDetailVO detail : packageVO.getDetails()){
            Integer pickSkuQuantity = skuQuantityMap.get(detail.getSkuCode());
            if(NullUtil.isNull(pickSkuQuantity)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]无拣货记录",detail.getSkuCode()));
            }
            if(pickSkuQuantity < detail.getQuantity()){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]打包数量过多[%d<%d]",detail.getSkuCode(),pickSkuQuantity,detail.getQuantity()));
            }else {
                skuQuantityMap.put(detail.getSkuCode(),pickSkuQuantity-detail.getQuantity());
            }
        }
        return true;
    }

    /**
     * 完成波次-调拨
     * */
    private boolean finishConnectAlt(Long connectId,
    		final List<WhWmsConnectPickSkuVO> pickSkuList,
    		final List<WhWmsConnectAllotPackageDetailVO> packedDetailList,Long operatorId) throws Exception{
    	WhWmsConnectInfoVO connect = findById(connectId);
    	if(!WMSConstants.ConnectStatus.WAITING_PACK.equals(connect.getConnectStatus())){
    		throw new WarehouseException("波次状态不是待打包");
    	}
    	//删除所有波次绑定的拣货箱
        delConnectBox(connectId);
    	//更新波次为已完成
    	connect.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
    	update(connect);
    	//波次-指令
    	List<WhWmsCommandConnectVO> commandConnectList = whWmsCommandConnectService.findNotCanceledByConnectId(connectId);
    	if(EmptyUtil.isEmpty(commandConnectList)){
    		throw new WarehouseException("波次状态下指令已全部取消");
    	}
    	List<String> commandCodes = new ArrayList<>();
    	for(WhWmsCommandConnectVO cmdConn : commandConnectList){
    		commandCodes.add(cmdConn.getCommandCode());
    	}
    	List<WhCommand> commandList = this.whCommandService.findCommandByCodes(commandCodes, true);
    	//填充数据
    	fullAltCommand(connect,commandList,packedDetailList);
        //过滤无库存的指令
    	//List<WhCommand> shortageList = filterShortageCommand(commandList);
    	//处理commandList
        for (WhCommand whCommand : commandList) {
            //完成指令，同时更新调拨单数据
            whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            whCommand.setOperatorId(operatorId);
            whCommandService.finishCommand(whCommand);
            //状态修改为发货完成。无库存的调拨自动完成
            whCommandService.updateCommandStatusById(whCommand.getId().intValue(),WhCommand.STATUS_DELIVERYCOMPLETION);
        }
        //缺货的调拨直接完成
//        for (WhCommand whCommand : shortageList) {
//        	whAllotService.updateAllotRcdStatusByCode(whCommand.getReferenceCode(),
//                    WhAllotRcd.STATUS_FINISHED);
//        }
        //更新wms库存
        updateWmsStockWhenConnectAltFinished(connectId,operatorId);
    	return true;
    }
    
    /**
     * 波次-调拨完成更新库存
     * */
    private void updateWmsStockWhenConnectAltFinished(Long connectId,Long operatorId){
    	WhWmsConnectInfoVO connect = findById(connectId);
    	if(!WMSConstants.ConnectStatus.FINISHED.equals(connect.getConnectStatus())){
    		throw new WarehouseException("波次状态不是已完成");
    	}
    	List<WhWmsConnectAllotPackageDetailVO> packedDetailList = whWmsConnectAllotPackageService.findConnectAltPackageDetailsByConnectId(connectId);
    	if(EmptyUtil.isEmpty(packedDetailList)){
    		return;
    	}
    	Map<String,Integer> packedSkuQMap = new HashMap<>();
        for(WhWmsConnectAllotPackageDetailVO detail : packedDetailList){
        	String key = detail.getSkuCode()+":"+detail.getBarCode();
        	Integer quantity = packedSkuQMap.get(key);
        	if(NullUtil.isNull(quantity)){
        		packedSkuQMap.put(key, detail.getQuantity());
        	}else{
        		packedSkuQMap.put(key, detail.getQuantity()+quantity);
        	}
        }
        //检查有没有
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);
        List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hs) || hs.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,交接区");
        }
        WhWmsHouseShelvesVO updateShelvesVO = hs.get(0);
        for(String key : packedSkuQMap.keySet()){
        	String[] parts = key.split(":");
        	if(parts.length != 2){
        		throw new WarehouseException("打包数据异常");
        	}
        	String skuCode = parts[0],barCode = parts[1];
        	Integer quantity = packedSkuQMap.get(key);
        	if(NullUtil.isNull(quantity) || quantity <= 0){
        		continue;
        	}
        	whWmsSkuStockService.updateStockByCond(0-quantity
                    ,updateShelvesVO.getPhysicalWarehouseCode()             //物理仓编码
                    ,updateShelvesVO.getHouseType()                         //区域类型
                    ,barCode                           //barcode
                    ,updateShelvesVO.getCode()                            //库位号
                    ,skuCode                           //skucode
                    ,connect.getSkuStatus()                          //良品、残次、样品
                    ,WhCommand.TYPE_ALLOT_OUT                              //出入库类型
                    ,connectId.toString()                         //相关单据号
                    ,operatorId,null,1);                                //操作人
        }
        
        
    	
    }
    
    
    /**
     * 过滤出无货的指令
     * */
    List<WhCommand> filterShortageCommand(List<WhCommand> commandList){
    	List<WhCommand> shortageList = new ArrayList<>();
    	for(WhCommand command : commandList){
    		boolean shortage = true;
    		for(WhCommandSku commandSku : command.getWhCommandSkuList()){
    			if(commandSku.getQuantity()>0 || commandSku.getDamagedQuantity() > 0){
    				shortage = false;
    				break;
    			}
    		}
    		if(shortage){
    			shortageList.add(command);
    		}
    	}
    	return shortageList;
    }
    
    
    /**
     * 填充拣货数据
     * */
    private void fullAltCommand(WhWmsConnectInfoVO connect,
    		List<WhCommand> commandList,
    		List<WhWmsConnectAllotPackageDetailVO> packedDetailList){
    	
    	for(WhCommand command : commandList){
    		for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                commandSku.setQuantity(0);
                commandSku.setDamagedQuantity(0);
            }
    	}
    	//根据创建时间降序commandList
        Collections.sort(commandList, new Comparator<WhCommand>() {
            @Override
            public int compare(WhCommand o1, WhCommand o2) {
            	if(NullUtil.isNull(o1) || NullUtil.isNull(o2)){
            		return -1;
            	}
                return -(o1.getCreateTime().compareTo(o2.getCreateTime()));
            }
        });
        
        Map<String,Integer> packedSkuQMap = new HashMap<>();
        for(WhWmsConnectAllotPackageDetailVO detail : packedDetailList){
        	String key = detail.getSkuCode();
        	Integer quantity = packedSkuQMap.get(key);
        	if(NullUtil.isNull(quantity)){
        		packedSkuQMap.put(key, detail.getQuantity());
        	}else{
        		packedSkuQMap.put(key, detail.getQuantity()+quantity);
        	}
        }
        //分拣
        Integer skuStatus = connect.getSkuStatus();
        for(WhCommand command : commandList){
    		for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
    			String skuCode = commandSku.getSkuCode();
                Integer packedQuantity = packedSkuQMap.get(skuCode);
                if(NullUtil.isNull(packedQuantity)){
                	continue;
                }
                Integer usedQuantity = 0;
                if(packedQuantity>0 && packedQuantity > commandSku.getPlanedQuantity()){
                	usedQuantity = commandSku.getPlanedQuantity();
                	packedSkuQMap.put(skuCode, packedQuantity-usedQuantity);
                }else{
                	usedQuantity = packedQuantity;
                	packedSkuQMap.put(skuCode, 0);
                }
                commandSku.setQuantity(usedQuantity);
//                if(usedQuantity > 0 && !WMSConstants.WMS_SKU_STATUS_DEFECTIVE.equals(skuStatus)){
//                	commandSku.setQuantity(usedQuantity);
//                }else if(usedQuantity > 0 && WMSConstants.WMS_SKU_STATUS_DEFECTIVE.equals(skuStatus)){
//                	commandSku.setDamagedQuantity(usedQuantity);
//                }
            }
    	}
        
        
    }
    
    
    /**
     * 检查调拨波次是否已完成
     * */
    private boolean checkConnectAltFinished(final List<WhWmsConnectPickSkuVO> pickSkuList,
    		final List<WhWmsConnectAllotPackageDetailVO> detailList){
    	if(EmptyUtil.isEmpty(pickSkuList)){
    		throw new WarehouseException("拣货信息不存在");
    	}
    	if(EmptyUtil.isEmpty(detailList)){
    		return false;
    	}
    	Map<String,Integer> barCodeQMap = new HashMap<>();
    	for(WhWmsConnectPickSkuVO pickSku : pickSkuList){
    		String key = pickSku.getBarCode();
    		Integer pickQuantity = barCodeQMap.get(key);
    		if(NullUtil.isNull(pickQuantity)){
    			barCodeQMap.put(key, pickSku.getActualAmount());
    		}else{
    			barCodeQMap.put(key, pickQuantity+pickSku.getActualAmount());
    		}
    	}
    	for(WhWmsConnectAllotPackageDetailVO pDetail : detailList){
    		String key = pDetail.getBarCode();
    		Integer quantity = barCodeQMap.get(key);
    		if(NullUtil.isNull(quantity)){
    			throw new WarehouseException("批次不在拣货单中:"+key);
    		}else{
    			barCodeQMap.put(key, quantity-pDetail.getQuantity());
    		}
    	}
    	for(String barCode : barCodeQMap.keySet()){
    		Integer quantity = barCodeQMap.get(barCode);
    		if(quantity > 0){
    			return false;
    		}
            if(quantity < 0){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]数量超了[%d]",barCode,-quantity));
            }
    	}
    	return true;
    }
    
    /**
     *删除拣货周转箱-物理删除
     * */
    private Boolean delConnectBox(Long connectId){
        WhWmsConnectTurnoverBoxExample boxExample = new WhWmsConnectTurnoverBoxExample();
        boxExample.createCriteria()
                .andConnectIdEqualTo(connectId);
        //物理删除
        return boxMapper.deleteByExample(boxExample)!=0;
    }
    /**
     * 根据条件查找待出库的仓库指令
     * 单品单件 top5 sku
     * @param cond
     * @return
     */
    public List<WhSkuInfoVO> findWaitOutStockCommandSkuByCond(WhWmsWaitOutStockCond cond){
    	cond.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        if(NullUtil.isNull(cond.getPhysicalWarehouseCode())){
            return null;
        }
    	return whCommandService.findWaitOutStockCommandSkuByCond(cond);
    }

    /**
     * 创建或者更新前验证
     * @param vo
     */
    private void validateBeforeCreate(WhWmsConnectInfoVO vo){
        if(vo.getConnectUserId()==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"创建人为空");
        }
        if(StringUtils.isBlank(vo.getConnectType())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"波次类型为空");
        }
        if(!WMSConstants.ConnectType.ALL.contains(vo.getConnectType())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"波次类型不在可选范围内");
        }
    }

    /**
     * 批量创建前验证
     * @param vo
     */
    private void validateCommandConnect(WhWmsConnectInfoVO vo){
        if(CollectionUtils.isEmpty(vo.getWhCommandsCodes())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"whCommandCodes为空");
        }

        //第一遍简单过滤,会抛异常,不符合条件的从list中剔除
        for(int i = 0;i < vo.getWhCommandsCodes().size();i++){
            String cmdCode = vo.getWhCommandsCodes().get(i);
            if(cmdCode==null){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"commandCode为空");
                //vo.getWhCommandsCodes().remove(i);
                //i--;
                //break;
            }
            if(whWmsCommandConnectService.findNotCanceledByWhCommandCode(cmdCode)!=null){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"command["+cmdCode+"] 已经启动波次");
                //vo.getWhCommandsCodes().remove(i);
                //i--;
                //break;
            }
            WhCommand cmd = whCommandService.findCommandByCode(cmdCode, true);
            if(cmd==null){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"command["+cmdCode+"] 实体为空");
                //vo.getWhCommandsCodes().remove(i);
                //i--;
                //break;
            }
            if(!cmd.getCommandStatus().equals(WhCommand.STATUS_IN_PROCESSING)){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"command["+cmdCode+"] status 必须是执行中");
                //vo.getWhCommandsCodes().remove(i);
                //i--;
                //break;
            }
            if(!WhCommand.getAllOutType().contains(cmd.getInOutType())){
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"command["+cmdCode+"] type 必须是出库类型");
                //vo.getWhCommandsCodes().remove(i);
                //i--;
                //break;
            }

            vo.getWhCommands().add(cmd);
        }

        //对commandList进行排序,按createTime升序
        Collections.sort(vo.getWhCommands(), new Comparator<WhCommand>() {
            @Override
            public int compare(WhCommand o1, WhCommand o2) {
                if(o1.getCreateTime()==null && o2.getCreateTime()==null){
                    return 0;
                }
                if(o1.getCreateTime()==null){
                    return 1;
                }
                if(o2.getCreateTime()==null){
                    return -1;
                }
                return o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        for(int i = 0;i < vo.getWhCommands().size();i++){
            vo.getWhCommandsCodes().set(i,vo.getWhCommands().get(i).getCode());
        }

        //第二遍过滤,会抛异常,检查仓库指令是否符合波次规则
        CommandConnectStrategyContext context = new CommandConnectStrategyContext(vo);
        context.validate();
    }

    /**
     * 策略持有类
     */
    private class CommandConnectStrategyContext{
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractCommandConnectStrategy strategy;

        public CommandConnectStrategyContext(WhWmsConnectInfoVO whWmsConnectInfoVO){
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE)){
                this.strategy = new SingleProductSinglePieceCommandConnectStrategy();
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE)){
                this.strategy = new MultiProductSinglePieceCommandConnectStrategy();
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)){
                this.strategy = new MultiProductMultiPieceCommandConnectStrategy();
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.RECEIVE_WASTE)){
                this.strategy = new MultiProductMultiPieceCommandConnectStrategy();
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"not found strategy");
            }
        }

        public void validate(){
            boolean result = this.strategy.validate(this);
        }

    }

    /**
     * 抽象策略,验证仓库指令是否符合波次规则
     */
    private abstract class AbstractCommandConnectStrategy{
        public abstract boolean validate(CommandConnectStrategyContext context);
    }

    /**
     * 实现策略 针对单品单件
     */
    private class SingleProductSinglePieceCommandConnectStrategy extends  AbstractCommandConnectStrategy{
        @Override
        public boolean validate(CommandConnectStrategyContext context) {
            if(org.springframework.util.StringUtils.isEmpty(context.whWmsConnectInfoVO.getSkuCode())){
                throw new WarehouseException(WarehouseExceptionErrorCode.INVALID_CONNECT_START,"单品单件验证不通过,skuCode 为空");
            }
            Map<String,Integer> skus = new HashMap<>();
            for (WhCommand whCommand : context.whWmsConnectInfoVO.getWhCommands()) {
                for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                    if(whCommandSku.getPlanedQuantity().intValue()>1){
                        throw new WarehouseException(WarehouseExceptionErrorCode.INVALID_CONNECT_START,"单品单件验证不通过,command["+whCommand.getCode()+"] sku 数量超过一个");
                    }
                    if(skus.containsKey(whCommandSku.getSkuCode())){
                        skus.put(whCommandSku.getSkuCode(),whCommandSku.getPlanedQuantity()+skus.get(whCommandSku.getSkuCode()));
                    }else{
                        skus.put(whCommandSku.getSkuCode(),whCommandSku.getPlanedQuantity());
                    }
                }
            }
            if(skus.values().size()!=1){
                throw new WarehouseException(WarehouseExceptionErrorCode.INVALID_CONNECT_START,"单品单件验证不通过,commandSku 不是单品");
            }
            Set<String> skuCodes = skus.keySet();
            for (String skuCode : skuCodes) {
                if(!skuCode.equals(context.whWmsConnectInfoVO.getSkuCode())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.INVALID_CONNECT_START,"单品单件验证不通过,commandSku["+skuCode+"] 不匹配");
                }
            }
            return true;
        }
    }

    /**
     * 实现策略 针对多品单件
     */
    private class MultiProductSinglePieceCommandConnectStrategy extends AbstractCommandConnectStrategy{
        @Override
        public boolean validate(CommandConnectStrategyContext context) {
            for (WhCommand whCommand : context.whWmsConnectInfoVO.getWhCommands()) {
                if(whCommand.getWhCommandSkuList().size()>1){
                    throw new WarehouseException(WarehouseExceptionErrorCode.INVALID_CONNECT_START,"多品单件验证不通过,command["+whCommand.getCode()+"] sku 种数超过一个");
                }
                for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                    if(whCommandSku.getPlanedQuantity().intValue()>1){
                        throw new WarehouseException(WarehouseExceptionErrorCode.INVALID_CONNECT_START,"多品单件验证不通过,command["+whCommand.getCode()+"] sku 数量超过一个");
                    }
                }
            }
            return true;
        }
    }

    /**
     * 实现策略 针对多品多件
     */
    private class MultiProductMultiPieceCommandConnectStrategy extends AbstractCommandConnectStrategy{
        @Override
        public boolean validate(CommandConnectStrategyContext context) {
            return true;
        }
    }

    /**
     * 波次启动后的处理逻辑
     * @throws Exception 
     */
    private void afterCreate(WhWmsConnectInfoVO vo) throws Exception{
        //根据波次占用生成拣货任务
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(vo.getId().toString());
        List<WhWmsOccupyVO> occupyVOList = whWmsOccupyService.getWmsOccupyByCond(cond);
        createConnectPickSkuByOccupy(vo,occupyVOList);
        //仅调拨出库不过滤cmd
        if(EmptyUtil.isNotEmpty(vo.getWhCommandsCodes())&&vo.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
        	if(EmptyUtil.isEmpty(occupyVOList)){
            	//wms无库存，调拨直接直接完成
                WhWmsConnectAllotPackageVO packageVO = new WhWmsConnectAllotPackageVO();
                packageVO.setConnectId(vo.getId());
                packageVO.setOperatorId(vo.getConnectUserId());
                packageVO.setFocusFinish(true);
                submitConnectAltCheck(packageVO);
            }
        }
    }

    private void createConnectPickSkuByOccupy(final WhWmsConnectInfoVO vo,final List<WhWmsOccupyVO> occupyVOList){
        List<WhWmsConnectPickSkuVO> pickSkuVOList = new ArrayList<>();
        for (WhWmsOccupyVO occupyVO : occupyVOList) {
            WhWmsConnectPickSkuVO connectPickSkuVO = new WhWmsConnectPickSkuVO();
            connectPickSkuVO.setConnectId(vo.getId());
            connectPickSkuVO.setSkuStatus(occupyVO.getSkuStatus());
            connectPickSkuVO.setSkuCode(occupyVO.getSkuCode());
            connectPickSkuVO.setBarCode(occupyVO.getBarCode());
            connectPickSkuVO.setShelvesCode(occupyVO.getOriShelvesCode());
            connectPickSkuVO.setNeedAmount(Math.abs(occupyVO.getAmount()));
            connectPickSkuVO.setActualAmount(0);
            //whWmsConnectPickSkuService.create(connectPickSkuVO);
            pickSkuVOList.add(connectPickSkuVO);
        }
        whWmsConnectPickSkuService.batchCreate(pickSkuVOList);
    }
    
    
    /**
     * 波次启动后的处理逻辑-采退
     * @throws Exception 
     */
    private void afterCreatePcsRtnConnectInfo(WhWmsConnectInfoVO vo) throws Exception{
        //根据波次占用生成拣货任务
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(vo.getId().toString());
        List<WhWmsOccupyVO> occupyVOList = whWmsOccupyService.getWmsOccupyByCond(cond);
        createConnectPickSkuByOccupy(vo,occupyVOList);
        List<WhWmsConnectPickSkuVO> whWmsConnectPickSkuVOs = whWmsConnectPickSkuService.findByConnectId(vo.getId());
        //暂存拣货数据，后期校验库存使用
        vo.setWhWmsConnectPickSkuVOs(whWmsConnectPickSkuVOs);
        //采退出库不过滤cmd
        if(EmptyUtil.isNotEmpty(vo.getWhCommandsCodes())){
        	if(EmptyUtil.isEmpty(occupyVOList)){
                if(NullUtil.isNotNull(vo.getId())){
                    connectStatusTransform(vo.getId(),WMSConstants.ConnectStatus.WAITING_PROCESS,WMSConstants.ConnectStatus.FINISHED);
                }
        	    //wms无库存，采退直接直接完成
                List<WhWmsCommandConnectVO> whWmsCommandConnectVOList = whWmsCommandConnectService.findNotCanceledByConnectId(vo.getId());
                List<String> commandCodes = new ArrayList<>();
                for(WhWmsCommandConnectVO cmdConn : whWmsCommandConnectVOList){
                    commandCodes.add(cmdConn.getCommandCode());
                }
                List<WhCommand> commandList = whCommandService.findCommandByCodes(commandCodes, true);
                for(WhCommand command : commandList){
                    for (WhCommandSku commandSku : command.getWhCommandSkuList()) {
                        commandSku.setQuantity(0);
                        commandSku.setDamagedQuantity(0);
                    }
                }
                for (WhCommand whCommand : commandList) {
                    //完成指令，同时更新采退单数据
                    whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
                    whCommandService.finishCommand(whCommand);
                    //状态修改为发货完成
                    whCommandService.updateCommandStatusById(whCommand.getId().intValue(),WhCommand.STATUS_DELIVERYCOMPLETION);
                    //采退单取消
                    whCommandService.cancelPurchaseRtnByWhCommand(whCommand);
                }
            }
        }
        

    }
    
    /**
     * 波次启动后的处理逻辑-调拨
     * @throws Exception 
     */
    private void afterCreateAltConnectInfo(WhWmsConnectInfoVO vo) throws Exception{
        //根据波次占用生成拣货任务
        WhWmsOccupyVO cond = new WhWmsOccupyVO();
        cond.setReceiptsNo(vo.getId().toString());
        List<WhWmsOccupyVO> occupyVOList = whWmsOccupyService.getWmsOccupyByCond(cond);
        createConnectPickSkuByOccupy(vo,occupyVOList);
        List<WhWmsConnectPickSkuVO> whWmsConnectPickSkuVOs = whWmsConnectPickSkuService.findByConnectId(vo.getId());
        //暂存拣货数据，后期校验库存使用
        vo.setWhWmsConnectPickSkuVOs(whWmsConnectPickSkuVOs);
    }

    /**
     * 箱号查询
     * @param cond
     * @return
     */
    @Override
    public List<WhWmsBoxNumber> findWmsBoxNumberByCond(WhWmsBoxNumberCond cond) {
        /*WhWmsBoxNumberExample example = new WhWmsBoxNumberExample();
        WhWmsBoxNumberExample.Criteria criteria = example.createCriteria();
        if(cond.getPhysicalWarehouseCode()!=null){
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getBoxNumber())){
            criteria.andBoxNumberLike(cond.getBoxNumber());
        }
        example.setOrderByClause(" ID DESC " + cond.getCriteriaStr());

        List<WhWmsBoxNumber> whWmsBoxNumbers = whWmsBoxNumberMapper.selectByExample(example);*/
        List<WhWmsBoxNumber> whWmsBoxNumbers = whWmsBoxNumberMapper.listBoxNumber(cond);
        if (CollectionUtils.isEmpty(whWmsBoxNumbers)) {
            return Collections.emptyList();
        }
        return whWmsBoxNumbers;
    }

    /**
     * 箱号查询
     * @param cond
     * @return
     */
    @Override
    public List<WhWmsBoxNumberVO> findSingleBoxNumberByCond(WhWmsBoxNumberCond cond) {
        WhWmsBoxNumberExample example = new WhWmsBoxNumberExample();
        WhWmsBoxNumberExample.Criteria criteria = example.createCriteria();
        if(cond.getPhysicalWarehouseCode()!=null){
            criteria.andPhysicalWarehouseCodeEqualTo(cond.getPhysicalWarehouseCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getBoxNumber())){
            criteria.andBoxNumberLike(cond.getBoxNumber());
        }
        if (EmptyUtil.isNotEmpty(cond.getBoxType()) && cond.getBoxType() != 0){
            criteria.andBoxTypeEqualTo(cond.getBoxType());
        }
        example.setOrderByClause(" ID DESC " + cond.getCriteriaStr());

        List<WhWmsBoxNumber> whWmsBoxNumbers = whWmsBoxNumberMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsBoxNumbers)) {
            return Collections.emptyList();
        }
        List<WhWmsBoxNumberVO> vos = new ArrayList<WhWmsBoxNumberVO>(whWmsBoxNumbers.size());
        for (WhWmsBoxNumber whWmsBoxNumber : whWmsBoxNumbers) {
            WhWmsBoxNumberVO whWmsConnectInfoVO = BeanUtil.buildFrom(whWmsBoxNumber, WhWmsBoxNumberVO.class);
            vos.add(whWmsConnectInfoVO);
        }
        return vos;
    }

    @Override
    public Map<Integer, WhWmsConnectCountInfoVO> countUnfinishedConnect(String physicalWarehouseCode) {
        Map<Integer, WhWmsConnectCountInfoVO> map = new HashMap<>();
        List<WhWmsConnectCountInfoVO> countInfoList = mapper.countUnfinishedConnect(physicalWarehouseCode);
        if(EmptyUtil.isNotEmpty(countInfoList)){
            for(WhWmsConnectCountInfoVO countInfo : countInfoList){
                map.put(countInfo.getType(),countInfo);
            }
        }
        return map;
    }

    @Override
    public boolean updateBoxNumber(WhWmsBoxNumberVO vo) {
        WhWmsBoxNumber whWmsBoxNumber = BeanUtil.buildFrom(vo,WhWmsBoxNumber.class);
        if (whWmsBoxNumberMapper.updateByPrimaryKeySelective(whWmsBoxNumber) > 0){
            return true;
        }
        return false;
    }

    @Override
    public WhWmsBoxNumberVO createBoxNumber(WhWmsBoxNumberVO vo) {
        WhWmsBoxNumber whWmsBoxNumber = BeanUtil.buildFrom(vo,WhWmsBoxNumber.class);
        whWmsBoxNumber.setCreateTime(DateUtil.getNow());
        // 箱号每次需要重新生成
        if (EmptyUtil.isNotEmpty(whWmsBoxNumber.getBoxNumber())){
            whWmsBoxNumber.setBoxNumber(null);
        }
        if (whWmsBoxNumberMapper.insert(whWmsBoxNumber) > 0){
            // 箱号=物理仓+箱号类型+ID(序列号)
            WhPhysicalWarehouse whPhysicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whWmsBoxNumber.getPhysicalWarehouseCode());
            if(NullUtil.isNull(whPhysicalWarehouse) || EmptyUtil.isEmpty(whPhysicalWarehouse.getHouseNo())){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]仓库编号为空",whWmsBoxNumber.getPhysicalWarehouseCode()));
            }
            WhWmsBoxNumber newBoxNumber = new WhWmsBoxNumber(whWmsBoxNumber.getId(),whPhysicalWarehouse.getHouseNo()+whWmsBoxNumber.getBoxType()+whWmsBoxNumber.getId());
            if (whWmsBoxNumberMapper.updateByPrimaryKeySelective(newBoxNumber) > 0){
                whWmsBoxNumber.setBoxNumber(newBoxNumber.getBoxNumber());
                return BeanUtil.buildFrom(whWmsBoxNumber,WhWmsBoxNumberVO.class);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean createBoxNumber(WhWmsBoxNumber boxNumber) {
        if (whWmsBoxNumberMapper.insert(boxNumber) > 0){
            return true;
        }
        return false;
    }
}
