package com.thebeastshop.pegasus.service.warehouse.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.warehouse.cond.WhAllotCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandConnectVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectInfoVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.*;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.service.warehouse.cond.WhConnectAltPackageCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectAllotPackageDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectAllotPackageMapper;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectAllotPackageVO;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

@Service("whWmsConnectAllotPackageService")
public class WhWmsConnectAllotPackageServiceImpl implements WhWmsConnectAllotPackageService{

	@Autowired
	private WhWmsConnectAllotPackageMapper whWmsConnectAllotPackageMapper;
	
	@Autowired
	private WhWmsConnectAllotPackageDetailMapper whWmsConnectAllotPackageDetailMapper;

	@Autowired
	private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhAllotService whAllotService;
	
	@Override
	public void add(WhWmsConnectAllotPackageVO vo) {
		if(EmptyUtil.isEmpty(vo.getDetails())){
			return;
		}
		if(NullUtil.isNull(vo.getStatus())){
			vo.setStatus(WhWmsConnectAllotPackageVO.STATUS_WAITING_RECEIVE);
		}
		WhWmsConnectAllotPackageExample example = new WhWmsConnectAllotPackageExample();
		example.createCriteria().andConnectIdEqualTo(vo.getConnectId());
		List<WhWmsConnectAllotPackage> packageList = whWmsConnectAllotPackageMapper.selectByExample(example);
		String code = null;
		if(EmptyUtil.isEmpty(packageList)){
			code = getCode(vo.getConnectId(),1);
		}else{
			code = getCode(vo.getConnectId(),packageList.size()+1);
		}
		vo.setCode(code);
		whWmsConnectAllotPackageMapper.insert(vo);
		if(EmptyUtil.isNotEmpty(vo.getDetails())){
			for(WhWmsConnectAllotPackageDetailVO detailVO :vo.getDetails()){
				detailVO.setConnectAllotPackageId(vo.getId());
				detailVO.setConnectAllotPackageCode(vo.getCode());
				whWmsConnectAllotPackageDetailMapper.insert(detailVO);
			}
		}
		
	}

	@Override
	public WhWmsConnectAllotPackageVO findById(Long id) {
		WhWmsConnectAllotPackageExample example = new WhWmsConnectAllotPackageExample();
		example.createCriteria().andIdEqualTo(id);
		List<WhWmsConnectAllotPackage> packageList = whWmsConnectAllotPackageMapper.selectByExample(example);
		if(EmptyUtil.isEmpty(packageList)){
			return null;
		}
		WhWmsConnectAllotPackageVO vo = BeanUtil.buildFrom(packageList.get(0), WhWmsConnectAllotPackageVO.class);
		WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
		de.createCriteria().andConnectAllotPackageIdEqualTo(id);
		List<WhWmsConnectAllotPackageDetail> details = whWmsConnectAllotPackageDetailMapper.selectByExample(de);
		if(EmptyUtil.isNotEmpty(details)){
			List<WhWmsConnectAllotPackageDetailVO> detailVOs = BeanUtil.buildListFrom(details,WhWmsConnectAllotPackageDetailVO.class);
			vo.setDetails(detailVOs);
		}
		return vo;
	}

	@Override
	public List<WhWmsConnectAllotPackageVO> findByConnectId(Long connectId) {
		WhWmsConnectAllotPackageExample example = new WhWmsConnectAllotPackageExample();
		example.createCriteria().andConnectIdEqualTo(connectId);
		List<WhWmsConnectAllotPackage> packageList = whWmsConnectAllotPackageMapper.selectByExample(example);
		if(EmptyUtil.isEmpty(packageList)){
			return new ArrayList<>();
		}
		List<WhWmsConnectAllotPackageVO> packageVOs = BeanUtil.buildListFrom(packageList,WhWmsConnectAllotPackageVO.class);
		List<Long> packageIds = new ArrayList<>();
		for(WhWmsConnectAllotPackageVO vo : packageVOs){
			packageIds.add(vo.getId());
		}
		WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
		de.createCriteria().andConnectAllotPackageIdIn(packageIds);
		List<WhWmsConnectAllotPackageDetail> details = whWmsConnectAllotPackageDetailMapper.selectByExample(de);
		if(EmptyUtil.isNotEmpty(details)){
			List<WhWmsConnectAllotPackageDetailVO> detailVOs = BeanUtil.buildListFrom(details,WhWmsConnectAllotPackageDetailVO.class);
			Map<Long,List<WhWmsConnectAllotPackageDetailVO>> pakcageDetailMap = new HashMap<>();
			for(WhWmsConnectAllotPackageDetailVO detailVO : detailVOs){
				List<WhWmsConnectAllotPackageDetailVO> tmpList = pakcageDetailMap.get(detailVO.getConnectAllotPackageId());
				if(NullUtil.isNull(tmpList)){
					tmpList = new ArrayList<>();
					pakcageDetailMap.put(detailVO.getConnectAllotPackageId(), tmpList);
				}
				tmpList.add(detailVO);
			}
			for(WhWmsConnectAllotPackageVO vo : packageVOs){
				List<WhWmsConnectAllotPackageDetailVO> detailList = pakcageDetailMap.get(vo.getId());
				if(NullUtil.isNotNull(detailList)){
					vo.setDetails(detailList);
				}
			}
		}
		return packageVOs;
	}
	
	
	@Override
	public Pagination<WhWmsConnectAllotPackageVO> findByCond(
			WhConnectAltPackageCond cond) {
		Pagination<WhWmsConnectAllotPackageVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
		Integer counts = whWmsConnectAllotPackageMapper.CountByCond(cond);
		page.setRecord(counts);
		if(NumberUtil.isNullOrZero(counts)){
			return page;
		}
		List<WhWmsConnectAllotPackageVO> packageVOs = findConnectAltPackageList(cond);
		page.setResultList(packageVOs);
		return page;
	}

	@Override
	public List<WhWmsConnectAllotPackageVO> findConnectAltPackageList(WhConnectAltPackageCond cond) {
		List<WhWmsConnectAllotPackageVO> packageVOs = whWmsConnectAllotPackageMapper.findByCond(cond);
		if(EmptyUtil.isEmpty(packageVOs)){
			return packageVOs;
		}

        if (cond.isFetch() || cond.isFetchAllot()){
            List<Long> packageIds = new ArrayList<>();
            List<Long> connectIds = new ArrayList<>();
            for(WhWmsConnectAllotPackageVO vo : packageVOs){
                packageIds.add(vo.getId());
                connectIds.add(vo.getConnectId());
            }

            Map<Long,List<WhWmsConnectAllotPackageDetailVO>> pakcageDetailMap = mapConnectAllotPackageDetailByIds(packageIds, cond.isFetch());

            Map<Long, WhAllotRcd> connectAllotMap = mapConnectAllotByConnectIds(connectIds, cond.isFetchAllot());

            for(WhWmsConnectAllotPackageVO vo : packageVOs){
                if (cond.isFetch() && pakcageDetailMap.size() > 0){
                    List<WhWmsConnectAllotPackageDetailVO> detailList = pakcageDetailMap.get(vo.getId());
                    if(NullUtil.isNotNull(detailList)){
                        vo.setDetails(detailList);
                    }
                }

                // 设置 allotCode, allotRemark
                if (cond.isFetchAllot() && connectAllotMap.size() > 0){
                    WhAllotRcd whAllotRcdTmp = connectAllotMap.get(vo.getConnectId());
                    if (EmptyUtil.isNotEmpty(whAllotRcdTmp)){
                        vo.setAllotCode(whAllotRcdTmp.getCode());
                        vo.setAllotRemark(whAllotRcdTmp.getRemark());
                    }
                }
            }
        }
		return packageVOs;
	}

    private Map<Long, WhAllotRcd> mapConnectAllotByConnectIds(List<Long> connectIds, boolean fetchAllot){
        Map<Long, WhAllotRcd> connectAllotMap = new HashMap<>();
        if (fetchAllot){
            WhWmsCommandConnectCond commandConnectCond = new WhWmsCommandConnectCond();
            commandConnectCond.setConnectIds(connectIds);
            commandConnectCond.setCancelFlag(PegasusConstants.NO);
            List<WhWmsCommandConnectVO> commandConnectVOs = whWmsCommandConnectService.findByCond(commandConnectCond);
            if (CollectionUtils.isNotEmpty(commandConnectVOs)){
                List<String> commandCodes = new ArrayList<>();
                for (WhWmsCommandConnectVO commandConnectVO : commandConnectVOs){
                    commandCodes.add(commandConnectVO.getCommandCode());
                }
                Map<String, String> commandMap = whCommandService.findReferenceCodesByCommdCodes(commandCodes);

                WhAllotCond allotCond = new WhAllotCond();
                allotCond.setCodes(new ArrayList<String>(){{
                    addAll(commandMap.values());
                }});
                List<WhAllotRcd> whAllotRcds = whAllotService.selectAllotRcdByCond(allotCond);
                if (CollectionUtils.isNotEmpty(whAllotRcds)){
                    // 调拨Map
                    Map<String, WhAllotRcd> allotRcdMap = new HashMap<>();
                    for (WhAllotRcd allotRcd : whAllotRcds){
                        allotRcdMap.put(allotRcd.getCode(), allotRcd);
                    }

                    // 指令调拨Map
                    Map<String, WhAllotRcd> commandAllotMap = new HashMap<>();
                    for (Map.Entry<String, String> entry : commandMap.entrySet()){
                        commandAllotMap.put(entry.getKey(), allotRcdMap.get(entry.getValue()));
                    }

                    // 波次调拨Map
                    for (WhWmsCommandConnectVO commandConnectVO : commandConnectVOs){
                        connectAllotMap.put(commandConnectVO.getConnectId(), commandAllotMap.get(commandConnectVO.getCommandCode()));
                    }
                }
            }
        }
        return connectAllotMap;
    }

    private Map<Long,List<WhWmsConnectAllotPackageDetailVO>> mapConnectAllotPackageDetailByIds(List<Long> packageIds, boolean fetch){
        Map<Long,List<WhWmsConnectAllotPackageDetailVO>> pakcageDetailMap = new HashMap<>();
        if (fetch){
            WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
            de.createCriteria().andConnectAllotPackageIdIn(packageIds);
            List<WhWmsConnectAllotPackageDetail> details = whWmsConnectAllotPackageDetailMapper.selectByExample(de);
            if(EmptyUtil.isNotEmpty(details)){
                List<WhWmsConnectAllotPackageDetailVO> detailVOs = BeanUtil.buildListFrom(details,WhWmsConnectAllotPackageDetailVO.class);
                for(WhWmsConnectAllotPackageDetailVO detailVO : detailVOs){
                    List<WhWmsConnectAllotPackageDetailVO> tmpList = pakcageDetailMap.get(detailVO.getConnectAllotPackageId());
                    if(NullUtil.isNull(tmpList)){
                        tmpList = new ArrayList<>();
                        pakcageDetailMap.put(detailVO.getConnectAllotPackageId(), tmpList);
                    }
                    tmpList.add(detailVO);
                }
            }
        }
        return pakcageDetailMap;
    }

	@Override
	public WhWmsConnectAllotPackageVO findConnectAltPackage(String allotPackageCode) {
		WhConnectAltPackageCond cond = new WhConnectAltPackageCond();
		cond.setCode(allotPackageCode);
		cond.setFetch(true);
		List<WhWmsConnectAllotPackageVO> list = findConnectAltPackageList(cond);
		if(EmptyUtil.isEmpty(list)){
			return null;
		}
		return list.get(0);
	}

	@Override
	@Transactional
	public boolean splitAllotPackage(WhWmsConnectAllotPackageVO allotPackage) {
		if(NullUtil.isNull(allotPackage.getSourceAltPackageId())
				|| EmptyUtil.isEmpty(allotPackage.getDetails()) ){
			throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"参数异常");
		}
		WhWmsConnectAllotPackageVO sourcePackageInfo = findById(allotPackage.getSourceAltPackageId());
		if(NullUtil.isNull(sourcePackageInfo)){
			throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"源调拨箱不存在！");
		}

		WhWmsConnectInfoVO connectInfo = whWmsConnectInfoService.findById(sourcePackageInfo.getConnectId());

//		if(!WMSConstants.ConnectStatus.WAITING_PACK.equals(connectInfo.getConnectStatus())){
//			throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
//					,String.format("当前波次状态[%s]",connectInfo.getConnectStatusName()));
//		}

		Map<Long,WhWmsConnectAllotPackageDetailVO> sourcePackageDetailMap = new HashMap<>();
		for(WhWmsConnectAllotPackageDetailVO sourceDetail : sourcePackageInfo.getDetails()){
			sourcePackageDetailMap.put(sourceDetail.getId(),sourceDetail);
		}
		//数据复制
        allotPackage.setPackageTime(DateUtil.getNow());
        allotPackage.setConnectId(sourcePackageInfo.getConnectId());
		allotPackage.setOperatorId(allotPackage.getOperatorId());
		allotPackage.setSourcePhysicalWarehouseCode(sourcePackageInfo.getSourcePhysicalWarehouseCode());
		allotPackage.setSourceWarehouseCode(sourcePackageInfo.getSourceWarehouseCode());
        allotPackage.setTargetPhysicalWarehouseCode(sourcePackageInfo.getTargetPhysicalWarehouseCode());
        allotPackage.setTargetWarehouseCode(sourcePackageInfo.getTargetWarehouseCode());

		List<WhWmsConnectAllotPackageDetailVO> sourceSplitDetailList = new ArrayList<>();
		for(WhWmsConnectAllotPackageDetailVO detail : allotPackage.getDetails()){

			WhWmsConnectAllotPackageDetailVO sourceDetail = sourcePackageDetailMap.get(detail.getId());
			if(NullUtil.isNull(sourceDetail)){
				throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"拆分数据异常");
			}
            if(sourceDetail.getQuantity() < detail.getQuantity()){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s]拆分数量不能大于原装箱单数量",sourceDetail.getBarCode()));
            }
            sourceDetail.setQuantity(sourceDetail.getQuantity() - detail.getQuantity());
            sourceSplitDetailList.add(sourceDetail);
		}
		//更新源箱明细数据
        for(WhWmsConnectAllotPackageDetailVO sourceDetail : sourceSplitDetailList){
            whWmsConnectAllotPackageDetailMapper.updateByPrimaryKeySelective(sourceDetail);
        }
        //检查员箱是否已成空箱
		if(isEmptyAltPackage(sourcePackageInfo)){
			sourcePackageInfo.setStatus(WhWmsConnectAllotPackageVO.STATUS_RECEIVED);
			updateCnnectAltPackage(sourcePackageInfo);
		}
        //新增拆分箱
        add(allotPackage);
		return true;
	}

	private boolean isEmptyAltPackage(WhWmsConnectAllotPackageVO altPackage){
		if(EmptyUtil.isNotEmpty(altPackage.getDetails())){
			for(WhWmsConnectAllotPackageDetailVO detail : altPackage.getDetails()){
				if(detail.getQuantity() != 0){
					return false;
				}
			}
		}
		return true;
	}

	@Override
	@Transactional
	public boolean updateCnnectAltPackage(WhWmsConnectAllotPackageVO altPackage) {
		whWmsConnectAllotPackageMapper.updateByPrimaryKeySelective(altPackage);
		return true;
	}

	@Override
	public List<WhWmsConnectAllotPackageVO> findMinEstimatedAllocationDate(List<Long> packageIdList) {
		return whWmsConnectAllotPackageMapper.findMinEstimatedAllocationDate(packageIdList);
	}

	@Override
    public WhWmsConnectAllotPackageVO findConnectBoxsByCond(WhConnectAltPackageCond cond) {
        WhWmsConnectAllotPackageVO packageVOs = whWmsConnectAllotPackageMapper.findConnectBoxsByCond(cond);
        return packageVOs;
    }

    @Override
    public List<WhWmsConnectAllotPackageVO> findAllotTypeByByCond(WhConnectAltPackageCond cond) {
        List<WhWmsConnectAllotPackageVO> packageVOs = whWmsConnectAllotPackageMapper.findAllotTypeByByCond(cond);
        return packageVOs;
    }

	private String getCode(Long connectId,int num){
		StringBuilder buff= new StringBuilder(connectId.toString());
		int size = (num+"").length();
		for(int i=size;i<3;i++){
			buff.append(0);
		}
		buff.append(num);
		return buff.toString();
	}

	@Override
	public List<WhWmsConnectAllotPackageDetailVO> findConnectAltPackageDetailsByConnectId(
			Long connectId) {
		WhWmsConnectAllotPackageDetailExample de = new WhWmsConnectAllotPackageDetailExample();
		de.createCriteria().andConnectIdEqualTo(connectId);
		List<WhWmsConnectAllotPackageDetail> details = whWmsConnectAllotPackageDetailMapper.selectByExample(de);
		if(EmptyUtil.isNotEmpty(details)){
			return BeanUtil.buildListFrom(details,WhWmsConnectAllotPackageDetailVO.class);
		}
		return null;
	}

	@Override
	public boolean associateExpress(WhWmsConnectAllotPackageVO vo) {
		WhWmsConnectAllotPackageVO update = new WhWmsConnectAllotPackageVO();
		update.setId(vo.getId());
		update.setExpressNo(vo.getExpressNo());
		update.setExpressType(vo.getExpressType());
		whWmsConnectAllotPackageMapper.updateByPrimaryKeySelective(update);
		return true;
	}

}
