package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsConnectActiveRuleCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectActivityRuleDetailMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsConnectActivityRuleMapper;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsConnectActivityRuleDetailExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsConnectActivityRuleService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectActivityRuleDetailVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsConnectActivityRuleVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2017/10/10.
 */
@Service("whWmsConnectActivityRuleService")
public class WhWmsConnectActivityRuleServiceImpl implements WhWmsConnectActivityRuleService {

    @Autowired
    private WhWmsConnectActivityRuleMapper whWmsConnectActivityRuleMapper;

    @Autowired
    private WhWmsConnectActivityRuleDetailMapper whWmsConnectActivityRuleDetailMapper;

    @Override
    public List<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCond(WhWmsConnectActiveRuleCond cond, boolean cascade) {
        List<WhWmsConnectActivityRuleVO> ruleList = whWmsConnectActivityRuleMapper.findConnectActivityRuleByCond(cond);
        if(EmptyUtil.isEmpty(ruleList) || !cascade){
            return ruleList;
        }
        fullCascade(ruleList);
        return ruleList;
    }

    @Override
    public Pagination<WhWmsConnectActivityRuleVO> findConnectActivityRuleByCondPage(WhWmsConnectActiveRuleCond cond, boolean cascade) {
        Pagination<WhWmsConnectActivityRuleVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int total = whWmsConnectActivityRuleMapper.countConnectActivityRuleByCond(cond);
        page.setRecord(total);
        if(!NumberUtil.isNullOrZero(total)){
            page.setResultList(findConnectActivityRuleByCond(cond,cascade));
        }
        return page;
    }

    @Override
    public WhWmsConnectActivityRuleVO findConnectActivityRule(Long ruleId) {
        WhWmsConnectActiveRuleCond cond = new WhWmsConnectActiveRuleCond();
        cond.setId(ruleId);
        List<WhWmsConnectActivityRuleVO> list = findConnectActivityRuleByCond(cond,true);
        if(EmptyUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public boolean saveConnectActivityRule(WhWmsConnectActivityRuleVO ruleVO) {
        Date now = DateUtil.getNow();
        if(NullUtil.isNotNull(ruleVO.getBeginTime())
                && ruleVO.getBeginTime().compareTo(now) <= 0){
            ruleVO.setEnable(PegasusConstants.YES);
        }
        if(NullUtil.isNull(ruleVO.getId())){
            ruleVO.setCreateTime(now);
            return createConnectActiveRule(ruleVO);
        }
        return updateConnectActiveRule(ruleVO);
    }



    @Override
    @Transactional
    public boolean enableDisableConnectActivityRule(Long ruleId, Integer enableOrDisable) {
        WhWmsConnectActivityRuleVO ruleVO = new WhWmsConnectActivityRuleVO();
        ruleVO.setId(ruleId);
        ruleVO.setEnable(enableOrDisable);
        whWmsConnectActivityRuleMapper.updateByPrimaryKeySelective(ruleVO);
        return true;
    }

    private boolean createConnectActiveRule(WhWmsConnectActivityRuleVO ruleVO){
        whWmsConnectActivityRuleMapper.insert(ruleVO);
        createConnectActiveRuleDetail(ruleVO);
        return true;
    }

    private boolean updateConnectActiveRule(WhWmsConnectActivityRuleVO ruleVO){
        whWmsConnectActivityRuleMapper.updateByPrimaryKeySelective(ruleVO);
        deleteConnectActiveRuleDetail(ruleVO.getId());
        createConnectActiveRuleDetail(ruleVO);
        return true;
    }

    private void createConnectActiveRuleDetail(WhWmsConnectActivityRuleVO ruleVO){
        if(EmptyUtil.isNotEmpty(ruleVO.getDetails())){
            for(WhWmsConnectActivityRuleDetailVO detailVO : ruleVO.getDetails()){
                detailVO.setActivityRuleId(ruleVO.getId());
                whWmsConnectActivityRuleDetailMapper.insert(detailVO);
            }
        }
    }

    private void deleteConnectActiveRuleDetail(Long ruleId){
        WhWmsConnectActivityRuleDetailExample example = new WhWmsConnectActivityRuleDetailExample();
        example.createCriteria().andActivityRuleIdEqualTo(ruleId);
        whWmsConnectActivityRuleDetailMapper.deleteByExample(example);
    }

    private void fullCascade(List<WhWmsConnectActivityRuleVO> ruleList){
        List<Long> ruleIds = new ArrayList<>();
        for(WhWmsConnectActivityRuleVO ruleVO : ruleList){
            ruleIds.add(ruleVO.getId());
        }
        Map<Long,List<WhWmsConnectActivityRuleDetailVO>> detailMap = new HashMap<>();
        List<WhWmsConnectActivityRuleDetailVO> detailList = whWmsConnectActivityRuleDetailMapper.findByRuleId(ruleIds);
        if(EmptyUtil.isNotEmpty(detailList)){
            for(WhWmsConnectActivityRuleDetailVO detailVO : detailList){
                List<WhWmsConnectActivityRuleDetailVO> tmpList = detailMap.get(detailVO.getActivityRuleId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    detailMap.put(detailVO.getActivityRuleId(),tmpList);
                }
                tmpList.add(detailVO);
            }
            for(WhWmsConnectActivityRuleVO ruleVO : ruleList){
                ruleVO.setDetails(detailMap.get(ruleVO.getId()));
            }
        }
    }
}
