package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandPreOccupyCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandPreOccupy;
import com.thebeastshop.pegasus.service.warehouse.model.WhWmsCommandPreOccupyExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhWmsCommandPreOccupyService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandPreOccupyVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created by Administrator on 2017/9/6.
 */
@Service("whWmsCommandPreOccupyService")
public class WhWmsCommandPreOccupyServiceImpl implements WhWmsCommandPreOccupyService {

    @Autowired
    private WhWmsCommandPreOccupyMapper whWmsCommandPreOccupyMapper;

    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;

    @Override
    @Transactional
    public boolean createPreOccupy(WhWmsCommandPreOccupyVO vo) {
        return createPreOccupy(Collections.singletonList(vo));
    }

    @Override
    @Transactional
    public boolean createPreOccupy(List<WhWmsCommandPreOccupyVO> voList) {
        if(EmptyUtil.isEmpty(voList)){
            return false;
        }
        Set<String> commandCodes = new HashSet<>();
        for(WhWmsCommandPreOccupyVO preOccupyVO : voList){
            commandCodes.add(preOccupyVO.getCommandCode());
        }
        whWmsCommandPreOccupyMapper.batchCreate(voList);
        //调用层加锁
        try{
            //建立唯一索引防止并发多占
            whWmsCommandPreOccupyIdxMapper.batchCreate(Arrays.asList(commandCodes.toArray(new String[commandCodes.size()])));
        }catch (DuplicateKeyException e){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"指令已预占用,请稍后重试");
        }
        return true;
    }


    @Override
    public List<WhWmsCommandPreOccupyVO> findByCond(WhWmsCommandPreOccupyCond cond) {
        return whWmsCommandPreOccupyMapper.findByCond(cond);
    }

    @Override
    @Transactional
    public boolean releasePreOccupy(WhWmsCommandPreOccupyCond cond) {
        List<WhWmsCommandPreOccupyVO> list = findByCond(cond);
        if(EmptyUtil.isEmpty(list)){
            return true;
        }
        List<Long> idList = new ArrayList<>();
        List<String> commandCodes = new ArrayList<>();
        for(WhWmsCommandPreOccupyVO preOccupyVO : list){
            idList.add(preOccupyVO.getId());
        }
        whWmsCommandPreOccupyMapper.releasePreOccupy(idList);
        //物理删除索引
        whWmsCommandPreOccupyIdxMapper.batchDelete(commandCodes);
        return true;
    }

    @Override
    @Transactional
    public boolean releasePreOccupy(String physicalWarehouseCode){
        whWmsCommandPreOccupyIdxMapper.batchDeletePhyWhCode(physicalWarehouseCode);
        whWmsCommandPreOccupyMapper.releasePreOccupyByPhysicalWarehouseCode(physicalWarehouseCode);
        return true;
    }
    @Override
    @Transactional
    public boolean releasePreOccupy(List<String> commandCodes) {
        if(EmptyUtil.isEmpty(commandCodes)){
            return true;
        }
        WhWmsCommandPreOccupyExample example = new WhWmsCommandPreOccupyExample();
        example.createCriteria().andCommandCodeIn(commandCodes).andStatusEqualTo(PegasusConstants.YES);
        List<WhWmsCommandPreOccupy> list = whWmsCommandPreOccupyMapper.selectByExample(example);
        if(EmptyUtil.isEmpty(list)){
            return true;
        }
        List<Long> idList = new ArrayList<>();
        for(WhWmsCommandPreOccupy preOccupy : list){
            idList.add(preOccupy.getId());
        }
        whWmsCommandPreOccupyMapper.releasePreOccupy(idList);
        //物理删除索引
        whWmsCommandPreOccupyIdxMapper.batchDelete(commandCodes);
        return true;
    }


    @Override
    @Transactional
    public boolean releasePreOccupyForConnectStart(List<String> commandCodes) {
        //仅释放预占用不删除指令占用成功记录，防止重复预占用
        if(EmptyUtil.isEmpty(commandCodes)){
            return true;
        }
        WhWmsCommandPreOccupyExample example = new WhWmsCommandPreOccupyExample();
        example.createCriteria().andCommandCodeIn(commandCodes).andStatusEqualTo(PegasusConstants.YES);
        List<WhWmsCommandPreOccupy> list = whWmsCommandPreOccupyMapper.selectByExample(example);
        if(EmptyUtil.isEmpty(list)){
            return true;
        }
        List<Long> idList = new ArrayList<>();
        for(WhWmsCommandPreOccupy preOccupy : list){
            idList.add(preOccupy.getId());
        }
        whWmsCommandPreOccupyMapper.releasePreOccupy(idList);
        return true;
    }
}
