/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhCommandOutFinishMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsSubmitHandRecordMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.other.PackageDao;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.exception.WmsExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsCommandCheckVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsHouseShelvesVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWmsWarehouseAreaVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.DateUtil;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsCommandHandoverServiceImpl.java, v 0.1 2016-04-18 下午7:06
 */
@Service("whWmsCommandHandoverService")
public class WhWmsCommandHandoverServiceImpl implements WhWmsCommandHandoverService {

    private final Logger log = LoggerFactory.getLogger(WhWmsCommandHandoverServiceImpl.class);

    @Autowired
    private WhCommandMapper whCommandMapper;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhWmsCommandCheckService whWmsCommandCheckService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhCommandOutFinishMapper whCommandOutFinishMapper;

    @Autowired
    private WhWmsSubmitHandRecordMapper whWmsSubmitHandRecordMapper;

    @Override
    @Transactional
    public boolean commandHandover(WhCommand cmd) {
        //更改指令状态，称重时间
        boolean success = whCommandMapper.updateCommandForHandover(cmd) == 1;
        if(!success){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("包裹:[%s][%s]状态异常！",cmd.getReferenceCode(),cmd.getExpressNo()));
        }
        //记录交接记录，异步处理
        WhCommandOutFinish whCommandOutFinish = new WhCommandOutFinish();
        whCommandOutFinish.setCommandCode(cmd.getCode());
        whCommandOutFinish.setExpressNo(cmd.getExpressNo());
        whCommandOutFinish.setStatus(PegasusConstants.NO);
        whCommandOutFinish.setWhStatus(PegasusConstants.NO);
        whCommandOutFinish.setWeight(cmd.getWeight());
        whCommandOutFinish.setWeightDate(cmd.getWeightDate());
        whCommandOutFinish.setWeightUserId(cmd.getWeightUserId());
        whCommandService.insertWhCommandOutFinish(whCommandOutFinish);
        return true;
    }

    @Transactional
    public void processSubmitCommandHandover(WhCommand whCommand){
        if(NullUtil.isNull(whCommand.getExpressNo())){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        if(NullUtil.isNull(whCommand.getWeight())){
            whCommand.setWeight(0f);
        }
        if(NullUtil.isNull(whCommand.getWeightUserId())){
            whCommand.setWeightUserId(1L);
        }
        if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_HANDOVER) && !whCommand.getCommandStatus().equals(WhCommand.STATUS_DELIVERYCOMPLETION)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"仓库指令状态必须是待交接,"+whCommand.getCode());
        }
        //状态修改为发货完成
        whCommand.setCommandStatus(WhCommand.STATUS_DELIVERYCOMPLETION);
        whCommandMapper.updateByPrimaryKeySelective(whCommand);
        //检查物理仓
        WhPhysicalWarehouse physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
        if(physicalWarehouse==null){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的物理仓");
        }
        //检查有没有交接区
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(physicalWarehouse.getCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);//交接区
        List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hs) || hs.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,交接区");
        }
        WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);

        WhWmsCommandCheckVO cond = new WhWmsCommandCheckVO();
        cond.setCommandCode(whCommand.getCode());//指令编号
        cond.setCancelFlag(PegasusConstants.NO);//未取消
        //扣减wms库存
        cond.setIsMaterial(null);//去掉搜索条件,耗材和非耗材都需要
        List<WhWmsCommandCheckVO> commandCheckVOs = whWmsCommandCheckService.findByCond(cond);
        for (WhWmsCommandCheckVO commandCheckVO : commandCheckVOs) {
            WhWmsSubmitHandRecord record = new WhWmsSubmitHandRecord(0-commandCheckVO.getCheckAmount()
                    ,targetShelvesVO.getPhysicalWarehouseCode()             //物理仓编码
                    ,targetShelvesVO.getHouseType()                         //区域类型
                    ,commandCheckVO.getBarCode()                            //barcode
                    ,targetShelvesVO.getCode()                              //库位号
                    ,commandCheckVO.getSkuCode()                            //skucode
                    ,commandCheckVO.getSkuStatus()                          //良品、残次、样品
                    ,whCommand.getInOutType()                               //出入库类型
                    ,whCommand.getCode()                                    //相关单据号
                    ,whCommand.getWeightUserId()==null?1:whCommand.getWeightUserId().intValue()
                    ,null,1,0);
            whWmsSubmitHandRecordMapper.insertSelective(record);
        }
        //更改物理仓记录状态
        boolean success = updateCommandOutFinishDone(whCommand.getCode());
        if(!success){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"指令"+whCommand.getCode()+"已经处理");
        }
    }

    private boolean updateCommandOutFinishDone(String commandCode){
        WhCommandOutFinish updateInfo= new WhCommandOutFinish();
        updateInfo.setStatus(PegasusConstants.YES);
        updateInfo.setFinishDate(DateUtil.getNow());
        WhCommandOutFinishExample example = new WhCommandOutFinishExample();
        example.createCriteria().andCommandCodeEqualTo(commandCode).andStatusEqualTo(PegasusConstants.NO);
        return whCommandOutFinishMapper.updateByExampleSelective(updateInfo,example) == 1;
    }


}
