/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsCommandConnectCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandConnectMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.exception.WmsExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsCommandConnectServiceImpl.java, v 0.1 2016-03-16 下午4:53
 */
@Service("whWmsCommandConnectService")
public class WhWmsCommandConnectServiceImpl implements WhWmsCommandConnectService {

    private static Logger log = LoggerFactory.getLogger(WhWmsCommandConnectServiceImpl.class);

    @Autowired
    private WhWmsCommandConnectMapper mapper;

    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhWmsOccupyService whWmsOccupyService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhWmsSkuBarcodeService whWmsSkuBarcodeService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Autowired
    private WhWmsWarehouseAreaService whWmsWarehouseAreaService;

    @Autowired
    private RedisDistributLock redisDistributLock;

    @Transactional
    private WhWmsCommandConnectVO create(WhWmsCommandConnectVO vo){
        validateBeforeCreate(vo);
        //create WhWmsCommandConnect
        vo.setCancelFlag(PegasusConstants.NO);
        WhWmsCommandConnect whWmsCommandConnect = BeanUtil.buildFrom(vo, WhWmsCommandConnect.class);
        mapper.insert(whWmsCommandConnect);
        vo.setId(whWmsCommandConnect.getId());
        //update WhCommand
        //whCommandService.commandInProcessingToPicking(vo.getCommandCode());
        WhCommand cmd = whCommandService.findCommandByCode(vo.getCommandCode(),false);
        cmd.setCommandStatus(WhCommand.STATUS_PICKING);
        WhCommand oldCmd = whCommandService.updateCommandV2(cmd);
        if(!WhCommand.STATUS_IN_PROCESSING.equals(oldCmd.getCommandStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                    ,String.format("当前指令状态[%s]",oldCmd.getCommandStatusStr()));
        }
        return vo;

    }

    @Override
    public List<WhWmsCommandConnectVO> create(WhWmsConnectInfoVO connect) {
        List<WhWmsCommandConnectVO> vos = new ArrayList<>();
        FilterStragetyContext context = new FilterStragetyContext(connect);
        //过滤掉没库存的cmd
        context.filter();
        if(CollectionUtils.isEmpty(connect.getWhCommandsCodes())){
            //所有cmd都没wms库存 回滚connect
            whWmsConnectInfoService.deleteById(connect.getId());
            return Collections.emptyList();
        }
        //创建波次占用及移库单
        context.occupy();
        //创建commandConnect
        for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
            WhWmsCommandConnectVO whWmsCommandConnectVO = create(new WhWmsCommandConnectVO(connect.getWhCommandsCodes().get(i), connect.getId(), connect.getSkuCode()));
            if(whWmsCommandConnectVO!=null){
                vos.add(whWmsCommandConnectVO);
            }
        }
        if(CollectionUtils.isEmpty(vos)){
            return Collections.emptyList();
        }else{
            return vos;
        }
    }

    @Override
    public boolean create(List<WhWmsCommandConnectVO> voList) {
        if(EmptyUtil.isEmpty(voList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次指令创建失败");
        }
        mapper.batchCreate(voList);
        return true;
    }

    @Override
    @Transactional
    public List<WhWmsCommandConnectVO> createConnectInfoAlt(WhWmsConnectInfoVO connect) {
        List<WhWmsCommandConnectVO> vos = new ArrayList<>();
        FilterStragetyContextAlt context = new FilterStragetyContextAlt(connect);
        //过滤掉没库存的cmd
        context.filter();
        if(CollectionUtils.isEmpty(connect.getWhCommandsCodes())){
            //所有cmd都没wms库存 回滚connect
            whWmsConnectInfoService.deleteById(connect.getId());
            return Collections.emptyList();
        }

        //创建波次占用及移库单
        context.occupy();
        //创建commandConnect
        for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
            WhWmsCommandConnectVO whWmsCommandConnectVO = create(new WhWmsCommandConnectVO(connect.getWhCommandsCodes().get(i), connect.getId(), connect.getSkuCode()));
            if(whWmsCommandConnectVO!=null){
                vos.add(whWmsCommandConnectVO);
            }
        }

        if(CollectionUtils.isEmpty(vos)){
            return Collections.emptyList();
        }else{
            return vos;
        }

    }
    
    @Override
    public List<WhWmsCommandConnectVO> createConnectInfoPcsRtn(WhWmsConnectInfoVO connect) {
        //获取分布式锁
        List<WhWmsCommandConnectVO> vos = new ArrayList<>();
        FilterStragetyContextPcsRtn context = new FilterStragetyContextPcsRtn(connect);
        //过滤掉没库存的cmd
        context.filter();
        if(CollectionUtils.isEmpty(connect.getWhCommandsCodes())){
            //所有cmd都没wms库存 回滚connect
            whWmsConnectInfoService.deleteById(connect.getId());
            return Collections.emptyList();
        }
        //创建波次占用及移库单
        context.occupy();
        //创建commandConnect
        for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
            WhWmsCommandConnectVO whWmsCommandConnectVO = create(new WhWmsCommandConnectVO(connect.getWhCommandsCodes().get(i), connect.getId(), connect.getSkuCode()));
            if(whWmsCommandConnectVO!=null){
                vos.add(whWmsCommandConnectVO);
            }
        }

        if(CollectionUtils.isEmpty(vos)){
            return Collections.emptyList();
        }else{
            return vos;
        }
    }

    @Override
    public List<WhWmsCommandConnectVO> createConnectInfoRecWaste(WhWmsConnectInfoVO vo) {
        //获取分布式锁
        List<WhWmsCommandConnectVO> vos = new ArrayList<>();
        FilterStragetyContextRecWaste context = new FilterStragetyContextRecWaste(vo);
        //过滤掉没库存的cmd
        context.filter();
        if(CollectionUtils.isEmpty(vo.getWhCommandsCodes())){
            //所有cmd都没wms库存 回滚connect
            whWmsConnectInfoService.deleteById(vo.getId());
            return Collections.emptyList();
        }
        //创建波次占用及移库单
        context.occupy();
        //创建commandConnect
        for(int i = 0;i < vo.getWhCommandsCodes().size();i++){
            WhWmsCommandConnectVO whWmsCommandConnectVO = create(new WhWmsCommandConnectVO(vo.getWhCommandsCodes().get(i), vo.getId(), vo.getSkuCode()));
            if(whWmsCommandConnectVO!=null){
                vos.add(whWmsCommandConnectVO);
            }
        }
        return vos;
    }

    @Override
    public List<WhWmsSkuPickStockVO> generalPickSkuStockStragety(List<WhWmsSkuPickStockVO> pickStockList ,Integer skuStatus,String physicalWarehouseCode){
        Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku良品数
        //第一遍过滤,算出所有sku的计划出库数量
        for(WhWmsSkuPickStockVO pickStockVO : pickStockList){
            SkuQtt quanlity = skus.get(pickStockVO.getSkuCode());
            if(NullUtil.isNull(quanlity)){
                quanlity = new SkuQtt(pickStockVO.getSkuCode());
                skus.put(pickStockVO.getSkuCode(),quanlity);
            }
            quanlity.planedQuantity += pickStockVO.getNeedQuanlity();
        }
        //先进先出:优先出库最早过期的,其次生产日期最早的,再次入库时间最早的
        Map<String,List<String>> skuBarcodeMap = findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])),false);

        //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
        for (String skuCode : skus.keySet()) {
            //List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
            //List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
            //barCodesBySku.addAll(_barCodesBySku);
            List<String> barCodesBySku = skuBarcodeMap.get(skuCode);
            if(CollectionUtils.isEmpty(barCodesBySku)){
                continue;
            }
            SkuQtt skuQtt = skus.get(skuCode);
            for (String barCode : barCodesBySku) {
                BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                skuQtt.barcodes.add(barcodeQtt);

                WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                cond.setBarCode(barCode);
                cond.setSkuCode(skuCode);
                cond.setSkuStatus(skuStatus);//良品属性
                cond.setPhysicalWarehouseCode(physicalWarehouseCode);
                //从普通区获取
                cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                List<WhWmsSkuStockVO> wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                WarehouseArea area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                barcodeQtt.areas.add(area);
                area.stocks.addAll(wmsSkuAvailableAccount);
            }
        }

        //拣货
        for (String skuCode : skus.keySet()) {
            SkuQtt skuQtt = skus.get(skuCode);
            int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
            for (BarcodeQtt b : skuQtt.barcodes) {
                //B策略,普通区
                WarehouseArea areaNormal=null;
                for (WarehouseArea area : b.areas) {
                    if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                        areaNormal = area;
                        break;
                    }
                }
                List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据
                for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                    WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                    stock.setShelvesSortOrder(hs.getSortOrder());
                    if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                        pickingStocks.add(stock);
                    }else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                        holdingStocks.add(stock);
                    }
                }
                //按照数量及拣货顺序排序
                sortSkuStock(pickingStocks);
                //按照数量及拣货顺序排序
                sortSkuStock(holdingStocks);
                //库存合并
                List<WhWmsSkuStockVO> stockList = new ArrayList<>();
                stockList.addAll(pickingStocks);
                stockList.addAll(holdingStocks);
                for (WhWmsSkuStockVO stock : stockList) {
                    if(occupyQuantity>0){
                        int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                        if(availableOccupyQuantity<=0){
                            continue;
                        }
                        WhWmsSkuStockVO pickStock = BeanUtil.buildFrom(stock,WhWmsSkuStockVO.class);
                        pickStock.setAmount(availableOccupyQuantity);
                        skuQtt.addPickStock(pickStock);
                        //已填充的占用数量+有效占用数量
                        skuQtt.disposeQuantity+=availableOccupyQuantity;
                        occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    }
                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }
                }
                //sku需求数已全部占用,中断sku的barcode循环
                if(occupyQuantity==0){
                    break;
                }
            }
        }

        for(WhWmsSkuPickStockVO pickStockVO : pickStockList){
            SkuQtt quanlity = skus.get(pickStockVO.getSkuCode());
            if(NullUtil.isNotNull(quanlity)){
                pickStockVO.setPickedStock(quanlity.getPickedStock());
                pickStockVO.setDisposeQuantity(quanlity.disposeQuantity);
            }
        }

        return pickStockList;
    }


    private static class WarehouseArea{
        private String type;
        private List<WhWmsSkuStockVO> stocks=new ArrayList<>();
        public WarehouseArea(String type){
            this.type = type;
        }
        public int getAvailableQuantity(){
            int sum = 0;
            for (WhWmsSkuStockVO stock : stocks) {
                sum+= stock.getAvailableAccount();
            }
            return sum;
        }
    }

    private static class BarcodeQtt{
        private String barcode;
        private List<WarehouseArea> areas = new ArrayList<>();
        public BarcodeQtt(String barcode){
            this.barcode = barcode;
        }
        public int getAvailableQuantity(){
            int sum = 0;
            for (WarehouseArea area : areas) {
                sum+= area.getAvailableQuantity();
            }
            return sum;
        }
    }

    private static class SkuQtt{
        private String skuCode;
        private int planedQuantity=0;//计划出库数量
        private int disposeQuantity=0;//已填充占用的出库数量
        private List<WhWmsSkuStockVO> pickedStock = new ArrayList<>();
        private List<BarcodeQtt> barcodes = new ArrayList<>();
        public SkuQtt(String skuCode){
            this.skuCode = skuCode;
        }
        public int getAvailableQuantity(){
            int sum = 0;
            for (BarcodeQtt b : barcodes) {
                sum+= b.getAvailableQuantity();
            }
            return sum;
        }

        public List<WhWmsSkuStockVO> getPickedStock(){
            return pickedStock;
        }

        public void addPickStock(WhWmsSkuStockVO skuStockVO){
            pickedStock.add(skuStockVO);
        }


    }

    private class FilterStragetyContext{
        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragety strategy;
        private Map<String,SkuQtt> skus;

        public FilterStragetyContext(WhWmsConnectInfoVO whWmsConnectInfoVO){
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED)){
                //轻残品策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED)){
                //中残品策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED)){
                //重残品策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE)){
                //样品策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE)){
                //单品单件策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE)){
                //多品单件策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)){
                //多品多件策略
                this.strategy = new FilterStragetyB(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"not found strategy");
            }
        }

        public void filter(){
            this.strategy.filter(this);
        }

        public void occupy(){
            this.strategy.occupy(this);
        }
    }
    /**
     * 采退过滤策略
     * */
    private class FilterStragetyContextPcsRtn{
    	
    	private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragetyPcsRtn strategy;
        private Map<String,SkuQtt> skus;
        
        public FilterStragetyContextPcsRtn(WhWmsConnectInfoVO whWmsConnectInfoVO){
        	this.whWmsConnectInfoVO = whWmsConnectInfoVO;
//        	if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED)){
//                //轻残策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
//            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED)){
//                //中残策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
//            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED)){
//                //重残策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
//            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE)){
//                //样品策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
//            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED)){
//                //样品策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
//            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING)){
//                //待定策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING);
//            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)){
//                //多品多件策略
//                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
//            }else{
//                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"采退波次启动出错");
//            }
            if (WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.keySet().contains(whWmsConnectInfoVO.getSkuStatus())){
                this.strategy = new FilterStragetyPcsRtn(whWmsConnectInfoVO.getSkuStatus());
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)){
                //多品多件策略
                this.strategy = new FilterStragetyPcsRtn(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"采退波次启动出错");
            }
        }
        
        public void filter(){
            this.strategy.filter(this);
        }

        public void occupy(){
            this.strategy.occupy(this);
        }
        
        
    }
    
    /**
     * 调拨过滤策略
     * */
    private class FilterStragetyContextAlt{
    	
    	private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragetyAlt strategy;
        private Map<String,SkuQtt> skus;
        
        public FilterStragetyContextAlt(WhWmsConnectInfoVO whWmsConnectInfoVO){
        	this.whWmsConnectInfoVO = whWmsConnectInfoVO;

        	/*if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED)){
                //轻残品策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED)){
                //中残品策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED)){
                //重残品策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE)){
                //样品策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);
            }else if(whWmsConnectInfoVO.getSkuStatus().equals(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED)){
                //废品策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED);
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)){
                //多品多件策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"调拨波次启动出错");
            }*/

            if (WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.keySet().contains(whWmsConnectInfoVO.getSkuStatus())){
                this.strategy = new FilterStragetyAlt(whWmsConnectInfoVO.getSkuStatus());
            }else if(whWmsConnectInfoVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_MULTI_PIECE)){
                //多品多件策略
                this.strategy = new FilterStragetyAlt(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            }else{
                throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"调拨波次启动出错");
            }
        }
        
        public void filter(){
            this.strategy.filter(this);
        }

        public void occupy(){
            this.strategy.occupy(this);
        }
        
        
    }

    /**
     * 调拨过滤策略
     * */
    private class FilterStragetyContextRecWaste{

        private WhWmsConnectInfoVO whWmsConnectInfoVO;
        private AbstractFilterStragetyRecWaste strategy;
        private Map<String,SkuQtt> skus;

        public FilterStragetyContextRecWaste(WhWmsConnectInfoVO whWmsConnectInfoVO){
            this.whWmsConnectInfoVO = whWmsConnectInfoVO;
            //残次策略
            this.strategy = new FilterStragetyRecWaste(whWmsConnectInfoVO.getSkuStatus());
        }

        public void filter(){
            this.strategy.filter(this);
        }

        public void occupy(){
            this.strategy.occupy(this);
        }


    }
    
    private abstract class AbstractFilterStragetyPcsRtn{
        public abstract void filter(FilterStragetyContextPcsRtn context);
        public abstract void occupy(FilterStragetyContextPcsRtn context);
    }

    private abstract class AbstractFilterStragety{
        public abstract void filter(FilterStragetyContext context);
        public abstract void occupy(FilterStragetyContext context);
    }
    
    private abstract class AbstractFilterStragetyAlt{
        public abstract void filter(FilterStragetyContextAlt context);
        public abstract void occupy(FilterStragetyContextAlt context);
    }

    private abstract class AbstractFilterStragetyRecWaste{
        public abstract void filter(FilterStragetyContextRecWaste context);
        public abstract void occupy(FilterStragetyContextRecWaste context);
    }

    private void _setSkuQttMap(Map<String,SkuQtt> skus,WhCommand whCommand){
        for (WhCommandSku cmdSku : whCommand.getWhCommandSkuList()) {
            if(!skus.containsKey(cmdSku.getSkuCode())){
                skus.put(cmdSku.getSkuCode(),new SkuQtt(cmdSku.getSkuCode()));
            }
            skus.get(cmdSku.getSkuCode()).planedQuantity+=cmdSku.getPlanedQuantity();
        }
    }

    private void _filterConnectCommand(Map<String,SkuQtt> skus,WhWmsConnectInfoVO connect){
        if(connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
            //调拨出库
            //不过滤库存

        }else{
            //非调拨出库
        	for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = skus.get(skuCode);
                while(skuQtt.planedQuantity>skuQtt.getAvailableQuantity() && skuQtt.planedQuantity > 0){
                    //反向遍历
                    for(int i = connect.getWhCommands().size() - 1;i >= 0;i--){
                        WhCommand whCommand = connect.getWhCommands().get(i);
                        boolean isEquals = false;
                        for (WhCommandSku cmdSku : whCommand.getWhCommandSkuList()) {
                            if(cmdSku.getSkuCode().equals(skuQtt.skuCode)){
                                isEquals = true;
                                break;
                            }
                        }
                        if(isEquals){
                            //更新当前cmdSkuList所有的skuQtt
                            for (WhCommandSku cmdSku : whCommand.getWhCommandSkuList()) {
                                int diff = skus.get(cmdSku.getSkuCode()).planedQuantity - skus.get(cmdSku.getSkuCode()).getAvailableQuantity();
                                if(diff > 0){
                                    int shortAmount = 0;
                                    if(diff >= cmdSku.getPlanedQuantity()){
                                        shortAmount = cmdSku.getPlanedQuantity();
                                    }else{
                                        shortAmount = diff;
                                    }
                                    whCommandService.recordCommandShortSku(whCommand.getCode(),cmdSku.getSkuCode(),shortAmount);
                                    connect.getFailureShortageCommandCodes().add("出库指令："+whCommand.getCode()+" 缺货SKU:" + cmdSku.getSkuCode() + " 缺货数量：" + shortAmount);
                                }
                                skus.get(cmdSku.getSkuCode()).planedQuantity-= cmdSku.getPlanedQuantity();
                            }

                            //增加失败次数
                            whCommandService.failureStartConnect(whCommand.getCode());

                            //删除当前cmd
                            connect.getWhCommands().remove(i);
                            connect.getWhCommandsCodes().remove(i);
                            //添加到失败集合中
//                            connect.getFailureShortageCommandCodes().add(whCommand.getCode());
                        }
                    }
                }
            }
        }

    }

    /**
     * 单品单件策略
     */
    private class FilterStragetyA extends AbstractFilterStragety{
        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku良品数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }

            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);//良品属性
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从活动区获取
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_ACTIVE));//活动区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_ACTIVE);//活动区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);

                    //从普通区获取
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);

                }
            }

            //第三遍过滤,去除所有库存不够的command出库单
            _filterConnectCommand(skus,connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if(connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
                //调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //A策略,活动区->普通区
                        WarehouseArea areaActive=null;
                        WarehouseArea areaNormal=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_ACTIVE)){
                                areaActive = area;
                            }
                            if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                                areaNormal = area;
                            }
                        }
                        //优先占用活动区库存
                        for (WhWmsSkuStockVO stock : areaActive.stocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //调拨出库占库存
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch (Exception e){
                                    //ignore
                                }

                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                        List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                        List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据

                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                                pickingStocks.add(stock);
                            }
                            else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                                holdingStocks.add(stock);
                            }
                        }

                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //从普通区的保管库位直接占用拣货
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch(Exception e){
                                    //ignore
                                }
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                        for (WhWmsSkuStockVO stock : pickingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //从普通区的拣货库位直接占用拣货
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch(Exception e){
                                    //ignore
                                }
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                }
            }else{
                //非调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //A策略,活动区->普通区
                        WarehouseArea areaActive=null;
                        WarehouseArea areaNormal=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_ACTIVE)){
                                areaActive = area;
                            }
                            if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                                areaNormal = area;
                            }
                        }
                        //优先占用活动区库存
                        for (WhWmsSkuStockVO stock : areaActive.stocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                        List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                        List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据

                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                                pickingStocks.add(stock);
                            }
                            else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                                holdingStocks.add(stock);
                            }
                        }

                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //算出活动区,barcode的sku所在的拣货库位
                                WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
                                whWmsHouseShelvesCond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                whWmsHouseShelvesCond.setType(WhWmsWarehouseAreaVO.TYPE_ACTIVE);
                                whWmsHouseShelvesCond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
                                whWmsHouseShelvesCond.setSkuCode(stock.getSkuCode());
                                List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
                                if(CollectionUtils.isEmpty(hs)){
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);
                                }else{
                                    //从普通区的保管库位建移库任务到活动区的库位,占用活动区库存
                                    WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
                                    //调用移库接口
                                    WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                                    moveStockVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                    moveStockVO.setCreateUserId(connect.getConnectUserId());
                                    moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                                    List<WhWmsMoveSkuVO> moveStockList = new ArrayList<>();
                                    WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                                    moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                    moveSkuVO.setSkuCode(stock.getSkuCode());
                                    moveSkuVO.setSkuStatus(stock.getSkuStatus());
                                    moveSkuVO.setBarCode(stock.getBarCode());
                                    moveSkuVO.setOriginalHouseType(stock.getHouseType());
                                    moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
                                    moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                                    moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                                    moveSkuVO.setAmount(availableOccupyQuantity);
                                    moveStockList.add(moveSkuVO);
                                    moveStockVO.setMoveSkuList(moveStockList);
                                    whWmsMoveStockService.newMoveStock(moveStockVO);

                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    //占用移库目标库位
                                    occupyVO.setHouseType(targetShelvesVO.getHouseType());
                                    occupyVO.setOriShelvesCode(targetShelvesVO.getCode());
                                    whWmsOccupyService.wmsOccupy(occupyVO);
                                }

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                        for (WhWmsSkuStockVO stock : pickingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //算出活动区,barcode的sku所在的拣货库位
                                WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
                                whWmsHouseShelvesCond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                whWmsHouseShelvesCond.setType(WhWmsWarehouseAreaVO.TYPE_ACTIVE);
                                whWmsHouseShelvesCond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
                                whWmsHouseShelvesCond.setSkuCode(stock.getSkuCode());
                                List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
                                if(CollectionUtils.isEmpty(hs)){
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);
                                }else{
                                    //从普通区的拣货库位建移库任务到活动区的库位,占用活动区库存
                                    WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
                                    //调用移库接口
                                    WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                                    moveStockVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                    moveStockVO.setCreateUserId(connect.getConnectUserId());
                                    moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                                    List<WhWmsMoveSkuVO> moveStockList = new ArrayList<>();
                                    WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                                    moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                    moveSkuVO.setSkuCode(stock.getSkuCode());
                                    moveSkuVO.setSkuStatus(stock.getSkuStatus());
                                    moveSkuVO.setBarCode(stock.getBarCode());
                                    moveSkuVO.setOriginalHouseType(stock.getHouseType());
                                    moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
                                    moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                                    moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                                    moveSkuVO.setAmount(availableOccupyQuantity);
                                    moveStockList.add(moveSkuVO);
                                    moveStockVO.setMoveSkuList(moveStockList);
                                    whWmsMoveStockService.newMoveStock(moveStockVO);

                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    //占用移库目标库位
                                    occupyVO.setHouseType(targetShelvesVO.getHouseType());
                                    occupyVO.setOriShelvesCode(targetShelvesVO.getCode());
                                    whWmsOccupyService.wmsOccupy(occupyVO);
                                }

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                    if(occupyQuantity>0){
                        throw new WarehouseException(WmsExceptionErrorCode.NOT_OCCUPY_FULL,"库存占用失败");
                    }
                }
            }
        }
    }

    /**
     * 多品多件 多品单件策略
     */
    private class FilterStragetyB extends AbstractFilterStragety{
        private Integer skuStatus;

        public FilterStragetyB(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku良品数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }
            Map<String,List<String>> houseTypeMap = new HashMap<>();
            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(skuStatus);//良品属性
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从普通区获取
                    List<String> houseTypes = houseTypeMap.get(WhWmsWarehouseAreaVO.TYPE_NORMAL);
                    if(NullUtil.isNull(houseTypes)){
                        houseTypes = whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
                        if(EmptyUtil.isNotEmpty(houseTypes)){
                            houseTypeMap.put(WhWmsWarehouseAreaVO.TYPE_NORMAL,houseTypes);
                        }
                    }
                    cond.setHouseTypes(houseTypes);//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);

                    //从活动区获取
                    houseTypes = houseTypeMap.get(WhWmsWarehouseAreaVO.TYPE_ACTIVE);
                    if(NullUtil.isNull(houseTypes)){
                        houseTypes = whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_ACTIVE);
                        if(EmptyUtil.isNotEmpty(houseTypes)){
                            houseTypeMap.put(WhWmsWarehouseAreaVO.TYPE_ACTIVE,houseTypes);
                        }
                    }
                    cond.setHouseTypes(houseTypes);//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_ACTIVE);//活动区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }

            //第三遍过滤,去除所有库存不够的command出库单
            _filterConnectCommand(skus,connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if(connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
                //调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //B策略,普通区 或 活动区
                        WarehouseArea areaNormal=null;
                        for (WarehouseArea area : b.areas) {
                            if(WhWmsWarehouseAreaVO.TYPE_NORMAL.equals(area.type)){
                                areaNormal = area;
                            }
                        }
                        List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                        List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据

                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            stock.setShelvesSortOrder(hs.getSortOrder());
                            if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                                pickingStocks.add(stock);
                            }
                            else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                                holdingStocks.add(stock);
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                        //库存排序
                        sortSkuStock(pickingStocks);
                        //优先占用普通区的拣货库位库存
                        for (WhWmsSkuStockVO stock : pickingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //调拨出库占库存
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch (Exception e){
                                    //ignore
                                }

                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }
                        //库存排序
                        sortSkuStock(holdingStocks);
                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //从普通区的保管库位直接占用拣货
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch(Exception e){
                                    //ignore
                                }

                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                }
            }else{
                //非调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //B策略,活动区
                        WarehouseArea areaActive = null;
                        for (WarehouseArea area : b.areas) {
                            if(WhWmsWarehouseAreaVO.TYPE_ACTIVE.equals(area.type)){
                                areaActive = area;
                            }
                        }
                        List<WhWmsSkuStockVO> activeStocks = new ArrayList<>();//活动区库存数据
                        for (WhWmsSkuStockVO stock : areaActive.stocks) {
                            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            stock.setShelvesSortOrder(hs.getSortOrder());
                            if(WhWmsWarehouseAreaVO.HOUSE_TYPE_ACTIVE.equals(hs.getHouseType())){//活动区优先
                                activeStocks.add(stock);
                            }
                        }

                        //库存排序
                        sortSkuStock(activeStocks);
                        //最优先活动区库存
                        for (WhWmsSkuStockVO stock : activeStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch (Exception e){
                                    //ignore
                                }
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                        //B策略,普通区
                        WarehouseArea areaNormal=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                                areaNormal = area;
                            }
                        }

                        List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                        List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据
                        for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                            WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                            stock.setShelvesSortOrder(hs.getSortOrder());
                            if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                                pickingStocks.add(stock);
                            }
                            else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                                holdingStocks.add(stock);
                            }
                        }

                        //拣货排序
                        sortSkuStock(pickingStocks);
                        //优先占用普通区的拣货库位库存
                        for (WhWmsSkuStockVO stock : pickingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }
                        //拣货排序
                        sortSkuStock(holdingStocks);
                        for (WhWmsSkuStockVO stock : holdingStocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //算出普通区,barcode的sku所在的拣货库位
                                WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
                                whWmsHouseShelvesCond.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                whWmsHouseShelvesCond.setType(WhWmsWarehouseAreaVO.TYPE_NORMAL);
                                whWmsHouseShelvesCond.setShelvesUsableStatus(WhWmsHouseShelvesVO.SHELVES_USABLE_SUATUS_AVAILABLE);
                                whWmsHouseShelvesCond.setSkuCode(stock.getSkuCode());
                                whWmsHouseShelvesCond.setShelvesType(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING);
                                List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
                                if(CollectionUtils.isEmpty(hs)){
                                    //没有拣货库位的情况下,直接从保管库位出,占用保管区库存
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);
                                }else{
                                    //从普通区的保管库位建移库任务到普通区的拣货库位,占用普通区的拣货库位库存
                                    WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
                                    //调用移库接口
                                    WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                                    moveStockVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                    moveStockVO.setCreateUserId(connect.getConnectUserId());
                                    moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_SUPPLEMENT);
                                    List<WhWmsMoveSkuVO> moveStockList = new ArrayList<>();
                                    WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                                    moveSkuVO.setPhysicalWarehouseCode(stock.getPhysicalWarehouseCode());
                                    moveSkuVO.setSkuCode(stock.getSkuCode());
                                    moveSkuVO.setSkuStatus(stock.getSkuStatus());
                                    moveSkuVO.setBarCode(stock.getBarCode());
                                    moveSkuVO.setOriginalHouseType(stock.getHouseType());
                                    moveSkuVO.setOriginalShelvesCode(stock.getShelvesCode());
                                    moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                                    moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                                    moveSkuVO.setAmount(availableOccupyQuantity);
                                    moveStockList.add(moveSkuVO);
                                    moveStockVO.setMoveSkuList(moveStockList);
                                    whWmsMoveStockService.newMoveStock(moveStockVO);

                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    //占用移库目标库位
                                    occupyVO.setHouseType(targetShelvesVO.getHouseType());
                                    occupyVO.setOriShelvesCode(targetShelvesVO.getCode());
                                    whWmsOccupyService.wmsOccupy(occupyVO);
                                }

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                    if(occupyQuantity>0){
                        throw new WarehouseException(WmsExceptionErrorCode.NOT_OCCUPY_FULL,"库存占用失败");
                    }
                }
            }
        }
    }

    /**
     * 残次策略
     */
    private class FilterStragetyC extends AbstractFilterStragety{

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku残次数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }

            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED);//轻残次属性
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从残次区获取
//                    cond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_DEFECTIVE);//残次区
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }

            //第三遍过滤,去除所有库存不够的command出库单
            _filterConnectCommand(skus,connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if(connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
                //调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //C策略,残次区
                        WarehouseArea areaDefective=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_DEFECTIVE)){
                                areaDefective = area;
                            }
                        }
                        //优先占用残次区库存
                        for (WhWmsSkuStockVO stock : areaDefective.stocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //调拨出库占库存
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch (Exception e){
                                    //ignore
                                }
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                }
            }else{
                //非调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //C策略,残次区
                        WarehouseArea areaDefective=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_DEFECTIVE)){
                                areaDefective = area;
                            }
                        }
                        //优先占用残次区库存
                        for (WhWmsSkuStockVO stock : areaDefective.stocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                    if(occupyQuantity>0){
                        throw new WarehouseException(WmsExceptionErrorCode.NOT_OCCUPY_FULL,"库存占用失败");
                    }
                }
            }
        }
    }

    /**
     * 样品策略
     */
    private class FilterStragetyD extends AbstractFilterStragety{

        @Override
        public void filter(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku样品数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }

            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                barCodesBySku.addAll(_barCodesBySku);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE);//样品属性
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从样品区获取
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//样品区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);
                }
            }

            //第三遍过滤,去除所有库存不够的command出库单
            _filterConnectCommand(skus,connect);
        }

        @Override
        public void occupy(FilterStragetyContext context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            if(connect.getWhCommands().get(0).getInOutType().equals(WhCommand.TYPE_ALLOT_OUT)){
                //调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //D策略,样品区
                        WarehouseArea areaSample=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_SAMPLE)){
                                areaSample = area;
                            }
                        }
                        //优先占用样品区库存
                        for (WhWmsSkuStockVO stock : areaSample.stocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }

                                //调拨出库占库存
                                try{
                                    //生成占用vo 调用占用service
                                    WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                    occupyVO.setAmount(0-availableOccupyQuantity);
                                    occupyVO.setReceiptsNo(connect.getId().toString());
                                    occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                    whWmsOccupyService.wmsOccupy(occupyVO);

                                    //已填充的占用数量+有效占用数量
                                    skuQtt.disposeQuantity+=availableOccupyQuantity;
                                    occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                                }catch (Exception e){
                                    //ignore
                                }

                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                }
            }else{
                //非调拨出库
                Map<String, SkuQtt> skus = context.skus;
                for (String skuCode : skus.keySet()) {
                    SkuQtt skuQtt = skus.get(skuCode);
                    int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                    for (BarcodeQtt b : skuQtt.barcodes) {
                        //D策略,样品区
                        WarehouseArea areaSample=null;
                        for (WarehouseArea area : b.areas) {
                            if(area.type.equals(WhWmsWarehouseAreaVO.HOUSE_TYPE_SAMPLE)){
                                areaSample = area;
                            }
                        }
                        //优先占用样品区库存
                        for (WhWmsSkuStockVO stock : areaSample.stocks) {
                            if(occupyQuantity>0){
                                int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                        ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                                if(availableOccupyQuantity<=0){
                                    continue;
                                }
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }
                        }

                        //sku需求数已全部占用,中断sku的barcode循环
                        if(occupyQuantity==0){
                            break;
                        }

                    }
                    if(occupyQuantity>0){
                        throw new WarehouseException(WmsExceptionErrorCode.NOT_OCCUPY_FULL,"库存占用失败");
                    }
                }
            }
        }
    }

    private Map<String,List<String>> findBarcodesForAltOrPcsRtnConnect(List<String> skuCodes,boolean allowExpire){
        Map<String,List<String>> map = new HashMap<>();
        List<WhWmsSkuBarcode> barcodeList = whWmsSkuBarcodeService.findBarcodesForAltOrPcsRtnConnect(skuCodes,allowExpire);
        if(EmptyUtil.isNotEmpty(barcodeList)){
            for(WhWmsSkuBarcode barcode : barcodeList){
                List<String> tmpList = map.get(barcode.getSkuCode());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(barcode.getSkuCode(),tmpList);
                }
                tmpList.add(barcode.getBarCode());
            }
        }
        return map;
    }
    
    /**
     * 调拨策略
     * */
    private class FilterStragetyAlt extends AbstractFilterStragetyAlt{
    	
    	private Integer skuStatus;

        public FilterStragetyAlt(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }
    	
		@Override
		public void filter(FilterStragetyContextAlt context) {
			WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku良品数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }

            // #7133 波次启动调拨 根据商品状态(不是良品) 则可以出过期商品
            boolean allowExpire = false;
            if (EmptyUtil.isNotEmpty(this.skuStatus)
                    && !WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE.equals(this.skuStatus)){
                allowExpire = true;
            }
            //先进先出:优先出库最早过期的,其次生产日期最早的,再次入库时间最早的
            Map<String,List<String>> skuBarcodeMap = findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])),allowExpire);
            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                //List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndUnexpiredSortByExpiredAsc(skuCode));
                //List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                //barCodesBySku.addAll(_barCodesBySku);
                List<String> barCodesBySku = skuBarcodeMap.get(skuCode);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(skuStatus);// 商品状态
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从普通区获取
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);

                }
            }

            //第三遍过滤,去除所有库存不够的command出库单,调拨无需过滤
            //_filterConnectCommand(skus,connect);
			
		}

		@Override
		public void occupy(FilterStragetyContextAlt context) {
			WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
			//调拨出库
            Map<String, SkuQtt> skus = context.skus;
            for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = skus.get(skuCode);
                int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                for (BarcodeQtt b : skuQtt.barcodes) {
                    //B策略,普通区
                    WarehouseArea areaNormal=null;
                    for (WarehouseArea area : b.areas) {
                        if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                            areaNormal = area;
                        }
                    }
                    List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                    List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据
                    for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                        WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        stock.setShelvesSortOrder(hs.getSortOrder());
                        if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                            pickingStocks.add(stock);
                        }
                        else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                            holdingStocks.add(stock);
                        }
                    }
                    //按照数量及拣货顺序排序
                    sortSkuStock(pickingStocks);
                    //优先占用普通区的拣货库位库存
                    for (WhWmsSkuStockVO stock : pickingStocks) {
                        if(occupyQuantity>0){
                            int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                    ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                            if(availableOccupyQuantity<=0){
                                continue;
                            }

                            //调拨出库占库存
                            try{
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }catch (Exception e){
                                //ignore
                            }

                        }
                    }

                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }
                    //按照数量及拣货顺序排序
                    sortSkuStock(holdingStocks);
                    for (WhWmsSkuStockVO stock : holdingStocks) {
                        if(occupyQuantity>0){
                            int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                    ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                            if(availableOccupyQuantity<=0){
                                continue;
                            }

                            //从普通区的保管库位直接占用拣货
                            try{
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }catch(Exception e){
                                //ignore
                            }

                        }
                    }

                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }

                }
            }
            
		}
    	
    }


    /**
     * 调拨策略
     * */
    private class FilterStragetyRecWaste extends AbstractFilterStragetyRecWaste{

        private Integer skuStatus;

        public FilterStragetyRecWaste(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }

        @Override
        public void filter(FilterStragetyContextRecWaste context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku良品数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }
            //先进先出:优先出库最早过期的,其次生产日期最早的,再次入库时间最早的
            Map<String,List<String>> skuBarcodeMap = findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])),true);
            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                List<String> barCodesBySku = skuBarcodeMap.get(skuCode);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(skuStatus);//良品属性
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从普通区获取
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);

                }
            }

            //第三遍过滤,去除所有库存不够的command出库单
            _filterConnectCommand(skus,connect);
        }

        @Override
        public void occupy(FilterStragetyContextRecWaste context) {
            WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String, SkuQtt> skus = context.skus;
            for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = skus.get(skuCode);
                int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                for (BarcodeQtt b : skuQtt.barcodes) {
                    //B策略,普通区
                    WarehouseArea areaNormal=null;
                    for (WarehouseArea area : b.areas) {
                        if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                            areaNormal = area;
                        }
                    }
                    List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                    List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据
                    for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                        WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        if(NullUtil.isNull(hs)){
                            continue;
                        }
                        stock.setShelvesSortOrder(hs.getSortOrder());
                        if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                            pickingStocks.add(stock);
                        }
                        else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                            holdingStocks.add(stock);
                        }
                    }
                    //按照数量及拣货顺序排序
                    sortSkuStock(pickingStocks);
                    //优先占用普通区的拣货库位库存
                    for (WhWmsSkuStockVO stock : pickingStocks) {
                        if(occupyQuantity>0){
                            int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                    ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                            if(availableOccupyQuantity<=0){
                                continue;
                            }

                            //调拨出库占库存
                            try{
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }catch (Exception e){
                                //ignore
                            }

                        }
                    }

                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }
                    //按照数量及拣货顺序排序
                    sortSkuStock(holdingStocks);
                    for (WhWmsSkuStockVO stock : holdingStocks) {
                        if(occupyQuantity>0){
                            int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                    ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                            if(availableOccupyQuantity<=0){
                                continue;
                            }

                            //从普通区的保管库位直接占用拣货
                            try{
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }catch(Exception e){
                                //ignore
                            }

                        }
                    }

                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }

                }
            }

        }

    }

    //数量及拣货顺序排序
    @Override
    public void sortSkuStock(List<WhWmsSkuStockVO> stocks){
        if(EmptyUtil.isEmpty(stocks)){
            return;
        }
        Collections.sort(stocks, new Comparator<WhWmsSkuStockVO>() {
            @Override
            public int compare(WhWmsSkuStockVO o1, WhWmsSkuStockVO o2) {
                return compareStock(o1,o2);
            }
        });
    }

    private int compareStock(WhWmsSkuStockVO o1, WhWmsSkuStockVO o2){
        Integer o1Account = o1.getAvailableAccount(),o2Account = o2.getAvailableAccount();
        if(NullUtil.isNull(o1Account)){
            o1Account = new Integer(0);
        }
        if(NullUtil.isNull(o2Account)){
            o2Account = new Integer(0);
        }
        int result = o1Account.compareTo(o2Account);
        if(result == 0){
            result = compareShelveSortOrder(o1.getShelvesSortOrder(),o2.getShelvesSortOrder());
            if(result == 0){
                result = o1.getShelvesCode().compareTo(o2.getShelvesCode());
            }
        }
        return result;
    }

    //按照拣货顺序比较,null排最后
    private int compareShelveSortOrder(Integer so1,Integer so2){
        if(NullUtil.isNull(so1)){
            so1 = 9999999;
        }
        if(NullUtil.isNull(so2)){
            so2 = 9999999;
        }
        return so1.compareTo(so2);
    }
    
    /**
     * 调拨策略
     * */
    private class FilterStragetyPcsRtn extends AbstractFilterStragetyPcsRtn{
    	
    	private Integer skuStatus;

        public FilterStragetyPcsRtn(Integer skuStatus) {
            this.skuStatus = skuStatus;
        }
    	
		@Override
		public void filter(FilterStragetyContextPcsRtn context) {
			WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
            Map<String,SkuQtt> skus = new HashMap<>();//k skuCode,v sku良品数
            context.skus = skus;
            //第一遍过滤,算出所有sku的计划出库数量
            for(int i = 0;i < connect.getWhCommandsCodes().size();i++){
                WhCommand whCommand = connect.getWhCommands().get(i);
                _setSkuQttMap(skus,whCommand);
            }
            //先进先出:优先出库最早过期的,其次生产日期最早的,再次入库时间最早的
            Map<String,List<String>> skuBarcodeMap = findBarcodesForAltOrPcsRtnConnect(Arrays.asList(skus.keySet().toArray(new String[skus.size()])),true);
            //第二遍过滤,组装SkuQtt,获取->BarcodeQtt->WarehouseArea->stock
            for (String skuCode : skus.keySet()) {
                //List<String> barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndSortByExpiredAsc(skuCode));
                //List<String> _barCodesBySku = new ArrayList<>(whWmsSkuBarcodeService.findBarCodesConditionBySkuCodeAndNullExpired(skuCode));
                //barCodesBySku.addAll(_barCodesBySku);
                List<String> barCodesBySku = skuBarcodeMap.get(skuCode);
                if(CollectionUtils.isEmpty(barCodesBySku)){
                    continue;
                }
                SkuQtt skuQtt = skus.get(skuCode);
                for (String barCode : barCodesBySku) {
                    BarcodeQtt barcodeQtt = new BarcodeQtt(barCode);
                    skuQtt.barcodes.add(barcodeQtt);

                    WhWmsSkuStockVO cond = new WhWmsSkuStockVO();
                    cond.setBarCode(barCode);
                    cond.setSkuCode(skuCode);
                    cond.setSkuStatus(skuStatus);//良品属性
                    cond.setPhysicalWarehouseCode(connect.getPhysicalWarehouseCode());

                    List<WhWmsSkuStockVO> wmsSkuAvailableAccount=null;
                    WarehouseArea area = null;

                    //从普通区获取
                    cond.setHouseTypes(whWmsWarehouseAreaService.getHouseTypesByType(WhWmsWarehouseAreaVO.TYPE_NORMAL));//普通区
                    wmsSkuAvailableAccount = whWmsSkuStockService.findWmsSkuAvailableAccount(cond);
                    area = new WarehouseArea(WhWmsWarehouseAreaVO.TYPE_NORMAL);//普通区
                    barcodeQtt.areas.add(area);
                    area.stocks.addAll(wmsSkuAvailableAccount);

                }
            }

            //第三遍过滤,去除所有库存不够的command出库单,调拨无需过滤
            //_filterConnectCommand(skus,connect);
			
		}

		@Override
		public void occupy(FilterStragetyContextPcsRtn context) {
			WhWmsConnectInfoVO connect = context.whWmsConnectInfoVO;
			//调拨出库
            Map<String, SkuQtt> skus = context.skus;
            for (String skuCode : skus.keySet()) {
                SkuQtt skuQtt = skus.get(skuCode);
                int occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                for (BarcodeQtt b : skuQtt.barcodes) {
                    //B策略,普通区
                    WarehouseArea areaNormal=null;
                    for (WarehouseArea area : b.areas) {
                        if(area.type.equals(WhWmsWarehouseAreaVO.TYPE_NORMAL)){
                            areaNormal = area;
                        }
                    }
                    List<WhWmsSkuStockVO> pickingStocks = new ArrayList<>();//拣货库位的库存数据
                    List<WhWmsSkuStockVO> holdingStocks = new ArrayList<>();//保管库位的库存数据
                    for (WhWmsSkuStockVO stock : areaNormal.stocks) {
                        WhWmsHouseShelvesVO hs = whWmsHouseShelvesService.getHouseShelvesByCode(stock.getShelvesCode());
                        stock.setShelvesSortOrder(hs.getSortOrder());
                        if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_PICKING)){
                            pickingStocks.add(stock);
                        }
                        else if(hs.getShelvesType().equals(WhWmsHouseShelvesVO.SHELVES_TYPE_HOLDING)){
                            holdingStocks.add(stock);
                        }
                    }
                    sortSkuStock(pickingStocks);
                    //优先占用普通区的拣货库位库存
                    for (WhWmsSkuStockVO stock : pickingStocks) {
                        if(occupyQuantity>0){
                            int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                    ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                            if(availableOccupyQuantity<=0){
                                continue;
                            }

                            //调拨出库占库存
                            try{
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }catch (Exception e){
                                //ignore
                            }

                        }
                    }

                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }
                    sortSkuStock(holdingStocks);
                    for (WhWmsSkuStockVO stock : holdingStocks) {
                        if(occupyQuantity>0){
                            int availableOccupyQuantity = occupyQuantity <= stock.getAvailableAccount()
                                    ? occupyQuantity : stock.getAvailableAccount();//需求占用的数量小于等于库位可用数量,取需求占用的数量,否则取库位最大可用数
                            if(availableOccupyQuantity<=0){
                                continue;
                            }

                            //从普通区的保管库位直接占用拣货
                            try{
                                //生成占用vo 调用占用service
                                WhWmsOccupyVO occupyVO = WhWmsOccupyVO.buildOccupyVOFromStock(stock);
                                occupyVO.setAmount(0-availableOccupyQuantity);
                                occupyVO.setReceiptsNo(connect.getId().toString());
                                occupyVO.setType(WhWmsOccupyVO.TYPE_CONNECT);
                                whWmsOccupyService.wmsOccupy(occupyVO);

                                //已填充的占用数量+有效占用数量
                                skuQtt.disposeQuantity+=availableOccupyQuantity;
                                occupyQuantity = skuQtt.planedQuantity - skuQtt.disposeQuantity;
                            }catch(Exception e){
                                //ignore
                            }

                        }
                    }

                    //sku需求数已全部占用,中断sku的barcode循环
                    if(occupyQuantity==0){
                        break;
                    }

                }
            }
            
		}
    	
    }

    @Override
    public Boolean update(WhWmsCommandConnectVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo,WhWmsCommandConnect.class))!=0;
    }

    @Override
    public Boolean batchUpdate(WhWmsCommandConnect record,WhWmsCommandConnectCond cond) {
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cond.getIds())){
            criteria.andIdIn(cond.getIds());
        }
        return mapper.updateByExampleSelective(record,example)>0;
    }

    @Override
    @Transactional
    public Boolean batchCancel(List<String> commandCodes, Long connectId) {
        if(EmptyUtil.isEmpty(commandCodes)){
            return false;
        }
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        criteria.andCommandCodeIn(commandCodes).andConnectIdEqualTo(connectId).andCancelFlagEqualTo(PegasusConstants.NO);
        WhWmsCommandConnect update = new WhWmsCommandConnect();
        update.setCancelFlag(PegasusConstants.YES);
        mapper.updateByExampleSelective(update,example);
        return true;
    }

    @Override
    public Boolean batchCancelByConnectId(List<Long> connectIds) {
        if(EmptyUtil.isEmpty(connectIds)){
            return false;
        }
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();
        criteria.andConnectIdIn(connectIds).andCancelFlagEqualTo(PegasusConstants.NO);
        WhWmsCommandConnect update = new WhWmsCommandConnect();
        update.setCancelFlag(PegasusConstants.YES);
        mapper.updateByExampleSelective(update,example);
        return true;
    }

    @Override
    public WhWmsCommandConnectVO findById(Long id) {
        WhWmsCommandConnect whWmsCommandConnect = mapper.selectByPrimaryKey(id);
        if(whWmsCommandConnect!=null){
            return BeanUtil.buildFrom(whWmsCommandConnect,WhWmsCommandConnectVO.class);
        }
        return null;
    }

    @Override
    public WhWmsCommandConnectVO findNotCanceledByWhCommandCode(String whCommandCode) {
        WhWmsCommandConnectCond cond = new WhWmsCommandConnectCond();
        cond.setCommandCode(whCommandCode);
        cond.setCancelFlag(PegasusConstants.NO);
        List<WhWmsCommandConnectVO> vos = findByCond(cond);
        if(CollectionUtils.isEmpty(vos)){
            return null;
        }else{
            return vos.get(0);
        }

    }

    @Override
    public WhWmsCommandConnectVO findByWhCommandCode(String whCommandCode,boolean isCanceled) {
        WhWmsCommandConnectCond cond = new WhWmsCommandConnectCond();
        cond.setCommandCode(whCommandCode);
        if (isCanceled){
            cond.setCancelFlag(PegasusConstants.NO);
        }
        List<WhWmsCommandConnectVO> vos = findByCond(cond);
        if(CollectionUtils.isEmpty(vos)){
            return null;
        }else{
            return vos.get(0);
        }

    }

    @Override
    public List<WhWmsCommandConnectVO> findNotCanceledByConnectId(Long connectId) {
        WhWmsCommandConnectCond cond = new WhWmsCommandConnectCond();
        cond.setConnectId(connectId);
        cond.setCancelFlag(PegasusConstants.NO);
        List<WhWmsCommandConnectVO> vos = findByCond(cond);
        if(CollectionUtils.isEmpty(vos)){
            return null;
        }else{
            return vos;
        }
    }

    @Override
    public Integer findCountByConnectId(Long connectId) {
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        example.createCriteria().andConnectIdEqualTo(connectId);
        Integer count = mapper.countByExample(example);
        return count;
    }

    @Override
    public List<WhCountVO> countConnectCommandByConnectId(List<Long> connectIds) {
        return mapper.countConnectCommandByConnectId(connectIds);
    }

    @Override
    public List<WhWmsCommandConnectVO> findByCond(WhWmsCommandConnectCond cond) {
        WhWmsCommandConnectExample example = new WhWmsCommandConnectExample();
        WhWmsCommandConnectExample.Criteria criteria = example.createCriteria();

        if(!StringUtils.isEmpty(cond.getCommandCode())){
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        }else if(CollectionUtils.isNotEmpty(cond.getCommandCodes())){
            criteria.andCommandCodeIn(cond.getCommandCodes());
        }
        if(!NumberUtil.isNullOrZero(cond.getConnectId())){
            criteria.andConnectIdEqualTo(cond.getConnectId());
        }
        if(EmptyUtil.isNotEmpty(cond.getConnectIds())){
            criteria.andConnectIdIn(cond.getConnectIds());
        }
        if(cond.getCancelFlag()!=null){
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }
        if(cond.getCommandCodeList() != null && cond.getCommandCodeList().size() > 0){
            criteria.andCommandCodeIn(cond.getCommandCodeList());
        }
        example.setOrderByClause(" ID " + cond.getCriteriaStr());

        List<WhWmsCommandConnect> whWmsCommandConnects = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsCommandConnects)) {
            return Collections.emptyList();
        }
        List<WhWmsCommandConnectVO> vos = new ArrayList<WhWmsCommandConnectVO>(whWmsCommandConnects.size());
        for (WhWmsCommandConnect whWmsCommandConnect : whWmsCommandConnects) {
            vos.add(BeanUtil.buildFrom(whWmsCommandConnect,WhWmsCommandConnectVO.class));
        }
        return vos;
    }

    /**
     * 创建前验证
     * @param vo
     */
    private void validateBeforeCreate(WhWmsCommandConnectVO vo){
        if(vo.getConnectId()==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"connectId为空");
        }
        WhWmsConnectInfoVO whWmsConnectInfoVO = whWmsConnectInfoService.findById(vo.getConnectId());
        if(whWmsConnectInfoVO==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM,"connect["+vo.getConnectId()+"] 实体为空");
        }
    }

}
