/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.common.lock.RedisDistributLock;
import com.thebeastshop.pegasus.integration.express.ExpressUtil;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.exfresh.ExFreshUtil;
import com.thebeastshop.pegasus.integration.express.zt.ZTExpressUtil;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrder;
import com.thebeastshop.pegasus.integration.express.zt.ZTOrderSubmitResponse;
import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.*;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCheckGiftCardMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandCheckMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWmsCommandPreOccupyIdxMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.exception.WmsExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/**
 * @author Eric.Lou
 * @version $Id: WhWmsCommandCheckServiceImpl.java, v 0.1 2016-04-14 下午3:31
 */
@Service("whWmsCommandCheckService")
public class WhWmsCommandCheckServiceImpl implements WhWmsCommandCheckService {

    @Autowired
    private WhWmsCommandCheckMapper mapper;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhWmsCommandConnectService whWmsCommandConnectService;

    @Autowired
    private WhWmsConnectInfoService whWmsConnectInfoService;

    @Autowired
    private WhWmsConnectDistributionService whWmsConnectDistributionService;

    @Autowired
    private WhWmsConnectPickSkuService whWmsConnectPickSkuService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsMoveStockService whWmsMoveStockService;

    @Autowired
    private WhCommandAssociateExpressService whCommandAssociateExpressService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhWmsCommandPreOccupyIdxMapper whWmsCommandPreOccupyIdxMapper;

    @Autowired
    private WhWmsOperationRcdService whWmsOperationRcdService;

    @Autowired
    private WhWmsCheckGiftCardMapper whWmsCheckGiftCardMapper;

    /**
     *
     * @param vos
     */
    public WhWmsConnectPickSkuSubmitDataVO preCheckCommandCheck(List<WhWmsCommandCheckVO> vos,Long operatorId){
        WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO = new WhWmsConnectPickSkuSubmitDataVO();
        if(CollectionUtils.isEmpty(vos)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        Set<String> commandCodes = new HashSet<>();
        for (WhWmsCommandCheckVO vo : vos) {
            commandCodes.add(vo.getCommandCode());
        }
        //同一个command数据
        if(CollectionUtils.isEmpty(commandCodes)||commandCodes.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        WhCommand whCommand = whCommandService.findCommandByCode(vos.get(0).getCommandCode(), true);
        //whWmsConnectPickSkuSubmitDataVO.setWhCommand(whCommand);
        whWmsConnectPickSkuSubmitDataVO.setCommandList(Arrays.asList(whCommand));
        if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是待包装状态");
        }
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
        if(commandConnectVO==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
        }
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次必须是已完成状态");
        }
        whWmsConnectPickSkuSubmitDataVO.setConnectVO(connectVO);
        //取消的出库指令
        if(whCommand.getCancelFlag().equals(PegasusConstants.YES)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令无法出库已被取消");
        }

        preCheckAndBuildMoveSktock(vos,whWmsConnectPickSkuSubmitDataVO,connectVO,operatorId);
        return whWmsConnectPickSkuSubmitDataVO;
    }

    public WhWmsConnectPickSkuSubmitDataVO preBatchCheckCommandCheck(List<WhWmsCommandCheckVO> vos,Long operatorId,List<WhCommand> whCommands){
        WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO = new WhWmsConnectPickSkuSubmitDataVO();
        if(CollectionUtils.isEmpty(vos)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        //WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findByCond(whCommands);
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommands.get(0).getCode());
        if(commandConnectVO==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
        }
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次必须是已完成状态");
        }
        //whWmsConnectPickSkuSubmitDataVO.setWhCommand(whCommands.get(0));
        whWmsConnectPickSkuSubmitDataVO.setCommandList(whCommands);
        for (WhCommand whCommand : whCommands){
            if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是待包装状态");
            }
            //取消的出库指令
            if(whCommand.getCancelFlag().equals(PegasusConstants.YES)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令无法出库已被取消");
            }
        }
        whWmsConnectPickSkuSubmitDataVO.setConnectVO(connectVO);
        preCheckAndBuildMoveSktock(vos,whWmsConnectPickSkuSubmitDataVO,connectVO,operatorId);
        return whWmsConnectPickSkuSubmitDataVO;
    }

    public void preCheckAndBuildMoveSktock(List<WhWmsCommandCheckVO> vos,
                                                                      WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO,
                                                                      WhWmsConnectInfoVO connectVO,Long operatorId){
        //检查有没有交接区
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);//交接区
        List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hs) || hs.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,交接区");
        }
        WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
        //检查有没有分拨包装区
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);//分拨包装区
        if(connectVO.getConnectType().equals(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE)){
            whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);//分拨包装区
        }
        List<WhWmsHouseShelvesVO> hsPacking = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hsPacking) || hsPacking.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,分拨包装区");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
        for (WhWmsCommandCheckVO vo : vos) {
            if (vo.getIsMaterial().equals(PegasusConstants.YES)) {
                vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            } else {
                vo.setSkuStatus(connectVO.getSkuStatus());
            }
        }
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(operatorId);
        moveStockVO.setOperatorId(operatorId);
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
        moveStockVO.setMoveSkuList(moveStockSkuList);
        //移库行数据
        for (WhWmsCommandCheckVO vo : vos) {
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveSkuVO.setSkuCode(vo.getSkuCode());
            moveSkuVO.setSkuStatus(vo.getSkuStatus());
            moveSkuVO.setBarCode(vo.getBarCode());
            moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
            moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
            moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
            moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
            moveSkuVO.setAmount(vo.getCheckAmount());
            moveStockSkuList.add(moveSkuVO);
        }
        whWmsMoveStockService.rebuildMoveStock(moveStockVO);
        whWmsMoveStockService.moveStockCheck(moveStockVO);
        whWmsConnectPickSkuSubmitDataVO.setMoveStockVO(moveStockVO);
    }

    @Override
    @Transactional
    public boolean submitConnectCheck(WhWmsConnectCheckVO connectCheck) {
        //出库指令状态更新-记录验货数据
        if(EmptyUtil.isNotEmpty(connectCheck.getOutCommandList())){
            List<WhWmsCommandCheckVO> commandCheckList = new ArrayList<>();
            Map<String,Integer> barcodeMap = connectCheck.getCheckBarCodeMap();
            Map<String,Integer> groupSkuMap = connectCheck.getGroupSkuMap();
            List<String> outCommandCodes = new ArrayList<>();
            for(WhCommand cmd : connectCheck.getOutCommandList()){
                outCommandCodes.add(cmd.getCode());
                for(String barCode : barcodeMap.keySet()){
                    WhWmsCommandCheckVO cmdCheck = new WhWmsCommandCheckVO();
                    String skuCode = barCode.split("_")[0];
                    Integer singleGroupAmount = groupSkuMap.get(skuCode);
                    cmdCheck.setCommandCode(cmd.getCode());
                    cmdCheck.setBarCode(barCode);
                    cmdCheck.setSkuCode(skuCode);
                    cmdCheck.setAmount(singleGroupAmount);
                    cmdCheck.setCheckAmount(singleGroupAmount);
                    cmdCheck.setIsMaterial(PegasusConstants.NO);
                    cmdCheck.setCancelFlag(PegasusConstants.NO);
                    cmdCheck.setSkuStatus(connectCheck.getSkuStatus());
                    commandCheckList.add(cmdCheck);
                }
            }
            whCommandService.batchCommandInPackingToHandover(outCommandCodes);
            mapper.batchInsert(commandCheckList);
        }
        //波次指令关系打取消标记
        List<String> connectCommandCancelList = new ArrayList<>();
        //取消指令状态更新为缺货中
        if(EmptyUtil.isNotEmpty(connectCheck.getCancelCommandCodes())){
            connectCommandCancelList.addAll(connectCheck.getCancelCommandCodes());
            //直接取消
            whCommandService.cancelCommandforShortage(connectCheck.getCancelCommandCodes(),WhCommand.STATUS_PACKING);
//            whCommandService.batchUpdateCommandStatus(connectCheck.getCancelCommandCodes(),WhCommand.STATUS_SHORTAGES,WhCommand.STATUS_PACKING);

        }
        //缺货指令更新为初始，打缺货标记
        if(EmptyUtil.isNotEmpty(connectCheck.getShortageCommandCodes())){
            connectCommandCancelList.addAll(connectCheck.getShortageCommandCodes());
            whCommandService.failureStartConnect(connectCheck.getShortageCommandCodes());
            whCommandService.batchUpdateCommandStatus(connectCheck.getShortageCommandCodes(),WhCommand.STATUS_IN_PROCESSING,WhCommand.STATUS_PACKING);
            //删除预占记录key,否则无法重新占用
            whWmsCommandPreOccupyIdxMapper.batchDelete(connectCheck.getShortageCommandCodes());
        }
        if(EmptyUtil.isNotEmpty(connectCommandCancelList)){
            whWmsCommandConnectService.batchCancel(connectCommandCancelList,connectCheck.getConnectId());
        }
        //处理相关移库
        if(EmptyUtil.isNotEmpty(connectCheck.getMoveStockList())){
            for(WhWmsMoveStockVO moveStock : connectCheck.getMoveStockList()){
                if(NullUtil.isNull(moveStock)){
                    continue;
                }
                if(moveStock.isAutoFinish()){
                    whWmsMoveStockService.executeMoveStock(moveStock);
                }else{
                    whWmsMoveStockService.createMoveStock(moveStock);
                }
                if(WhWmsMoveStockVO.MOVE_TYPE_CANCEL_MAKE.equals(moveStock.getMoveType())){
                    connectCheck.setToCancelMoveCode(moveStock.getCode());
                }
            }
        }
        //删除拣货周转箱
        whWmsConnectPickSkuService.deleteConnectBox(connectCheck.getConnectId());
        return true;
    }

    public Boolean cancelBatchCheck(List<String> commandCodes,Long operatorId,List<WhWmsCommandCheckVO> vos,Integer stockoutCount,WhWmsCommandCheckPara whWmsCommandCheckPara) {
        if(EmptyUtil.isEmpty(commandCodes)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        WhCommandCond cond = new WhCommandCond();
        cond.setCodeList(commandCodes);
        List<WhCommand> whCommandList = whCommandService.findCommandByCond(cond);
        if(whCommandList != null && whCommandList.size() > 0){
            for(WhCommand whCommand:whCommandList){
                if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是待包装状态");
                }
            }
        }else{
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"找不到对应的出库指令");
        }
        if(commandCodes.size() != whCommandList.size()){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"找不到对应的出库指令");
        }
        WhWmsCommandConnectCond whWmsCommandConnectCond = new WhWmsCommandConnectCond();
        whWmsCommandConnectCond.setConnectId(whWmsCommandCheckPara.getConnectId());
        whWmsCommandConnectCond.setCancelFlag(0);
        List<WhWmsCommandConnectVO> commandConnectVOList = whWmsCommandConnectService.findByCond(whWmsCommandConnectCond);
        if (CollectionUtils.isEmpty(commandConnectVOList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
        }
        WhWmsConnectInfoVO connectInfoVO = whWmsConnectInfoService.findById(whWmsCommandCheckPara.getConnectId());
        if(connectInfoVO == null ||
                !connectInfoVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次必须是已完成状态");
        }

        for(WhWmsCommandConnectVO vo:commandConnectVOList){
            vo.setCancelFlag(PegasusConstants.YES);
        }
        whWmsCommandCheckPara.setOutStockCommandConncectVOList(commandConnectVOList);
        //删除波次和cmd的关联
        whWmsCommandCheckPara.setOutStockConnectInfo(connectInfoVO);

        //更新command执行中,更新失败次数
        for(WhCommand whCommand:whCommandList){
            if(whCommand.getCancelFlag() == 1){
                whCommand.setCommandStatus(WhCommand.STATUS_SHORTAGES);
            }else{
                whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            }
            whCommand.setFailureStartConnect(whCommand.getFailureStartConnect()+1);
        }
        whWmsCommandCheckPara.setOutStockCommandList(whCommandList);

        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectInfoVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);//分拨包装区
        List<WhWmsHouseShelvesVO> hsPacking = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hsPacking) || hsPacking.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,活动区");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);

        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectInfoVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_DIFF);//分拨包装区
        List<WhWmsHouseShelvesVO> diffShelves = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(diffShelves) || diffShelves.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,差异区");
        }
        WhWmsHouseShelvesVO tarShelves = diffShelves.get(0);

        WhWmsConnectPickSkuCond pickSkuCond = new WhWmsConnectPickSkuCond();
        pickSkuCond.setConnectId(connectInfoVO.getId());
        List<WhWmsConnectPickSkuVO> connectPickSkuVOs = whWmsConnectPickSkuService.findConnectPickSkuByCond(pickSkuCond);
        Map<String,Map<String,Integer>> diffSkuMap = computePickSkuDiffStock(connectPickSkuVOs,vos);
        if(diffSkuMap != null && diffSkuMap.size() > 0){
            WhWmsMoveStockVO whWmsMoveStockVO = moveDiffStockThenFinish(connectInfoVO,whCommandList.get(0),operatorId,sourceShelvesVO,tarShelves,diffSkuMap);
            whWmsMoveStockService.rebuildMoveStock(whWmsMoveStockVO);
            whWmsMoveStockService.moveStockCheck(whWmsMoveStockVO);
            List<WhWmsMoveStockVO> moveStockVOList = new ArrayList<>();
            moveStockVOList.add(whWmsMoveStockVO);
            whWmsCommandCheckPara.setStockoutMoveStockList(moveStockVOList);
        }
        return true;
    }

    public String cancelMakeCommandOnCheckOut(WhWmsMoveStockVO move, WhCommand command) {
        String commandCode = command.getCode();
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsConnectInfoVO connect = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(NullUtil.isNull(connect)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不存在");
        }
        whWmsConnectDistributionService.deleteConnectDistribution(connect.getId(),commandCode);
        whCommandService.commandStatusToShortages(commandCode);
        if (!(EmptyUtil.isNotEmpty(command.isNoCreateMoveStock()) && command.isNoCreateMoveStock())){
            whWmsMoveStockService.newMoveStock(move);
            return move.getCode();
        }
        return null;
    }

    public boolean cancelMakeCommandOnCheckOut(WhWmsCommandCheckPara whWmsCommandCheckPara) {
        WhWmsMoveStockVO move = whWmsCommandCheckPara.getCancelMoveStockVO();
        List<WhCommand> commands = whWmsCommandCheckPara.getCancelCommands();
        if (CollectionUtils.isEmpty(commands)){
            return false;
        }
        List<String> cancelCommands = new ArrayList<>();
        for (WhCommand whCommand : commands){
            cancelCommands.add(whCommand.getCode());
        }
        String commandCode = cancelCommands.get(0);
        //WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(commandCode);
        WhWmsCommandConnectCond commandConnectCond = new WhWmsCommandConnectCond();
        commandConnectCond.setCommandCodes(cancelCommands);
        commandConnectCond.setCancelFlag(PegasusConstants.NO);
        List<WhWmsCommandConnectVO> commandConnectVOs = whWmsCommandConnectService.findByCond(commandConnectCond);
        if (CollectionUtils.isEmpty(commandConnectVOs)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
        }
        WhWmsConnectInfoVO connect = whWmsConnectInfoService.findById(commandConnectVOs.get(0).getConnectId());
        if(NullUtil.isNull(connect)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次不存在");
        }

        whWmsCommandCheckPara.setConnectId(connect.getId());
        whWmsCommandCheckPara.setCancelCommandCodes(cancelCommands);
        whWmsCommandCheckPara.setCancelCommandCode(commandCode);
        if (!(EmptyUtil.isNotEmpty(whWmsCommandCheckPara.isNoCreateMoveStock()) && whWmsCommandCheckPara.isNoCreateMoveStock())){
            if (EmptyUtil.isNotEmpty(move) && whWmsMoveStockService.buildMoveStock(move)){
                whWmsCommandCheckPara.setCancelMoveStockVO(move);
            }else{
                whWmsCommandCheckPara.setCancelMoveStockVO(null);
            }
        }
        return true;
    }

    @Override
    public List<WhWmsCommandCheckVO> create(List<WhWmsCommandCheckVO> vos,WhWmsConnectPickSkuSubmitDataVO whWmsConnectPickSkuSubmitDataVO,Long operatorId) {
        WhWmsConnectInfoVO whWmsConnectInfoVO = whWmsConnectPickSkuSubmitDataVO.getConnectVO();
        List<String> newCommandCodes = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(whWmsConnectPickSkuSubmitDataVO.getCommandList())) {
            List<WhCommand> whCommands = whWmsConnectPickSkuSubmitDataVO.getCommandList();
            List<WhCommand> commandAssociateExpresss = new ArrayList<>();
            for (WhCommand whCommand : whCommands) {
                if (whCommand != null && WhCommand.STATUS_PACKING.equals(whCommand.getCommandStatus())) {
                    newCommandCodes.add(whCommand.getCode());
                }
                if (WMSConstants.ExpressType.SELF.equals(whCommand.getExpressType())
                        || WMSConstants.ExpressType.SHOP.equals(whCommand.getExpressType())) {
                    commandAssociateExpresss.add(whCommand);
                }
            }

            if (CollectionUtils.isNotEmpty(newCommandCodes)) {
                // 批量更新command状态,待包装到待交接
                whCommandService.batchCommandInPackingToHandover(newCommandCodes);
                //去除分拨数据校验。允许barcode不一致，sku实际数量和计划数量一致即可。前端校验
                //校验barcode数据是否一致
                //whWmsConnectDistributionService.checkConnectDistribution(commandConnectVO.getConnectId(),commandConnectVO.getCommandCode(),vos);
            }

            if (WMSConstants.ConnectType.SINGLE_PRODUCT_SINGLE_PIECE.equals(whWmsConnectInfoVO.getConnectType())
                    || WMSConstants.ConnectType.MULTI_PIECE_ACTIVITY.equals(whWmsConnectInfoVO.getConnectType())
                    || WMSConstants.ConnectType.BULK_ORDER.equals(whWmsConnectInfoVO.getConnectType())
                    || WMSConstants.ConnectType.LARGE_SIZED_PACKAGE.equals(whWmsConnectInfoVO.getConnectType())){
                //尝试删除拣货周转箱-单品单件 多件活动验货 大宗订单 大件包裹
                whWmsConnectPickSkuService.deleteConnectBox(whWmsConnectInfoVO.getId());
            }else if(WMSConstants.ConnectType.MULTI_PRODUCT_SINGLE_PIECE.equals(whWmsConnectInfoVO.getConnectType())){
                List<WhCommand> restCommandList = whCommandService.findCommandByConnectIdAndBarCode(null,whWmsConnectInfoVO.getId());
                if(EmptyUtil.isEmpty(restCommandList)){
                    //所有command都验货完成
                    whWmsConnectPickSkuService.deleteConnectBox(whWmsConnectInfoVO.getId());
                }
            }else{
                //删除分拨数据
                whWmsConnectDistributionService.deleteConnectDistribution(whWmsConnectInfoVO.getId(),whCommands.get(0).getCode());
            }

            //批量创建出库验货数据
            for (WhWmsCommandCheckVO vo : vos) {
                if (vo.getIsMaterial().equals(PegasusConstants.YES)) {
                    vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                } else {
                    vo.setSkuStatus(whWmsConnectInfoVO.getSkuStatus());
                }
                create(vo);
            }
            //batchCreateCommandCheck(vos);

            //记录验货日志
            buildOperationRcdThenBatchInsert(vos,whWmsConnectInfoVO,operatorId);
            //batchCreate(vos);
            //记录验货礼品卡
            batchInserCheckGiftCard(whWmsConnectPickSkuSubmitDataVO.getCheckGiftCardList());
            //调用移库接口
            //whWmsMoveStockService.newMoveStock(moveStockVO);
            //调用移库完成接口
            //whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(),operatorId);
            //创建移库单,分拨包装区到交接区
            WhWmsMoveStockVO moveStockVO = whWmsConnectPickSkuSubmitDataVO.getMoveStockVO();
            if (moveStockVO != null) {
                //检查有没有分拨包装区
                whWmsMoveStockService.executeMoveStock(moveStockVO);
            }
            if (CollectionUtils.isNotEmpty(commandAssociateExpresss)) {
                whCommandAssociateExpressService.batchCommandAssociateExpress(commandAssociateExpresss);//店送 自送 将相关单据号 填到快递单号字段
            }
        }
        return vos;
    }

    @Override
    @Transactional
    public boolean createCustomization(WhWmsCommandCheckInfo checkInfo) {
        Set<String> commandCodes = new HashSet<>();
        for (WhWmsCommandCheckVO vo : checkInfo.getCommandCheckDetailList()) {
            commandCodes.add(vo.getCommandCode());
        }
        //同一个command数据
        if(CollectionUtils.isEmpty(commandCodes)||commandCodes.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        WhCommand whCommand = whCommandService.findCommandByCode(checkInfo.getCommandCode(), true);
        if(!WhCommand.STATUS_IN_PROCESSING.equals(whCommand.getCommandStatus())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是初始状态！");
        }
        //取消的出库指令
        if(NullUtil.isNotNull(whCommand.getCancelFlag()) && whCommand.getCancelFlag().equals(PegasusConstants.YES)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令无法出库已被取消");
        }
        WhPhysicalWarehouse whPhysicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whCommand.getPhysicalWarehouseCode());
        WhWmsHouseShelvesVO handOverShelvesVO = getOnlyOneHouseShelves(whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);
        List<WhWmsHouseShelvesVO> customizationAreaShelves = getHouseShelves(whPhysicalWarehouse.getCode(),WhWmsWarehouseAreaVO.HOUSE_TYPE_CUSTOMIZATION);
        WhWmsHouseShelvesVO customizationShelvesVO = customizationAreaShelves.get(0);
        //是否有未完成移库任务
        //checkMoveStock(whCommand);
        //定制区库存检查
        checkWmsSkuStock(checkInfo.getCommandCheckDetailList(),customizationShelvesVO);
        //更新command状态,待包装到待交接
        whCommandService.commandInProcessingToHandover(whCommand.getCode());
        //创建移库单,定制区到交接区
        doMoveStockThenFinish(
                checkInfo.getCommandCheckDetailList()
                ,customizationShelvesVO
                ,handOverShelvesVO
                ,checkInfo.getOperatorId());
        //批量创建出库验货数据
        for (WhWmsCommandCheckVO vo : checkInfo.getCommandCheckDetailList()) {
            vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
            create(vo);
        }
        //记录礼品卡验货信息
        batchInserCheckGiftCard(checkInfo.getCheckGiftCardList());
        WhWmsConnectInfoVO whWmsConnectInfoVO = whCommandService.findWhWmsConnectInfoVOByCommandCode(whCommand.getCode());
        buildOperationRcdThenInsert(checkInfo.getCommandCheckDetailList().get(0),whWmsConnectInfoVO,checkInfo.getOperatorId());
        //调用电子面单接口
        //doAssociateExpress(whCommand,isEbill,pi,ztOrder);
        return true;
    }

    //检查定制skuwms库存
    private void checkWmsSkuStock(List<WhWmsCommandCheckVO> vos,WhWmsHouseShelvesVO customizationShelvesVO){
        Map<String,Integer> customizationSkuMap = new HashMap<>();
        Map<String,Integer> normalSkuMap = new HashMap<>();
        String key = null;
        for(WhWmsCommandCheckVO commandCheckVO : vos){
            key = commandCheckVO.getSkuCode()+"|"+commandCheckVO.getBarCode();
            if(commandCheckVO.isCustomization()){
                Integer amount = customizationSkuMap.get(key);
                if(NullUtil.isNull(amount)){
                    customizationSkuMap.put(key,commandCheckVO.getAmount());
                }else{
                    customizationSkuMap.put(key,commandCheckVO.getAmount()+amount);
                }
            }else{
                Integer amount = normalSkuMap.get(key);
                if(NullUtil.isNull(amount)){
                    normalSkuMap.put(key,commandCheckVO.getAmount());
                }else{
                    normalSkuMap.put(key,commandCheckVO.getAmount()+amount);
                }
            }
        }
        WhWmsSkuStockVO stockCond = new WhWmsSkuStockVO();
        stockCond.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
        stockCond.setShelvesCode(customizationShelvesVO.getCode());
        List<WhWmsSkuStockVO> custShelveStockList = whWmsSkuStockService.getWmsSkuStocksByShelvesCond(stockCond);
        if(EmptyUtil.isEmpty(custShelveStockList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"定制商品库存不足！");
        }
        Map<String,Integer> custStockMap = new HashMap<>();
        for(WhWmsSkuStockVO skuStockVO : custShelveStockList){
            if(skuStockVO.getAvailableAmount() <= 0){
                continue;
            }
            key = skuStockVO.getSkuCode()+"|"+skuStockVO.getBarCode();
            Integer amount = custStockMap.get(key);
            if(NullUtil.isNull(amount)){
                custStockMap.put(key,skuStockVO.getAvailableAmount());
            }else{
                custStockMap.put(key,amount+skuStockVO.getAvailableAmount());
            }
        }
        //定制商品库存检查
        for(Map.Entry<String,Integer> skuOutStock : customizationSkuMap.entrySet()){
            key = skuOutStock.getKey();
            Integer needAmount = skuOutStock.getValue();
            Integer totalAmount = custStockMap.get(key);
            if(NullUtil.isNull(totalAmount)){
                totalAmount = 0;
            }
            if(needAmount > totalAmount){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]定制商品库存不足[%s<%s]！",key,totalAmount,needAmount));
            }
        }
        //非定制定制商品区库存检查
        for(Map.Entry<String,Integer> skuOutStock : normalSkuMap.entrySet()){
            String skuCode = skuOutStock.getKey();
            Integer needAmount = skuOutStock.getValue();
            Integer totalAmount = custStockMap.get(skuCode);
            if(NullUtil.isNull(totalAmount)){
                totalAmount = 0;
            }
            if(needAmount > totalAmount){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,String.format("[%s]商品库存不足[%s<%s]！",skuCode,totalAmount,needAmount));
            }
        }


    }

    private WhWmsHouseShelvesVO getOnlyOneHouseShelves(String physicalWarehouseCode ,String sourceArea){
        List<WhWmsHouseShelvesVO> list = getHouseShelves(physicalWarehouseCode,sourceArea);
        if(list.size() > 1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,"+WhWmsWarehouseAreaVO.getHouseAreaName(sourceArea));
        }
        return list.get(0);
    }


    private List<WhWmsHouseShelvesVO> getHouseShelves(String physicalWarehouseCode ,String sourceArea){
        //检查有没有定制区
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(physicalWarehouseCode);
        whWmsHouseShelvesCond.setHouseType(sourceArea);//定制区
        List<WhWmsHouseShelvesVO> list = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(list)){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,"+WhWmsWarehouseAreaVO.getHouseAreaName(sourceArea));
        }
        return list;
    }


    private void doMoveStockThenFinish(List<WhWmsCommandCheckVO> vos,WhWmsHouseShelvesVO sourceShelvesVO,WhWmsHouseShelvesVO targetShelvesVO,Long operatorId){
        List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
        //移库行数据
        for (WhWmsCommandCheckVO vo : vos) {
            WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
            moveSkuVO.setPhysicalWarehouseCode(sourceShelvesVO.getPhysicalWarehouseCode());
            moveSkuVO.setSkuCode(vo.getSkuCode());
            moveSkuVO.setSkuStatus(vo.getSkuStatus());
            moveSkuVO.setBarCode(vo.getBarCode());
            moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
            moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
            moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
            moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
            moveSkuVO.setAmount(vo.getCheckAmount());
            moveStockSkuList.add(moveSkuVO);
        }
        if(EmptyUtil.isEmpty(moveStockSkuList)){
            return;
        }
        WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
        moveStockVO.setPhysicalWarehouseCode(sourceShelvesVO.getPhysicalWarehouseCode());
        moveStockVO.setCreateUserId(operatorId);
        moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
        moveStockVO.setMoveSkuList(moveStockSkuList);
        //调用移库接口
        whWmsMoveStockService.newMoveStock(moveStockVO);
        //调用移库完成接口
        whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(),operatorId);
    }

    private void buildOperationRcdThenInsert(WhWmsCommandCheckVO vo,WhWmsConnectInfoVO whWmsConnectInfoVO,Long operatorId){
       try{
           WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
           rcd.setReferenceCode(vo.getId().toString());
           rcd.setOperateType(WhWmsOperationRcdVO.OPERATOR_TYPE_CHECKOUT);
           rcd.setCommandCode(vo.getCommandCode());
           rcd.setOperatorId(operatorId);
           rcd.setOperateTime(DateUtil.getNow());
           rcd.setOperationDesc(whWmsConnectInfoVO.getId()+"");
           //记录操作日志
           whWmsOperationRcdService.insert(rcd);
       }catch (Exception e){
           e.printStackTrace();
       }
    }

    private void buildOperationRcdThenBatchInsert(List<WhWmsCommandCheckVO> vos,WhWmsConnectInfoVO whWmsConnectInfoVO,Long operatorId){
        List<WhWmsOperationRcdVO> rcds = new ArrayList<>();
        for (WhWmsCommandCheckVO vo : vos){
            WhWmsOperationRcdVO rcd = new WhWmsOperationRcdVO();
            rcd.setOperatorId(operatorId);
            rcd.setOperateType(WhWmsOperationRcdVO.OPERATOR_TYPE_CHECKOUT);
            rcd.setReferenceCode(vo.getId().toString());
            rcd.setOperateTime(DateUtil.getNow());
            rcd.setCommandCode(vo.getCommandCode());
            rcd.setOperationDesc(whWmsConnectInfoVO.getId()+"");
            rcds.add(rcd);
        }

        //记录操作日志
        whWmsOperationRcdService.batchInsert(rcds);
    }

    //检查sku数量
    private void checkSkuAmount(WhCommand whCommand,List<WhWmsCommandCheckVO> vos){
    	List<WhCommandSku> cmdSkus = whCommand.getWhCommandSkuList();
    	if(EmptyUtil.isNotEmpty(cmdSkus)){
    		for(WhCommandSku cmdSku : cmdSkus){
    			cmdSku.setQuantity(0);
    			cmdSku.setDamagedQuantity(0);
    		}
    	}
    }

    @Override
    public Boolean create(Long connectId, List<WhWmsCommandCheckBatch> batchList, List<PackageInfo> fedList, List<PackageInfo> sfList) {
        //删除拣货任务数据
        whWmsConnectPickSkuService.deleteConnectBox(connectId);
        //先调用电子面单接口
        if(CollectionUtils.isNotEmpty(fedList) && isEbillMode(WMSConstants.ExpressType.FEDEX)){
             ExpressUtil.orderFedExpressInfo(fedList, false);
         }
        if(CollectionUtils.isNotEmpty(sfList) && isEbillMode(WMSConstants.ExpressType.SF_LAND)){
            ExpressUtil.genSFDeliveryCode(sfList);
        }
        batchCreate(connectId,batchList);
        return true;
    }

    private void batchCreate(Long connectId, List<WhWmsCommandCheckBatch> batchList){
        for (WhWmsCommandCheckBatch batch : batchList) {
            //循环创建出库验货
            WhCommand whCommand = whCommandService.findCommandByCode(batch.getWhWmsCommandCheckVOList().get(0).getCommandCode(), false);
            if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_DISTRIBUTION)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是待分拨状态");
            }
            WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
            if(commandConnectVO==null){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
            }
            WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
            if(!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.DISTRIBUTION)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次必须是分拨状态");
            }
            //取消的出库指令
            if(whCommand.getCancelFlag().equals(PegasusConstants.YES)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令无法出库已被取消");
            }
            //更新command状态,待包装到待交接
            whCommandService.commandInDistributionToPacking(commandConnectVO.getCommandCode());
            whCommandService.commandInPackingToHandover(commandConnectVO.getCommandCode());
            //创建移库单,分拨包装区到交接区
            //检查有没有交接区
            WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
            whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_HANDOVER);//交接区
            List<WhWmsHouseShelvesVO> hs = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
            if(CollectionUtils.isEmpty(hs) || hs.size()>1){
                throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,交接区");
            }
            WhWmsHouseShelvesVO targetShelvesVO = hs.get(0);
            //检查有没有分拨包装区
            whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);//分拨包装区
            List<WhWmsHouseShelvesVO> hsPacking = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
            if(CollectionUtils.isEmpty(hsPacking) || hsPacking.size()>1){
                throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,分拨包装区");
            }
            WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(batch.getOperatorId());
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
            moveStockVO.setMoveSkuList(moveStockSkuList);

            //批量创建出库验货数据
            for (WhWmsCommandCheckVO vo : batch.getWhWmsCommandCheckVOList()) {
                if(vo.getIsMaterial().equals(PegasusConstants.YES)){
                    vo.setSkuStatus(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE);
                }else{
                    vo.setSkuStatus(connectVO.getSkuStatus());
                }
                vo.setCancelFlag(PegasusConstants.NO);
                create(vo);
            }

            //移库行数据
            for (WhWmsCommandCheckVO vo : batch.getWhWmsCommandCheckVOList()) {
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(vo.getSkuCode());
                moveSkuVO.setSkuStatus(vo.getSkuStatus());
                moveSkuVO.setBarCode(vo.getBarCode());
                moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                moveSkuVO.setTargetHouseType(targetShelvesVO.getHouseType());
                moveSkuVO.setTargetShelvesCode(targetShelvesVO.getCode());
                moveSkuVO.setAmount(vo.getCheckAmount());
                moveStockSkuList.add(moveSkuVO);
            }

            //调用移库接口
            whWmsMoveStockService.newMoveStock(moveStockVO);
            //调用移库完成接口
            whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(),batch.getOperatorId());

            //调用电子面单接口
            if(batch.getPi()!=null){
                if(whCommand.getExpressType().equals(WMSConstants.ExpressType.FEDEX)){
                    //联邦
                    if (batch.getPi().getDeliveryCode()!=null && batch.getPi().getExpressOrderNo()!=null){
                        //联邦电子面单调用成功
                        whCommandAssociateExpressService.commandAssociateExpress(whCommand.getCode(),batch.getPi().getDeliveryCode());
                    }
                }else  if(whCommand.getExpressType().equals(WMSConstants.ExpressType.SF_LAND)
                        ||whCommand.getExpressType().equals(WMSConstants.ExpressType.SF_AIR)
                        ||whCommand.getExpressType().equals(WMSConstants.ExpressType.SF_COLD_CHAIN)){
                    //顺丰空运、顺丰陆运
                    if(batch.getPi().getDeliveryCode()!=null && batch.getPi().getExpressOrderNo()!=null && batch.getPi().getOriginCode()!=null && batch.getPi().getDestCode()!=null){
                        //顺丰电子面单调用成功
                        whCommandAssociateExpressService.commandAssociateExpress(whCommand.getCode(),batch.getPi().getDeliveryCode());
                    }
                }

            }
            //next
        }
        //更新波次状态
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(connectId);
        connectVO.setConnectStatus(WMSConstants.ConnectStatus.FINISHED);
        whWmsConnectInfoService.update(connectVO);
    }

    @Override
    public Boolean cancel(String commandCode, Long operatorId) {
        if(EmptyUtil.isEmpty(commandCode)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        WhCommand whCommand = whCommandService.findCommandByCode(commandCode, true);
        if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是待包装状态");
        }
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
        if(commandConnectVO==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
        }
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次必须是已完成状态");
        }
        //删除波次和cmd的关联
        commandConnectVO.setCancelFlag(PegasusConstants.YES);
        whWmsCommandConnectService.update(commandConnectVO);

        //更新command执行中,更新失败次数
        if(whCommand.getCancelFlag() == 1){
            whCommand.setCommandStatus(WhCommand.STATUS_SHORTAGES);
        }else{
            whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
            //删除预占记录key,否则无法重新占用
            whWmsCommandPreOccupyIdxMapper.batchDelete(Collections.singletonList(whCommand.getCode()));
        }
        whCommand.setFailureStartConnect(whCommand.getFailureStartConnect()+1);
        whCommandService.updateCommand(whCommand);
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);//分拨包装区
        List<WhWmsHouseShelvesVO> hsPacking = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hsPacking) || hsPacking.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,分拨包装区["+whWmsHouseShelvesCond.getHouseType()+"],物理仓["+connectVO.getPhysicalWarehouseCode()+"]");
        }

        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_DIFF);//差异区
        List<WhWmsHouseShelvesVO> diffShelves = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(diffShelves) || diffShelves.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,差异区["+whWmsHouseShelvesCond.getHouseType()+"],物理仓["+connectVO.getPhysicalWarehouseCode()+"]");
        }

        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);
        WhWmsHouseShelvesVO tarShelves = diffShelves.get(0);
        WhWmsSkuStockVO whWmsSkuStockVO = new WhWmsSkuStockVO() ;
        whWmsSkuStockVO.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_ACTIVE);
        whWmsSkuStockVO.setSkuCode(whCommand.getWhCommandSkuList().get(0).getSkuCode());
        whWmsSkuStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        whWmsSkuStockVO.setShelvesCode(sourceShelvesVO.getCode());
        List<WhWmsSkuStockVO> whWmsSkuStockVOList = whWmsSkuStockService.getWmsSkuStockByCond(whWmsSkuStockVO);
        if(whWmsSkuStockVOList != null && whWmsSkuStockVOList.size() > 0){
            for(WhWmsSkuStockVO vo :whWmsSkuStockVOList){
                if(vo.getAmount() > 0){
                    WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
                    moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                    moveStockVO.setCreateUserId(operatorId);
                    moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
                    moveStockVO.setReferenceCode(whCommand.getReferenceCode());

                    WhWmsMoveSkuVO whWmsMoveSkuVO = new WhWmsMoveSkuVO();
                    whWmsMoveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                    whWmsMoveSkuVO.setSkuCode(vo.getSkuCode());
                    whWmsMoveSkuVO.setCreateTime(Calendar.getInstance().getTime());
                    whWmsMoveSkuVO.setCreateUserId(operatorId.toString());
                    whWmsMoveSkuVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
                    whWmsMoveSkuVO.setAmount(1);
                    whWmsMoveSkuVO.setBarCode(vo.getBarCode());
                    whWmsMoveSkuVO.setOriginalHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_ACTIVE);
                    whWmsMoveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                    whWmsMoveSkuVO.setTargetHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_DIFF);
                    whWmsMoveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                    whWmsMoveSkuVO.setSkuStatus(vo.getSkuStatus());
                    List<WhWmsMoveSkuVO> moveSkuList = new ArrayList<>();
                    moveSkuList.add(whWmsMoveSkuVO);
                    //调用移库接口
                    moveStockVO.setMoveSkuList(moveSkuList);
                    whWmsMoveStockService.newMoveStock(moveStockVO);
                    whWmsMoveStockService.doMoveStockAndReleaseOccupyAndFinish(moveStockVO.getCode(),operatorId);
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public Boolean cancel(String commandCode,Long operatorId,List<WhWmsCommandCheckVO> vos) {
        if(EmptyUtil.isEmpty(commandCode)){
            throw new WarehouseException(WarehouseExceptionErrorCode.ILLEGAL_PARAM);
        }
        WhCommand whCommand = whCommandService.findCommandByCode(commandCode, false);
        if(!whCommand.getCommandStatus().equals(WhCommand.STATUS_PACKING)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"出库指令必须是待包装状态");
        }
        WhWmsCommandConnectVO commandConnectVO = whWmsCommandConnectService.findNotCanceledByWhCommandCode(whCommand.getCode());
        if(commandConnectVO==null){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"该出库指令没有关联波次");
        }
        WhWmsConnectInfoVO connectVO = whWmsConnectInfoService.findById(commandConnectVO.getConnectId());
        if(!connectVO.getConnectStatus().equals(WMSConstants.ConnectStatus.FINISHED)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"波次必须是已完成状态");
        }
        //删除波次和cmd的关联
        commandConnectVO.setCancelFlag(PegasusConstants.YES);
        whWmsCommandConnectService.update(commandConnectVO);

        WhWmsConnectDistributionVO cond = new WhWmsConnectDistributionVO();
        cond.setConnectId(commandConnectVO.getConnectId());
        cond.setCommandCode(commandCode);
        List<WhWmsConnectDistributionVO> connectDistributionVOList = whWmsConnectDistributionService.findByCond(cond);

        /*//更新command状态,待包装到缺货中
        whCommandService.commandInPackingToShortages(commandConnectVO.getCommandCode());*/

        //更新command执行中,更新失败次数
        whCommand.setCommandStatus(WhCommand.STATUS_IN_PROCESSING);
        whCommand.setFailureStartConnect(whCommand.getFailureStartConnect()+1);
        whCommandService.updateCommand(whCommand);
        //删除预占记录key,否则无法重新占用
        whWmsCommandPreOccupyIdxMapper.batchDelete(Collections.singletonList(whCommand.getCode()));

        //删除分拨数据
        whWmsConnectDistributionService.deleteConnectDistribution(commandConnectVO.getConnectId(),commandConnectVO.getCommandCode());

        //检查有没有分拨包装区
        WhWmsHouseShelvesCond whWmsHouseShelvesCond = new WhWmsHouseShelvesCond();
        whWmsHouseShelvesCond.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        // 源库位
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_PACKING);// M区 分拨包装区
        List<WhWmsHouseShelvesVO> hsPacking = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(hsPacking) || hsPacking.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,分拨包装区["+whWmsHouseShelvesCond.getHouseType()+"],物理仓["+connectVO.getPhysicalWarehouseCode()+"]");
        }
        WhWmsHouseShelvesVO sourceShelvesVO = hsPacking.get(0);

        /*//推荐库位走上架推荐库位的逻辑
        List<WhWmsStartPutawayVO> pvoList = buildPutawayVOs(vos,connectVO,sourceShelvesVO);
        List<WhWmsMoveSkuVO> moveStockSkuList = whWmsWaitPutawayService.recommendWmsHouseShelves(pvoList);
        */

        // 目标库位
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_ACTIVE);// L区 活动区
        List<WhWmsHouseShelvesVO> targetActiveHouseShelves = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(targetActiveHouseShelves) || targetActiveHouseShelves.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,活动区["+whWmsHouseShelvesCond.getHouseType()+"],物理仓["+connectVO.getPhysicalWarehouseCode()+"]");
        }
        WhWmsHouseShelvesVO targetShelvesVO = targetActiveHouseShelves.get(0);
        List<WhWmsMoveSkuVO> moveStockSkuList = buildMoveStockSkuByCommandCheck(sourceShelvesVO,targetShelvesVO,vos,connectVO);
        if(CollectionUtils.isNotEmpty(moveStockSkuList)){
            //移库行不为空
            //创建移库单,分拨包装区到活动区
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(operatorId);
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            moveStockVO.setReferenceCode(whCommand.getReferenceCode());
            //调用移库接口
            moveStockVO.setMoveSkuList(moveStockSkuList);
            whWmsMoveStockService.newMoveStock(moveStockVO);
        }
        //差异库存 移至 差异区 移库单直接完成
        //检查有没有差异区
        whWmsHouseShelvesCond.setHouseType(WhWmsWarehouseAreaVO.HOUSE_TYPE_DIFF);//差异区
        List<WhWmsHouseShelvesVO> diffShelves = whWmsHouseShelvesService.getHouseShelvesByCond(whWmsHouseShelvesCond);
        if(CollectionUtils.isEmpty(diffShelves) || diffShelves.size()>1){
            throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,"没有合适的目标库位,差异区");
        }
        WhWmsHouseShelvesVO diffShelve = diffShelves.get(0);
        Map<String,Map<String,Integer>> diffSkuMap = computeDiffStock(connectDistributionVOList,vos);
        WhWmsMoveStockVO whWmsMoveStockVO = moveDiffStockThenFinish(connectVO,whCommand,operatorId,sourceShelvesVO,diffShelve,diffSkuMap);
        whWmsMoveStockService.createMoveStockThenFinish(whWmsMoveStockVO);
        return true;
    }

    private WhWmsMoveStockVO moveDiffStockThenFinish(WhWmsConnectInfoVO connectVO,WhCommand whCommand,Long operatorId
            ,WhWmsHouseShelvesVO sourceShelvesVO,WhWmsHouseShelvesVO diffShelve,Map<String,Map<String,Integer>> diffSkuMap){
        if(EmptyUtil.isEmpty(diffSkuMap)){
            return null;
        }
        List<WhWmsMoveSkuVO> moveStockSkuList = new ArrayList<>();
        for(Map.Entry<String,Map<String,Integer>> entry : diffSkuMap.entrySet()){
            String skuCode = entry.getKey();
            for(Map.Entry<String,Integer> barcodeEntry : entry.getValue().entrySet()){
                String barCode = barcodeEntry.getKey();
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
                moveSkuVO.setSkuCode(skuCode);
                moveSkuVO.setSkuStatus(connectVO.getSkuStatus());
                moveSkuVO.setBarCode(barCode);
                moveSkuVO.setOriginalHouseType(sourceShelvesVO.getHouseType());
                moveSkuVO.setOriginalShelvesCode(sourceShelvesVO.getCode());
                moveSkuVO.setTargetHouseType(diffShelve.getHouseType());
                moveSkuVO.setTargetShelvesCode(diffShelve.getCode());
                moveSkuVO.setAmount(barcodeEntry.getValue());
                moveStockSkuList.add(moveSkuVO);
            }
        }
        if(EmptyUtil.isNotEmpty(moveStockSkuList)){
            WhWmsMoveStockVO moveStockVO = new WhWmsMoveStockVO();
            moveStockVO.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
            moveStockVO.setCreateUserId(operatorId);
            moveStockVO.setMoveType(WhWmsMoveStockVO.MOVE_TYPE_COMMON);
            moveStockVO.setReferenceCode(whCommand.getReferenceCode());
            //调用移库接口
            moveStockVO.setMoveSkuList(moveStockSkuList);
            return moveStockVO;
        }
        return null;
    }

    private Map<String,Map<String,Integer>> computePickSkuDiffStock(List<WhWmsConnectPickSkuVO> connectPickSkuVOs
            ,List<WhWmsCommandCheckVO> commandCheckVOList){
        Map<String,Map<String,Integer>> diffStockMap = new HashMap<>();//{skucode->{barcode->distributeAmount},..}
        if(EmptyUtil.isEmpty(connectPickSkuVOs)){
            return diffStockMap;
        }
        Map<String,Integer> pickSkuMap = new HashMap<>();//{barcode->distributeAmount,..}
        Map<String,Set<String>> skuBarCodeMap = new HashMap<>();//{skuCode->[barcode,..],..}
        for(WhWmsConnectPickSkuVO pickSkuVO : connectPickSkuVOs){
            if(EmptyUtil.isEmpty(pickSkuVO.getBarCode())){
                pickSkuVO.setBarCode(pickSkuVO.getSkuCode()+"_0001");
            }
            String key = pickSkuVO.getBarCode();
            Set<String> barCodeSets = skuBarCodeMap.get(pickSkuVO.getSkuCode());
            if(NullUtil.isNull(barCodeSets)){
                barCodeSets = new TreeSet<>();
                skuBarCodeMap.put(pickSkuVO.getSkuCode(),barCodeSets);
            }
            barCodeSets.add(pickSkuVO.getBarCode());
            Integer pickSkuAmount = pickSkuMap.get(key);
            if(NullUtil.isNull(pickSkuAmount)){
                pickSkuAmount = 0;
            }
            pickSkuMap.put(key,pickSkuAmount+pickSkuVO.getNeedAmount());
        }
        if(EmptyUtil.isNotEmpty(commandCheckVOList)){
            for(WhWmsCommandCheckVO commandCheckVO : commandCheckVOList){
                String skuCode = commandCheckVO.getSkuCode();
                Set<String> barCodes = skuBarCodeMap.get(skuCode);
                if(EmptyUtil.isEmpty(barCodes)){
                    throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,String.format("[%s]无拣货数据",skuCode));
                }
                Integer pickSkuAmount = pickSkuMap.get(commandCheckVO.getBarCode());
                Integer checkAmount = commandCheckVO.getCheckAmount();
                if(NullUtil.isNull(pickSkuAmount)){
                    pickSkuAmount = 0;
                }
                if(pickSkuAmount >= checkAmount){
                    pickSkuMap.put(commandCheckVO.getBarCode(),pickSkuAmount-checkAmount);
                    checkAmount = 0;
                }else{
                    if(pickSkuAmount > 0){
                        pickSkuMap.put(commandCheckVO.getBarCode(),0);
                        checkAmount -= pickSkuAmount;
                    }
                }
                if(checkAmount>0){
                    //批次不在拣货数据中，或者批次数量不足,则从拣货数据中减去其他批次数量
                    for(String barCode : barCodes){
                        pickSkuAmount = pickSkuMap.get(barCode);
                        if(pickSkuAmount >= checkAmount){
                            pickSkuMap.put(barCode,pickSkuAmount-checkAmount);
                            checkAmount = 0;
                            break;
                        }else{
                            checkAmount -= pickSkuAmount;
                            pickSkuMap.put(barCode,0);
                        }
                    }
                    if(checkAmount > 0){
                        throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,String.format("[%s]验货数量有误",skuCode));
                    }
                }
            }
        }
        for(Map.Entry<String,Set<String>> skuBarCodeEntry : skuBarCodeMap.entrySet()){
            String skuCode = skuBarCodeEntry.getKey();
            for(String barCode : skuBarCodeEntry.getValue()){
                Integer diffAmount = pickSkuMap.get(barCode);
                if(NumberUtil.isNullOrZero(diffAmount)){
                    continue;
                }
                Map<String,Integer> barCodeMap = diffStockMap.get(skuCode);
                if(NullUtil.isNull(barCodeMap)){
                    barCodeMap = new HashMap<>();
                    diffStockMap.put(skuCode,barCodeMap);
                }
                barCodeMap.put(barCode,diffAmount);
            }
        }
        return diffStockMap;
    }

    //计算差异数据
    private Map<String,Map<String,Integer>> computeDiffStock(List<WhWmsConnectDistributionVO> commandDistributionVOList
            ,List<WhWmsCommandCheckVO> commandCheckVOList){
        Map<String,Map<String,Integer>> diffStockMap = new HashMap<>();//{skucode->{barcode->distributeAmount},..}
        if(EmptyUtil.isEmpty(commandDistributionVOList)){
            return diffStockMap;
        }
        Map<String,Integer> distributeSkuMap = new HashMap<>();//{barcode->distributeAmount,..}
        Map<String,Set<String>> skuBarCodeMap = new HashMap<>();//{skuCode->[barcode,..],..}
        for(WhWmsConnectDistributionVO distributionVO : commandDistributionVOList){
            if(EmptyUtil.isEmpty(distributionVO.getBarCode())){
                distributionVO.setBarCode(distributionVO.getSkuCode()+"_0001");
            }
            String key = distributionVO.getBarCode();
            Set<String> barCodeSets = skuBarCodeMap.get(distributionVO.getSkuCode());
            if(NullUtil.isNull(barCodeSets)){
                barCodeSets = new TreeSet<>();
                skuBarCodeMap.put(distributionVO.getSkuCode(),barCodeSets);
            }
            barCodeSets.add(distributionVO.getBarCode());
            Integer distributeAmount = distributeSkuMap.get(key);
            if(NullUtil.isNull(distributeAmount)){
                distributeAmount = 0;
            }
            distributeSkuMap.put(key,distributeAmount+distributionVO.getDistributAmount());
        }
        if(EmptyUtil.isNotEmpty(commandCheckVOList)){
            for(WhWmsCommandCheckVO commandCheckVO : commandCheckVOList){
                String skuCode = commandCheckVO.getSkuCode();
                Set<String> barCodes = skuBarCodeMap.get(skuCode);
                if(EmptyUtil.isEmpty(barCodes)){
                    throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,String.format("[%s]无分拨数据",skuCode));
                }
                Integer distributeAmount = distributeSkuMap.get(commandCheckVO.getBarCode());
                Integer checkAmount = commandCheckVO.getCheckAmount();
                if(NullUtil.isNull(distributeAmount)){
                    distributeAmount = 0;
                }
                if(distributeAmount >= checkAmount){
                    distributeSkuMap.put(commandCheckVO.getBarCode(),distributeAmount-checkAmount);
                    checkAmount = 0;
                }else{
                    if(distributeAmount > 0){
                        distributeSkuMap.put(commandCheckVO.getBarCode(),0);
                        checkAmount -= distributeAmount;
                    }
                }
                if(checkAmount>0){
                    //批次不在分拨数据中，或者批次数量不足,则从分拨数据中减去其他批次数量
                    for(String barCode : barCodes){
                        distributeAmount = distributeSkuMap.get(barCode);
                        if(distributeAmount >= checkAmount){
                            distributeSkuMap.put(barCode,distributeAmount-checkAmount);
                            checkAmount = 0;
                            break;
                        }else{
                            checkAmount -= distributeAmount;
                            distributeSkuMap.put(barCode,0);
                        }
                    }
                    if(checkAmount > 0){
                        throw new WarehouseException(WmsExceptionErrorCode.NOT_FOUND_SHELVES,String.format("[%s]验货数量有误",skuCode));
                    }
                }
            }
        }
        for(Map.Entry<String,Set<String>> skuBarCodeEntry : skuBarCodeMap.entrySet()){
            String skuCode = skuBarCodeEntry.getKey();
            for(String barCode : skuBarCodeEntry.getValue()){
                Integer diffAmount = distributeSkuMap.get(barCode);
                if(NumberUtil.isNullOrZero(diffAmount)){
                    continue;
                }
                Map<String,Integer> barCodeMap = diffStockMap.get(skuCode);
                if(NullUtil.isNull(barCodeMap)){
                    barCodeMap = new HashMap<>();
                    diffStockMap.put(skuCode,barCodeMap);
                }
                barCodeMap.put(barCode,diffAmount);
            }
        }
        return diffStockMap;
    }

    //组织上架数据
    private List<WhWmsStartPutawayVO> buildPutawayVOs(List<WhWmsCommandCheckVO> vos,WhWmsConnectInfoVO connectVO,WhWmsHouseShelvesVO sourceShelvesVO){
    	List<WhWmsStartPutawayVO> pvoList = new ArrayList<>();
    	if(EmptyUtil.isNotEmpty(vos)){
    		for(WhWmsCommandCheckVO checkVO : vos){
        		WhWmsStartPutawayVO pt = new WhWmsStartPutawayVO();
        		pt.setSourceShelvesVO(sourceShelvesVO);
        		pt.setPhysicalWarehouseCode(connectVO.getPhysicalWarehouseCode());
        		pt.setPutawayAmount(checkVO.getCheckAmount());
        		pt.setSkuCode(checkVO.getSkuCode());
        		pt.setBarCode(checkVO.getBarCode());
        		pt.setSkuStatus(connectVO.getSkuStatus());
        		pt.setReceiveAmount(checkVO.getCheckAmount());
        		pt.setStorageType(checkVO.getStorageType());
        		pvoList.add(pt);
        	}
    	}
    	return pvoList;
    }

    private List<WhWmsMoveSkuVO> buildMoveStockSkuByCommandCheck(WhWmsHouseShelvesVO oriShelves,
                                                                 WhWmsHouseShelvesVO tarShelves,
                                                                 List<WhWmsCommandCheckVO> vos,
                                                                 WhWmsConnectInfoVO connectVO){
        List<WhWmsMoveSkuVO> moveSkuList = new ArrayList<>();
        if(EmptyUtil.isNotEmpty(vos)){
            for(WhWmsCommandCheckVO commandCheckVO : vos){
                WhWmsMoveSkuVO moveSkuVO = new WhWmsMoveSkuVO();
                moveSkuVO.setSkuCode(commandCheckVO.getSkuCode());
                moveSkuVO.setSkuStatus(connectVO.getSkuStatus());
                moveSkuVO.setBarCode(commandCheckVO.getBarCode());
                moveSkuVO.setPhysicalWarehouseCode(oriShelves.getPhysicalWarehouseCode());
                moveSkuVO.setOriginalShelvesCode(oriShelves.getCode());
                moveSkuVO.setOriginalHouseType(oriShelves.getHouseType());
                moveSkuVO.setTargetShelvesCode(tarShelves.getCode());
                moveSkuVO.setTargetHouseType(tarShelves.getHouseType());
                moveSkuVO.setAmount(commandCheckVO.getCheckAmount());
                moveSkuList.add(moveSkuVO);
            }
        }
        if(EmptyUtil.isNotEmpty(moveSkuList)){
            return moveSkuList;
        }
        return null;
    }
    

    @Override
    public Boolean reject(String commandCode, Long operatorId) {
        if(cancel(commandCode,operatorId,null)){
            //whCommandService.cancelCommandByCode(commandCode);
            return true;
        }
        return false;
    }


    private WhWmsCommandCheckVO create(WhWmsCommandCheckVO vo) {
        WhWmsCommandCheck whWmsCommandCheck = BeanUtil.buildFrom(vo, WhWmsCommandCheck.class);
        mapper.insert(whWmsCommandCheck);
        vo.setId(whWmsCommandCheck.getId());
        return vo;
    }


    private void batchCreateCommandCheck(List<WhWmsCommandCheckVO> vos){
        if(EmptyUtil.isEmpty(vos)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"验货数据异常");
        }
        int size = vos.size();
        boolean result = mapper.batchInsert(vos)==size;
        if(!result){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"验货数据插入异常");
        }
    }

    @Override
    public Boolean update(WhWmsCommandCheckVO vo) {
        return mapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(vo,WhWmsCommandCheck.class))!=0;
    }

    @Override
    public boolean deleteById(Long id) {
        return mapper.deleteByPrimaryKey(id)!=0;
    }

    @Override
    public WhWmsCommandCheckVO findById(Long id) {
        WhWmsCommandCheck whWmsConnectDistribution = mapper.selectByPrimaryKey(id);
        if(whWmsConnectDistribution!=null){
            return BeanUtil.buildFrom(whWmsConnectDistribution,WhWmsCommandCheckVO.class);
        }
        return null;
    }

    @Override
    public List<WhWmsCommandCheckVO> findByCond(WhWmsCommandCheckVO cond) {
        WhWmsCommandCheckExample example = new WhWmsCommandCheckExample();
        WhWmsCommandCheckExample.Criteria criteria = example.createCriteria();

        if(cond.getCommandCode()!=null){
            criteria.andCommandCodeEqualTo(cond.getCommandCode());
        }
        if(cond.getSkuStatus()!=null){
            criteria.andSkuStatusEqualTo(cond.getSkuStatus());
        }
        if(cond.getSkuCode()!=null){
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }
        if(cond.getBarCode()!=null){
            criteria.andBarCodeEqualTo(cond.getBarCode());
        }
        if(cond.getIsMaterial()!=null){
            criteria.andIsMaterialEqualTo(cond.getIsMaterial());
        }
        if(cond.getCancelFlag()!=null){
            criteria.andCancelFlagEqualTo(cond.getCancelFlag());
        }

        List<WhWmsCommandCheck> whWmsCommandChecks = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(whWmsCommandChecks)) {
            return Collections.emptyList();
        }
        List<WhWmsCommandCheckVO> vos = new ArrayList<WhWmsCommandCheckVO>(whWmsCommandChecks.size());
        for (WhWmsCommandCheck whWmsCommandCheck : whWmsCommandChecks) {
            WhWmsCommandCheckVO whWmsCommandCheckVO = BeanUtil.buildFrom(whWmsCommandCheck, WhWmsCommandCheckVO.class);
            vos.add(whWmsCommandCheckVO);
        }
        return vos;
    }

    @Override
    public boolean checkGiftCardCanBindByCardNo(String cardNo) {
        WhWmsCheckGiftCardExample example = new WhWmsCheckGiftCardExample();
        example.createCriteria().andCardNoEqualTo(cardNo)
                .andStatusEqualTo(WhWmsCheckGiftCardVO.STATUS_BOUND);
        List<WhWmsCheckGiftCard> boundGiftCardList = whWmsCheckGiftCardMapper.selectByExample(example);
        return EmptyUtil.isEmpty(boundGiftCardList);
    }

    @Override
    @Transactional
    public boolean unBoundCheckGiftCard(String packageCode){
        WhWmsCheckGiftCard update = new WhWmsCheckGiftCard();
        update.setStatus(WhWmsCheckGiftCardVO.STATUS_UNBOUND);
        WhWmsCheckGiftCardExample example = new WhWmsCheckGiftCardExample();
        example.createCriteria().andPackageCodeEqualTo(packageCode)
                .andStatusEqualTo(WhWmsCheckGiftCardVO.STATUS_BOUND);
        whWmsCheckGiftCardMapper.updateByExampleSelective(update,example);
        return true;
    }

    private boolean batchInserCheckGiftCard(List<WhWmsCheckGiftCardVO> checkGiftCardList){
        if(EmptyUtil.isNotEmpty(checkGiftCardList)){
            whWmsCheckGiftCardMapper.batchInsert(checkGiftCardList);
        }
        return true;
    }

    private Boolean isEbillMode(Integer expressType) {
        //顺丰空运陆运
        if(expressType.equals(WMSConstants.ExpressType.SF_LAND)
                ||expressType.equals(WMSConstants.ExpressType.SF_AIR)
                ||expressType.equals(WMSConstants.ExpressType.SF_COLD_CHAIN)){
            CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("system.express.sf.isEBill");
            return config!=null&&config.getConfigValue().equals("1")?true:false;
        }
        //联邦
        if(expressType.equals(WMSConstants.ExpressType.FEDEX)){
            CommGlobalConfig config = PegasusUtilFacade.getInstance().findConfigByKey("system.express.fed.isEBill");
            return config!=null&&config.getConfigValue().equals("1")?true:false;
        }else{
            return false;
        }
    }

}
