package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.thebeastshop.pegasus.service.warehouse.WMSConstants;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWarehouseGroupCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhPhysicalWarehouseRelateWarehouseMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhWarehouseGroupMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseRelateWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhPhysicalWarehouseRelateWarehouseExample;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouse;
import com.thebeastshop.pegasus.service.warehouse.model.WhWarehouseGroupExample;
import com.thebeastshop.pegasus.service.warehouse.service.WhInfoService;
import com.thebeastshop.pegasus.service.warehouse.service.WhWarehouseGroupService;
import com.thebeastshop.pegasus.service.warehouse.vo.WhPhysicalWarehouseVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseGroupVO;
import com.thebeastshop.pegasus.service.warehouse.vo.WhWarehouseVO;
import com.thebeastshop.pegasus.util.comm.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * Created by Administrator on 2017/12/5.
 */
@Service("whWarehouseGroupService")
public class WhWarehouseGroupServiceImpl implements WhWarehouseGroupService {

    @Autowired
    private WhWarehouseGroupMapper whWarehouseGroupMapper;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhPhysicalWarehouseRelateWarehouseMapper whPhysicalWarehouseRelateWarehouseMapper;

    @Override
    public List<WhWarehouseGroupVO> findByCond(WhWarehouseGroupCond cond, boolean cascade) {
        List<WhWarehouseGroupVO> groupList = whWarehouseGroupMapper.findByCond(cond);
        if(cascade){
            fullWarehouseGroup(groupList);
        }
        return groupList;
    }

    @Override
    public WhWarehouseGroupVO findWarehouseGroupByWhCode(String warehouseCode, boolean cascade) {
        if(EmptyUtil.isNotEmpty(warehouseCode)){
            WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
            cond.setRelateWhCodes(Collections.singletonList(warehouseCode));
            List<WhWarehouseGroupVO> list = findByCond(cond,cascade);
            if(EmptyUtil.isNotEmpty(list)){
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public WhWarehouseGroupVO findWarehouseGroupByPhyWhCode(String phyWhCode, boolean cascade) {
        if(EmptyUtil.isNotEmpty(phyWhCode)){
            WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
            cond.setRelatePhyWhCodes(Collections.singletonList(phyWhCode));
            List<WhWarehouseGroupVO> list = findByCond(cond,cascade);
            if(EmptyUtil.isNotEmpty(list)){
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public List<WhWarehouseGroupVO> findWarehouseGroupByWhCodes(WhWarehouseGroupCond cond) {
        return whWarehouseGroupMapper.findWarehouseGroupByWhCodes(cond);
    }

    @Override
    public List<WhWarehouseGroupVO> findByCodeOrName(String codeOrName) {
        return whWarehouseGroupMapper.findByCodeOrName(codeOrName);
    }

    @Override
    public Pagination<WhWarehouseGroupVO> findByCondPage(WhWarehouseGroupCond cond) {
        Pagination<WhWarehouseGroupVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = whWarehouseGroupMapper.countByCond(cond);
        page.setRecord(count);
        if(!NumberUtil.isNullOrZero(count)){
            List<WhWarehouseGroupVO> groupList = findByCond(cond,false);
            page.setResultList(groupList);
        }
        return page;
    }

    @Override
    public Map<Long, WhWarehouseGroupVO> findAllMap(boolean cascade) {
        Map<Long,WhWarehouseGroupVO> map = new HashMap<>();
        List<WhWarehouseGroupVO> list = findAll(cascade);
        if(EmptyUtil.isNotEmpty(list)){
            for(WhWarehouseGroupVO group : list){
                map.put(group.getId(),group);
            }
        }
        return map;
    }

    @Override
    public Map<String, WhWarehouseGroupVO> findWhGroupMap(List<String> relateWarehouseCodes) {
        Map<String,WhWarehouseGroupVO> whGroupMap = new HashMap<>();
        if(EmptyUtil.isEmpty(relateWarehouseCodes)){
            return whGroupMap;
        }
        WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
        cond.setRelateWhCodes(relateWarehouseCodes);
        List<WhWarehouseGroupVO> groupList = findByCond(cond,true);
        if(EmptyUtil.isNotEmpty(groupList)){
            for(WhWarehouseGroupVO group : groupList){
                if(EmptyUtil.isNotEmpty(group.getRelateWarehouses())){
                    for(WhWarehouseVO wh : group.getRelateWarehouses()){
                        whGroupMap.put(wh.getCode(),group);
                    }
                }
            }
        }
        return whGroupMap;
    }

    @Override
    public List<WhWarehouseGroupVO> findAll(boolean cascade) {
        WhWarehouseGroupCond cond = new WhWarehouseGroupCond();
        return findByCond(cond,cascade);
    }

    @Override
    public WhWarehouseGroupVO findById(Long id, boolean cascade) {
        WhWarehouseGroupVO group = whWarehouseGroupMapper.findById(id);
        if(NullUtil.isNotNull(group) && cascade){
            fullWarehouseGroup(Collections.singletonList(group));
        }
        return group;
    }

    @Override
    public List<WhWarehouseGroupVO> findByIds(List<Long> ids) {
        WhWarehouseGroupExample example = new WhWarehouseGroupExample();
        example.createCriteria().andIdIn(ids);
        return BeanUtil.buildListFrom(whWarehouseGroupMapper.selectByExample(example), WhWarehouseGroupVO.class);
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(WhWarehouseGroupVO groupVO) {
        warehouseGroupRebuildeAndCheck(groupVO);
        if(NullUtil.isNotNull(groupVO.getId())){
            return update(groupVO);
        }
        return save(groupVO);
    }

    private boolean save(WhWarehouseGroupVO group){
        group.setCreateTime(DateUtil.getNow());
        whWarehouseGroupMapper.insert(group);
        group.setCode(buildWarehouseGoupCode(group.getId()));
        whWarehouseGroupMapper.updateByPrimaryKeySelective(group);
        //关联逻辑仓
        warehouseRelateWarehouseGroup(group);
        //关联物理仓
        physicalWarehouseRelateWarehouseGroup(group);
        //物理仓默认出入库逻辑仓
        phyWhRelateInOutWh(group.getRelatePhysicalWarehouses());
        return true;
    }

    private String buildWarehouseGoupCode(Long id){
        String code = id.toString();
        for(int i = code.length(); i<=3 ;i++){
            code = "0"+code;
        }
        return "WG"+code;
    }

    private boolean update(WhWarehouseGroupVO group){
        //清除物理仓默认出入库逻辑仓
        List<WhPhysicalWarehouseVO> oldPhyWhList = whInfoService.findPhysicalWarehouseByGroupId(Collections.singletonList(group.getId()));
        List<String> oldPhyWhCodes = new ArrayList<>();
        for(WhPhysicalWarehouseVO phyWh : oldPhyWhList){
            oldPhyWhCodes.add(phyWh.getCode());
        }
        phyWhRelieveInOutWh(oldPhyWhCodes);
        //清除物理仓默认出入库逻辑仓
        whInfoService.physicalWarehouseRelieveWarehouseGroup(group.getId());
        //更新分组
        whWarehouseGroupMapper.updateByPrimaryKeySelective(group);
        //清除关联逻辑仓
        whInfoService.warehouseRelieveWarehouseGroup(group.getId());
        //清除关联物理仓
        whInfoService.physicalWarehouseRelieveWarehouseGroup(group.getId());
        //关联逻辑仓
        warehouseRelateWarehouseGroup(group);
        //关联物理仓
        physicalWarehouseRelateWarehouseGroup(group);
        //物理仓默认出入库逻辑仓
        phyWhRelateInOutWh(group.getRelatePhysicalWarehouses());
        return true;
    }

    private boolean phyWhRelateInOutWh(List<WhPhysicalWarehouseVO> physicalWarehouses){
        List<WhPhysicalWarehouseRelateWarehouse> relateList = new ArrayList<>();
        for(WhPhysicalWarehouseVO physicalWarehouse : physicalWarehouses){
            for(WhWarehouseVO relateWh : physicalWarehouse.getRelateInOutWarehouses()){
                WhPhysicalWarehouseRelateWarehouse relate = new WhPhysicalWarehouseRelateWarehouse();
                relate.setSkuStatus(relateWh.getRelateInOutSkuStatus());
                relate.setType(relateWh.getRelateInOrOut());
                relate.setPhysicalWarehouseCode(physicalWarehouse.getCode());
                relate.setWarehouseCode(relateWh.getCode());
                relateList.add(relate);
            }
        }
        whPhysicalWarehouseRelateWarehouseMapper.batchInsert(relateList);
        return true;
    }

    private boolean phyWhRelieveInOutWh(List<String> phyWhCodes){
        WhPhysicalWarehouseRelateWarehouseExample example = new WhPhysicalWarehouseRelateWarehouseExample();
        example.createCriteria().andPhysicalWarehouseCodeIn(phyWhCodes);
        whPhysicalWarehouseRelateWarehouseMapper.deleteByExample(example);
        return true;
    }

    private void warehouseRelateWarehouseGroup(WhWarehouseGroupVO group){
        if(EmptyUtil.isNotEmpty(group.getRelateWarehouses())){
            List<String> warehouseCodes = new ArrayList<>();
            for(WhWarehouseVO warehouse : group.getRelateWarehouses()){
                warehouseCodes.add(warehouse.getCode());
            }
            boolean relateReslut = whInfoService.warehouseRelateWarehouseGroup(warehouseCodes,group.getId());
            if(!relateReslut){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"存在逻辑仓已关联其它逻辑仓分组");
            }
        }
    }

    private void physicalWarehouseRelateWarehouseGroup(WhWarehouseGroupVO group){
        if(EmptyUtil.isNotEmpty(group.getRelatePhysicalWarehouses())){
            List<String> physicalWarehouseCodes = new ArrayList<>();
            for(WhPhysicalWarehouseVO physicalWarehouse : group.getRelatePhysicalWarehouses()){
                physicalWarehouseCodes.add(physicalWarehouse.getCode());
            }
            boolean relateReslut = whInfoService.physicalWarehouseRelateWarehouseGroup(physicalWarehouseCodes,group.getId());
            if(!relateReslut){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"存在物理仓已关联其它逻辑仓分组");
            }
        }
    }

    private void warehouseGroupRebuildeAndCheck(WhWarehouseGroupVO group){
        if(EmptyUtil.isEmpty(group.getRelatePhysicalWarehouses())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"逻辑仓组必须至少关联一个物理仓");
        }
        if(EmptyUtil.isEmpty(group.getRelateWarehouses())){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"逻辑仓组必须至少包含一个逻辑");
        }
        List<String> relateWhCodes = new ArrayList<>();
        for(WhWarehouseVO whWarehouse : group.getRelateWarehouses()){
            relateWhCodes.add(whWarehouse.getCode());
        }
        List<WhWarehouse> whList = whInfoService.findWarehouseByCodes(relateWhCodes);
        Set<Integer> whCommodityStatusSet = new HashSet<>();
        for(WhWarehouse warehouse : whList){
            whCommodityStatusSet.add(warehouse.getCommodityStatus());
        }
        if(!whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"缺少良品逻辑仓");
        }
        if(!whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED)
                && !whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED)
                && !whCommodityStatusSet.contains(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"缺少残次逻辑仓");
        }
//        if(!whCommodityStatusSet.contains(WMSConstants.WMS_SKU_STATUS_SAMPLE)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"缺少样品逻辑仓");
//        }
//        if(!whCommodityStatusSet.contains(WMSConstants.WMS_SKU_STATUS_WASTE)){
//            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,"缺少废品逻辑仓");
//        }
        List<String> relateWarehouseCodes = new ArrayList<>();
        for(WhWarehouseVO warehouse : group.getRelateWarehouses()){
            relateWarehouseCodes.add(warehouse.getCode());
        }
        WhWarehouseVO wh = null;
        WhWarehouseVO reWh = null;
        for(WhPhysicalWarehouseVO phyWh : group.getRelatePhysicalWarehouses()){
            List<WhWarehouseVO> relateWh = phyWh.getRelateInOutWarehouses();
            if(EmptyUtil.isEmpty(phyWh.getRelateInOutWarehouses())){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s未设置默认出入库逻辑仓]",phyWh.getCode()));
            }
            Map<String,WhWarehouseVO> inOutWarehouseMap = new HashMap<>();
            String key = null,keyOut = null;
            for(WhWarehouseVO relateWarehouse : phyWh.getRelateInOutWarehouses()){
                if(!relateWarehouseCodes.contains(relateWarehouse.getCode())){
                    throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                            ,String.format("当前逻辑仓分组无逻辑仓[%s]",relateWarehouse.getCode()));
                }
                key = buildRelateWarehouseKey(relateWarehouse.getRelateInOutSkuStatus(),relateWarehouse.getRelateInOrOut());
                inOutWarehouseMap.put(key,relateWarehouse);
            }
            //良品入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,WhWarehouseVO.RELATE_IN);
            if(NullUtil.isNull(inOutWarehouseMap.get(key))){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s未设置默认良品入库逻辑仓]",phyWh.getCode()));
            }
            //良品出库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_NONDEFECTIVE,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(key))){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s未设置默认良品出库逻辑仓]",phyWh.getCode()));
            }
            //轻残次入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
            if(NullUtil.isNull(wh)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s未设置默认轻残品入库逻辑仓]",phyWh.getCode()));
            }
            //轻残次出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MILD_DAMAGED,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            //中残次入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
            if(NullUtil.isNull(wh)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s未设置默认中残品入库逻辑仓]",phyWh.getCode()));
            }
            //中残次出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_MODERATE_DAMAGED,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            //重残入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
            if(NullUtil.isNull(wh)){
                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
                        ,String.format("[%s未设置默认重残品入库逻辑仓]",phyWh.getCode()));
            }
            //重残出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SEVERE_DAMAGED,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                relateWh.add(reWh);
            }
            //样品入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
//            if(NullUtil.isNull(wh)){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
//                        ,String.format("[%s未设置默认样品入库逻辑仓]",phyWh.getCode()));
//            }
            //添加样品出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_SAMPLE,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                if(NullUtil.isNotNull(reWh)){
                    reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                    relateWh.add(reWh);
                }
            }
            //陈列品入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
//            if(NullUtil.isNull(wh)){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
//                        ,String.format("[%s未设置默认样品入库逻辑仓]",phyWh.getCode()));
//            }
            //添加陈列品出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_DISPLAY,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                if(NullUtil.isNotNull(reWh)){
                    reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                    relateWh.add(reWh);
                }
            }
            //道具入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
            //添加陈道具出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_PROP,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                if(NullUtil.isNotNull(reWh)){
                    reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                    relateWh.add(reWh);
                }
            }
            //废品入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
//            if(NullUtil.isNull(wh)){
//                throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED
//                        ,String.format("[%s未设置默认废品入库逻辑仓]",phyWh.getCode()));
//            }
            //废品出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_WASTED,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                if(NullUtil.isNotNull(reWh)){
                    reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                    relateWh.add(reWh);
                }
            }

            //待定品入库
            key = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING,WhWarehouseVO.RELATE_IN);
            wh = inOutWarehouseMap.get(key);
            //待定品出库
            keyOut = buildRelateWarehouseKey(WhWarehouseVO.COMMODITY_STATUS_FOR_HOLD_PENDING,WhWarehouseVO.RELATE_OUT);
            if(NullUtil.isNull(inOutWarehouseMap.get(keyOut))){
                reWh = BeanUtil.buildFrom(wh,WhWarehouseVO.class);
                if(NullUtil.isNotNull(reWh)){
                    reWh.setRelateInOrOut(WhWarehouseVO.RELATE_OUT);
                    relateWh.add(reWh);
                }
            }
        }
    }

    private String buildRelateWarehouseKey(Integer skuStatus,Integer inOrOut){
        return skuStatus+"_"+inOrOut;
    }

    private void fullWarehouseGroup(List<WhWarehouseGroupVO> groupList){
        if(EmptyUtil.isEmpty(groupList)){
            return;
        }
        List<Long> groupIdList = new ArrayList<>();
        for(WhWarehouseGroupVO group : groupList){
            groupIdList.add(group.getId());
        }
        List<String> physicalWarehouseCodes = new ArrayList<>();
        Map<Long,List<WhPhysicalWarehouseVO>> physicalWarehouseMap = whInfoService.findPhysicalWarehouseMapByGroupId(groupIdList);
        for(List<WhPhysicalWarehouseVO> list : physicalWarehouseMap.values()){
            for(WhPhysicalWarehouseVO item : list){
                physicalWarehouseCodes.add(item.getCode());
            }
        }
        Map<String,WhWarehouseVO> whMap = new HashMap<>();
        Map<Long,List<WhWarehouseVO>> warehouseMap = whInfoService.findWarehouseMapByGroupId(groupIdList);
        for(List<WhWarehouseVO> list : warehouseMap.values()){
            for(WhWarehouseVO item : list){
                whMap.put(item.getCode(),item);
            }
        }
        Map<String,List<WhPhysicalWarehouseRelateWarehouse>> phyWhRelateWhMap = findPhyWhRelateWarehouseMap(physicalWarehouseCodes);
        for(WhWarehouseGroupVO group : groupList){
            if(physicalWarehouseMap.get(group.getId()) == null){
                continue;
            }
            List<WhPhysicalWarehouseVO> groupPhyWhList = physicalWarehouseMap.get(group.getId());
            //物理仓默认出入库逻辑仓
            for(WhPhysicalWarehouseVO item : groupPhyWhList){
                List<WhWarehouseVO> relateWhList = new ArrayList<>();
                List<WhPhysicalWarehouseRelateWarehouse> phyWhRelateWhList = phyWhRelateWhMap.get(item.getCode());
                if(EmptyUtil.isNotEmpty(phyWhRelateWhList)){
                    for(WhPhysicalWarehouseRelateWarehouse phyWhRelateWh : phyWhRelateWhList){
                        WhWarehouseVO whWarehouse = BeanUtil.buildFrom(whMap.get(phyWhRelateWh.getWarehouseCode()),WhWarehouseVO.class);
                        if (NullUtil.isNotNull(whWarehouse)){
                            whWarehouse.setRelateInOrOut(phyWhRelateWh.getType());
                            whWarehouse.setRelateInOutSkuStatus(phyWhRelateWh.getSkuStatus());
                            relateWhList.add(whWarehouse);
                        }
                    }
                }
                item.setRelateInOutWarehouses(relateWhList);
            }
            List<WhWarehouseVO> groupWhList = warehouseMap.get(group.getId());
            group.setRelatePhysicalWarehouses(groupPhyWhList);
            group.setRelateWarehouses(groupWhList);
        }
    }

    private Map<String,List<WhPhysicalWarehouseRelateWarehouse>> findPhyWhRelateWarehouseMap(List<String> phyWhCodes){
        WhPhysicalWarehouseRelateWarehouseExample example = new WhPhysicalWarehouseRelateWarehouseExample();
        example.createCriteria().andPhysicalWarehouseCodeIn(phyWhCodes);
        List<WhPhysicalWarehouseRelateWarehouse> list = whPhysicalWarehouseRelateWarehouseMapper.selectByExample(example);
        Map<String,List<WhPhysicalWarehouseRelateWarehouse>> map = new HashMap<>();
        if(EmptyUtil.isNotEmpty(list)){
            for(WhPhysicalWarehouseRelateWarehouse phyWhRelateWh : list){
                List<WhPhysicalWarehouseRelateWarehouse> tmpList = map.get(phyWhRelateWh.getPhysicalWarehouseCode());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(phyWhRelateWh.getPhysicalWarehouseCode(),tmpList);
                }
                tmpList.add(phyWhRelateWh);
            }
        }
        return map;
    }


}
