package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTlBuyerApplyCondVO;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyLineMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerApplyMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerPackageLineMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTlBuyerPackageMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import page.Pagination;

import java.util.*;

/**
 * @version V1.0
 * @Description:${todo}(用一句话描述该文件做什么)
 * @author: ljj
 * @date: 2018/10/19 11:26
 */
@Service("whTlBuyerPackageService")
public class WhTlBuyerPackageServiceImpl implements WhTlBuyerPackageService {

    @Autowired
    private WhBondedWarehouseAllotApplyService whBondedWarehouseAllotApplyService;
    @Autowired
    private WhTlBuyerPackageMapper whTlBuyerPackageMapper;
    @Autowired
    private WhTlBuyerPackageLineMapper whTlBuyerPackageLineMapper;
    @Autowired
    private WhTlBuyerApplyMapper whTlBuyerApplyMapper;
    @Autowired
    private WhInfoService whInfoService;
    @Autowired
    private WhAllotService whAllotService;
    @Autowired
    private WhCommandService whCommandService;
    @Autowired
    private WhInvService whInvService;

    @Autowired
    private McPcsBrandService brandService;

    @Override
    @Transactional
    public Integer batchCreatePackageOrder(List<Integer> applyIds, String name, Long operatorId) throws Exception {
//        1.根据勾选数据生成一张装箱单
        Map<String,WhTlBuyerPackageLine> skuWhTlBuyerPackageLineHashMap = new HashMap<>();
        List<WhTlBuyerApplyVO> list = whBondedWarehouseAllotApplyService.findByIds(applyIds);
        WhTlBuyerPackage whTlBuyerPackage = new WhTlBuyerPackage();
        whTlBuyerPackage.setName(name);
        whTlBuyerPackage.setStatus(WhTlBuyerPackage.STATUS_WAITING_DELIVERY);
        whTlBuyerPackage.setCreateOperatorId(operatorId.intValue());
        whTlBuyerPackage.setCreateTime(new Date());
        whTlBuyerPackageMapper.insert(whTlBuyerPackage);
        final Map<String, Object> params = new HashMap<String, Object>();
        params.put("createTime", DateUtil.getNow());
        params.put("id", whTlBuyerPackage.getId());
        String code = CodeGenerator.getInstance().generate("WH_BONDED_WAREHOUSE_PACKAGE_CODE", params);
        List<WhTlBuyerPackageLine> allApplyLineList = Lists.newArrayList();
        for (WhTlBuyerApplyVO whTlBuyerApplyVO : list) {
            for (WhTlBuyerApplyLine applyLine : whTlBuyerApplyVO.getWhTlBuyerApplyLines()) {
                //根据sku汇总applyline中的数据
                if (null == skuWhTlBuyerPackageLineHashMap.get(applyLine.getSkuCode())) {
                    WhTlBuyerPackageLine whTlBuyerPackageLine = new WhTlBuyerPackageLine();
                    whTlBuyerPackageLine.setBuyerPackageId(whTlBuyerPackage.getId());
                    whTlBuyerPackageLine.setSkuCode(applyLine.getSkuCode());
                    whTlBuyerPackageLine.setSkuName(applyLine.getSkuName());
                    whTlBuyerPackageLine.setBrandId(applyLine.getBrandId());
                    whTlBuyerPackageLine.setEbayItemCode(applyLine.getItemNumber());
                    whTlBuyerPackageLine.setBarcode(applyLine.getSupplierBarCode());
                    whTlBuyerPackageLine.setQuality(applyLine.getApprovedQuality());
                    PcsBrandVO pcsBrandVO = brandService.findById(applyLine.getBrandId());
                    whTlBuyerPackageLine.setBrandName(pcsBrandVO.getNameCn());
                    skuWhTlBuyerPackageLineHashMap.put(whTlBuyerPackageLine.getSkuCode(),whTlBuyerPackageLine);
                } else {
                    WhTlBuyerPackageLine whTlBuyerPackageLine = skuWhTlBuyerPackageLineHashMap.get(applyLine.getSkuCode());
                    whTlBuyerPackageLine.setQuality(whTlBuyerPackageLine.getQuality()+applyLine.getApprovedQuality());
                    skuWhTlBuyerPackageLineHashMap.put(applyLine.getSkuCode(),whTlBuyerPackageLine);
                }
            }
        }
        for (Map.Entry<String, WhTlBuyerPackageLine> entry : skuWhTlBuyerPackageLineHashMap.entrySet()) {
            allApplyLineList.add(entry.getValue());
        }

        whTlBuyerPackageLineMapper.batchInsertRecord(allApplyLineList);
        //新加逻辑：释放申请单占用的库存
        List<WhReleaseOccupationVO> releaseOccupationVOList = buildReleaseOccupyVOList(list);
        whInvService.releaseOccupation(releaseOccupationVOList);
        Map<String,Map<String,Integer>> map = buildAllotMap(allApplyLineList);
        String allotCodes = createAllots(map,code,operatorId,list.get(0).getTargetWarehouseCode());
//        //完成调拨单出库操作
//        WhCommand rcd = new WhCommand();
//        rcd.setInOutType(WhCommand.TYPE_ALLOT_OCCUPY);
//        rcd.setReferenceCode(allotCodes);
//        whCommandService.finishCommand(rcd);
        whTlBuyerPackage.setCode(code);
        whTlBuyerPackage.setReferenceCode(allotCodes);
        whTlBuyerPackageMapper.updateByPrimaryKeySelective(whTlBuyerPackage);

        for (WhTlBuyerApplyVO whTlBuyerApplyVO : list) {
            WhTlBuyerApply whTlBuyerApply = new WhTlBuyerApply();
            whTlBuyerApply.setId(whTlBuyerApplyVO.getId());
            whTlBuyerApply.setStatus(WhTlBuyerApply.STATUS_WAITING_IN_WAREHOUSE);
            whBondedWarehouseAllotApplyService.updateApply(whTlBuyerApply);
        }
        whBondedWarehouseAllotApplyService.batchUpdate(applyIds,whTlBuyerPackage.getId());
        sendEmail(allApplyLineList,0);
        return whTlBuyerPackage.getId();
    }

    private Map<String,Map<String,Integer>> buildAllotMap (List<WhTlBuyerPackageLine> allApplyLineList) {
        Map<String,Map<String,Integer>> warehouseSkuQtyMap = new LinkedHashMap<>();
        warehouseSkuQtyMap.put(WhWarehouseVO.WAREHOUSE_WH020600010096,new HashMap<String, Integer>());
        warehouseSkuQtyMap.put(WhWarehouseVO.WAREHOUSE_WH020600010102,new HashMap<String, Integer>());
        Map<String,Integer> skuQtyMap = new HashMap<>();
        for (WhTlBuyerPackageLine whTlBuyerApplyLine : allApplyLineList) {
            if (null == skuQtyMap.get(whTlBuyerApplyLine.getSkuCode())) {
                skuQtyMap.put(whTlBuyerApplyLine.getSkuCode(),whTlBuyerApplyLine.getQuality());
            } else {
                skuQtyMap.put(whTlBuyerApplyLine.getSkuCode(),skuQtyMap.get(whTlBuyerApplyLine.getSkuCode())+whTlBuyerApplyLine.getQuality());
            }
        }
        for (Map.Entry<String, Integer> entry : skuQtyMap.entrySet()) {
            List<String> warehouseCodeList = Lists.newArrayList();
            warehouseCodeList.add(WhWarehouseVO.WAREHOUSE_WH020600010096);//颛兴路-良品待分配
            warehouseCodeList.add(WhWarehouseVO.WAREHOUSE_WH020600010102);//颛兴路-官网渠道销售仓
            Integer availiableQty = 0;
            Integer warehouse_wh020600010096InvQty = 0;
            Integer warehouse_wh020600010102InvQty = 0;
            List<WhWarehouseSkuInvVO> whWarehouseSkuInvVOList =whInvService.findWarehousesSkuInvByCond(warehouseCodeList,entry.getKey());
            for (WhWarehouseSkuInvVO whWarehouseSkuInvVO : whWarehouseSkuInvVOList) {
                availiableQty+=whWarehouseSkuInvVO.getCanUseInv();
                if (whWarehouseSkuInvVO.getWarehouseCode().equals(WhWarehouseVO.WAREHOUSE_WH020600010096)) {
                    warehouse_wh020600010096InvQty = whWarehouseSkuInvVO.getCanUseInv();
                } else {
                    warehouse_wh020600010102InvQty = whWarehouseSkuInvVO.getCanUseInv();
                }
            }
            if (entry.getValue()>availiableQty) {
                throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM, "SKU【"+entry.getKey()+"】库存不足");
            }
            if (entry.getValue() >= warehouse_wh020600010096InvQty) {
                //数量>良品仓库存
                warehouseSkuQtyMap.get(WhWarehouseVO.WAREHOUSE_WH020600010096).put(entry.getKey(),warehouse_wh020600010096InvQty);
                warehouseSkuQtyMap.get(WhWarehouseVO.WAREHOUSE_WH020600010102).put(entry.getKey(),entry.getValue()-warehouse_wh020600010096InvQty);
            } else {
                warehouseSkuQtyMap.get(WhWarehouseVO.WAREHOUSE_WH020600010096).put(entry.getKey(),entry.getValue());
            }
        }
        return warehouseSkuQtyMap;
    }


    private List<WhReleaseOccupationVO> buildReleaseOccupyVOList (List<WhTlBuyerApplyVO> list) {
        List<WhReleaseOccupationVO> occupationVOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (WhTlBuyerApplyVO whTlBuyerApplyVO : list) {
                String applyCode = whTlBuyerApplyVO.getCode();
                List<WhInvOccupy> whInvOccupyList = whInvService.findOccupyQttByReferenceCodeLike(applyCode);
                if (CollectionUtils.isNotEmpty(whInvOccupyList)) {
                    for (WhInvOccupy whInvOccupy : whInvOccupyList) {
                        WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                        whReleaseOccupationVO.setReferenceCode(whInvOccupy.getReferenceCode());
                        whReleaseOccupationVO.setOccupyType(whInvOccupy.getOccupyType());
                        occupationVOS.add(whReleaseOccupationVO);
                    }
                }
            }
        }
        return occupationVOS;
    }

    @Override
    public Pagination<WhTlBuyerPackageOrderVO> findByCond(WhTlBuyerApplyCondVO whTlBuyerApplyCondVO) {
        Pagination<WhTlBuyerPackageOrderVO> page = new Pagination<>(whTlBuyerApplyCondVO.getCurrpage(), whTlBuyerApplyCondVO.getPagenum());
        Integer count = whTlBuyerPackageMapper.countByCond(whTlBuyerApplyCondVO);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        page.setResultList(whTlBuyerPackageMapper.findByCond(whTlBuyerApplyCondVO));
        return page;
    }

    @Override
    public WhTlBuyerPackageOrderVO findById(Integer id) {
        WhTlBuyerPackageOrderVO vo = whTlBuyerPackageMapper.findById(id);
        List<WhTlBuyerPackageLine> whTlBuyerPackageLines = whTlBuyerPackageLineMapper.findByPackageOrderId(id);
        vo.setWhTlBuyerPackageLines(whTlBuyerPackageLines);
        return vo;
    }

    @Override
    public List<WhTlBuyerPackageOrderVO> findByIds(List<Integer> ids) {
        return whTlBuyerPackageMapper.findByIds(ids);
    }

    @Override
    @Transactional
    public Integer packageOrderInOrOutBond(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        //先查询调拨单，判断状态
        List<WhAllotRcd> allotRcds = Lists.newArrayList();
        String allotCodes = saveVO.getWhTlBuyerPackage().getReferenceCode();
        String[] allotCodesArray = allotCodes.split(",");
        for (String allotCode : allotCodesArray) {
            WhAllotRcd whAllotRcd = whAllotService.findAllotRcdByCode(allotCode,false);
            allotRcds.add(whAllotRcd);
        }
        if (1 == saveVO.getType()) {
            //出库
            for (WhAllotRcd whAllotRcd : allotRcds) {
                if (whAllotRcd.getAllotStatus()!=WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND) {
                    throw new BusinessException("SM1001",
                            "该装箱单关联的调拨单，存在状态不为待出库的调拨单！");
                }
            }

            outBound(saveVO);
            //装箱单状态置为“司机已取货”
            WhTlBuyerPackage updateRecord = new WhTlBuyerPackage();
            updateRecord.setId(saveVO.getWhTlBuyerPackage().getId());
            updateRecord.setStatus(WhTlBuyerPackage.STATUS_DRIVER_GETED);
            Integer res = whTlBuyerPackageMapper.updateByPrimaryKeySelective(updateRecord);
            for (WhTlBuyerPackageLine whTlBuyerPackageLine : saveVO.getWhTlBuyerPackageLines()) {
                WhTlBuyerPackageLine whTlBuyerPackageLine1 = new WhTlBuyerPackageLine();
                whTlBuyerPackageLine1.setId(whTlBuyerPackageLine.getId());
                whTlBuyerPackageLine1.setActualOutBoundQty(whTlBuyerPackageLine.getActualOutBoundQty());

                whTlBuyerPackageLineMapper.updateByPrimaryKeySelective(whTlBuyerPackageLine1);
            }
            //申请单状态置为“待入库”
            WhTlBuyerApplyCondVO whTlBuyerApplyCondVO = new WhTlBuyerApplyCondVO();
            whTlBuyerApplyCondVO.setBuyerPackageId(saveVO.getWhTlBuyerPackage().getId());
            List<WhTlBuyerApplyVO> applyVOS =  whTlBuyerApplyMapper.findByCond(whTlBuyerApplyCondVO);
            if (CollectionUtils.isNotEmpty(applyVOS)) {
                for (WhTlBuyerApplyVO applyVO : applyVOS) {
                    WhTlBuyerApply updateApplyRecord = new WhTlBuyerApply();
                    updateApplyRecord.setId(applyVO.getId());
                    updateApplyRecord.setStatus(WhTlBuyerApply.STATUS_WAITING_IN_WAREHOUSE);
                    whTlBuyerApplyMapper.updateByPrimaryKeySelective(updateApplyRecord);
                }
            }
            return res;
        } else {
            //入库
            for (WhAllotRcd whAllotRcd : allotRcds) {
                if (whAllotRcd.getAllotStatus()!=WhAllotRcd.STATUS_WAIT_FOR_INBOUND) {
                    throw new BusinessException("SM1001",
                            "该装箱单关联的调拨单，存在状态不为待入库的调拨单！");
                }
            }
            inBound(saveVO);
            //装箱单状态置为“深圳已入仓”
            WhTlBuyerPackage updateRecord = new WhTlBuyerPackage();
            updateRecord.setId(saveVO.getWhTlBuyerPackage().getId());
            updateRecord.setStatus(WhTlBuyerPackage.STATUS_WAREHOUSE_IN);
            Integer res = whTlBuyerPackageMapper.updateByPrimaryKeySelective(updateRecord);
            for (WhTlBuyerPackageLine whTlBuyerPackageLine : saveVO.getWhTlBuyerPackageLines()) {
                WhTlBuyerPackageLine whTlBuyerPackageLine1 = new WhTlBuyerPackageLine();
                whTlBuyerPackageLine1.setId(whTlBuyerPackageLine.getId());
                whTlBuyerPackageLine1.setReceiveGoodQty(whTlBuyerPackageLine.getReceiveGoodQty());
                whTlBuyerPackageLine1.setReceiveBadQty(whTlBuyerPackageLine.getReceiveBadQty());
                whTlBuyerPackageLineMapper.updateByPrimaryKeySelective(whTlBuyerPackageLine1);
            }
            //申请单状态置为“已完成”
            WhTlBuyerApplyCondVO whTlBuyerApplyCondVO = new WhTlBuyerApplyCondVO();
            whTlBuyerApplyCondVO.setBuyerPackageId(saveVO.getWhTlBuyerPackage().getId());
            List<WhTlBuyerApplyVO> applyVOS =  whTlBuyerApplyMapper.findByCond(whTlBuyerApplyCondVO);
            if (CollectionUtils.isNotEmpty(applyVOS)) {
                for (WhTlBuyerApplyVO applyVO : applyVOS) {
                    WhTlBuyerApply updateApplyRecord = new WhTlBuyerApply();
                    updateApplyRecord.setId(applyVO.getId());
                    updateApplyRecord.setStatus(WhTlBuyerApply.STATUS_FINISH);
                    whTlBuyerApplyMapper.updateByPrimaryKeySelective(updateApplyRecord);
                }
            }
            sendEmail(saveVO.getWhTlBuyerPackageLines(),1);
            return res;
        }
    }

    @Override
    public WhTlBuyerPackage findBuyerPackageDetailByIdForExceal(Integer buyerPackageId) {
        WhTlBuyerPackage whTlBuyerPackage = whTlBuyerPackageMapper.selectByPrimaryKey(buyerPackageId);
        List<PackingListExcelItemVO> listExcelItemVOS = whTlBuyerPackageLineMapper.findPackageOrderDetailByIdForExcel(buyerPackageId);
        whTlBuyerPackage.setPackingListExcelItemVOS(listExcelItemVOS);
        return whTlBuyerPackage;
    }

    private Boolean outBound(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        List<String> allotCodes = Arrays.asList(saveVO.getWhTlBuyerPackage().getReferenceCode().split(","));
        for (String allotCode : allotCodes) {
            WhCommand whCommand = whCommandService.findCommandByReferenceCode(allotCode);
            if (whCommand == null || !whCommand.isOut()) {
                throw new BusinessException("SM1001",
                        "指令不存在！");
            }

//            String warehouseCode = whCommand.getWarehouseCode();
//            ControllerPermissionUtil.getInstance().checkWarehousePermission(warehouseCode);
//
//            String physicalWarehouseCode = whCommand.getPhysicalWarehouseCode();
//            ControllerPermissionUtil.getInstance().checkPhysicalWarehousePermission(physicalWarehouseCode);
//            //物理仓检查
//            whCommandService.preCheckBeforeFinishCommand(Collections.singletonList(warehouseCode),Collections.singletonList(physicalWarehouseCode),checked);

            // commandSkuMap<code,quantity>
            Map<String, Integer> commandSkuMap = new HashMap<>();
            for (WhTlBuyerPackageLine packageLine : saveVO.getWhTlBuyerPackageLines()) {
                commandSkuMap.put(packageLine.getSkuCode(), packageLine.getActualOutBoundQty());
            }

            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                String commandSkuCode = whCommandSku.getSkuCode();
                Integer qtt = 0;
                if (commandSkuMap.get(commandSkuCode)>=whCommandSku.getPlanedQuantity()) {
                    qtt = whCommandSku.getPlanedQuantity();
                } else {
                    qtt = commandSkuMap.get(commandSkuCode);
                }
                if (qtt == null) {
                    throw new BusinessException("sm1002",
                            "command sku not match");
                }
                whCommandSku.setQuantity(qtt);
                whCommandSku.setDamagedQuantity(0);
            }

            whCommand.setOperatorId(saveVO.getOperatorId());
            boolean tf = whCommandService.finishCommand(whCommand);

        }
        return true;
    }

    private Boolean inBound(BondedWarehouseAllotPackageVO saveVO) throws Exception {
        List<String> allotCodes = Arrays.asList(saveVO.getWhTlBuyerPackage().getReferenceCode().split(","));
//        临时倒叙
//        Collections.reverse(allotCodes);
        Map<String,Integer> saveVOReceiveGoodSkuQty = new HashMap<>();
        Map<String,Integer> saveVOReceiveBadSkuQty = new HashMap<>();

        for (WhTlBuyerPackageLine packageLine : saveVO.getWhTlBuyerPackageLines()) {
            saveVOReceiveGoodSkuQty.put(packageLine.getSkuCode(),packageLine.getReceiveGoodQty());
            saveVOReceiveBadSkuQty.put(packageLine.getSkuCode(),packageLine.getReceiveBadQty());
        }

        for (String allotCode : allotCodes) {
            WhCommand whCommand = whCommandService.findCommandByTypeAndReferenceCode(10,allotCode,true);
            if (whCommand == null || whCommand.isOut()) {
                throw new BusinessException("SM1001","指令不存在！");
            }
            for (WhCommandSku whCommandSku : whCommand.getWhCommandSkuList()) {
                Integer qtt = 0;
                String commandSkuCode = whCommandSku.getSkuCode();
                if (whCommandSku.getPlanedQuantity() <= saveVOReceiveGoodSkuQty.get(commandSkuCode)) {
                    //若实际收货数量 > 指令计划数量 ————>Command skuQty = whCommandSku.getPlanedQuantity()
                    qtt = whCommandSku.getPlanedQuantity();
                    //溢出的良品数量(分配给下一个指令行的数量)为 接收良品数量-指令计划数量
                    saveVOReceiveGoodSkuQty.put(commandSkuCode,saveVOReceiveGoodSkuQty.get(commandSkuCode)-whCommandSku.getPlanedQuantity());
                    //设置残次数量为0
                    whCommandSku.setDamagedQuantity(0);
                } else {

                    //若实际收货数量 < 指令计划数量  实收良品数量就该等于填写的数量
                    qtt = saveVOReceiveGoodSkuQty.get(commandSkuCode);
                    //实收残品 要先看看  (实收残次+实收良品)和 commandSku行planQty的数量大小关系
                    Integer damagedQty = 0;
                    if ((saveVOReceiveBadSkuQty.get(commandSkuCode) + saveVOReceiveGoodSkuQty.get(commandSkuCode)) > whCommandSku.getPlanedQuantity()) {
//                        若(实收残次+实收良品) > commandSku行planQty
//                            10 + 40   >  48
                        damagedQty = whCommandSku.getPlanedQuantity()-qtt;  //残次数量=CommandSku行plan数量-实收良品
                    } else {
                        damagedQty = saveVOReceiveBadSkuQty.get(commandSkuCode);
                    }
                    saveVOReceiveGoodSkuQty.put(commandSkuCode,saveVOReceiveGoodSkuQty.get(commandSkuCode)-qtt);
                    whCommandSku.setDamagedQuantity(damagedQty);
                    //溢出的残次数量(分配给下一个指令行的数量)为 填写的实收残次数量- 本行填写残次
                    saveVOReceiveBadSkuQty.put(commandSkuCode,saveVOReceiveBadSkuQty.get(commandSkuCode)-damagedQty);
                }
                whCommandSku.setQuantity(qtt);
            }
            whCommand.setOperatorId(saveVO.getOperatorId());
            boolean tf = whCommandService.finishCommand(whCommand);
            if(whCommand.getInOutType().equals(WhCommand.TYPE_ALLOT_IN)){
                //生成差异 （scm库存入库,创建指令并自动完成）
                final WhCommand whInCommand = bulidWhCommandForQc(whCommand);
                if(CollectionUtils.isNotEmpty(whInCommand.getWhCommandSkuList())){
                    whCommandService.createCommandThenFinish(whInCommand);
                }
            }
        }
        return true;
    }


    /**
     * 创建质检差异指令,仓库指令需要的参数,线上
     * @param vo
     * @return
     * @throws Exception
     */
    private WhCommand bulidWhCommandForQc(WhCommand vo) throws Exception {
        final WhCommand whCommand = new WhCommand();
        /**
         * 差异数量调入仓根据调拨出库的逻辑仓类型判断
         * 良品待分配仓:WH020600360218
         * 残次品仓:WH020600360219
         * 样品仓:WH020600360220
         * 其他:WH020600360218
         */
        WhAllotRcd allotRcd = whAllotService.findAllotRcdByCode(vo.getReferenceCode(),false);
        if(NullUtil.isNull(allotRcd)){
            throw new WarehouseException("SM1004",String.format("[%s]调拨单不存在",vo.getReferenceCode()));
        }
        WhWarehouse whWarehouse= whInfoService.findWarehouseByCode(allotRcd.getSourceWarehouseCode());
        if(whWarehouse != null){
        	/*Integer whType = whWarehouse.getWarehouseType();
        	//仓库类型，1良品待分配仓2残次品仓3废品仓4礼品仓5样品仓6生产加工仓9渠道销售仓
        	if(WhWarehouseVO.TYPE_WAIT_FOR_DISPATCHING.equals(whType)){
        		whCommand.setWarehouseCode("WH020600360218");
        	}else if(WhWarehouseVO.TYPE_DAMAGED.equals(whType)){
        		whCommand.setWarehouseCode("WH020600360219");
        	}else if(WhWarehouseVO.TYPE_SAMPLE.equals(whType)){
        		whCommand.setWarehouseCode("WH020600360220");
        	}else {
        		whCommand.setWarehouseCode("WH020600360218");
        	}*/
            Integer commodityStatus = whWarehouse.getCommodityStatus();
            // 改成 用 逻辑仓商品状态判断
            whCommand.setWarehouseCode(WhWarehouseVO.fetchDiffWarehouseByCommodityStatus(commodityStatus));
            whCommand.setPhysicalWarehouseCode("WH02060036");//差异物理仓
            whCommand.setReferenceCode(vo.getReferenceCode()+"_1");
            whCommand.setInOutType(WhCommand.TYPE_ALLOT_IN);
            final List<WhCommandSku> returnWhCommandSkuList = new ArrayList<>();
            for (final WhCommandSku sku : vo.getWhCommandSkuList()) {
                Integer planedQuantity = sku.getPlanedQuantity()-sku.getQuantity()-sku.getDamagedQuantity();
                if(planedQuantity > 0){
                    final WhCommandSku whCommandSku = new WhCommandSku();
                    whCommandSku.setSkuCode(sku.getSkuCode());
                    whCommandSku.setPlanedQuantity(planedQuantity);
                    returnWhCommandSkuList.add(whCommandSku);
                }
            }
            whCommand.setWhCommandSkuList(returnWhCommandSkuList);
        }

        return whCommand;
    }


    private String createAllots(Map<String,Map<String,Integer>> map, String packageOrderCode, Long operatorId,String applyTargetPhysicalWarehouseCode) throws Exception {
        StringBuilder allotCodes = new StringBuilder("");
        for (Map.Entry<String, Map<String,Integer>> entry : map.entrySet()) {
            WhAllotRcd whAllotRcd = new WhAllotRcd();
            whAllotRcd.setAllotType(WhAllotRcd.TYPE_CROSS_BORDER_ALLOT);
            whAllotRcd.setSourceWarehouseCode(entry.getKey());
            Set<String> warehouseCodeSet = new HashSet<>();
            warehouseCodeSet.add(entry.getKey());
            whAllotRcd.setSourcePhysicalWarehouseCode("WH20250047");
            whAllotRcd.setTargetPhysicalWarehouseCode(applyTargetPhysicalWarehouseCode);
            //获取默认入库良品仓
            if (EmptyUtil.isNotEmpty(applyTargetPhysicalWarehouseCode)) {
                WhWarehouse relateWarehouseVO = whInfoService.findDefaultInNondefectiveWarehouseByPhyWhCode(applyTargetPhysicalWarehouseCode);
                if (NullUtil.isNotNull(relateWarehouseVO)) {
                    whAllotRcd.setTargetWarehouseCode(relateWarehouseVO.getCode());
                }
            }
            whAllotRcd.setAllotStatus(WhAllotRcd.STATUS_WAIT_FOR_OUTBOUND);
            whAllotRcd.setReferenceCode(packageOrderCode);
            whAllotRcd.setRemark("海淘调拨");
            whAllotRcd.setCreateUserId(operatorId == null ? 1 : operatorId.intValue());
            List<WhAllotRcdSku> allotRcdSkus = new ArrayList<>();

            for (Map.Entry<String,Integer> skuEntry : entry.getValue().entrySet()) {
                if (skuEntry.getValue()>0) {
                    WhAllotRcdSku whAllotRcdSku = new WhAllotRcdSku();
                    whAllotRcdSku.setSkuCode(skuEntry.getKey());
                    whAllotRcdSku.setQuantity(skuEntry.getValue());
                    allotRcdSkus.add(whAllotRcdSku);
                }
            }
            if (CollectionUtils.isEmpty(allotRcdSkus)) {
                continue;
            }
            whAllotRcd.setWhAllotRcdSkuList(allotRcdSkus);
            String allotCode = whAllotService.createAllotRcd(whAllotRcd);
            allotCodes.append(allotCode+",");
        }
        return allotCodes.toString().substring(0,allotCodes.length()-1);
    }

    public Boolean sendEmail(List<WhTlBuyerPackageLine> whTlBuyerPackageLines,Integer type) {
        StringBuffer emailContent = new StringBuffer();
        emailContent.append(
                "<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append(
                "#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append(
                "#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        if(EmptyUtil.isNotEmpty(whTlBuyerPackageLines)) {
            String title = "";
            if (type == 0) {
                title = "<th>SKU</th><th>SKU名</th><th>供应商条码</th><th>品牌</th><th>数量</th>";
            } else {
                title = "<th>SKU</th><th>SKU名</th><th>供应商条码</th><th>商品货号</th><th>申请数量</th><th>审批通过数量</th><th>实际出库数量</th><th>实际入库良品</th><th>实际入库残次</th>";
            }
            emailContent.append(
                    "</br></br><table id='table-5'><thead>"+title
                            + "</thead>");
            emailContent.append("<tbody>");
            for(WhTlBuyerPackageLine whTlBuyerPackageLine : whTlBuyerPackageLines) {
                emailContent.append("<tr>");
                if (type ==0) {
                    emailContent.append("<td>" + whTlBuyerPackageLine.getSkuCode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getSkuName() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getBarcode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getBrandName() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getQuality() + "</td>");
                } else {
                    emailContent.append("<td>" + whTlBuyerPackageLine.getSkuCode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getSkuName() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getBarcode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getEbayItemCode() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getQuality() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getQuality() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getActualOutBoundQty() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getReceiveGoodQty() + "</td>");
                    emailContent.append("<td>" + whTlBuyerPackageLine.getReceiveBadQty() + "</td>");
                }
            }
            emailContent.append("</tr>");
        }
        emailContent.append("</tbody></table>");
        List<String> toAddressList = new ArrayList<>();
        CommGlobalConfig commGlobalConfig = new CommGlobalConfig();
        if (type == 0) {
            commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("whtl.packageOrder.addresses");
        } else {
            commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("whtl.packageInOrOutBound.addresses");
        }
        String[] toUser = commGlobalConfig.getConfigValue().split(",");
        toAddressList = Arrays.asList(toUser);
        // 邮件VO
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        String subject ="";
        if (type == 0) {
            subject = "港仓打包通知";
        } else {
            subject = "深圳仓调拨入库通知";
        }
        emailVO.setSubject(subject);
        emailVO.setContent(emailContent.toString());
        // 发邮件
        if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
            // 正式环境发邮件
            EmailUtil.getInstance().send(emailVO);
        }
        return null;
    }

}
