package com.thebeastshop.pegasus.service.warehouse.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.thebeastshop.pegasus.service.warehouse.dao.TmallStockLogMapper;
import com.thebeastshop.pegasus.service.warehouse.model.TmallStockLog;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityRequest;
import com.thebeastshop.pegasus.util.vo.ThirdpartyGoodsQuantityResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.service.warehouse.model.WhCommand;
import com.thebeastshop.pegasus.service.warehouse.model.WhCommandSku;
import com.thebeastshop.pegasus.service.warehouse.service.WhCommandService;
import com.thebeastshop.pegasus.service.warehouse.service.WhThirdPartyService;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;

import vipapis.delivery.PackageProduct;
import vipapis.delivery.PrintTemplateResponse;
import vipapis.delivery.Ship;

@Service("whThirdPartyService")
public class WhThirdPartyServiceImpl implements WhThirdPartyService{

	@Autowired
	private WhCommandService whCommandService;

	@Autowired
	private TmallStockLogMapper tmallStockLogMapper;
	
	private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();
	
	@Override
	public boolean vipShip(WhCommand whCommand) {
		List<WhCommandSku> skuList = whCommandService.findCommandSkuByCommandCode(whCommand.getCode());
		List<Ship> shipList = new ArrayList<>();
		Ship ship = new Ship();
		ship.setOrder_id(whCommand.getOuterOrderCode());
		ship.setPackage_type("1");
		ship.setCarrier_code("1000000458");
		ship.setCarrier_name("顺丰速运(直发)");
		System.out.println("唯品会发货：" + whCommand.getOuterOrderCode());
		List<vipapis.delivery.Package> packages = new ArrayList<>();
		vipapis.delivery.Package packagePojo = new vipapis.delivery.Package();
	
		List<PackageProduct> productList = new ArrayList<>();
		for(WhCommandSku whCommandSku : skuList) {
			PackageProduct packageProduct = new PackageProduct();
			packageProduct.setBarcode(whCommandSku.getSkuCode());
			packageProduct.setAmount(whCommandSku.getQuantity());
			productList.add(packageProduct);
		}
		packagePojo.setPackage_product_list(productList);
		packagePojo.setTransport_no(whCommand.getExpressNo());
		packages.add(packagePojo);
		ship.setPackages(packages);
		shipList.add(ship);
		pegasusUtilFacade.vipShip(shipList);
		return true;
	}

	@Override
	public PrintTemplateResponse getPrintTemplate(String outerOrderCode) {
		return pegasusUtilFacade.getPrintTemplate(outerOrderCode);
	}

	@Override
	public ThirdpartyGoodsQuantityResponse syncCommodityStocks(ThirdpartyGoodsQuantityRequest goodsQuantitySyncVO) throws Exception {
		ThirdpartyGoodsQuantityResponse response = pegasusUtilFacade.syncThirdpartyGoodsStocks(goodsQuantitySyncVO);
		saveStockUpdateLog(goodsQuantitySyncVO, response);
		return response;
	}

  private void saveStockUpdateLog(ThirdpartyGoodsQuantityRequest request, ThirdpartyGoodsQuantityResponse response) {
		final TmallStockLog tmallStockLog = new TmallStockLog();
		tmallStockLog.setGoodsId(request.getGoodsId());
		tmallStockLog.setQuantity(request.getQuantity());
		tmallStockLog.setSkuCode(request.getSkuCode());
		tmallStockLog.setReferenceCode(request.getReferenceCode());
		tmallStockLog.setSyncType(request.getReferenceType());
		tmallStockLog.setCreateTime(new Date());
		tmallStockLog.setChannelCode(request.getChannelCode());
		tmallStockLog.setSyncStatus(response.isUpdateSuccess() ? (short)1 : 0);
		tmallStockLog.setRemark(response.getMsg());
		tmallStockLogMapper.insertSelective(tmallStockLog);
	}

}
