/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.warehouse.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.pegasus.service.warehouse.cond.WhTakeStockCond;
import com.thebeastshop.pegasus.service.warehouse.cond.WhWmsHouseShelvesCond;
import com.thebeastshop.pegasus.service.warehouse.dao.WhAllotRcdSkuMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTakeStockMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.WhTakeStockRcdMapper;
import com.thebeastshop.pegasus.service.warehouse.dao.custom.WhAllotDiffDetailCustomMapper;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseException;
import com.thebeastshop.pegasus.service.warehouse.exception.WarehouseExceptionErrorCode;
import com.thebeastshop.pegasus.service.warehouse.model.*;
import com.thebeastshop.pegasus.service.warehouse.service.*;
import com.thebeastshop.pegasus.service.warehouse.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.Constants;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.exception.CommExceptionErrorCode;
import com.thebeastshop.pegasus.util.model.CommSku;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author Royan
 * @version $Id: WhTakeStockServiceImpl.java, v 0.1 2015-07-09 下午3:10
 */
@Service("whTakeStockService")
public class WhTakeStockServiceImpl implements WhTakeStockService {

    private final Logger         log = LoggerFactory.getLogger(WhTakeStockServiceImpl.class);

    @Autowired
    private WhTakeStockMapper    whTakeStockMapper;

    @Autowired
    private WhTakeStockRcdMapper whTakeStockRcdMapper;

    @Autowired
    private WhInfoService whInfoService;

    @Autowired
    private WhWmsHouseShelvesService whWmsHouseShelvesService;

    @Autowired
    private WhWmsSkuStockService whWmsSkuStockService;

    @Autowired
    private WhInvService         whInvService;

    @Autowired
    private WhCommandService whCommandService;

    @Autowired
    private WhAllotRcdSkuMapper whAllotRcdSkuMapper;

    @Autowired
    private WhAllotDiffDetailCustomMapper whAllotDiffDetailCustomMapper;

    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();
    /**
     * 创建
     *
     * @param whTakeStock
     * @return ID
     * @throws Exception 
     */
    @Override
    @Transactional
    public Long createTakeStock(WhTakeStock whTakeStock) throws Exception {

        if(NullUtil.isNull(whTakeStock.getType())){
            whTakeStock.setType(WhTakeStock.TYPE_SCM);
        }

        if (whTakeStock.getBatchNumber() == null) {
            whTakeStock.setBatchNumber(findMaxBatchNumber());
        }

        List<WhTakeStockRcd> whTakeStockRcdList = whTakeStock.getWhTakeStockRcdList();
        if (whTakeStockRcdList == null || whTakeStockRcdList.isEmpty()) {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,"盘点行为空");
        }

        WhWarehouseVO whWarehouseVO = whInfoService.findWarehouseAndGroupByWarehouseCode(whTakeStock.getWarehouseCode());
        if (EmptyUtil.isEmpty(whWarehouseVO)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "逻辑仓不存在!");
        }
        Integer skuStatus = null;
        WhWmsHouseShelvesVO shelvesVO = null;
        boolean needUpdateWmsSkuStock = false;

        WhPhysicalWarehouse physicalWarehouse = null;
        // 逻辑仓分组属性 不为仓库
        if(!WhWarehouseGroupVO.WAREHOUSE_YES.equals(whWarehouseVO.getWarehouseGroupType())){
            // skuStatus = whCommandService.getSkuStatusByWarehouseType(whWarehouse.getWarehouseType());
            // 逻辑仓 找 物理仓
            if(whTakeStock.isUpdatePhyWhStock()){
                if (EmptyUtil.isEmpty(whTakeStock.getPhysicalWarehouseCode())){
                    physicalWarehouse = findPhysicalByWarehouseCode(whTakeStock.getWarehouseCode());
                }else{
                    physicalWarehouse = whInfoService.findPhysicalWarehouseByCode(whTakeStock.getPhysicalWarehouseCode());
                }
                if (EmptyUtil.isEmpty(physicalWarehouse)){
                    throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND, "物理仓不存在!");
                }

                skuStatus = whCommandService.getSkuStatusByWarehouseType(whWarehouseVO.getCommodityStatus());
                shelvesVO = getWhWmsHouseShelves(physicalWarehouse.getCode(),skuStatus);
                needUpdateWmsSkuStock = true;
            }
        } else if(!whTakeStock.isFromWms()){
            skuStatus = whCommandService.getSkuStatusByWarehouseType(whWarehouseVO.getCommodityStatus());
            shelvesVO = getWhWmsHouseShelves(Constants.HAITAO_PHY_WAREHOUSECODE,skuStatus);
        }
        whTakeStock.setCreateTime(DateUtil.getNow());
        whTakeStockMapper.insert(whTakeStock);
        Long whTakeStockId = whTakeStock.getId();

        List<WhAllotDiffDetailVO> allotDiffDetailVOs = new ArrayList<>();

        for (WhTakeStockRcd whTakeStockRcd : whTakeStockRcdList) {
            Integer quantity = whTakeStockRcd.getQuantity();
            if (quantity != 0) {
                whTakeStockRcd.setTakeStockId(whTakeStockId);
                whTakeStockRcd.setResultType(quantity > 0 ? WhTakeStockRcd.TYPE_PROFIT:WhTakeStockRcd.TYPE_LOSS);
                whTakeStockRcdMapper.insert(whTakeStockRcd);
                //扣除wms库存记录
                if(whTakeStock.isUpdatePhyWhStock()){
                    if(needUpdateWmsSkuStock){
//                    WhWmsSkuStockRecord skuStockRecord = buildPhyWhSkuStockRcd(whTakeStockRcd,shelvesVO,skuStatus,whTakeStock.getCreateUserId());
//                    skuStockRecordList.add(skuStockRecord);
                        updatePhyWhSkuStock(whTakeStockRcd,shelvesVO,skuStatus,whTakeStock.getCreateUserId());
                    } else  {
                        if (NullUtil.isNotNull(whTakeStockRcd.getCrossBorderFlag())
                                && whTakeStockRcd.getCrossBorderFlag() == 1 && whTakeStock.getSyncSeaPhyWarehouse()) {
//                        WhWmsSkuStockRecord skuStockRecord = buildPhyWhSkuStockRcd(whTakeStockRcd,shelvesVO,skuStatus,whTakeStock.getCreateUserId());
//                        skuStockRecordList.add(skuStockRecord);
                            updatePhyWhSkuStock(whTakeStockRcd,shelvesVO,skuStatus,whTakeStock.getCreateUserId());
                        }
                    }
                }
                // 记录SKU库存记录
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setWmsTakeStockRcdId(whTakeStockRcd.getWmsTakeStockRcdId());//wms盘点记录行id,可以为空
                whInvRcd.setTakeStockRcdId(whTakeStockRcd.getId().intValue());
                whInvRcd.setWarehouseCode(whTakeStock.getWarehouseCode());
                whInvRcd.setInOutType(WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd
                    .getResultType()) ? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT);
                whInvRcd.setSkuCode(whTakeStockRcd.getSkuCode());
                whInvRcd.setQuantity(whTakeStockRcd.getQuantity());
                whInvRcd.setMemo(whTakeStockRcd.getMemo());
                whInvRcd.setSubmitTime(DateUtil.getNow());
                whInvRcd.setSubmitUserId(whTakeStock.getCreateUserId());
                whInvService.record(whInvRcd);

                // 如果是调拨差异创建的盘点，则更新差异处理数量 累加 (具体详情则在 调拨差异详情表查看)
                if (whTakeStock.isAllotDiffProcess()){
                    if (EmptyUtil.isNotEmpty(whTakeStockRcd.getNeedUpdateAllotSkuId())){
                        WhAllotRcdSku record = new WhAllotRcdSku();
                        record.setId(whTakeStockRcd.getNeedUpdateAllotSkuId());
                        record.setProcessedQuantity(Math.abs(whTakeStockRcd.getQuantity()));
                        whAllotRcdSkuMapper.updateProcessedQuantityByPrimaryKey(record);
                    }
                    // 构建调拨差异详情
                    buildAllotDiffDetailVOs(whTakeStock,whTakeStockRcd,allotDiffDetailVOs);
                }
            }
        }
        // 记录 调拨差异详情
        if (CollectionUtils.isNotEmpty(allotDiffDetailVOs)){
            whAllotDiffDetailCustomMapper.batchInsert(allotDiffDetailVOs);
        }

        if(whTakeStock.isSyncThirdpartStock()){
            //同步天猫库存
            String warehouseCode = whTakeStock.getWarehouseCode();
            if(Constants.warehouseMap.containsKey(warehouseCode)) {
                syncTmallStock(getSyncSkuList(whTakeStockRcdList), Constants.warehouseMap.get(warehouseCode), whTakeStockId,whTakeStock.getCreateUserId());
            }
            //同步京东库存
            trySyncJdStock(whTakeStock);
        }

        return whTakeStockId;
    }

    private void trySyncJdStock(WhTakeStock whTakeStock){
        if(!pegasusUtilFacade.needSyncJdStock(whTakeStock.getWarehouseCode())){
            return;
        }
        List<CommSku> skuList = getSyncSkuList(whTakeStock.getWhTakeStockRcdList());
        if(EmptyUtil.isNotEmpty(skuList)){
            Map<String,Integer> skuQuantityMap = new HashMap<>();
            for(CommSku commSku : skuList){
                Integer total = skuQuantityMap.get(commSku.getCode());
                if(NullUtil.isNull(total)){
                    total = 0;
                }
                skuQuantityMap.put(commSku.getCode(),total+commSku.getQuantity());
            }
            List<String> referenceCodes = new LinkedList<String>();
            referenceCodes.add(whTakeStock.getId().toString());
            whCommandService.syncJdSkuStock(whTakeStock.getWarehouseCode()
                    ,skuQuantityMap
                    ,Constants.STOCK_SYNC_TYPE_INVENTORY
                    , referenceCodes
                    ,whTakeStock.getCreateUserId(),true);
        }

    }


    private boolean updatePhyWhSkuStock(WhTakeStockRcd whTakeStockRcd,WhWmsHouseShelvesVO shelvesVO,Integer skuStatus,Long operaterId){
        Integer quantity = whTakeStockRcd.getQuantity();
        if(quantity > 0){
            return updatePhyWhSkuStockIn(whTakeStockRcd,shelvesVO,skuStatus,operaterId);
        }else if(quantity < 0){
            return updatePhyWhSkuStockOut(whTakeStockRcd,shelvesVO,skuStatus,operaterId);
        }
        return true;
    }

    private boolean updatePhyWhSkuStockIn(WhTakeStockRcd whTakeStockRcd,WhWmsHouseShelvesVO shelvesVO,Integer skuStatus,Long operaterId){
        WhWmsSkuStockRecord skuStockRecord = buildPhyWhSkuStockRcd(whTakeStockRcd,shelvesVO,skuStatus,operaterId);
        updatePhyWhSkuStock(Collections.singletonList(skuStockRecord));
        return true;
    }

    private boolean updatePhyWhSkuStockOut(WhTakeStockRcd whTakeStockRcd,WhWmsHouseShelvesVO shelvesVO,Integer skuStatus,Long operaterId){
        whCommandService.updatePhyWhSkuStockOut(shelvesVO.getPhysicalWarehouseCode(),whTakeStockRcd.getSkuCode()
                ,skuStatus,whTakeStockRcd.getQuantity(),buildPhyWhInOutType(whTakeStockRcd)
                ,whTakeStockRcd.getId().toString(),NullUtil.isNull(operaterId)?1L:operaterId
                ,whTakeStockRcd.getMemo());
        return true;
    }

    @Override
    @Transactional
    public List<Long> batchCreateTakeStock(List<WhTakeStock> whTakeStockList) throws Exception {
      List<Long>  ids = new ArrayList<Long>();
      Long batchNumber = findMaxBatchNumber();
      for (WhTakeStock whTakeStock : whTakeStockList) {
        whTakeStock.setBatchNumber(batchNumber);
        ids.add(createTakeStock(whTakeStock));
      }
      return ids;
    }

    @Override
    public WhPhysicalWarehouseVO findPhysicalByWarehouseCode(String warehouseCode){
        Validation.paramNotNull(warehouseCode,"逻辑仓编码为空");
        List<WhPhysicalWarehouseVO> physicalWarehouseVOs = whInfoService.findPhysicalWarehouseByWarehouseCode(warehouseCode);
        if (CollectionUtils.isEmpty(physicalWarehouseVOs)){
            throw new WarehouseException(WarehouseExceptionErrorCode.WAREHOUSE_NOT_FIND,
                    "逻辑仓["+warehouseCode+"]在逻辑仓分组中找不到对应的物理仓，操作失败");
        }
        if (physicalWarehouseVOs.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "逻辑仓["+warehouseCode+"]对应的物理仓有多个，操作失败");
        }
        return physicalWarehouseVOs.get(0);
    }

    private void updatePhyWhSkuStock(List<WhWmsSkuStockRecord> skuStockRecordList){
        if(EmptyUtil.isNotEmpty(skuStockRecordList)){
            for(WhWmsSkuStockRecord skuStockRecord : skuStockRecordList){
                whWmsSkuStockService.updateStockByCond(skuStockRecord.getQuantity()
                        ,skuStockRecord.getPhysicalWarehouseCode()
                        ,skuStockRecord.getHouseType()
                        ,skuStockRecord.getBarCode(),skuStockRecord.getShelvesCode(),skuStockRecord.getSkuCode(),skuStockRecord.getSkuStatus()
                        ,skuStockRecord.getInOutType(),skuStockRecord.getReceiptNo(),skuStockRecord.getCreateUserId(),skuStockRecord.getMemo(),2);
            }
        }
    }

    private WhWmsSkuStockRecord buildPhyWhSkuStockRcd(WhTakeStockRcd whTakeStockRcd,WhWmsHouseShelvesVO shelvesVO,Integer skuStatus,Long operaterId){
        WhWmsSkuStockRecord skuStockRecord = new WhWmsSkuStockRecord();
        skuStockRecord.setPhysicalWarehouseCode(shelvesVO.getPhysicalWarehouseCode());
        skuStockRecord.setSkuStatus(skuStatus);
        skuStockRecord.setQuantity(whTakeStockRcd.getQuantity());
        skuStockRecord.setSkuCode(whTakeStockRcd.getSkuCode());
        skuStockRecord.setBarCode(skuStockRecord.getSkuCode()+"_0000");
        skuStockRecord.setShelvesCode(shelvesVO.getCode());
        skuStockRecord.setHouseType(shelvesVO.getHouseType());
        skuStockRecord.setMemo(whTakeStockRcd.getMemo());
        skuStockRecord.setInOutType(buildPhyWhInOutType(whTakeStockRcd));
        skuStockRecord.setReceiptNo(whTakeStockRcd.getId().toString());
        skuStockRecord.setCreateTime(DateUtil.getNow());
        skuStockRecord.setCreateUserId(NullUtil.isNull(operaterId)?1L:operaterId);
        return skuStockRecord;
    }

    private Integer buildPhyWhInOutType(WhTakeStockRcd whTakeStockRcd){
        return WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd
                .getResultType()) ? WhCommand.TYPE_INVENTROY_PROFIT_IN : WhCommand.TYPE_INVENTROY_LOSS_OUT;
    }


    private WhWmsHouseShelvesVO getWhWmsHouseShelves(String physicalWarehouseCode,Integer skuStatus){
        WhWmsHouseShelvesCond cond = new WhWmsHouseShelvesCond();
        cond.setPhysicalWarehouseCode(physicalWarehouseCode);
        cond.setSkuStatus(skuStatus);
        List<WhWmsHouseShelvesVO> whWmsHouseShelvesList = whWmsHouseShelvesService.getHouseShelvesByCond(cond);
        if (CollectionUtils.isEmpty(whWmsHouseShelvesList)){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+ WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",库位不存在!");
        }
        if (whWmsHouseShelvesList.size()>1){
            throw new WarehouseException(WarehouseExceptionErrorCode.RESULT_NOT_EXPECTED,
                    "物理仓["+cond.getPhysicalWarehouseCode()+"],SKU状态["+WhWarehouseVO.COMMODITY_STATUS_DETAIL_MAP.get(cond.getSkuStatus())+"]"+",查询有多个库位!");
        }
        return whWmsHouseShelvesList.get(0);
    }

    private void buildAllotDiffDetailVOs(WhTakeStock whTakeStock, WhTakeStockRcd whTakeStockRcd, List<WhAllotDiffDetailVO> allotDiffDetailVOs) {
        // 由调拨异常创建的调拨单，记录调拨差异详情
        WhAllotDiffDetailVO whAllotDiffDetailVO = new WhAllotDiffDetailVO();
        whAllotDiffDetailVO.setCreateTime(DateUtil.getNow());
        whAllotDiffDetailVO.setOperatorId(EmptyUtil.isNotEmpty(whTakeStock.getCreateUserId())?whTakeStock.getCreateUserId().intValue():1);
        whAllotDiffDetailVO.setSkuCode(whTakeStockRcd.getSkuCode());
        whAllotDiffDetailVO.setQuantity(whTakeStockRcd.getQuantity());
        whAllotDiffDetailVO.setProcessType(WhAllotDiffDetailVO.PROCESS_TYPE_INVENTORY);
        whAllotDiffDetailVO.setWarehouseCode(whTakeStock.getWarehouseCode());
        whAllotDiffDetailVO.setRefId(whTakeStock.getRefAllotId());
        allotDiffDetailVOs.add(whAllotDiffDetailVO);
    }

    /**
     * 创建 SCM 盘点
     * @param whTakeStock
     * @return ID
     * @throws Exception
     */
    @Override
    @Transactional
    public void recordScmStock(WhTakeStock whTakeStock) throws Exception {
        List<WhTakeStockRcd> whTakeStockRcdList = whTakeStock.getWhTakeStockRcdList();
        if (whTakeStockRcdList == null || whTakeStockRcdList.isEmpty()) {
            throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                    "whTakeStockRcdList can not be empty.");
        }
        for (WhTakeStockRcd whTakeStockRcd : whTakeStockRcdList) {
            Integer quantity = whTakeStockRcd.getQuantity();
            if (quantity != 0) {
                whTakeStockRcd.setResultType(quantity > 0 ? WhTakeStockRcd.TYPE_PROFIT
                        : WhTakeStockRcd.TYPE_LOSS);
                // 记录SKU库存记录
                WhInvRcd whInvRcd = new WhInvRcd();
                whInvRcd.setWmsTakeStockRcdId(whTakeStockRcd.getWmsTakeStockRcdId());
                //whInvRcd.setWarehouseCode(whTakeStock.getWarehouseCode());
                if (WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd.getResultType()) && EmptyUtil.isEmpty(whTakeStock.getInWhWarehouse())){
                    throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                            whTakeStock.getNotExicstInWhWarehouseMsg());
                }else if(WhTakeStockRcd.TYPE_LOSS.equals(whTakeStockRcd.getResultType()) && EmptyUtil.isEmpty(whTakeStock.getOutWhWarehouse())){
                    throw new WarehouseException(CommExceptionErrorCode.ILLEGAL_PARAM,
                            whTakeStock.getNotExicstOutWhWarehouseMsg());
                }
                whInvRcd.setWarehouseCode(WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd
                        .getResultType()) ? whTakeStock.getInWhWarehouse().getCode() : whTakeStock.getOutWhWarehouse().getCode());
                whInvRcd.setInOutType(WhTakeStockRcd.TYPE_PROFIT.equals(whTakeStockRcd
                        .getResultType()) ? WhInvRcd.TYPE_PROFIT_IN : WhInvRcd.TYPE_LOSS_OUT);
                whInvRcd.setSkuCode(whTakeStockRcd.getSkuCode());
                whInvRcd.setQuantity(whTakeStockRcd.getQuantity());
                whInvRcd.setMemo(whTakeStockRcd.getMemo());
                whInvRcd.setSubmitUserId(whTakeStock.getCreateUserId());
                whInvService.record(whInvRcd);
            }
        }
        // 此处不同步
        /*String warehouseCode = whTakeStock.getWarehouseCode();
        if(Constants.warehouseMap.containsKey(warehouseCode)) {
            syncTmallStock(getSyncSkuList(whTakeStockRcdList), Constants.warehouseMap.get(warehouseCode), whTakeStockId);
        }*/
    }

    public void syncTmallStock(List<CommSku> skuList, String sessionKey, Long whTakeStockId,Long operatorId) throws Exception {
    	if(EmptyUtil.isNotEmpty(skuList)) {
			for(CommSku pcsSkuVO : skuList) {
				//PcsSku pcsSku = pFacade.findTmallSkuByCode(pcsSkuVO.getCode());
				//pcsSku.setQuantity(pcsSkuVO.getQuantity());
				whCommandService.synCommodityStocks(pegasusUtilFacade.getSkuNumIid(pcsSkuVO.getCode(), sessionKey), pcsSkuVO.getCode(), 
						pcsSkuVO.getQuantity(), sessionKey, 2, whTakeStockId + "",operatorId);
			}
		}
    }
    /**
     * 根据仓库编码查找
     * 需要同步天猫后台的sku列表
     * @param whTakeStockRcdList
     * @return
     */
    private List<CommSku> getSyncSkuList(List<WhTakeStockRcd> whTakeStockRcdList) {
    	List<CommSku> skuList = new ArrayList<CommSku>();
    	if(EmptyUtil.isNotEmpty(whTakeStockRcdList)) {
    		for(WhTakeStockRcd sku : whTakeStockRcdList) {
    		  //备注没有预售才同步天猫后台库存
    		  if (EmptyUtil.isEmpty(sku.getMemo()) || sku.getMemo().indexOf("预售") == -1) {
              CommSku pcsSku = new CommSku();
              pcsSku.setCode(sku.getSkuCode());
              pcsSku.setQuantity(sku.getQuantity());
              skuList.add(pcsSku);
          }
    		}
    	}
    	return skuList;
    }
    /**
     * 根据仓库编码查找
     *
     * @param warehouseCode 仓库编码
     * @param fetchRcd 是否抓取记录
     * @return 列表
     */
    @Override
    public List<WhTakeStockRcdVO> findTakeStockByWarehouseCode(String warehouseCode, boolean fetchRcd) {
        WhTakeStockCond cond = new WhTakeStockCond();
        cond.setWarehouseCode(warehouseCode);
        cond.setFetchRcd(fetchRcd);
        return findTakeStockByCond(cond).getList();
    }

    /**
     * 根据条件查找
     *
     * @param cond 条件
     * @return 列表
     */
    @Override
    public PageInfo<WhTakeStockRcdVO> findTakeStockByCond(WhTakeStockCond cond) {
        int offset = cond.getCurrpage() * cond.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, cond.getPagenum());
        PageInfo<WhTakeStockRcdVO> ageInfo = new PageInfo(whTakeStockMapper.findTakeStockByCond(cond, pageRowBounds));
        ageInfo.setTotal(pageRowBounds.getTotal());
        return ageInfo;
    }

    @Override
    public Long findMaxBatchNumber() {
        String dateStr = DateUtil.format(new Date(), DateUtil.DEFAULTDATEFORMAT);
        Long maxBatchNumber = whTakeStockMapper.selectMaxBatchNumber(dateStr);
        if (maxBatchNumber == null) {
            return Long.valueOf(dateStr + "001");
        }
        return maxBatchNumber + 1;
    }

}